/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_FPICKER_SOURCE_AQUA_SALAQUACONSTANTS_H
#define INCLUDED_FPICKER_SOURCE_AQUA_SALAQUACONSTANTS_H

#define kAppFourCharCode 'LibO'
#define kControlPropertyTracking 'Trck'
#define kControlPropertyLastPartCode 'LsPc'
#define kControlPropertySubType 'SuTy'
#define kPopupControlPropertyTitleWidth 'PoTW'

#define kAquaSpaceBetweenControls (8)
#define kAquaSpaceBetweenPopupMenus (10)

#define kAquaSpaceInsideGroupH (16)
#define kAquaSpaceInsideGroupV (11)

#define kAquaSpaceBoxFrameViewDiffTop (7)
#define kAquaSpaceBoxFrameViewDiffLeft (7)
#define kAquaSpaceBoxFrameViewDiffBottom (9)
#define kAquaSpaceBoxFrameViewDiffRight (7)

#define kAquaSpaceButtonFrameBoundsDiff (6)
#define kAquaSpaceSwitchButtonFrameBoundsDiff (2)

#define kAquaSpacePopupMenuFrameBoundsDiffTop (2)
#define kAquaSpacePopupMenuFrameBoundsDiffBottom (4)
#define kAquaSpacePopupMenuFrameBoundsDiffV                                                        \
    (kAquaSpacePopupMenuFrameBoundsDiffTop + kAquaSpacePopupMenuFrameBoundsDiffBottom)
#define kAquaSpacePopupMenuFrameBoundsDiffLeft (3)

#define kAquaSpaceLabelFrameBoundsDiffH (3)
#define kAquaSpaceLabelPopupDiffV (6)
#define kAquaSpaceAfterPopupButtonsV (20)

#define kAquaPopupButtonDefaultHeight (26)

#endif // INCLUDED_FPICKER_SOURCE_AQUA_SALAQUACONSTANTS_H

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
