/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SC_INC_HELPIDS_H
#define INCLUDED_SC_INC_HELPIDS_H

#define HID_INSWIN_POS                                          "SC_HID_INSWIN_POS"
#define HID_INSWIN_CALC                                         "SC_HID_INSWIN_CALC"
#define HID_INSWIN_CANCEL                                       "SC_HID_INSWIN_CANCEL"
#define HID_INSWIN_OK                                           "SC_HID_INSWIN_OK"
#define HID_INSWIN_SUMME                                        "SC_HID_INSWIN_SUMME"
#define HID_INSWIN_FUNC                                         "SC_HID_INSWIN_FUNC"
#define HID_INSWIN_INPUT                                        "SC_HID_INSWIN_INPUT"

// Help IDs for document window ----------------------------------------------
#define HID_SC_WIN_GRIDWIN                                      "SC_HID_SC_WIN_GRIDWIN"
#define HID_SC_WIN_PREVIEW                                      "SC_HID_SC_WIN_PREVIEW"

#define HID_SC_HEADER_EDIT                                      "SC_HID_SC_HEADER_EDIT"
#define HID_SC_FOOTER_EDIT                                      "SC_HID_SC_FOOTER_EDIT"

#define HID_SC_SCENWIN_TOP                                      "SC_HID_SC_SCENWIN_TOP"
#define HID_SC_SCENWIN_BOTTOM                                   "SC_HID_SC_SCENWIN_BOTTOM"

#define HID_SC_INPUTWIN                                         "SC_HID_SC_INPUTWIN"

#define HID_SC_RENAME_NAME                                      "SC_HID_SC_RENAME_NAME"
#define HID_SC_APPEND_NAME                                      "SC_HID_SC_APPEND_NAME"

#define HID_SC_ADD_AUTOFMT                                      "SC_HID_SC_ADD_AUTOFMT"
#define HID_SC_AUTOFMT_NAME                                     "SC_HID_SC_AUTOFMT_NAME"

//  wrong group - HID_SC_DLG_START is full
#define HID_SC_REN_AFMT_NAME                                    "SC_HID_SC_REN_AFMT_NAME"

#define HID_CHG_PROTECT                                         "SC_HID_CHG_PROTECT"


#define HID_SC_REN_AFMT_DLG                                     "SC_HID_SC_REN_AFMT_DLG"

// Help IDs for Submenus (max.50) --------------------------------------------
#define HID_PASSWD_TABLE                                        "SC_HID_PASSWD_TABLE"
#define HID_PASSWD_DOC                                          "SC_HID_PASSWD_DOC"
#define HID_PASSWD_DOC_CONFIRM                                  "SC_HID_PASSWD_DOC_CONFIRM"


// Other help IDs (max.70) ---------------------------------------------------
#define HID_SELECTTABLES                                        "SC_HID_SELECTTABLES"


// Analysis Addin Functions (max.120) ----------------------------------------
#define HID_AAI_FUNC_WORKDAY                                    "SC_HID_AAI_FUNC_WORKDAY"
#define HID_AAI_FUNC_YEARFRAC                                   "SC_HID_AAI_FUNC_YEARFRAC"
#define HID_AAI_FUNC_EDATE                                      "SC_HID_AAI_FUNC_EDATE"
#define HID_AAI_FUNC_WEEKNUM                                    "SC_HID_AAI_FUNC_WEEKNUM"
#define HID_AAI_FUNC_EOMONTH                                    "SC_HID_AAI_FUNC_EOMONTH"
#define HID_AAI_FUNC_NETWORKDAYS                                "SC_HID_AAI_FUNC_NETWORKDAYS"
#define HID_AAI_FUNC_AMORDEGRC                                  "SC_HID_AAI_FUNC_AMORDEGRC"
#define HID_AAI_FUNC_AMORLINC                                   "SC_HID_AAI_FUNC_AMORLINC"
#define HID_AAI_FUNC_ACCRINT                                    "SC_HID_AAI_FUNC_ACCRINT"
#define HID_AAI_FUNC_ACCRINTM                                   "SC_HID_AAI_FUNC_ACCRINTM"
#define HID_AAI_FUNC_RECEIVED                                   "SC_HID_AAI_FUNC_RECEIVED"
#define HID_AAI_FUNC_DISC                                       "SC_HID_AAI_FUNC_DISC"
#define HID_AAI_FUNC_DURATION                                   "SC_HID_AAI_FUNC_DURATION"
#define HID_AAI_FUNC_EFFECT                                     "SC_HID_AAI_FUNC_EFFECT"
#define HID_AAI_FUNC_CUMPRINC                                   "SC_HID_AAI_FUNC_CUMPRINC"
#define HID_AAI_FUNC_CUMIPMT                                    "SC_HID_AAI_FUNC_CUMIPMT"
#define HID_AAI_FUNC_PRICE                                      "SC_HID_AAI_FUNC_PRICE"
#define HID_AAI_FUNC_PRICEDISC                                  "SC_HID_AAI_FUNC_PRICEDISC"
#define HID_AAI_FUNC_PRICEMAT                                   "SC_HID_AAI_FUNC_PRICEMAT"
#define HID_AAI_FUNC_MDURATION                                  "SC_HID_AAI_FUNC_MDURATION"
#define HID_AAI_FUNC_NOMINAL                                    "SC_HID_AAI_FUNC_NOMINAL"
#define HID_AAI_FUNC_DOLLARFR                                   "SC_HID_AAI_FUNC_DOLLARFR"
#define HID_AAI_FUNC_DOLLARDE                                   "SC_HID_AAI_FUNC_DOLLARDE"
#define HID_AAI_FUNC_YIELD                                      "SC_HID_AAI_FUNC_YIELD"
#define HID_AAI_FUNC_YIELDDISC                                  "SC_HID_AAI_FUNC_YIELDDISC"
#define HID_AAI_FUNC_YIELDMAT                                   "SC_HID_AAI_FUNC_YIELDMAT"
#define HID_AAI_FUNC_TBILLEQ                                    "SC_HID_AAI_FUNC_TBILLEQ"
#define HID_AAI_FUNC_TBILLPRICE                                 "SC_HID_AAI_FUNC_TBILLPRICE"
#define HID_AAI_FUNC_TBILLYIELD                                 "SC_HID_AAI_FUNC_TBILLYIELD"
#define HID_AAI_FUNC_ODDFPRICE                                  "SC_HID_AAI_FUNC_ODDFPRICE"
#define HID_AAI_FUNC_ODDFYIELD                                  "SC_HID_AAI_FUNC_ODDFYIELD"
#define HID_AAI_FUNC_ODDLPRICE                                  "SC_HID_AAI_FUNC_ODDLPRICE"
#define HID_AAI_FUNC_ODDLYIELD                                  "SC_HID_AAI_FUNC_ODDLYIELD"
#define HID_AAI_FUNC_XIRR                                       "SC_HID_AAI_FUNC_XIRR"
#define HID_AAI_FUNC_XNPV                                       "SC_HID_AAI_FUNC_XNPV"
#define HID_AAI_FUNC_INTRATE                                    "SC_HID_AAI_FUNC_INTRATE"
#define HID_AAI_FUNC_COUPNCD                                    "SC_HID_AAI_FUNC_COUPNCD"
#define HID_AAI_FUNC_COUPDAYS                                   "SC_HID_AAI_FUNC_COUPDAYS"
#define HID_AAI_FUNC_COUPDAYSNC                                 "SC_HID_AAI_FUNC_COUPDAYSNC"
#define HID_AAI_FUNC_COUPDAYBS                                  "SC_HID_AAI_FUNC_COUPDAYBS"
#define HID_AAI_FUNC_COUPPCD                                    "SC_HID_AAI_FUNC_COUPPCD"
#define HID_AAI_FUNC_COUPNUM                                    "SC_HID_AAI_FUNC_COUPNUM"
#define HID_AAI_FUNC_FVSCHEDULE                                 "SC_HID_AAI_FUNC_FVSCHEDULE"
#define HID_AAI_FUNC_ISEVEN                                     "SC_HID_AAI_FUNC_ISEVEN"
#define HID_AAI_FUNC_ISODD                                      "SC_HID_AAI_FUNC_ISODD"
#define HID_AAI_FUNC_GCD                                        "SC_HID_AAI_FUNC_GCD"
#define HID_AAI_FUNC_LCM                                        "SC_HID_AAI_FUNC_LCM"
#define HID_AAI_FUNC_MULTINOMIAL                                "SC_HID_AAI_FUNC_MULTINOMIAL"
#define HID_AAI_FUNC_SERIESSUM                                  "SC_HID_AAI_FUNC_SERIESSUM"
#define HID_AAI_FUNC_QUOTIENT                                   "SC_HID_AAI_FUNC_QUOTIENT"
#define HID_AAI_FUNC_MROUND                                     "SC_HID_AAI_FUNC_MROUND"
#define HID_AAI_FUNC_SQRTPI                                     "SC_HID_AAI_FUNC_SQRTPI"
#define HID_AAI_FUNC_RANDBETWEEN                                "SC_HID_AAI_FUNC_RANDBETWEEN"
#define HID_AAI_FUNC_BESSELI                                    "SC_HID_AAI_FUNC_BESSELI"
#define HID_AAI_FUNC_BESSELJ                                    "SC_HID_AAI_FUNC_BESSELJ"
#define HID_AAI_FUNC_BESSELK                                    "SC_HID_AAI_FUNC_BESSELK"
#define HID_AAI_FUNC_BESSELY                                    "SC_HID_AAI_FUNC_BESSELY"
#define HID_AAI_FUNC_BIN2DEC                                    "SC_HID_AAI_FUNC_BIN2DEC"
#define HID_AAI_FUNC_BIN2HEX                                    "SC_HID_AAI_FUNC_BIN2HEX"
#define HID_AAI_FUNC_BIN2OCT                                    "SC_HID_AAI_FUNC_BIN2OCT"
#define HID_AAI_FUNC_DELTA                                      "SC_HID_AAI_FUNC_DELTA"
#define HID_AAI_FUNC_DEC2BIN                                    "SC_HID_AAI_FUNC_DEC2BIN"
#define HID_AAI_FUNC_DEC2HEX                                    "SC_HID_AAI_FUNC_DEC2HEX"
#define HID_AAI_FUNC_DEC2OCT                                    "SC_HID_AAI_FUNC_DEC2OCT"
#define HID_AAI_FUNC_ERF                                        "SC_HID_AAI_FUNC_ERF"
#define HID_AAI_FUNC_ERFC                                       "SC_HID_AAI_FUNC_ERFC"
#define HID_AAI_FUNC_GESTEP                                     "SC_HID_AAI_FUNC_GESTEP"
#define HID_AAI_FUNC_HEX2BIN                                    "SC_HID_AAI_FUNC_HEX2BIN"
#define HID_AAI_FUNC_HEX2DEC                                    "SC_HID_AAI_FUNC_HEX2DEC"
#define HID_AAI_FUNC_HEX2OCT                                    "SC_HID_AAI_FUNC_HEX2OCT"
#define HID_AAI_FUNC_IMABS                                      "SC_HID_AAI_FUNC_IMABS"
#define HID_AAI_FUNC_IMAGINARY                                  "SC_HID_AAI_FUNC_IMAGINARY"
#define HID_AAI_FUNC_IMPOWER                                    "SC_HID_AAI_FUNC_IMPOWER"
#define HID_AAI_FUNC_IMARGUMENT                                 "SC_HID_AAI_FUNC_IMARGUMENT"
#define HID_AAI_FUNC_IMCOS                                      "SC_HID_AAI_FUNC_IMCOS"
#define HID_AAI_FUNC_IMDIV                                      "SC_HID_AAI_FUNC_IMDIV"
#define HID_AAI_FUNC_IMEXP                                      "SC_HID_AAI_FUNC_IMEXP"
#define HID_AAI_FUNC_IMCONJUGATE                                "SC_HID_AAI_FUNC_IMCONJUGATE"
#define HID_AAI_FUNC_IMLN                                       "SC_HID_AAI_FUNC_IMLN"
#define HID_AAI_FUNC_IMLOG10                                    "SC_HID_AAI_FUNC_IMLOG10"
#define HID_AAI_FUNC_IMLOG2                                     "SC_HID_AAI_FUNC_IMLOG2"
#define HID_AAI_FUNC_IMPRODUCT                                  "SC_HID_AAI_FUNC_IMPRODUCT"
#define HID_AAI_FUNC_IMREAL                                     "SC_HID_AAI_FUNC_IMREAL"
#define HID_AAI_FUNC_IMSIN                                      "SC_HID_AAI_FUNC_IMSIN"
#define HID_AAI_FUNC_IMSUB                                      "SC_HID_AAI_FUNC_IMSUB"
#define HID_AAI_FUNC_IMSUM                                      "SC_HID_AAI_FUNC_IMSUM"
#define HID_AAI_FUNC_IMSQRT                                     "SC_HID_AAI_FUNC_IMSQRT"
#define HID_AAI_FUNC_COMPLEX                                    "SC_HID_AAI_FUNC_COMPLEX"
#define HID_AAI_FUNC_OCT2BIN                                    "SC_HID_AAI_FUNC_OCT2BIN"
#define HID_AAI_FUNC_OCT2DEZ                                    "SC_HID_AAI_FUNC_OCT2DEZ"
#define HID_AAI_FUNC_OCT2HEX                                    "SC_HID_AAI_FUNC_OCT2HEX"
#define HID_AAI_FUNC_CONVERT                                    "SC_HID_AAI_FUNC_CONVERT"
#define HID_AAI_FUNC_FACTDOUBLE                                 "SC_HID_AAI_FUNC_FACTDOUBLE"
#define HID_AAI_FUNC_IMTAN                                      "SC_HID_AAI_FUNC_IMTAN"
#define HID_AAI_FUNC_IMSEC                                      "SC_HID_AAI_FUNC_IMSEC"
#define HID_AAI_FUNC_IMCSC                                      "SC_HID_AAI_FUNC_IMCSC"
#define HID_AAI_FUNC_IMCOT                                      "SC_HID_AAI_FUNC_IMCOT"
#define HID_AAI_FUNC_IMSINH                                     "SC_HID_AAI_FUNC_IMSINH"
#define HID_AAI_FUNC_IMCOSH                                     "SC_HID_AAI_FUNC_IMCOSH"
#define HID_AAI_FUNC_IMSECH                                     "SC_HID_AAI_FUNC_IMSECH"
#define HID_AAI_FUNC_IMCSCH                                     "SC_HID_AAI_FUNC_IMCSCH"

// DateFunc Addin Functions (max.20) -----------------------------------------
#define HID_DAI_FUNC_DAYSINMONTH                                "SC_HID_DAI_FUNC_DAYSINMONTH"
#define HID_DAI_FUNC_DAYSINYEAR                                 "SC_HID_DAI_FUNC_DAYSINYEAR"
#define HID_DAI_FUNC_WEEKSINYEAR                                "SC_HID_DAI_FUNC_WEEKSINYEAR"
#define HID_DAI_FUNC_DIFFMONTHS                                 "SC_HID_DAI_FUNC_DIFFMONTHS"
#define HID_DAI_FUNC_DIFFWEEKS                                  "SC_HID_DAI_FUNC_DIFFWEEKS"
#define HID_DAI_FUNC_DIFFYEARS                                  "SC_HID_DAI_FUNC_DIFFYEARS"
#define HID_DAI_FUNC_ROT13                                      "SC_HID_DAI_FUNC_ROT13"

// End help IDs ------------------------------------------------------------

#define HID_FUNC_DBANZAHL                                       "SC_HID_FUNC_DBANZAHL"
#define HID_FUNC_DBANZAHL2                                      "SC_HID_FUNC_DBANZAHL2"
#define HID_FUNC_DBMITTELWERT                                   "SC_HID_FUNC_DBMITTELWERT"
#define HID_FUNC_DBAUSZUG                                       "SC_HID_FUNC_DBAUSZUG"
#define HID_FUNC_DBMAX                                          "SC_HID_FUNC_DBMAX"
#define HID_FUNC_DBMIN                                          "SC_HID_FUNC_DBMIN"
#define HID_FUNC_DBPRODUKT                                      "SC_HID_FUNC_DBPRODUKT"
#define HID_FUNC_DBSTDABW                                       "SC_HID_FUNC_DBSTDABW"
#define HID_FUNC_DBSTDABWN                                      "SC_HID_FUNC_DBSTDABWN"
#define HID_FUNC_DBSUMME                                        "SC_HID_FUNC_DBSUMME"
#define HID_FUNC_DBVARIANZ                                      "SC_HID_FUNC_DBVARIANZ"
#define HID_FUNC_DBVARIANZEN                                    "SC_HID_FUNC_DBVARIANZEN"

#define HID_FUNC_DATUM                                          "SC_HID_FUNC_DATUM"
#define HID_FUNC_DATWERT                                        "SC_HID_FUNC_DATWERT"
#define HID_FUNC_TAG                                            "SC_HID_FUNC_TAG"
#define HID_FUNC_TAGE360                                        "SC_HID_FUNC_TAGE360"
#define HID_FUNC_STUNDE                                         "SC_HID_FUNC_STUNDE"
#define HID_FUNC_MINUTE                                         "SC_HID_FUNC_MINUTE"
#define HID_FUNC_MONAT                                          "SC_HID_FUNC_MONAT"
#define HID_FUNC_JETZT                                          "SC_HID_FUNC_JETZT"
#define HID_FUNC_SEKUNDE                                        "SC_HID_FUNC_SEKUNDE"
#define HID_FUNC_ZEIT                                           "SC_HID_FUNC_ZEIT"
#define HID_FUNC_ZEITWERT                                       "SC_HID_FUNC_ZEITWERT"
#define HID_FUNC_HEUTE                                          "SC_HID_FUNC_HEUTE"
#define HID_FUNC_WOCHENTAG                                      "SC_HID_FUNC_WOCHENTAG"
#define HID_FUNC_JAHR                                           "SC_HID_FUNC_JAHR"
#define HID_FUNC_TAGE                                           "SC_HID_FUNC_TAGE"
#define HID_FUNC_DATEDIF                                        "SC_HID_FUNC_DATEDIF"
#define HID_FUNC_KALENDERWOCHE                                  "SC_HID_FUNC_KALENDERWOCHE"
#define HID_FUNC_OSTERSONNTAG                                   "SC_HID_FUNC_OSTERSONNTAG"
#define HID_FUNC_ISOWEEKNUM                                     "SC_HID_FUNC_ISOWEEKNUM"

#define HID_FUNC_BW                                             "SC_HID_FUNC_BW"
#define HID_FUNC_ZW                                             "SC_HID_FUNC_ZW"
#define HID_FUNC_ZZR                                            "SC_HID_FUNC_ZZR"
#define HID_FUNC_RMZ                                            "SC_HID_FUNC_RMZ"
#define HID_FUNC_ZINS                                           "SC_HID_FUNC_ZINS"
#define HID_FUNC_ZINSZ                                          "SC_HID_FUNC_ZINSZ"
#define HID_FUNC_KAPZ                                           "SC_HID_FUNC_KAPZ"
#define HID_FUNC_KUMKAPITAL                                     "SC_HID_FUNC_KUMKAPITAL"
#define HID_FUNC_KUMZINSZ                                       "SC_HID_FUNC_KUMZINSZ"
#define HID_FUNC_DIA                                            "SC_HID_FUNC_DIA"
#define HID_FUNC_LIA                                            "SC_HID_FUNC_LIA"
#define HID_FUNC_GDA                                            "SC_HID_FUNC_GDA"
#define HID_FUNC_GDA2                                           "SC_HID_FUNC_GDA2"
#define HID_FUNC_VDB                                            "SC_HID_FUNC_VDB"
#define HID_FUNC_EFFEKTIV                                       "SC_HID_FUNC_EFFEKTIV"
#define HID_FUNC_NOMINAL                                        "SC_HID_FUNC_NOMINAL"
#define HID_FUNC_NBW                                            "SC_HID_FUNC_NBW"
#define HID_FUNC_IKV                                            "SC_HID_FUNC_IKV"
#define HID_FUNC_LAUFZEIT                                       "SC_HID_FUNC_LAUFZEIT"
#define HID_FUNC_ZGZ                                            "SC_HID_FUNC_ZGZ"
#define HID_FUNC_QIKV                                           "SC_HID_FUNC_QIKV"
#define HID_FUNC_ISPMT                                          "SC_HID_FUNC_ISPMT"

#define HID_FUNC_ISTBEZUG                                       "SC_HID_FUNC_ISTBEZUG"
#define HID_FUNC_ISTFEHL                                        "SC_HID_FUNC_ISTFEHL"
#define HID_FUNC_ISTFEHLER                                      "SC_HID_FUNC_ISTFEHLER"
#define HID_FUNC_ISTLEER                                        "SC_HID_FUNC_ISTLEER"
#define HID_FUNC_ISTLOG                                         "SC_HID_FUNC_ISTLOG"
#define HID_FUNC_ISTNV                                          "SC_HID_FUNC_ISTNV"
#define HID_FUNC_ISTKTEXT                                       "SC_HID_FUNC_ISTKTEXT"
#define HID_FUNC_ISTTEXT                                        "SC_HID_FUNC_ISTTEXT"
#define HID_FUNC_ISTZAHL                                        "SC_HID_FUNC_ISTZAHL"
#define HID_FUNC_ISTFORMEL                                      "SC_HID_FUNC_ISTFORMEL"
#define HID_FUNC_N                                              "SC_HID_FUNC_N"
#define HID_FUNC_NV                                             "SC_HID_FUNC_NV"
#define HID_FUNC_TYP                                            "SC_HID_FUNC_TYP"
#define HID_FUNC_AKTUELL                                        "SC_HID_FUNC_AKTUELL"
#define HID_FUNC_FORMEL                                         "SC_HID_FUNC_FORMEL"
#define HID_FUNC_ZELLE                                          "SC_HID_FUNC_ZELLE"
#define HID_FUNC_INFO                                           "SC_HID_FUNC_INFO"

#define HID_FUNC_FALSCH                                         "SC_HID_FUNC_FALSCH"
#define HID_FUNC_NICHT                                          "SC_HID_FUNC_NICHT"
#define HID_FUNC_WAHR                                           "SC_HID_FUNC_WAHR"
#define HID_FUNC_WENN                                           "SC_HID_FUNC_WENN"
#define HID_FUNC_IFERROR                                        "SC_HID_FUNC_IFERROR"
#define HID_FUNC_IFNA                                           "SC_HID_FUNC_IFNA"
#define HID_FUNC_ODER                                           "SC_HID_FUNC_ODER"
#define HID_FUNC_UND                                            "SC_HID_FUNC_UND"
#define HID_FUNC_XOR                                            "SC_HID_FUNC_XOR"

#define HID_FUNC_ABS                                            "SC_HID_FUNC_ABS"
#define HID_FUNC_POTENZ                                         "SC_HID_FUNC_POTENZ"
#define HID_FUNC_ANZAHLLEEREZELLEN                              "SC_HID_FUNC_ANZAHLLEEREZELLEN"
#define HID_FUNC_PI                                             "SC_HID_FUNC_PI"
#define HID_FUNC_SUMME                                          "SC_HID_FUNC_SUMME"
#define HID_FUNC_QUADRATESUMME                                  "SC_HID_FUNC_QUADRATESUMME"
#define HID_FUNC_PRODUKT                                        "SC_HID_FUNC_PRODUKT"
#define HID_FUNC_SUMMEWENN                                      "SC_HID_FUNC_SUMMEWENN"
#define HID_FUNC_AVERAGEIF                                      "SC_HID_FUNC_AVERAGEIF"
#define HID_FUNC_SUMIFS                                         "SC_HID_FUNC_SUMIFS"
#define HID_FUNC_AVERAGEIFS                                     "SC_HID_FUNC_AVERAGEIFS"
#define HID_FUNC_COUNTIFS                                       "SC_HID_FUNC_COUNTIFS"
#define HID_FUNC_ZAEHLENWENN                                    "SC_HID_FUNC_ZAEHLENWENN"
#define HID_FUNC_WURZEL                                         "SC_HID_FUNC_WURZEL"
#define HID_FUNC_ZUFALLSZAHL                                    "SC_HID_FUNC_ZUFALLSZAHL"
#define HID_FUNC_ISTGERADE                                      "SC_HID_FUNC_ISTGERADE"
#define HID_FUNC_ISTUNGERADE                                    "SC_HID_FUNC_ISTUNGERADE"
#define HID_FUNC_KOMBINATIONEN                                  "SC_HID_FUNC_KOMBINATIONEN"
#define HID_FUNC_KOMBINATIONEN2                                 "SC_HID_FUNC_KOMBINATIONEN2"
#define HID_FUNC_ARCCOS                                         "SC_HID_FUNC_ARCCOS"
#define HID_FUNC_ARCSIN                                         "SC_HID_FUNC_ARCSIN"
#define HID_FUNC_ARCOSHYP                                       "SC_HID_FUNC_ARCOSHYP"
#define HID_FUNC_ARSINHYP                                       "SC_HID_FUNC_ARSINHYP"
#define HID_FUNC_ARCCOT                                         "SC_HID_FUNC_ARCCOT"
#define HID_FUNC_ARCTAN                                         "SC_HID_FUNC_ARCTAN"
#define HID_FUNC_ARCOTHYP                                       "SC_HID_FUNC_ARCOTHYP"
#define HID_FUNC_ARTANHYP                                       "SC_HID_FUNC_ARTANHYP"
#define HID_FUNC_COS                                            "SC_HID_FUNC_COS"
#define HID_FUNC_SIN                                            "SC_HID_FUNC_SIN"
#define HID_FUNC_COT                                            "SC_HID_FUNC_COT"
#define HID_FUNC_TAN                                            "SC_HID_FUNC_TAN"
#define HID_FUNC_COSHYP                                         "SC_HID_FUNC_COSHYP"
#define HID_FUNC_SINHYP                                         "SC_HID_FUNC_SINHYP"
#define HID_FUNC_COTHYP                                         "SC_HID_FUNC_COTHYP"
#define HID_FUNC_TANHYP                                         "SC_HID_FUNC_TANHYP"
#define HID_FUNC_ARCTAN2                                        "SC_HID_FUNC_ARCTAN2"
#define HID_FUNC_COSECANT                                       "SC_HID_FUNC_COSECANT"
#define HID_FUNC_SECANT                                         "SC_HID_FUNC_SECANT"
#define HID_FUNC_SECANTHYP                                      "SC_HID_FUNC_SECANTHYP"
#define HID_FUNC_COSECANTHYP                                    "SC_HID_FUNC_COSECANTHYP"
#define HID_FUNC_DEG                                            "SC_HID_FUNC_DEG"
#define HID_FUNC_RAD                                            "SC_HID_FUNC_RAD"
#define HID_FUNC_EXP                                            "SC_HID_FUNC_EXP"
#define HID_FUNC_LOG                                            "SC_HID_FUNC_LOG"
#define HID_FUNC_LN                                             "SC_HID_FUNC_LN"
#define HID_FUNC_LOG10                                          "SC_HID_FUNC_LOG10"
#define HID_FUNC_FAKULTAET                                      "SC_HID_FUNC_FAKULTAET"
#define HID_FUNC_REST                                           "SC_HID_FUNC_REST"
#define HID_FUNC_VORZEICHEN                                     "SC_HID_FUNC_VORZEICHEN"
#define HID_FUNC_TEILERGEBNIS                                   "SC_HID_FUNC_TEILERGEBNIS"
#define HID_FUNC_GANZZAHL                                       "SC_HID_FUNC_GANZZAHL"
#define HID_FUNC_KUERZEN                                        "SC_HID_FUNC_KUERZEN"
#define HID_FUNC_RUNDEN                                         "SC_HID_FUNC_RUNDEN"
#define HID_FUNC_AUFRUNDEN                                      "SC_HID_FUNC_AUFRUNDEN"
#define HID_FUNC_ABRUNDEN                                       "SC_HID_FUNC_ABRUNDEN"
#define HID_FUNC_GERADE                                         "SC_HID_FUNC_GERADE"
#define HID_FUNC_UNGERADE                                       "SC_HID_FUNC_UNGERADE"
#define HID_FUNC_OBERGRENZE                                     "SC_HID_FUNC_OBERGRENZE"
#define HID_FUNC_UNTERGRENZE                                    "SC_HID_FUNC_UNTERGRENZE"
#define HID_FUNC_GGT                                            "SC_HID_FUNC_GGT"
#define HID_FUNC_KGV                                            "SC_HID_FUNC_KGV"
#define HID_FUNC_UMRECHNEN                                      "SC_HID_FUNC_UMRECHNEN"
#define HID_FUNC_EUROCONVERT                                    "SC_HID_FUNC_EUROCONVERT"

#define HID_FUNC_MTRANS                                         "SC_HID_FUNC_MTRANS"
#define HID_FUNC_MMULT                                          "SC_HID_FUNC_MMULT"
#define HID_FUNC_MDET                                           "SC_HID_FUNC_MDET"
#define HID_FUNC_MINV                                           "SC_HID_FUNC_MINV"
#define HID_FUNC_EINHEITSMATRIX                                 "SC_HID_FUNC_EINHEITSMATRIX"
#define HID_FUNC_SUMMENPRODUKT                                  "SC_HID_FUNC_SUMMENPRODUKT"
#define HID_FUNC_SUMMEX2MY2                                     "SC_HID_FUNC_SUMMEX2MY2"
#define HID_FUNC_SUMMEX2PY2                                     "SC_HID_FUNC_SUMMEX2PY2"
#define HID_FUNC_SUMMEXMY2                                      "SC_HID_FUNC_SUMMEXMY2"
#define HID_FUNC_HAEUFIGKEIT                                    "SC_HID_FUNC_HAEUFIGKEIT"
#define HID_FUNC_RGP                                            "SC_HID_FUNC_RGP"
#define HID_FUNC_RKP                                            "SC_HID_FUNC_RKP"
#define HID_FUNC_TREND                                          "SC_HID_FUNC_TREND"
#define HID_FUNC_VARIATION                                      "SC_HID_FUNC_VARIATION"

#define HID_FUNC_ANZAHL                                         "SC_HID_FUNC_ANZAHL"
#define HID_FUNC_ANZAHL2                                        "SC_HID_FUNC_ANZAHL2"
#define HID_FUNC_MAX                                            "SC_HID_FUNC_MAX"
#define HID_FUNC_MIN                                            "SC_HID_FUNC_MIN"
#define HID_FUNC_VARIANZ                                        "SC_HID_FUNC_VARIANZ"
#define HID_FUNC_VARIANZEN                                      "SC_HID_FUNC_VARIANZEN"
#define HID_FUNC_STABW                                          "SC_HID_FUNC_STABW"
#define HID_FUNC_STABWN                                         "SC_HID_FUNC_STABWN"
#define HID_FUNC_MITTELWERT                                     "SC_HID_FUNC_MITTELWERT"
#define HID_FUNC_SUMQUADABW                                     "SC_HID_FUNC_SUMQUADABW"
#define HID_FUNC_MITTELABW                                      "SC_HID_FUNC_MITTELABW"
#define HID_FUNC_SCHIEFE                                        "SC_HID_FUNC_SCHIEFE"
#define HID_FUNC_SKEWP                                          "SC_HID_FUNC_SKEWP"
#define HID_FUNC_KURT                                           "SC_HID_FUNC_KURT"
#define HID_FUNC_GEOMITTEL                                      "SC_HID_FUNC_GEOMITTEL"
#define HID_FUNC_HARMITTEL                                      "SC_HID_FUNC_HARMITTEL"
#define HID_FUNC_MODALWERT                                      "SC_HID_FUNC_MODALWERT"
#define HID_FUNC_MEDIAN                                         "SC_HID_FUNC_MEDIAN"
#define HID_FUNC_QUANTIL                                        "SC_HID_FUNC_QUANTIL"
#define HID_FUNC_QUARTILE                                       "SC_HID_FUNC_QUARTILE"
#define HID_FUNC_KGROESSTE                                      "SC_HID_FUNC_KGROESSTE"
#define HID_FUNC_KKLEINSTE                                      "SC_HID_FUNC_KKLEINSTE"
#define HID_FUNC_QUANTILSRANG                                   "SC_HID_FUNC_QUANTILSRANG"
#define HID_FUNC_RANG                                           "SC_HID_FUNC_RANG"
#define HID_FUNC_GESTUTZTMITTEL                                 "SC_HID_FUNC_GESTUTZTMITTEL"
#define HID_FUNC_WAHRSCHBEREICH                                 "SC_HID_FUNC_WAHRSCHBEREICH"
#define HID_FUNC_B                                              "SC_HID_FUNC_B"
#define HID_FUNC_PHI                                            "SC_HID_FUNC_PHI"
#define HID_FUNC_GAUSS                                          "SC_HID_FUNC_GAUSS"
#define HID_FUNC_FISHER                                         "SC_HID_FUNC_FISHER"
#define HID_FUNC_FISHERINV                                      "SC_HID_FUNC_FISHERINV"
#define HID_FUNC_BINOMVERT                                      "SC_HID_FUNC_BINOMVERT"
#define HID_FUNC_NEGBINOMVERT                                   "SC_HID_FUNC_NEGBINOMVERT"
#define HID_FUNC_KRITBINOM                                      "SC_HID_FUNC_KRITBINOM"
#define HID_FUNC_POISSON                                        "SC_HID_FUNC_POISSON"
#define HID_FUNC_NORMVERT                                       "SC_HID_FUNC_NORMVERT"
#define HID_FUNC_NORMINV                                        "SC_HID_FUNC_NORMINV"
#define HID_FUNC_STANDNORMVERT                                  "SC_HID_FUNC_STANDNORMVERT"
#define HID_FUNC_STANDNORMINV                                   "SC_HID_FUNC_STANDNORMINV"
#define HID_FUNC_LOGNORMVERT                                    "SC_HID_FUNC_LOGNORMVERT"
#define HID_FUNC_LOGINV                                         "SC_HID_FUNC_LOGINV"
#define HID_FUNC_EXPONVERT                                      "SC_HID_FUNC_EXPONVERT"
#define HID_FUNC_GAMMAVERT                                      "SC_HID_FUNC_GAMMAVERT"
#define HID_FUNC_GAMMAINV                                       "SC_HID_FUNC_GAMMAINV"
#define HID_FUNC_GAMMALN                                        "SC_HID_FUNC_GAMMALN"
#define HID_FUNC_BETAVERT                                       "SC_HID_FUNC_BETAVERT"
#define HID_FUNC_BETAINV                                        "SC_HID_FUNC_BETAINV"
#define HID_FUNC_WEIBULL                                        "SC_HID_FUNC_WEIBULL"
#define HID_FUNC_HYPGEOMVERT                                    "SC_HID_FUNC_HYPGEOMVERT"
#define HID_FUNC_TVERT                                          "SC_HID_FUNC_TVERT"
#define HID_FUNC_TINV                                           "SC_HID_FUNC_TINV"
#define HID_FUNC_FVERT                                          "SC_HID_FUNC_FVERT"
#define HID_FUNC_FINV                                           "SC_HID_FUNC_FINV"
#define HID_FUNC_CHIVERT                                        "SC_HID_FUNC_CHIVERT"
#define HID_FUNC_CHIINV                                         "SC_HID_FUNC_CHIINV"
#define HID_FUNC_STANDARDISIERUNG                               "SC_HID_FUNC_STANDARDISIERUNG"
#define HID_FUNC_VARIATIONEN                                    "SC_HID_FUNC_VARIATIONEN"
#define HID_FUNC_VARIATIONEN2                                   "SC_HID_FUNC_VARIATIONEN2"
#define HID_FUNC_KONFIDENZ                                      "SC_HID_FUNC_KONFIDENZ"
#define HID_FUNC_GTEST                                          "SC_HID_FUNC_GTEST"
#define HID_FUNC_CHITEST                                        "SC_HID_FUNC_CHITEST"
#define HID_FUNC_FTEST                                          "SC_HID_FUNC_FTEST"
#define HID_FUNC_TTEST                                          "SC_HID_FUNC_TTEST"
#define HID_FUNC_BESTIMMTHEITSMASS                              "SC_HID_FUNC_BESTIMMTHEITSMASS"
#define HID_FUNC_ACHSENABSCHNITT                                "SC_HID_FUNC_ACHSENABSCHNITT"
#define HID_FUNC_STEIGUNG                                       "SC_HID_FUNC_STEIGUNG"
#define HID_FUNC_STFEHLERYX                                     "SC_HID_FUNC_STFEHLERYX"
#define HID_FUNC_PEARSON                                        "SC_HID_FUNC_PEARSON"
#define HID_FUNC_KORREL                                         "SC_HID_FUNC_KORREL"
#define HID_FUNC_KOVAR                                          "SC_HID_FUNC_KOVAR"
#define HID_FUNC_SCHAETZER                                      "SC_HID_FUNC_SCHAETZER"
#define HID_FUNC_MINA                                           "SC_HID_FUNC_MINA"
#define HID_FUNC_MAXA                                           "SC_HID_FUNC_MAXA"
#define HID_FUNC_MITTELWERTA                                    "SC_HID_FUNC_MITTELWERTA"
#define HID_FUNC_STABWA                                         "SC_HID_FUNC_STABWA"
#define HID_FUNC_STABWNA                                        "SC_HID_FUNC_STABWNA"
#define HID_FUNC_VARIANZA                                       "SC_HID_FUNC_VARIANZA"
#define HID_FUNC_VARIANZENA                                     "SC_HID_FUNC_VARIANZENA"
#define HID_FUNC_CHISQDIST                                      "SC_HID_FUNC_CHISQDIST"
#define HID_FUNC_CHISQINV                                       "SC_HID_FUNC_CHISQINV"
#define HID_FUNC_GAMMA                                          "SC_HID_FUNC_GAMMA"

#define HID_FUNC_ADRESSE                                        "SC_HID_FUNC_ADRESSE"
#define HID_FUNC_BEREICHE                                       "SC_HID_FUNC_BEREICHE"
#define HID_FUNC_WAHL                                           "SC_HID_FUNC_WAHL"
#define HID_FUNC_SPALTE                                         "SC_HID_FUNC_SPALTE"
#define HID_FUNC_ZEILE                                          "SC_HID_FUNC_ZEILE"
#define HID_FUNC_SPALTEN                                        "SC_HID_FUNC_SPALTEN"
#define HID_FUNC_ZEILEN                                         "SC_HID_FUNC_ZEILEN"
#define HID_FUNC_WVERWEIS                                       "SC_HID_FUNC_WVERWEIS"
#define HID_FUNC_SVERWEIS                                       "SC_HID_FUNC_SVERWEIS"
#define HID_FUNC_INDEX                                          "SC_HID_FUNC_INDEX"
#define HID_FUNC_INDIREKT                                       "SC_HID_FUNC_INDIREKT"
#define HID_FUNC_VERWEIS                                        "SC_HID_FUNC_VERWEIS"
#define HID_FUNC_VERGLEICH                                      "SC_HID_FUNC_VERGLEICH"
#define HID_FUNC_VERSCHIEBUNG                                   "SC_HID_FUNC_VERSCHIEBUNG"
#define HID_FUNC_FEHLERTYP                                      "SC_HID_FUNC_FEHLERTYP"
#define HID_FUNC_VORLAGE                                        "SC_HID_FUNC_VORLAGE"
#define HID_FUNC_DDE                                            "SC_HID_FUNC_DDE"
#define HID_FUNC_TABELLE                                        "SC_HID_FUNC_TABELLE"
#define HID_FUNC_TABELLEN                                       "SC_HID_FUNC_TABELLEN"
#define HID_FUNC_HYPERLINK                                      "SC_HID_FUNC_HYPERLINK"
#define HID_FUNC_GETPIVOTDATA                                   "SC_HID_FUNC_GETPIVOTDATA"

#define HID_FUNC_CODE                                           "SC_HID_FUNC_CODE"
#define HID_FUNC_DM                                             "SC_HID_FUNC_DM"
#define HID_FUNC_ZEICHEN                                        "SC_HID_FUNC_ZEICHEN"
#define HID_FUNC_SAEUBERN                                       "SC_HID_FUNC_SAEUBERN"
#define HID_FUNC_VERKETTEN                                      "SC_HID_FUNC_VERKETTEN"
#define HID_FUNC_IDENTISCH                                      "SC_HID_FUNC_IDENTISCH"
#define HID_FUNC_FINDEN                                         "SC_HID_FUNC_FINDEN"
#define HID_FUNC_SUCHEN                                         "SC_HID_FUNC_SUCHEN"
#define HID_FUNC_GLAETTEN                                       "SC_HID_FUNC_GLAETTEN"
#define HID_FUNC_GROSS2                                         "SC_HID_FUNC_GROSS2"
#define HID_FUNC_GROSS                                          "SC_HID_FUNC_GROSS"
#define HID_FUNC_KLEIN                                          "SC_HID_FUNC_KLEIN"
#define HID_FUNC_WERT                                           "SC_HID_FUNC_WERT"
#define HID_FUNC_TEXT                                           "SC_HID_FUNC_TEXT"
#define HID_FUNC_T                                              "SC_HID_FUNC_T"
#define HID_FUNC_ERSETZEN                                       "SC_HID_FUNC_ERSETZEN"
#define HID_FUNC_FEST                                           "SC_HID_FUNC_FEST"
#define HID_FUNC_LAENGE                                         "SC_HID_FUNC_LAENGE"
#define HID_FUNC_LINKS                                          "SC_HID_FUNC_LINKS"
#define HID_FUNC_RECHTS                                         "SC_HID_FUNC_RECHTS"
#define HID_FUNC_TEIL                                           "SC_HID_FUNC_TEIL"
#define HID_FUNC_LENB                                           "SC_HID_FUNC_LENB"
#define HID_FUNC_RIGHTB                                         "SC_HID_FUNC_RIGHTB"
#define HID_FUNC_LEFTB                                          "SC_HID_FUNC_LEFTB"
#define HID_FUNC_MIDB                                           "SC_HID_FUNC_MIDB"
#define HID_FUNC_WIEDERHOLEN                                    "SC_HID_FUNC_WIEDERHOLEN"
#define HID_FUNC_WECHSELN                                       "SC_HID_FUNC_WECHSELN"
#define HID_FUNC_BASIS                                          "SC_HID_FUNC_BASIS"
#define HID_FUNC_DEZIMAL                                        "SC_HID_FUNC_DEZIMAL"
#define HID_FUNC_ROEMISCH                                       "SC_HID_FUNC_ROEMISCH"
#define HID_FUNC_ARABISCH                                       "SC_HID_FUNC_ARABISCH"
#define HID_FUNC_BAHTTEXT                                       "SC_HID_FUNC_BAHTTEXT"
#define HID_FUNC_JIS                                            "SC_HID_FUNC_JIS"
#define HID_FUNC_ASC                                            "SC_HID_FUNC_ASC"
#define HID_FUNC_UNICODE                                        "SC_HID_FUNC_UNICODE"
#define HID_FUNC_UNICHAR                                        "SC_HID_FUNC_UNICHAR"
#define HID_FUNC_NUMBERVALUE                                    "SC_HID_FUNC_NUMBERVALUE"
#define HID_FUNC_BITAND                                         "SC_HID_FUNC_BITAND"
#define HID_FUNC_BITOR                                          "SC_HID_FUNC_BITOR"
#define HID_FUNC_BITXOR                                         "SC_HID_FUNC_BITXOR"
#define HID_FUNC_BITLSHIFT                                      "SC_HID_FUNC_BITLSHIFT"
#define HID_FUNC_BITRSHIFT                                      "SC_HID_FUNC_BITRSHIFT"
#define HID_FUNC_FILTERXML                                      "SC_HID_FUNC_FILTERXML"
#define HID_FUNC_WEBSERVICE                                     "SC_HID_FUNC_WEBSERVICE"
#define HID_FUNC_ENCODEURL                                      "SC_HID_FUNC_ENCODEURL"
#define HID_FUNC_COLOR                                          "SC_HID_FUNC_COLOR"
#define HID_FUNC_COVARIANCE_P                                   "SC_HID_FUNC_COVARIANCE_P"
#define HID_FUNC_COVARIANCE_S                                   "SC_HID_FUNC_COVARIANCE_S"
#define HID_FUNC_ST_DEV_P_MS                                    "SC_HID_FUNC_ST_DEV_P_MS"
#define HID_FUNC_ST_DEV_S                                       "SC_HID_FUNC_ST_DEV_S"
#define HID_FUNC_VAR_P_MS                                       "SC_HID_FUNC_VAR_P_MS"
#define HID_FUNC_VAR_S                                          "SC_HID_FUNC_VAR_S"
#define HID_FUNC_BETADIST_MS                                    "SC_HID_FUNC_BETADIST_MS"
#define HID_FUNC_BETAINV_MS                                     "SC_HID_FUNC_BETAINV_MS"
#define HID_FUNC_BINOM_DIST_MS                                  "SC_HID_FUNC_BINOM_DIST_MS"
#define HID_FUNC_BINOM_INV_MS                                   "SC_HID_FUNC_BINOM_INV_MS"
#define HID_FUNC_CHIINV_MS                                      "SC_HID_FUNC_CHIINV_MS"
#define HID_FUNC_CHIVERT_MS                                     "SC_HID_FUNC_CHIVERT_MS"
#define HID_FUNC_CHITEST_MS                                     "SC_HID_FUNC_CHITEST_MS"
#define HID_FUNC_CHISQDIST_MS                                   "SC_HID_FUNC_CHISQDIST_MS"
#define HID_FUNC_CHISQINV_MS                                    "SC_HID_FUNC_CHISQINV_MS"
#define HID_FUNC_CONFIDENCE_N                                   "SC_HID_FUNC_CONFIDENCE_N"
#define HID_FUNC_CONFIDENCE_T                                   "SC_HID_FUNC_CONFIDENCE_T"
#define HID_FUNC_F_DIST_LT                                      "SC_HID_FUNC_F_DIST_LT"
#define HID_FUNC_F_DIST_RT                                      "SC_HID_FUNC_F_DIST_RT"
#define HID_FUNC_F_INV_LT                                       "SC_HID_FUNC_F_INV_LT"
#define HID_FUNC_F_INV_RT                                       "SC_HID_FUNC_F_INV_RT"
#define HID_FUNC_F_TEST_MS                                      "SC_HID_FUNC_F_TEST_MS"
#define HID_FUNC_EXP_DIST_MS                                    "SC_HID_FUNC_EXP_DIST_MS"
#define HID_FUNC_HYP_GEOM_DIST_MS                               "SC_HID_FUNC_HYP_GEOM_DIST_MS"
#define HID_FUNC_POISSON_DIST_MS                                "SC_HID_FUNC_POISSON_DIST_MS"
#define HID_FUNC_WEIBULL_DIST_MS                                "SC_HID_FUNC_WEIBULL_DIST_MS"
#define HID_FUNC_GAMMADIST_MS                                   "SC_HID_FUNC_GAMMADIST_MS"
#define HID_FUNC_GAMMAINV_MS                                    "SC_HID_FUNC_GAMMAINV_MS"
#define HID_FUNC_GAMMALN_MS                                     "SC_HID_FUNC_GAMMALN_MS"
#define HID_FUNC_LOGNORMDIST_MS                                 "SC_HID_FUNC_LOGNORMDIST_MS"
#define HID_FUNC_NORMDIST_MS                                    "SC_HID_FUNC_NORMDIST_MS"
#define HID_FUNC_NORMINV_MS                                     "SC_HID_FUNC_NORMINV_MS"
#define HID_FUNC_STD_NORMDIST_MS                                "SC_HID_FUNC_STD_NORMDIST_MS"
#define HID_FUNC_STD_NORMINV_MS                                 "SC_HID_FUNC_STD_NORMINV_MS"
#define HID_FUNC_TDIST_2T                                       "SC_HID_FUNC_TDIST_2T"
#define HID_FUNC_TDIST_MS                                       "SC_HID_FUNC_TDIST_MS"
#define HID_FUNC_TDIST_RT                                       "SC_HID_FUNC_TDIST_RT"
#define HID_FUNC_TINV_2T                                        "SC_HID_FUNC_TINV_2T"
#define HID_FUNC_TINV_MS                                        "SC_HID_FUNC_TINV_MS"
#define HID_FUNC_TTEST_MS                                       "SC_HID_FUNC_TTEST_MS"
#define HID_FUNC_PERCENTILE_EXC                                 "SC_HID_FUNC_PERCENTILE_EXC"
#define HID_FUNC_PERCENTILE_INC                                 "SC_HID_FUNC_PERCENTILE_INC"
#define HID_FUNC_PERCENTRANK_EXC                                "SC_HID_FUNC_PERCENTRANK_EXC"
#define HID_FUNC_PERCENTRANK_INC                                "SC_HID_FUNC_PERCENTRANK_INC"
#define HID_FUNC_QUARTILE_INC                                   "SC_HID_FUNC_QUARTILE_INC"
#define HID_FUNC_QUARTILE_EXC                                   "SC_HID_FUNC_QUARTILE_EXC"
#define HID_FUNC_RANK_EQ                                        "SC_HID_FUNC_RANK_EQ"
#define HID_FUNC_RANK_AVG                                       "SC_HID_FUNC_RANK_AVG"
#define HID_FUNC_MODAL_VALUE_MS                                 "SC_HID_FUNC_MODAL_VALUE_MS"
#define HID_FUNC_MODAL_VALUE_MULTI                              "SC_HID_FUNC_MODAL_VALUE_MULTI"
#define HID_FUNC_NEGBINOMDIST_MS                                "SC_HID_FUNC_NEGBINOMDIST_MS"
#define HID_FUNC_Z_TEST_MS                                      "SC_HID_FUNC_Z_TEST_MS"
#define HID_FUNC_CEIL_MS                                        "SC_HID_FUNC_CEIL_MS"
#define HID_FUNC_CEIL_PRECISE                                   "SC_HID_FUNC_CEIL_PRECISE"
#define HID_FUNC_CEIL_ISO                                       "SC_HID_FUNC_CEIL_ISO"
#define HID_FUNC_FLOOR_MS                                       "SC_HID_FUNC_FLOOR_MS"
#define HID_FUNC_NETWORKDAYS                                    "SC_HID_FUNC_NETWORKDAYS"
#define HID_FUNC_NETWORKDAYS_MS                                 "SC_HID_FUNC_NETWORKDAYS_MS"
#define HID_FUNC_WORKDAY_MS                                     "SC_HID_FUNC_WORKDAY_MS"
#define HID_FUNC_ERF_MS                                         "SC_HID_FUNC_ERF_MS"
#define HID_FUNC_ERFC_MS                                        "SC_HID_FUNC_ERFC_MS"
#define HID_FUNC_AGGREGATE                                      "SC_HID_FUNC_AGGREGATE"
#define HID_FUNC_ERROR_TYPE_ODF                                 "SC_HID_FUNC_ERROR_TYPE_ODF"
#define HID_FUNC_CEIL_MATH                                      "SC_HID_FUNC_CEIL_MATH"
#define HID_FUNC_FLOOR_MATH                                     "SC_HID_FUNC_FLOOR_MATH"
#define HID_FUNC_FLOOR_PRECISE                                  "SC_HID_FUNC_FLOOR_PRECISE"
#define HID_FUNC_RAWSUBTRACT                                    "SC_HID_FUNC_RAWSUBTRACT"
#define HID_FUNC_WEEKNUM_OOO                                    "SC_HID_FUNC_WEEKNUM_OOO"
#define HID_FUNC_FORECAST_ETS_ADD                               "SC_HID_FUNC_FORECAST_ETS_ADD"
#define HID_FUNC_FORECAST_ETS_MUL                               "SC_HID_FUNC_FORECAST_ETS_MUL"
#define HID_FUNC_FORECAST_ETS_PIA                               "SC_HID_FUNC_FORECAST_ETS_PIA"
#define HID_FUNC_FORECAST_ETS_PIM                               "SC_HID_FUNC_FORECAST_ETS_PIM"
#define HID_FUNC_FORECAST_ETS_SEA                               "SC_HID_FUNC_FORECAST_ETS_SEA"
#define HID_FUNC_FORECAST_ETS_STA                               "SC_HID_FUNC_FORECAST_ETS_STA"
#define HID_FUNC_FORECAST_ETS_STM                               "SC_HID_FUNC_FORECAST_ETS_STM"
#define HID_FUNC_FORECAST_LIN                                   "SC_HID_FUNC_FORECAST_LIN"
#define HID_FUNC_CONCAT_MS                                      "SC_HID_FUNC_CONCAT_MS"
#define HID_FUNC_TEXTJOIN_MS                                    "SC_HID_FUNC_TEXTJOIN_MS"
#define HID_FUNC_IFS_MS                                         "SC_HID_FUNC_IFS_MS"
#define HID_FUNC_SWITCH_MS                                      "SC_HID_FUNC_SWITCH_MS"
#define HID_FUNC_MINIFS_MS                                      "SC_HID_FUNC_MINIFS_MS"
#define HID_FUNC_MAXIFS_MS                                      "SC_HID_FUNC_MAXIFS_MS"
#define HID_FUNC_ROUNDSIG                                       "SC_HID_FUNC_ROUNDSIG"
#define HID_FUNC_REPLACEB                                       "SC_HID_FUNC_REPLACEB"
#define HID_FUNC_FINDB                                          "SC_HID_FUNC_FINDB"
#define HID_FUNC_SEARCHB                                        "SC_HID_FUNC_SEARCHB"
#define HID_FUNC_REGEX                                          "SC_HID_FUNC_REGEX"

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
