/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: IBM Corporation
 *
 *  Copyright: 2008 by IBM Corporation
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
/*************************************************************************
 * @file
 *  For LWP filter architecture prototype
 ************************************************************************/
/*************************************************************************
 * Change History
 Jan 2005           Created
 ************************************************************************/

#ifndef INCLUDED_LOTUSWORDPRO_SOURCE_FILTER_LWPOBJFACTORY_HXX
#define INCLUDED_LOTUSWORDPRO_SOURCE_FILTER_LWPOBJFACTORY_HXX

#include <sal/config.h>

#include <rtl/ref.hxx>

#include "lwpheader.hxx"
#include "lwpobjid.hxx"
#include "lwpobj.hxx"
#include "lwpobjhdr.hxx"
#include "lwpidxmgr.hxx"

#include <unordered_map>

/**
 * @brief   object factory used for lwp object creation and maintenance
*/
class LwpObjectFactory
{
public:
    LwpObjectFactory(LwpSvStream* pSvStream);
public:
//  static LwpObjectFactory* Instance(LwpSvStream* pSvStream=NULL);
    ~LwpObjectFactory();

//For object Factory and object manager
private:
//  static LwpObjectFactory *m_pMgr;
    sal_uInt32 m_nNumObjs;
    LwpSvStream* m_pSvStream;
    struct hashFunc
    {
            size_t operator()( const LwpObjectID& rName ) const
            {
                return rName.HashCode();
            }
    };
    struct eqFunc
    {
            bool operator()( const LwpObjectID& rKey1, const LwpObjectID& rKey2 ) const
            {
                return(rKey1==rKey2);
            }
    };
    typedef std::unordered_map<LwpObjectID, rtl::Reference<LwpObject>, hashFunc, eqFunc> LwpIdToObjMap;
    LwpIdToObjMap m_IdToObjList;
    LwpIndexManager m_IndexMgr;
    void ClearObjectMap();

protected:
    rtl::Reference<LwpObject> FindObject(const LwpObjectID &objID);
public:
    rtl::Reference<LwpObject> CreateObject(sal_uInt32 type, LwpObjectHeader &objHdr);
    rtl::Reference<LwpObject> QueryObject(const LwpObjectID &objID);
    void ReleaseObject(const LwpObjectID &objID);
    void ReadIndex(LwpSvStream* pStrm);
    LwpIndexManager& GetIndexManager(){return m_IndexMgr;}

};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
