package WSDiscovery::Types::ProbeType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Types_of :ATTR(:get<Types>);
my %Scopes_of :ATTR(:get<Scopes>);

__PACKAGE__->_factory(
    [ qw(        Types
        Scopes

    ) ],
    {
        'Types' => \%Types_of,
        'Scopes' => \%Scopes_of,
    },
    {
        'Types' => 'WSDiscovery::Elements::Types',

        'Scopes' => 'WSDiscovery::Elements::Scopes',

    },
    {

        'Types' => '',
        'Scopes' => '',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

WSDiscovery::Types::ProbeType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ProbeType from the namespace http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Types

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * Scopes

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # WSDiscovery::Types::ProbeType
   Types => $some_value, # QNameListType
   Scopes =>  { value => $some_value },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

