/*
 * @(#)Pyraminx.h
 *
 * Copyright 1994 - 2023  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Pyraminx */

#ifndef _XtPyraminx_h
#define _XtPyraminx_h

/***********************************************************************
 *
 * Pyraminx Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNview ((char *) "view")
#define XtNsize ((char *) "size")
#define XtNsticky ((char *) "sticky")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "position")
#define XtNdirection ((char *) "direction")
#define XtNstyle ((char *) "style")
#define XtNcontrol ((char *) "control")
#define XtNfast ((char *) "fast")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCView ((char *) "View")
#define XtCSize ((char *) "Size")
#define XtCSticky ((char *) "Sticky")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Position")
#define XtCDirection ((char *) "Direction")
#define XtCStyle ((char *) "Style")
#define XtCControl ((char *) "Control")
#define XtCFast ((char *) "Fast")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _PyraminxClassRec *PyraminxWidgetClass;

extern WidgetClass pyraminxWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction, style;
	int         control;
	int         fast;
} pyraminxCallbackStruct;
#endif

#define ACTION_GET 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_PRACTICE_QUERY 104
#define ACTION_RANDOMIZE_QUERY 105
#define ACTION_SOLVE_MESSAGE 106
#define ACTION_FIND_MESSAGE 115
#define ACTION_RESTORE 107
#define ACTION_RESET 108
#define ACTION_AMBIGUOUS 109
#define ACTION_ILLEGAL 110
#define ACTION_MOVED 111
#define ACTION_CONTROL 112
#define ACTION_SOLVED 113
#define ACTION_COMPUTED 114
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_PRACTICE 203
#define ACTION_RANDOMIZE 204
#define ACTION_SOLVE 205
#define ACTION_FIND 216
#define ACTION_INCREMENT 206
#define ACTION_DECREMENT 207
#define ACTION_ORIENTIZE 208
#define ACTION_STICKY 209
#define ACTION_SPEED 210
#define ACTION_SLOW 211
#define ACTION_SOUND 212
#define ACTION_VIEW 213
#define ACTION_DIM 214
#define ACTION_CHEAT 215
#define ACTION_TOP 300
#define ACTION_TR 301
#define ACTION_RIGHT 302
#define ACTION_BOTTOM 303
#define ACTION_BL 304
#define ACTION_LEFT 305
#define ACTION_CW 307
#define ACTION_BR 309
#define ACTION_TL 310
#define ACTION_CCW 311
#define ACTION_SHIFT_TOP 320
#define ACTION_SHIFT_TR 321
#define ACTION_SHIFT_RIGHT 322
#define ACTION_SHIFT_BOTTOM 323
#define ACTION_SHIFT_BL 324
#define ACTION_SHIFT_LEFT 325
#define ACTION_SHIFT_CW 327
#define ACTION_SHIFT_BR 329
#define ACTION_SHIFT_TL 330
#define ACTION_SHIFT_CCW 331
#define ACTION_CONTROL_TOP 340
#define ACTION_CONTROL_TR 341
#define ACTION_CONTROL_RIGHT 342
#define ACTION_CONTROL_BOTTOM 343
#define ACTION_CONTROL_BL 344
#define ACTION_CONTROL_LEFT 345
#define ACTION_CONTROL_CW 347
#define ACTION_CONTROL_BR 349
#define ACTION_CONTROL_TL 350
#define ACTION_CONTROL_CCW 351
#define ACTION_SHIFT_CONTROL_TOP 360
#define ACTION_SHIFT_CONTROL_TR 361
#define ACTION_SHIFT_CONTROL_RIGHT 362
#define ACTION_SHIFT_CONTROL_BOTTOM 363
#define ACTION_SHIFT_CONTROL_BL 364
#define ACTION_SHIFT_CONTROL_LEFT 365
#define ACTION_SHIFT_CONTROL_CW 367
#define ACTION_SHIFT_CONTROL_BR 369
#define ACTION_SHIFT_CONTROL_TL 370
#define ACTION_SHIFT_CONTROL_CCW 371
#define ACTION_PERIOD2 400
#define ACTION_PERIOD3 401
#define ACTION_BOTH 402
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999
#define ACTION_SHIFT(a) ((a>=ACTION_SHIFT_TOP) && (a<=ACTION_SHIFT_CCW))
#define ACTION_SHIFT_CONTROL(a) ((a>=ACTION_SHIFT_CONTROL_TOP) && (a<=ACTION_SHIFT_CONTROL_CCW))

#define RESTORE_DIR (-5)
#define CLEAR_DIR (-4)
#define AMBIGUOUS_DIR (-3)
#define ILLEGAL_DIR (-2)
#define IGNORE_DIR (-1)
#define MAX_FACES 4
#define MAX_VIEWS 2
#define MIN_FACETS 1
#define PERIOD2 2
#define PERIOD3 3
#define BOTH 4
#define MAX_MODES 3
#define DEFAULT_MODE PERIOD3
#define DEFAULT_FACETS 3
#define DEFAULT_ORIENT FALSE
#define DEFAULT_PRACTICE TRUE
#define DEFAULT_STICKY FALSE
#define DEFAULT_DELAY 10
#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _PyraminxRec *PyraminxWidget;

#endif /* _XtPyraminx_h */
/* DON'T ADD STUFF AFTER THIS #endif */
