/*---------------------------------------------------------------------------*\
	vtcore_ioctl.h
	Core Kernel module IOCTL header file
	Author: Ben Kramer
	Date:	24 October 2005
\*---------------------------------------------------------------------------*/

#ifndef __VTCOREIOCTL__
#define __VTCOREIOCTL__

/* Channel Interface types */
#define VT_UNKNOWN	0
#define VT_FXO_AN	1
#define VT_FXS_AN	2

typedef struct {
	unsigned char   board;
	unsigned char   channel;
	unsigned int    length;
	void           *data;
} VT_DATA;

typedef struct {
	unsigned char reg;
	unsigned char value;
} VT_REG_RW;


#define VT_IOC_MAGIC   'v'

//#define VT_IOC_REGWRITE	_IO(VT_IOC_MAGIC, 1)
//#define VT_IOC_REGREAD	_IO(VT_IOC_MAGIC, 2)
#define VT_IOC_CHANREADAUDIO	_IO(VT_IOC_MAGIC, 3)
#define VT_IOC_CHANWRITEAUDIO	_IO(VT_IOC_MAGIC, 4)
#define VT_IOC_HOOK		_IO(VT_IOC_MAGIC, 5)
#define VT_IOC_READ_MSGQ	_IO(VT_IOC_MAGIC, 6)
#define VT_IOC_CHANCOUNT	_IO(VT_IOC_MAGIC, 7)
//#define VT_IOC_LINEVOLT	_IO(VT_IOC_MAGIC, 8)    // unused
//#define VT_IOC_LINEPOL	_IO(VT_IOC_MAGIC, 9)
//#define VT_IOC_LINESTATE	_IO(VT_IOC_MAGIC, 10)
#define VT_IOC_LISTEN		_IO(VT_IOC_MAGIC, 11)
#define VT_IOC_UNLISTEN		_IO(VT_IOC_MAGIC, 12)
/* Use 2 Listens instead
#define VT_IOC_BRIDGE		_IO(VT_IOC_MAGIC, 13)
#define VT_IOC_UNBRIDGE		_IO(VT_IOC_MAGIC, 14)
*/
#define VT_IOC_CHAN_READ_AUDIO_FIFO_HOW_FULL	_IO(VT_IOC_MAGIC, 15)
#define VT_IOC_CHAN_WRITE_AUDIO_FIFO_HOW_EMPTY	_IO(VT_IOC_MAGIC, 16)
#define VT_IOC_BOARD_COUNT	_IO(VT_IOC_MAGIC, 17)
#define VT_IOC_BOARD_PORT_COUNT	_IO(VT_IOC_MAGIC, 18)
#define VT_IOC_BOARD_PORT_TYPE	_IO(VT_IOC_MAGIC, 19)
#define VT_IOC_CHAN_BALANCE_SET	_IO(VT_IOC_MAGIC, 20)
#define VT_IOC_SET_RECGAIN	_IO(VT_IOC_MAGIC, 21)
#define VT_IOC_SET_PLAYGAIN	_IO(VT_IOC_MAGIC, 22)
#define VT_IOC_FXS_RING		_IO(VT_IOC_MAGIC, 23)
//#define VT_IOC_FXS_RING_CADON	  _IO(VT_IOC_MAGIC, 24)  // unused
//#define VT_IOC_FXS_RING_CADOFF  _IO(VT_IOC_MAGIC, 25)
//#define VT_IOC_FXS_RING_CADON2  _IO(VT_IOC_MAGIC, 26)
//#define VT_IOC_FXS_RING_CADOFF2 _IO(VT_IOC_MAGIC, 27)
#define VT_IOC_SET_LOGGING	_IO(VT_IOC_MAGIC, 28)
#define VT_IOC_ECHOCAN_ON	_IO(VT_IOC_MAGIC, 29)
#define VT_IOC_ECHOCAN_OFF	_IO(VT_IOC_MAGIC, 30)

//#define VT_IOC_PORT_RST	_IO(VT_IOC_MAGIC, 50)

#define VT_IOC_SETCOUNTRY	_IOW(VT_IOC_MAGIC, 61, VT_DATA)
#define VT_IOC_SETFLASH		_IOW(VT_IOC_MAGIC, 62, VT_DATA)
#define VT_IOC_SETHOOKTHRESH	_IOW(VT_IOC_MAGIC, 63, VT_DATA)
#define VT_IOC_SETLOOPDROP	_IOW(VT_IOC_MAGIC, 64, VT_DATA)
#define VT_IOC_SETVDAAIMPEDANCE	_IOW(VT_IOC_MAGIC, 65, VT_DATA)

#define VT_IOC_TAPLISTEN	_IOW(VT_IOC_MAGIC, 70, VT_DATA)

#define VT_IOC_DRIVER_VERSION	_IO(VT_IOC_MAGIC, 99)

/* OpenPCI programming */
#define VT_IOC_PPWDATA		_IO(VT_IOC_MAGIC, 100)
#define VT_IOC_PPRSTATUS	_IO(VT_IOC_MAGIC, 101)
#define VT_IOC_PPRELEASE	_IO(VT_IOC_MAGIC, 102)
//#define VT_IOC_PPEXCL		_IO(VT_IOC_MAGIC, 103)
#define VT_IOC_PPCLAIM		_IO(VT_IOC_MAGIC, 104)
#define VT_IOC_OPCI_ARM_RST	_IO(VT_IOC_MAGIC, 105)
#define VT_IOC_ARMR		_IO(VT_IOC_MAGIC, 106)
#define VT_IOC_ARMW		_IO(VT_IOC_MAGIC, 107)
//#define VT_IOC_OPCI_ARM_RESET	_IO(VT_IOC_MAGIC, 108)

// Replacements for ARMW, PPWDATA and PPSTATUS
#define VT_IOC_ARMWR	        _IO(VT_IOC_MAGIC, 109)
#define VT_IOC_JTAGWRITE	_IO(VT_IOC_MAGIC, 110)
#define VT_IOC_JTAGSTATUS	_IO(VT_IOC_MAGIC, 111)

#endif
