/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser;

import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.SchemaSetImpl;
import com.sun.xml.xsom.impl.parser.NGCCRuntimeEx;
import com.sun.xml.xsom.impl.parser.Patch;
import com.sun.xml.xsom.impl.parser.PatcherManager;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XMLParser;
import com.sun.xml.xsom.parser.XSOMParser;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserContext {
    public final SchemaSetImpl schemaSet = new SchemaSetImpl();
    private final XSOMParser owner;
    final XMLParser parser;
    private final Vector patchers = new Vector();
    protected final Set parsedDocuments = new HashSet();
    private boolean hadError = false;
    final PatcherManager patcherManager = new PatcherManager(){

        public void addPatcher(Patch patch) {
            ParserContext.this.patchers.add(patch);
        }

        public void reportError(String msg, Locator src) throws SAXException {
            ParserContext.this.setErrorFlag();
            SAXParseException e = new SAXParseException(msg, src);
            if (ParserContext.this.errorHandler == null) {
                throw e;
            }
            ParserContext.this.errorHandler.error(e);
        }
    };
    final ErrorHandler errorHandler = new ErrorHandler(){

        private ErrorHandler getErrorHandler() {
            if (ParserContext.this.owner.getErrorHandler() == null) {
                return ParserContext.this.noopHandler;
            }
            return ParserContext.this.owner.getErrorHandler();
        }

        public void warning(SAXParseException e) throws SAXException {
            this.getErrorHandler().warning(e);
        }

        public void error(SAXParseException e) throws SAXException {
            ParserContext.this.setErrorFlag();
            this.getErrorHandler().error(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            ParserContext.this.setErrorFlag();
            this.getErrorHandler().fatalError(e);
        }
    };
    final ErrorHandler noopHandler = new ErrorHandler(){

        public void warning(SAXParseException e) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXException {
        }

        public void fatalError(SAXParseException e) throws SAXException {
            ParserContext.this.setErrorFlag();
        }
    };

    public ParserContext(XSOMParser owner, XMLParser parser) {
        this.owner = owner;
        this.parser = parser;
        try {
            this.parse(new InputSource(ParserContext.class.getResource("datatypes.xsd").toExternalForm()));
            SchemaImpl xs = (SchemaImpl)this.schemaSet.getSchema("http://www.w3.org/2001/XMLSchema");
            xs.addSimpleType(this.schemaSet.anySimpleType);
            xs.addComplexType(this.schemaSet.anyType);
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                e.getException().printStackTrace();
            } else {
                e.printStackTrace();
            }
            throw new InternalError();
        }
    }

    public EntityResolver getEntityResolver() {
        return this.owner.getEntityResolver();
    }

    public AnnotationParserFactory getAnnotationParserFactory() {
        return this.owner.getAnnotationParserFactory();
    }

    public void parse(InputSource source) throws SAXException {
        this.newNGCCRuntime().parseEntity(source, false, null, null);
    }

    public XSSchemaSet getResult() throws SAXException {
        Iterator itr = this.patchers.iterator();
        while (itr.hasNext()) {
            ((Patch)itr.next()).run();
        }
        this.patchers.clear();
        itr = this.schemaSet.iterateElementDecls();
        while (itr.hasNext()) {
            ((ElementDecl)itr.next()).updateSubstitutabilityMap();
        }
        if (this.hadError) {
            return null;
        }
        return this.schemaSet;
    }

    public NGCCRuntimeEx newNGCCRuntime() {
        return new NGCCRuntimeEx(this);
    }

    void setErrorFlag() {
        this.hadError = true;
    }

    protected static final class DocumentIdentity {
        private final String targetNamespaceUri;
        private final String schemaDocumentURI;

        protected DocumentIdentity(String _targetNamespaceUri, String _schemaDocumentURI) {
            this.targetNamespaceUri = _targetNamespaceUri;
            this.schemaDocumentURI = _schemaDocumentURI;
        }

        public boolean equals(Object o) {
            DocumentIdentity rhs = (DocumentIdentity)o;
            if (!this.schemaDocumentURI.equals(rhs.schemaDocumentURI)) {
                return false;
            }
            if (this.targetNamespaceUri == null && rhs.targetNamespaceUri == null) {
                return true;
            }
            if (this.targetNamespaceUri == null || rhs.targetNamespaceUri == null) {
                return false;
            }
            return this.targetNamespaceUri.equals(rhs.targetNamespaceUri);
        }

        public int hashCode() {
            return this.schemaDocumentURI.hashCode() ^ (this.targetNamespaceUri == null ? 0 : this.targetNamespaceUri.hashCode());
        }
    }
}

