/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0.3
 * January 2003
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
//
#ifndef _vdk_hlbutton_h
// put your code below here
#define _vdk_hlbutton_h
#include <vdk/evlisthandle.h>
#include <vdk/vdkcustombutton.h>

/*!
  \class VDKHLButton
  \brief (HL stands for HighLighted) this class provides a button that
  behaves like Netscape buttons, it highlights when mouse is over.
  Parent class API left unchanged. This widget can be used alone or
  packed into a VDKHLButtonBar
 */
class VDKHLButton: public VDKCustomButton
{
  protected:
  VDKPixbuf* normal_pix, *pixellated_pix,  *darkened_pix;
  bool OnEnter (VDKObject*,  GdkEvent*);
  bool OnLeave (VDKObject*,  GdkEvent*);
  bool OnClickRelease (VDKObject*,  GdkEvent*);
  bool OnClickPress (VDKObject*,  GdkEvent*);
  public:
  /*!
    constructor
    \param owner the owner form
    \param pixfile a graphic file (accepts both .xpm and .png)
    \param label a label (but these buttons look better without label)
    \param type
    \parm position label position related to pixmap
  */
  VDKHLButton (VDKForm  *owner, 
                  const char *pixfile, 
                  const char *label = NULL, 
                  unsigned int type=VDK_CBUTTON_UNTOGGLED|VDK_CBUTTON_NORMAL,
                  GtkPositionType position=GTK_POS_RIGHT);
    /*!
    constructor
    \param owner the owner form
    \param pixdata a graphic data (only .xpm format)
    \param label a label (but these buttons look better without label)
    \param type
    \parm position label position related to pixmap
  */
  VDKHLButton (VDKForm *owner,
                   const char **pixdata,
                   const char *label = NULL,
                   unsigned int type=VDK_CBUTTON_UNTOGGLED|VDK_CBUTTON_NORMAL,
                   GtkPositionType position=GTK_POS_RIGHT);
  virtual ~VDKHLButton () {}
  void Setup (void);
  DECLARE_EVENT_LIST (VDKHLButton);
};
#endif 

