###############################################################################
# Computes dependencies using HIPCC
###############################################################################
# Copyright (c) 2008-2020 Advanced Micro Devices, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

###############################################################################
# This file converts dependency files generated using hipcc to a format that
# cmake can understand.

# Input variables:
#
# input_file:STRING=<> Dependency file to parse. Required argument
# output_file:STRING=<> Output file to generate. Required argument

if(NOT input_file OR NOT output_file)
    message(FATAL_ERROR "You must specify input_file and output_file on the command line")
endif()

file(READ ${input_file} depend_text)

if (NOT "${depend_text}" STREQUAL "")
    string(REPLACE " /" "\n/" depend_text ${depend_text})
    string(REGEX REPLACE "^.*:" "" depend_text ${depend_text})
    string(REGEX REPLACE "[ \\\\]*\n" ";" depend_text ${depend_text})

    set(dependency_list "")

    foreach(file ${depend_text})
        string(REGEX REPLACE "^ +" "" file ${file})
        if(NOT EXISTS "${file}")
            message(WARNING " Removing non-existent dependency file: ${file}")
            set(file "")
        endif()

        if(NOT IS_DIRECTORY "${file}")
            get_filename_component(file_absolute "${file}" ABSOLUTE)
            list(APPEND dependency_list "${file_absolute}")
        endif()
    endforeach()
endif()

# Remove the duplicate entries and sort them.
list(REMOVE_DUPLICATES dependency_list)
list(SORT dependency_list)

foreach(file ${dependency_list})
    set(hip_hipcc_depend "${hip_hipcc_depend} \"${file}\"\n")
endforeach()

file(WRITE ${output_file} "# Generated by: FindHIP.cmake. Do not edit.\nSET(HIP_HIPCC_DEPEND\n ${hip_hipcc_depend})\n\n")
# vim: ts=4:sw=4:expandtab:smartindent
