
/****************************************************************************
 **
 ** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
 ** All rights reserved.
 ** Contact: chuebsch@moliso.de
 **
 ** This file is part of the ShelXle
 **
 ** This file may be used under the terms of the GNU Lesser
 ** General Public License version 2.1 as published by the Free Software
 ** Foundation and appearing in the file COPYING included in the
 ** packaging of this file.  Please review the following information to
 ** ensure the GNU Lesser General Public License version 2.1 requirements
 ** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
 **
 **
 ****************************************************************************/
//äöüß needed to keep this file UTF8 QString::fromUtf8("»")
#include "eacDlg.h"
#include "deprecation.h"
#include "opengltestwidget.h"
#include <QColorDialog>
#include <QPushButton>
#include <QFileDialog>
#include <QFontDialog>
#include <QLineEdit>
#include <QLabel>
#include <QGroupBox>
#include <QDialogButtonBox>

// #include "glureplace.h"
#include "itsme.h"
#ifndef GL_MULTISAMPLE
#define GL_MULTISAMPLE  0x809D
#endif

/*

EacGLW::EacGLW(Molecule *externMole, QWidget * parent): QOpenGLWidget(parent){
  this->setParent(parent);
  mol=externMole;
  mol->loadSettings();
  //printf("EacGLW %p\n",mol);
  einstellung = new QSettings( QSettings::IniFormat, QSettings::UserScope ,PROGRAM_NAME,mol->mynewnameis ,this);
  einstellung->beginGroup("Colors");
  backGroundColor=einstellung->value("BackGroundColor",QColor("lightskyblue")).value<QColor>();
  labelColor=einstellung->value("LabelColor").value<QColor>();
  einstellung->endGroup();

  //printf("einstellung %s\n",einstellung->fileName().toStdString().c_str());
  einstellung->sync();
  exmin=mol->pmin;
  exmax=mol->pmax;
  mol->pmax=0.99;
  mol->pmin=0.39;
  //mol->copyAcol(mol->AtomColor,mol->arad,mol->AtomStyle);
  //mol->loadSettings();
  proba=50;
  MyAtom xda;
  xda.symmGroup=0;
  xda.hidden=0;
  xda.part=0;
  //xda.ownStyle=false;
  xda.Label="C";
  xda.pos.x=0;
  xda.pos.y=0;
  xda.pos.z=0;
  xda.uc.m11=0.1;
  xda.uc.m22=0.07;
  xda.uc.m33=0.025;
  xda.uc.m13=xda.uc.m31=0.01;
  xda.uc.m12=xda.uc.m21=-0.02;
  xda.uc.m23=xda.uc.m32=0.01;
  xda.an = 5;
  xd.append(xda);

  xda.Label="H1(noADP)";
  xda.pos.x=0.00001;
  xda.pos.y=0.00001;
  xda.pos.z=1.0;
  // xda.ownStyle=true;
  //xda.style=ATOM_STYLE_NOADP;
  //xda.rad=mol->arad[0];
  //xda.color=mol->AtomColor[0];
  xda.uc.m11=0.05;
  xda.uc.m22=0.05;
  xda.uc.m33=0.05;
  xda.uc.m13=0.0;
  xda.uc.m12=0.0;
  xda.uc.m23=0.0;
  xda.an=0;
  xd.append(xda);

  xda.Label="H2";
  //xda.ownStyle=false;
  xda.pos.x=0.81649658102978810529098386315336;
  xda.pos.y=-0.4714045208499572479996295714055;
  xda.pos.z=-0.333333;
  xda.uc.m11=0.05;
  xda.uc.m22=0.05;
  xda.uc.m33=0.05;
  xda.uc.m13=0.0;
  xda.uc.m12=0.0;
  xda.uc.m23=0.0;
  xda.an=0;
  xd.append(xda);

  xda.Label="H3";
  xda.pos.x=0;
  xda.pos.y=0.94280904169991449599925914281199;
  xda.pos.z=-0.333333;
  xda.uc.m11=0.05;
  xda.uc.m22=0.05;
  xda.uc.m33=0.05;
  xda.uc.m13=0.0;
  xda.uc.m12=0.0;
  xda.uc.m23=0.0;
  xda.an=0;
  xd.append(xda);

  xda.Label="H4";
  xda.pos.x=-0.81649658102978810529098386315336;
  xda.pos.y=-0.4714045208499572479996295714055;
  xda.pos.z=-0.333333;
  xda.uc.m11=0.05;
  xda.uc.m22=0.05;
  xda.uc.m33=0.05;
  xda.uc.m13=0.0;
  xda.uc.m12=0.0;
  xda.uc.m23=0.0;
  xda.an=0;
  xd.append(xda);
  xda.Label="Q1";
  xda.pos.x=-0.81649658102978810529098386315336;
  xda.pos.y=-0.4714045208499572479996295714055;
  xda.pos.z=0.333333;
  xda.peakHeight=0.91;
  xda.uc.m11=0.05;
  xda.uc.m22=0.05;
  xda.uc.m33=0.05;
  xda.uc.m13=0.0;
  xda.uc.m12=0.0;
  xda.uc.m23=0.0;
  xda.an=-1;
  xd.append(xda);
  xda.Label="Q2";
  xda.pos.x=0.81649658102978810529098386315336;
  xda.pos.y=0.4714045208499572479996295714055;
  xda.pos.z=0.333333;
  xda.peakHeight=0.41;
  xda.uc.m11=0.05;
  xda.uc.m22=0.05;
  xda.uc.m33=0.05;
  xda.uc.m13=0.0;
  xda.uc.m12=0.0;
  xda.uc.m23=0.0;
  xda.an=-1;
  xd.append(xda);
  xda.Label="Q3";
  xda.pos.x=0;
  xda.pos.y=-0.94280904169991449599925914281199;
  xda.pos.z=0.333333;
  xda.peakHeight=0.71;
  xda.uc.m11=0.05;
  xda.uc.m22=0.05;
  xda.uc.m33=0.05;
  xda.uc.m13=0.0;
  xda.uc.m12=0.0;
  xda.uc.m23=0.0;
  xda.an=-1;
  xd.append(xda);
  printf("make bonds\n");
  bonds=mol->connecting(xd,true);
  xd[0].an=0;//das ist ein ... trick um bindungen vom zentralatom zu den liganden zu erzeugen.

}

void EacGLW::qglColor(QColor color) {
    glColor4d(color.redF(), color.greenF(), color.blueF(), color.alphaF());
}

void EacGLW::renderText(double x, double y, double z, const QString &text){
    // Identify x and y locations to render text within widget
  GLdouble textPosX = 0.0, textPosY = 0.0;
  project(x, y, z, textPosX, textPosY);
  //printf("%f %f %f -> %f %f\n",x,y,z,textPosX,textPosY);
  // Render text
  QPainter painter(this);
  QFontMetrics mtr(myFont);
  QRect rc=mtr.boundingRect(text+"L"); 
  QImage image(rc.width(),rc.height(), QImage::Format_ARGB32_Premultiplied);
  image.fill(0);
  QPainter p;
  p.begin(&image);
  p.setPen(labelColor);
  p.setBackground(Qt::NoBrush);
  p.setFont(myFont);
  p.drawText(image.rect(), Qt::AlignCenter, text);
  p.end();
  painter.drawImage(textPosX, textPosY-rc.height(), image);
  painter.end();
}

void EacGLW::setMSAA(bool b){
 QSurfaceFormat glf = format();
  printf("samples %d\n", glf.samples());
  if (b) {    
    glEnable(GL_MULTISAMPLE);
  }
  else  {
    glDisable(GL_MULTISAMPLE);;
  }
  update();
}

void EacGLW::draw(){
  //int pr;
  //glGetIntegerv(GL_CURRENT_PROGRAM,&pr);
  //printf("@@@%d %d \n",pr,mol->g_program);
  const GLfloat  OBJ_SPE[]   = { 0.8f, 0.8f, 0.8f, 1.0f };  
  const GLfloat  OBJ_SHIN    =  32.0f;               
  glMaterialfv( GL_FRONT_AND_BACK, GL_SPECULAR,             OBJ_SPE  );
  glEnable     ( GL_COLOR_MATERIAL ) ;
  glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE ) ;    
  glMaterialf(  GL_FRONT_AND_BACK, GL_SHININESS,           OBJ_SHIN );
  static double rtx=2.0;  
  glRotated(rtx/2.5,1.0,0.0,0.0);
  glRotated(rtx,0.0,0.0,1.0);
  glRotated(rtx/4.0,0.0,1.0,0.0);
  rtx+=0.5;
  mol->dratom=0;
  glEnable(GL_DEPTH_TEST );
  glDepthFunc(GL_LEQUAL);
  mol->monoQrom = false;
  //mol->nonPositiveDefinite=0;
//  mol->parthigh=false;
  glPushMatrix();
  glScaled( 40, 40, 40 );
  mol->adp=1;
  mol->intern=1;
  mol->tubes=0;
  glEnable(GL_CULL_FACE);
  mol->atoms(xd,proba);
  glDisable(GL_CULL_FACE);
  if (mol->bondColorStyle){
    qglColor(mol->bondColor);
    glDisable(GL_COLOR_MATERIAL);
  }
  //printf("bonds %d\n",bonds.size());
  mol->bonds(bonds);
  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_BLEND);
  mol->intern=0;
  mol->dratom=0;
  //if (!mol->useShaders) mol->atoms(xd,proba);
  mol->lbond();
  glDisable(GL_BLEND);
  glColor3f(0,0,0);
  glClear( GL_DEPTH_BUFFER_BIT);
  for (int i=0; i<xd.size();i++){
    if ((i==1)||(!(mol->AtomStyle[xd[i].an]&ATOM_STYLE_NOLABEL)))
      renderText( xd.at(i).pos.x,xd.at(i).pos.y,xd.at(i).pos.z, xd.at(i).Label);
  }
  glPopMatrix();
}

void EacGLW::initializeGL(){
  glEnable(GL_LINE_SMOOTH);  
  glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);

  timer = new QTimer(this);
  connect( timer, SIGNAL(timeout()),
          this, SLOT(update()) );
  timer->start(20);

  //glEnable(GL_POLYGON_SMOOTH);   
  myFont = QFont("Arial", 24, -1, false);
  myFont.setStyleStrategy(QFont::NoAntialias);
  const GLfloat  position[] = {100.0f, 100.0f,100.0f,0.0f};
  const GLfloat  diffuse[]  = { 1.0f, 1.0f, 1.0f, 1.0f };
  const GLfloat  specular[] = { 1.0f, 0.9f, 0.9f, 1.0f };
  const GLfloat  ambient[]  = { 0.4f, 0.4f, 0.4f, 1.0f };

  glLightModeli(  GL_LIGHT_MODEL_LOCAL_VIEWER, 1 );

  glLightfv( GL_LIGHT0, GL_POSITION, position );
  glLightfv( GL_LIGHT0, GL_AMBIENT,  ambient );
  glLightfv( GL_LIGHT0, GL_DIFFUSE,  diffuse );
  glLightfv( GL_LIGHT0, GL_SPECULAR, specular );

  glLightfv( GL_LIGHT1, GL_POSITION, position );
  glLightfv( GL_LIGHT1, GL_DIFFUSE,  diffuse );  
  glLightfv( GL_LIGHT1, GL_AMBIENT,  ambient );
  glLightModeli(  GL_LIGHT_MODEL_TWO_SIDE, 1);

  glLightfv( GL_LIGHT2, GL_DIFFUSE,  diffuse );  

  glLineWidth(2.0);
  QOpenGLTexture *hbtex = new QOpenGLTexture(QImage(QString(mol->theIconPath+"hbb.png")).mirrored());
  hbtex->bind();
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
  glEnable( GL_LIGHTING );
  glEnable( GL_LIGHT0 );
  glDisable(GL_BLEND);
  glAlphaFunc ( GL_GREATER, 0.01f ) ;
  glEnable(GL_ALPHA_TEST);
  glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
  const GLfloat  OBJ_SPE[]   = { 1.0f, 1.0f, 1.0f, 1.0f };  
  const GLfloat  OBJ_SHIN    = 127.0f;                   
  glMaterialfv( GL_FRONT_AND_BACK, GL_SPECULAR,             OBJ_SPE  );
  glEnable     ( GL_COLOR_MATERIAL ) ;
  glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE ) ;    
  glMaterialf(  GL_FRONT_AND_BACK, GL_SHININESS,           OBJ_SHIN );
  glShadeModel( GL_SMOOTH );
  glEnable(GL_NORMALIZE);
  glClearColor(0.4f,0.4f,0.4f,1.0f);
  glEnable(GL_DEPTH_TEST );
  glDepthFunc(GL_LEQUAL);
  gluLookAt_(0.0, 200, 50 ,   0.0, 0.0, 0.0,   0.0, -100, 400 );
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
  saveProgram=mol->g_Program;
  mol->g_Program=new QOpenGLShaderProgram(this);
  mol->g_program=mol->installShader();
}

void EacGLW::resizeGL(int width, int height){
    retinafktr=devicePixelRatio();// it qt5 this is in in qt6 its qreal!!
  glViewport(0, 0, width*retinafktr, height*retinafktr);
  glGetIntegerv(GL_VIEWPORT, vp);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  //FIXME
  gluPerspective_( 29.0, (double)width/height, 5.0, 8000.0 );
}

void EacGLW::paintGL(){
  GLenum err = GL_NO_ERROR;
  while((err = glGetError()) != GL_NO_ERROR)
  {
    printf("eac paintGL %s err=%X\n",glError2String(err).toStdString().c_str(),err);
    //printf("%s\n",(char*)gluErrorString(err));
  }
  glClearColor(backGroundColor.redF(), backGroundColor.greenF(), backGroundColor.blueF(), 1.0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glViewport(0, 0, QOpenGLWidget::width()*retinafktr, QOpenGLWidget::height()*retinafktr);
  glGetIntegerv(GL_VIEWPORT, vp);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective_( 29.0, (double)QOpenGLWidget::width()/QOpenGLWidget::height(), 5.0, 8000.0 );
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  draw();
  glPopMatrix();
}

void EacGLW::changeAtom(int OZ,bool HisD){
  xd[0].Label=(HisD)?QString("D"):mol->pse(OZ);
  xd[0].an=OZ;
  xd[1].Label=QString("%1(noADP)").arg(xd[0].Label);
  xd[1].an=OZ;
  //xd[1].ownStyle=true;
  //xd[1].style=ATOM_STYLE_NOADP;
  //xd[1].rad=mol->arad[OZ];
  //xd[1].color=mol->AtomColor[OZ];
  update();
}

void EacGLW::colorDLG(){
  QColor bgcolor;
  //printf("EacGLW::colorDLG()\n");
  bool hisd = (psew==NULL)?false:psew->HisD;
  bgcolor=QColorDialog::getColor(mol->atomColor(xd.at(0).an,hisd), this);
  if (bgcolor.isValid()) {
    if (hisd)
      mol->deuteriumColor=bgcolor;
    else
      mol->AtomColor[xd.at(0).an]=bgcolor;
    mol->AtomColor[xd.at(0).an].setAlpha(63);
    xd[1].an=xd.at(0).an;
    einstellung->beginGroup("Atoms");
    einstellung->beginWriteArray("AtomColors",107);
    for (int i = 0; i < 107; ++i) {
      einstellung->setArrayIndex(i);
      einstellung->setValue("Color", mol->AtomColor[i]);
    }
    einstellung->endArray();
    einstellung->endGroup();
    einstellung->sync();
    emit colorchanged(bgcolor);

  }
}


*/
void EacDlg::changeAtom(int OZ,bool HisD){
  mol->showatoms.first().Label=(HisD)?QString("D"):mol->pse(OZ);
  mol->showatoms.first().an=OZ;
  mol->showatoms[1].Label=QString("%1(noADP)").arg(mol->showatoms.first().Label);
  mol->showatoms[1].an=OZ;
  updateLEs(OZ,HisD);
  printf("changeAtom OZ%d\n",OZ);
  if (!pause4LE) emit statesChanged();
  //xd[1].ownStyle=true;
  //xd[1].style=ATOM_STYLE_NOADP;
  //xd[1].rad=mol->arad[OZ];
  //xd[1].color=mol->AtomColor[OZ];
  update();
}

void EacDlg::colorDLG(){
  QColor bgcolor;
  //printf("EacGLW::colorDLG()\n");
  int an = mol->showatoms.first().an;
  bool hisd = (psew==NULL)?false:psew->HisD;
  bgcolor=QColorDialog::getColor(mol->atomColor(an,hisd), this);
  if (bgcolor.isValid()) {
    if (hisd)
      mol->deuteriumColor=bgcolor;
    else
      mol->AtomColor[an]=bgcolor;
    mol->AtomColor[an].setAlpha(63);
    mol->showatoms[1].an=an;
    einstellung->beginGroup("Atoms");
    einstellung->beginWriteArray("AtomColors",107);
    for (int i = 0; i < 107; ++i) {
      einstellung->setArrayIndex(i);
      einstellung->setValue("Color", mol->AtomColor[i]);
    }
    einstellung->endArray();
    einstellung->endGroup();
    einstellung->sync();
    colorchange(bgcolor);    
    emit colorchanged(bgcolor);
  }
}


void EacDlg::colorchange(QColor bgcolor){
  colorbut->setStyleSheet(QString(
			  "QPushButton {"
			  "border: 1px solid #000000;"
			  "border-radius: 9px;"
			  "color: %4;"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
			  "}"
			  "QPushButton:hover {"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %2, stop: 0.5 %1, stop: 1 %2);"
			  "}"
			  "QPushButton:flat {"
			  "    border: none; /* no border for a flat push button */"
			  "}"
			  )
		  .arg(bgcolor.name())
		  .arg(bgcolor.darker(200).name())
		  .arg(bgcolor.lighter(200).name())
          .arg((bgcolor.value()<90)?"#ffffff":"#000000"));
  //printf("colorchange %s\n",bgcolor.name().toStdString().c_str());
  if (!pause4LE) emit statesChanged();
}

void EacDlg::colorDLG2(){
  QColor bgcolor;
  bgcolor = QColorDialog::getColor(mol->bondColor, this, "bond color", QColorDialog::ShowAlphaChannel);
  if (bgcolor.isValid()) {
    mol->bondColor=mol->bondColor=bgcolor;

    colorbut2->setStyleSheet(QString(
			    "QPushButton {"
			    "border: 1px solid #000000;"
			    "border-radius: 9px;"
			    "color: %4;"
			    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
			    "}"
			    "QPushButton:hover {"
			    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %2, stop: 0.5 %1, stop: 1 %2);"
			    "}"
			    "QPushButton:flat {"
			    "    border: none; /* no border for a flat push button */"
			    "}"
			    )
		    .arg(bgcolor.name())
		    .arg(bgcolor.darker(200).name())
		    .arg(bgcolor.lighter(200).name())
		    .arg((bgcolor.value()<90)?"#ffffff":"#000000"));

  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->endGroup();
  }
  update();
}

void EacDlg::colorDLGLabel(){
    QPushButton *but = qobject_cast<QPushButton *>(sender());
    qDebug()<<sender()<<but;
  QColor bgcolor;
  bgcolor = QColorDialog::getColor(mol->bondColor, this, "Label color", QColorDialog::ShowAlphaChannel);
  if (bgcolor.isValid()) {
    ogl->labelColor=bgcolor;
    if (but!=nullptr) {
        QString stsh=QString(
                    "QPushButton {"
                    "border: 1px solid #000000;"
                    "border-radius: 9px;"
                    "color: %1;"
                    "opacity: %2;"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                    "}"
                    "QPushButton:hover {"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                    "border: 0px"
                    "}"
                    "QPushButton:flat {"
                    "    border: none; /* no border for a flat push button */"
                    "}"
                    )
               .arg((bgcolor.value()<128)?"#ffffff":"#000000")//1
                .arg(bgcolor.alphaF(),0,'f')//2
                .arg(bgcolor.red())//3
                .arg(bgcolor.green())//4
                .arg(bgcolor.blue())//5
                .arg(bgcolor.alpha())//6
                .arg(bgcolor.darker(200).red())//7
                .arg(bgcolor.darker(200).green())//8
                .arg(bgcolor.darker(200).blue())//9
                .arg(bgcolor.lighter(200).red())//10
                .arg(bgcolor.lighter(200).green())//11
                .arg(bgcolor.lighter(200).blue());//12
        but->setStyleSheet(stsh);
  }
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->endGroup();

  storeColors();
  }
}

void EacDlg::colorDLGSLabel(){
    QPushButton *but = qobject_cast<QPushButton *>(sender());
  QColor bgcolor;
  bgcolor = QColorDialog::getColor(mol->bondColor, this, "Selected Label Color", QColorDialog::ShowAlphaChannel);
  if (bgcolor.isValid()) {
    ogl->selectedLabelColor=bgcolor;
    if (but!=nullptr){
        QString stsh=QString(
                    "QPushButton {"
                    "border: 1px solid #000000;"
                    "border-radius: 9px;"
                    "color: %1;"
                    "opacity: %2;"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                    "}"
                    "QPushButton:hover {"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                    "border: 0px"
                    "}"
                    "QPushButton:flat {"
                    "    border: none; /* no border for a flat push button */"
                    "}"
                    )
               .arg((bgcolor.value()<128)?"#ffffff":"#000000")//1
                .arg(bgcolor.alphaF(),0,'f')//2
                .arg(bgcolor.red())//3
                .arg(bgcolor.green())//4
                .arg(bgcolor.blue())//5
                .arg(bgcolor.alpha())//6
                .arg(bgcolor.darker(200).red())//7
                .arg(bgcolor.darker(200).green())//8
                .arg(bgcolor.darker(200).blue())//9
                .arg(bgcolor.lighter(200).red())//10
                .arg(bgcolor.lighter(200).green())//11
                .arg(bgcolor.lighter(200).blue());//12
        but->setStyleSheet(stsh);
    }
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->endGroup();

  storeColors();
  }
}

void EacDlg::colorDLGFLabel(){
    QPushButton *but = qobject_cast<QPushButton *>(sender());
  QColor bgcolor;
  bgcolor = QColorDialog::getColor(ogl->focusedLabelColor, this, "Focused Label Color", QColorDialog::ShowAlphaChannel);
  if (bgcolor.isValid()) {
    ogl->focusedLabelColor=bgcolor;
    if (but!=nullptr) {
        QString stsh=QString(
                    "QPushButton {"
                    "border: 1px solid #000000;"
                    "border-radius: 9px;"
                    "color: %1;"
                    "opacity: %2;"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                    "}"
                    "QPushButton:hover {"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                    "border: 0px"
                    "}"
                    "QPushButton:flat {"
                    "    border: none; /* no border for a flat push button */"
                    "}"
                    )
               .arg((bgcolor.value()<128)?"#ffffff":"#000000")//1
                .arg(bgcolor.alphaF(),0,'f')//2
                .arg(bgcolor.red())//3
                .arg(bgcolor.green())//4
                .arg(bgcolor.blue())//5
                .arg(bgcolor.alpha())//6
                .arg(bgcolor.darker(200).red())//7
                .arg(bgcolor.darker(200).green())//8
                .arg(bgcolor.darker(200).blue())//9
                .arg(bgcolor.lighter(200).red())//10
                .arg(bgcolor.lighter(200).green())//11
                .arg(bgcolor.lighter(200).blue());//12
        but->setStyleSheet(stsh);
  }
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->endGroup();

  storeColors();
  }
}



void EacDlg::bgColorDLGLabel(){
    QPushButton *but = qobject_cast<QPushButton *>(sender());
    qDebug()<<sender()<<but;
  QColor bgcolor;
  bgcolor = QColorDialog::getColor(ogl->labelBGColor, this, "Label color", QColorDialog::ShowAlphaChannel);
  if (bgcolor.isValid()) {
    ogl->labelBGColor=bgcolor;
    if (but!=nullptr) {
        QString stsh=QString(
                    "QPushButton {"
                    "border: 1px solid #000000;"
                    "border-radius: 9px;"
                    "color: %1;"
                    "opacity: %2;"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                    "}"
                    "QPushButton:hover {"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                    "border: 0px"
                    "}"
                    "QPushButton:flat {"
                    "    border: none; /* no border for a flat push button */"
                    "}"
                    )
               .arg((bgcolor.value()<128)?"#ffffff":"#000000")//1
                .arg(bgcolor.alphaF(),0,'f')//2
                .arg(bgcolor.red())//3
                .arg(bgcolor.green())//4
                .arg(bgcolor.blue())//5
                .arg(bgcolor.alpha())//6
                .arg(bgcolor.darker(200).red())//7
                .arg(bgcolor.darker(200).green())//8
                .arg(bgcolor.darker(200).blue())//9
                .arg(bgcolor.lighter(200).red())//10
                .arg(bgcolor.lighter(200).green())//11
                .arg(bgcolor.lighter(200).blue());//12
        but->setStyleSheet(stsh);
    }
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->endGroup();

  storeColors();
  }
}

void EacDlg::bgColorDLGSLabel(){
    QPushButton *but = qobject_cast<QPushButton *>(sender());
  QColor bgcolor;
  bgcolor = QColorDialog::getColor(ogl->selectedLabelBGColor, this, "Selected Label Color", QColorDialog::ShowAlphaChannel);
  if (bgcolor.isValid()) {
    ogl->selectedLabelBGColor=bgcolor;
    if (but!=nullptr) {
        QString stsh=QString(
                    "QPushButton {"
                    "border: 1px solid #000000;"
                    "border-radius: 9px;"
                    "color: %1;"
                    "opacity: %2;"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                    "}"
                    "QPushButton:hover {"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                    "border: 0px"
                    "}"
                    "QPushButton:flat {"
                    "    border: none; /* no border for a flat push button */"
                    "}"
                    )
               .arg((bgcolor.value()<128)?"#ffffff":"#000000")//1
                .arg(bgcolor.alphaF(),0,'f')//2
                .arg(bgcolor.red())//3
                .arg(bgcolor.green())//4
                .arg(bgcolor.blue())//5
                .arg(bgcolor.alpha())//6
                .arg(bgcolor.darker(200).red())//7
                .arg(bgcolor.darker(200).green())//8
                .arg(bgcolor.darker(200).blue())//9
                .arg(bgcolor.lighter(200).red())//10
                .arg(bgcolor.lighter(200).green())//11
                .arg(bgcolor.lighter(200).blue());//12
        but->setStyleSheet(stsh);
    }
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->endGroup();

  storeColors();
  }
}

void EacDlg::labelColorAlpha(int a){
      ogl->labelColor.setAlpha(a);
      QColor color = ogl->labelColor;
      QString stsh=QString(
                  "QPushButton {"
                  "border: 1px solid #000000;"
                  "border-radius: 9px;"
                  "color: %1;"
                  "opacity: %2;"
                  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                  "}"
                  "QPushButton:hover {"
                  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                  "border: 0px"
                  "}"
                  "QPushButton:flat {"
                  "    border: none; /* no border for a flat push button */"
                  "}"
                  )
             .arg((color.value()<128)?"#ffffff":"#000000")//1
              .arg(color.alphaF(),0,'f')//2
              .arg(color.red())//3
              .arg(color.green())//4
              .arg(color.blue())//5
              .arg(color.alpha())//6
              .arg(color.darker(200).red())//7
              .arg(color.darker(200).green())//8
              .arg(color.darker(200).blue())//9
              .arg(color.lighter(200).red())//10
              .arg(color.lighter(200).green())//11
              .arg(color.lighter(200).blue());//12
      colorbutlab->setStyleSheet(stsh);
      storeColors();
}
void EacDlg::slabelColorAlpha(int a){
    ogl->selectedLabelColor.setAlpha(a);
    QColor color = ogl->selectedLabelColor;
    QString stsh=QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %1;"
                "opacity: %2;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                "border: 0px"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
           .arg((color.value()<128)?"#ffffff":"#000000")//1
            .arg(color.alphaF(),0,'f')//2
            .arg(color.red())//3
            .arg(color.green())//4
            .arg(color.blue())//5
            .arg(color.alpha())//6
            .arg(color.darker(200).red())//7
            .arg(color.darker(200).green())//8
            .arg(color.darker(200).blue())//9
            .arg(color.lighter(200).red())//10
            .arg(color.lighter(200).green())//11
            .arg(color.lighter(200).blue());//12
    colorbutslab->setStyleSheet(stsh);
    storeColors();
}
void EacDlg::flabelColorAlpha(int a){
    ogl->focusedLabelColor.setAlpha(a);
    QColor color = ogl->focusedLabelColor;
    QString stsh=QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %1;"
                "opacity: %2;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                "border: 0px"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
           .arg((color.value()<128)?"#ffffff":"#000000")//1
            .arg(color.alphaF(),0,'f')//2
            .arg(color.red())//3
            .arg(color.green())//4
            .arg(color.blue())//5
            .arg(color.alpha())//6
            .arg(color.darker(200).red())//7
            .arg(color.darker(200).green())//8
            .arg(color.darker(200).blue())//9
            .arg(color.lighter(200).red())//10
            .arg(color.lighter(200).green())//11
            .arg(color.lighter(200).blue());//12
    colorbutflab->setStyleSheet(stsh);
    storeColors();
}
void EacDlg::labelBGColorAlpha(int a){
    ogl->labelBGColor.setAlpha(a);
    QColor color = ogl->labelBGColor;
    QString stsh=QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %1;"
                "opacity: %2;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                "border: 0px"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
           .arg((color.value()<128)?"#ffffff":"#000000")//1
            .arg(color.alphaF(),0,'f')//2
            .arg(color.red())//3
            .arg(color.green())//4
            .arg(color.blue())//5
            .arg(color.alpha())//6
            .arg(color.darker(200).red())//7
            .arg(color.darker(200).green())//8
            .arg(color.darker(200).blue())//9
            .arg(color.lighter(200).red())//10
            .arg(color.lighter(200).green())//11
            .arg(color.lighter(200).blue());//12
    bgcolorbutlab->setStyleSheet(stsh);
    storeColors();
}
void EacDlg::slabelBGColorAlpha(int a){
    ogl->selectedLabelBGColor.setAlpha(a);
    QColor color = ogl->selectedLabelBGColor;
    QString stsh=QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %1;"
                "opacity: %2;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                "border: 0px"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
           .arg((color.value()<128)?"#ffffff":"#000000")//1
            .arg(color.alphaF(),0,'f')//2
            .arg(color.red())//3
            .arg(color.green())//4
            .arg(color.blue())//5
            .arg(color.alpha())//6
            .arg(color.darker(200).red())//7
            .arg(color.darker(200).green())//8
            .arg(color.darker(200).blue())//9
            .arg(color.lighter(200).red())//10
            .arg(color.lighter(200).green())//11
            .arg(color.lighter(200).blue());//12
    bgcolorbutslab->setStyleSheet(stsh);
    storeColors();
}

void EacDlg::flabelBGColorAlpha(int a){
    ogl->focusedLabelBGColor.setAlpha(a);
    QColor color = ogl->focusedLabelBGColor;
    QString stsh=QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %1;"
                "opacity: %2;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                "border: 0px"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
           .arg((color.value()<128)?"#ffffff":"#000000")//1
            .arg(color.alphaF(),0,'f')//2
            .arg(color.red())//3
            .arg(color.green())//4
            .arg(color.blue())//5
            .arg(color.alpha())//6
            .arg(color.darker(200).red())//7
            .arg(color.darker(200).green())//8
            .arg(color.darker(200).blue())//9
            .arg(color.lighter(200).red())//10
            .arg(color.lighter(200).green())//11
            .arg(color.lighter(200).blue());//12
    bgcolorbutflab->setStyleSheet(stsh);
    storeColors();
}


void EacDlg::bgColorDLGFLabel(){
    QPushButton *but = qobject_cast<QPushButton *>(sender());
  QColor bgcolor;
  bgcolor = QColorDialog::getColor(ogl->focusedLabelBGColor, this, "Focused Label Color", QColorDialog::ShowAlphaChannel);
  if (bgcolor.isValid()) {
    ogl->focusedLabelBGColor=bgcolor;
    if (but!=nullptr) {
        QString stsh=QString(
                    "QPushButton {"
                    "border: 1px solid #000000;"
                    "border-radius: 9px;"
                    "color: %1;"
                    "opacity: %2;"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
                    "}"
                    "QPushButton:hover {"
                    "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
                    "border: 0px"
                    "}"
                    "QPushButton:flat {"
                    "    border: none; /* no border for a flat push button */"
                    "}"
                    )
               .arg((bgcolor.value()<128)?"#ffffff":"#000000")//1
                .arg(bgcolor.alphaF(),0,'f')//2
                .arg(bgcolor.red())//3
                .arg(bgcolor.green())//4
                .arg(bgcolor.blue())//5
                .arg(bgcolor.alpha())//6
                .arg(bgcolor.darker(200).red())//7
                .arg(bgcolor.darker(200).green())//8
                .arg(bgcolor.darker(200).blue())//9
                .arg(bgcolor.lighter(200).red())//10
                .arg(bgcolor.lighter(200).green())//11
                .arg(bgcolor.lighter(200).blue());//12
        but->setStyleSheet(stsh);
  }
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->endGroup();

  storeColors();
  }
}

void EacDlg::colorDLGenvidef(){
  QColor bgcolor;
  bgcolor=QColorDialog::getColor(mol->enviDefaultColor, this);
  if (bgcolor.isValid()) {
    mol->enviDefaultColor=mol->enviDefaultColor=bgcolor;

    colorbutEdf->setStyleSheet(QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %4;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %2, stop: 0.5 %1, stop: 1 %2);"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
            .arg(bgcolor.name())
            .arg(bgcolor.darker(200).name())
            .arg(bgcolor.lighter(200).name())
            .arg((bgcolor.value()<90)?"#ffffff":"#000000"));
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
  for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
  }
  einstellung->endArray();

  einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
  for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
  }
  einstellung->endArray();
  einstellung->endGroup();
  }
  update();
}

void EacDlg::colorDLGenvibon(){
  QColor bgcolor;
  bgcolor=QColorDialog::getColor(mol->enviBondColor, this);
  if (bgcolor.isValid()) {
    mol->enviBondColor=mol->enviBondColor=bgcolor;

    colorbutEbo->setStyleSheet(QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %4;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %2, stop: 0.5 %1, stop: 1 %2);"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
            .arg(bgcolor.name())
            .arg(bgcolor.darker(200).name())
            .arg(bgcolor.lighter(200).name())
            .arg((bgcolor.value()<90)?"#ffffff":"#000000"));
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);

  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);

  einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
  for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
  }
  einstellung->endArray();

  einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
  for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
  }
  einstellung->endArray();
  einstellung->endGroup();
  }
  update();
}

void EacDlg::colorDLGenvihbo(){
  QColor bgcolor;
  bgcolor=QColorDialog::getColor(mol->enviHBColor, this);
  if (bgcolor.isValid()) {
    mol->enviHBColor=mol->enviHBColor=bgcolor;

    colorbutEhb->setStyleSheet(QString(
                "QPushButton {"
                "border: 1px solid #000000;"
                "border-radius: 9px;"
                "color: %4;"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
                "}"
                "QPushButton:hover {"
                "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %2, stop: 0.5 %1, stop: 1 %2);"
                "}"
                "QPushButton:flat {"
                "    border: none; /* no border for a flat push button */"
                "}"
                )
            .arg(bgcolor.name())
            .arg(bgcolor.darker(200).name())
            .arg(bgcolor.lighter(200).name())
            .arg((bgcolor.value()<90)?"#ffffff":"#000000"));
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);

  einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
  for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
  }
  einstellung->endArray();

  einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
  for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
  }
  einstellung->endArray();
  einstellung->endGroup();
  }
  update();
}
/*
void EacGLW::wallA(int st){
  if (st) mol->AtomStyle[xd.at(0).an]|=ATOM_STYLE_WALLS;
  else if (mol->AtomStyle[xd.at(0).an]&ATOM_STYLE_WALLS) mol->AtomStyle[xd.at(0).an]-=ATOM_STYLE_WALLS;
  if (st==Qt::PartiallyChecked) mol->AtomStyle[xd.at(0).an]|=ATOM_STYLE_PLAID;
  else if (mol->AtomStyle[xd.at(0).an]&ATOM_STYLE_PLAID) mol->AtomStyle[xd.at(0).an]-=ATOM_STYLE_PLAID;

}

void EacGLW::ringA(int st){
  if (st==Qt::PartiallyChecked) mol->AtomStyle[xd.at(0).an]|=ATOM_STYLE_WHITERING;
  else if (mol->AtomStyle[xd.at(0).an]&ATOM_STYLE_WHITERING) mol->AtomStyle[xd.at(0).an]-=ATOM_STYLE_WHITERING;
  if (st) mol->AtomStyle[xd.at(0).an]|=ATOM_STYLE_RINGS;
  else if (mol->AtomStyle[xd.at(0).an]&ATOM_STYLE_RINGS) mol->AtomStyle[xd.at(0).an]-=ATOM_STYLE_RINGS;

}

void EacGLW::spheA(int st){
  if (st) mol->AtomStyle[xd.at(0).an]|=ATOM_STYLE_SPHERE;
  else if (mol->AtomStyle[xd.at(0).an]&ATOM_STYLE_SPHERE) mol->AtomStyle[xd.at(0).an]-=ATOM_STYLE_SPHERE;

}

void EacGLW::soldA(int st){
  if (st) {
    mol->AtomStyle[xd.at(0).an]|=ATOM_STYLE_SOLID;
  }
  else if (mol->AtomStyle[xd.at(0).an]&ATOM_STYLE_SOLID) mol->AtomStyle[xd.at(0).an]-=ATOM_STYLE_SOLID;

}
*/

void EacDlg::wallA(int st){
    int an = mol->showatoms.first().an;
  if (st) mol->AtomStyle[an]|=ATOM_STYLE_WALLS;
  else if (mol->AtomStyle[an]&ATOM_STYLE_WALLS) mol->AtomStyle[an]-=ATOM_STYLE_WALLS;
  if (st==Qt::PartiallyChecked) mol->AtomStyle[an]|=ATOM_STYLE_PLAID;
  else if (mol->AtomStyle[an]&ATOM_STYLE_PLAID) mol->AtomStyle[an]-=ATOM_STYLE_PLAID;
  //printf("wallA state %d\n",st);
  if (!pause4LE) emit statesChanged();
}

void EacDlg::ringA(int st){
    int an = mol->showatoms.first().an;
  if (st==Qt::PartiallyChecked) mol->AtomStyle[an]|=ATOM_STYLE_WHITERING;
  else if (mol->AtomStyle[an]&ATOM_STYLE_WHITERING) mol->AtomStyle[an]-=ATOM_STYLE_WHITERING;
  if (st) mol->AtomStyle[an]|=ATOM_STYLE_RINGS;
  else if (mol->AtomStyle[an]&ATOM_STYLE_RINGS) mol->AtomStyle[an]-=ATOM_STYLE_RINGS;
  //printf("ringlA state %d\n",st);
  if (!pause4LE) emit statesChanged();
}

void EacDlg::spheA(int st){
    int an = mol->showatoms.first().an;
  if (st) mol->AtomStyle[an]|=ATOM_STYLE_SPHERE;
  else if (mol->AtomStyle[an]&ATOM_STYLE_SPHERE) mol->AtomStyle[an]-=ATOM_STYLE_SPHERE;
  //printf("spheA state %d\n",st);
  if (!pause4LE) emit statesChanged();
}

void EacDlg::soldA(int st){
    int an = mol->showatoms.first().an;
  if (st) {
    mol->AtomStyle[an]|=ATOM_STYLE_SOLID;
  }
  else if (mol->AtomStyle[an]&ATOM_STYLE_SOLID) mol->AtomStyle[an]-=ATOM_STYLE_SOLID;
  //printf("soldA state %d\n",st);
  if (!pause4LE) emit statesChanged();
}



void EacDlg::woADP(bool b){
  walbx->setDisabled(b);
  rinbx->setDisabled(b);
  sphbx->setDisabled(b);
  sldbx->setDisabled(b);
  if (b) {
    mol->AtomStyle[mol->showatoms.first().an]|=ATOM_STYLE_NOADP;
    sldbx->setChecked(b);
  }
  else
    if (mol->AtomStyle[mol->showatoms.first().an]&ATOM_STYLE_NOADP)
      mol->AtomStyle[mol->showatoms.first().an]-=ATOM_STYLE_NOADP;

  //printf("woADP state %d OZ %d\n",b,mol->showatoms.first().an);
  if (!pause4LE) emit statesChanged();
}

void EacDlg::whitA(int st){
  if (st) {
    mol->AtomStyle[mol->showatoms.first().an]|=ATOM_STYLE_WHITERING;
  }
  else if (mol->AtomStyle[mol->showatoms.first().an]&ATOM_STYLE_WHITERING) mol->AtomStyle[mol->showatoms.first().an]-=ATOM_STYLE_WHITERING;
  //printf("whitA state %d\n",st);
  if (!pause4LE) emit statesChanged();
}

void EacDlg::nolaA(int st){
  if (st) {
    mol->AtomStyle[mol->showatoms.first().an]|=ATOM_STYLE_NOLABEL;
  }
  else if (mol->AtomStyle[mol->showatoms.first().an]&ATOM_STYLE_NOLABEL) mol->AtomStyle[mol->showatoms.first().an]-=ATOM_STYLE_NOLABEL;
  //printf("nolaA state %d\n",st);
  if (!pause4LE) emit statesChanged();
}

void EacDlg::metalA(int st){
  if (st) {
    mol->AtomStyle[mol->showatoms.first().an]|=ATOM_STYLE_METAL;
  }
  else if (mol->AtomStyle[mol->showatoms.first().an]&ATOM_STYLE_METAL) mol->AtomStyle[mol->showatoms.first().an]-=ATOM_STYLE_METAL;
  //printf("metalA state %d\n",st);
  if (!pause4LE) emit statesChanged();
}



void EacDlg::checkWall(){
  if (sldbx->checkState()&&(walbx->checkState()))walbx->setCheckState(Qt::Unchecked); 
  //printf("checkWall\n");
  if (!pause4LE) emit statesChanged();
}

void EacDlg::checkSolid(){
  if (sldbx->checkState()&&(walbx->checkState()))sldbx->setCheckState(Qt::Unchecked);
  //printf("checkSolid\n");
  if (!pause4LE) emit statesChanged();
}

void EacDlg::checkBall(){
  if (sphbx->checkState())
      sldbx->setEnabled(true);
  else
      sldbx->setEnabled(false);
  //printf("checkBall\n");
  if (!pause4LE) emit statesChanged();
}

void EacDlg::updateLEs(int OZ,bool HisD){
    //printf("updateLEs %d ; H is D%d\n",OZ,HisD);
  int an = OZ;
  pause4LE = true;
  eacKRAD->setValue(mol->Kovalenz_Radien[an]/100.0);
  eacRAD->setValue(mol->arad[an]);

  rinbx->setCheckState((mol->AtomStyle[an]&ATOM_STYLE_RINGS)?((mol->AtomStyle[OZ]&ATOM_STYLE_WHITERING)?Qt::PartiallyChecked :Qt::Checked):Qt::Unchecked);
  sphbx->setCheckState((mol->AtomStyle[an]&ATOM_STYLE_SPHERE)?Qt::Checked:Qt::Unchecked);
  sldbx->setCheckState((mol->AtomStyle[an]&ATOM_STYLE_SOLID)?Qt::Checked:Qt::Unchecked);

  walbx->setCheckState((mol->AtomStyle[an]&ATOM_STYLE_WALLS)?((mol->AtomStyle[OZ]&ATOM_STYLE_PLAID)?Qt::PartiallyChecked: Qt::Checked):Qt::Unchecked);
  nlabx->setCheckState((mol->AtomStyle[an]&ATOM_STYLE_NOLABEL)?Qt::Checked:Qt::Unchecked);
  metalic->setCheckState((mol->AtomStyle[an]&ATOM_STYLE_METAL)?Qt::Checked:Qt::Unchecked);
  noadp->setChecked((mol->AtomStyle[an]&ATOM_STYLE_NOADP)?true:false);
  woADP(noadp->isChecked());
  QColor colr=mol->atomColor(an,HisD);

  colorbut->setStyleSheet(QString(
			  "QPushButton {"
			  "border: 1px solid #000000;"
			  "border-radius: 9px;"
			  "color: %4;"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
			  "}"
			  "QPushButton:hover {"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %2, stop: 0.5 %1, stop: 1 %2);"
			  "}"
			  "QPushButton:flat {"
			  "    border: none; /* no border for a flat push button */"
			  "}"
			  )
          .arg( colr.name())
          .arg( colr.darker(200).name())
          .arg( colr.lighter(200).name())
          .arg((colr.value()<90)?"#ffffff":"#000000"));

  pause4LE = false;
  emit statesChanged();
  update();
}

void EacDlg::probaChanged(int ix){
  mol->proba=eacProba->itemData(ix).toInt() ;
  //printf("probaChanged %d\n",ix);
  if (!pause4LE) emit statesChanged();
  update();
}

void EacDlg::unicolor(bool b){
  mol->bondColor = mol->bondColor;
  mol->bondColorStyle=mol->bondColorStyle=(b)?1:0;
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);

  einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
  for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
  }
  einstellung->endArray();

  einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
  for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
  }
  einstellung->endArray();

  einstellung->endGroup();
  //printf("unicolor %d\n",b);
  if (!pause4LE) emit statesChanged();

  update();

}

void EacDlg::strengthChanged(double d){
  mol->bondStrength=d;
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);

  einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
  for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
  }
  einstellung->endArray();

  einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
  for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
  }
  einstellung->endArray();
  einstellung->endGroup();  
  //printf("strengthChanged %f\n",d);
  if (!pause4LE) emit statesChanged();
  update();
}

void EacDlg::qStrengthChanged(double d){
  mol->q_bondWidth=d;
  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("Q-BondStrength",mol->q_bondWidth);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);

  einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
  for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
  }
  einstellung->endArray();

  einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
  for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
  }
  einstellung->endArray();
  einstellung->endGroup();
  //printf("qStrengthChanged %f\n",d);
  if (!pause4LE) emit statesChanged();
  update();
}


void EacDlg::QPeakRadChanged(double d){
mol->qPeakRad=mol->qPeakRad=d;
  einstellung->beginGroup("QPeaks");
  einstellung->setValue("QPeaksRadius",mol->qPeakRad);
  einstellung->endGroup();
  //printf("QPeakRadChanged %f\n",d);
  if (!pause4LE) emit statesChanged();
//settings...
update();	
}

void EacDlg::lodChanged(int d){
  ogl->setLOD(d);
  mol->LOD = d;
  einstellung->beginGroup("Window");
  einstellung->setValue("LevelOfDetail",mol->LOD);
  einstellung->endGroup();
  //printf("lodChaged %d\n",d);
  if (!pause4LE) emit statesChanged();
  update();
}

void EacDlg::importSettings(){

    //printf("createOGL %d\n",__LINE__);
  einstellung->beginGroup("Files");
  QString dn=einstellung->value("lastFile").toString();
  einstellung->endGroup();
  if (!dn.isEmpty()) {
    dn.replace(QRegularExpression(".ins$"),".ini");
    dn.replace(QRegularExpression(".res$"),".ini");
  }
  QString fn = QFileDialog::getOpenFileName (this,"Exporting atom style settings...",dn,"Settings (*.ini)");
  if (fn.isNull())return;
  QSettings *eaSettings = new QSettings(fn,QSettings::IniFormat);

  //-------------------------
  //
  eaSettings->beginGroup("Atoms");
  int ri=eaSettings->beginReadArray("CovaleceRadii");
  for (int i = 0; i < ri; ++i) {
    eaSettings->setArrayIndex(i);
    mol->Kovalenz_Radien[i]=eaSettings->value("Radius").toInt();
  }
  eaSettings->endArray();

  ri = eaSettings->beginReadArray("BallRadii");
  for (int i = 0; i < ri; ++i) {
    eaSettings->setArrayIndex(i);
    mol->arad[i]=eaSettings->value("Radius").toDouble();
  }
  eaSettings->endArray();
  ri = eaSettings->beginReadArray("AtomStyles");
  for (int i = 0; i < ri; ++i) {
    eaSettings->setArrayIndex(i);
   mol->AtomStyle[i]=eaSettings->value("Style" ).toInt();
  }
  eaSettings->endArray();
  ri = eaSettings->beginReadArray("AtomColors");
  for (int i = 0; i < ri; ++i) {
    eaSettings->setArrayIndex(i);
    mol->AtomColor[i]=eaSettings->value("Color").value<QColor>();
    mol->AtomColor[i].setAlphaF(0.25);
  }
  eaSettings->endArray();
  eaSettings->endGroup();

  eaSettings->beginGroup("Bonds");
  mol->bondColor = eaSettings->value("BondColor").value<QColor>();
  mol->bondColorStyle = eaSettings->value("BondStyle").toInt();;
  mol->bondStrength = eaSettings->value("BondStrength").toDouble();

  mol->enviBondColor=eaSettings->value("enviBondColor",QColor(Qt::darkGreen)).value<QColor>();
  mol->enviHBColor=eaSettings->value("enviHBColor",QColor(Qt::darkYellow)).value<QColor>();
  mol->enviDefaultColor=eaSettings->value("enviDefaultColor",QColor(Qt::black)).value<QColor>();
  
  eaSettings->endGroup();
  delete eaSettings;

  //
  einstellung->beginGroup("Atoms");
  einstellung->beginWriteArray("CovaleceRadii",95);
  for (int i = 0; i < 95; ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Radius", mol->Kovalenz_Radien[i]);
  }
  einstellung->endArray();

  einstellung->beginWriteArray("BallRadii");
  for (int i = 0; i < 109; ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Radius",mol->arad[i]);
  }
  einstellung->endArray();
  einstellung->beginWriteArray("AtomStyles",107);
  for (int i = 0; i < 107; ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Style", mol->AtomStyle[i]);
  }
  einstellung->endArray();
  int asel=psew->selection; 
  einstellung->beginWriteArray("AtomColors",107);
  for (int i = 0; i < 107; ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Color", mol->AtomColor[i]);
    psew->selection=i;
    psew->colorchange(mol->atomColor(i));
  }
  psew->selection=asel;
  einstellung->endArray();
  einstellung->endGroup();

  einstellung->beginGroup("Bonds");
  einstellung->setValue("BondColor",mol->bondColor);
  einstellung->setValue("BondStyle",mol->bondColorStyle);
  einstellung->setValue("BondStrength",mol->bondStrength);
  einstellung->setValue("enviBondColor",mol->enviBondColor);
  einstellung->setValue("enviHBColor",mol->enviHBColor);
  einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);
  einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
  for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
  }
  einstellung->endArray();

  einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
  for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
  }
  einstellung->endArray();

  einstellung->endGroup();
  //--------------------------------------
}

void EacDlg::exportSettings(){
  einstellung->beginGroup("Files");
  QString dn=einstellung->value("lastFile").toString();
  einstellung->endGroup();
  if (!dn.isEmpty()) {
    dn.replace(QRegularExpression(".ins$"),".ini");
    dn.replace(QRegularExpression(".res$"),".ini");
  }
  QString fn = QFileDialog::getSaveFileName (this,"Exporting atom style settings...",dn,"Settings (*.ini)");
  QSettings *eaSettings = new QSettings(fn,QSettings::IniFormat);
  //-------------------------
  //
  eaSettings->beginGroup("Atoms");
  eaSettings->beginWriteArray("CovaleceRadii",95);
  for (int i = 0; i < 95; ++i) {
    eaSettings->setArrayIndex(i);
    eaSettings->setValue("Radius", mol->Kovalenz_Radien[i]);
  }
  eaSettings->endArray();

  eaSettings->beginWriteArray("BallRadii");
  for (int i = 0; i < 109; ++i) {
    eaSettings->setArrayIndex(i);
    eaSettings->setValue("Radius",mol->arad[i]);
  }
  eaSettings->endArray();
  eaSettings->beginWriteArray("AtomStyles",107);
  for (int i = 0; i < 107; ++i) {
    eaSettings->setArrayIndex(i);
    eaSettings->setValue("Style", mol->AtomStyle[i]);
  }
  eaSettings->endArray();
  eaSettings->beginWriteArray("AtomColors",107);
  for (int i = 0; i < 107; ++i) {
    eaSettings->setArrayIndex(i);
    eaSettings->setValue("Color", mol->AtomColor[i]);
  }
  eaSettings->endArray();
  eaSettings->endGroup();

  eaSettings->beginGroup("Bonds");
  eaSettings->setValue("BondColor",mol->bondColor);
  eaSettings->setValue("BondStyle",mol->bondColorStyle);
  eaSettings->setValue("BondStrength",mol->bondStrength);
  eaSettings->setValue("enviBondColor",mol->enviBondColor);
  eaSettings->setValue("enviHBColor",mol->enviHBColor);
  eaSettings->setValue("enviDefaultColor",mol->enviDefaultColor);

  eaSettings->setValue("HBondMaxDist",mol->hbdist());
  eaSettings->value("HBondMaxAng",mol->hbangl());
  eaSettings->endGroup();
  delete eaSettings;
  //--------------------------------------
  //
}

void EacDlg::kradChanged(double d){
  mol->Kovalenz_Radien[psew->selection]=mol->Kovalenz_Radien[psew->selection]=(int)(d*100);
  einstellung->beginGroup("Atoms");
  einstellung->beginWriteArray("CovaleceRadii",95);
  for (int i = 0; i < 95; ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Radius", mol->Kovalenz_Radien[i]);
  }
  einstellung->endArray();
  einstellung->endGroup();
  einstellung->sync();
  //printf("kradChanged %f\n",d);
  if (!pause4LE) emit statesChanged();
  update();
}

void EacDlg::hbdistChanged(double d){
    einstellung->beginGroup("Bonds");
    mol->setHBondMaxDist(eacHBDist->value());
    einstellung->setValue("HBondMaxDist",eacHBDist->value());
    mol->setHBondMaxAngl(eacHBAngl->value());
    einstellung->setValue("HBondMaxAng",eacHBAngl->value());
    einstellung->endGroup();
    einstellung->sync();
    //printf("hbdistChanged %f\n",d);
    if (!pause4LE) emit statesChanged();
    update();
}

void EacDlg::updateHBElemnts(){
    //printf("updateHBElemnts\n");
    QStringList accst=accLE->text().simplified().split(",",skipEmptyParts);
    mol->theseAreAcceptors.clear();
    for (int i=0; i<accst.size();i++){
        int an=mol->getOZ(accst.at(i));
        if (an>=0) mol->theseAreAcceptors.append(an);
    }
    QStringList donst=donLE->text().simplified().split(",",skipEmptyParts);
    mol->theseAreDonors.clear();
    for (int i=0; i<donst.size();i++){
        int an=mol->getOZ(donst.at(i));
        if (an>=0) mol->theseAreDonors.append(an);
    }
    donst.clear();
    for (int i=0; i<mol->theseAreDonors.size(); i++) donst.append(mol->pse(mol->theseAreDonors.at(i)));
    donLE->setText(donst.join(","));
    accst.clear();
    for (int i=0; i<mol->theseAreAcceptors.size(); i++) accst.append(mol->pse(mol->theseAreAcceptors.at(i)));
    accLE->setText(accst.join(","));

    einstellung->beginGroup("Bonds");
    einstellung->setValue("BondColor",mol->bondColor);
    einstellung->setValue("BondStyle",mol->bondColorStyle);
    einstellung->setValue("BondStrength",mol->bondStrength);
    einstellung->setValue("enviBondColor",mol->enviBondColor);
    einstellung->setValue("enviHBColor",mol->enviHBColor);
    einstellung->setValue("enviDefaultColor",mol->enviDefaultColor);

    einstellung->beginWriteArray("HBondDonors",mol->theseAreDonors.size());
    for (int i = 0; i < mol->theseAreDonors.size(); ++i) {
      einstellung->setArrayIndex(i);
      einstellung->setValue("Element",mol->pse(mol->theseAreDonors.at(i)));
    }
    einstellung->endArray();

    einstellung->beginWriteArray("HBondAcceptors",mol->theseAreAcceptors.size());
    for (int i = 0; i < mol->theseAreAcceptors.size(); ++i) {
      einstellung->setArrayIndex(i);
      einstellung->setValue("Element",mol->pse(mol->theseAreAcceptors.at(i)));
    }
    einstellung->endArray();
    einstellung->endGroup();
    //printf("updateHBElemnts \n");
    if (!pause4LE) emit statesChanged();
}

void EacDlg::hbanglChanged(double d){
    einstellung->beginGroup("Bonds");
    mol->setHBondMaxDist(eacHBDist->value());
    einstellung->setValue("HBondMaxDist",eacHBDist->value());
    mol->setHBondMaxAngl(eacHBAngl->value());
    einstellung->setValue("HBondMaxAng",eacHBAngl->value());
    einstellung->endGroup();
    einstellung->sync();
    //printf("hbanglChanged %f\n",d);
    if (!pause4LE) emit statesChanged();
    update();
}

void EacDlg::radChanged(double d){

  mol->arad[psew->selection] = mol->arad[psew->selection] = d;
  //eacGLW->xd[1].rad=d;
  einstellung->beginGroup("Atoms");

  einstellung->beginWriteArray("BallRadii");
  for (int i = 0; i < 109; ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Radius",mol->arad[i]);
  }
  einstellung->endArray();
  einstellung->endGroup();
  einstellung->sync();
  //printf("radChanged %f\n",d);
  if (!pause4LE) emit statesChanged();
  update();
}

void EacDlg::createOGL(){
    ogl = new PlayOpenGL(mol);

    //ogl->setParent(this);
    ogl->setMinimumWidth(510);
    ogl->fVertexes.resize(28);
    ogl->fNormals.resize(28);
    qpv = new QPeakView(this);
    qpv->setMinimumWidth(50);
    ogl->rotze=0;

    connect(qpv, SIGNAL(cutOffChanged(double)), ogl, SLOT(setQpeakCutoff(double)));
    connect(qpv,SIGNAL(findQP(double)),ogl,SLOT(highliteQPeak(double)));
    connect(ogl,SIGNAL(qpfoci(double)),qpv,SLOT(qpeaksInFocus(double)));

    qpv->dark=false;
    qpv->update();
    //printf("createOGL %d\n",__LINE__);

    //QToolBar *vito;
    //printf("theIconPath='%s'\n",theIconPath.toStdString().c_str());
    vito = new QToolBar(this);
    ogl->sfacMenu   = new QMenu(tr("Change element to..."));
    ogl->selSfacMenu = new QMenu(tr("Change elements of selection to..."));
    QAction *a = ogl->h_bonds = vito->addAction(QIcon(theIconPath+"hbrs.svg"),"Toggle H-bonds");
    ogl->h_bonds->setCheckable(true);
    ogl->h_bonds->setChecked(true);
    connect(a,SIGNAL(triggered(bool)), ogl,SLOT(update()));

    a=ogl->adp=new QAction(QIcon(theIconPath+"adp.svg"),"ADP");
    vito->addAction(ogl->adp);
    ogl->adp->setCheckable(true);
    ogl->adp->setChecked(true);

    connect(a,SIGNAL(triggered(bool)), ogl,SLOT(update()));
    a = new QAction(QIcon(theIconPath+"bonds.svg"), "Toggle Bonds");
    a->setCheckable(true);
    a->setChecked(true);
    connect(a,SIGNAL(toggled(bool)), ogl, SLOT(setBonds(bool)));
    connect(a,SIGNAL(triggered(bool)), ogl,SLOT(update()));
    vito->addAction(a);
    a=new QAction(QIcon(theIconPath+"labels.svg"), "Toggle Labels");
    a->setCheckable(true);
    a->setChecked(true);
    connect(a,SIGNAL(toggled(bool)), ogl, SLOT(setLabels(bool)));
    connect(a,SIGNAL(triggered(bool)), ogl,SLOT(update()));
    vito->addAction(a);
    ogl->tubes=new QAction(QIcon(theIconPath+"tubes.svg"),"tubes");
    ogl->tubes->setCheckable(true);
    ogl->tubes->setChecked(false);

    connect(ogl->tubes,SIGNAL(triggered(bool)), ogl,SLOT(update()));

    vito->addAction(ogl->tubes);
    ogl->ballStick=new QAction(QIcon(theIconPath+"ballstick.svg"),"ballstick");
    ogl->ballStick->setCheckable(true);
    ogl->ballStick->setChecked(true);
    vito->addAction(ogl->ballStick);
    connect(ogl->ballStick,SIGNAL(triggered(bool)), ogl,SLOT(update()));

    QActionGroup *tubeGroup = new QActionGroup(this);
    tubeGroup->addAction(ogl->tubes);
    tubeGroup->addAction(ogl->ballStick);
    ogl->QPeakLegend=new QAction(QIcon(theIconPath+"qlegend.svg"),"qpeaklegend");
    vito->addAction(ogl->QPeakLegend);
    ogl->QPeakLegend->setCheckable(true);
    ogl->QPeakLegend->setChecked(true);
    connect(ogl->QPeakLegend,SIGNAL(toggled(bool)), qpv, SLOT(setVisible(bool)));
    ogl->hideHydrogen=new QAction(QIcon(theIconPath+"hideh.svg"),"hide h");
    connect(ogl->hideHydrogen,SIGNAL(triggered(bool)), ogl, SLOT(hideHydrogens()));

    vito->addAction(ogl->hideHydrogen);
    ogl->addBond=new QAction("add bond");
    ogl->killBond=new QAction("kill bond");
    ogl->clearSelection=new QAction("clear select");
    ogl->centerSelection=new QAction("center select");
    ogl->hideNotSelection=new QAction("hide not select");
    ogl->unhide=new QAction(QIcon(theIconPath+"show.svg"),"unhide");
    vito->addAction(ogl->unhide);
    connect(ogl->unhide,SIGNAL(triggered(bool)), ogl, SLOT(showHidden()));
    ogl->invhide=new QAction("invert hide");
    //vito->addAction(ogl->invhide);
    //printf("createOGL %d\n",__LINE__);
    ogl->grow=new QAction("grow");
    //vito->addAction(ogl->grow);
    ogl->fuse=new QAction("fuse");
    //vito->addAction(ogl->fuse);
    ogl->shpm1=new QAction(QIcon(theIconPath+"part-1.svg"),"show part -n");
    vito->addAction(ogl->shpm1);    
    connect(ogl->shpm1,SIGNAL(triggered(bool)), ogl,SLOT(update()));
    ogl->qPeakBonds=new QAction(QIcon(theIconPath+"qbond.svg"),"q peak bonds");
    ogl->qPeakBonds->setCheckable(true);
    ogl->qPeakBonds->setChecked(true);
    vito->addAction(ogl->qPeakBonds);
    ogl->qPeakBonds->setCheckable(true);
    ogl->qPeakBonds->setChecked(true);
    ogl->toggleDockWidgets=new QAction("tog doc widgets");
    //vito->addAction(ogl->toggleDockWidgets);
    ogl->delSelAt=new QAction("delete selected atoms");
    //vito->addAction(ogl->delSelAt);
    ogl->highlightParts=new QAction(QIcon(theIconPath+"parts.svg"),"highlight parts");
    ogl->highlightParts->setCheckable(true);
    ogl->highlightParts->setChecked(true);

    connect(ogl->highlightParts,SIGNAL(triggered(bool)), ogl,SLOT(update()));
    vito->addAction(ogl->highlightParts);
    a=ogl->centroid=new QAction("centroid");
    connect(a,SIGNAL(triggered(bool)), ogl,SLOT(update()));
    //vito->addAction(ogl->centroid);
    ogl->enviNoQ=new QAction("envi no q");
    //vito->addAction(ogl->enviNoQ);
    ogl->enviCova=new QAction("envi covalent");
    //vito->addAction(ogl->enviCova);
    ogl->invSelection=new QAction("invert selection");
    //vito->addAction(ogl->invSelection);
    ogl->cntrPlot=new QAction("contour plot");
    //vito->addAction(ogl->cntrPlot);
    ogl->nocntrPlot=new QAction("no contour plot");
    //vito->addAction(ogl->nocntrPlot);
    ogl->rainbowPlot=new QAction("rainbow contour plot");
    //vito->addAction(ogl->rainbowPlot);
    ogl->togUnit=new QAction("unit cell");
    ogl->toggleOrthoView=new QAction("toggle ortho view");
    //vito->addAction(ogl->toggleOrthoView);
    a=ogl->hideBeLo=new QAction(QIcon(theIconPath+"ideal.svg"),"hide bede lone objects");
    ogl->hideBeLo->setCheckable(true);
    ogl->hideBeLo->setChecked(true);
    vito->addAction(ogl->hideBeLo);

    connect(a,SIGNAL(triggered(bool)), ogl,SLOT(update()));
    ogl->shortLabels=new QAction("short labels");
    ogl->shortLabels->setCheckable(true);
    ogl->shortLabels->setChecked(false);
    //vito->addAction(ogl->shortLabels);
    ogl->atomLegend=new QAction("atom legend");
    //vito->addAction(ogl->atomLegend);
    //printf("createOGL %d\n",__LINE__);
    einstellung->beginGroup("Colors");
    ogl->backGroundColor=einstellung->value("BackGroundColor",QColor("lightskyblue")).value<QColor>();
    ogl->labelColor=einstellung->value("LabelColor").value<QColor>();

    ogl->backGroundColor=einstellung->value("BackGroundColor",QColor("lightskyblue")).value<QColor>();
    ogl->labelColor=einstellung->value("LabelColor").value<QColor>();
    ogl->labelBGColor         = einstellung->value("LabelBGColor",         QColor(0,0,0,0)).value<QColor>();
    ogl->focusedLabelBGColor  = einstellung->value("focusedLabelBGColor",  QColor(0,0,0,10)).value<QColor>();
    ogl->focusedLabelColor    = einstellung->value("focusedLabelColor",    QColor(255,255,0,255)).value<QColor>();
    ogl->selectedLabelBGColor = einstellung->value("selectedLabelBGColor", QColor(0,0,0,51)).value<QColor>();
    ogl->selectedLabelColor   = einstellung->value("selectedLabelColor",   QColor(135, 206, 235 ,255)).value<QColor>();

    einstellung->endGroup();

    einstellung->beginGroup("Window");
    if (einstellung->contains("ShortLabels"))
      ogl->shortLabels->setChecked(einstellung->value("ShortLabels").toBool());
    /*
    QAction  *togBackGr = new QAction("Toggle Background Gradient");
    togBackGr->setCheckable(true);
    togBackGr->setChecked(true);
    togBackGr->setShortcut(QKeySequence("F6"));
    connect(togBackGr,SIGNAL(toggled(bool)),ogl, SLOT(setBGGradient(bool)));
    if (einstellung->contains("BackGroundGradient"))
        togBackGr->setChecked(einstellung->value("BackGroundGradient").toBool());
    ogl->setBGGradient(togBackGr->isChecked());
    */
    einstellung->endGroup();

    connect(ogl, SIGNAL(initialized()), this, SLOT(makedemomol()));
    //xd[0].an=0;//das ist ein ... trick um bindungen vom zentralatom zu den liganden zu erzeugen.
}
void EacDlg::makedemomol(){

    printf("makedemomol line %d\n",__LINE__);

    QFile f(QString(":/shaders/%1").arg(demoMoleculeBox->currentData().toString()));
    //QFile f("C:/_DEV/branch/qt6/shaders/example7.shelxle");
    //QFile f("C:/_DEV/branch/qt6/shaders/aceclofenac.shelxle");
    //QFile f("C:/_DEV/branch/qt6/shaders/mo_sample1.shelxle");
    //QFile f("C:/_DEV/branch/qt6/shaders/vino_0m.shelxle");
    //QFile f("C:/_DEV/branch/qt6/shaders/testmol1.shelxle");

    demo.clear();
    f.open(QIODevice::Text|QIODevice::ReadOnly);
    QList<QByteArray> all = f.readAll().split('\n');
    MyAtom xda;
    for (int i=0; i<all.size();i++){
        xda = mol->fromAtomString(QString::fromLatin1(all.at(i)));
        if (xda.an>-81) demo.append(xda);
    }

    demo[1].isIso = true;
    demo[1].Label = QString("%1(_noADP)").arg(demo.first().Label);
    demo[1].style = ATOM_STYLE_NOADP|ATOM_STYLE_NOADP;
    //printf("make bonds\n");
    mol->showatoms=demo;
    mol->pmin=1000.0;
    mol->pmax=-1000.0;
    for (int i=0; i<demo.size(); i++){
       if (demo.at(i).an==-1) {
           mol->pmax=qMax(demo.at(i).peakHeight,mol->pmax);
           mol->pmin=qMin(demo.at(i).peakHeight,mol->pmin);
       }
    }

    qpv->setMin(mol->pmin);
    qpv->setMax(mol->pmax);
    changeAtom(5,false);
    ogl->updateBondActions();
    ogl->updateSceenAtoms();
    eacGLO->addWidget(ogl->enviButt,1,4,1,1);
    eacGLO->addWidget(ogl->enviSelect,1,5,1,1);
    if (timer==nullptr){
        timer = new QTimer(this);
        connect( timer, SIGNAL(timeout()),
            ogl, SLOT(rotY()) );
    }
    if (idlerot->isChecked()) timer->start(20);
}

EacDlg::EacDlg(Molecule *externMole){
  mol=externMole;
  exmol = mol->showatoms;
  exbond = mol->showbonds;
  //printf(PROGRAM_NAME "my new name is:%s:\n",mol->mynewnameis.toStdString().c_str());
  if (mol->mynewnameis.startsWith("shelXle")){
      theIconPath=QString(":/xle-icons/");
  }else{
      theIconPath=QString(":/bicons/");
  }
  setObjectName("Edit Atom Parameters Dialog");
  einstellung = new QSettings( QSettings::IniFormat, QSettings::UserScope ,PROGRAM_NAME,mol->mynewnameis ,this);
  setWindowTitle("Edit Atom Parameters");
  createOGL();

  //printf("? %d\n",__LINE__);
  eacGLO = new QGridLayout; 
  //eacCB = new QComboBox;
  eacRAD = new QDoubleSpinBox();
  eacKRAD = new QDoubleSpinBox();
  eacHBDist = new QDoubleSpinBox();
  eacHBAngl = new QDoubleSpinBox();
  QLabel *rad =new QLabel("Sphere radius");
  QLabel *krad =new QLabel("Covalent radius");
  QWidget *globalStuff = new QWidget(this);
  QWidget *atomStuff = new QWidget(this);
  QWidget *labelStuff = new QWidget(this);
  QGridLayout *atomlt = new QGridLayout(atomStuff);
  QVBoxLayout *glt = new QVBoxLayout();
  QGridLayout *llt = new QGridLayout();
  eacProba = new QComboBox(this);
  eacProba->addItem("90 % Probability",90);
  eacProba->addItem("70 % Probability",70);
  eacProba->addItem("50 % Probability",50);
  eacProba->addItem("30 % Probability",30);
  eacProba->addItem("10 % Probability",10);
  eacProba->setCurrentIndex(2);
  switch (mol->proba){
	  case 10: eacProba->setCurrentIndex(4);break; 
	  case 30: eacProba->setCurrentIndex(3);break; 
	  case 50: eacProba->setCurrentIndex(2);break; 
	  case 70: eacProba->setCurrentIndex(1);break; 
	  case 90: eacProba->setCurrentIndex(0);break; 
  }

  connect(eacProba,SIGNAL(currentIndexChanged(int)),this,SLOT(probaChanged(int)));
  QCheckBox *singleC =new QCheckBox("uni colored bonds");
  singleC->setChecked(mol->bondColorStyle);

  unicolor(mol->bondColorStyle);

  connect(singleC,SIGNAL(toggled(bool)),this,SLOT(unicolor(bool)));
  impbut = new QPushButton("Import atom styles");
  expbut = new QPushButton("Export atom styles");
  connect(impbut,SIGNAL(pressed()),this,SLOT(importSettings()));
  connect(expbut,SIGNAL(pressed()),this,SLOT(exportSettings()));
  colorbut2 = new QPushButton("Bond Color");
  colorbut2->setStyleSheet(QString(
			  "QPushButton {"
			  "border: 1px solid #000000;"
			  "border-radius: 9px;"
			  "color: %4;"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
			  "}"
			  "QPushButton:hover {"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %2, stop: 1 %1);"
			  "border: 0px"
			  "}"
			  "QPushButton:flat {"
			  "    border: none; /* no border for a flat push button */"
			  "}"
			  )
		  .arg(mol->bondColor.name())
		  .arg(mol->bondColor.darker(200).name())
		  .arg(mol->bondColor.lighter(200).name())
		  .arg((mol->bondColor.value()<90)?"#ffffff":"#000000"));
  connect(colorbut2,SIGNAL(pressed()),this,SLOT(colorDLG2()));
  colorbutlab = new QPushButton("Label Color");

  QString stsh=QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %1;"
              "opacity: %2;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
         .arg((ogl->labelColor.value()<128)?"#ffffff":"#000000")//1
          .arg(ogl->labelColor.alphaF(),0,'f')//2
          .arg(ogl->labelColor.red())//3
          .arg(ogl->labelColor.green())//4
          .arg(ogl->labelColor.blue())//5
          .arg(ogl->labelColor.alpha())//6
          .arg(ogl->labelColor.darker(200).red())//7
          .arg(ogl->labelColor.darker(200).green())//8
          .arg(ogl->labelColor.darker(200).blue())//9
          .arg(ogl->labelColor.lighter(200).red())//10
          .arg(ogl->labelColor.lighter(200).green())//11
          .arg(ogl->labelColor.lighter(200).blue());//12
  colorbutlab->setStyleSheet(stsh);
  connect(colorbutlab,SIGNAL(pressed()),this,SLOT(colorDLGLabel()));
  QSpinBox *sbx = new QSpinBox();
  sbx->setRange(0,255);
  sbx->setPrefix("Alpha: ");
  sbx->setValue(ogl->labelColor.alpha());
  connect(sbx,SIGNAL(valueChanged(int)),this,SLOT(labelColorAlpha(int)));
  llt->addWidget(new QLabel("Label Color:"),0,0);
  llt->addWidget(colorbutlab,0,1);
  llt->addWidget(sbx,0,2);
  bgcolorbutlab = new QPushButton("Label Background Color");

  stsh=QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %1;"
              "opacity: %2;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
         .arg((ogl->labelBGColor.value()<128)?"#ffffff":"#000000")//1
          .arg(ogl->labelBGColor.alphaF(),0,'f')//2
          .arg(ogl->labelBGColor.red())//3
          .arg(ogl->labelBGColor.green())//4
          .arg(ogl->labelBGColor.blue())//5
          .arg(ogl->labelBGColor.alpha())//6
          .arg(ogl->labelBGColor.darker(200).red())//7
          .arg(ogl->labelBGColor.darker(200).green())//8
          .arg(ogl->labelBGColor.darker(200).blue())//9
          .arg(ogl->labelBGColor.lighter(200).red())//10
          .arg(ogl->labelBGColor.lighter(200).green())//11
          .arg(ogl->labelBGColor.lighter(200).blue());//12
  bgcolorbutlab->setStyleSheet(stsh);
  connect(bgcolorbutlab,SIGNAL(pressed()),this,SLOT(bgColorDLGLabel()));
  sbx = new QSpinBox();
    sbx->setRange(0,255);
    sbx->setPrefix("Alpha: ");
    sbx->setValue(ogl->labelBGColor.alpha());
    connect(sbx,SIGNAL(valueChanged(int)),this,SLOT(labelBGColorAlpha(int)));
  llt->addWidget(new QLabel("Label Background Color"),1,0);
  llt->addWidget(bgcolorbutlab,1,1);
  llt->addWidget(sbx,1,2);

  colorbutflab = new QPushButton("Focused Label Color");
  stsh=QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %1;"
              "opacity: %2;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
         .arg((ogl->focusedLabelColor.value()<128)?"#ffffff":"#000000")//1
          .arg(ogl->focusedLabelColor.alphaF(),0,'f')//2
          .arg(ogl->focusedLabelColor.red())//3
          .arg(ogl->focusedLabelColor.green())//4
          .arg(ogl->focusedLabelColor.blue())//5
          .arg(ogl->focusedLabelColor.alpha())//6
          .arg(ogl->focusedLabelColor.darker(200).red())//7
          .arg(ogl->focusedLabelColor.darker(200).green())//8
          .arg(ogl->focusedLabelColor.darker(200).blue())//9
          .arg(ogl->focusedLabelColor.lighter(200).red())//10
          .arg(ogl->focusedLabelColor.lighter(200).green())//11
          .arg(ogl->focusedLabelColor.lighter(200).blue());//12
  colorbutflab->setStyleSheet(stsh);
  connect(colorbutflab,SIGNAL(pressed()),this,SLOT(colorDLGFLabel()));
  sbx = new QSpinBox();
    sbx->setRange(0,255);
    sbx->setPrefix("Alpha: ");
    sbx->setValue(ogl->focusedLabelColor.alpha());
    connect(sbx,SIGNAL(valueChanged(int)),this,SLOT(flabelColorAlpha(int)));
  llt->addWidget(new QLabel("Focused Label Color"),2,0);
  llt->addWidget(colorbutflab,2,1);
  llt->addWidget(sbx,2,2);

  bgcolorbutflab = new QPushButton("Focused Label Background Color");
  stsh=QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %1;"
              "opacity: %2;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
         .arg((ogl->focusedLabelBGColor.value()<128)?"#ffffff":"#000000")//1
          .arg(ogl->focusedLabelBGColor.alphaF(),0,'f')//2
          .arg(ogl->focusedLabelBGColor.red())//3
          .arg(ogl->focusedLabelBGColor.green())//4
          .arg(ogl->focusedLabelBGColor.blue())//5
          .arg(ogl->focusedLabelBGColor.alpha())//6
          .arg(ogl->focusedLabelBGColor.darker(200).red())//7
          .arg(ogl->focusedLabelBGColor.darker(200).green())//8
          .arg(ogl->focusedLabelBGColor.darker(200).blue())//9
          .arg(ogl->focusedLabelBGColor.lighter(200).red())//10
          .arg(ogl->focusedLabelBGColor.lighter(200).green())//11
          .arg(ogl->focusedLabelBGColor.lighter(200).blue());//12
  bgcolorbutflab->setStyleSheet(stsh);
  connect(bgcolorbutflab,SIGNAL(pressed()),this,SLOT(bgColorDLGFLabel()));
  sbx = new QSpinBox();
    sbx->setRange(0,255);
    sbx->setPrefix("Alpha: ");
    sbx->setValue(ogl->focusedLabelBGColor.alpha());
    connect(sbx,SIGNAL(valueChanged(int)),this,SLOT(flabelBGColorAlpha(int)));
  llt->addWidget(new QLabel("Focused Label Background Color"),3,0);
  llt->addWidget(bgcolorbutflab,3,1);
  llt->addWidget(sbx,3,2);

  colorbutslab = new QPushButton("Selected Label Color");
  stsh=QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %1;"
              "opacity: %2;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
         .arg((ogl->selectedLabelColor.value()<128)?"#ffffff":"#000000")//1
          .arg(ogl->selectedLabelColor.alphaF(),0,'f')//2
          .arg(ogl->selectedLabelColor.red())//3
          .arg(ogl->selectedLabelColor.green())//4
          .arg(ogl->selectedLabelColor.blue())//5
          .arg(ogl->selectedLabelColor.alpha())//6
          .arg(ogl->selectedLabelColor.darker(200).red())//7
          .arg(ogl->selectedLabelColor.darker(200).green())//8
          .arg(ogl->selectedLabelColor.darker(200).blue())//9
          .arg(ogl->selectedLabelColor.lighter(200).red())//10
          .arg(ogl->selectedLabelColor.lighter(200).green())//11
          .arg(ogl->selectedLabelColor.lighter(200).blue());//12
  colorbutslab->setStyleSheet(stsh);
  connect(colorbutslab,SIGNAL(pressed()),this,SLOT(colorDLGSLabel()));
  sbx = new QSpinBox();
    sbx->setRange(0,255);
    sbx->setPrefix("Alpha: ");
    sbx->setValue(ogl->selectedLabelColor.alpha());
    connect(sbx,SIGNAL(valueChanged(int)),this,SLOT(slabelColorAlpha(int)));
  llt->addWidget(new QLabel("Selected Label Color"),4,0);
  llt->addWidget(colorbutslab,4,1);
  llt->addWidget(sbx,4,2);


  bgcolorbutslab = new QPushButton("Selected Label Background Color");
  stsh=QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %1;"
              "opacity: %2;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%10,%11,%12,%6), stop: 1 rgba(%7,%8,%9,%6));"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 rgba(%3,%4,%5,%6), stop: 0.5 rgba(%7,%8,%9,%6), stop: 1 rgba(%3,%4,%5,%6));"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
         .arg((ogl->selectedLabelBGColor.value()<128)?"#ffffff":"#000000")//1
          .arg(ogl->selectedLabelBGColor.alphaF(),0,'f')//2
          .arg(ogl->selectedLabelBGColor.red())//3
          .arg(ogl->selectedLabelBGColor.green())//4
          .arg(ogl->selectedLabelBGColor.blue())//5
          .arg(ogl->selectedLabelBGColor.alpha())//6
          .arg(ogl->selectedLabelBGColor.darker(200).red())//7
          .arg(ogl->selectedLabelBGColor.darker(200).green())//8
          .arg(ogl->selectedLabelBGColor.darker(200).blue())//9
          .arg(ogl->selectedLabelBGColor.lighter(200).red())//10
          .arg(ogl->selectedLabelBGColor.lighter(200).green())//11
          .arg(ogl->selectedLabelBGColor.lighter(200).blue());//12
  bgcolorbutslab->setStyleSheet(stsh);
  //printf("BG alpha : %f %f %f\n",ogl->labelBGColor.alphaF(),ogl->focusedLabelBGColor.alphaF(),ogl->selectedLabelBGColor.alphaF());
  connect(bgcolorbutslab,SIGNAL(pressed()),this,SLOT(bgColorDLGSLabel()));
  sbx = new QSpinBox();
    sbx->setRange(0,255);
    sbx->setPrefix("Alpha: ");
    sbx->setValue(ogl->selectedLabelBGColor.alpha());
    connect(sbx,SIGNAL(valueChanged(int)),this,SLOT(slabelBGColorAlpha(int)));
  llt->addWidget(new QLabel("Selected Label Background Color"),5,0);
  llt->addWidget(bgcolorbutslab,5,1);
  llt->addWidget(sbx,5,2);
  QToolButton *tobu= new QToolButton();
  tobu->setDefaultAction(ogl->shortLabels);
  tobu->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
  connect(ogl->shortLabels,SIGNAL(toggled(bool)), ogl, SLOT(makeLabels()));
  llt->addWidget(tobu,6,0);
  QPushButton *fontbut = new QPushButton("Change Label Font");
  connect(fontbut,SIGNAL(clicked(bool)),this,SLOT(changeLabelFont()));
  llt->addWidget(fontbut,6,1);
  colorbutEdf = new QPushButton("ENVI default color");
  colorbutEdf->setStyleSheet(QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %4;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %2, stop: 1 %1);"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
          .arg(mol->enviDefaultColor.name())
          .arg(mol->enviDefaultColor.darker(200).name())
          .arg(mol->enviDefaultColor.lighter(200).name())
          .arg((mol->enviDefaultColor.value()<90)?"#ffffff":"#000000"));
  connect(colorbutEdf,SIGNAL(pressed()),this,SLOT(colorDLGenvidef()));
  colorbutEbo =new QPushButton("ENVI covalent color");
  colorbutEbo->setStyleSheet(QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %4;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %2, stop: 1 %1);"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
          .arg(mol->enviBondColor.name())
          .arg(mol->enviBondColor.darker(200).name())
          .arg(mol->enviBondColor.lighter(200).name())
          .arg((mol->enviBondColor.value()<90)?"#ffffff":"#000000"));
  connect(colorbutEbo,SIGNAL(pressed()),this,SLOT(colorDLGenvibon()));

  colorbutEhb =new QPushButton("ENVI H-Bond color");
  colorbutEhb->setStyleSheet(QString(
              "QPushButton {"
              "border: 1px solid #000000;"
              "border-radius: 9px;"
              "color: %4;"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
              "}"
              "QPushButton:hover {"
              "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %2, stop: 1 %1);"
              "border: 0px"
              "}"
              "QPushButton:flat {"
              "    border: none; /* no border for a flat push button */"
              "}"
              )
          .arg(mol->enviHBColor.name())
          .arg(mol->enviHBColor.darker(200).name())
          .arg(mol->enviHBColor.lighter(200).name())
          .arg((mol->enviHBColor.value()<90)?"#ffffff":"#000000"));
  connect(colorbutEhb,SIGNAL(pressed()),this,SLOT(colorDLGenvihbo()));
  bondStrength = new QDoubleSpinBox();
  bondStrength->setValue(mol->bondStrength);
  bondStrength->setDecimals(2);
  bondStrength->setSingleStep(0.01);
  bondStrength->setToolTip("Bond Strength");  
  connect(bondStrength,SIGNAL(valueChanged(double)),this,SLOT(strengthChanged(double)) );

  q_bondWidth = new QDoubleSpinBox();
  q_bondWidth->setValue(mol->q_bondWidth);
  q_bondWidth->setDecimals(1);
  q_bondWidth->setSingleStep(0.1);
  q_bondWidth->setToolTip("Bond Strength");
  connect(q_bondWidth,SIGNAL(valueChanged(double)),this,SLOT(qStrengthChanged(double)) );
  glt->addWidget(eacProba);
  glt->addWidget(singleC);
  glt->addWidget(colorbut2);
  glt->addWidget(colorbutEdf);
  glt->addWidget(colorbutEbo);
  glt->addWidget(colorbutEhb);
  QHBoxLayout *glt2= new QHBoxLayout();
  QHBoxLayout *glt9= new QHBoxLayout();
  QHBoxLayout *glt5= new QHBoxLayout();
  QHBoxLayout *glt6= new QHBoxLayout();
  QHBoxLayout *glt7= new QHBoxLayout();
  QHBoxLayout *glt8= new QHBoxLayout();
  QStringList accsl;

  for (int i=0; i<mol->theseAreAcceptors.size(); i++) accsl.append(mol->pse(mol->theseAreAcceptors.at(i)));
  accLE = new QLineEdit(accsl.join(","));
  QLabel *accla = new QLabel("H-Bond Acceptor Elements");
  glt7->addWidget(accLE);
  glt7->addWidget(accla);

  QStringList donsl;
  for (int i=0; i<mol->theseAreDonors.size(); i++) donsl.append(mol->pse(mol->theseAreDonors.at(i)));
  donLE = new QLineEdit(donsl.join(","));
  QLabel *donla = new QLabel("H-Bond Donor Elements     ");
  glt8->addWidget(donLE);
  glt8->addWidget(donla);
  connect(accLE,SIGNAL(editingFinished()),this,SLOT(updateHBElemnts()));
  glt2->addWidget(bondStrength);
  glt9->addWidget(q_bondWidth);
  glt9->addWidget(new QLabel("Q-Bond line width"));
  QLabel *bsl = new QLabel("Bond strength");
  QLabel *lodl = new QLabel("Level of detail");
  QLabel *qradl = new QLabel("QPeak-size");
  glt2->addWidget(bsl);
  lodSpinBox = new QSpinBox();
  lodSpinBox->setValue(mol->LOD);
  lodSpinBox->setMinimum(2);
  lodSpinBox->setMaximum(8);
  connect(lodSpinBox,SIGNAL(valueChanged(int)),this,SLOT(lodChanged(int)));
  QHBoxLayout *glt3= new QHBoxLayout();
  glt3->addWidget(lodSpinBox);
  glt3->addWidget(lodl);
  glt6->addWidget(eacHBDist);
  QLabel *hbdl = new QLabel("Max H-Acceptor Distance");
  glt6->addWidget(hbdl);
  QLabel *hbal = new QLabel("Min H-Bond Angle");
  glt5->addWidget(eacHBAngl);
  glt5->addWidget(hbal);
  QDoubleSpinBox* qPeakSizeSBx = new QDoubleSpinBox();
  qPeakSizeSBx->setValue(mol->qPeakRad);
  qPeakSizeSBx->setDecimals(3);
  qPeakSizeSBx->setMinimum(0.005);
  qPeakSizeSBx->setMaximum(0.5);
  qPeakSizeSBx->setSingleStep(0.003);
  qPeakSizeSBx->setToolTip("QPeak-size");
  connect(qPeakSizeSBx,SIGNAL(valueChanged(double)),this,SLOT(QPeakRadChanged(double)) );

  demoMoleculeBox = new QComboBox();
  demoMoleculeBox->addItem("default molecule1", "trypto.shelxle");
  //demoMoleculeBox->addItem("default molecule2", "trypto1.shelxle" );
  demoMoleculeBox->addItem("Tartrate", "vino_0m.shelxle" );
  demoMoleculeBox->addItem("IDEAL @ Aceclofenac", "aceclofenac.shelxle");
  demoMoleculeBox->addItem("CP* rings", "example7.shelxle" );
  demoMoleculeBox->addItem("Packed Vitamin C", "ascorbic.shelxle" );
  demoMoleculeBox->addItem("dissorder", "mo_sample1.shelxle" );
  //demoMoleculeBox->addItem("default molecule5", "testmol1.shelxle" );

  connect(demoMoleculeBox, SIGNAL(currentIndexChanged(int)), this, SLOT(makedemomol()));





  QHBoxLayout *glt4= new QHBoxLayout();
  glt4->addWidget(qPeakSizeSBx);
  glt4->addWidget(qradl);

  glt->addLayout(glt2);
  glt->addLayout(glt3);
  glt->addLayout(glt4);
  glt->addLayout(glt9);
  glt->addLayout(glt5);
  glt->addLayout(glt6);
  glt->addLayout(glt7);
  glt->addLayout(glt8);

  globalStuff->setLayout(glt);
  labelStuff->setLayout(llt);
  walbx = new QCheckBox("Draw intersecting planes");
  //walbx->setTristate();
  rinbx = new QCheckBox("Draw principal ellipses (check again for black or white)");
  rinbx->setTristate();
  sphbx = new QCheckBox("Draw ellipsoid surface");
  sldbx = new QCheckBox("Solid closed ellipsoid");
  noadp = new QCheckBox("No ADP");
  metalic = new QCheckBox("Dashed bonds to other elements\n (metals)");
  nlabx = new QCheckBox("No label!");
  metalic->setCheckState ( Qt::Unchecked);
  walbx->setCheckState ( Qt::Checked);
  rinbx->setCheckState ( Qt::Checked);
  rinbx->setWhatsThis("If this check box is half selected <font color=gray><b>white</b></font> <b>outer lines</b> will be drawn around the ellipsoid which looks nice when the atom has a dark color.<br> If this is fully selected <b>black outer lines</b> will be drawn around the ellipsoid.");
  sphbx->setCheckState ( Qt::Checked);
  sldbx->setCheckState ( Qt::Unchecked);
  nlabx->setCheckState ( Qt::Unchecked);  
  noadp->setCheckState ( Qt::Unchecked);
  psew = new PSEWidget(mol);
  psew->selection=5;
  idlerot = new QCheckBox("spin demo molecule");
  idlerot->setCheckable(true);
  idlerot->setChecked(true);
  connect(idlerot,SIGNAL(toggled(bool)),this,SLOT(toggleRotation(bool)));
  QPushButton *multi = new QPushButton("Style Multiple Elements");
  colorbut =new QPushButton("Atom Color");
  colorbut->setStyleSheet(QString(
			  "QPushButton {"
			  "border: 1px solid #000000;"
			  "border-radius: 9px;"
			  "color: %4;"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %1, stop: 0.5 %3, stop: 1 %2);"
			  "}"
			  "QPushButton:hover {"
			  "background-color: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 %2, stop: 0.5 %1, stop: 1 %2);"
			  "}"
			  "QPushButton:flat {"
			  "    border: none; /* no border for a flat push button */"
			  "}"
			  )
          .arg( mol->atomColor(0,psew->HisD).name())
          .arg( mol->atomColor(0,psew->HisD).darker(200).name())
          .arg( mol->atomColor(0,psew->HisD).lighter(200).name())
          .arg((mol->atomColor(0,psew->HisD).value()<90)?"#ffffff":"#000000"));
  eacKRAD->setValue(mol->Kovalenz_Radien[5]/100.0);
  eacKRAD->setDecimals(2);
  eacKRAD->setSingleStep(0.01);
  eacRAD->setValue(mol->arad[5]);
  eacRAD->setDecimals(2);
  eacRAD->setSingleStep(0.01);
  eacHBDist->setValue(mol->hbdist());
  eacHBDist->setDecimals(2);
  eacHBDist->setSingleStep(0.01);

  eacHBAngl->setMaximum(180.0);
  eacHBAngl->setMinimum(0.0);
  eacHBAngl->setValue(mol->hbangl());
  eacHBAngl->setDecimals(1);
  eacHBAngl->setSingleStep(0.1);
  QTabWidget *tabby = new QTabWidget(this);
  tabby->insertTab(0,atomStuff,"Atom settings");
  tabby->insertTab(1,globalStuff,"Global settings");
  tabby->insertTab(2,labelStuff, "Label settings");

  //eacGLO->addWidget(eacGLW,0,0,1,6);
  eacGLO->addWidget(qpv,0,0,1,1);
#if defined (Q_OS_MAC)
    QWidget *container = QWidget::createWindowContainer(ogl);
   // container->setMinimumHeight(400);
    eacGLO->addWidget(container,0,1,1,5);
#else
    eacGLO->addWidget(ogl,0,1,1,5);
#endif

  eacGLO->addWidget(demoMoleculeBox, 1, 0, 1, 2);
  eacGLO->addWidget(idlerot, 1, 3, 1,1);
  eacGLO->addWidget(tabby,0,6,1,3);
  atomlt->addWidget(rad,2,1);
  atomlt->addWidget(krad,3,1);
  atomlt->addWidget(eacRAD,2,0);
  atomlt->addWidget(eacKRAD,3,0);
  atomlt->addWidget(psew,0,0,1,3);
  atomlt->addWidget(colorbut,1,0,1,3);
  atomlt->addWidget(nlabx,4,0);
  eacGLO->addWidget(multi,8,1);
  eacGLO->addWidget(expbut,8,2);
  eacGLO->addWidget(impbut,8,3);
  eacGLO->addWidget(vito,8,4,1,4);
  atomlt->addWidget(walbx,5,0);
  atomlt->addWidget(rinbx,6,0,1,3);
  atomlt->addWidget(sphbx,5,1);
  atomlt->addWidget(sldbx,5,2);
  atomlt->addWidget(noadp,4,1);
  atomlt->addWidget(metalic,4,2);
  setLayout(eacGLO);
  connect(eacHBDist,SIGNAL(valueChanged(double)),this,SLOT(hbdistChanged(double)) );
  connect(eacKRAD,SIGNAL(valueChanged(double)),this,SLOT(kradChanged(double)) );
  connect(eacRAD,SIGNAL(valueChanged(double)),this,SLOT(radChanged(double)) );
  connect(eacHBAngl,SIGNAL(valueChanged(double)),this,SLOT(hbanglChanged(double)) );
  connect(multi,SIGNAL(pressed()),this , SLOT(doMulti()));
  //connect(psew,SIGNAL(pseSelected(int,bool)), this, SLOT(updateLEs(int,bool)));
  //connect(psew,SIGNAL(Htransmutated(int,bool)),this,SLOT(updateLEs(int,bool)));
  connect(psew,SIGNAL(pseSelected(int,bool)), this, SLOT(changeAtom(int,bool)));

  connect(this,SIGNAL(colorchanged(QColor)),psew,SLOT(colorchange(QColor)));
  connect(noadp,SIGNAL(toggled(bool)),this,SLOT(woADP(bool)));

  connect(colorbut,SIGNAL(pressed()),this,SLOT(colorDLG()));
  connect(walbx,SIGNAL(stateChanged(int)),this,SLOT(wallA(int)));
  connect(walbx,SIGNAL(stateChanged(int)),this,SLOT(checkSolid()));
  connect(nlabx,SIGNAL(stateChanged(int)),this,SLOT(nolaA(int)));
  connect(rinbx,SIGNAL(stateChanged(int)),this,SLOT(ringA(int)));
  connect(sphbx,SIGNAL(stateChanged(int)),this,SLOT(spheA(int)));
  connect(sphbx,SIGNAL(stateChanged(int)),this,SLOT(checkBall()));
  connect(sldbx,SIGNAL(stateChanged(int)),this,SLOT(soldA(int)));
  connect(sldbx,SIGNAL(stateChanged(int)),this,SLOT(checkWall()));
  connect(metalic,SIGNAL(stateChanged(int)),this,SLOT(metalA(int)));
//  connect(ogl,SIGNAL(initialized()),this,SLOT(updateLEs()));
  connect(this,SIGNAL(statesChanged()),this,SLOT(updateShaders()));
  //eacGLW->setMSAA(true);

}
void EacDlg::updateShaders(){
    //printf("updateShaders\n");
    mol->showbonds = mol->connecting(mol->showatoms,true);
    ogl->makeAtoms(mol->showatoms);
    ogl->makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
    ogl->makeLabels();
}


void EacDlg::doMulti(){
  MultiStyle *m = new MultiStyle(mol);
  if (m->exec()==QDialog::Accepted){
    int stt=0;
    if (m->sphbx->checkState())stt|=ATOM_STYLE_SPHERE;
    if (m->rinbx->checkState())stt|=ATOM_STYLE_RINGS;
    if (m->rinbx->checkState()==Qt::PartiallyChecked)stt|=ATOM_STYLE_WHITERING;
    if (m->walbx->checkState())stt|=ATOM_STYLE_WALLS;
    if (m->walbx->checkState()==Qt::PartiallyChecked)stt|=ATOM_STYLE_PLAID;
    if (m->sldbx->checkState())stt|=ATOM_STYLE_SOLID;
    if (m->metalic->checkState())stt|=ATOM_STYLE_METAL;
    int mi=qMin(m->start->currentIndex(),m->end->currentIndex()),
	ma=qMax(m->start->currentIndex(),m->end->currentIndex());
    for (int i=mi;i<=ma;i++){
      mol->AtomStyle[i]=stt;    
    }
    emit statesChanged();
  }
}

MultiStyle::MultiStyle(Molecule *externMole){
  mol=externMole;
  setWindowTitle("Multiple Elements Styler");  
  start = new QComboBox();
  end = new QComboBox();
  start->addItems(mol->thepse());
  start->setCurrentIndex(2);
  end->addItems(mol->thepse());
  end->setCurrentIndex(93);
  QLabel *staL =new QLabel("From: "); 
  QLabel *endL =new QLabel("To: "); 
  walbx = new QCheckBox("Draw intersecting planes");
  //walbx->setTristate();
  rinbx = new QCheckBox("Draw principal ellipses");
  rinbx->setTristate();
  sphbx = new QCheckBox("Draw ellipsoid surface");
  sldbx = new QCheckBox("Solid ellipsoid");
  metalic = new QCheckBox("Dashed Bonds to others");
  metalic->setCheckState ( Qt::Unchecked);
  walbx->setCheckState ( Qt::Checked);
  rinbx->setCheckState ( Qt::Checked);
  sphbx->setCheckState ( Qt::Checked);
  sldbx->setCheckState ( Qt::Unchecked);
  QGridLayout *eacGLO = new QGridLayout; 
  eacGLO->addWidget(staL,0,0,1,1,Qt::AlignRight);
  eacGLO->addWidget(endL,0,2,1,1,Qt::AlignRight);
  eacGLO->addWidget(start,0,1);
  eacGLO->addWidget(end,0,3);
  eacGLO->addWidget(walbx,1,0);
  eacGLO->addWidget(rinbx,1,1);
  eacGLO->addWidget(sphbx,1,2);
  eacGLO->addWidget(sldbx,1,3);
  eacGLO->addWidget(metalic,1,4);
  connect(start,SIGNAL(currentIndexChanged(int)),this,SLOT(commonDefault()));
  connect(end,SIGNAL(currentIndexChanged(int)),this,SLOT(commonDefault()));
  commonDefault();
  connect(walbx,SIGNAL(stateChanged(int)),this,SLOT(checkSolid()));
  connect(sphbx,SIGNAL(stateChanged(int)),this,SLOT(checkBall()));
  connect(sldbx,SIGNAL(stateChanged(int)),this,SLOT(checkWall()));
  QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
  connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
  eacGLO->addWidget(buttonBox,2,0,1,5);
  //  eacGLO->addWidget(,1,);
  setLayout(eacGLO);
}
void MultiStyle::commonDefault(){
    int
            mi=qMin(start->currentIndex(),end->currentIndex()),
            ma=qMax(start->currentIndex(),end->currentIndex());
    int stt=mol->AtomStyle[mi];
    int fstt=stt;
    for (int i=mi;i<=ma;i++){
        printf("%s %d %X\n",mol->pse(i).toStdString().c_str(),i,mol->AtomStyle[i]);
      if (mol->AtomStyle[i] != stt) {
          stt=-1;
          break;
      }
    }
    printf("commonDefault %s %s %X %X\n",mol->pse(mi).toStdString().c_str(),mol->pse(ma).toStdString().c_str(),stt,fstt);
    if (stt!=-1){
        /*    if (m->sphbx->checkState())stt|=ATOM_STYLE_SPHERE;
    if (m->rinbx->checkState())stt|=ATOM_STYLE_RINGS;
    if (m->rinbx->checkState()==Qt::PartiallyChecked)stt|=ATOM_STYLE_WHITERING;
    if (m->walbx->checkState())stt|=ATOM_STYLE_WALLS;
    if (m->walbx->checkState()==Qt::PartiallyChecked)stt|=ATOM_STYLE_PLAID;
    if (m->sldbx->checkState())stt|=ATOM_STYLE_SOLID;
    if (m->metalic->checkState())stt|=ATOM_STYLE_METAL;*/
        metalic->setCheckState((stt&ATOM_STYLE_METAL)? Qt::Checked: Qt::Unchecked);
        walbx->setCheckState((stt&ATOM_STYLE_WALLS)? Qt::Checked: Qt::Unchecked);
        rinbx->setCheckState((stt&ATOM_STYLE_RINGS)? (stt&ATOM_STYLE_WHITERING)? Qt::PartiallyChecked: Qt::Checked: Qt::Unchecked);
        sphbx->setCheckState((stt&ATOM_STYLE_SPHERE)? Qt::Checked: Qt::Unchecked);
        sldbx->setCheckState((stt&ATOM_STYLE_SOLID)? Qt::Checked: Qt::Unchecked);
        update();
    }

}
void MultiStyle::checkWall(){
  if (sldbx->checkState()&&(walbx->checkState()))walbx->setCheckState(Qt::Unchecked);
}

void MultiStyle::checkSolid(){
  if (sldbx->checkState()&&(walbx->checkState()))sldbx->setCheckState(Qt::Unchecked);
}

void MultiStyle::checkBall(){
  if (sphbx->checkState())sldbx->setEnabled(true);
  else sldbx->setEnabled(false);
}

void EacDlg::changeLabelFont(){
  bool ok;
  QFont font = QFontDialog::getFont(&ok, ogl->myFont, this,"Change Label Font");
  if (ok) {
    //font.setStyleStrategy(QFont::OpenGLCompatible);
    ogl->myFont=font;
    einstellung->beginGroup("Fonts");
    einstellung->setValue("LabelFont",ogl->myFont);
    einstellung->endGroup();
    //chgl->updateLabelTextures();
    ogl->makeLabels();
    ogl->update();
  }
}

void EacDlg::reject(){    
  //printf("reject\n");
  timer->stop();
  einstellung->beginGroup("Atoms");
  einstellung->beginWriteArray("AtomStyles",107);
  for (int i = 0; i < 107; ++i) {
    einstellung->setArrayIndex(i);
    einstellung->setValue("Style", mol->AtomStyle[i]);
  }
  einstellung->endArray();
  einstellung->endGroup();
  einstellung->beginGroup("Fonts");
  einstellung->setValue("LabelFont",ogl->myFont);
  einstellung->endGroup();
  //mol->pmin=eacGLW->exmin;
  //mol->pmax=eacGLW->exmax;

  psew->esm->disconnect();
  delete psew->esm;
  psew->disconnect();
  //eacGLW->disconnect();
  this->disconnect();
  //ogl->deleteLater();

  if (!exmol.isEmpty()){
      mol->showatoms=exmol;
      mol->showbonds=exbond;
  }
  //mol->g_Program->release();
  //mol->g_Program->deleteLater();
  //mol->g_Program=eacGLW->saveProgram;
  //delete eacGLW;
  done(QDialog::Rejected);
}

void EacDlg::accept(){
    printf("accept\n");
  done(QDialog::Accepted);
}

/*
void EacGLW::project(double x, double y, double z, GLdouble &tx, GLdouble &ty){
  makeCurrent();
  GLdouble model[16];
  GLdouble proj[16];
  GLint viewport[4];
  glGetIntegerv(GL_VIEWPORT, viewport);
  glGetDoublev( GL_PROJECTION_MATRIX , (double*)proj );
  glGetDoublev( GL_MODELVIEW_MATRIX, (double*)model );
  V3 pos(x,y,z);
  posTo2D(pos, model, proj, viewport, tx, ty, retinafktr);
}

inline void EacGLW::transform_point(GLdouble out[4], const GLdouble m[16], const GLdouble in[4]) {
#define M(row,col)  m[col*4+row]
  out[0] =
    M(0, 0) * in[0] + M(0, 1) * in[1] + M(0, 2) * in[2] + M(0, 3) * in[3];
  out[1] =
    M(1, 0) * in[0] + M(1, 1) * in[1] + M(1, 2) * in[2] + M(1, 3) * in[3];
  out[2] =
    M(2, 0) * in[0] + M(2, 1) * in[1] + M(2, 2) * in[2] + M(2, 3) * in[3];
  out[3] =
    M(3, 0) * in[0] + M(3, 1) * in[1] + M(3, 2) * in[2] + M(3, 3) * in[3];
#undef M
}
inline bool  EacGLW::posTo2D(V3 obj,
    const GLdouble model[16], const GLdouble proj[16], const GLint viewport[4],
    GLdouble &winx, GLdouble &winy,double retinafktr) {
  GLdouble in[4], out[4];

  in[0] = obj.x;
  in[1] = obj.y;
  in[2] = obj.z;
  in[3] = 1.0;
  transform_point(out, model, in);
  transform_point(in, proj, out);

  if (in[3] == 0.0) return false;

  in[0] /= in[3];
  in[1] /= in[3];
  in[2] /= in[3];

  winx = viewport[0] + (1 + in[0]) * viewport[2] / 2;
  winy = viewport[1] + (1 - in[1]) * viewport[3] / 2;
  winx/=retinafktr;
  winy/=retinafktr;
  return true;

}
*/
