# 2022-08-30 Triage Log

A somewhat difficult week to triage due to the large amount of noise coming from two benchmarks. Hopefully this noise settles down in the future. Other than that, improvements much outweighed regressions with an average of 142 changes to instruction count averaging 0.7% improvement. There were no huge wins this week, however.

Triage done by **@rylev**.
Revision range: [4a24f08b..0631ea5d](https://perf.rust-lang.org/?start=4a24f08ba43166cfee86d868b3fe8612aec6faca&end=0631ea5d73f4a3199c776687b12c20c50a91f0d2&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.0% | [0.2%, 2.6%] | 4     |
| Regressions ❌ <br /> (secondary) | 1.3% | [0.3%, 2.6%] | 23    |
| Improvements ✅ <br /> (primary) | -0.7% | [-2.8%, -0.2%] | 138   |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.7%, -0.2%] | 71    |
| All ❌✅ (primary) | -0.7% | [-2.8%, 2.6%] | 142   |


2 Regressions, 3 Improvements, 10 Mixed; 6 of them in rollups
40 artifact comparisons made in total

#### Regressions

add `depth_limit` in `QueryVTable` to avoid entering a new tcx in `layout_of` [#100748](https://github.com/rust-lang/rust/pull/100748) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7480389611f9d04bd34adf41a2b3029be4eb815e&end=cfb5ae26a4496b7d35180f15e47ada0f3897c7e8&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.5% | [0.3%, 0.7%] | 8     |
| Regressions ❌ <br /> (secondary) | 0.7% | [0.3%, 1.3%] | 13    |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.5% | [0.3%, 0.7%] | 8     |
- Most of the regressions are happening in `html5ever-0.26.0` and `deeply-nested-multi` which have been noisy lately. The regressions are small enough that it's likely that we're seeing that noise here too. Subsequent changes show improvements of the same magnitude reversing the regressions here. 
- However, there are some regressions that seem like they might be real, and they are all in `doc` profile test cases. The common query across the potentially real regressions is the `build_impl` query. This change seems like strictly less work, so I'm confused why this might be. 
- Left a [comment](https://github.com/rust-lang/rust/pull/100748#issuecomment-1231842964) asking if anyone had any good ideas despite the cachegrind run not revealing anything.


Don't catch overflow when running with cargo doc [#101039](https://github.com/rust-lang/rust/pull/101039) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=450e99f93795c81c1f2d10be27fb3a98be5b0cfc&end=c07a8b4e09f356c7468b69c50cac7fc5b5000b8a&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.6% | [0.6%, 0.8%] | 6     |
| Regressions ❌ <br /> (secondary) | 0.9% | [0.2%, 1.3%] | 9     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.6% | [0.6%, 0.8%] | 6     |
- The primary regressions seem like noise (as they are reversed in the next perf run), but the secondary regressions seem like sustained regressions.
- This was a fix for an issue that broke some crates so the minor perf hit in secondary benchmarks is likely acceptable even if it is real. 


#### Improvements

Symbols: do not write string values of preinterned symbols into compiled artifacts [#100803](https://github.com/rust-lang/rust/pull/100803) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4a24f08ba43166cfee86d868b3fe8612aec6faca&end=ebfc7aa53185617f14e1e15bef8ef5b4505b5397&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.6% | [-2.5%, -0.2%] | 35    |
| Improvements ✅ <br /> (secondary) | -1.7% | [-2.6%, -0.3%] | 24    |
| All ❌✅ (primary) | -0.6% | [-2.5%, -0.2%] | 35    |


Elide superfluous storage markers [#99946](https://github.com/rust-lang/rust/pull/99946) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=addacb5878b9970ebc1665768a05cb601e7aea15&end=5462da52ba9edc77c2a7e4fc77aaf3b977d41ad1&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.9% | [0.9%, 0.9%] | 1     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.6% | [-1.9%, -0.2%] | 14    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.5%, -0.3%] | 38    |
| All ❌✅ (primary) | -0.5% | [-1.9%, 0.9%] | 15    |


Rollup of 13 pull requests [#101115](https://github.com/rust-lang/rust/pull/101115) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d5ef528bebbe0d8e350e547316fdc7d7476614d2&end=3fdd578d72a24d4efc2fe2ad18eec3b6ba72271e&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.6% | [-0.6%, -0.6%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.3%, -0.9%] | 8     |
| All ❌✅ (primary) | -0.6% | [-0.6%, -0.6%] | 1     |


#### Mixed

Rollup of 15 pull requests [#100963](https://github.com/rust-lang/rust/pull/100963) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ebfc7aa53185617f14e1e15bef8ef5b4505b5397&end=addacb5878b9970ebc1665768a05cb601e7aea15&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.2% | [0.2%, 0.3%] | 5     |
| Regressions ❌ <br /> (secondary) | 0.4% | [0.2%, 0.6%] | 17    |
| Improvements ✅ <br /> (primary) | -0.6% | [-0.8%, -0.5%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.3%] | 6     |
| All ❌✅ (primary) | -0.2% | [-0.8%, 0.3%] | 11    |
- I looked for something obvious that might be causing this, and I couldn't find anything promising. 
- It seems there are some PRs that are very likely *not* the cause. We can start by testing the others to see if they yield results. 


Check projection types before inlining MIR [#100571](https://github.com/rust-lang/rust/pull/100571) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=76531befc4b0352247ada67bd225e8cf71ee5686&end=4d45b0745ab227feb9000bc15713ade4b99241ea&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 0.9% | [0.7%, 1.2%] | 8     |
| Improvements ✅ <br /> (primary) | -0.4% | [-1.1%, -0.2%] | 115   |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.3%, -0.1%] | 42    |
| All ❌✅ (primary) | -0.4% | [-1.1%, -0.2%] | 115   |
- All of the regressions are secondary, and many are in the recently noisy `deeply-nested-multi`. Additionally, the improvements far outweigh the regressions.
- Marked as triaged


Rollup of 8 pull requests [#101017](https://github.com/rust-lang/rust/pull/101017) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=76f3b891a0c48e128c5a43ef57e70d86735e1cf2&end=13a6aaffdf6bd6f1bce000b09aa390e93d6aca77&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | [0.3%, 0.3%] | 2     |
| Regressions ❌ <br /> (secondary) | 1.5% | [0.2%, 3.6%] | 14    |
| Improvements ✅ <br /> (primary) | -0.4% | [-0.6%, -0.3%] | 8     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -0.3% | [-0.6%, 0.3%] | 10    |
- Looks like [#10034](https://github.com/rust-lang/rust/pull/100034) is the likely culprit for a large part of the regressions
- This is [tracked](https://github.com/rust-lang/rust/pull/101017#issuecomment-1228337691) by those working in the area.


Avoid reporting overflow in `is_impossible_method` [#100705](https://github.com/rust-lang/rust/pull/100705) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=13a6aaffdf6bd6f1bce000b09aa390e93d6aca77&end=983f4daddf238d114c4adc4751c5528fc6695a5a&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | [0.6%, 0.8%] | 6     |
| Regressions ❌ <br /> (secondary) | 0.3% | [0.3%, 0.3%] | 1     |
| Improvements ✅ <br /> (primary) | -0.5% | [-0.6%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.4% | [-0.6%, 0.8%] | 8     |
- The primary perf regression on this PR seems to be reversed by #101039 
- Marked as triaged


Rollup of 8 pull requests [#101037](https://github.com/rust-lang/rust/pull/101037) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8a13871b69924b74cfa1d737f2894068b37ea7ea&end=42fa8ac7236f4f78a82aeea543bdd445a59f02e0&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.5% | [0.3%, 3.8%] | 3     |
| Regressions ❌ <br /> (secondary) | 0.9% | [0.5%, 1.2%] | 7     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.3%, -1.2%] | 2     |
| All ❌✅ (primary) | 1.5% | [0.3%, 3.8%] | 3     |
- Mostly a mixture of noisy and a small regression from [#101006](https://github.com/rust-lang/rust/pull/101006). 
- That PR is a correctness fix, so it seems likely that we'll be ok with this small regression.


session: stabilize split debuginfo on linux [#98051](https://github.com/rust-lang/rust/pull/98051) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=42fa8ac7236f4f78a82aeea543bdd445a59f02e0&end=450e99f93795c81c1f2d10be27fb3a98be5b0cfc&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 0.2% | [0.2%, 0.3%] | 2     |
| Improvements ✅ <br /> (primary) | -0.6% | [-0.7%, -0.5%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.1%, -0.6%] | 6     |
| All ❌✅ (primary) | -0.6% | [-0.7%, -0.5%] | 6     |
- It was determined that this was [just noise](https://github.com/rust-lang/rust/pull/98051#issuecomment-1229567245).


interpret: remove support for uninitialized scalars [#100043](https://github.com/rust-lang/rust/pull/100043) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c07a8b4e09f356c7468b69c50cac7fc5b5000b8a&end=2b443a8d97ff1f26c35e4bcf682bf9a89e8a66d2&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.8% | [0.6%, 0.9%] | 2     |
| Regressions ❌ <br /> (secondary) | 1.3% | [0.3%, 3.2%] | 18    |
| Improvements ✅ <br /> (primary) | -0.6% | [-0.7%, -0.5%] | 6     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -0.2% | [-0.7%, 0.9%] | 8     |
- Looks like the primary regressions are due to noise.
- The regressions in secondary benchmarks seem to be more real though. Looks like the most impacted query is `eval_to_allocation_raw`. Seems possible that that might indeed be impacted by this change (just going off the usage of `eval_to_allocation_raw` in const eval)?
- Indeed, it was found that an unconditional `format!` was [causing this issue](https://github.com/rust-lang/rust/pull/100043#issuecomment-1230184985).
- This should be fixed by [#101154](https://github.com/rust-lang/rust/pull/101154).


Rollup of 9 pull requests [#101064](https://github.com/rust-lang/rust/pull/101064) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2b443a8d97ff1f26c35e4bcf682bf9a89e8a66d2&end=bb8a08f011ce481adc62e45150b642d1f160bd78&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.6% | [0.5%, 0.7%] | 6     |
| Regressions ❌ <br /> (secondary) | 1.0% | [1.0%, 1.0%] | 1     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.5%, -1.3%] | 3     |
| All ❌✅ (primary) | 0.6% | [0.5%, 0.7%] | 6     |
- It was determined that this was [just noise](https://github.com/rust-lang/rust/pull/101064#issuecomment-1229570007).


Avoid cloning a collection only to iterate over it [#100497](https://github.com/rust-lang/rust/pull/100497) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=223d16ebbde1bd309c58e853b053e14318e56b0e&end=ce36e88256f09078519f8bc6b21e4dc88f88f523&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.5% | [0.5%, 0.6%] | 6     |
| Regressions ❌ <br /> (secondary) | 0.8% | [0.5%, 1.1%] | 10    |
| Improvements ✅ <br /> (primary) | -0.6% | [-0.8%, -0.5%] | 3     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.2%, -0.5%] | 4     |
| All ❌✅ (primary) | 0.2% | [-0.8%, 0.6%] | 9     |
- The regressions seem to just be noise. The improvements though seem real. [See here](https://github.com/rust-lang/rust/pull/100497#issuecomment-1229740623).


Rollup of 8 pull requests [#101152](https://github.com/rust-lang/rust/pull/101152) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fcc2bddd262b26c3a4aeff2328e39b8e2b6d3254&end=bc4b39c271bbd36736cbf1c0a1ac23d5df38d365&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.6% | [0.5%, 0.7%] | 10    |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.3% | [-0.5%, -0.2%] | 24    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.9%, -0.3%] | 34    |
| All ❌✅ (primary) | -0.0% | [-0.5%, 0.7%] | 34    |
- [#99821](https://github.com/rust-lang/rust/pull/99821) is responsible for all the improvements *and* regressions for this rollup.
- Given that the improvements outweigh the regressions we mark this as triaged.
