require 'spec_helper'

RSpec.describe Humanize, "vi locale" do
  before do
    Humanize.configure do |config|
      config.default_locale = :vi
      config.decimals_as = :number
    end
  end

  # rubocop:disable Metrics/LineLength
  vi_tests = [
    [1.0 / 0, "vô cùng"],
    [-1.0 / 0, "âm vô cùng"],
    [0.0 / 0, "không xác định"],
    [-0.042, "âm không phẩy không bốn hai"],
    [-0.00003345, "âm không phẩy không không không không ba ba bốn năm"],
    [-0.0000017854, "âm không phẩy không không không không không một bảy tám năm bốn"],
    [0.000000123, "không phẩy không không không không không không một hai ba"],
    [8.000015, "tám phẩy không không không không một năm"],
    [8.15, "tám phẩy mười lăm"],
    [-101_517, "âm một trăm linh một nghìn năm trăm mười bảy"],
    [-1_000_000_000_001, "âm một nghìn tỷ không trăm linh một"],
    [-1, "âm một"],
    [0, "không"],
    [1, "một"],
    [5, "năm"],
    [10, "mười"],
    [11, "mười một"],
    [15, "mười lăm"],
    [21, "hai mươi mốt"],
    [25, "hai mươi lăm"],
    [55, "năm mươi lăm"],
    [99, "chín mươi chín"],
    [100, "một trăm"],
    [101, "một trăm linh một"],
    [105, "một trăm linh năm"],
    [110, "một trăm mười"],
    [111, "một trăm mười một"],
    [115, "một trăm mười lăm"],
    [121, "một trăm hai mươi mốt"],
    [125, "một trăm hai mươi lăm"],
    [155, "một trăm năm mươi lăm"],
    [555, "năm trăm năm mươi lăm"],
    [1_000, "một nghìn"],
    [1_001, "một nghìn không trăm linh một"],
    [1_011, "một nghìn không trăm mười một"],
    [1_555, "một nghìn năm trăm năm mươi lăm"],
    [5_555, "năm nghìn năm trăm năm mươi lăm"],
    [10_000, "mười nghìn"],
    [10_005, "mười nghìn không trăm linh năm"],
    [10_015, "mười nghìn không trăm mười lăm"],
    [10_515, "mười nghìn năm trăm mười lăm"],
    [11_115, "mười một nghìn một trăm mười lăm"],
    [99_999, "chín mươi chín nghìn chín trăm chín mươi chín"],
    [100_000, "một trăm nghìn"],
    [100_100, "một trăm nghìn một trăm"],
    [999_999, "chín trăm chín mươi chín nghìn chín trăm chín mươi chín"],
    [1_000_000, "một triệu"],
    [1_001_000, "một triệu không trăm linh một nghìn"],
    [1_000_001, "một triệu không trăm linh một"],
    [1_007_310, "một triệu không trăm linh bảy nghìn ba trăm mười"],
    [1_123_001, "một triệu một trăm hai mươi ba nghìn không trăm linh một"],
    [51_005_501, "năm mươi mốt triệu không trăm linh năm nghìn năm trăm linh một"],
    [321_005_315, "ba trăm hai mươi mốt triệu không trăm linh năm nghìn ba trăm mười lăm"],
    [1_001_000_000, "một tỷ không trăm linh một triệu"],
    [1_000_000_001, "một tỷ không trăm linh một"],
    [5_000_001_000, "năm tỷ không trăm linh một nghìn"],
    [5_050_011_051, "năm tỷ không trăm năm mươi triệu không trăm mười một nghìn không trăm năm mươi mốt"],
    [55_000_000_001, "năm mươi lăm tỷ không trăm linh một"],
    [111_000_001_000, "một trăm mười một tỷ không trăm linh một nghìn"],
    [1_000_000_000_000, "một nghìn tỷ"],
    [1_000_000_000_001, "một nghìn tỷ không trăm linh một"],
    [1_000_000_001_000, "một nghìn tỷ không trăm linh một nghìn"],
    [1_000_001_000_000, "một nghìn tỷ không trăm linh một triệu"],
    [1_001_000_000_000, "một nghìn không trăm linh một tỷ"],
    [5_132_365_732_902, "năm nghìn một trăm ba mươi hai tỷ ba trăm sáu mươi lăm triệu bảy trăm ba mươi hai nghìn chín trăm linh hai"],
    [1_000_000_000_000_000, "một triệu tỷ"],
    [1_000_000_000_100_000, "một triệu tỷ một trăm nghìn"],
    [1_000_132_365_732_902, "một triệu một trăm ba mươi hai tỷ ba trăm sáu mươi lăm triệu bảy trăm ba mươi hai nghìn chín trăm linh hai"],
    [5_265_132_365_732_902, "năm triệu hai trăm sáu mươi lăm nghìn một trăm ba mươi hai tỷ ba trăm sáu mươi lăm triệu bảy trăm ba mươi hai nghìn chín trăm linh hai"],
    [1_000_000_000_000_000_000, "một tỷ tỷ"],
    [1_000_000_000_000_001_902, "một tỷ tỷ không trăm linh một nghìn chín trăm linh hai"],
    [1_000_000_000_365_732_902, "một tỷ tỷ ba trăm sáu mươi lăm triệu bảy trăm ba mươi hai nghìn chín trăm linh hai"],
    [1_000_000_132_365_732_902, "một tỷ một trăm ba mươi hai tỷ ba trăm sáu mươi lăm triệu bảy trăm ba mươi hai nghìn chín trăm linh hai"],
    [1_019_000_132_365_732_902, "một tỷ không trăm mười chín triệu một trăm ba mươi hai tỷ ba trăm sáu mươi lăm triệu bảy trăm ba mươi hai nghìn chín trăm linh hai"],
    [1_113_789_528_888_007_000, "một tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn"],
    [91_113_789_528_888_007_000, "chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn"],
    [191_113_789_528_888_007_415, "một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_191_113_789_528_888_007_415, "một nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [51_191_113_789_528_888_007_415, "năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [151_191_113_789_528_888_007_415, "một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_000_000_000_000_000_000_000_000, "một triệu tỷ tỷ"],
    [4_151_191_113_789_528_888_007_415, "bốn triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [40_151_191_113_789_528_888_007_415, "bốn mươi triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [401_151_191_113_789_528_888_007_415, "bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [9_401_151_191_113_789_528_888_007_415, "chín tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_000_000_000_000_000_000_000_000_000, "một tỷ tỷ tỷ"],
    [90_401_151_191_113_789_528_888_007_415, "chín mươi tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [905_401_151_191_113_789_528_888_007_415, "chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_905_401_151_191_113_789_528_888_007_415, "hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [72_905_401_151_191_113_789_528_888_007_415, "bảy mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [832_905_401_151_191_113_789_528_888_007_415, "tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_832_905_401_151_191_113_789_528_888_007_415, "một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [61_832_905_401_151_191_113_789_528_888_007_415, "sáu mươi mốt triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [201_832_905_401_151_191_113_789_528_888_007_415, "hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_000_000_000_000_000_000_000_000_000_000_000_000, "một tỷ tỷ tỷ tỷ"],
    [4_201_832_905_401_151_191_113_789_528_888_007_415, "bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [24_201_832_905_401_151_191_113_789_528_888_007_415, "hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [324_201_832_905_401_151_191_113_789_528_888_007_415, "ba trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [4_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [14_024_201_832_905_401_151_191_113_789_528_888_007_415, "mười bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [75_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [4_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [14_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [7_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy nghìn một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [77_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy mươi bảy nghìn một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [777_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy trăm bảy mươi bảy nghìn một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [8_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [88_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám mươi tám triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [6_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [936_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [12_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "mười hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [35_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [75_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm nghìn chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [55_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm mươi lăm nghìn chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [555_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm trăm năm mươi lăm nghìn chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [115_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm mười lăm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [12_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "mười hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [4_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [44_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [7_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [47_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [32_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [7_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [77_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [75_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [9_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [99_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [6_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [66_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [3_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [33_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [6_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [56_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [7_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [47_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [4_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [24_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [65_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [52_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [6_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [46_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [32_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [7_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [47_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [2_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [62_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [5_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [85_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [4_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [24_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [3_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [63_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [4_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [54_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [21_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [3_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [63_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [4_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [14_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [614_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "sáu trăm mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_614_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một triệu sáu trăm mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [81_614_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "tám mươi mốt triệu sáu trăm mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [381_614_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "ba trăm tám mươi mốt triệu sáu trăm mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [1_381_614_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "một tỷ ba trăm tám mươi mốt triệu sáu trăm mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [21_381_614_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "hai mươi mốt tỷ ba trăm tám mươi mốt triệu sáu trăm mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"],
    [921_381_614_863_421_954_863_524_785_362_147_732_846_952_142_365_124_547_856_633_666_999_875_477_632_147_444_102_005_000_975_635_102_036_900_000_114_475_304_024_201_832_905_401_151_191_113_789_528_888_007_415, "chín trăm hai mươi mốt tỷ ba trăm tám mươi mốt triệu sáu trăm mười bốn nghìn tám trăm sáu mươi ba tỷ bốn trăm hai mươi mốt triệu chín trăm năm mươi bốn nghìn tám trăm sáu mươi ba tỷ năm trăm hai mươi bốn triệu bảy trăm tám mươi lăm nghìn ba trăm sáu mươi hai tỷ một trăm bốn mươi bảy triệu bảy trăm ba mươi hai nghìn tám trăm bốn mươi sáu tỷ chín trăm năm mươi hai triệu một trăm bốn mươi hai nghìn ba trăm sáu mươi lăm tỷ một trăm hai mươi bốn triệu năm trăm bốn mươi bảy nghìn tám trăm năm mươi sáu tỷ sáu trăm ba mươi ba triệu sáu trăm sáu mươi sáu nghìn chín trăm chín mươi chín tỷ tám trăm bảy mươi lăm triệu bốn trăm bảy mươi bảy nghìn sáu trăm ba mươi hai tỷ một trăm bốn mươi bảy triệu bốn trăm bốn mươi bốn nghìn một trăm linh hai tỷ không trăm linh năm triệu chín trăm bảy mươi lăm tỷ sáu trăm ba mươi lăm triệu một trăm linh hai nghìn không trăm ba mươi sáu tỷ chín trăm triệu một trăm mười bốn tỷ bốn trăm bảy mươi lăm triệu ba trăm linh bốn nghìn không trăm hai mươi bốn tỷ hai trăm linh một triệu tám trăm ba mươi hai nghìn chín trăm linh năm tỷ bốn trăm linh một triệu một trăm năm mươi mốt nghìn một trăm chín mươi mốt tỷ một trăm mười ba triệu bảy trăm tám mươi chín nghìn năm trăm hai mươi tám tỷ tám trăm tám mươi tám triệu không trăm linh bảy nghìn bốn trăm mười lăm"]
  ]
  # rubocop:enable Metrics/LineLength

  vi_tests.each do |num, output|
    it "#{num} is equal to #{output}" do
      expect(num.humanize).to eq(output)
    end
  end
end
