### WARNING: This file is auto-generated by our OpenAPI spec. Do not
### edit it manually.

require_relative '../../resource_includes/response_helper'

module Asana
  module Resources
    class GoalRelationshipsBase < Resource

      def self.inherited(base)
        Registry.register(base)
      end

      class << self
        # Add a supporting goal relationship
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_supporting_relationship(client, goal_gid: required("goal_gid"), options: {}, **data)
          path = "/goals/{goal_gid}/addSupportingRelationship"
          path["{goal_gid}"] = goal_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Get a goal relationship
        #
        # goal_relationship_gid - [str]  (required) Globally unique identifier for the goal relationship.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_goal_relationship(client, goal_relationship_gid: required("goal_relationship_gid"), options: {})
          path = "/goal_relationships/{goal_relationship_gid}"
          path["{goal_relationship_gid}"] = goal_relationship_gid
          parse(client.get(path, options: options)).first
        end

        # Get goal relationships
        #

        # supported_goal - [str]  (required) Globally unique identifier for the supported goal in the goal relationship.
        # resource_subtype - [str]  If provided, filter to goal relationships with a given resource_subtype.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_goal_relationships(client, supported_goal: nil, resource_subtype: nil, options: {})
          path = "/goal_relationships"
          params = { supported_goal: supported_goal, resource_subtype: resource_subtype }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get(path, params: params, options: options)), type: Resource, client: client)
        end

        # Removes a supporting goal relationship
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_supporting_relationship(client, goal_gid: required("goal_gid"), options: {}, **data)
          path = "/goals/{goal_gid}/removeSupportingRelationship"
          path["{goal_gid}"] = goal_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Update a goal relationship
        #
        # goal_relationship_gid - [str]  (required) Globally unique identifier for the goal relationship.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to PUT
        def update_goal_relationship(client, goal_relationship_gid: required("goal_relationship_gid"), options: {}, **data)
          path = "/goal_relationships/{goal_relationship_gid}"
          path["{goal_relationship_gid}"] = goal_relationship_gid
          parse(client.put(path, body: data, options: options)).first
        end

      end
    end
  end
end
