% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.xts}
\alias{plot.xts}
\alias{lines.xts}
\alias{points.xts}
\title{Plotting xts Objects}
\usage{
\method{plot}{xts}(
  x,
  y = NULL,
  ...,
  subset = "",
  panels = NULL,
  multi.panel = FALSE,
  col = 1:8,
  up.col = NULL,
  dn.col = NULL,
  bg = "#FFFFFF",
  type = "l",
  lty = 1,
  lwd = 2,
  lend = 1,
  main = deparse(substitute(x)),
  main.timespan = TRUE,
  observation.based = FALSE,
  log = FALSE,
  ylim = NULL,
  yaxis.same = TRUE,
  yaxis.left = TRUE,
  yaxis.right = TRUE,
  yaxis.ticks = 5,
  major.ticks = "auto",
  minor.ticks = NULL,
  grid.ticks.on = "auto",
  grid.ticks.lwd = 1,
  grid.ticks.lty = 1,
  grid.col = "darkgray",
  labels.col = "#333333",
  format.labels = TRUE,
  grid2 = "#F5F5F5",
  legend.loc = NULL,
  extend.xaxis = FALSE
)

\method{lines}{xts}(
  x,
  ...,
  main = "",
  on = 0,
  col = NULL,
  type = "l",
  lty = 1,
  lwd = 1,
  pch = 1
)

\method{points}{xts}(x, ..., main = "", on = 0, col = NULL, pch = 1)
}
\arguments{
\item{x}{A xts object.}

\item{y}{Not used, always \code{NULL}.}

\item{\dots}{Any passthrough arguments for \code{lines()} and \code{points()}.}

\item{subset}{An ISO8601-style subset string.}

\item{panels}{Character vector of expressions to plot as panels.}

\item{multi.panel}{Either \code{TRUE}, \code{FALSE}, or an integer less than or equal
to the number of columns in the data set. When \code{TRUE}, each column of the
data is plotted in a separate panel. When an integer 'n', the data will be
plotted in groups of 'n' columns per panel and each group will be plotted
in a separate panel.}

\item{col}{Color palette to use.}

\item{up.col}{Color for positive bars when \code{type = "h"}.}

\item{dn.col}{Color for negative bars when \code{type = "h"}.}

\item{bg}{Background color of plotting area, same as in \code{\link[=par]{par()}}.}

\item{type}{The type of plot to be drawn, same as in \code{\link[=plot]{plot()}}.}

\item{lty}{Set the line type, same as in \code{\link[=par]{par()}}.}

\item{lwd}{Set the line width, same as in \code{\link[=par]{par()}}.}

\item{lend}{Set the line end style, same as in \code{\link[=par]{par()}}.}

\item{main}{Main plot title.}

\item{main.timespan}{Should the timespan of the series be shown in the top
right corner of the plot?}

\item{observation.based}{When \code{TRUE}, all the observations are equally spaced
along the x-axis. When \code{FALSE} (the default) the observations on the x-axis
are spaced based on the time index of the data.}

\item{log}{Should the y-axis be in log scale? Default \code{FALSE}.}

\item{ylim}{The range of the y axis.}

\item{yaxis.same}{Should 'ylim' be the same for every panel? Default \code{TRUE}.}

\item{yaxis.left}{Add y-axis labels to the left side of the plot?}

\item{yaxis.right}{Add y-axis labels to the right side of the plot?}

\item{yaxis.ticks}{Desired number of y-axis grid lines. The actual number of
grid lines is determined by the \code{n} argument to \code{\link[=pretty]{pretty()}}.}

\item{major.ticks}{Period specifying locations for major tick marks and labels
on the x-axis. See Details for possible values.}

\item{minor.ticks}{Period specifying locations for minor tick marks on the
x-axis. When \code{NULL}, minor ticks are not drawn. See details for possible
values.}

\item{grid.ticks.on}{Period specifying locations for vertical grid lines.
See details for possible values.}

\item{grid.ticks.lwd}{Line width of the grid.}

\item{grid.ticks.lty}{Line type of the grid.}

\item{grid.col}{Color of the grid.}

\item{labels.col}{Color of the axis labels.}

\item{format.labels}{Label format to draw lower frequency x-axis ticks and
labels passed to \code{\link[=axTicksByTime]{axTicksByTime()}}}

\item{grid2}{Color for secondary x-axis grid.}

\item{legend.loc}{Places a legend into one of nine locations on the chart:
bottomright, bottom, bottomleft, left, topleft, top, topright, right, or
center. Default \code{NULL} does not draw a legend.}

\item{extend.xaxis}{When \code{TRUE}, extend the x-axis before and/or after the
plot's existing time index range, so all of of the time index values of
the new series are included in the plot. Default \code{FALSE}.}

\item{on}{Panel number to draw on. A new panel will be drawn if \code{on = NA}.
The default, \code{on = 0}, will add to the active panel. The active panel is
defined as the panel on which the most recent action was performed. Note
that only the first element of \code{on} is checked for the default behavior to
add to the last active panel.}

\item{pch}{the plotting character to use, same as in 'par'}
}
\description{
Plotting for xts objects.
}
\details{
Possible values for arguments \code{major.ticks}, \code{minor.ticks}, and
\code{grid.ticks.on} include \sQuote{auto}, \sQuote{minute}, \sQuote{hours},
\sQuote{days}, \sQuote{weeks}, \sQuote{months}, \sQuote{quarters}, and
\sQuote{years}. The default is \sQuote{auto}, which attempts to determine
sensible locations from the periodicity and locations of observations. The
other values are based on the possible values for the \code{ticks.on}
argument of \code{\link[=axTicksByTime]{axTicksByTime()}}.
}
\examples{

\dontrun{
data(sample_matrix)
sample.xts <- as.xts(sample_matrix)

# plot the Close
plot(sample.xts[,"Close"])

# plot a subset of the data
plot(sample.xts[,"Close"], subset = "2007-04-01/2007-06-31")

# function to compute simple returns
simple.ret <- function(x, col.name){
  x[,col.name] / lag(x[,col.name]) - 1
}

# plot the close and add a panel with the simple returns
plot(sample.xts[,"Close"])
R <- simple.ret(sample.xts, "Close")
lines(R, type = "h", on = NA)

# add the 50 period simple moving average to panel 1 of the plot
library(TTR)
lines(SMA(sample.xts[,"Close"], n = 50), on = 1, col = "blue")

# add month end points to the chart
points(sample.xts[endpoints(sample.xts[,"Close"], on = "months"), "Close"], 
       col = "red", pch = 17, on = 1)

# add legend to panel 1
addLegend("topright", on = 1, 
          legend.names = c("Close", "SMA(50)"), 
          lty = c(1, 1), lwd = c(2, 1),
          col = c("black", "blue", "red"))
}

}
\references{
based on \code{\link[quantmod:quantmod-package]{chart_Series()}} in \pkg{quantmod}
written by Jeffrey A. Ryan
}
\seealso{
\code{\link[=addSeries]{addSeries()}}, \code{\link[=addPanel]{addPanel()}}
}
\author{
Ross Bennett
}
