% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedSetCover.R
\name{weightedSetCover}
\alias{weightedSetCover}
\title{Weighted Set Cover}
\usage{
weightedSetCover(idsInSet, costs, topN, nThreads = 4)
}
\arguments{
\item{idsInSet}{A list of set names and their member IDs.}

\item{costs}{A vector of the same length to add weights for penalty, i.e. 1/-logP.}

\item{topN}{The number of sets (or less when it completes early) to return.}

\item{nThreads}{The number of processes to use. In Windows, it fallbacks to 1.}
}
\value{
A list of \code{topSets} and \code{coverage}.
\describe{
 \item{topSets}{A list of set IDs.}
 \item{coverage}{The percentage of IDs covered in the top sets.}
}
}
\description{
Size constrained weighted set cover problem to find top N sets while
maximizing the coverage of all elements.
}
\author{
Zhiao Shi, Yuxing Liao
}
