% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_debug}
\alias{pr_set_debug}
\title{Set debug value to include error messages of routes cause an error}
\usage{
pr_set_debug(pr, debug = FALSE)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{debug}{\code{TRUE} provides more insight into your API errors.}
}
\value{
The Plumber router with the new debug setting.
}
\description{
By default, error messages from your plumber routes are hidden, but can be
turned on by setting the debug value to \code{TRUE} using this setter.
}
\examples{
\dontrun{
# Will contain the original error message
pr() \%>\%
  pr_set_debug(TRUE) \%>\%
  pr_get("/boom", function() stop("boom")) \%>\%
  pr_run()

# Will NOT contain an error message
pr() \%>\%
  pr_set_debug(FALSE) \%>\%
  pr_get("/boom", function() stop("boom")) \%>\%
  pr_run()
}

# Setting within a plumber file
#* @plumber
function(pr) {
  pr \%>\%
    pr_set_debug(TRUE)
}

}
