% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_mixed_model.R
\name{is_mixed_model}
\alias{is_mixed_model}
\title{Checks if a model is a mixed effects model}
\usage{
is_mixed_model(x)
}
\arguments{
\item{x}{A model object.}
}
\value{
A logical, \code{TRUE} if \code{x} is a mixed model.
}
\description{
Small helper that checks if a model is a mixed effects model,
i.e. if it the model has random effects.
}
\examples{
data(mtcars)
model <- lm(mpg ~ wt + cyl + vs, data = mtcars)
is_mixed_model(model)

if (require("lme4")) {
  data(sleepstudy)
  model <- lmer(Reaction ~ Days + (1 | Subject), data = sleepstudy)
  is_mixed_model(model)
}
}
