% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters_gam.R
\name{get_parameters.gamm}
\alias{get_parameters.gamm}
\alias{get_parameters.gam}
\alias{get_parameters.rqss}
\title{Get model parameters from generalized additive models}
\usage{
\method{get_parameters}{gamm}(
  x,
  component = c("all", "conditional", "smooth_terms", "location"),
  ...
)

\method{get_parameters}{gam}(
  x,
  component = c("all", "conditional", "smooth_terms", "location"),
  ...
)

\method{get_parameters}{rqss}(x, component = c("all", "conditional", "smooth_terms"), ...)
}
\arguments{
\item{x}{A fitted model.}

\item{component}{Should all predictor variables, predictor variables for the
 conditional model, the zero-inflated part of the model, the dispersion
 term or the instrumental variables be returned? Applies to models
 with zero-inflated and/or dispersion formula, or to models with instrumental
 variable (so called fixed-effects regressions). May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{...}{Currently not used.}
}
\value{
For models with smooth terms or zero-inflation component, a data
  frame with three columns: the parameter names, the related point estimates
  and the component.
}
\description{
Returns the coefficients from a model.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
