% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/near.R
\name{near}
\alias{near}
\title{Compare two numeric vectors}
\usage{
near(x, y, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x, y}{Numeric vectors to compare}

\item{tol}{Tolerance of comparison.}
}
\description{
This is a safe way of comparing if two vectors of floating point numbers
are (pairwise) equal.  This is safer than using \code{==}, because it has
a built in tolerance
}
\examples{
sqrt(2) ^ 2 == 2
near(sqrt(2) ^ 2, 2)
}
