% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar-count-between}
\alias{calendar-count-between}
\alias{calendar_count_between}
\title{Counting: calendars}
\usage{
calendar_count_between(start, end, precision, ..., n = 1L)
}
\arguments{
\item{start, end}{\verb{[clock_calendar]}

A pair of calendar vectors. These will be recycled to their common size.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the calendar used.}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
An integer representing the number of \code{precision} units between
\code{start} and \code{end}.
}
\description{
\code{calendar_count_between()} counts the number of \code{precision} units between
\code{start} and \code{end} (i.e., the number of years or months). This count
corresponds to the \emph{whole number} of units, and will never return a
fractional value.

This is suitable for, say, computing the whole number of years or months
between two calendar dates, accounting for the day and time of day.

Each calendar has its own help page describing the precisions that you can
count at:
\itemize{
\item \link[=year-month-day-count-between]{year-month-day}
\item \link[=year-month-weekday-count-between]{year-month-weekday}
\item \link[=iso-year-week-day-count-between]{iso-year-week-day}
\item \link[=year-quarter-day-count-between]{year-quarter-day}
\item \link[=year-day-count-between]{year-day}
}
}
\section{Comparison Direction}{

The computed count has the property that if \code{start <= end}, then
\verb{start + <count> <= end}. Similarly, if \code{start >= end}, then
\verb{start + <count> >= end}. In other words, the comparison direction between
\code{start} and \code{end} will never change after adding the count to \code{start}. This
makes this function useful for repeated count computations at
increasingly fine precisions.
}

\examples{
# Number of whole years between these dates
x <- year_month_day(2000, 01, 05)
y <- year_month_day(2005, 01, 04:06)

# Note that `2000-01-05 -> 2005-01-04` is only 4 full years
calendar_count_between(x, y, "year")
}
