% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sva.check.R
\name{sva.check}
\alias{sva.check}
\title{A function for post-hoc checking of an sva object to check for
degenerate cases.}
\usage{
sva.check(svaobj, dat, mod, mod0)
}
\arguments{
\item{svaobj}{The transformed data matrix with the variables in rows and samples in columns}

\item{dat}{The data set that was used to build the surrogate variables}

\item{mod}{The model matrix being used to fit the data}

\item{mod0}{The null model matrix being used to fit the data}
}
\value{
sv The estimated surrogate variables, one in each column

pprob.gam: A vector of the posterior probabilities each gene is affected by heterogeneity

pprob.b A vector of the posterior probabilities each gene is affected by mod

n.sv The number of significant surrogate variables
}
\description{
This function is designed to check for degenerate cases in the
sva fit and fix the sva object where possible.
}
\details{
\code{\link{empirical.controls}} for a direct estimate of the empirical controls.
}
\examples{
library(bladderbatch)
data(bladderdata)
#dat <- bladderEset
dat <- bladderEset[1:5000,]

pheno = pData(dat)
edata = exprs(dat)
mod = model.matrix(~as.factor(cancer), data=pheno)
mod0 = model.matrix(~1,data=pheno)

n.sv = num.sv(edata,mod,method="leek")
svobj = sva(edata,mod,mod0,n.sv=n.sv)
svacheckobj = sva.check(svobj,edata,mod,mod0)

}
