% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeCommunities.R
\name{mergeCommunities}
\alias{mergeCommunities}
\title{Merge communities from graph-based clustering}
\usage{
mergeCommunities(graph, clusters, number = NULL, steps = NULL)
}
\arguments{
\item{graph}{A \link{graph} object from \pkg{igraph}, usually where each node represents an observation.}

\item{clusters}{Factor specifying the cluster identity for each node.}

\item{number}{Integer scalar specifying the number of clusters to obtain.
Ignored if \code{steps} is specified.}

\item{steps}{Integer scalar specifying the number of merge steps.}
}
\value{
A vector or factor of the same length as \code{clusters},
containing the desired number of merged clusters.
}
\description{
Adjust the resolution of a graph-based community detection algorithm by greedily merging clusters together.
At each step, the pair of clusters that yield the highest modularity are merged.
}
\details{
This function is similar to the \code{\link{cut_at}} function from the \pkg{igraph} package,
but works on clusters that were not generated by a hierarchical algorithm.
The aim is to facilitate rapid adjustment of the number of clusters without having to repeat the clustering -
or, even worse, repeating the graph construction, e.g., in \code{\link{makeSNNGraph}}.
}
\examples{
output <- clusterRows(iris[,1:4], NNGraphParam(k=5), full=TRUE)
table(output$clusters)

merged <- mergeCommunities(output$objects$graph, output$clusters, number=3)
table(merged)

}
\seealso{
\code{\link{cut_at}}, for a faster and more natural adjustment when using a hierarchical community detection algorithm.

\linkS4class{NNGraphParam}, for a one-liner to generate graph-based clusters.
}
\author{
Aaron Lun
}
