/*
 * Copyright (c) 2004-2007 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2020 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart,
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * Copyright (c) 2006      University of Houston. All rights reserved.
 * Copyright (c) 2015      Research Organization for Information Science
 *                         and Technology (RIST). All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */
#include "ompi_config.h"
#include <stdio.h>
#include <string.h>

#include "ompi/mpi/c/bindings.h"
#include "ompi/runtime/params.h"
#include "ompi/communicator/communicator.h"
#include "ompi/errhandler/errhandler.h"
#include "ompi/errhandler/errcode.h"

#if OMPI_BUILD_MPI_PROFILING
#if OPAL_HAVE_WEAK_SYMBOLS
#pragma weak MPI_Add_error_string = PMPI_Add_error_string
#endif
#define MPI_Add_error_string PMPI_Add_error_string
#endif

static const char FUNC_NAME[] = "MPI_Add_error_string";


int MPI_Add_error_string(int errorcode, const char *string)
{
    int rc;

    if ( MPI_PARAM_CHECK ) {
        OMPI_ERR_INIT_FINALIZE(FUNC_NAME);

        if ( ompi_mpi_errcode_is_invalid(errorcode) )
            return OMPI_ERRHANDLER_NOHANDLE_INVOKE(MPI_ERR_ARG,
                                          FUNC_NAME);

	if ( ompi_mpi_errcode_is_predefined(errorcode) )
	    return OMPI_ERRHANDLER_NOHANDLE_INVOKE(MPI_ERR_ARG,
					  FUNC_NAME);

	if ( MPI_MAX_ERROR_STRING < (strlen(string)+1) )
	    return OMPI_ERRHANDLER_NOHANDLE_INVOKE(MPI_ERR_ARG,
					  FUNC_NAME);
    }

    rc = ompi_mpi_errnum_add_string (errorcode, string, (int)(strlen(string)+1));
    if ( OMPI_SUCCESS != rc ) {
        return OMPI_ERRHANDLER_NOHANDLE_INVOKE(MPI_ERR_INTERN,
                                      FUNC_NAME);
    }

    return MPI_SUCCESS;
}
