# Operators

The table below lists the operators in the Nix expression language, in
order of precedence (from strongest to weakest binding).

| Name                     | Syntax                              | Associativity | Description                                                                                                                                                                                                                   | Precedence |
| ------------------------ | ----------------------------------- | ------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------- |
| Select                   | *e* `.` *attrpath* \[ `or` *def* \] | none          | Select attribute denoted by the attribute path *attrpath* from set *e*. (An attribute path is a dot-separated list of attribute names.) If the attribute doesn’t exist, return *def* if provided, otherwise abort evaluation. | 1          |
| Application              | *e1* *e2*                           | left          | Call function *e1* with argument *e2*.                                                                                                                                                                                        | 2          |
| Arithmetic Negation      | `-` *e*                             | none          | Arithmetic negation.                                                                                                                                                                                                          | 3          |
| Has Attribute            | *e* `?` *attrpath*                  | none          | Test whether set *e* contains the attribute denoted by *attrpath*; return `true` or `false`.                                                                                                                                  | 4          |
| List Concatenation       | *e1* `++` *e2*                      | right         | List concatenation.                                                                                                                                                                                                           | 5          |
| Multiplication           | *e1* `*` *e2*,                      | left          | Arithmetic multiplication.                                                                                                                                                                                                    | 6          |
| Division                 | *e1* `/` *e2*                       | left          | Arithmetic division.                                                                                                                                                                                                          | 6          |
| Addition                 | *e1* `+` *e2*                       | left          | Arithmetic addition.                                                                                                                                                                                                          | 7          |
| Subtraction              | *e1* `-` *e2*                       | left          | Arithmetic subtraction.                                                                                                                                                                                                       | 7          |
| String Concatenation     | *string1* `+` *string2*             | left          | String concatenation.                                                                                                                                                                                                         | 7          |
| Not                      | `!` *e*                             | none          | Boolean negation.                                                                                                                                                                                                             | 8          |
| Update                   | *e1* `//` *e2*                      | right         | Return a set consisting of the attributes in *e1* and *e2* (with the latter taking precedence over the former in case of equally named attributes).                                                                           | 9          |
| Less Than                | *e1* `<` *e2*,                      | none          | Arithmetic/lexicographic comparison.                                                                                                                                                                                                        | 10         |
| Less Than or Equal To    | *e1* `<=` *e2*                      | none          | Arithmetic/lexicographic comparison.                                                                                                                                                                                                        | 10         |
| Greater Than             | *e1* `>` *e2*                       | none          | Arithmetic/lexicographic comparison.                                                                                                                                                                                                        | 10         |
| Greater Than or Equal To | *e1* `>=` *e2*                      | none          | Arithmetic/lexicographic comparison.                                                                                                                                                                                                        | 10         |
| Equality                 | *e1* `==` *e2*                      | none          | Equality.                                                                                                                                                                                                                     | 11         |
| Inequality               | *e1* `!=` *e2*                      | none          | Inequality.                                                                                                                                                                                                                   | 11         |
| Logical AND              | *e1* `&&` *e2*                      | left          | Logical AND.                                                                                                                                                                                                                  | 12         |
| Logical OR               | *e1* <code>&#124;&#124;</code> *e2* | left          | Logical OR.                                                                                                                                                                                                                   | 13         |
| Logical Implication      | *e1* `->` *e2*                      | none          | Logical implication (equivalent to <code>!e1 &#124;&#124; e2</code>).                                                                                                                                                                            | 14         |
