#!/usr/bin/env python3
# vim: tabstop=8 expandtab shiftwidth=4 softtabstop=4

import os
from pathlib import Path

excludes = ['libtorrent.hpp', 'storage.hpp', 'io_service.hpp']

os.remove('include/libtorrent/libtorrent.hpp')
with open('include/libtorrent/libtorrent.hpp', 'w+') as f:
    f.write('''
// This header is generated by tools/gen_convenience_header.py

''')

    for fn in os.popen('git ls-files include/libtorrent/*.hpp include/libtorrent/kademlia/*.hpp include/libtorrent/extensions/*.hpp'):

        fn = Path(fn.strip())

        if fn.name in excludes: continue

        f.write('#include "%s"\n' % fn.relative_to('include'))
