// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIGroup.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIGroupPrivate {
    friend class OAIGroup;

     QString id;
     bool id_isSet;
     bool id_isValid;

     QString description;
     bool description_isSet;
     bool description_isValid;

     QString display_name;
     bool display_name_isSet;
     bool display_name_isValid;

     QList<QString> group_types;
     bool group_types_isSet;
     bool group_types_isValid;

     QList<OAIUser> members;
     bool members_isSet;
     bool members_isValid;

     QSet<QString> membersodata_bind;
     bool membersodata_bind_isSet;
     bool membersodata_bind_isValid;
};

OAIGroup::OAIGroup()
    : d_ptr()
{
}

OAIGroup::OAIGroup(const OAIGroup& other)
    : d_ptr(other.d_ptr)
{
}

OAIGroup::OAIGroup(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIGroup::~OAIGroup() = default;

void OAIGroup::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIGroupPrivate{});

        Q_D(OAIGroup);


        d->id_isSet = false;
        d->id_isValid = false;

        d->description_isSet = false;
        d->description_isValid = false;

        d->display_name_isSet = false;
        d->display_name_isValid = false;

        d->group_types_isSet = false;
        d->group_types_isValid = false;

        d->members_isSet = false;
        d->members_isValid = false;

        d->membersodata_bind_isSet = false;
        d->membersodata_bind_isValid = false;
    }
}

void OAIGroup::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIGroup::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIGroup);

    d->id_isValid = ::OpenAPI::fromJsonValue(d->id, json[QString("id")]);
    d->id_isSet = !json[QString("id")].isNull() && d->id_isValid;

    d->description_isValid = ::OpenAPI::fromJsonValue(d->description, json[QString("description")]);
    d->description_isSet = !json[QString("description")].isNull() && d->description_isValid;

    d->display_name_isValid = ::OpenAPI::fromJsonValue(d->display_name, json[QString("displayName")]);
    d->display_name_isSet = !json[QString("displayName")].isNull() && d->display_name_isValid;

    d->group_types_isValid = ::OpenAPI::fromJsonValue(d->group_types, json[QString("groupTypes")]);
    d->group_types_isSet = !json[QString("groupTypes")].isNull() && d->group_types_isValid;

    d->members_isValid = ::OpenAPI::fromJsonValue(d->members, json[QString("members")]);
    d->members_isSet = !json[QString("members")].isNull() && d->members_isValid;

    d->membersodata_bind_isValid = ::OpenAPI::fromJsonValue(d->membersodata_bind, json[QString("members@odata.bind")]);
    d->membersodata_bind_isSet = !json[QString("members@odata.bind")].isNull() && d->membersodata_bind_isValid;
}

QString OAIGroup::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIGroup::asJsonObject() const {
    Q_D(const OAIGroup);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->id_isSet) {
        obj.insert(QString("id"), ::OpenAPI::toJsonValue(d->id));
    }
    if (d->description_isSet) {
        obj.insert(QString("description"), ::OpenAPI::toJsonValue(d->description));
    }
    if (d->display_name_isSet) {
        obj.insert(QString("displayName"), ::OpenAPI::toJsonValue(d->display_name));
    }
    if (d->group_types.size() > 0) {
        obj.insert(QString("groupTypes"), ::OpenAPI::toJsonValue(d->group_types));
    }
    if (d->members.size() > 0) {
        obj.insert(QString("members"), ::OpenAPI::toJsonValue(d->members));
    }
    if (d->membersodata_bind.size() > 0) {
        obj.insert(QString("members@odata.bind"), ::OpenAPI::toJsonValue(d->membersodata_bind));
    }
    return obj;
}

QString OAIGroup::getId() const {
    Q_D(const OAIGroup);
    if(!d){
        return {};
    }
    return d->id;
}
void OAIGroup::setId(const QString &id) {
    Q_D(OAIGroup);
    Q_ASSERT(d);

    d->id = id;
    d->id_isSet = true;
}

bool OAIGroup::is_id_Set() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }

    return d->id_isSet;
}

bool OAIGroup::is_id_Valid() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    return d->id_isValid;
}

QString OAIGroup::getDescription() const {
    Q_D(const OAIGroup);
    if(!d){
        return {};
    }
    return d->description;
}
void OAIGroup::setDescription(const QString &description) {
    Q_D(OAIGroup);
    Q_ASSERT(d);

    d->description = description;
    d->description_isSet = true;
}

bool OAIGroup::is_description_Set() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }

    return d->description_isSet;
}

bool OAIGroup::is_description_Valid() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    return d->description_isValid;
}

QString OAIGroup::getDisplayName() const {
    Q_D(const OAIGroup);
    if(!d){
        return {};
    }
    return d->display_name;
}
void OAIGroup::setDisplayName(const QString &display_name) {
    Q_D(OAIGroup);
    Q_ASSERT(d);

    d->display_name = display_name;
    d->display_name_isSet = true;
}

bool OAIGroup::is_display_name_Set() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }

    return d->display_name_isSet;
}

bool OAIGroup::is_display_name_Valid() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    return d->display_name_isValid;
}

QList<QString> OAIGroup::getGroupTypes() const {
    Q_D(const OAIGroup);
    if(!d){
        return {};
    }
    return d->group_types;
}
void OAIGroup::setGroupTypes(const QList<QString> &group_types) {
    Q_D(OAIGroup);
    Q_ASSERT(d);

    d->group_types = group_types;
    d->group_types_isSet = true;
}

bool OAIGroup::is_group_types_Set() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }

    return d->group_types_isSet;
}

bool OAIGroup::is_group_types_Valid() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    return d->group_types_isValid;
}

QList<OAIUser> OAIGroup::getMembers() const {
    Q_D(const OAIGroup);
    if(!d){
        return {};
    }
    return d->members;
}
void OAIGroup::setMembers(const QList<OAIUser> &members) {
    Q_D(OAIGroup);
    Q_ASSERT(d);

    d->members = members;
    d->members_isSet = true;
}

bool OAIGroup::is_members_Set() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }

    return d->members_isSet;
}

bool OAIGroup::is_members_Valid() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    return d->members_isValid;
}

QSet<QString> OAIGroup::getMembersodataBind() const {
    Q_D(const OAIGroup);
    if(!d){
        return {};
    }
    return d->membersodata_bind;
}
void OAIGroup::setMembersodataBind(const QSet<QString> &membersodata_bind) {
    Q_D(OAIGroup);
    Q_ASSERT(d);

    d->membersodata_bind = membersodata_bind;
    d->membersodata_bind_isSet = true;
}

bool OAIGroup::is_membersodata_bind_Set() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }

    return d->membersodata_bind_isSet;
}

bool OAIGroup::is_membersodata_bind_Valid() const{
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    return d->membersodata_bind_isValid;
}

bool OAIGroup::isSet() const {
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->id_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->description_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->display_name_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->group_types.size() > 0) {
            isObjectUpdated = true;
            break;
        }

        if (d->members.size() > 0) {
            isObjectUpdated = true;
            break;
        }

        if (d->membersodata_bind.size() > 0) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIGroup::isValid() const {
    Q_D(const OAIGroup);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return true;
}

} // namespace OpenAPI
