/* WARNING: auto-generated (by autogen/speed); do not edit */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <cpucycles.h> /* -lcpucycles */
#include <lib1305.h> /* -l1305 */
#include <randombytes.h> /* -lrandombytes */

static const char *targeto = 0;
static const char *targetp = 0;
static const char *targeti = 0;

#include "limits.inc"

static void *callocplus(long long len)
{
  void *x = calloc(1,len + 128);
  if (!x) abort();
  return x;
}

static void *aligned(void *x)
{
  unsigned char *y = x;
  y += 63 & (-(unsigned long) x);
  return y;
}

static void longlong_sort(long long *x,long long n)
{
  long long top,p,q,r,i;

  if (n < 2) return;
  top = 1;
  while (top < n - top) top += top;

  for (p = top;p > 0;p >>= 1) {
    for (i = 0;i < n - p;++i)
      if (!(i & p))
        if (x[i] > x[i+p]) {
          long long t = x[i];
          x[i] = x[i+p];
          x[i+p] = t;
        }
    i = 0;
    for (q = top;q > p;q >>= 1) {
      for (;i < n - q;++i) {
        if (!(i & p)) {
          long long a = x[i + p];
          for (r = q;r > p;r >>= 1)
            if (a > x[i+r]) {
              long long t = a;
              a = x[i+r];
              x[i+r] = t;
            }
          x[i + p] = a;
        }
      }
    }
  }
}

#define TIMINGS 32 // must be multiple of 4
static long long t[TIMINGS+1];

static void t_print(const char *op,long long impl,long long len)
{
  long long tsort[TIMINGS];
  long long iqm = 0;

  printf("%s",op);
  if (impl >= 0)
    printf(" %lld",impl);
  else
    printf(" selected");
  printf(" %lld",len);
  for (long long i = 0;i < TIMINGS;++i)
    tsort[i] = t[i] = t[i+1]-t[i];
  longlong_sort(tsort,TIMINGS);

  for (long long j = TIMINGS/4;j < 3*TIMINGS/4;++j)
    iqm += tsort[j];
  iqm *= 2;
  iqm += TIMINGS/2;
  iqm /= TIMINGS;

  printf(" %lld ",iqm);
  for (long long i = 0;i < TIMINGS;++i)
    printf("%+lld",t[i]-iqm);
  printf("\n");
  fflush(stdout);
}

#define MAXTEST_BYTES 65536

static void measure_cpucycles(void)
{
  printf("cpucycles selected persecond %lld\n",cpucycles_persecond());
  printf("cpucycles selected implementation %s\n",cpucycles_implementation());

  for (long long i = 0;i <= TIMINGS;++i)
    t[i] = cpucycles();
  t_print("cpucycles",-1,0);
}

static void measure_randombytes(void)
{
  void *mstorage = callocplus(MAXTEST_BYTES);
  unsigned char *m = aligned(mstorage);
  long long mlen = 0;

  while (mlen < MAXTEST_BYTES) {
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      randombytes(m,mlen);
    }
    t_print("randombytes",-1,mlen);
    mlen += 1+mlen/2;
  }
  free(mstorage);
}

static void measure_verify_16(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"16")) return;
  void *xstorage = callocplus(lib1305_verify_16_BYTES);
  unsigned char *x = aligned(xstorage);
  void *ystorage = callocplus(lib1305_verify_16_BYTES);
  unsigned char *y = aligned(ystorage);

  for (long long impl = -1;impl < lib1305_numimpl_verify_16();++impl) {
    int (*crypto_verify)(const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,lib1305_dispatch_verify_16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_verify = lib1305_dispatch_verify_16(impl);
      printf("verify_16 %lld implementation %s compiler %s\n",impl,lib1305_dispatch_verify_16_implementation(impl),lib1305_dispatch_verify_16_compiler(impl));
    } else {
      crypto_verify = lib1305_verify_16;
      printf("verify_16 selected implementation %s compiler %s\n",lib1305_verify_16_implementation(),lib1305_verify_16_compiler());
    }
    randombytes(x,lib1305_verify_16_BYTES);
    randombytes(y,lib1305_verify_16_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_verify(x,y);
    }
    t_print("verify_16",impl,lib1305_verify_16_BYTES);
  }
  free(ystorage);
  free(xstorage);
}

static void measure_onetimeauth_poly1305(void)
{
  if (targeto && strcmp(targeto,"onetimeauth")) return;
  if (targetp && strcmp(targetp,"poly1305")) return;
  void *hstorage = callocplus(lib1305_onetimeauth_poly1305_BYTES);
  unsigned char *h = aligned(hstorage);
  void *mstorage = callocplus(MAXTEST_BYTES);
  unsigned char *m = aligned(mstorage);
  long long mlen;
  void *kstorage = callocplus(lib1305_onetimeauth_poly1305_KEYBYTES);
  unsigned char *k = aligned(kstorage);

  for (long long impl = -1;impl < lib1305_numimpl_onetimeauth_poly1305();++impl) {
    void (*crypto_onetimeauth)(unsigned char *,const unsigned char *,long long,const unsigned char *);
    int (*crypto_onetimeauth_verify)(const unsigned char *,const unsigned char *,long long,const unsigned char *);
    if (targeti && strcmp(targeti,lib1305_dispatch_onetimeauth_poly1305_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_onetimeauth = lib1305_dispatch_onetimeauth_poly1305(impl);
      crypto_onetimeauth_verify = lib1305_dispatch_onetimeauth_poly1305_verify(impl);
      printf("onetimeauth_poly1305 %lld implementation %s compiler %s\n",impl,lib1305_dispatch_onetimeauth_poly1305_implementation(impl),lib1305_dispatch_onetimeauth_poly1305_compiler(impl));
    } else {
      crypto_onetimeauth = lib1305_onetimeauth_poly1305;
      crypto_onetimeauth_verify = lib1305_onetimeauth_poly1305_verify;
      printf("onetimeauth_poly1305 selected implementation %s compiler %s\n",lib1305_onetimeauth_poly1305_implementation(),lib1305_onetimeauth_poly1305_compiler());
    }
    randombytes(h,lib1305_onetimeauth_poly1305_BYTES);
    randombytes(m,MAXTEST_BYTES);
    randombytes(k,lib1305_onetimeauth_poly1305_KEYBYTES);
    mlen = 0;
    while (mlen <= MAXTEST_BYTES) {
      randombytes(m,mlen);
      for (long long i = 0;i <= TIMINGS;++i) {
        t[i] = cpucycles();
        crypto_onetimeauth(h,m,mlen,k);
      }
      t_print("onetimeauth_poly1305",impl,mlen);
      mlen += 1+mlen/2;
    }
    mlen = 0;
    while (mlen <= MAXTEST_BYTES) {
      randombytes(m,mlen);
      for (long long i = 0;i <= TIMINGS;++i) {
        t[i] = cpucycles();
        crypto_onetimeauth_verify(h,m,mlen,k);
      }
      t_print("onetimeauth_poly1305_verify",impl,mlen);
      mlen += 1+mlen/2;
    }
  }
  free(kstorage);
  free(mstorage);
  free(hstorage);
}

#include "print_cpuid.inc"

int main(int argc,char **argv)
{
  printf("lib1305 version %s\n",lib1305_version);
  printf("lib1305 arch %s\n",lib1305_arch);
  print_cpuid();

  if (*argv) ++argv;
  if (*argv) {
    targeto = *argv++;
    if (*argv) {
      targetp = *argv++;
      if (*argv) {
        targeti = *argv++;
      }
    }
  }

  measure_cpucycles();
  measure_randombytes();
  limits();
  measure_verify_16();
  measure_onetimeauth_poly1305();

  return 0;
}
