; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-linux-gnu  -mattr=+sse4.2 < %s | FileCheck %s --check-prefixes=ALL,SSE,SSE42
; RUN: llc -mtriple=x86_64-unknown-linux-gnu  -mattr=+avx < %s | FileCheck %s --check-prefixes=ALL,AVX,AVX1
; RUN: llc -mtriple=x86_64-unknown-linux-gnu  -mattr=+avx2 < %s | FileCheck %s --check-prefixes=ALL,AVX,AVX2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu  -mattr=+avx512f < %s | FileCheck %s --check-prefixes=ALL,AVX512

;
; vXf32
;

define <4 x float> @gather_v4f32_ptr_v4i32(<4 x float*> %ptr, <4 x i32> %trigger, <4 x float> %passthru) {
; SSE-LABEL: gather_v4f32_ptr_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE-NEXT:    pextrb $0, %xmm4, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB0_2
; SSE-NEXT:  # %bb.1: # %cond.load
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    movss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE-NEXT:    blendps {{.*#+}} xmm3 = xmm5[0],xmm3[1,2,3]
; SSE-NEXT:  .LBB0_2: # %else
; SSE-NEXT:    pextrb $4, %xmm4, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB0_4
; SSE-NEXT:  # %bb.3: # %cond.load1
; SSE-NEXT:    pextrq $1, %xmm0, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],mem[0],xmm3[2,3]
; SSE-NEXT:  .LBB0_4: # %else2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pextrb $8, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB0_6
; SSE-NEXT:  # %bb.5: # %cond.load4
; SSE-NEXT:    movq %xmm1, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],mem[0],xmm3[3]
; SSE-NEXT:  .LBB0_6: # %else5
; SSE-NEXT:    pextrb $12, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB0_8
; SSE-NEXT:  # %bb.7: # %cond.load7
; SSE-NEXT:    pextrq $1, %xmm1, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1,2],mem[0]
; SSE-NEXT:  .LBB0_8: # %else8
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: gather_v4f32_ptr_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB0_2
; AVX1-NEXT:  # %bb.1: # %cond.load
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vmovss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX1-NEXT:    vblendps {{.*#+}} xmm2 = xmm4[0],xmm2[1,2,3]
; AVX1-NEXT:  .LBB0_2: # %else
; AVX1-NEXT:    vpextrb $4, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB0_4
; AVX1-NEXT:  # %bb.3: # %cond.load1
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; AVX1-NEXT:  .LBB0_4: # %else2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je .LBB0_6
; AVX1-NEXT:  # %bb.5: # %cond.load4
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX1-NEXT:  .LBB0_6: # %else5
; AVX1-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB0_8
; AVX1-NEXT:  # %bb.7: # %cond.load7
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX1-NEXT:  .LBB0_8: # %else8
; AVX1-NEXT:    vmovaps %xmm2, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: gather_v4f32_ptr_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX2-NEXT:    vpextrb $0, %xmm3, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB0_2
; AVX2-NEXT:  # %bb.1: # %cond.load
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vmovss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm4[0],xmm2[1,2,3]
; AVX2-NEXT:  .LBB0_2: # %else
; AVX2-NEXT:    vpextrb $4, %xmm3, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB0_4
; AVX2-NEXT:  # %bb.3: # %cond.load1
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; AVX2-NEXT:  .LBB0_4: # %else2
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je .LBB0_6
; AVX2-NEXT:  # %bb.5: # %cond.load4
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX2-NEXT:  .LBB0_6: # %else5
; AVX2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB0_8
; AVX2-NEXT:  # %bb.7: # %cond.load7
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX2-NEXT:  .LBB0_8: # %else8
; AVX2-NEXT:    vmovaps %xmm2, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: gather_v4f32_ptr_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm2 killed $xmm2 def $ymm2
; AVX512-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vptestnmd %zmm1, %zmm1, %k0
; AVX512-NEXT:    kshiftlw $12, %k0, %k0
; AVX512-NEXT:    kshiftrw $12, %k0, %k1
; AVX512-NEXT:    vgatherqps (,%zmm0), %ymm2 {%k1}
; AVX512-NEXT:    vmovaps %xmm2, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*> %ptr, i32 4, <4 x i1> %mask, <4 x float> %passthru)
  ret <4 x float> %res
}

define <4 x float> @gather_v4f32_v4i32_v4i32(float* %base, <4 x i32> %idx, <4 x i32> %trigger, <4 x float> %passthru) {
; SSE-LABEL: gather_v4f32_v4i32_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movq %rdi, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,0,1]
; SSE-NEXT:    pmovsxdq %xmm0, %xmm4
; SSE-NEXT:    psllq $2, %xmm4
; SSE-NEXT:    paddq %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE-NEXT:    pmovsxdq %xmm0, %xmm0
; SSE-NEXT:    pxor %xmm5, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm5
; SSE-NEXT:    pextrb $0, %xmm5, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB1_2
; SSE-NEXT:  # %bb.1: # %cond.load
; SSE-NEXT:    movq %xmm4, %rax
; SSE-NEXT:    movss {{.*#+}} xmm6 = mem[0],zero,zero,zero
; SSE-NEXT:    blendps {{.*#+}} xmm2 = xmm6[0],xmm2[1,2,3]
; SSE-NEXT:  .LBB1_2: # %else
; SSE-NEXT:    psllq $2, %xmm0
; SSE-NEXT:    pextrb $4, %xmm5, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB1_4
; SSE-NEXT:  # %bb.3: # %cond.load1
; SSE-NEXT:    pextrq $1, %xmm4, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; SSE-NEXT:  .LBB1_4: # %else2
; SSE-NEXT:    paddq %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pextrb $8, %xmm1, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB1_6
; SSE-NEXT:  # %bb.5: # %cond.load4
; SSE-NEXT:    movq %xmm3, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; SSE-NEXT:  .LBB1_6: # %else5
; SSE-NEXT:    pextrb $12, %xmm1, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB1_8
; SSE-NEXT:  # %bb.7: # %cond.load7
; SSE-NEXT:    pextrq $1, %xmm3, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; SSE-NEXT:  .LBB1_8: # %else8
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: gather_v4f32_v4i32_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq %rdi, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,0,1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm4, %xmm4
; AVX1-NEXT:    vpsllq $2, %xmm4, %xmm4
; AVX1-NEXT:    vpaddq %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vpsllq $2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB1_2
; AVX1-NEXT:  # %bb.1: # %cond.load
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vmovd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1],xmm2[2,3,4,5,6,7]
; AVX1-NEXT:  .LBB1_2: # %else
; AVX1-NEXT:    vpextrb $4, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB1_4
; AVX1-NEXT:  # %bb.3: # %cond.load1
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; AVX1-NEXT:  .LBB1_4: # %else2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je .LBB1_6
; AVX1-NEXT:  # %bb.5: # %cond.load4
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX1-NEXT:  .LBB1_6: # %else5
; AVX1-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB1_8
; AVX1-NEXT:  # %bb.7: # %cond.load7
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX1-NEXT:  .LBB1_8: # %else8
; AVX1-NEXT:    vmovaps %xmm2, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: gather_v4f32_v4i32_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq %rdi, %xmm3
; AVX2-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vpsllq $2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX2-NEXT:    vpextrb $0, %xmm3, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB1_2
; AVX2-NEXT:  # %bb.1: # %cond.load
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vmovss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm4[0],xmm2[1,2,3]
; AVX2-NEXT:  .LBB1_2: # %else
; AVX2-NEXT:    vpextrb $4, %xmm3, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB1_4
; AVX2-NEXT:  # %bb.3: # %cond.load1
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; AVX2-NEXT:  .LBB1_4: # %else2
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je .LBB1_6
; AVX2-NEXT:  # %bb.5: # %cond.load4
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX2-NEXT:  .LBB1_6: # %else5
; AVX2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB1_8
; AVX2-NEXT:  # %bb.7: # %cond.load7
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX2-NEXT:  .LBB1_8: # %else8
; AVX2-NEXT:    vmovaps %xmm2, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: gather_v4f32_v4i32_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512-NEXT:    vptestnmd %zmm1, %zmm1, %k0
; AVX512-NEXT:    kshiftlw $12, %k0, %k0
; AVX512-NEXT:    kshiftrw $12, %k0, %k1
; AVX512-NEXT:    vgatherdps (%rdi,%zmm0,4), %zmm2 {%k1}
; AVX512-NEXT:    vmovaps %xmm2, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vptr0 = insertelement <4 x float*> undef, float* %base, i32 0
  %vptr1 = shufflevector <4 x float*> %vptr0, <4 x float*> undef, <4 x i32> zeroinitializer
  %vptr2 = getelementptr float, <4 x float*> %vptr1, <4 x i32> %idx

  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*> %vptr2, i32 4, <4 x i1> %mask, <4 x float> %passthru)
  ret <4 x float> %res
}

define <4 x float> @gather_v4f32_v4i64_v4i32(float* %base, <4 x i64> %idx, <4 x i32> %trigger, <4 x float> %passthru) {
; SSE-LABEL: gather_v4f32_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movq %rdi, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,0,1]
; SSE-NEXT:    psllq $2, %xmm0
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm5, %xmm5
; SSE-NEXT:    pcmpeqd %xmm2, %xmm5
; SSE-NEXT:    pextrb $0, %xmm5, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB2_2
; SSE-NEXT:  # %bb.1: # %cond.load
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    movss {{.*#+}} xmm6 = mem[0],zero,zero,zero
; SSE-NEXT:    blendps {{.*#+}} xmm3 = xmm6[0],xmm3[1,2,3]
; SSE-NEXT:  .LBB2_2: # %else
; SSE-NEXT:    psllq $2, %xmm1
; SSE-NEXT:    pextrb $4, %xmm5, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB2_4
; SSE-NEXT:  # %bb.3: # %cond.load1
; SSE-NEXT:    pextrq $1, %xmm0, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],mem[0],xmm3[2,3]
; SSE-NEXT:  .LBB2_4: # %else2
; SSE-NEXT:    paddq %xmm1, %xmm4
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pextrb $8, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB2_6
; SSE-NEXT:  # %bb.5: # %cond.load4
; SSE-NEXT:    movq %xmm4, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],mem[0],xmm3[3]
; SSE-NEXT:  .LBB2_6: # %else5
; SSE-NEXT:    pextrb $12, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB2_8
; SSE-NEXT:  # %bb.7: # %cond.load7
; SSE-NEXT:    pextrq $1, %xmm4, %rax
; SSE-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1,2],mem[0]
; SSE-NEXT:  .LBB2_8: # %else8
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: gather_v4f32_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsllq $2, %xmm3, %xmm3
; AVX1-NEXT:    vmovq %rdi, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,1,0,1]
; AVX1-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsllq $2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB2_2
; AVX1-NEXT:  # %bb.1: # %cond.load
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vmovd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1],xmm2[2,3,4,5,6,7]
; AVX1-NEXT:  .LBB2_2: # %else
; AVX1-NEXT:    vpextrb $4, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB2_4
; AVX1-NEXT:  # %bb.3: # %cond.load1
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; AVX1-NEXT:  .LBB2_4: # %else2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je .LBB2_6
; AVX1-NEXT:  # %bb.5: # %cond.load4
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX1-NEXT:  .LBB2_6: # %else5
; AVX1-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB2_8
; AVX1-NEXT:  # %bb.7: # %cond.load7
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX1-NEXT:  .LBB2_8: # %else8
; AVX1-NEXT:    vmovaps %xmm2, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: gather_v4f32_v4i64_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq %rdi, %xmm3
; AVX2-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-NEXT:    vpsllq $2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX2-NEXT:    vpextrb $0, %xmm3, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB2_2
; AVX2-NEXT:  # %bb.1: # %cond.load
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vmovss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm4[0],xmm2[1,2,3]
; AVX2-NEXT:  .LBB2_2: # %else
; AVX2-NEXT:    vpextrb $4, %xmm3, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB2_4
; AVX2-NEXT:  # %bb.3: # %cond.load1
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; AVX2-NEXT:  .LBB2_4: # %else2
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je .LBB2_6
; AVX2-NEXT:  # %bb.5: # %cond.load4
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX2-NEXT:  .LBB2_6: # %else5
; AVX2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB2_8
; AVX2-NEXT:  # %bb.7: # %cond.load7
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX2-NEXT:  .LBB2_8: # %else8
; AVX2-NEXT:    vmovaps %xmm2, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: gather_v4f32_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm2 killed $xmm2 def $ymm2
; AVX512-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vptestnmd %zmm1, %zmm1, %k0
; AVX512-NEXT:    kshiftlw $12, %k0, %k0
; AVX512-NEXT:    kshiftrw $12, %k0, %k1
; AVX512-NEXT:    vgatherqps (%rdi,%zmm0,4), %ymm2 {%k1}
; AVX512-NEXT:    vmovaps %xmm2, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vptr0 = insertelement <4 x float*> undef, float* %base, i32 0
  %vptr1 = shufflevector <4 x float*> %vptr0, <4 x float*> undef, <4 x i32> zeroinitializer
  %vptr2 = getelementptr float, <4 x float*> %vptr1, <4 x i64> %idx

  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*> %vptr2, i32 4, <4 x i1> %mask, <4 x float> %passthru)
  ret <4 x float> %res
}

;
; vXi8
;

define <16 x i8> @gather_v16i8_v16i32_v16i8(i8* %base, <16 x i32> %idx, <16 x i8> %trigger, <16 x i8> %passthru) {
; SSE-LABEL: gather_v16i8_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq %rdi, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm6[0,1,0,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,0,1]
; SSE-NEXT:    pmovsxdq %xmm0, %xmm0
; SSE-NEXT:    paddq %xmm8, %xmm0
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    pcmpeqb %xmm4, %xmm6
; SSE-NEXT:    pextrb $0, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_2
; SSE-NEXT:  # %bb.1: # %cond.load
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    pinsrb $0, (%rax), %xmm5
; SSE-NEXT:  .LBB3_2: # %else
; SSE-NEXT:    pmovsxdq %xmm7, %xmm7
; SSE-NEXT:    pextrb $1, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_4
; SSE-NEXT:  # %bb.3: # %cond.load1
; SSE-NEXT:    pextrq $1, %xmm0, %rax
; SSE-NEXT:    pinsrb $1, (%rax), %xmm5
; SSE-NEXT:  .LBB3_4: # %else2
; SSE-NEXT:    paddq %xmm8, %xmm7
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    pcmpeqb %xmm4, %xmm6
; SSE-NEXT:    pextrb $2, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_6
; SSE-NEXT:  # %bb.5: # %cond.load4
; SSE-NEXT:    movq %xmm7, %rax
; SSE-NEXT:    pinsrb $2, (%rax), %xmm5
; SSE-NEXT:  .LBB3_6: # %else5
; SSE-NEXT:    pmovsxdq %xmm1, %xmm0
; SSE-NEXT:    pextrb $3, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_8
; SSE-NEXT:  # %bb.7: # %cond.load7
; SSE-NEXT:    pextrq $1, %xmm7, %rax
; SSE-NEXT:    pinsrb $3, (%rax), %xmm5
; SSE-NEXT:  .LBB3_8: # %else8
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; SSE-NEXT:    paddq %xmm8, %xmm0
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    pcmpeqb %xmm4, %xmm6
; SSE-NEXT:    pextrb $4, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_10
; SSE-NEXT:  # %bb.9: # %cond.load10
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    pinsrb $4, (%rax), %xmm5
; SSE-NEXT:  .LBB3_10: # %else11
; SSE-NEXT:    pmovsxdq %xmm1, %xmm1
; SSE-NEXT:    pextrb $5, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_12
; SSE-NEXT:  # %bb.11: # %cond.load13
; SSE-NEXT:    pextrq $1, %xmm0, %rax
; SSE-NEXT:    pinsrb $5, (%rax), %xmm5
; SSE-NEXT:  .LBB3_12: # %else14
; SSE-NEXT:    paddq %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    pcmpeqb %xmm4, %xmm6
; SSE-NEXT:    pextrb $6, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_14
; SSE-NEXT:  # %bb.13: # %cond.load16
; SSE-NEXT:    movq %xmm1, %rax
; SSE-NEXT:    pinsrb $6, (%rax), %xmm5
; SSE-NEXT:  .LBB3_14: # %else17
; SSE-NEXT:    pmovsxdq %xmm2, %xmm0
; SSE-NEXT:    pextrb $7, %xmm6, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_16
; SSE-NEXT:  # %bb.15: # %cond.load19
; SSE-NEXT:    pextrq $1, %xmm1, %rax
; SSE-NEXT:    pinsrb $7, (%rax), %xmm5
; SSE-NEXT:  .LBB3_16: # %else20
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,3,0,1]
; SSE-NEXT:    paddq %xmm8, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqb %xmm4, %xmm2
; SSE-NEXT:    pextrb $8, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_18
; SSE-NEXT:  # %bb.17: # %cond.load22
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    pinsrb $8, (%rax), %xmm5
; SSE-NEXT:  .LBB3_18: # %else23
; SSE-NEXT:    pmovsxdq %xmm1, %xmm1
; SSE-NEXT:    pextrb $9, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_20
; SSE-NEXT:  # %bb.19: # %cond.load25
; SSE-NEXT:    pextrq $1, %xmm0, %rax
; SSE-NEXT:    pinsrb $9, (%rax), %xmm5
; SSE-NEXT:  .LBB3_20: # %else26
; SSE-NEXT:    paddq %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqb %xmm4, %xmm2
; SSE-NEXT:    pextrb $10, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_22
; SSE-NEXT:  # %bb.21: # %cond.load28
; SSE-NEXT:    movq %xmm1, %rax
; SSE-NEXT:    pinsrb $10, (%rax), %xmm5
; SSE-NEXT:  .LBB3_22: # %else29
; SSE-NEXT:    pmovsxdq %xmm3, %xmm0
; SSE-NEXT:    pextrb $11, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_24
; SSE-NEXT:  # %bb.23: # %cond.load31
; SSE-NEXT:    pextrq $1, %xmm1, %rax
; SSE-NEXT:    pinsrb $11, (%rax), %xmm5
; SSE-NEXT:  .LBB3_24: # %else32
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[2,3,0,1]
; SSE-NEXT:    paddq %xmm8, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqb %xmm4, %xmm2
; SSE-NEXT:    pextrb $12, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_26
; SSE-NEXT:  # %bb.25: # %cond.load34
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    pinsrb $12, (%rax), %xmm5
; SSE-NEXT:  .LBB3_26: # %else35
; SSE-NEXT:    pmovsxdq %xmm1, %xmm1
; SSE-NEXT:    pextrb $13, %xmm2, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_28
; SSE-NEXT:  # %bb.27: # %cond.load37
; SSE-NEXT:    pextrq $1, %xmm0, %rax
; SSE-NEXT:    pinsrb $13, (%rax), %xmm5
; SSE-NEXT:  .LBB3_28: # %else38
; SSE-NEXT:    paddq %xmm1, %xmm8
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE-NEXT:    pextrb $14, %xmm4, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_30
; SSE-NEXT:  # %bb.29: # %cond.load40
; SSE-NEXT:    movq %xmm8, %rax
; SSE-NEXT:    pinsrb $14, (%rax), %xmm5
; SSE-NEXT:  .LBB3_30: # %else41
; SSE-NEXT:    pextrb $15, %xmm4, %eax
; SSE-NEXT:    testb $1, %al
; SSE-NEXT:    je .LBB3_32
; SSE-NEXT:  # %bb.31: # %cond.load43
; SSE-NEXT:    pextrq $1, %xmm8, %rax
; SSE-NEXT:    pinsrb $15, (%rax), %xmm5
; SSE-NEXT:  .LBB3_32: # %else44
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: gather_v16i8_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq %rdi, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,1,0,1]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm6, %xmm6
; AVX1-NEXT:    vpaddq %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm2, %xmm6
; AVX1-NEXT:    vpextrb $0, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_2
; AVX1-NEXT:  # %bb.1: # %cond.load
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $0, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_2: # %else
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm5
; AVX1-NEXT:    vpextrb $1, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_4
; AVX1-NEXT:  # %bb.3: # %cond.load1
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $1, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_4: # %else2
; AVX1-NEXT:    vpmovsxdq %xmm7, %xmm6
; AVX1-NEXT:    vpaddq %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpcmpeqb %xmm7, %xmm2, %xmm7
; AVX1-NEXT:    vpextrb $2, %xmm7, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je .LBB3_6
; AVX1-NEXT:  # %bb.5: # %cond.load4
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $2, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_6: # %else5
; AVX1-NEXT:    vpaddq %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpextrb $3, %xmm7, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_8
; AVX1-NEXT:  # %bb.7: # %cond.load7
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $3, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_8: # %else8
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm0
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqb %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpextrb $4, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_10
; AVX1-NEXT:  # %bb.9: # %cond.load10
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $4, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_10: # %else11
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm7
; AVX1-NEXT:    vpextrb $5, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_12
; AVX1-NEXT:  # %bb.11: # %cond.load13
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $5, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_12: # %else14
; AVX1-NEXT:    vpmovsxdq %xmm6, %xmm6
; AVX1-NEXT:    vpaddq %xmm7, %xmm4, %xmm5
; AVX1-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpcmpeqb %xmm7, %xmm2, %xmm7
; AVX1-NEXT:    vpextrb $6, %xmm7, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je .LBB3_14
; AVX1-NEXT:  # %bb.13: # %cond.load16
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $6, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_14: # %else17
; AVX1-NEXT:    vpaddq %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpextrb $7, %xmm7, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_16
; AVX1-NEXT:  # %bb.15: # %cond.load19
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $7, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_16: # %else20
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm0
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqb %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpextrb $8, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_18
; AVX1-NEXT:  # %bb.17: # %cond.load22
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $8, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_18: # %else23
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $9, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_20
; AVX1-NEXT:  # %bb.19: # %cond.load25
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $9, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_20: # %else26
; AVX1-NEXT:    vpmovsxdq %xmm6, %xmm5
; AVX1-NEXT:    vpaddq %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm2, %xmm6
; AVX1-NEXT:    vpextrb $10, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je .LBB3_22
; AVX1-NEXT:  # %bb.21: # %cond.load28
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $10, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_22: # %else29
; AVX1-NEXT:    vpaddq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $11, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_24
; AVX1-NEXT:  # %bb.23: # %cond.load31
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $11, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_24: # %else32
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_26
; AVX1-NEXT:  # %bb.25: # %cond.load34
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $12, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_26: # %else35
; AVX1-NEXT:    vpextrb $13, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_28
; AVX1-NEXT:  # %bb.27: # %cond.load37
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $13, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_28: # %else38
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je .LBB3_30
; AVX1-NEXT:  # %bb.29: # %cond.load40
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vpinsrb $14, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_30: # %else41
; AVX1-NEXT:    vpextrb $15, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je .LBB3_32
; AVX1-NEXT:  # %bb.31: # %cond.load43
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vpinsrb $15, (%rax), %xmm3, %xmm3
; AVX1-NEXT:  .LBB3_32: # %else44
; AVX1-NEXT:    vmovdqa %xmm3, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: gather_v16i8_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq %rdi, %xmm4
; AVX2-NEXT:    vpbroadcastq %xmm4, %ymm4
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm5
; AVX2-NEXT:    vpaddq %ymm5, %ymm4, %ymm5
; AVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm2, %xmm6
; AVX2-NEXT:    vpextrb $0, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_2
; AVX2-NEXT:  # %bb.1: # %cond.load
; AVX2-NEXT:    vmovq %xmm5, %rax
; AVX2-NEXT:    vpinsrb $0, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_2: # %else
; AVX2-NEXT:    vpextrb $1, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_4
; AVX2-NEXT:  # %bb.3: # %cond.load1
; AVX2-NEXT:    vpextrq $1, %xmm5, %rax
; AVX2-NEXT:    vpinsrb $1, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_4: # %else2
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm2, %xmm6
; AVX2-NEXT:    vpextrb $2, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-NEXT:    je .LBB3_6
; AVX2-NEXT:  # %bb.5: # %cond.load4
; AVX2-NEXT:    vmovq %xmm5, %rax
; AVX2-NEXT:    vpinsrb $2, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_6: # %else5
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vpextrb $3, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_8
; AVX2-NEXT:  # %bb.7: # %cond.load7
; AVX2-NEXT:    vpextrq $1, %xmm5, %rax
; AVX2-NEXT:    vpinsrb $3, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_8: # %else8
; AVX2-NEXT:    vpaddq %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqb %xmm5, %xmm2, %xmm5
; AVX2-NEXT:    vpextrb $4, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_10
; AVX2-NEXT:  # %bb.9: # %cond.load10
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vpinsrb $4, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_10: # %else11
; AVX2-NEXT:    vpextrb $5, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_12
; AVX2-NEXT:  # %bb.11: # %cond.load13
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vpinsrb $5, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_12: # %else14
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqb %xmm5, %xmm2, %xmm5
; AVX2-NEXT:    vpextrb $6, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je .LBB3_14
; AVX2-NEXT:  # %bb.13: # %cond.load16
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vpinsrb $6, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_14: # %else17
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm6
; AVX2-NEXT:    vpextrb $7, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_16
; AVX2-NEXT:  # %bb.15: # %cond.load19
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vpinsrb $7, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_16: # %else20
; AVX2-NEXT:    vpaddq %ymm6, %ymm4, %ymm0
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqb %xmm5, %xmm2, %xmm5
; AVX2-NEXT:    vpextrb $8, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_18
; AVX2-NEXT:  # %bb.17: # %cond.load22
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vpinsrb $8, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_18: # %else23
; AVX2-NEXT:    vpextrb $9, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_20
; AVX2-NEXT:  # %bb.19: # %cond.load25
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vpinsrb $9, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_20: # %else26
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqb %xmm5, %xmm2, %xmm5
; AVX2-NEXT:    vpextrb $10, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je .LBB3_22
; AVX2-NEXT:  # %bb.21: # %cond.load28
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vpinsrb $10, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_22: # %else29
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpextrb $11, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_24
; AVX2-NEXT:  # %bb.23: # %cond.load31
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vpinsrb $11, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_24: # %else32
; AVX2-NEXT:    vpaddq %ymm1, %ymm4, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_26
; AVX2-NEXT:  # %bb.25: # %cond.load34
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vpinsrb $12, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_26: # %else35
; AVX2-NEXT:    vpextrb $13, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_28
; AVX2-NEXT:  # %bb.27: # %cond.load37
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vpinsrb $13, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_28: # %else38
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpextrb $14, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je .LBB3_30
; AVX2-NEXT:  # %bb.29: # %cond.load40
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vpinsrb $14, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_30: # %else41
; AVX2-NEXT:    vpextrb $15, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je .LBB3_32
; AVX2-NEXT:  # %bb.31: # %cond.load43
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vpinsrb $15, (%rax), %xmm3, %xmm3
; AVX2-NEXT:  .LBB3_32: # %else44
; AVX2-NEXT:    vmovdqa %xmm3, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: gather_v16i8_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq %rdi, %zmm3
; AVX512-NEXT:    vpmovsxdq %ymm0, %zmm4
; AVX512-NEXT:    vpaddq %zmm4, %zmm3, %zmm4
; AVX512-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX512-NEXT:    vpcmpeqb %xmm5, %xmm1, %xmm5
; AVX512-NEXT:    vpmovsxbd %xmm5, %zmm5
; AVX512-NEXT:    vptestmd %zmm5, %zmm5, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_2
; AVX512-NEXT:  # %bb.1: # %cond.load
; AVX512-NEXT:    vmovq %xmm4, %rax
; AVX512-NEXT:    vpinsrb $0, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_2: # %else
; AVX512-NEXT:    kshiftrw $1, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_4
; AVX512-NEXT:  # %bb.3: # %cond.load1
; AVX512-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512-NEXT:    vpinsrb $1, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_4: # %else2
; AVX512-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX512-NEXT:    vpcmpeqb %xmm5, %xmm1, %xmm5
; AVX512-NEXT:    vpmovsxbd %xmm5, %zmm5
; AVX512-NEXT:    vptestmd %zmm5, %zmm5, %k0
; AVX512-NEXT:    kshiftrw $2, %k0, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_6
; AVX512-NEXT:  # %bb.5: # %cond.load4
; AVX512-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX512-NEXT:    vmovq %xmm5, %rax
; AVX512-NEXT:    vpinsrb $2, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_6: # %else5
; AVX512-NEXT:    kshiftrw $3, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_8
; AVX512-NEXT:  # %bb.7: # %cond.load7
; AVX512-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX512-NEXT:    vpextrq $1, %xmm5, %rax
; AVX512-NEXT:    vpinsrb $3, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_8: # %else8
; AVX512-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX512-NEXT:    vpcmpeqb %xmm5, %xmm1, %xmm5
; AVX512-NEXT:    vpmovsxbd %xmm5, %zmm5
; AVX512-NEXT:    vptestmd %zmm5, %zmm5, %k0
; AVX512-NEXT:    kshiftrw $4, %k0, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    vextracti32x4 $2, %zmm4, %xmm5
; AVX512-NEXT:    je .LBB3_10
; AVX512-NEXT:  # %bb.9: # %cond.load10
; AVX512-NEXT:    vmovq %xmm5, %rax
; AVX512-NEXT:    vpinsrb $4, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_10: # %else11
; AVX512-NEXT:    kshiftrw $5, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_12
; AVX512-NEXT:  # %bb.11: # %cond.load13
; AVX512-NEXT:    vpextrq $1, %xmm5, %rax
; AVX512-NEXT:    vpinsrb $5, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_12: # %else14
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX512-NEXT:    vpcmpeqb %xmm5, %xmm1, %xmm5
; AVX512-NEXT:    vpmovsxbd %xmm5, %zmm5
; AVX512-NEXT:    vptestmd %zmm5, %zmm5, %k0
; AVX512-NEXT:    kshiftrw $6, %k0, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    vextracti32x4 $3, %zmm4, %xmm4
; AVX512-NEXT:    je .LBB3_14
; AVX512-NEXT:  # %bb.13: # %cond.load16
; AVX512-NEXT:    vmovq %xmm4, %rax
; AVX512-NEXT:    vpinsrb $6, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_14: # %else17
; AVX512-NEXT:    vpmovsxdq %ymm0, %zmm0
; AVX512-NEXT:    kshiftrw $7, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_16
; AVX512-NEXT:  # %bb.15: # %cond.load19
; AVX512-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512-NEXT:    vpinsrb $7, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_16: # %else20
; AVX512-NEXT:    vpaddq %zmm0, %zmm3, %zmm0
; AVX512-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm3
; AVX512-NEXT:    vpmovsxbd %xmm3, %zmm3
; AVX512-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512-NEXT:    kshiftrw $8, %k0, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_18
; AVX512-NEXT:  # %bb.17: # %cond.load22
; AVX512-NEXT:    vmovq %xmm0, %rax
; AVX512-NEXT:    vpinsrb $8, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_18: # %else23
; AVX512-NEXT:    kshiftrw $9, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_20
; AVX512-NEXT:  # %bb.19: # %cond.load25
; AVX512-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512-NEXT:    vpinsrb $9, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_20: # %else26
; AVX512-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm3
; AVX512-NEXT:    vpmovsxbd %xmm3, %zmm3
; AVX512-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512-NEXT:    kshiftrw $10, %k0, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_22
; AVX512-NEXT:  # %bb.21: # %cond.load28
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX512-NEXT:    vmovq %xmm3, %rax
; AVX512-NEXT:    vpinsrb $10, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_22: # %else29
; AVX512-NEXT:    kshiftrw $11, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_24
; AVX512-NEXT:  # %bb.23: # %cond.load31
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX512-NEXT:    vpextrq $1, %xmm3, %rax
; AVX512-NEXT:    vpinsrb $11, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_24: # %else32
; AVX512-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm3
; AVX512-NEXT:    vpmovsxbd %xmm3, %zmm3
; AVX512-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512-NEXT:    kshiftrw $12, %k0, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    vextracti32x4 $2, %zmm0, %xmm3
; AVX512-NEXT:    je .LBB3_26
; AVX512-NEXT:  # %bb.25: # %cond.load34
; AVX512-NEXT:    vmovq %xmm3, %rax
; AVX512-NEXT:    vpinsrb $12, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_26: # %else35
; AVX512-NEXT:    kshiftrw $13, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_28
; AVX512-NEXT:  # %bb.27: # %cond.load37
; AVX512-NEXT:    vpextrq $1, %xmm3, %rax
; AVX512-NEXT:    vpinsrb $13, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_28: # %else38
; AVX512-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm1
; AVX512-NEXT:    vpmovsxbd %xmm1, %zmm1
; AVX512-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512-NEXT:    kshiftrw $14, %k0, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    vextracti32x4 $3, %zmm0, %xmm0
; AVX512-NEXT:    je .LBB3_30
; AVX512-NEXT:  # %bb.29: # %cond.load40
; AVX512-NEXT:    vmovq %xmm0, %rax
; AVX512-NEXT:    vpinsrb $14, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_30: # %else41
; AVX512-NEXT:    kshiftrw $15, %k0, %k0
; AVX512-NEXT:    kmovw %k0, %eax
; AVX512-NEXT:    testb $1, %al
; AVX512-NEXT:    je .LBB3_32
; AVX512-NEXT:  # %bb.31: # %cond.load43
; AVX512-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512-NEXT:    vpinsrb $15, (%rax), %xmm2, %xmm2
; AVX512-NEXT:  .LBB3_32: # %else44
; AVX512-NEXT:    vmovdqa %xmm2, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vptr0 = insertelement <16 x i8*> undef, i8* %base, i32 0
  %vptr1 = shufflevector <16 x i8*> %vptr0, <16 x i8*> undef, <16 x i32> zeroinitializer
  %vptr2 = getelementptr i8, <16 x i8*> %vptr1, <16 x i32> %idx

  %mask = icmp eq <16 x i8> %trigger, zeroinitializer
  %res = call <16 x i8> @llvm.masked.gather.v16i8.v16p0i8(<16 x i8*> %vptr2, i32 4, <16 x i1> %mask, <16 x i8> %passthru)
  ret <16 x i8> %res
}

declare <2 x double> @llvm.masked.gather.v2f64.v2p0f64(<2 x double*>, i32, <2 x i1>, <2 x double>)
declare <4 x double> @llvm.masked.gather.v4f64.v4p0f64(<4 x double*>, i32, <4 x i1>, <4 x double>)

declare <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*>, i32, <4 x i1>, <4 x float>)
declare <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*>, i32, <8 x i1>, <8 x float>)

declare <16 x i8> @llvm.masked.gather.v16i8.v16p0i8(<16 x i8*>, i32, <16 x i1>, <16 x i8>)
