/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2021 Broadcom. All Rights Reserved. The term
 * “Broadcom” refers to Broadcom Inc. and/or its subsidiaries.
 *
 */

/**
 * Generic state machine framework declarations.
 */

#ifndef _EFC_SM_H
#define _EFC_SM_H

struct efc_sm_ctx;

/* State Machine events */
enum efc_sm_event {
	/* Common Events */
	EFC_EVT_ENTER,
	EFC_EVT_REENTER,
	EFC_EVT_EXIT,
	EFC_EVT_SHUTDOWN,
	EFC_EVT_ALL_CHILD_NODES_FREE,
	EFC_EVT_RESUME,
	EFC_EVT_TIMER_EXPIRED,

	/* Domain Events */
	EFC_EVT_RESPONSE,
	EFC_EVT_ERROR,

	EFC_EVT_DOMAIN_FOUND,
	EFC_EVT_DOMAIN_ALLOC_OK,
	EFC_EVT_DOMAIN_ALLOC_FAIL,
	EFC_EVT_DOMAIN_REQ_ATTACH,
	EFC_EVT_DOMAIN_ATTACH_OK,
	EFC_EVT_DOMAIN_ATTACH_FAIL,
	EFC_EVT_DOMAIN_LOST,
	EFC_EVT_DOMAIN_FREE_OK,
	EFC_EVT_DOMAIN_FREE_FAIL,
	EFC_EVT_HW_DOMAIN_REQ_ATTACH,
	EFC_EVT_HW_DOMAIN_REQ_FREE,

	/* Sport Events */
	EFC_EVT_NPORT_ALLOC_OK,
	EFC_EVT_NPORT_ALLOC_FAIL,
	EFC_EVT_NPORT_ATTACH_OK,
	EFC_EVT_NPORT_ATTACH_FAIL,
	EFC_EVT_NPORT_FREE_OK,
	EFC_EVT_NPORT_FREE_FAIL,
	EFC_EVT_NPORT_TOPOLOGY_NOTIFY,
	EFC_EVT_HW_PORT_ALLOC_OK,
	EFC_EVT_HW_PORT_ALLOC_FAIL,
	EFC_EVT_HW_PORT_ATTACH_OK,
	EFC_EVT_HW_PORT_REQ_ATTACH,
	EFC_EVT_HW_PORT_REQ_FREE,
	EFC_EVT_HW_PORT_FREE_OK,

	/* Login Events */
	EFC_EVT_SRRS_ELS_REQ_OK,
	EFC_EVT_SRRS_ELS_CMPL_OK,
	EFC_EVT_SRRS_ELS_REQ_FAIL,
	EFC_EVT_SRRS_ELS_CMPL_FAIL,
	EFC_EVT_SRRS_ELS_REQ_RJT,
	EFC_EVT_NODE_ATTACH_OK,
	EFC_EVT_NODE_ATTACH_FAIL,
	EFC_EVT_NODE_FREE_OK,
	EFC_EVT_NODE_FREE_FAIL,
	EFC_EVT_ELS_FRAME,
	EFC_EVT_ELS_REQ_TIMEOUT,
	EFC_EVT_ELS_REQ_ABORTED,
	/* request an ELS IO be aborted */
	EFC_EVT_ABORT_ELS,
	/* ELS abort process complete */
	EFC_EVT_ELS_ABORT_CMPL,

	EFC_EVT_ABTS_RCVD,

	/* node is not in the GID_PT payload */
	EFC_EVT_NODE_MISSING,
	/* node is allocated and in the GID_PT payload */
	EFC_EVT_NODE_REFOUND,
	/* node shutting down due to PLOGI recvd (implicit logo) */
	EFC_EVT_SHUTDOWN_IMPLICIT_LOGO,
	/* node shutting down due to LOGO recvd/sent (explicit logo) */
	EFC_EVT_SHUTDOWN_EXPLICIT_LOGO,

	EFC_EVT_PLOGI_RCVD,
	EFC_EVT_FLOGI_RCVD,
	EFC_EVT_LOGO_RCVD,
	EFC_EVT_PRLI_RCVD,
	EFC_EVT_PRLO_RCVD,
	EFC_EVT_PDISC_RCVD,
	EFC_EVT_FDISC_RCVD,
	EFC_EVT_ADISC_RCVD,
	EFC_EVT_RSCN_RCVD,
	EFC_EVT_SCR_RCVD,
	EFC_EVT_ELS_RCVD,

	EFC_EVT_FCP_CMD_RCVD,

	EFC_EVT_GIDPT_DELAY_EXPIRED,

	/* SCSI Target Server events */
	EFC_EVT_NODE_ACTIVE_IO_LIST_EMPTY,
	EFC_EVT_NODE_DEL_INI_COMPLETE,
	EFC_EVT_NODE_DEL_TGT_COMPLETE,
	EFC_EVT_NODE_SESS_REG_OK,
	EFC_EVT_NODE_SESS_REG_FAIL,

	/* Must be last */
	EFC_EVT_LAST
};

/* State Machine event name lookup array */
#define EFC_SM_EVENT_NAME {						\
	[EFC_EVT_ENTER]			= "EFC_EVT_ENTER",		\
	[EFC_EVT_REENTER]		= "EFC_EVT_REENTER",		\
	[EFC_EVT_EXIT]			= "EFC_EVT_EXIT",		\
	[EFC_EVT_SHUTDOWN]		= "EFC_EVT_SHUTDOWN",		\
	[EFC_EVT_ALL_CHILD_NODES_FREE]	= "EFC_EVT_ALL_CHILD_NODES_FREE",\
	[EFC_EVT_RESUME]		= "EFC_EVT_RESUME",		\
	[EFC_EVT_TIMER_EXPIRED]		= "EFC_EVT_TIMER_EXPIRED",	\
	[EFC_EVT_RESPONSE]		= "EFC_EVT_RESPONSE",		\
	[EFC_EVT_ERROR]			= "EFC_EVT_ERROR",		\
	[EFC_EVT_DOMAIN_FOUND]		= "EFC_EVT_DOMAIN_FOUND",	\
	[EFC_EVT_DOMAIN_ALLOC_OK]	= "EFC_EVT_DOMAIN_ALLOC_OK",	\
	[EFC_EVT_DOMAIN_ALLOC_FAIL]	= "EFC_EVT_DOMAIN_ALLOC_FAIL",	\
	[EFC_EVT_DOMAIN_REQ_ATTACH]	= "EFC_EVT_DOMAIN_REQ_ATTACH",	\
	[EFC_EVT_DOMAIN_ATTACH_OK]	= "EFC_EVT_DOMAIN_ATTACH_OK",	\
	[EFC_EVT_DOMAIN_ATTACH_FAIL]	= "EFC_EVT_DOMAIN_ATTACH_FAIL",	\
	[EFC_EVT_DOMAIN_LOST]		= "EFC_EVT_DOMAIN_LOST",	\
	[EFC_EVT_DOMAIN_FREE_OK]	= "EFC_EVT_DOMAIN_FREE_OK",	\
	[EFC_EVT_DOMAIN_FREE_FAIL]	= "EFC_EVT_DOMAIN_FREE_FAIL",	\
	[EFC_EVT_HW_DOMAIN_REQ_ATTACH]	= "EFC_EVT_HW_DOMAIN_REQ_ATTACH",\
	[EFC_EVT_HW_DOMAIN_REQ_FREE]	= "EFC_EVT_HW_DOMAIN_REQ_FREE",	\
	[EFC_EVT_NPORT_ALLOC_OK]	= "EFC_EVT_NPORT_ALLOC_OK",	\
	[EFC_EVT_NPORT_ALLOC_FAIL]	= "EFC_EVT_NPORT_ALLOC_FAIL",	\
	[EFC_EVT_NPORT_ATTACH_OK]	= "EFC_EVT_NPORT_ATTACH_OK",	\
	[EFC_EVT_NPORT_ATTACH_FAIL]	= "EFC_EVT_NPORT_ATTACH_FAIL",	\
	[EFC_EVT_NPORT_FREE_OK]		= "EFC_EVT_NPORT_FREE_OK",	\
	[EFC_EVT_NPORT_FREE_FAIL]	= "EFC_EVT_NPORT_FREE_FAIL",	\
	[EFC_EVT_NPORT_TOPOLOGY_NOTIFY]	= "EFC_EVT_NPORT_TOPOLOGY_NOTIFY",\
	[EFC_EVT_HW_PORT_ALLOC_OK]	= "EFC_EVT_HW_PORT_ALLOC_OK",	\
	[EFC_EVT_HW_PORT_ALLOC_FAIL]	= "EFC_EVT_HW_PORT_ALLOC_FAIL",	\
	[EFC_EVT_HW_PORT_ATTACH_OK]	= "EFC_EVT_HW_PORT_ATTACH_OK",	\
	[EFC_EVT_HW_PORT_REQ_ATTACH]	= "EFC_EVT_HW_PORT_REQ_ATTACH",	\
	[EFC_EVT_HW_PORT_REQ_FREE]	= "EFC_EVT_HW_PORT_REQ_FREE",	\
	[EFC_EVT_HW_PORT_FREE_OK]	= "EFC_EVT_HW_PORT_FREE_OK",	\
	[EFC_EVT_SRRS_ELS_REQ_OK]	= "EFC_EVT_SRRS_ELS_REQ_OK",	\
	[EFC_EVT_SRRS_ELS_CMPL_OK]	= "EFC_EVT_SRRS_ELS_CMPL_OK",	\
	[EFC_EVT_SRRS_ELS_REQ_FAIL]	= "EFC_EVT_SRRS_ELS_REQ_FAIL",	\
	[EFC_EVT_SRRS_ELS_CMPL_FAIL]	= "EFC_EVT_SRRS_ELS_CMPL_FAIL",	\
	[EFC_EVT_SRRS_ELS_REQ_RJT]	= "EFC_EVT_SRRS_ELS_REQ_RJT",	\
	[EFC_EVT_NODE_ATTACH_OK]	= "EFC_EVT_NODE_ATTACH_OK",	\
	[EFC_EVT_NODE_ATTACH_FAIL]	= "EFC_EVT_NODE_ATTACH_FAIL",	\
	[EFC_EVT_NODE_FREE_OK]		= "EFC_EVT_NODE_FREE_OK",	\
	[EFC_EVT_NODE_FREE_FAIL]	= "EFC_EVT_NODE_FREE_FAIL",	\
	[EFC_EVT_ELS_FRAME]		= "EFC_EVT_ELS_FRAME",		\
	[EFC_EVT_ELS_REQ_TIMEOUT]	= "EFC_EVT_ELS_REQ_TIMEOUT",	\
	[EFC_EVT_ELS_REQ_ABORTED]	= "EFC_EVT_ELS_REQ_ABORTED",	\
	[EFC_EVT_ABORT_ELS]		= "EFC_EVT_ABORT_ELS",		\
	[EFC_EVT_ELS_ABORT_CMPL]	= "EFC_EVT_ELS_ABORT_CMPL",	\
	[EFC_EVT_ABTS_RCVD]		= "EFC_EVT_ABTS_RCVD",		\
	[EFC_EVT_NODE_MISSING]		= "EFC_EVT_NODE_MISSING",	\
	[EFC_EVT_NODE_REFOUND]		= "EFC_EVT_NODE_REFOUND",	\
	[EFC_EVT_SHUTDOWN_IMPLICIT_LOGO] = "EFC_EVT_SHUTDOWN_IMPLICIT_LOGO",\
	[EFC_EVT_SHUTDOWN_EXPLICIT_LOGO] = "EFC_EVT_SHUTDOWN_EXPLICIT_LOGO",\
	[EFC_EVT_PLOGI_RCVD]		= "EFC_EVT_PLOGI_RCVD",		\
	[EFC_EVT_FLOGI_RCVD]		= "EFC_EVT_FLOGI_RCVD",		\
	[EFC_EVT_LOGO_RCVD]		= "EFC_EVT_LOGO_RCVD",		\
	[EFC_EVT_PRLI_RCVD]		= "EFC_EVT_PRLI_RCVD",		\
	[EFC_EVT_PRLO_RCVD]		= "EFC_EVT_PRLO_RCVD",		\
	[EFC_EVT_PDISC_RCVD]		= "EFC_EVT_PDISC_RCVD",		\
	[EFC_EVT_FDISC_RCVD]		= "EFC_EVT_FDISC_RCVD",		\
	[EFC_EVT_ADISC_RCVD]		= "EFC_EVT_ADISC_RCVD",		\
	[EFC_EVT_RSCN_RCVD]		= "EFC_EVT_RSCN_RCVD",		\
	[EFC_EVT_SCR_RCVD]		= "EFC_EVT_SCR_RCVD",		\
	[EFC_EVT_ELS_RCVD]		= "EFC_EVT_ELS_RCVD",		\
	[EFC_EVT_FCP_CMD_RCVD]		= "EFC_EVT_FCP_CMD_RCVD",	\
	[EFC_EVT_NODE_DEL_INI_COMPLETE]	= "EFC_EVT_NODE_DEL_INI_COMPLETE",\
	[EFC_EVT_NODE_DEL_TGT_COMPLETE]	= "EFC_EVT_NODE_DEL_TGT_COMPLETE",\
	[EFC_EVT_LAST]			= "EFC_EVT_LAST",		\
}

int
efc_sm_post_event(struct efc_sm_ctx *ctx,
		  enum efc_sm_event evt, void *data);
void
efc_sm_transition(struct efc_sm_ctx *ctx,
		  void (*state)(struct efc_sm_ctx *ctx,
				enum efc_sm_event evt, void *arg),
		  void *data);
void efc_sm_disable(struct efc_sm_ctx *ctx);
const char *efc_sm_event_name(enum efc_sm_event evt);

#endif /* ! _EFC_SM_H */
