/*************************************************************************
* Copyright (C) 2021 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/
#if !defined(_IFMA_ECPRECOMP7_SM2_H_)
#define _IFMA_ECPRECOMP7_SM2_H_

#include "owndefs.h"

#if (_IPP32E >= _IPP32E_K1)

#include "pcpgfpecstuff.h"

#include "sm2/ifma_defs_sm2.h"
#include "sm2/ifma_ecpoint_sm2.h"

typedef struct SINGLE_PSM2_AFFINE_POINT_IFMA {
    __ALIGN64 Ipp64u x[PSM2_LEN52];
    __ALIGN64 Ipp64u y[PSM2_LEN52];
} SINGLE_PSM2_AFFINE_POINT_IFMA;

#define BASE_POINT_WIN_SIZE (7)
#define BASE_POINT_N_ENTRY  (1 << ((BASE_POINT_WIN_SIZE)-1))

extern const __ALIGN64 SINGLE_PSM2_AFFINE_POINT_IFMA ifma_ec_sm2_bp_precomp[37][BASE_POINT_N_ENTRY];

#if !defined(_DISABLE_ECP_SM2_HARDCODED_BP_TBL_)

const __ALIGN64 SINGLE_PSM2_AFFINE_POINT_IFMA ifma_ec_sm2_bp_precomp[][BASE_POINT_N_ENTRY] = {
{
/* digit=0 [{1,2,3,..,}]*([2^0]*G)  */
    {{0x0001167a5f72d7b5,0x000c43181404d9e9,0x000e6dbd3aaf42f3,0x00024c3c33e7981e,0x0000654979a299ac}, {0x0003cd65d4e5a49b,0x0008384568872dd6,0x0008f0fffbcf430c,0x0002a48f8c1f5e57,0x00009272f196066e}},
    {{0x000d7e9c18d8240f,0x000aaa6e417d56a0,0x000a3b0e4550d595,0x00088cd2483bdc9b,0x0000832b6de84b57}, {0x00047e746600a032,0x000d7b7693b68c19,0x000859275c90d69f,0x0007157acccbd8d3,0x00005bc85177169b}},
    {{0x000019fd6c2ea279,0x000d0917cb6254a3,0x000a0b6907791b62,0x000eb4a0a2676528,0x0000d038c8d3308c}, {0x0008ad3478846130,0x000f770c6ce91902,0x000bb07902d865c4,0x000c13c97f40aa52,0x00002d50aa9bfa6d}},
    {{0x0000dc8e3b19766a,0x000581f7eeae6605,0x000039ddf04401d9,0x0009f9020487ea28,0x00001ca3fd26b4a0}, {0x000ffc31c595b91b,0x000797e67a87e986,0x000aec6fb58321c6,0x000cf70ed1de135e,0x0000a8e2c4f05632}},
    {{0x000f443ef3733cb4,0x000cb3ff75fcd620,0x000231240b46fe4f,0x000f5f4c515aa58f,0x0000acee1008bf1e}, {0x000b4152768f6bb9,0x0003d1943d948337,0x000e5ea1cf8e42ac,0x0002258efb30f4bb,0x0000df40ee234c36}},
    {{0x0005e74ca112a1cc,0x0001baaf82ba6ba8,0x0005e46613dca025,0x000e34db6b1274a2,0x0000e903fc536e5d}, {0x000568bc9800f516,0x000a645b374d537b,0x00007f00118f53d1,0x00030e9848fbf6d2,0x0000221155fdf8ec}},
    {{0x000bf492e195f07f,0x0001de5ebffe884b,0x0003c307b8018431,0x000fe18c50b89419,0x00000a1adeda69ac}, {0x000ba05a8f672532,0x0000d327ed0e66d2,0x000ea11a5c476cbf,0x000d99baf0e449a2,0x000006fdeeeb922b}},
    {{0x00015c2fc0eb2070,0x0007a5b1df1b6701,0x000a3428b0cdb816,0x00087df9e90be6f2,0x0000f4f38ed34143}, {0x00077fd5f39cf758,0x000c519eaa1d82ae,0x0001c9fb549748ab,0x0008f3382693b350,0x00003b68d86b6f9a}},
    {{0x0007d88740be6daa,0x000b882728e34867,0x000622fa36cfdf7c,0x0008669b48e5e049,0x000008f7936983b4}, {0x00022a6c24b493eb,0x0000a36e3e719ce8,0x0008bd29b04cc229,0x000a6e96963c563a,0x0000711254fc6553}},
    {{0x000e8237d906e272,0x00063b15d4a3f432,0x00085b93464a3fd4,0x00088728eecdb60d,0x000063eef3231b13}, {0x00031bbfda8cd29f,0x0004821c3dc4be1e,0x000a4a6263ce10f0,0x000dd716508c65d1,0x000015073445b5d7}},
    {{0x00083da169291613,0x0009c670b0bce154,0x00080eed9d6a0bfd,0x0005092677557c8c,0x00003202222cfd8a}, {0x00028398a7eae7b7,0x000180bd61f72bf5,0x0001683a9ec60b3b,0x0002c587d5dd8402,0x00006a86e659db9f}},
    {{0x00090ea13d89cc69,0x000255069e37462b,0x00018fe68620e964,0x0008d4f0789f3850,0x000031ef3cf56a9d}, {0x0006bd39ee352fe8,0x0000667570e4332b,0x000673b80d8ed70b,0x000385ffafa48d5c,0x0000a591652ce762}},
    {{0x000c80c9d04d2808,0x0005a9a32d8f64e3,0x000dc6453311458c,0x000bc2b2e7da2bdf,0x00002cb3a3b11de1}, {0x0005fa508acb12e2,0x0007d33fce2e44d4,0x0004849da0dcd4c6,0x000ec55f9aef09eb,0x0000eae191c31b26}},
    {{0x000f8babeb190812,0x0000a4e094c1dc30,0x000ced3824c7aa66,0x00074d0533f194a6,0x000002c062f92d6f}, {0x000f6cd2b110e9a8,0x00091ab321a1a47f,0x000bbc8af71c2e8f,0x0009b55adfe0c027,0x0000ebfab3c299b6}},
    {{0x000df89411540793,0x000923289e1ea4d0,0x000ac9ab62313957,0x000ddf2219c14e38,0x000002798dfc11cf}, {0x000c5c1e9ea4d4d6,0x000aa6fced9ad262,0x0008fa2e93406f8c,0x000885947d9be66a,0x000020846630e236}},
    {{0x000d01076ee1cd74,0x000cd5a581b2d20c,0x00093f74bd090be1,0x000f4639d7121d6b,0x0000c74662a9ce8e}, {0x000a4759c17b4394,0x000acd91ba3bb8a6,0x0000bf7a5d3f3801,0x0003c5c62b07e323,0x000082838a70c166}},
    {{0x000e33014346c3a9,0x000095088fa55ffb,0x000107c9d987c4a3,0x000f2b6584a31dd2,0x0000ff8f6b14a019}, {0x000da3bda2d72e1e,0x000953e595c8241b,0x00053ede9ccb4205,0x000cdc439cbf5da2,0x000018a52a7858cd}},
    {{0x000617c54f3a57d1,0x0009e6cda402d38f,0x000dcba397c6a7df,0x00017bfe48ed8eea,0x0000a909b54de6b4}, {0x000b7154885c6b51,0x00052ad21227839e,0x00060f8cff874f5d,0x0007e8e972e6a3a7,0x0000255f5e75e5e0}},
    {{0x0002d8e3f61e46a0,0x000ef8a682a8116e,0x00086b27e23bfa6a,0x0009e513f9b9e970,0x0000e27f60beec8c}, {0x0003246dbc6eb4e8,0x000255fe0d47ce4e,0x0003d805a7b4087e,0x0009af4f3ee12d06,0x0000dffd18b1c09a}},
    {{0x0008e3e09541188e,0x0006b0d2ff10201a,0x000abedec872090a,0x00069c20e3d876d4,0x000087ecb8de0f7b}, {0x000da6987805758b,0x00077a3929596b9a,0x00032632c2a7c1aa,0x0007d153d274c1de,0x000090621fde36d4}},
    {{0x000f01e019ea2472,0x000266cb630aa808,0x0000f49041d7deaa,0x0009350681611dea,0x00003d0a0dce821b}, {0x000abe5cc3f2bfb4,0x000d5418bd40f896,0x000e02ff3a27ab02,0x000e86399ce4ac99,0x000049d0896d001d}},
    {{0x000dbc0b894bb4f4,0x0002e20681014988,0x0001f9c1e48b7e8e,0x0006bcc8cbd44336,0x0000923926eb0c2c}, {0x000005bcfa05f5a4,0x000429e49d6299a7,0x000c78170090ecdb,0x0005f7927afb6fed,0x00000a0af6725bb3}},
    {{0x000f6ae59570ee69,0x000423cbdcc1639d,0x00074bb372d8a3e0,0x0006915c4c7c42e7,0x0000354c77faf967}, {0x0001bb84d9312a64,0x000a22b967527d11,0x0000bbd1e7d36ed8,0x0006f2599638cb07,0x000082f920f072ba}},
    {{0x000668304566ea9f,0x000c5a73b2b5ea29,0x0001b72e0dfb6f53,0x00068c65d19de7a9,0x0000b028d8339d06}, {0x000f529385702e1f,0x000b15aaaac89ff3,0x000446feccaf4f3e,0x000f06e44bc53bc2,0x00009f9c624cb5d9}},
    {{0x000e53aa7d49eafb,0x000cdac9d5e2826d,0x000fe4b7a2a6312c,0x0008cfdc13addc3d,0x0000b1d9952c6972}, {0x00071e68556c226a,0x000774683bb5d64a,0x000bb10c1848b985,0x0003d48c9d605474,0x000068340188b965}},
    {{0x00092bed74888d36,0x000cbce275c0fb58,0x000e72fe273b12ce,0x0002e80de91707e7,0x0000db762f73c5fb}, {0x0003605d1822de60,0x000264f60af612d9,0x000d43631ab3bd6b,0x0004629df73fd298,0x0000cfe82714262c}},
    {{0x000746a77aa308aa,0x0001a9c30737acc0,0x0002eb6e3ed4ce48,0x000f943a95bb54ee,0x00006010a8bdd232}, {0x000560e7e5cf332c,0x000be9efdeac35b0,0x000f8b7e87813782,0x0002181fb9421fe7,0x00000340a99e9269}},
    {{0x0007671e24561bb4,0x00000d8f762de2a3,0x00001886c3580ffe,0x0007956cd67f42a4,0x00002cf5abf25b97}, {0x000de5ed1dcc00e4,0x000478255fa3c47b,0x000bf3c02988a494,0x0007bba59141f96f,0x000072ac7d2040d2}},
    {{0x0003afcc938edfa0,0x000981cc61252576,0x000913c163700794,0x00002d5bdecb033c,0x0000e4e3c5ff4d82}, {0x0001d8f4668b50d7,0x0007cd2a51338b78,0x000edd0f0b7e280a,0x000f0bbe8dc91387,0x0000219bfbb5cbf8}},
    {{0x0007c9d827edc576,0x000d568cf9f5796f,0x0003c6b070fad2a5,0x000143c45bc8ac15,0x0000c8cc3708f7a1}, {0x000c780d9d193ed6,0x0007191b007b950e,0x000ab8ba8c708175,0x000ad5467340f445,0x000052592b31e902}},
    {{0x000802fb3eb3d841,0x000e04d04b1868a7,0x000982cd2e03b6ec,0x0001b9a36069a7ab,0x00006f98bd625e59}, {0x0004e2dfb27220ca,0x0007d60b11ba4ebf,0x000e42ff9a6e1785,0x000e36f3b18c612a,0x0000d89ac35c73c0}},
    {{0x00050e3e71fd4a23,0x000f7f7b071198b5,0x000ba19d01ea4efc,0x000f0a982d78af40,0x00007cfcfdcb0d03}, {0x0001c52fadb094b5,0x000950490fa2f5bb,0x0003b956e911832b,0x00047e33b5297cf4,0x0000601800188ccc}},
    {{0x00091c76dcf25dc1,0x00000084b5c6b0ec,0x0008cb89c5ee1953,0x000f206fba6c6844,0x00001903b72eb3c3}, {0x0009f9329b4a17d7,0x0005e366f36057c5,0x0007b0a7b8ab0858,0x000734400dfb20ce,0x0000db8842f3d9d8}},
    {{0x0003c17aa0e9a859,0x000f26b39a949a9e,0x000ca30e12c38332,0x000068df9575c1e1,0x00009178ba1bca31}, {0x0001ea1386258de0,0x000e8ea2a8ea6306,0x00082a7454b4a9cb,0x0000492d7ad24091,0x00003d94af9fb739}},
    {{0x000bd0a4c60f2724,0x000c9bd244c18bc3,0x000063be261d339f,0x00071ad908da622a,0x0000c90f49d55404}, {0x0005922faeaab30b,0x00008552e7fd4231,0x00008fb1810871af,0x000375b0f859ed94,0x000046581a19632a}},
    {{0x0002eab5669ebb2b,0x0004708bb2fef9b6,0x000fe7fc9aa83744,0x00090c3213ee8cc1,0x00003abf92585915}, {0x0009761c3595cedf,0x0006a92651244ab0,0x000f2886cba43860,0x000a8ac5d83b89ab,0x0000e8dc6841ec1d}},
    {{0x0009fed874184a69,0x000fdea655ea6c93,0x000d96c14ff60a53,0x000268939458e5ff,0x000084dc3eef11b9}, {0x00041b5b6de8e246,0x0007a0b14c452ccd,0x00027d8f16bd2bb6,0x0009b725bb028dc2,0x0000572ecdca9ee2}},
    {{0x000130b4de2895f9,0x0005f439cc75e202,0x0002c214bff765f8,0x0000651a5b628ccb,0x0000c56a9a48fe00}, {0x0004695e9be17d1b,0x00041f854faac0fd,0x0009ccfdbc214556,0x00069ae44fdcdb03,0x00007edcab584c41}},
    {{0x000e3590f168d2b1,0x000339e9acab36da,0x000f5f613429ffb6,0x00023e7d6983b7a2,0x00005c48a5be3e59}, {0x000d83804d41f76e,0x000c0e774de782a4,0x0004cbc3ab5f71cc,0x000ae8e01b15b054,0x00003bee4f4f1362}},
    {{0x000b014c73ee1325,0x00054d9da08a3283,0x00083663a292e2bc,0x000c2fa93b16ed9d,0x0000813ab0c77049}, {0x000434a3b15969fc,0x000b5b49bda3732d,0x0005c2f25b7357d1,0x000ce9480b6457d5,0x000006200abb3a4c}},
    {{0x00045b268a2411df,0x0005891671a913cc,0x0003cf1240da7743,0x000b948d5605bba5,0x00004b4552738e3d}, {0x000ea61903ca09a3,0x000f0db2771a4bd7,0x000aad4157e88d82,0x00061433957627a5,0x00004ab7fd350a66}},
    {{0x000e4964e7611bb9,0x000295adae74d432,0x000d8cac7948a4d6,0x000c3da9c7112bb3,0x0000028720a3c72b}, {0x000903eadc6af862,0x000266a7dbde62a9,0x000bbdd6677a6604,0x0007c5f888f772fc,0x0000717d5496d7ca}},
    {{0x000a1261ea8c6488,0x000ca2d55afe929b,0x0003b29c6c19e3fc,0x000283f973ccef5c,0x0000a10539a87a90}, {0x000b7937899af0f6,0x00050bf36f6aa1c7,0x00060f93ea46df3f,0x000a0668b373f1cd,0x0000948b79142119}},
    {{0x00008f8d46c0616e,0x0005754a372e43dd,0x000bc0c92bf53994,0x000a2a74df8df2cb,0x0000da1b4aba6922}, {0x000b4c696835e3a0,0x000565c909e53769,0x000987ddf078fecb,0x00008f50f3a8e25c,0x0000ab1518d04d06}},
    {{0x000cc1c4cbf2eada,0x0000b07cccf2a3b4,0x00073637b5075beb,0x0002cbb01aff4f89,0x0000cbdd0a13bdae}, {0x000af408e2bf7bff,0x000a5c0ca6d44b87,0x000590425f3ca33c,0x0002bced68c4d27e,0x0000860daa597e7f}},
    {{0x0006fe7e8c09b138,0x00085228df4d5e7c,0x000d0b002f39288d,0x0009113f99774834,0x0000f38034f3008a}, {0x000e75ecfbf60757,0x000c0515ee009c8c,0x0001dffbf3bde851,0x0003cd7b9f7b0540,0x00001d4b51f20fec}},
    {{0x000f73502b13dfd6,0x0000f6bfe31b4bdb,0x0004c8f0f3d24ad0,0x000df99852ba6e75,0x00007531d7f6850f}, {0x00076e3627f19150,0x000acfbce9c4ce08,0x00036c4b44a54a01,0x00043b9b4580491e,0x000069d8a672d2ae}},
    {{0x00006262266ce0ea,0x0007ceb468278ecf,0x0007246abb7f770e,0x00070c62b11c5a9f,0x00004d940c70f297}, {0x000a1dd93504b336,0x000c58ae56addebf,0x0002c8778a299d26,0x000826f34db89297,0x0000216c1d191d4f}},
    {{0x000d757d105035e9,0x0000892525eeeea3,0x000b8207d3ab24fe,0x000dd86c38699063,0x000048ba86d3e9a8}, {0x000543f2cf2834f5,0x000c4f1160cf0568,0x000be874b4e8fd83,0x00084d925a64595e,0x0000d3990d091ae1}},
    {{0x000e9af8e18b884c,0x00003c1132459043,0x000b64b2b57c9247,0x000641003b9843a4,0x00006be6b120ee1b}, {0x0008b29a50338313,0x0007739485c6ac24,0x00020bd7e43e2261,0x000cd2f42c7c7494,0x000007104b3c5bab}},
    {{0x00075df6aa322652,0x0008438ee19c58e7,0x000f0e751ca64953,0x000ee2cc1ceff8f3,0x0000007cbe08fafc}, {0x0005d3fe7d60d02b,0x000f86971b9f6cc4,0x000af3ff81584de1,0x000e38e96e8b86ad,0x0000c8a5afe65086}},
    {{0x000c0c2ef468013e,0x000447a6a3e240d9,0x000ce19f2d3f4f80,0x000f5b1d82e8fa8a,0x0000a47b981fb33a}, {0x0006f55f89eb0100,0x000573f986d93e93,0x00003f8e75c98dfb,0x000a00d1be6eb587,0x00006025306d77dc}},
    {{0x0005004985706114,0x0003a99c2255a574,0x00039ede58b41f12,0x00057962df076847,0x00004155be8eedab}, {0x0000393d7b59e2eb,0x0004af37b669d889,0x0001361a3ce556fd,0x000088c50176ce1a,0x0000ab255f00efdc}},
    {{0x000f2508973a0049,0x000e1a9999674ce0,0x000b7ed788a7049c,0x00076b0df4215b78,0x00003fc339599f2f}, {0x0008a181cc31d786,0x00004b008af5a09e,0x0006e20a280096e6,0x000aefa786ef0ad9,0x0000708a7fb34b8e}},
    {{0x000ecd84e8002ca5,0x0006e4c51e07c6d3,0x000605339c03f827,0x000e29d372b2ef6b,0x00009294965e1f2c}, {0x0008e0d1f90738b6,0x000ea3c21f6272c6,0x0002e51519ef8f60,0x000ea3fdf6d43936,0x00004958f256a93e}},
    {{0x0002ae43cded4986,0x0008c0786370d1e5,0x000d72bfe828c06d,0x000de1ca387f03fa,0x0000fe77288924ef}, {0x0005c10049922062,0x0001e1b0f661a1bf,0x00078e2792579aa8,0x000f50251dd874f6,0x0000e1fb6309e4fc}},
    {{0x000ccd7fbba38366,0x0006a2f5d13d7662,0x0000c2887037a707,0x000822e131ce6676,0x0000ab184d3f7174}, {0x0000417ce21feaac,0x000ba6783f71e187,0x000c16456fd30111,0x0002534b61beb5bb,0x000057298cddd196}},
    {{0x000938b88b271119,0x000cdf7ba43a3002,0x0008b28d3c70b643,0x000ff1e445a0b19e,0x0000e8d8708505a0}, {0x000b509b7bcaa8da,0x0004889cc6d3bc35,0x000c1b8dbbb4f0d8,0x00076ce646be6d56,0x000064c9e731d2c4}},
    {{0x00068a9aaae04721,0x00049c19bd83c3bb,0x000c97a89201474f,0x0007e36f61e60b19,0x00008e006d3601e3}, {0x000264283d8cd6ac,0x000a26d694677ca3,0x00050811d256561a,0x000f93bb86344083,0x0000be34e422eda5}},
    {{0x000f8047fec93faa,0x00073131b791a8e2,0x00020dd5c4c96fd6,0x000b598413ee227a,0x000003f52b6a9a3c}, {0x0000a3aa35db586e,0x000e80870eb165fc,0x000407776015d23f,0x00014524d484ac18,0x00007d7bd4527603}},
    {{0x0007d6e92e359c6f,0x000b32a6697b084d,0x00085cc819e78cf5,0x000e64343264911a,0x0000b8665b43083e}, {0x000987117e217dc3,0x000f6ea5f2ff0fb6,0x000d0aba23bc49fd,0x000e1da50005ab33,0x00006631cedcfd42}},
    {{0x0006861e633bad54,0x0009090870f777a7,0x000efcf8e7ed6758,0x00048f60795ddd3e,0x000066e4b07a455f}, {0x00057bcc2dcfcebf,0x0009631b8b2b3172,0x000c4e0e7bda1bfd,0x00084c79157e95b6,0x0000dfc62d4f9b9e}},
    {{0x000229bde0a25f6d,0x000c029e3fcf95af,0x000222ea492c862b,0x000ec26fcddc3afe,0x00003df0533d4aef}, {0x00093afe4a6dc67d,0x000928563cb37395,0x000db3baa6ee4ad4,0x0006c1219f41b8f6,0x0000aed543421b6f}},
    {{0x0003d9b4b1683537,0x00027fca4ce53d4f,0x000429ff213ff55b,0x000978dcef44d3df,0x0000c87265aec8bc}, {0x0008adaee633517a,0x0000f9e83600b2c5,0x00046726aded6663,0x000c242380cd02ed,0x00003bc51cfc7e49}},
},
{
/* digit=1 [{1,2,3,..,}]*([2^7]*G)  */
    {{0x0003f6205b429ade,0x0008bf1c0a4e32ae,0x00022c7d1370668b,0x0006f3f11ba4f98a,0x00003ef4e616f3e6}, {0x000eda7e2acd29f6,0x000cb5cda51a38f4,0x0007e42471db7ebf,0x0003a61d62c9b445,0x000045ac20585b53}},
    {{0x000e1431a0e449d7,0x000b00a18c82a340,0x0009ce6b623dbfa8,0x000726ce7b22b908,0x0000257d316c6584}, {0x000316fa44c65236,0x000abdf21e2c9a6a,0x000fa681abf2e073,0x00024b68464198dd,0x0000b20d3821b191}},
    {{0x00047be60cbe754a,0x000f718c602db135,0x00077d7fb8185623,0x0007f9aeed67c8ab,0x0000af29dafc6215}, {0x000785ec118bf7e4,0x000eb16620c35dba,0x000199925c15e48d,0x000c1ccda92fa080,0x000033aa09cb45cd}},
    {{0x0008bb37bbc8eaff,0x000c954d84c1ba41,0x00006d707a0a6cc6,0x00064269baff481a,0x00008b85ca90fd0e}, {0x000470e9650bf952,0x0004614637082390,0x000f1b05fe17e127,0x000e19ae44e27a58,0x0000d28ce5f3ca66}},
    {{0x00030cd9e7bba66b,0x0002a47d0f6c9f6f,0x000f98fa70856f4b,0x0006d7ae2af062ff,0x0000407848c30d3a}, {0x000ad179dbe5e183,0x00081bb63f0280dd,0x000e0af2bc5b9ef5,0x000814831cfa3aa4,0x000057f28a37fd0a}},
    {{0x000045cccc33ac82,0x00041300a514028b,0x000e69aa5701e6de,0x0005a99b5c0bae0a,0x0000570e393aab01}, {0x0008b5223fabe3c9,0x00035b4958105bd7,0x00093e95309ea81e,0x00079468e41e71fc,0x00006d2120c20644}},
    {{0x0008216623c8051a,0x000974d15e695a2b,0x0000ed4105279fa7,0x000b0efdc15ffcce,0x00008407c2795c45}, {0x000e93eb01f7bc66,0x000aabb5b8017b63,0x00053f362f01a15a,0x000e5aaeaf3866d1,0x00003fe8d5b0e2a0}},
    {{0x0007e4a6bab88bb5,0x000ac749feb21e8b,0x00068a9ac9915331,0x0005411d793c48f8,0x00004c41659fc83e}, {0x0006563f1f63710c,0x000b29b8e532f2ea,0x000f494986fd6c33,0x00009638f46578c7,0x0000487d3b7f6df0}},
    {{0x00099ffa74b0a131,0x00003c57e9ff5e74,0x00041fcef932469d,0x000943242ecc22d1,0x00006e8a53cc4b10}, {0x00053e70b02ce3d3,0x0000f7bfea4c6526,0x000f62519e5d6a4f,0x000cebfd7945f306,0x00003029e98b8415}},
    {{0x000328a51d2191fb,0x000aa9835ebb3353,0x0006ddec4b72ed65,0x000c31d009d2f054,0x00005adafdcd98fa}, {0x00033a5443f17c91,0x000464a519cce4e8,0x00062cd2554ecc5b,0x00047ccb6657f4ba,0x0000ea376f2b8440}},
    {{0x0008bc857ba2453a,0x000354b27eeba2be,0x0003efa1af80516d,0x0009be57220a5103,0x0000fe282dac550a}, {0x000b6dd98b001e61,0x0001d5dc16564000,0x000e0a4e87ba6cd5,0x0004d1decf33a87f,0x0000a1f0885f20c6}},
    {{0x0005611ee5405eb8,0x0008bb358c3e290d,0x0008f2d2f416d96a,0x000e3a8b7a6840bc,0x0000f3c09d0c0771}, {0x0001b7ebe5a31b29,0x000072918a3d173b,0x000c77a4349cc89d,0x000dea0ec6082dba,0x0000e943c639dfbb}},
    {{0x0009c5a35b857733,0x000b43af66b31410,0x000618bc27427626,0x000dd611df52cb1b,0x0000dea20d731f39}, {0x000a53863aaa59ac,0x000287d564c29a15,0x000e07486f27f2f6,0x000cc58c64e300dd,0x00008bb7806200b4}},
    {{0x000e6cf633beb827,0x0007541ee6485223,0x000f064e09c8e331,0x000479c4a2008653,0x000005672dd401d9}, {0x0002ef49575fc255,0x000fb1756ee1946b,0x000faaa78a620586,0x00078458d74c45db,0x0000286229ac59c2}},
    {{0x000f183d4950bd4e,0x0006829e2dd608d3,0x00024b281ebe2bef,0x0005d5ac1a775b95,0x0000ffcbf6fa1b5d}, {0x000c6f7a38b05932,0x0009a4d54018e45e,0x000735a43f67590e,0x0006365280498d29,0x000083d04586749b}},
    {{0x000a36193b229fdd,0x000d6a1f04e7a9d7,0x000b81137c112f74,0x0001d75822a9a12a,0x000092df75029907}, {0x000e19344b0a3b18,0x0004947df3b965bf,0x0003ac1801a2dec0,0x00014686de82c871,0x000005c6bebc40f7}},
    {{0x0003e45d0a32fcee,0x0005a7fa4a4a3aeb,0x0004023d27d3a94b,0x000a1159700a2516,0x0000f05f61efb8e4}, {0x00094cf5c5dd948a,0x000c6eb880b4b16a,0x000f504d1ef5ec3c,0x000cd2d4d99cf64d,0x0000e533ca08d4f2}},
    {{0x00022bc0f01f06e1,0x0001254579a83be0,0x000ba95a583c43a3,0x00031de06bd83e20,0x00002d83f0a341da}, {0x000a009dec653ef8,0x000a9def081681f6,0x00021b6942705a2a,0x00043026da1504f9,0x0000091f0e90b112}},
    {{0x000572cecfe7bf86,0x000ee8278a5f0508,0x0006508e5c6e542b,0x000b6af13a5bbd8f,0x0000f885cd1a4781}, {0x0008a541d84528e9,0x000447f8ada787a5,0x0006f2151fe114b5,0x000878e13175c476,0x0000495badfdb204}},
    {{0x000325396578ba7e,0x000f1d5b140820f9,0x000f5534905a956f,0x000b7ba771977a8d,0x00007dbdca2d6fc5}, {0x00060a74da50d8cb,0x0006557137368856,0x000e0eaff086fcbc,0x00033a7ba6c24de9,0x0000d539d80b8c55}},
    {{0x000e7fac53e5832a,0x000d1e7a73f7e66c,0x0009be7bb912cbb5,0x00008b9b169f23f1,0x00005bf337922a53}, {0x0002b5e9ce1f9bdc,0x0008af5eaec7f01a,0x000e559ad53c6d06,0x000d4b81bd375c03,0x000065d670d2c170}},
    {{0x000cf320046dae34,0x0003dc84af3ffc3d,0x0009110ca683092d,0x000d3d8dc44ef5dd,0x0000146ddfa12279}, {0x00091848ad843b2e,0x000e677ff21f464c,0x0008d7eea9091dcf,0x00044e760768c865,0x00001e2755ed17fc}},
    {{0x0008a20903a4deda,0x00053f20c8da65f4,0x000dc571a79e0955,0x000122dd7b74cc0e,0x00001f3b1489237b}, {0x00074eec705b4e7f,0x000b345d9736c54a,0x0000f9d3c9235647,0x0009c2ee431a3c33,0x0000a634b54e5906}},
    {{0x0008d3493802aedd,0x0007f6143720a39a,0x00079ce8e3d24e2a,0x000b745b17663a59,0x0000ba7c742c42b4}, {0x00008e23e6376d36,0x000eb442027cbdff,0x0004192ba0107cd9,0x000f3d3711d81bbe,0x00001954cdd874dd}},
    {{0x0008536eb6e977e0,0x00031c30a317f04a,0x000150b5cecb8ce9,0x0006ae3ac0b43e66,0x0000c0d72af52624}, {0x0005a628eb6b6cae,0x0002cf4928e1e625,0x00001afda0667e5a,0x0007f4265f3de227,0x0000cf11f93b8c0d}},
    {{0x0001910c3b106232,0x000b54c4e6c94ee9,0x000dbb97ce7d0b7e,0x000f00a7d4aefda2,0x00000a5704423357}, {0x00005307a4979c43,0x00049a5bc7522d2f,0x00044591f664b2c8,0x0004e020b15ed1b9,0x0000304591f7dbd2}},
    {{0x0002e01cb8acccaf,0x000db23b53a5142b,0x00077554ae226c41,0x000098d0174d7152,0x000044df36341e6f}, {0x000ed3679f629911,0x0008282c8aa57cdc,0x00046fbfad702a88,0x000e5b3ac8eb84b0,0x000001d5d3e16826}},
    {{0x000a64b76a2ec18e,0x00078c3aead2a764,0x000aeda893a50823,0x000054515bd98ad9,0x0000ae9054cb0356}, {0x000b64e7f5d86a85,0x00000fd39ede8e65,0x000fd4dbcfc6de80,0x0002a0a6b04984a9,0x00003c88762946cd}},
    {{0x0002fee193a647ca,0x000b670c4033ee6b,0x0001643aa02f7b4a,0x00087114e66f3146,0x0000e357bcb2874d}, {0x0008627cf129e3fd,0x000a292529e30056,0x000cf7e52e3bc05f,0x0005f1b5d8d50c49,0x0000864bce4c6e0f}},
    {{0x000ad7991fa05182,0x0004decea29a2582,0x000bb694041f373a,0x000e6989d82ab62b,0x0000931b87e7d76c}, {0x0005776952079845,0x0006358770640105,0x00085f9043a52233,0x000f00fdcb296a03,0x000059005bf4862b}},
    {{0x000cc11e5684c1b7,0x000e3f8f8bc1e41e,0x0008eb1d9286e66e,0x0000297b1812feac,0x000066f0a15d3e34}, {0x00096054a3178eff,0x0000bc29acc99c03,0x00023c25e83fcc7b,0x000147c408a07b0d,0x0000ddb2c5c07623}},
    {{0x000976011b1bc461,0x00060f0107f30719,0x0007818994a2a18f,0x0000776333ff85ee,0x00003e669ead7d8f}, {0x00054bbcc73bbbba,0x0000ed0af38e5638,0x00005b56c91358c0,0x000b3df90dff2123,0x0000265625f4bbba}},
    {{0x000db00f4b4772bf,0x000145e2b12b3c1c,0x0003c88be095cc1c,0x00090b61b8a4923a,0x0000344af5ccf9cd}, {0x0009dcc691662dd8,0x000962a4096193de,0x000145eaab6e7b80,0x000a2e933dee45c3,0x0000dda44baf48fb}},
    {{0x000d5d161871cf5e,0x000bf96b711c1622,0x0001b7c2140db6c3,0x0004fb357c8e120a,0x000091f47ad1dff2}, {0x0001508663c0622f,0x00026c2d6643c86f,0x000fb96dbf23d874,0x000f766581d547ca,0x0000da7eebc0a4d0}},
    {{0x000c00bde07e9500,0x00040dcbd4ee582e,0x000af33a5075386f,0x0006f9598d9f545b,0x0000ff588a64a467}, {0x000a474e6ea6e85c,0x0001ea51b156b584,0x000fb3e7504d1e38,0x00007f044e32f572,0x0000d5ab75d376b9}},
    {{0x000b47dc0dc20f02,0x00003326e2aa2b72,0x000a2cd6bec5fb3e,0x0007365f285de9ba,0x00008bcea35cebfd}, {0x0002605ff74f7a52,0x0003aafb4968c25b,0x000ac9d2a2b84e45,0x00004ff873ba7a11,0x000063946120e765}},
    {{0x000ea745b0f8807a,0x000e9d8587aa16bb,0x0001307a4103df44,0x000b78e0498dc118,0x00004e9d7e40f8a1}, {0x0008dcff7bc5f923,0x00065ad9cdec8732,0x0008b45d8a3f4963,0x000ca219f7b76513,0x0000644e1c93afd0}},
    {{0x000d04a8b55db72c,0x000f435dabbc4a91,0x0008fcbaeb67078e,0x000bbdfc9b2f2124,0x000019e43abb0f65}, {0x0003be91f3aae668,0x000f8a9736725587,0x00016e8f3bc10c21,0x00040ec4a74ee5e2,0x0000c0d08c02ae5a}},
    {{0x0006ce7146590851,0x00020187d3713eba,0x000d38a163074e6b,0x000cdbf349943c34,0x000053c9b5c6d74f}, {0x000e1b66247a7101,0x00069c95293b8e92,0x000d7308e5ba5fc1,0x000136280b9ebeb8,0x00008f80fc44a55d}},
    {{0x000b576e500ea398,0x000b82245cf3e7b2,0x0008f9cbc2bec6cc,0x0001d58f77345037,0x0000cdd0554e6eea}, {0x000cc7ccaae38d62,0x000534c4be5c6035,0x0000fc56156e4977,0x0004f1cf337aea39,0x0000ee6f49181e94}},
    {{0x00079d789c195287,0x00027477408790a6,0x0000930aceb86101,0x0006cbe2723b0edd,0x0000392b0905f00d}, {0x00088b89f8858b86,0x0007f3db1a0ba159,0x000ffe03a89fc719,0x0000201ba5da50ba,0x00006a863f2cd455}},
    {{0x0001a4387e58a913,0x000648acceb75521,0x0007521152b339f5,0x000d2dd874036bbb,0x000041757e920823}, {0x000a54437646ae42,0x00019047e92f959e,0x0006f40a3de71463,0x00075397ce58940c,0x0000ebb7ab93546a}},
    {{0x000a1b010e4aab26,0x000e3c5617a973ad,0x00044532982b8675,0x000a969681bed3c3,0x00007d4f1ae7cdba}, {0x0009ae9fffe1232f,0x000e65305444e20d,0x0006fe785b41f639,0x0004120e08eac5d0,0x0000aaa419560e8f}},
    {{0x000758b9c8293920,0x0008c6cbfbe97afe,0x000e690a1af49bfb,0x0004203981fcd743,0x00000b943f7aa23d}, {0x000f5a347a711abb,0x000b1d90df6603b8,0x000e12a3bbabc3a5,0x0008154f4b9ee0a5,0x0000c0badc5131ea}},
    {{0x000d8fbf079db722,0x0003ab9c82633610,0x000e51bbae11705a,0x0004eff476c3420f,0x0000c6baf02761a6}, {0x0009a0b4c2b16f08,0x00045aaf34d60563,0x0007d8efd5c37a31,0x0002406427c1b59a,0x00008f17aca33851}},
    {{0x00076f86426c3280,0x00065a8f5c36655c,0x000a66bb836ec14c,0x000111b0275c4c04,0x00005124ac1a1510}, {0x0005aa9d9a40b2c9,0x0002362d7acf7364,0x00073b575ab0d288,0x00008cff853212bd,0x0000e58faa0c1f04}},
    {{0x0001293d9c195932,0x000eef2d6ea5365d,0x00041ddd78506af1,0x0002081d18e3a2ee,0x0000175ed7253823}, {0x000cab1223717464,0x00081eaf69bff654,0x000231c48aeca4f3,0x000a6a4d3a8f27aa,0x00008dde1551daa6}},
    {{0x000901ca13309f4b,0x000cc1b25d3b7455,0x000e3ab715f6fdc0,0x00089282b9a04c15,0x0000c045df01cfee}, {0x000d75e0c168f76d,0x000e0171344f2fd0,0x0005435774ec19e9,0x00056bece16d3efb,0x0000be9d895f073b}},
    {{0x000a4a40e4749395,0x0003734cc0308f44,0x000ce52d8c15a3ea,0x000e8df3075e4632,0x00004bbedaed5c68}, {0x00006feb5915c0d9,0x000949c11a211e9d,0x00019a13bc8bd809,0x000ff23cfa204cd8,0x0000b0ba02c5fdd1}},
    {{0x00054deaaba5d8eb,0x000a6f6362a3502a,0x0007aa9e44e1e1d7,0x000cb2b299a780e5,0x000070536c702e08}, {0x00097282cef3adbd,0x000014bed566650a,0x000e5203d864d70e,0x000ddd1dc2014b85,0x00008605d670e497}},
    {{0x0000ad950d9dd8e2,0x0001a65713c77ad9,0x0003175ee249e6a4,0x00060f1892e877fa,0x0000ea9facbe9436}, {0x0009dfd972df6c3e,0x000cbedb2b8203e3,0x00058343fdd04e5e,0x0003d97ebfc1bf8d,0x00003e108caa72ac}},
    {{0x000b277b4f2aa16d,0x0008230545a5016c,0x0002e2769b2435ab,0x0002779964fdc84e,0x00002e12bff6b35c}, {0x0006dbbcbe4dd215,0x0009cf4e0ff812c7,0x0000e963f1c305f5,0x0005e69a0be36a64,0x00007762740fc054}},
    {{0x000c36a9138a7f68,0x0008470ee63806de,0x000cb7255647a569,0x0007fd1b252fccff,0x00007c9171f47258}, {0x00097ff34fc8093d,0x0008de7129a90bdd,0x0000a742e5f26310,0x00051c078b3f740a,0x00003fd65a14fa19}},
    {{0x000341e2c79fcc59,0x000d996d461221d7,0x000e9d32b3c02d65,0x000bf9b355c0b280,0x0000b04f743f16ea}, {0x000c8edc4bc3438f,0x00096016b5362987,0x00010d7d0315dd2e,0x000a6516e8c2661c,0x00009b5fb13a3567}},
    {{0x000012645f461429,0x00093cfe4e77bfe0,0x0000678940510b04,0x000c3c83e76847ae,0x0000aff2f45006a2}, {0x000568a45e9f4ac7,0x00003ec5016c2bdf,0x0000224802e6c323,0x0008a3781ba7f616,0x0000b608cbc8aa43}},
    {{0x0006e23886af7a22,0x0004d87701710104,0x000dd4329762ec47,0x000b0c85a529a29f,0x0000ca8eb75290d6}, {0x000944765a1f3112,0x0004526223465ae1,0x0008b3e5061d9db9,0x000c05c301f5a96a,0x00003eea325d3356}},
    {{0x000ea3fbc35ccbaf,0x0003d0980f8881d4,0x000742058b853b8f,0x000a93c1cd768f5a,0x0000aed3d20d113d}, {0x000f0613da6d40d8,0x000bfc5a47958e97,0x00078f3cffc06a56,0x000231aedfc6fba6,0x0000fe6d947b0cd3}},
    {{0x000959b0ed60b577,0x000f5ec0253c6f66,0x0008e5689b3f8d47,0x00064ea48fbc6376,0x000021581d29868b}, {0x0009abba118e8524,0x000b62a3b710d54d,0x00007ed07686fcbc,0x0002ac100d616b1a,0x00008f7e4edf5463}},
    {{0x000afd83d0bbed45,0x0009a4a423d92e83,0x0007efe97713bc6d,0x0002864fd29134cd,0x0000f105bf080515}, {0x00099d5c6362bc3b,0x000301adc72d227d,0x0007d741e5cbbe71,0x0003e8ec90a2b500,0x00002cb9449eed3c}},
    {{0x0007431dacc6cd8f,0x000327d0afc47ee7,0x0004cf1e41610068,0x00016c7df373dad7,0x00000042e51a0bb4}, {0x0000030244d5b5c0,0x00046436c0b767e7,0x000a283bcb615adb,0x0001f3281f151893,0x00002a5797383854}},
    {{0x000aa5a92ffbb0f3,0x000ddf4779f321c1,0x000d9726ba60bd3b,0x000141269fac0c6a,0x00009d33c89d1a6a}, {0x0001d981b6db934f,0x00097c858d13b960,0x00095003d1097326,0x000b1547c517a25b,0x000006db28fb4238}},
    {{0x00014be21fa8ba83,0x000723ee01b8bba9,0x00053235fc70e3a3,0x000854ee045851bf,0x000076061a1e3082}, {0x0000ed8989d0ade3,0x000e0475957e0684,0x0000b493f0327c6c,0x000c0eec5255cb9c,0x0000fb2ef57cd978}},
    {{0x0006e16fd686583d,0x00057ec048801ddf,0x00069f1cc520e3ff,0x000612fe4ef3e986,0x000004ce0c5522b7}, {0x00081124788f63ea,0x000409a1a13cbddd,0x000c67aaf921c06f,0x000d218fe7051bf6,0x00008b2ed76302fe}},
    {{0x000dfc779262f1ac,0x000f6f4b5df8fd32,0x000451c354acf03a,0x000b9cf87bbf3a89,0x0000202b08c85e13}, {0x000e0f0ccae32d7b,0x000d462b52f30d47,0x000ccba62aab00b8,0x0004cba64588a6eb,0x000032bdcd539457}},
},
{
/* digit=2 [{1,2,3,..,}]*([2^14]*G)  */
    {{0x000da81d1a2da736,0x00040521de498b84,0x0001c2d52e2068c9,0x00034dcbf6d4ec10,0x0000ea5880b663f8}, {0x0006df66b322ab71,0x000871f17ecb7ffc,0x0000f54419e4a898,0x00008b81cf1e389b,0x00007a05a6db6c73}},
    {{0x000d667d4f8e5a50,0x0005f26536b3c801,0x0004a16346a9cdbf,0x000ccbcf92ba9de0,0x0000fd5b3900eedf}, {0x00033c3069b93deb,0x000cf3b7ce8ad20c,0x000bd324a9a9bcab,0x000e5cfb2329a308,0x000095f2c48470ed}},
    {{0x0004bce015ccff87,0x000eb34d4a8f11bc,0x000721bc1cd438c9,0x0000827146cb5b70,0x0000a843732fe483}, {0x0001dd088c05eae6,0x0007da74df7bf31b,0x00093d301e85027f,0x0005ab37a147b28f,0x0000a2d230e7336c}},
    {{0x0007c5babcf7ea0d,0x000569819d685897,0x00078e0634866c49,0x0003879a283042ba,0x0000ab406b710c6e}, {0x000d69f7c9fd8080,0x000e1dc73087360a,0x000d64b5dfb2ca8d,0x00033828902da352,0x00009013008cdbe0}},
    {{0x000c1bee4cf1095b,0x000bd1666a4b713a,0x000b431e3d19fcc0,0x000938196d536753,0x00009b8e71621624}, {0x000a316451576162,0x000c76ddc87f3039,0x000e232d808e2b09,0x0006544735ee9f1f,0x000087a1d181f421}},
    {{0x000997691124b333,0x000d451eb882ca26,0x0000f886014ca42e,0x000749cbae97f712,0x000066796b2b5be8}, {0x00085f944d025c08,0x0007702f28a19d3f,0x000e61bdac26a8c0,0x000db2ea8aad567e,0x00008078a3f854ce}},
    {{0x00007ba56ac78d16,0x0009448f1d1d7ddb,0x000b3a1404a747c0,0x000254738fd1d565,0x00000fc34247734c}, {0x000dcc5f098ff4c6,0x000ef2299588fd1a,0x000526f2f3ca3291,0x000225dc6ae0385c,0x0000d29a013f2711}},
    {{0x000264880c2de156,0x000947380fee3995,0x0003cc64079cf1c7,0x0008da6ea4de174d,0x000003341f9f4354}, {0x000e8151f6e4ad1b,0x000bc54650c77ccc,0x000de287aa666044,0x000db0e21e16b6f4,0x0000efb7d194ac4c}},
    {{0x0007348efe215c9e,0x000a931c79ae7459,0x000bc87a3f8399b5,0x000a1bcc9091643d,0x0000c57a72438223}, {0x000cbcc9f0323ea7,0x0003f4633ae285d5,0x00075e694b36151f,0x000d0d5c1d1a3493,0x0000014dccf8288a}},
    {{0x00030900d2988954,0x0003e2d547c4b1d6,0x0003d769a258c9fd,0x00064ff7bf5754d0,0x00000bcff2e3a601}, {0x000995fcc5b48583,0x0002cf93957e8bcd,0x000d37ccadf3bf57,0x00031fc7dc53bffe,0x000071bb6556f9f8}},
    {{0x000f0306abec554b,0x000c8bc468067e3f,0x000d6238fc116a66,0x00069b8bd7796b94,0x0000a6558eced667}, {0x000af21c707b4feb,0x000a2aa0e68fd01b,0x0006f4d94f62eeee,0x0000ccb1d1af09d8,0x00003f1221391f32}},
    {{0x000eb563bf3376c9,0x0008f5d8ea00637f,0x000675ed8c7dbfa9,0x00051a85bac437f4,0x000037bf89c8189d}, {0x000ba46a66de87e9,0x000d24fe7e880662,0x000a387ef19a5076,0x0004953dbcdc6eb5,0x0000e2e1c4016e3e}},
    {{0x000f9b9bb42c0485,0x000ff2e8def6906c,0x000dacfee25d0f89,0x0001242fe1bc12ce,0x0000ba97a0a64232}, {0x0001c99c56cf201c,0x000d455c2ed2dbcd,0x000509787b117d3b,0x00095af8690b3a9b,0x0000417bd19de076}},
    {{0x000424aaeb3b91d4,0x000a998c13da2eb4,0x000c3d55be8eaf2e,0x000e03205c693bdb,0x0000fd5cf1c45d66}, {0x000d0f0a7ea7323d,0x0005a0440c0cb913,0x000e433cbef81c62,0x000ea78c3ad814d5,0x000070dbb0fed04a}},
    {{0x00090203a46ae630,0x0001c021ff3b323e,0x0008f647e46c84d1,0x00057306c16c8124,0x0000a93f9c553d27}, {0x0007068a29d80ae0,0x00066d1e92ca2f02,0x000d3c68f1fe6df3,0x000db0092823efe5,0x000043f0b8b11afd}},
    {{0x000ab7a126c29381,0x000d4f017773e3eb,0x00051c6ad9458693,0x0004188703c92ac9,0x00008d7d6ab30ed3}, {0x000fcc5e3f382814,0x0000f7ef5c71c3f7,0x0007acea6adea02a,0x000f418dc0bf1f23,0x0000b54ae9a11e38}},
    {{0x0002f3a2514a57f2,0x000755bd0ab98c69,0x000170e5611bc333,0x0001ad1373538876,0x0000a7a18cb1378a}, {0x0001b5efeee3ae1e,0x00054b58ddc3cceb,0x00036b1de1bda0d1,0x00035fe338e63f0a,0x000007514aeac9d8}},
    {{0x00012e9031f0a5ba,0x000cc72344d0cb10,0x000f9f81fac388f1,0x000819ec8de87114,0x000074f23945d20f}, {0x0003e7f085b71746,0x00040c6c0934c56a,0x00090588b97228a8,0x000b5a380052b408,0x0000fac86ae9306a}},
    {{0x000c5184d549deec,0x000d52b46bc9e417,0x000192f5462b2c21,0x000c8f8e355f7d23,0x0000cd177410648a}, {0x000d55e33cdefe21,0x000c7275af172a79,0x000eebe63c04f4ee,0x0007c713ff4aa0b7,0x00008d8307613e4b}},
    {{0x0004d3cd58e4d852,0x0006bab993f02b8b,0x00026693cfd3cf03,0x000af4e6d5408547,0x0000c2aabff8fa45}, {0x000a3c809ae43c50,0x000cf7a0f723e79e,0x00046edbbfbdccc1,0x000982a8cd0b6af1,0x00002b1e5a091517}},
    {{0x000fd07201deffac,0x00025809cadf872a,0x000cb98046995509,0x000ff21f4ff84d98,0x0000963d2bcbfe56}, {0x0002499093a6be69,0x000585326f80abc8,0x000f80d703b9d497,0x0001bfd4d58fc0e7,0x00004a60473ceb19}},
    {{0x000e5caaad4486b4,0x0005d1e24444b21e,0x000d3ed0c0b72819,0x000f982fc3cff018,0x00004ba520fa8898}, {0x000a25bbc397a8af,0x0002998611e20d76,0x000406e1ccb223d3,0x000b86f4e2652aa2,0x00009c27f8856e6a}},
    {{0x0009fc879466ceba,0x0001f18b2f8e875d,0x000210013a7160b9,0x000c7186305ed045,0x0000eb43ec41e200}, {0x0002cb32611aaefe,0x000c458e587ba1f1,0x0002c7fb38833b1b,0x0008800e363b5a76,0x00002467a594f1ce}},
    {{0x000404e6c71b8202,0x000e48bf41f295b4,0x0003bbd6407bf067,0x000844a0d45ccf07,0x0000dfc2ca06446e}, {0x0004dedc225205ce,0x00035847c15238fa,0x0001bcdcdbedad65,0x000bf3d178a82808,0x0000a8e3bc0a11ca}},
    {{0x0000c6ae5018d027,0x000a419015aee791,0x000bdfb1d84f73ff,0x000d4b9963b67b87,0x0000485df021db40}, {0x000ff3d64526fc0f,0x000809d05281ec5e,0x00034417b79ccca5,0x0008a68f1ced9e92,0x000084c11d3c4c8d}},
    {{0x000c1ee614663ebd,0x000eefc957140edb,0x0004cb8ebdd6ee14,0x000c319463886ccb,0x00003f1f77e17b13}, {0x0008c813d019b2ae,0x000ae3a496d29903,0x000b0b3353a94e2a,0x000af96c39382e3b,0x0000a718f3f170b3}},
    {{0x000c164496ab3d67,0x0006ea56a382dda6,0x000036dc6d5437ab,0x0008c51072a7b515,0x0000956b614be2c0}, {0x00073c805d2be046,0x000e2a99459dcad8,0x0005bf1a2e6a28d1,0x00042bc725dbc286,0x0000b972c00e8d03}},
    {{0x000aa44ce9e0496f,0x000a7518060ed141,0x000452f518ef97a7,0x000abccfd1dc35d3,0x000044605da47e0c}, {0x000f1fba3870f0ae,0x000ece7c99396b4b,0x000488733ee9559f,0x000e5da54cf3f91b,0x0000a28e5309a1c9}},
    {{0x0006d871fcfa1706,0x000e3b101284285a,0x0002d9406b0f302d,0x000121cb8a49debb,0x0000c65e2ed97a1e}, {0x0005b77a782ee91a,0x000a18fff5f1afba,0x0000590abfa71329,0x000f8f32227e83f1,0x000050dde9b93ce1}},
    {{0x0009607b794f0285,0x000f0c89ef49400c,0x00029e7554b7902b,0x000a03702d679b84,0x000027d77adc7fb0}, {0x000c9a2c835846f8,0x000d19300fc32289,0x000389f09dc87369,0x000449f520da060a,0x0000929d2a527a1a}},
    {{0x000d034270025e0c,0x0009dc6d5d8f5f46,0x0008b8bd0e581906,0x00031cd1e56e8bfe,0x0000ed5db268c8c6}, {0x000d7cfa60528665,0x0003499dd0753176,0x000a49d661bee9a9,0x00055f095fcec179,0x000078f295389204}},
    {{0x00010c7a09f07b72,0x00054a4f28f770b2,0x0000ebb86416fc49,0x000e678562cc3429,0x0000c146c66ed941}, {0x0006c78f44e0f9a9,0x000ed0e1730b01d2,0x000dd20b61e67d48,0x0004e94705fe8cc4,0x00004cb9e577978b}},
    {{0x0005b05d6914ffce,0x000bbcbc25e829c9,0x00064f5723a4258e,0x0009424439122bbc,0x000062a0f760a317}, {0x0008e2d3db0cdd63,0x0006e0a06d9aac8f,0x000ef51a43b76bd2,0x000e313b4e84259e,0x0000cd05a227ffe3}},
    {{0x0007a74f56626479,0x000ed3a968075def,0x0002063cf858014f,0x00060623e3b51455,0x0000d8a825e00c73}, {0x000803d1b3ff54bb,0x00057ca25942c21f,0x000b4932e5b4a102,0x0003a09d5ae52fa2,0x00001c461ac9803f}},
    {{0x000b28d11887efae,0x000ea168fa1b64e1,0x000b56a252fe844a,0x000dfae103e32b3d,0x000025b4f7dea5d3}, {0x000947e940ce1f1b,0x000ca48aa1767741,0x000a6ef9a8c24921,0x000739056310da94,0x0000c91e4f7cec0d}},
    {{0x000631d5545c61d7,0x000e9f1a5c65d6fa,0x00046c01c5cb2c3e,0x000b12160108765b,0x0000037e6b0239be}, {0x000f48f86beaf031,0x00003582003a33aa,0x0005101c310ecee8,0x000a3f604e6cbfb5,0x0000370d71300c7c}},
    {{0x0000b578f398f5c2,0x0002684aeddb0ff5,0x000a40bb38f9bc76,0x0008d0e81bf9c714,0x00005ffb3646b97a}, {0x0006781ae38091b4,0x0003bde34988e66e,0x00063bae09eddb66,0x0000f7f47a3c3027,0x0000045549bcc1b5}},
    {{0x000293017d41f805,0x00015b6e5b119f8a,0x0007fe0ad1dcef79,0x000dcb03d2f4f593,0x0000bc5de02b9ec2}, {0x000fe4bde4a50c54,0x00075fbe79e7001c,0x000f666fd4f9eba0,0x00036e2014942d8c,0x0000174ec1b3aeae}},
    {{0x000fca2c37292e34,0x000df0d50a803e6a,0x0009860576e3da8a,0x00016b82c8491f1a,0x0000f908c5eb3698}, {0x0007bce061481fee,0x0004ca0326e92580,0x0004ef03e64401e2,0x000e3e3b0b3335a2,0x00006a363fee2346}},
    {{0x0009631af51f3820,0x000310bcf577dfc0,0x0009a7fe9a4d5c89,0x0006e8e893b8e850,0x00004aa3176b18d3}, {0x000fe9e9998db107,0x00088de616ddcf17,0x0003cbbbcb14c557,0x00003faac8272dc8,0x0000f37f11c6d949}},
    {{0x000ba3b57ca7d9fb,0x000fd143f3a1d7db,0x000b58fe1aeb5b1f,0x0000b20f07391ec2,0x000053738f59c6e1}, {0x00071b4df4657720,0x00037c87c0c02e8f,0x00048a4dda850a8e,0x000c2bbecdb49b0f,0x00001e0e88fb7249}},
    {{0x00038cdac58335c3,0x000c66df86cb8aa1,0x000a5efe055d4c77,0x0008683ad1af4476,0x00001273e06eec8a}, {0x000a2ce980ef2516,0x000377fed539bad2,0x000293912c3a97cd,0x0005bf11b26fc0b7,0x00002701f2738b12}},
    {{0x0003ba8b2493b148,0x0007d81bf2ec5d3b,0x000ba5926cd37918,0x00003b04098e8707,0x0000993e2bf0b8df}, {0x000b9e789a25168f,0x00011110cc4fd0b4,0x000f73b82fcc0949,0x00025b8664697e9b,0x00008b52da34d004}},
    {{0x000c26b8aa6f79d5,0x000e067dcfb9770c,0x000edbc74258b6a8,0x0008a01b52d4c4ee,0x0000e4bcfdfaa83b}, {0x000fb6562627da7f,0x00009f556e31fea7,0x000812774e7e1710,0x00049a0c8d511a79,0x0000bbd260be01ec}},
    {{0x000722aab36249e1,0x0000a40db721fc3e,0x000026a00c5e1911,0x000d74549b846153,0x0000b622aadebdd0}, {0x000ca6686c5b5ea1,0x000292c7cbcce6e4,0x000fead6468bad0d,0x000bbc79632dbaa5,0x00008d702b3a959e}},
    {{0x000945ee8039f7f9,0x000e245d6a8c7bdc,0x00087d06e54cdf17,0x000783d6f1f6930d,0x0000551ed8a2334d}, {0x0008ab5b4cc0c954,0x000c9e84281ae650,0x0000185519e20a39,0x0007ef592eb5d96e,0x0000ec44157cc235}},
    {{0x000fa33716016f7e,0x000e46af2f5045d6,0x000a09af49a8fdb5,0x000e43c6a1cc8371,0x0000c277d0e603e7}, {0x00075a70fd1e4ccb,0x000139ebdaf3db97,0x000de03d23466af0,0x000a4a43866e1ef2,0x0000fdf225ba7f64}},
    {{0x000f14821c351edd,0x00021666bac77433,0x00028a88c1031a4f,0x00003eb20264c266,0x0000b50cc08ac4a3}, {0x000b467364f7c8ff,0x0009bc822547761a,0x000838d0cd7ef0bb,0x0004c66a947c25a3,0x0000d8d71347dba3}},
    {{0x000a2a39c57739c8,0x0003badbd20048ba,0x0002c2455087a0da,0x000600d3308eeb44,0x000035ab7e73bb70}, {0x00039893a9299ac7,0x000e1e5fae8a6704,0x00048b6bc37d45c8,0x0006000cec119be8,0x00002354d9fe710d}},
    {{0x00044539e0bf2fd6,0x0009b8e02b90f648,0x000d689709228660,0x0002c31506185413,0x000035c1a6a9b616}, {0x0002e4cfa6e7a7b9,0x000883f5b421e0bd,0x0006decae0701125,0x000ca3d924eb9b7e,0x00008973fbb6a139}},
    {{0x00084810bd80b472,0x000c9d87096bfb22,0x000213dd306a948b,0x000f10fc1ad42d95,0x00008adbd51369b8}, {0x0005716e1bc7e9cd,0x000e88f207a0a817,0x00081194cb775ec2,0x0000051502eda484,0x00001655fde650e6}},
    {{0x0002d8529ab17664,0x000febdd18efe4ef,0x0008f93d5bb9e7aa,0x0005bd5b6398956a,0x00003781ce087bdb}, {0x000adb3daf55c56c,0x00037ad269a5439a,0x000db01176c3f26d,0x0003e296872f7e7c,0x0000033a30fcd1df}},
    {{0x000bd6335284b84e,0x0008f43880ca626c,0x000925adb6bbaeb5,0x000a46b04a59bffa,0x0000f0ff8d1a11f0}, {0x000a185a6e7f82fb,0x000f677d6d0f0bf9,0x000fe783b2b1463c,0x0001df2e23eaa59a,0x0000740f8798259e}},
    {{0x000c722cfd41d7fc,0x00094d23f0bdd09a,0x000c4e6261ce5297,0x000c7c34230caad3,0x000087ee7f4ba1d9}, {0x000c5464bb31d104,0x000cc2b2971e1826,0x0006075a6c6d5093,0x00046ca459e99e4e,0x0000a65a1fb97994}},
    {{0x000c644d48d918fa,0x000a94d0bf8c23b4,0x0006cfb155d1a0ec,0x000071c4322d7bc1,0x00001f3bfe3fb2c5}, {0x000783f98fc491e3,0x000a7c0a39281925,0x0008235ca69e46fd,0x0008ae01fc9d169e,0x0000ca900548dc79}},
    {{0x000bda541349a39a,0x000c425a2a1aa23c,0x000962d9a09f1913,0x000462f7c27405d0,0x0000bde10d8a970c}, {0x000e683472ead4af,0x000cb9cfd08a2467,0x0009aeb8afaa4737,0x000ded0ac9c9a0d3,0x0000ce90da220b05}},
    {{0x0008f648f58227f8,0x0008836fa6d3184c,0x000e3ba47dcb6caa,0x000da665bec76370,0x0000b6a20603deac}, {0x000582c5e925265f,0x00046c9943a97cef,0x000568b96c2b5af9,0x000cc39e771b3bdd,0x0000841b94d6bf73}},
    {{0x000bf54149dde419,0x000a87dd1b4541dc,0x000e114d1eae42db,0x000618a1da2ae53e,0x0000d375cfe5fb7d}, {0x000c7151c5ec6dc1,0x0006021ec84fcd40,0x000c06e7f03abd0c,0x000e5abab6ac4a9f,0x000092cc4d88e993}},
    {{0x0004a400aa461c13,0x000fbb8169ed26cc,0x00035b80cc32eeed,0x000c0e53577fae15,0x0000c26d785c466c}, {0x00060512ceba4cd9,0x0004d5dbd6d77e63,0x0003d73e01830fe7,0x000f552a7971b6cb,0x0000ff6234aaf953}},
    {{0x000264d6ed5d6a7c,0x000e0ce67dac839d,0x0009760722497bcc,0x000fa7d6b7f1b9b1,0x0000412325c4dc51}, {0x0006aab96f5c6a1f,0x00010838ccd0083c,0x000477f4aed2a7fc,0x0003b9babdf5da39,0x0000b6954a4db685}},
    {{0x000b9720f5c665de,0x0007b936adb439b1,0x000f941b1f83f35f,0x000b862417afe4c2,0x0000bf88e1af3c59}, {0x0003fc188202f659,0x0002281f3bbbe4c4,0x0002a4f2f7105f4f,0x000558633d4e7b95,0x000028d27173eaf4}},
    {{0x00076bd78c722e88,0x0001551700e67635,0x00094f20827e73e4,0x000aef9bcfe57d6e,0x000097aad46ac9e8}, {0x000fb4432357b1de,0x0002f28bc7ebf10c,0x000ebcc31c6cab55,0x00039f2999933d7e,0x0000f5102b0ca303}},
    {{0x000a7e1a8ba693a5,0x000ba49ec02c239a,0x00067e4df2c98264,0x0004249f27435ecc,0x0000c02baa7777ec}, {0x000e994e304f2110,0x00083fbacc530a15,0x000fefab6e1cec97,0x000590dcbf287767,0x0000795c0592733f}},
    {{0x000984b1ef514e65,0x000ebd81411e2260,0x00032dfef40dafe3,0x00094956e4f8c6ae,0x0000136ba04fa012}, {0x0009ccee49a09296,0x00064c3b8e8e0968,0x000892b26d304e0f,0x000a112d29d432b7,0x00003ed12545e12b}},
},
{
/* digit=3 [{1,2,3,..,}]*([2^21]*G)  */
    {{0x000ce669fe8edc64,0x000977cc52c3285c,0x00000d67ed46f754,0x00061b80f9f0ec69,0x000012dbd13ccd38}, {0x000807b39e2a78af,0x000206aed104adae,0x0004dbd4a5d72c92,0x000027f3b3295361,0x0000693ac17f9250}},
    {{0x000f594afa4a4a7e,0x0000f5b4b990ac34,0x0006399e2ee44b8b,0x000b41f7bd0670ff,0x0000001c5d479361}, {0x000a8e6617658623,0x00048daa039ef32b,0x0006f48d6ebc6748,0x00037741a7683353,0x000042075593bdb8}},
    {{0x000094eefdd302c8,0x0009c460befb138c,0x00020963d227f072,0x000d142da3f15ca9,0x0000ba9e641f3b9d}, {0x000e401530c93b7d,0x00059744a3037da9,0x0003796f4979883e,0x00016795e7569395,0x00000c613cf9d65c}},
    {{0x000b20d1bb21d958,0x000fae479a31475e,0x000d97dd75179a2e,0x000145b32680eacd,0x00006b0a592db55e}, {0x00009e2a418bd004,0x0006a13ebcb0ebbf,0x0002fc81c9f8657b,0x000a128ce6f290ff,0x0000c2bf7d73e0f4}},
    {{0x00034ee8f7ca2841,0x000957847db5272e,0x00051343550a99c6,0x00027dce2b87e02c,0x000008e06a87c6fb}, {0x0003e4982cf177a8,0x0006fef4d4a55e9c,0x000544e47582945f,0x00026aa21056b319,0x0000bff078406896}},
    {{0x00002033f3eacba9,0x0001ecdd9087e29c,0x0005322e2493e6b9,0x000f6eadf4905da2,0x000016f929c8a045}, {0x00059f8488967f6f,0x0007be7575f06e12,0x000d9b6612dab69a,0x000892e6af43919b,0x00009097672f7684}},
    {{0x00083aac2d553230,0x000e2ff837639a05,0x0009af89299438f4,0x0004cfd3b1df4866,0x0000926c091d5ae1}, {0x000a5356cab1f151,0x00008a0b5e8d9e9f,0x0001ca41a7e71ebf,0x000839a4f0b024e7,0x000062a46f632c13}},
    {{0x000b21b7651b535d,0x000ed1ed8043c9bb,0x000ce1e1641850f3,0x000ddb9452c21474,0x00004ffeff4a6ad3}, {0x000dfe0c1b878ca7,0x0005170036f8309a,0x00092f2e778c4742,0x0002eb6f51aac2f0,0x00008b0fb8da7185}},
    {{0x000858780433abbd,0x00033774b30fce56,0x00038782098ecd9b,0x00099b6cee29ec01,0x00008890c1e6e660}, {0x000f67858c8ce86a,0x000d24efffce7d38,0x000387b8a9346a50,0x000711dcd7ef98b7,0x000069a697b171f9}},
    {{0x0003d469b1729fe4,0x0003a650ac09ae3b,0x0007f3ea0e2a6394,0x00028ea3015db36d,0x0000ff7f5572ee9d}, {0x000e9e34a5b7a36a,0x000b713b7a4042cc,0x000b2865c4506a15,0x000d73147264da3a,0x0000d28e88eb3d3c}},
    {{0x000c180b52f9cd55,0x00035dbd16da5551,0x0005671d63efc307,0x000d083bc2c9bef2,0x000077cd3b33b7bc}, {0x00016701d2c8f290,0x000af20f7a38f325,0x000c4fa1e8432fcd,0x000902477a71103f,0x0000c13307631946}},
    {{0x000a6de9599a5692,0x000b8cbb1dad4d5d,0x000317ddb4c6dcc3,0x000820def3a0ba2c,0x0000523c6f46afb3}, {0x000507a5b0666ce8,0x00009a4e67dd5fa6,0x0001f27b937bc419,0x000e17182d353469,0x000013aba876630c}},
    {{0x000e231e63f86155,0x0001ac0dd78b9590,0x00056fcf6a929cf7,0x000aff49a7e599c7,0x0000f2beae09c341}, {0x000c54d7d94bca5d,0x000460a94c47dce4,0x0002a0654f786ff2,0x000ef6bb318918dd,0x000043199fd3902e}},
    {{0x000672c94de6b79d,0x00065b645d1cb3c6,0x0006de9aae65c98a,0x00020c93993596a1,0x0000084850324b2b}, {0x0007470e2ed88727,0x00078a44113efdd4,0x000588cca7c8e729,0x00036e449a848413,0x000086370e30c8fe}},
    {{0x000cabc373c129c0,0x000b795474aefcee,0x00074d1801c4d4d6,0x0000903a019fb1d5,0x000090a24a4b2a71}, {0x000bcf6d4c7ea10b,0x00045a7dff3768f0,0x000f699905cf4cac,0x0004d37be1302ac8,0x000059f9ed7615c4}},
    {{0x0004954a8c5f8491,0x00036d6e05110de4,0x0001ebf0a61838fb,0x0003c617a5d05e90,0x0000931b4242abcb}, {0x00055e87db36946f,0x000d5c8c8d5ff47c,0x0001d34b9a502d72,0x000abe95f6140f42,0x0000eef1dfbb044d}},
    {{0x000af702fdfc658e,0x0009b5edcfe4f6b2,0x0003916044a0e71b,0x0009253d633d18f7,0x000067827258be5d}, {0x0002270c1591a40c,0x000aac7e34119c0c,0x0005718100a44dc3,0x0007de482d9958a4,0x0000936a6e932f8e}},
    {{0x00002d829e0de935,0x000d2b09417b0748,0x000bfb976a3c1581,0x000b232260ee014c,0x0000912559287882}, {0x000a3a2e63eb8e6a,0x000cdebf51672313,0x00079a1f51566a56,0x000a7c04a1f1a9ec,0x000070a867c7854d}},
    {{0x0008953d6fbc948f,0x000f59036928cf85,0x00092b62a61d026f,0x000b727b9d2522d8,0x0000d4740c141ba6}, {0x000e7258d3488637,0x000fa4f6dd639d25,0x000c32176d124824,0x000ef5dc0aae73c5,0x0000a6763062fc85}},
    {{0x000816180ac7b35c,0x0005671668988232,0x000293310c1fe0fe,0x000d24b7b7e35a0a,0x0000fbc7f7dfa8ee}, {0x00002f829b61fff0,0x0004af7a42839a1d,0x000ff28e0716b31b,0x0006c53c4262a0be,0x0000eeadb1a1ce5d}},
    {{0x00015f1a3129e10f,0x000af2b4e6c937c8,0x0002977a7267764a,0x00073c6a478a6c0d,0x0000cb95cba1c483}, {0x0009a10260d9eee0,0x00063e1488dd8e2c,0x000bef43bc3079ea,0x00087b3e5515d1e2,0x000027a54dfc6c17}},
    {{0x000bb05b171e260f,0x0000312f11202e54,0x000cbd9782e9eb34,0x0007071408c05d3f,0x00007b0ad44d5ffa}, {0x0008e0fdb6bdc2ae,0x00083bcf267acc86,0x000abae442a4c99c,0x000059d8f7232875,0x0000d3f091a78c65}},
    {{0x00025e9ecbca3bd5,0x0005b277501df3f8,0x00002e53470ab011,0x000c2c5c9f5f0879,0x00001e324f25d94a}, {0x0002c87b5f5c096e,0x0003690c467cfb66,0x00083478fe443b48,0x000ffa57d95db742,0x000084fcea7f7f1a}},
    {{0x000be1e8d816e34a,0x0005ed0373a139a1,0x0005503eb6c76567,0x000d72c0a0c0fe38,0x00000930e2800fd6}, {0x000a839aa5e6043c,0x0001feb1c5709e13,0x00063fa936978e73,0x0001cc67e25bec26,0x0000b4bdbcf0e7e5}},
    {{0x00063de507ea770d,0x000de8db50e250d4,0x0003df144efaa8e2,0x000948957b939cd8,0x0000f00ebd59ede6}, {0x00058f76309396a2,0x00070b764deb6457,0x0001c9d75c4c6c1f,0x0009d4bd7c9c7109,0x000094ab2f959459}},
    {{0x0008e62912bb0c69,0x0007715b88eb025b,0x0008b374d95a85ef,0x0008d1ee3692017d,0x0000e00546935947}, {0x00067e18f669c1a6,0x00031e71bb112d7b,0x000f45f7f358f9cd,0x0002a153c6281ddf,0x00009ce24d9faa21}},
    {{0x000f23a149bca110,0x0006b07752dadb87,0x00012f665e907d38,0x0000550047f8ad59,0x0000a6b2737c88e3}, {0x000df2eae0d2d96f,0x000d847b47f5dc0c,0x0008afaaf8da34d4,0x0000c0a53b08c91b,0x0000e0c5963803ea}},
    {{0x000040a69d08ead8,0x0005d6ad8eece93f,0x000e87e8da444df5,0x000e5f2b193b1fa2,0x00000036b7fac7e9}, {0x0004a15b7ebad244,0x00033aabbc15474c,0x000fda83a8c245cb,0x000c2ef6f58e5947,0x0000ab5619ed45b0}},
    {{0x0006744b238ad74a,0x00032c3f045f7417,0x000a0cd8d1dfa1dd,0x00031dc9d44dabde,0x000084c351aa16ef}, {0x00066dbbbd4b79cd,0x0004a96d5540a264,0x000654e5bf972fe2,0x000124ed39cff7e8,0x000006fad5584afd}},
    {{0x0009b54ae4ccf190,0x0006b5139c106a36,0x0000e8f52cd3cb71,0x000bf08f80ab4008,0x000063ecb5195105}, {0x000e88b3133f9c79,0x000eeb2da83f3530,0x00079992670c5be7,0x000c619c9d672568,0x00009c94c9c60e0b}},
    {{0x0002d3810e75db98,0x0005272729ef9b4f,0x0007ff48b8893550,0x00078145eb9f842d,0x0000b7c621d7385a}, {0x000e48f3bca9cf86,0x000b8618ffd026ad,0x000e625e5d56e39f,0x000ab106e697de51,0x0000a9125a0d4e5c}},
    {{0x000447e9cc831545,0x00039cab5ded44d9,0x000acfe1552fee6f,0x0002053a733d2726,0x0000d8fb9153c30d}, {0x000e7b29e73a90d1,0x000b934edb6a2c09,0x00051fd35387a394,0x000def08b496427e,0x00005f85a2688694}},
    {{0x000424e8f9ba0b93,0x0007cc5433ef7479,0x0002d758a3e8cabd,0x0002c570b4f000a1,0x0000648310308664}, {0x00091a20f1e32de3,0x00041f7fce3ececd,0x0006f7a6a4a18ef2,0x0007a40a6f273f95,0x00006d7bc3eb35a4}},
    {{0x000d62c3c0d878cc,0x000bd2f14f772133,0x000506fc0d074a1e,0x00053b069efcbcf3,0x000054da173b382d}, {0x0006a1152b4b6ab6,0x00077d56291d93b5,0x000356e41211a144,0x000cf742c41cc0cc,0x0000d44d93647521}},
    {{0x000f6db69902561b,0x0009788fc670cdc9,0x00011bc01617c072,0x0001039ee89bce70,0x0000cfeb4e30a91c}, {0x0008f453c12e47f9,0x0008ce538b6874d1,0x00013f0f3dd733fa,0x000df596b652acc4,0x0000070c70ded8f9}},
    {{0x0002577943ed1947,0x000c51f97d56ec8b,0x000635b321c1dce6,0x000f4c0548ac452f,0x0000108844a039c5}, {0x000d188c05a8f588,0x000c907ce36d8dc7,0x000454c24921477f,0x000444f341fa52c4,0x0000a2d7f2d74a60}},
    {{0x0004981202326049,0x0009f23af30ee110,0x000d64a57e4877b7,0x0008d66d3bca95de,0x0000aa95f1b4aaaf}, {0x000957488a1fa688,0x000248ced945f9d8,0x00053e4500e34b51,0x0004ec08199ff786,0x0000dc704075eeaf}},
    {{0x000432d7fec902b7,0x000dcb98903b6701,0x000d7b52267dcb60,0x000413111b403207,0x00001357bed41bd7}, {0x0003d756c1125098,0x000a7a9535cc50ee,0x00098d003854c0f0,0x0004962fbbd5ae57,0x00004841bca8d5b6}},
    {{0x000e30c76057eb58,0x00068ca7bfadc9c6,0x000b3aae0116da0a,0x0004e7debde602db,0x0000de60723a0a04}, {0x000c372afe5f7c62,0x00098fdeab5ccde3,0x000b5f5be690997e,0x0002ac9676df4a3c,0x000028ff6485238f}},
    {{0x000d7abe5b2e9d52,0x0002ffa22191deca,0x0001b9811b5540a1,0x000d459ea5db7dd7,0x00007563c3351050}, {0x000a75fab5e73768,0x00027ca2af62afa4,0x00063a4216da6470,0x000fd71b1066c376,0x0000728e0ecfca8f}},
    {{0x000cadd177056db7,0x0007112b5eaff3d4,0x0003bc769207538f,0x0007fbd0b226cdcd,0x0000d68a971cb7ae}, {0x000d3db0039f89bc,0x0001dce3018f0114,0x0000cd40c9ae9f18,0x000bb3ef18abf742,0x0000e4c4353ecb88}},
    {{0x000fdced3ed27960,0x000a90267c9be8cd,0x0001590535eb2ae4,0x0007701b0fc0c04a,0x00000a023e8bb8a0}, {0x00066947177447ea,0x000e06cde38d8e01,0x0001fff605dcc55c,0x000c26be22dda145,0x0000b32e709b81ae}},
    {{0x000518964e0c5fd9,0x00008a23f3ad0b05,0x00008aad44cb4866,0x000c136a024b9aaa,0x000067192f7f61c3}, {0x000aa96177525e8e,0x0006f03cf1735dcf,0x000d9114dd244865,0x000888ad108db4cf,0x0000aec1bfd08a5e}},
    {{0x000ab3806cce7241,0x000c1ce423887790,0x0000a059a1dfabf2,0x000a244b273397bb,0x00003d65f2a93933}, {0x000a60d1b06036f8,0x000cea8ca3b592d5,0x000964a2fa69559d,0x000e4b4a59647493,0x000017ee9471a84d}},
    {{0x00014f6deef40534,0x000a82e14d3d8207,0x00033d6449a055d1,0x000d431c43f7ed5f,0x00002ed0948cf9d7}, {0x0005e0389a99f1ac,0x000c7cbdce132937,0x0000397e12268f39,0x0003760a23c2f5d9,0x0000c935abac75ea}},
    {{0x00052b1e1073e1a5,0x000f84a0c1c1455f,0x000d942637ad068c,0x000010f8a702108f,0x00002c64ff56f96c}, {0x000b9a16d727e0b6,0x000acf06fe3379e5,0x0005d2bc212790e2,0x000afddcb18846f9,0x00004d030329bc97}},
    {{0x00000106b178893e,0x0007ae2c3659cf4c,0x0007128b98eaa6be,0x000d0f17c825e01d,0x0000fd2e94e765ff}, {0x000797e208c8a081,0x000d12668d49e74a,0x000cbfb9b2628f2c,0x000072932fe4d074,0x00002abae9bd73bf}},
    {{0x000793e3b6b83b30,0x00064f8714d7bcdf,0x0000861188ceb25a,0x000836b57f887559,0x0000aa70f4c39c97}, {0x000e5a6ccef975d5,0x00068bb3df26c700,0x000b1425b20bccac,0x0001beb2c7708823,0x0000c3e597f24036}},
    {{0x000920b4d475bedf,0x000601c20860a37a,0x0001a6c7768b0a63,0x0009437bdf506d72,0x0000de3d4aed0bf9}, {0x00051b6900b359cf,0x000cbfe3d2fe1e07,0x0002762542109347,0x0009d5d83f981349,0x00002085a33e208c}},
    {{0x000b427915cb2d9c,0x000fec8d33d25907,0x000a6b6f878fe209,0x0004da0927589135,0x00008ba9de943b1c}, {0x000a09fab0991dff,0x00080c1e31c86c33,0x0006792b45738377,0x00022fbfabbfabf8,0x00000b81945640ae}},
    {{0x0007aa27ff722866,0x00095500f6877413,0x0003805fcb9e8eeb,0x000097b2ddfcf0b7,0x0000906494cfde74}, {0x0001dad9278c86af,0x0001a53f73534dfe,0x00017c8e51d0b3ee,0x000e2264fe779fe2,0x0000f9399f5c2391}},
    {{0x000f2b9a899efa35,0x00044c5bebbb0c89,0x000f7a937ed79daf,0x000d8393645c3d73,0x000002e30297a15c}, {0x00000d05a8de6267,0x000f1c09869fb65a,0x00001a95369da17e,0x0001d8284f596a68,0x0000a54eb42f428d}},
    {{0x0007afd35e423eb1,0x000207737f624bca,0x0000589345b1b05d,0x000841ab44d9b3f6,0x0000856926f19438}, {0x00031d759bbd89f1,0x000491c56f96ea9e,0x000d5c66b3d428f8,0x0008f65ae85d04dd,0x0000fe7d32eb79df}},
    {{0x0006c9eef207e08f,0x0001e7e6e201fa79,0x00066ba39be6e809,0x000ae2ff6bec79f1,0x0000b616f14c0f5e}, {0x000a3da1546202dd,0x0000e77aab41895a,0x00093e7c9fe3e873,0x00005f4a80c70b54,0x0000548eeadf6f0a}},
    {{0x000cc1a29a108d50,0x0006ccd7dab0a262,0x000ec67c8390b012,0x0005dcb4c64bcf06,0x0000f259d55a3603}, {0x000d5ece299782c2,0x0007a0a1dc54ab27,0x000dd366a6679ec3,0x000a9f22b1d8fa56,0x00000463c1d0eece}},
    {{0x000e0e293cec1e79,0x000efc99ec7f6002,0x000ea6e4722d8500,0x000d2880f2620157,0x000054e88ff06240}, {0x0008fcb8d2e2a682,0x000bb41a29a94f41,0x000046598dbf7cca,0x000fc1c555e4fa70,0x0000e866a08c23df}},
    {{0x00055eaf0cd106ed,0x000eac0ffa583fe3,0x00075d5cb5db3a43,0x00068fdd48ba02fb,0x000000f80f6d4c38}, {0x000dffd39b9c5153,0x000091f21f2463a0,0x000a549ca0718f92,0x00093a5a7c8b59ed,0x000071141a9807b8}},
    {{0x0007357890dd4e38,0x000ad26368db2df2,0x000025d8495c27cf,0x000ff989f1617b78,0x000034d4937f3648}, {0x00079875fcdf6a41,0x0003bafc7add2319,0x00065054796a385e,0x00063f88333b6cfe,0x0000ba555751f971}},
    {{0x00044e669582dd15,0x000609ef7f52438b,0x00028c7c925d34d3,0x00088a39d0f09e7f,0x00001aa149662b55}, {0x000de74ef350ef69,0x00050efa2a33bc70,0x0004e9b4ca36537b,0x000f476a52619b28,0x0000e5cc6e2e16b7}},
    {{0x000740b19e406537,0x0001128987018afd,0x0008c9ef1e3cfcf5,0x000147c2788d343a,0x000000bd40c703bc}, {0x0006907b78203587,0x00054432615b4606,0x000a2fae0e3938e1,0x000420ac9fc4cd7e,0x000061a1a83680d7}},
    {{0x0001e1652f266287,0x0002072786662748,0x0004d6d5004b921b,0x0009798d1624a8c9,0x0000a6c2afe78ace}, {0x000b4716993415ad,0x0000b70c175d0b87,0x0003efa55ba75b9e,0x0009da493ef2cd19,0x0000967d0431319d}},
    {{0x0001bb3328972e05,0x00081d050273498c,0x000b43e91b4aea4e,0x0009d7c51b0b14e4,0x000036a831285442}, {0x00092962275aebf9,0x000ceea0fb01f9e0,0x000ea5a49dab5109,0x00062df927cf2354,0x0000f8845418f676}},
    {{0x000f39d3d76f2654,0x0008b5cef1752354,0x0002c38aeabb3b6c,0x00065abb0b5fd32d,0x00009a4a07ce1f25}, {0x0005648873cbfad2,0x000e64e5d115d4b3,0x000e40d2e3544b37,0x000823b6b1a1b049,0x0000420db940926a}},
    {{0x000a61e31101b401,0x000b74d28dad2d7c,0x0008f99381581fb1,0x0006d98a29dc712e,0x000046c5f42fff53}, {0x000011451423b3eb,0x0003c0d9f657b72f,0x0000ef292dbb3276,0x0002a7c4929e7744,0x0000ee6ba08f8841}},
},
{
/* digit=4 [{1,2,3,..,}]*([2^28]*G)  */
    {{0x000c50fdfbffcbfe,0x000a12ee6bc0d5f3,0x000d1eb16b2119f0,0x0003b21259ba1e92,0x000095afdef8cbeb}, {0x000584520b9e2c92,0x0008610feb591e96,0x000754802ab80276,0x00031ea8ecb90bdd,0x000002948477a4c6}},
    {{0x000fc6d460d9c206,0x00024b68998b6f02,0x000fc9a84a798355,0x0003bd99ba516a43,0x0000f1c752d2f2ce}, {0x000717f6e91c96f3,0x000ba1ff04750021,0x0000101ff724bb9d,0x0000f57875a3b062,0x00001911b2aa36f6}},
    {{0x000c9dbce96a690e,0x00020a9b23952efd,0x000ece1eda0be426,0x0003e42c87d6e797,0x00004250a5772078}, {0x000f792fd6216e65,0x00011a4a7752b22b,0x0004f0652e1c761c,0x0007d6395f3037f3,0x00000f9718cd45f8}},
    {{0x0004c7f57ef9e74f,0x0007af373f4ee836,0x000f3d49fd3a3dde,0x00003bd7ef68deb6,0x000023a2d231ebcd}, {0x000eca838c637b01,0x0002f973dfd6c576,0x0000dfe2ab1c805e,0x0005a94572e7fda6,0x00009401440f369a}},
    {{0x0007d74400024b40,0x0001f5b00db08719,0x0004509077de17a2,0x000354c8eb4c5624,0x000076dc0dfdda91}, {0x0004925d7e16e234,0x000e71fb7a5cd3e3,0x000628461ccda123,0x0001e761ca242827,0x000040a6ef696001}},
    {{0x000e553f6d124300,0x000275d95d682353,0x000d2b82b5b6dca7,0x000d63f3a355d098,0x0000ae0d057f7ca3}, {0x0001f9e4577d877b,0x000c3279477c834c,0x000c7e5cafae2064,0x000a2108248735aa,0x0000554c8dbd94eb}},
    {{0x000176969fce95fd,0x000241c5aa6dc450,0x000beb9be4d5ea44,0x0006fb48576985bc,0x0000dd0c88c86a87}, {0x0008fffa1635a744,0x00014b52e79efa78,0x0008c0387af837e9,0x000b1463f31ea88f,0x00003e02994385b3}},
    {{0x000adf82eec10655,0x0006da35576881ff,0x0001f3593b826072,0x0005479f5a9118fc,0x000081b7ed8887c5}, {0x0009f9ff322cf7ed,0x000a52f29f0216a2,0x000a1c6f5503a339,0x000087e4359a783f,0x00001f2f7550b63d}},
    {{0x000d2b7c76e70230,0x000cac6501adec50,0x000d15eb9ef1627f,0x0007ec71504ac4d0,0x0000e8e72360119c}, {0x000a6a690fe5719f,0x0000b2a6adf1eff9,0x0008001065e53180,0x000c3e7128f929d5,0x0000a8ed05310b1d}},
    {{0x0000184375155611,0x000680c6035cb9d5,0x0009cd9ebedaf7db,0x000025f68ebbaadd,0x00009b22d47c19e6}, {0x0009ed7e238ec156,0x00087ebb00fe3165,0x000f4fc1d9495e60,0x000a7fb7a835fe31,0x0000cbc5fbf249f5}},
    {{0x000ddaf091b1a54d,0x0005aa18a0a22a3e,0x0008c82e61dfde58,0x000ef6fe2926ccce,0x00006f8bf537ed18}, {0x000f182c887d4a0e,0x00001be42965f456,0x000e7c978127d1ce,0x000537d0a1d9e889,0x0000569de4dc738d}},
    {{0x000fa89a0e74e6d0,0x0003d52a6a5b2e22,0x0009d6028cb9cb9c,0x000868143cf11bcb,0x0000f98ceb8beb7c}, {0x0004f0bd89ceabf3,0x000d3055f6bc7d18,0x0000611f84ca8c91,0x0009ceb37e7fcea7,0x00002ab69d8e4537}},
    {{0x0006164be8ef810c,0x000c68f62e3a73d7,0x00042132ea0f220f,0x0009b931a8cfae76,0x0000120e0489c3ff}, {0x000056c882e544e9,0x000dba82d21f227a,0x0003f4d8ead76b96,0x000524458fba4ab8,0x0000af5f9fc5fd38}},
    {{0x00084efca06ca980,0x000f34de85805779,0x000729e45600bd35,0x000abe8d8f71256b,0x0000c757c5918e10}, {0x000d8a877f78c2e4,0x0008eba882fe2edb,0x000ff0a632610953,0x00000ba6c1759a7a,0x0000b96a1b55892e}},
    {{0x0007062382d80b8a,0x000852b7fcb37ae6,0x0000105dffe9b512,0x000554b3f092abdf,0x000049e87155c674}, {0x00073628f54f8dad,0x000eba81d77012b6,0x0001176a2e46bb7e,0x000f52d8011507b0,0x0000fc7de4c283a2}},
    {{0x0000a3774b40ba51,0x000d2e1cc3a9ee5d,0x000566b1a46d5ccf,0x00059f07988c4721,0x0000c80b4f9aef60}, {0x000f16c5f230e80a,0x000da03ec1812abb,0x00006315b4b346ed,0x000fedf2b2d744df,0x000097e8aa16c20a}},
    {{0x000d6e10aa7185cb,0x000017ccc3b062e6,0x00011d8ad8b90450,0x000f8e927aa95f45,0x0000358b43fc06a6}, {0x0001d5d7e36dcfc2,0x000fc29193e72912,0x00012443b6776098,0x0009b04e627380b4,0x0000fd059fca40f2}},
    {{0x00006b777ce58f01,0x000345cefa37e057,0x00050cf438f95f41,0x0008ee0abf1f45d9,0x0000d3ab82dfe23f}, {0x000dec2fdf1e1687,0x0003a9ada1e3f0b0,0x000621bc115b07d9,0x00091804b5c24dae,0x00005a536309e580}},
    {{0x0001a1f36d5a3e11,0x0008dc2f815e7fc9,0x000a6ab5b38987d7,0x00005ba64e516fa6,0x0000e35f790ff4a1}, {0x0000a6a16d83c088,0x0006ceefab1c6182,0x000449d91c98968f,0x0007bb24e4313214,0x0000f72073843b6f}},
    {{0x000bdb5454f13c39,0x000a22272f00d7ab,0x0002e178a51c5620,0x0007ffab23452bb1,0x000095fe77e2c7ec}, {0x0005269f7a15d9c8,0x00096a8c061d84bd,0x0004524b8f8eebd0,0x000df15fadf6f11d,0x000006922729d2f3}},
    {{0x0003db3cfadbe550,0x0007ea332972b6cb,0x000375df17c3205b,0x0003d308348750d8,0x0000156569ad36a1}, {0x0005c1e5a6730825,0x000935b88ef2de6e,0x000bf9f4cdfbcd4a,0x000c1aa110289f97,0x0000e8b4b218715f}},
    {{0x00047831dd65d665,0x00061c4f2c50ca7b,0x000e125f3749ad4c,0x000d6b6dedd6ee5b,0x00008f3560aa418f}, {0x0004cca576eb6ef0,0x0006bf234f5421e2,0x0002931e2453d90c,0x000a5a30ba21d2d2,0x0000f40aef62be5b}},
    {{0x000906e3dcb95765,0x0003952a2d0bb27c,0x00071e7a288f483b,0x0000b33851620f5e,0x000049133fb7e046}, {0x0006fedc5361d7ed,0x000097bdcdbabe80,0x000b57799cd31b0b,0x000f7bdbe9c25b69,0x00005ac7039c2b9c}},
    {{0x000b6b867e927375,0x000fa63b9d79dc5c,0x0006f3e1b3db6fd1,0x0007c0d5e633292b,0x00008252bcf8f282}, {0x000208df42a98b04,0x000321910210d248,0x000c2cc0bbf1cf7e,0x000fda998a5ce085,0x00004661e9931c1c}},
    {{0x0003ff64af040144,0x0000271a4dc2976c,0x000f713650222aaa,0x000a7b0407b2fb4a,0x0000de28d8759197}, {0x00046b6fabd1d7f3,0x000f4abb6a1aa945,0x0000e83a29065344,0x000c3009a559142d,0x00004e4b62383c59}},
    {{0x0009e0629876866b,0x000baa1e5ef979af,0x000344a68c0b5f09,0x000b007ac8563053,0x00009d8b747143ec}, {0x000042138fad570e,0x000f593e59ae3704,0x000886949e418ec7,0x00095cfd231c4091,0x0000cff10c404233}},
    {{0x0006585937313d7d,0x000c05513277642a,0x0003aea43c3c0b6e,0x000f848100f54c99,0x0000872c0c47c3fb}, {0x00097cc55eb26b25,0x0002361e834684ad,0x000dd6b60df38d56,0x000f85fa83e5f219,0x000080ec5b9b7a9b}},
    {{0x0008e57fdd7ade46,0x00059b24d6140c44,0x00002d217ca3f679,0x000cabad76479b8f,0x000088094d742238}, {0x0000f8a7e3617373,0x00035946e4869acc,0x000c11e58b0c0758,0x00047a937c7d9950,0x00006d8fa5650507}},
    {{0x0003e42674ed11ef,0x000404828d8b786a,0x000696d9b1c4a0b2,0x000a64d22d72fb93,0x000014d70fab6fd3}, {0x000db48af8bdb685,0x0000a04eb44f8247,0x000dd01bf9cf8243,0x0005d612508a37df,0x00003b03be491bcb}},
    {{0x00052e217a1d1fb3,0x000e03733ad7df0e,0x0003c7441a511a17,0x000e3fe73bb6fe95,0x0000c210edd71197}, {0x000e1c3b3b5b574a,0x000d784c56ae9c1b,0x0002719fec3c39ba,0x000ac883f91c7e72,0x0000596cbb0e72a7}},
    {{0x00087a7c47d16487,0x0007c27d1eee4af9,0x000efb643de140a8,0x000af19f4764d9f4,0x000015e713bb998e}, {0x000e86dcbb8a91af,0x00012fcbf8d52174,0x00004c90675aec42,0x000d6fee55cd1165,0x0000473a26dbefc9}},
    {{0x00036638b477ef6d,0x000889bef8c0d8f8,0x000f69f8ac86759b,0x0002c5990ba889fc,0x000077c230155958}, {0x000318fe4ed774b1,0x000943b1be4baa60,0x000ee1a405a3bdc0,0x000f93f1b2f417c0,0x0000d8aff7c79fd5}},
    {{0x000ab61ec541eea4,0x0001ddc9914833ea,0x000ddea233e07a02,0x00092d963c34f544,0x000044eff2fab1eb}, {0x000151dc44d86278,0x0003f0a1ebb24397,0x000d4968c888b6c7,0x000fdf950aa9dbd8,0x00009aceb5a6375e}},
    {{0x0008f88f4b8f4675,0x0003e1eb007bd2ce,0x00071e4c30d657d9,0x000e4cd8527b3006,0x0000e64c785f241a}, {0x00060c0a55cbc596,0x000f64194d67dbb6,0x000a74f7e445f24d,0x0008892b9bf8cc55,0x000087103038e47a}},
    {{0x000c4132cd9b183d,0x000612f382df8229,0x000787543d725563,0x0008dc0dafa6bf3a,0x000054b1d9938b00}, {0x000909776b50d022,0x000e79e83c7dbff4,0x000339f55e1b465e,0x000b542cad7a0e54,0x0000ba6a0a29e068}},
    {{0x000468725b4544cb,0x000d798fc46027b3,0x00037c0fef8d6693,0x0001f562e64ba62d,0x0000f4f40675932d}, {0x000d29eb4b2b5d30,0x00096664493a478f,0x000a8ba7c916705b,0x000ac523815da842,0x00002363b3a920b8}},
    {{0x0005576b1b9c4387,0x00012f0b382afb58,0x00090cf5e15b9217,0x000e25c7b242acfc,0x000019252c1e86b5}, {0x000d5ad8a3d0a645,0x000eeaf47eba0955,0x000f27b0e1492667,0x000c14fd914315df,0x00004f8a7c6076b0}},
    {{0x000807ac46701c33,0x000b8d6d492ad054,0x000c5c86829eeafe,0x0003db877d68abd2,0x0000fca131606089}, {0x00046fb59b42ee1f,0x0003ac322ebe5b5b,0x000567698797e76a,0x0003c7d91f0f74fd,0x0000c77ff2c96539}},
    {{0x0002670ed84701aa,0x0009919671d435d3,0x0006aa77f196a6d1,0x0009ff14771936f5,0x000045e8ec81d56d}, {0x0008ff7e385075a2,0x00053a57ae34859f,0x000496f4ac1269ed,0x000ab1e97fce260b,0x0000bc829794fbcc}},
    {{0x000727a64762c5b0,0x00023d5228f62cfc,0x000f9e44f2954c41,0x0006a900f293a819,0x00009324b17896cd}, {0x00027fe6fe89cd5b,0x000c3c1764b979f4,0x000d84375a0a4d5f,0x0007be72e67bd8fe,0x00007978b94bf0c7}},
    {{0x000014848f08e5f8,0x0000dc08a46d3f0d,0x000f2f51cd2de0cd,0x000f26442abb9c85,0x0000b1f0caf156bd}, {0x0001a678227aedd6,0x000363358fbe9f6c,0x000e8c01632b677f,0x00025feaa88fbae1,0x0000dd95784a0bf0}},
    {{0x00036ab62c9baf2f,0x000e3a0427cc9a23,0x000a9a0ba77b1f0f,0x000b2ba599b2ab1c,0x00006167aaef6883}, {0x0000834b4a11c2b3,0x0007e5fdfd466b81,0x000b1bdee8b8d4df,0x0001c6c0b819a31b,0x00006b8ce7712b3e}},
    {{0x000472ce5ee2aa98,0x000a7c8a447852c7,0x000e5e562934541d,0x000111e5956b46a2,0x0000c2def91e1de2}, {0x0004c70da2035d12,0x0009ecf24750f0ed,0x000774bd31fbde41,0x000bef51f1644a0a,0x000075f1a69ccb8d}},
    {{0x000a76901a375370,0x000534a3899464c4,0x000e1bd64649cb25,0x0008de028a8fda1f,0x0000afcf366ebe08}, {0x0003cc2fe33a0853,0x000c655169d3adba,0x0008bacebd18e2f2,0x0001722b708df59d,0x0000673842d3ffb5}},
    {{0x00084f5b5b4155b8,0x0003bee12769b41d,0x000d7c141a89a9b9,0x000f02731f3e90d4,0x0000f5807b7dec20}, {0x000e4d79f5f291c3,0x0007e1820075ebee,0x000d095ee31719b1,0x000e77b13e98787c,0x00009bacf15e8239}},
    {{0x00021e1ade0c9f13,0x0006baad0ce722d7,0x000d6be87abd4fcc,0x000228a81f7554c5,0x0000e992ec32bf51}, {0x000dfe81a7d3c300,0x00060efd94bfa623,0x0007abb915ac1f99,0x0001008b04e471a8,0x00006a6dfb158b1c}},
    {{0x000895918d9c587c,0x000b90d8c07b4267,0x000ab468e989eec5,0x00096f5f2fd3207a,0x00000c4fd8f7ddf2}, {0x0008b1cd86dd7ac0,0x000a8a8ab83f3bab,0x0005768923fb00d7,0x0001e0496024dfd8,0x000093c337f8280a}},
    {{0x000f2f33fb1ed546,0x000f5524877cacf3,0x0009dec562c094ff,0x0002af42d6955bb6,0x000051aac6f16c54}, {0x000f747f4566c18d,0x0000f500d0f779ed,0x0009bf4c72dfb961,0x000237be0f508927,0x00009d1af0421cb4}},
    {{0x000a30ddfb3c9567,0x00044273b206d755,0x000b8261642fa0c9,0x000999c462c3d5ec,0x0000e5cfff9087cb}, {0x0007f4092bba64cd,0x0003c030e85f29c6,0x0000dcbcd00ede6d,0x0001f5c5ab9995bb,0x0000d909fe94ac39}},
    {{0x0004393c8401d21e,0x0008419e515f55e0,0x000b70a2c970650a,0x000812aa1988dfb2,0x00004579ea7e0f77}, {0x00001ae0b356ff64,0x000a67b2f4f8d464,0x0004e4808c24fb2c,0x0003cc7049b70ecf,0x0000d988de6931b1}},
    {{0x0005205bc1daf6aa,0x000b46ea4ce6aedd,0x0001b36b71d5ade6,0x000c684feda79817,0x0000c1b97fd8fcc2}, {0x00015296e4680f82,0x00039c979c619a51,0x00019b0dc58bdb9c,0x000edbf5165245ca,0x0000dda5f64c3464}},
    {{0x0002da59de36c6d3,0x000dc41490e573d0,0x000197752e9c3c3d,0x000caf7729881db7,0x00005781ea0add88}, {0x000709293651cc16,0x000b2ea5e1c2adf9,0x000040381b05df36,0x000cd96512965ec0,0x0000cf761e9b4f6f}},
    {{0x00012f98f1b3e1b2,0x00055f5544270463,0x000c9e4a1d2b7326,0x00007925876fdd82,0x000074ea097a9061}, {0x0006e346721dc27b,0x000037acb54bd914,0x00011e8654a4af5d,0x000c7efafad16cfe,0x0000f0e1c71ca6c9}},
    {{0x00056bad8c8fb6bb,0x000d537ea4bef324,0x000e9fd62945dd49,0x000f97b5d567fef7,0x000086c5b4120ca3}, {0x0002cbc8de7435c4,0x000ef4e32422c90f,0x000915725631070d,0x00056753035060bb,0x0000ac9120611153}},
    {{0x0001ce2ea4b332e4,0x0008a88d39b03943,0x000be58c21e92546,0x000b8614d72a258c,0x0000d6dccab15931}, {0x0000f4d58db96687,0x0009b295553ee450,0x0000bd38d9439d07,0x000760d9baad6913,0x00000af15cbf9b45}},
    {{0x000e116715a75218,0x000ee37a35141d7c,0x000d96ee6c976ad7,0x00008be27249f510,0x0000dd9663c48776}, {0x000806b3a6abaec9,0x000974d53433737a,0x00034026f2f4f6f0,0x0003631542622247,0x000033f84d61ede9}},
    {{0x0005789811a3ae5f,0x000145466230de30,0x00035f272f8c7bcd,0x0008464d6e1bcc51,0x0000c0b21060c721}, {0x00056b9c81e33e1a,0x000ecf8a7f58e633,0x000b78291f065f2b,0x000e115598fa93ae,0x000008d4d5dc0246}},
    {{0x00023976b401d760,0x0006a4914be6b70b,0x000cd32b79cb8bde,0x0001ffab9c10c28c,0x000071ebaf4d93ce}, {0x00025fddbaeca2e7,0x0008b2280bebff24,0x000a3891662f455e,0x000cee7ab7537d72,0x00000da3f309f420}},
    {{0x000d2fa921a168a7,0x0002e4b7b670cfd8,0x0001d3d2b35868fd,0x000fd4925f10a54f,0x0000d3ce9bd12974}, {0x000176530f52e7e9,0x0005ca6a8cc32d2c,0x00019482b90bd81b,0x000cd9a2087e9855,0x0000804eb315a666}},
    {{0x0002197860bc9037,0x000d8b8123349561,0x0003876dc1f987c0,0x000583fb6e6ef179,0x00008cb21fa0cf30}, {0x000fc89c021518a8,0x0001fe3269ddefc5,0x000e6ecf600526c8,0x00082dc869beeb1a,0x0000ceed4cbeee27}},
    {{0x0000659ae15c0cff,0x000524432040fd35,0x000c95fbcb5411e2,0x00010634f1a87377,0x00003ae2a14e5951}, {0x000c01abc86960db,0x0007837753dd90d3,0x000b3a5cbd54cd6d,0x00025ee3849235af,0x00005aead12b08c4}},
    {{0x000b7d73502d7d8e,0x000d7454261868b3,0x000e46fbdbc13c21,0x000713844ea5cc30,0x000049be3239b611}, {0x0002b0432aea713a,0x000625e8db9e6204,0x000d1b612358a422,0x000bb2de468b3935,0x0000d73f40958c1c}},
    {{0x000ef0b57b47fd09,0x0005a747602a55e1,0x000ef3a6ec69c95a,0x000a9812736cac28,0x000000509d742fc3}, {0x000649cba516376b,0x000241310dde1462,0x000486dad6e304cf,0x00067a74ba5dd344,0x000076e637f5c43c}},
    {{0x00011c2158de7341,0x0007322124e7a4f5,0x00002187b24db413,0x0007c89cf37f3770,0x00005c2bbc1a94be}, {0x000c3a8a2a94c5d1,0x000019673c8091ee,0x000a670f1d766afb,0x000dcaf7cc3d5518,0x000067e6f9927685}},
},
{
/* digit=5 [{1,2,3,..,}]*([2^35]*G)  */
    {{0x00005700bcae739d,0x00002be037d24753,0x00015b109f3a7bb3,0x000e43f9da256a61,0x000093ad7b5eea05}, {0x0009fd0396309d30,0x00051affa8b57a31,0x0009e17000aa55be,0x000584057dd782f4,0x00008fc1c3299638}},
    {{0x000d93c48b3b2619,0x00080481131fe4d5,0x0004069419aa8668,0x0002802c3872251d,0x0000e0421b9f2df1}, {0x000bdc567515ba99,0x000aa60a7a56df82,0x000c254922dcad79,0x0003014dbea6f756,0x00003529c91e3e54}},
    {{0x000f4cead9303d8e,0x0007da2afde793dd,0x0006deeafd0c52d0,0x0002cee4e07a6bb6,0x0000805a8d0d1862}, {0x000bb34d90f85393,0x00081fd23389603e,0x000a4addd74321cb,0x000ce7a3c9e82e99,0x0000dd06c08d7e68}},
    {{0x0004e4b39f1a7fc3,0x000685bd324dc746,0x00077329f942afb5,0x0004c07e4ddb8995,0x0000a7edd72789c7}, {0x0005b61b34ef6322,0x0000a0c0708326c5,0x000423a1ac63d4b6,0x000e55cca0e0f401,0x00009daa63d66c01}},
    {{0x000d5fa96476c552,0x0001a9871f6885b5,0x0004ffaab3c7c9d1,0x000d4603f8de64d8,0x00007b2e031462b5}, {0x0008c9e92f0c5787,0x000de242f7202665,0x0003c82030726817,0x0006a6a3eaa87186,0x00003c95078f22e7}},
    {{0x00023916557f453e,0x0004ae26a44583ee,0x000fb5b0a3af5dde,0x0008c41782c4831c,0x0000ea56bb04a5ee}, {0x0000d169d9ff58e9,0x0007dac5db5ca14c,0x00004bf3faad365c,0x000cefa7842801b9,0x0000c473429c32cd}},
    {{0x000d3a6e10d62089,0x0002e7b29cd9afa4,0x000148cd51c8b2ae,0x000a75007bff9823,0x000091ea2803d58f}, {0x000a6e1d7cd54ba9,0x00012006683ca3d4,0x0006b0cc5578ac68,0x0005cbf6720ff656,0x0000c9b8e7ae81da}},
    {{0x0009db6d2b5b0c57,0x0000d45183dbc273,0x000c532d1cd3ebe1,0x000638b8aa1df7af,0x0000d1b32952af42}, {0x0005152b969da4ab,0x000ffc53c8ae6a5a,0x000f8a7ed96e444b,0x00021fa7d3dcb0a7,0x00009f0fef615ad7}},
    {{0x000b2a69f40c9752,0x000d9c51b7ec3baa,0x0003ed0013ffe154,0x000b0917e419d1a5,0x000087bc5ca8dc9f}, {0x0006dfe0e70f6230,0x000bdcab123ee058,0x0001e5900c76841c,0x0001e44fe0b74ae1,0x00003adc613ad53b}},
    {{0x00063c9f8355c127,0x0001540eb5653460,0x000b854039ff3d78,0x0008ae7c2d9a955b,0x00009ca4d64c814d}, {0x0001356a07c69e07,0x000e21ebd8080839,0x000a3b9495398a52,0x000846dcfe86a411,0x0000787df0a13b19}},
    {{0x00027c45c73a8764,0x0001414547d3af8f,0x000fb60a1bb40672,0x0004ae7a70f5fd99,0x000082531e392b1b}, {0x000da4c7c8966027,0x0005e83a98dbec18,0x000a67cc1dd3e148,0x000d57deb57d902c,0x0000f11b0aa60752}},
    {{0x0007d863d57f3414,0x000fe1509dc623ed,0x0008df4273550cea,0x00065f9b96e5fcb4,0x00009ae9885ba4ab}, {0x000ac350b383e5bd,0x000a0f46498bc168,0x000a58596f3b798e,0x000fe6aeb0539155,0x000054e1d4ea8874}},
    {{0x0003b275d29dc04d,0x0007d76747fcb13b,0x000306ea3b2fe9b6,0x000e902e3d618276,0x0000789aaa24ff3b}, {0x000d025585e1c78e,0x000596e4aecfcc94,0x0004f5b5dff9c8eb,0x000695d3ac036938,0x0000d2e6787c6ac0}},
    {{0x000ccd3ce60d460f,0x00007ea73fe2e166,0x000b13997331a00f,0x000bf84382342cbf,0x00007e70f6af3225}, {0x000335bae3648d46,0x0005c252c9be9d30,0x000b173ced6a5a93,0x00062cd16c887a31,0x00002a4f9fbbbf9f}},
    {{0x0005a47a979741b1,0x0009565bbf2dd4e9,0x000af96bbcbc82aa,0x00026bf44f9cd822,0x00004b2b149910a4}, {0x00050f9cdf45d19a,0x0001eda90005e40d,0x0000abd40b1a8e66,0x000244881e5b8a56,0x00000e73a53fe7c9}},
    {{0x0001dd32de445aa6,0x0001fc91cf2f9f3c,0x000cf76c57384160,0x0006f62abd1f13b2,0x000052e2ed7e3fc4}, {0x000d88787f35a985,0x000e2148e3be1e7a,0x0007b25528a99e57,0x00035b65281c2f4e,0x0000c1eb2107c6cd}},
    {{0x00035d5a8c2927bb,0x0008de6d2b0185a1,0x00024afffb21509f,0x00056b3b64117f50,0x000014162b8f15d3}, {0x00024513d05bd8b3,0x000434f9385172af,0x0001a1f98c4d653f,0x0005e9ef0660e5cd,0x0000273cbf1678a5}},
    {{0x0005911351a59103,0x000e04b05be68d91,0x0004a7bede129f38,0x000a1a51eec3037b,0x00009215fc231a08}, {0x000dd81523b72a23,0x000894715cc1a87c,0x00091f600ab80cef,0x0005a0ab3eca37dc,0x0000b2bc149ce4ad}},
    {{0x00068d2c36fd9f9f,0x0002973c5be71204,0x000e5a97f4bb36f9,0x000f1907757b63c9,0x0000fcc1fbc2fc33}, {0x000eb5cac213cead,0x0001c14e861adc28,0x000f903943fc7081,0x000da639df6e310f,0x000040d070b3e432}},
    {{0x000d7619d49860f4,0x000ea16ce8ca2f98,0x000f7a39c2b109d7,0x00055c8ae1632632,0x00003a28a5876314}, {0x000509cc3ed28df0,0x000cc59ccd51ee9a,0x000cdc1784ba5cb3,0x0005898cfd78caf0,0x00008e1987ffc9c4}},
    {{0x0006780551ed5362,0x0000162b85d37aab,0x00052c0a5dccf49a,0x0000008978e8fe28,0x00002aef7a358742}, {0x0003eaf9eb9304c7,0x0002bc6376029477,0x000c2b67f2b6f818,0x00045ae346f21474,0x0000533e9491e7ee}},
    {{0x000821aa8c6a2ac8,0x000818984232ecee,0x00008bcff77eddc2,0x000f1868ed1e27bd,0x000057062274e3c7}, {0x000f1f1e845f219e,0x0006638746018c4b,0x00079c20a4d39735,0x0003878465feda34,0x0000ad6855572cb6}},
    {{0x0009354b24d7ada1,0x0001567cc35e0245,0x000f79c525b386c1,0x00013a1c4fe295fd,0x0000734ae5333989}, {0x00049712b0342f42,0x000a478fead6dbc2,0x00041f2ad87713c3,0x00037135a752173d,0x0000b5a42c879097}},
    {{0x00066a43e3dbd58e,0x000729043504c8bd,0x0001dfe5e88ce125,0x000b8e4a214027f1,0x0000e0bfff41c734}, {0x000497d8ef9bff74,0x000dfbd8ec3dde6c,0x0009dae39fbaeced,0x000c615eeff4aecd,0x00000b575a8087f6}},
    {{0x0006858fe09d95af,0x000e54554313a7ae,0x0003adbfb75fad76,0x0006af4c0e89f84b,0x0000cbc199841374}, {0x000d3daf04bee219,0x0002f16c60fc3b73,0x0000bf406b089be7,0x0004df5aec57f12e,0x0000f4b714839375}},
    {{0x0001a7b34a992617,0x000262b67fd16035,0x000f4cded03bd337,0x000a495f4d446c82,0x0000de7f0ecd39ef}, {0x0004309127b7e470,0x000333eca6abb6e3,0x000e251b37d1836e,0x000e19b24cc67dda,0x00006986f3fce1fe}},
    {{0x00006b3c165ba83e,0x00040763b7168cd5,0x0005b2089849d3ee,0x000158864b408e50,0x0000d1e7c3c11ba3}, {0x000951b1022b0811,0x000a6ba9409ee8d0,0x00082031e38d13ee,0x000986a7af0f043e,0x0000cf5bbfcacd65}},
    {{0x0006ed33eb976593,0x000cb73bb5996a5d,0x000a8d40797d331a,0x0008195eab513d66,0x0000745011a8ad57}, {0x0009172aa1b56b55,0x000681e0477e446e,0x0004dd55b38c0636,0x00046c34beadb245,0x0000f622ee53fa27}},
    {{0x0007b0a3ab20cf47,0x0005b6ecbe5bf999,0x0009b3cdaea41415,0x000dddb1a4af7693,0x0000c87b4d02be99}, {0x00044162383848a6,0x0009bae35ed444fc,0x000b61b91b37a6bb,0x000c991cfe2a21c2,0x000005e9cfbed62a}},
    {{0x000a1a9489a1a5ec,0x000ce2cc85fbf558,0x000f2223a8aee3ca,0x000478fc82ab4b29,0x0000ce60dd26d1b6}, {0x000dc4d8f75b7e43,0x000c8e7ae5cb1be6,0x0009bc9a205da2e2,0x0000b9d8f07fbb11,0x000007c9c2797b7d}},
    {{0x000ba6fe16b74a37,0x000c9ef80b1e2a3a,0x0009b6ba80ac3749,0x000a58cf3522eba3,0x00004f2c5f7bc7fd}, {0x000ae382cb1abc5b,0x0005df37a1e6cd6d,0x0004f4dd227488b9,0x000587f8906c8701,0x0000c94e7603d61a}},
    {{0x000f31b12c8e946f,0x00041998676a0cd3,0x00012cccc0790516,0x000d05413f948da8,0x0000915d9bc125cc}, {0x000631c24a7ac56f,0x000cc7dbbc6a8f6e,0x000a263d88d9b845,0x000ac140e423d536,0x0000abcdfb4c1ede}},
    {{0x00036dfe301d6bcf,0x000976515927a0af,0x000260fcbb9fec72,0x000d7a1d042bcb4e,0x00003986716d1e65}, {0x0007a8b84e008f31,0x0001a9e0bbf32708,0x0003023c184225e5,0x000006bbd97e7f72,0x00007a8476f8c3f8}},
    {{0x000200faf183b044,0x00091921123920f6,0x000df3ccbb457e6d,0x0001c38fa6eba464,0x0000347d78c4d002}, {0x000b2f467c70d83f,0x000a9b0ee2ba361f,0x000def1984834b5b,0x0006757a81659a0a,0x00005cf0e1308d83}},
    {{0x00041ecde4f12ba0,0x00055e2ab6f60ccc,0x000400171094c76e,0x0001f83d982ca07e,0x0000bfd8343191ee}, {0x000f9f86ae6ad522,0x000bd01e24ac8cdd,0x000622bbda9e9819,0x000bfccf5e80a139,0x0000ea19704218e6}},
    {{0x000fb670adeb0531,0x000a2e1cb11d95f2,0x0002237733ba53d6,0x0002af7a4f5b85d2,0x0000d11b8b4df863}, {0x000f21077157d779,0x00029dae46ae076e,0x000ef1a942676f1f,0x000698d2955c21b4,0x0000366784d1b5f8}},
    {{0x000d37ab64d1b8a3,0x00048a552398fb88,0x0001d701426c97ce,0x00054721bdb66fec,0x0000bdc35f96e76d}, {0x000480bc0f59b636,0x000445d5741bd54e,0x00007a408f26f505,0x0003f9d9158c7ff6,0x0000ff89ff1faf90}},
    {{0x000bc2333e034b3a,0x00064dea255dc2e1,0x000153b1d74a371a,0x0009201c2dd539c2,0x00008464ef965378}, {0x0003be3e2d7ffc4f,0x000a0233bf14077a,0x0002bb433fcdcb11,0x000fb8623c1e9373,0x0000767ed200d1a8}},
    {{0x00082d0bd4f64295,0x0009f5eb0d7a40a1,0x000e40bed0984111,0x0000c3c234be2868,0x0000a55bb693492a}, {0x00003589e0e1c59a,0x000b79f78b50c3dd,0x0008e289bb712956,0x0000c85c99d84cfa,0x0000a5af77c7b795}},
    {{0x0006c6e73e758063,0x000aa4c0ca07be80,0x000a771d1a3c2b89,0x000f8e30bbd4d1f2,0x0000707591fefd22}, {0x000baf90e9d177b6,0x0002f80643449531,0x000fa11454675837,0x0002074957d79a89,0x000023d4bf71171b}},
    {{0x00012ff13201e572,0x0001c2d35ca8a962,0x0009211dfb91e1bb,0x000d6b83cbe76c57,0x00005b47bc9b1b75}, {0x000cf3690ccde132,0x000203bdc7c14ed2,0x0009be86fc27ebba,0x0004eba9b9fc557d,0x000081e537c1cfda}},
    {{0x000edfee74727d78,0x000980a22c07efda,0x000b10e358fad228,0x0005c368538ea7ce,0x0000b7ca5d8c2865}, {0x0006c1397b278758,0x000841d382b260a7,0x00040b29c25b9e45,0x00049b72f524c365,0x00001fffd1819be9}},
    {{0x000e1fe027315046,0x000e4a8e9ae005a4,0x000e29dad879e0cf,0x000713338832c69a,0x00003efed8d22203}, {0x000e9be0c541ee45,0x00043c0e163d6976,0x0006689793657bcd,0x0008f5b80673d362,0x0000c7348859135d}},
    {{0x00072bc3bd04c059,0x0008da4e3ff7f4d9,0x00070f0f1e03cebe,0x0004a82cb1df491d,0x0000cff4a142a9a8}, {0x0007a0aa0adfeeed,0x000d8ea5a8781ca7,0x000f8a9d70def5c5,0x0005f0e216119383,0x000056865c8536c9}},
    {{0x000c2b7335282880,0x000df2155af305ab,0x0003cc18f696a952,0x0003e94feda61624,0x0000074ce58fe838}, {0x000d1423175154af,0x000fe1ae0cacb704,0x0006b7521866fd89,0x000dc49d637a4c2f,0x00008dccfc32bf4d}},
    {{0x00058b746d6febb7,0x00056fdc8cde8233,0x000c5724a2fcaf62,0x0002c41d3479ab73,0x0000cd65f0ee0ad5}, {0x0004b4965d7be852,0x0006736dfdce5b87,0x00022e44ee30b9ff,0x000510f3c1fd2443,0x0000b17b0a94a0b8}},
    {{0x000ed9da5acaa517,0x000e2d9bc48b2b20,0x0009589a56d9ec6e,0x0000cd50699c9cf1,0x0000c0682f67c25b}, {0x000ad83acc2d9df4,0x000b491d3a194ec3,0x000f43e0aa5860a7,0x0008825d7c9356bf,0x0000ffd010d5ac2b}},
    {{0x000ad7d4257077af,0x0007d06b6e41f434,0x00081d274d0d97bc,0x000d46b97f058b8a,0x00008141f09a57ee}, {0x00059c2c95a92ba2,0x0004dbd7225bde57,0x0005ec9647f39a2e,0x000a46b029f14b8e,0x0000e8a3e62f0c3d}},
    {{0x000af97ab489033e,0x0005ffc2cbd90b39,0x000bc39c20e78840,0x000b48cd3c1d2d1a,0x000065f064cee3fc}, {0x000a3b79e03ee91a,0x000d739b8fffef5d,0x0008d7784f339ddf,0x000a02d5cc657cb5,0x00001fb78c5705a2}},
    {{0x000fe19eecc5e624,0x000306f9bcd832a1,0x000b535333e9171a,0x0000a14c3dd19f34,0x0000bfd509e3ec8f}, {0x000d131ff598e707,0x000efce0b7cd59b2,0x00008b2e08b38876,0x00028c0e783e18dd,0x0000a91d85b2dfd9}},
    {{0x0004382f883cfa65,0x00007fc08c3e7142,0x00031d2cf6a1e10f,0x000b73831dee9409,0x0000a725ec88ef3c}, {0x000e45138849f25c,0x000af48749f6cddb,0x000d14475f1cac00,0x0002cabd31e17b50,0x0000d48626e3da74}},
    {{0x000d0de0ff499960,0x0003fbfcf664ef0c,0x000452faffdd7772,0x0005d14882e7b0ee,0x0000b786850a0512}, {0x000390625f2d5fad,0x00097f518ec1a4a5,0x0002f3d039da3312,0x0001a9edc17472da,0x000096d8837d422c}},
    {{0x00098d1cd3290a63,0x0009e70dc26c34ec,0x000fb8080a9ca335,0x000e643ad8d71805,0x00009473d89368fb}, {0x0003a8f3f95413da,0x0006d4ba18760cd3,0x00015ad17f92f4f3,0x000ce2649cf662d6,0x00004e46841f615b}},
    {{0x000d33f7c64c592a,0x000b6794f7501394,0x000df640f443e759,0x0001115b48de8e41,0x0000a085e12aedd8}, {0x0008c0b7e2b229ef,0x000b6d02a9baf2c0,0x00022cc20ae9044c,0x000e8d6e6ca27b62,0x00005703e8b98911}},
    {{0x0002cefc1f02f736,0x000540270033b3e8,0x0003ceb47e84f986,0x000e14fc35ec1c12,0x0000f46085bdda1b}, {0x000cbc25542ce047,0x0005a07add73f5e2,0x000320971ec0822e,0x00035a98911e32d6,0x0000881d02f4e758}},
    {{0x000387b347fbdee2,0x0006458ebef829c1,0x000f7bdfa33f4d8a,0x0002883778b30bae,0x0000a57a86aa56f3}, {0x0001ee174ceb06c4,0x000b005d309fccfd,0x0004d56aaf05a383,0x0007b122e2a74e83,0x00003ae917835919}},
    {{0x000b2e078e41d080,0x000d82af788420d2,0x00062fb2b0bd6d30,0x0000d29e31188cbe,0x0000fb42bc94f44b}, {0x0003accbe6f8e771,0x0007513275c93443,0x000099c782740df3,0x000b459fad4b877a,0x000033181c9bb1c4}},
    {{0x000dde73fb0eda0e,0x0008f6af3e12a3b0,0x00070b40f538cf4b,0x000dfc9a8cad561c,0x00005c1801d14801}, {0x0002dc79588dc298,0x0009f476f2307348,0x00070463a39ee33f,0x00014bb90225bd9b,0x000010b40545d203}},
    {{0x00036dc7a7be1464,0x00010d064c152673,0x00019582bc150f70,0x000cb20deb2fe94d,0x00003c415ba4f212}, {0x000985f73eec9d69,0x000f765a6fccae60,0x00097f2f3c826fb7,0x00047dd07d59c9ae,0x0000707066e8983c}},
    {{0x00041a35ed2eefac,0x0003a0fbcccb63d2,0x000fd5d39ee7f02c,0x000d05a5130a3242,0x0000bbb31c95b0bc}, {0x000ca4ba534b4c07,0x000fbe96ffe723e0,0x000b5137627b8873,0x00053eb426e6c7a7,0x0000febe40fcfcba}},
    {{0x000346e0b45a707b,0x0009552613f225f5,0x000803741bd4eedf,0x000933cc8d49c2e1,0x0000a0a7a1802a2d}, {0x00015993942ef2d8,0x000a6714ab7c1ec9,0x00037e0ce22b32c3,0x000ffe9aeaab9bc3,0x000007042cafe458}},
    {{0x000b755d669d39d8,0x000c3024b484f11d,0x00034f49b01e2ce1,0x0008ed0468857e28,0x0000254a9385fdf0}, {0x00055e07a3d440f8,0x00042678ee665499,0x000d14e839ec6cdb,0x00015ef57c3c712e,0x0000ed2a33990852}},
    {{0x000957be96b408de,0x0001ebc7fea66f42,0x000ee42926b6ac46,0x0000b4e4cb455b9f,0x00007fb272c87861}, {0x0005ea64c175d75c,0x000e57ab709e7669,0x000f97d844601eea,0x000524f6c42043f9,0x0000257150f4b193}},
    {{0x00019b55359a6996,0x00066ea8746126f1,0x0003984c698d3b0b,0x000148d30ea757f0,0x0000a5a62e68d1b0}, {0x000b1ceb549a8926,0x000f6127020a2f62,0x000cb3fd49371a21,0x000f1e9c3dfc9693,0x0000f10737a457e3}},
},
{
/* digit=6 [{1,2,3,..,}]*([2^42]*G)  */
    {{0x0008da4ebfceed2f,0x000160ab87632830,0x000a7a776b62d8f6,0x0004161d81461a65,0x0000d2503d370ab1}, {0x000a3a28b12e059b,0x0006dba7a43ef9af,0x000eb449b66afd29,0x000b4f497099cf91,0x0000b740d849144f}},
    {{0x000d1cb14db150ae,0x000c2825db119cee,0x000e5fa06f3d8cd3,0x0001519236fc45ff,0x000017232f7c8181}, {0x0008b9e65214d82e,0x000a8d9bebd6dcfe,0x000c1e6f59806e97,0x000d0a1cae163880,0x0000454a197aa771}},
    {{0x000fb2e99ff222fe,0x0002f6cd6bc0c742,0x00011048d43a1261,0x0002bc6c0346ba52,0x00000874002068cc}, {0x000d17dfae243b95,0x000e8b373c9aa0e8,0x000e84c66747a444,0x0002560f7e0b8280,0x0000dcfd670f7595}},
    {{0x0002524b949e4535,0x00090f56a6cde629,0x00006c5056ca68db,0x00087837cf37f5e8,0x0000287aeba17f2c}, {0x000194d41a0f7a82,0x000aff261f9d588b,0x0006ee54936659f4,0x0003de1c86018de4,0x00005bb7bee891ac}},
    {{0x000dd4596bac0c33,0x000a79383e647f24,0x00062bfb0f5a73be,0x00082923eee62853,0x00009c04543340c6}, {0x0004c782a0e9f2c3,0x000e03645715f5f5,0x000fa691a3c1b9a6,0x000e7ab9adcc6de5,0x0000db83ee04ac86}},
    {{0x000d23467ed57309,0x000db8f9d25bed94,0x000dbe922092fe90,0x000764e90499c35e,0x0000cd06d43dbfbb}, {0x0000064077438554,0x0001c32ae4be0845,0x00061d2fcaebf091,0x000c4346a089d960,0x000055f71e1c5a73}},
    {{0x0002f96218c9d5a6,0x0001641dd16123d0,0x0008ab2e1526c4ed,0x0003e09ffc5e3edf,0x0000df1e41035c68}, {0x00077bcd67728b89,0x00047ee4e6273040,0x000cb877fdbfcf62,0x000eff21cb5a44a2,0x00003511953a16ce}},
    {{0x000409ffca73851f,0x000c3de29624b94e,0x0002a47c5c60b925,0x000e16665847cd08,0x00008e7f8ebd9097}, {0x000eeb9e98545750,0x0000ce814b1f1ed6,0x000b01ac8d35a5c3,0x00075837d8e25100,0x0000c3c5bd7d279b}},
    {{0x00076e1d283c6ce1,0x000f7174959c50ba,0x000dc4eaecd286d4,0x000634535982fee9,0x00009158cb09e7d4}, {0x00017b5f6cd33044,0x0002969dcb333eca,0x0005d0e40dd7519e,0x0006b515ebd579a2,0x000024e41aff93ab}},
    {{0x000040ff1375951b,0x000a1e839dda7393,0x0006bb352da54b3b,0x0002ae6c9597e201,0x0000d9dbd47572b3}, {0x00056e9021dda66f,0x000e6fe0123fc320,0x0007cca3903d3977,0x000ef0e68cdaccaf,0x0000bb4084bf66da}},
    {{0x000d2f201031c945,0x000b772e503d6e75,0x00042cdc17bd8ed3,0x0007777ce2a48632,0x00005c328a9c3027}, {0x00070c96d90b6fdf,0x0006762cff8288de,0x00001a6ce10f17ed,0x0004b60b2595dea4,0x0000d81fe47c8c90}},
    {{0x000c39102e4fe37e,0x0007b23e92ab7da2,0x000353e2a4aa27de,0x000cc7a3fc098e3d,0x00002536baff989e}, {0x000be55df78b163c,0x000cb15a4f900b15,0x000738e13e4be770,0x000cf45a8c0b1e35,0x0000d1c8b85e4c20}},
    {{0x000d8a6f91768025,0x000780bb92a70307,0x000ec75e9f0a4627,0x00018b3f31d5783a,0x0000ef5c08e724f6}, {0x00056b23247f3db8,0x00038ade392d9748,0x000a43483fdba1d5,0x000a5c1dc4f1a93d,0x0000b35fcbd53c35}},
    {{0x0006e5b5f09bd9de,0x0000bc9fb162290f,0x000034f2dbce94c6,0x000c8626fd489944,0x0000d0a4061eae30}, {0x000b78b3bd8a273d,0x0009de5ae80b923c,0x000eef67b29524b2,0x00014e750cd4e68d,0x000073f7f21962fc}},
    {{0x000877c7f92f06b5,0x000b95cee57a30e3,0x000ffcb286123ae9,0x00022d50fbf6547e,0x00004800675d1bc9}, {0x0009b9e818f59d1a,0x00077d2030cdc4a4,0x0003a9ed390ee53a,0x0001df3669085b25,0x0000f51fe98bf18b}},
    {{0x000ccbecccc94f0b,0x0008c99893a55b13,0x00041516d980406a,0x00012ad64445dc39,0x000003dcb08f3616}, {0x000905907009deb2,0x000ded15742863c2,0x0003a9de2612f089,0x0003f2f1e316164a,0x000095cdb1f35323}},
    {{0x00048f32683a1106,0x0003a7a5b3460224,0x000343e47d7bd6af,0x000126c091046994,0x00005de2a5b586f7}, {0x000254188f58af50,0x00060974a069758d,0x00091651f61f3bac,0x000a319e608f0298,0x000076b7f2c0358b}},
    {{0x00000d3f381e3ef3,0x000ceeb6c1dc33a4,0x0002adde75fa3959,0x0009beae4a15a271,0x0000d91f39a52916}, {0x0006e68167f8436b,0x000613d0010f1b08,0x0003bdc583de98b5,0x0008ced07b396a51,0x0000f5f1ccd47883}},
    {{0x00053474745b4111,0x0008d69ab64986d6,0x00028504062204bd,0x0000eca3a2c7a367,0x0000a183bd071463}, {0x000618d9a29310fd,0x000c586fd5dfd7f9,0x00026b628f55ea0d,0x000e9141be7be638,0x00009ab70426722c}},
    {{0x000f4c6b7f0b2b2e,0x000b35498ad70152,0x00093c54616a18ed,0x000e4887a4d5a30c,0x0000c8ce85111073}, {0x000b61623a4c2109,0x0007aaf6df31d435,0x000e6d28f6f0b661,0x00010c63d8f4fd58,0x0000a716f19ad118}},
    {{0x0009cc90fff48c76,0x0001a62b3ac032a0,0x000b5de11f98ce03,0x00066f2164aead02,0x0000da752ba1afdb}, {0x000d7ff20909c958,0x00089515a1f95adc,0x000675794b9fa634,0x000e20f2564f7acb,0x0000bcf3634218fa}},
    {{0x000e4e170e87d63e,0x00033b1ac864b298,0x000d6cac3ba652e6,0x0003f216dfe43c73,0x00000994b53a9850}, {0x000ef04ead3ef321,0x000f6d077d47a1c2,0x00091df581572494,0x0004bc458f8e24b3,0x0000c2de27be5104}},
    {{0x0004d336eb2b06dc,0x000d438af59f9816,0x00086b544e2a7565,0x0008feca007deaa8,0x000038b1c05044a7}, {0x000eacd2e1baa833,0x000ab3d6f9a39bf7,0x0005f9a26b4a4cd8,0x0007fe97e08d97c1,0x0000e07374b44b2d}},
    {{0x0004dd2e81908fd2,0x00053362700b61c4,0x00047b4115ede230,0x000e824902002b8e,0x0000fbcc6260def8}, {0x0003325697f653d2,0x0008966e57020f8d,0x0003416143080196,0x0004c4d2fd9b6e91,0x00007ade93e02f1e}},
    {{0x000ecd682caa18e1,0x000f70d2a0a391d9,0x0002000a80040e56,0x000857d371f72e8b,0x000053775b161201}, {0x000f90ea5eb901bc,0x0009364d5c28a36b,0x00005a3daaeff7bb,0x000133f544a030cc,0x0000c4cbbce12e0b}},
    {{0x000f8c9fcc7163d1,0x000572b83e473108,0x000bba1ec860c1e4,0x0001e09ceb4984ee,0x00008bbae4d3fd8e}, {0x0000e95aa9b6fff8,0x00013bf54498bb71,0x00098c0dc39f81a0,0x000f4d5f47a7767f,0x000053d12f97e872}},
    {{0x0000a32458403bc2,0x00082b711c5a4e92,0x000be5918eedb420,0x0007560f86f6b115,0x00009eef65546fcf}, {0x00081bcf351ff9e7,0x00039fdb3c33d733,0x0000221a9d2cfe38,0x0009978c093d8420,0x00008091d026a7bf}},
    {{0x00007fce2951dfdb,0x0009b16e29e1fefc,0x000e24c61a1bc2dc,0x00064ec20795b0f7,0x00006867bc74d613}, {0x000ea7544ff9e1a7,0x000863bcedd14dac,0x000776fbd052c35f,0x000040b845e5e89f,0x00008d3631aa2f1a}},
    {{0x00078cb5cf75d160,0x00082adcd531e19f,0x0001f334ec5d686b,0x0007bcfc67e75339,0x000083292fd5cb3c}, {0x000ca0f2c79e4395,0x000d7220b49dc04c,0x000d3bf945b11bd7,0x000dced7c2b83ea6,0x00005baf7714ff68}},
    {{0x0003508c06e840d9,0x000135b5a2b19028,0x000ee969d63b1a38,0x000161e84ec50423,0x0000f2fa14216578}, {0x0004bfe086722bf4,0x0003cf085472f45e,0x000dfda75e905f33,0x00079bdd9d624bac,0x0000fae3603f75ba}},
    {{0x000ee7df45826065,0x000159449fe4f3af,0x0001d996e565d3d7,0x000672368612ab1d,0x0000b960776c83e6}, {0x000d3ecc1939a703,0x0009f6c9772241da,0x00098eef9abac2b5,0x00032adbadd70bae,0x000062ee5f76ad58}},
    {{0x000fd21287e5c826,0x0009b0b6759542e3,0x00065f7682b53c33,0x000431f1b099e8c5,0x0000215359e247e6}, {0x000ecefb66ae71b0,0x000c047b9bdf08b0,0x0005d0993282cf6b,0x0001c428f51699c8,0x00006ac5644d7483}},
    {{0x0008a6bf88a12bc8,0x000cdb7063092912,0x0001649711d448cf,0x000792826cbe6242,0x0000b333087bceb8}, {0x0006b67ab7ffab12,0x00025a16516d0184,0x000c86a31293dd6e,0x000a457b718e848d,0x00005e930921509d}},
    {{0x00045277b9938fd7,0x000e086e2c20dff9,0x0007dce3453814e0,0x000e253ca6ba6c61,0x0000f538b78fd25f}, {0x0008e6179f3b912f,0x00078b639a80001e,0x000414bf793b6324,0x000bb8e28cac8f71,0x000031ad39adcade}},
    {{0x000a465f76d43f56,0x00090150ef7afe7d,0x000b2300b65a46dc,0x000e4e184f9a0661,0x0000561c2fc130d9}, {0x0000a143683c7212,0x0009a56843b2c208,0x0005135d6f7b6c2b,0x0000a908bec8776a,0x000034f7ab83b724}},
    {{0x0008c05b480c3297,0x0005a07fc36b2bc3,0x00097924fce51403,0x00007eaa739b3ab6,0x0000265fbf04966b}, {0x0002950b0f740005,0x0008cf8940d2564d,0x0005fd0c6b2dbfd1,0x000c6ce9a6b44dbe,0x000084a9579b81e7}},
    {{0x000e916369db82e0,0x00020510f751afcf,0x000eed18f269af1a,0x00013c1ce9324e71,0x00008683d69fc1e4}, {0x0004e5889623baec,0x0009ba4018b294b8,0x000e6bfb3c0b24e6,0x000bb0651dbdf225,0x000027ab085ca68d}},
    {{0x000f09a4ab6c3aaa,0x000de01cb3ba63c4,0x000e95f1d210e7b4,0x000f3a8d12cf38b4,0x000018d1e9f0e6ad}, {0x0005dfe6cbc23716,0x000aa7708956bd51,0x000a734e02a987f9,0x000198b26b6caa0c,0x000066d2bdfa41f7}},
    {{0x0009b8808e884a94,0x00056a949ba89d55,0x0006dd0557bc07d6,0x000df3f286c34b23,0x0000010cc2c61658}, {0x0003c84869304a8b,0x000c4e02538c802a,0x00014310ac59c7a8,0x0004e213a3299cbe,0x00008091b8c7dd4c}},
    {{0x00066d7d54bb7037,0x0009fc78a9ea064d,0x000c8c718ecb6d4e,0x000b29b0b388df47,0x00005ce278ce6360}, {0x000615c03685384f,0x0001493d593abf47,0x0007bd22554fbd0f,0x000cda5b2fbacf9b,0x00000be25106f6db}},
    {{0x000db548aff3dd66,0x0009fc3e222a2257,0x00021af9576355f5,0x00038fa46dacfcf1,0x0000a39c02de3477}, {0x000e5949738ae55b,0x0002b82b325aa2c3,0x000316cfaab2be69,0x000c3155c811feef,0x000094001c4354f9}},
    {{0x000e52c880cebefd,0x000fbac37dc45285,0x00047d8233836931,0x000393a52c077d39,0x0000f2cef1dcb976}, {0x0004fff652069879,0x000f14bd96afc0f1,0x000d7647c5393c35,0x000b655fa3d54814,0x0000b31085f87723}},
    {{0x000c64f583e1f402,0x000473a19323b48d,0x000d2fce8f8f79be,0x000cd0f61edb557d,0x00009ba886a6747e}, {0x000f6589946073be,0x00002e0d1b415ede,0x000135675a16d9b8,0x0002cee38fd0b032,0x0000a1d1db71309c}},
    {{0x0008a92ead7f3bdd,0x000ea3397552948c,0x000df72673192c3a,0x0006ba2de5b32e77,0x00009c0d4111e5a8}, {0x000bd04137e03344,0x00089b4162fd10fb,0x000ebd666ce66159,0x00064d877840eaad,0x0000381e39594fa2}},
    {{0x00000628e098c674,0x0009cdcbf9ca0680,0x000c9f9fe4c5a3c1,0x0000f7b96570ef82,0x0000049c1cd347b3}, {0x000fb672fa7243a5,0x000c2b46489362bf,0x0009a950e91645d7,0x000e29f1b1a58485,0x000003188482ca65}},
    {{0x000e8a5a08e6c7c8,0x000d1896d6be3d81,0x000632895b101d4c,0x00031a37b4f35e11,0x00007da1f2d7abe7}, {0x000576beeab98952,0x000748d0ccd0c23e,0x000b5c50c67fca2a,0x000936a558e370e5,0x0000985eec700203}},
    {{0x00037f6ba08ad439,0x0006926c8ad8398f,0x000df38a044b9452,0x0009463c48a42ddf,0x0000a860dd55a6b4}, {0x000d162812b222ed,0x000fd854816b2dad,0x000e65262e4eb660,0x0005a5b527b029ea,0x0000175bad33bdec}},
    {{0x0002c3da8cbbe229,0x000aa90abc735562,0x000bb0db89d0e690,0x0003454c1c36d6e8,0x000036f4e1df9931}, {0x0000ad2fb609c4b6,0x000745f01f277c0a,0x0004f07d4ce8634e,0x0007939a3356bbf7,0x00009fa9bbd0303c}},
    {{0x000834bdba6935df,0x00068b5bf0655c17,0x00009c8960d66e80,0x000b3b6460148a4f,0x0000f945f0f28aea}, {0x00008c5ad9f47c68,0x00079e9a1df4281a,0x000eb5d36cee9dce,0x000d177605462f15,0x0000bdcbfae25681}},
    {{0x0004c6b9e03db771,0x0001da5fbc75f102,0x000950b5e2ab475f,0x00073cbe4e444a5a,0x0000bd5871471640}, {0x000d74a1ca5ad868,0x00048ec67d0c8551,0x00000d3328df82c8,0x000e5f6f20f8912a,0x00002e0fe080c362}},
    {{0x0001c3d6d6d5d264,0x000b218027996557,0x0001970f15dafe9f,0x0000511096cf81f4,0x0000c9526de03ea1}, {0x0001e30dad4e3f37,0x0003aaa14b7782f7,0x0000539fa89532b3,0x000cc848b2ec61a4,0x00002b6f09d9ff2f}},
    {{0x000dfdd25cf29291,0x000dda0092de30ae,0x0000a4e132261624,0x0007de7dd4994fc6,0x00001c40532fba17}, {0x00018feb438b5b0b,0x0003e95815fe08be,0x000948087b006e4d,0x0005efbc2a9ef7a4,0x000009e6d587a5d6}},
    {{0x000969e4f9206d0f,0x00075a33642fbb5e,0x0001c4b5d8ec63ca,0x000a4b54ef559a14,0x00009b489e45d4b8}, {0x00079fd87810f9e3,0x00005eec7620bd39,0x000e3eca2d32cf90,0x000386a4932bc4fd,0x000080d2dfd12b4c}},
    {{0x0002bab6b693b018,0x0005396af6ef38e8,0x000153f766a56bc4,0x00059f4479f1c4a8,0x000065854adf0b46}, {0x000ca7e73f59716e,0x0006eb462570ba76,0x0001e66b58a3ff32,0x0007e313f7e7d714,0x000075a290729d59}},
    {{0x00062bf29147d07f,0x000b71338d29fb95,0x000a83b78c68c915,0x0008e5f7bbf7376c,0x00002d08e6ebdc2b}, {0x000022479e069a78,0x000529a2b2914757,0x00012616758d3d5f,0x00000b75f51a9a10,0x00005ca72d9581a1}},
    {{0x00056185d307f683,0x000a74cb99c3929c,0x000b06852fc4967f,0x00067199709504e7,0x000075f08dbc7f90}, {0x0007d8f5aec63809,0x00005c9d1e1a8854,0x000031b69a7b3391,0x000d26bf93901560,0x00004fd890aed914}},
    {{0x000e962e74fa42b4,0x0008b6eef166545e,0x000872fa7032fb4a,0x000897ad192d20e0,0x000094230f24ef1d}, {0x00071573ec958b1f,0x000ed4a294849e47,0x000b5bb10b0cb9ef,0x000c1bd82e65ac22,0x0000021aaa1f3222}},
    {{0x0003cf15c474b96e,0x0009e70fb75491a6,0x00055261629d3ef4,0x000ccabb565167c7,0x0000cc5624a31510}, {0x000841e7e25d97e2,0x000c7e403d770905,0x000be67912255f30,0x000c36beb19eb409,0x000000ba1f7537e3}},
    {{0x00022bdb04b10d27,0x000bf434239c52db,0x0008d4498f41ccfa,0x00035c025e14818a,0x0000e4cd009815c9}, {0x000292bfc4a245f8,0x00097364e9de7d60,0x000cb48c1de328ef,0x0007e4db08fe9d56,0x0000d6112b78e540}},
    {{0x000831ddebf9598e,0x000979bb92d0eac8,0x0000cfca46f5cab4,0x000b6015ad2f7772,0x0000d41fe36ef39c}, {0x0003a2ea9b69dc25,0x00042dff273b08cb,0x000f81461d1ffb14,0x000a4c36404a0c68,0x0000bd4f3b25d7e1}},
    {{0x000b52447a59ca38,0x000412904d355b9b,0x0009d306c9363867,0x00067f6caa01f11d,0x0000041bf277bf17}, {0x0009fef689c4169e,0x000e3dc4bfdf9266,0x0004eceb55ee1f01,0x0002944c74b71d64,0x000046d3fb3b5264}},
    {{0x000d89c6b8902588,0x0004a43fc1846231,0x0001866a88efa1d1,0x000fa61d29d42923,0x00004af39ae87686}, {0x000be51bae53ac07,0x0008423ad27f8d1c,0x0003aa54acb70da7,0x0007b8f235bf292c,0x00000305b9d0943e}},
    {{0x000514fe38c4f7de,0x000b829401fdb149,0x000db76997df5622,0x000f807d9447624a,0x00005ac0b00fbb71}, {0x000727b2d9749d3e,0x0001289dda4509a3,0x000629016714c594,0x000780af9268e465,0x00007f6db4424a1f}},
    {{0x0002aae6462c8c00,0x000054a3be95cf37,0x000ef28c0b873e69,0x000af8ca81887394,0x0000225ad865d446}, {0x000ef44f58dd3666,0x000173b419047734,0x0004dbd8a69723d0,0x000254b9684a7eec,0x00008b1aa366d4f9}},
},
{
/* digit=7 [{1,2,3,..,}]*([2^49]*G)  */
    {{0x0001aeed239f4556,0x00049d4ddf57cac1,0x0001d2a819808334,0x00000b6a5d2670cb,0x00000f2e4aea4ac9}, {0x000c8f8ccc05367c,0x0002818771212a6d,0x00085497ca404a57,0x000d31fe2406ea3f,0x000066d75813b43b}},
    {{0x000510a53ce5c73d,0x000fc461cc13581a,0x000c24ae8baba850,0x000a7dee213f3d39,0x0000f50e637950f1}, {0x000bbff69e5103db,0x000a85cb5f3beadb,0x000a70f73cee5aaa,0x000c947b2cc95a87,0x0000ba0e771ec061}},
    {{0x00040300d97bfe32,0x0006a033e7779a90,0x0006d553f95b3008,0x0007b47c5e9b61ac,0x0000021b54e152ca}, {0x000c553aa7a3a110,0x00046dd1c7ec0c1e,0x000577c34df1edd3,0x000d7165340112a0,0x0000d5fa7bfd90cc}},
    {{0x000f022a7558380e,0x0001ba7b90f5fdee,0x000e0da2bcb36cce,0x0007745bd4959204,0x0000dd2eac35ad01}, {0x0002c8521c0c5af3,0x0003ad91885450a0,0x000fb8b9f94c617a,0x0001771d86ee2b64,0x000058a7459f4852}},
    {{0x00087c696cede771,0x000a6d45b0f224af,0x000936b54c8b1b48,0x0008998378d19198,0x000043233bf94432}, {0x000fa637bed26bac,0x0005c18a17d7bb9a,0x00086ab22583df2c,0x000cd022a04cdac7,0x000073f0dad5030b}},
    {{0x0004aef507316508,0x0005e17245c6d9b5,0x000bfb309240aa80,0x000b0fce93d46ee3,0x0000cb28ae82deb4}, {0x00028ce7431d4cf7,0x000e6de34e2fd644,0x00027a4a239496d1,0x0005695b9f53f16f,0x000026a63f905548}},
    {{0x000eeda91a8f07be,0x00010b8144a4e27f,0x0005df4bc4b7698c,0x000c15c892204fe5,0x0000de3f93a307f0}, {0x000af35ec993e2fe,0x0004c71f0d310b53,0x000194dcb0a3be66,0x00024460840d4b9a,0x0000015279dfb876}},
    {{0x000dc97176f5fc32,0x00084c41f3ea9f74,0x000fcdfe91636818,0x000109e6007a66ed,0x0000d9337c74353b}, {0x0000aa28be36eb52,0x000f0a17aefcc5c9,0x00073205c1bdaa3f,0x000aa1cff6aa02da,0x0000e49689d28f4f}},
    {{0x000568b08146d249,0x00059da996f8b53d,0x000b5c2a3f70a11c,0x0005b73182b847ef,0x0000b7cbc8379d11}, {0x0001c6a0bb8a4a9a,0x000842be45b2e521,0x00032433b189ace9,0x000b9407f99f918b,0x000034002e73cc09}},
    {{0x0002b2c99ae289bb,0x0005a8aa4e3f5fdd,0x00024d4d0bab6201,0x00089e755c5401ca,0x0000536b9ff65767}, {0x000b91bfbcc62323,0x0004d65e1912fdcd,0x0003cb2f76182d10,0x0009c80f7ce8e668,0x0000cec3a67b10da}},
    {{0x000a8bf6d5778d03,0x000fbd801fe4d51f,0x00093d2ccba1f75b,0x000c28520bd7ebc8,0x00004d0d1b357aba}, {0x000f08f86aeb0018,0x000603f6c973af40,0x0004f47cd1006667,0x00016f77b47974d8,0x000047e82a24dcfe}},
    {{0x0005d1ddd12aa937,0x000401ffeda864d3,0x000e540c0684a675,0x000cbc4f9b990931,0x0000df6e60528b00}, {0x0001f5e0ad0b56b8,0x0006c70bafd39118,0x00050a6ae9d54b72,0x0004803e3bbc4682,0x0000b9184d9f5217}},
    {{0x000608dde1c5dff6,0x000b8a3467306f98,0x000e8e6eacb62013,0x000117376a795382,0x00002bc99d4c1ce7}, {0x000805d31cafc6c2,0x000ec33f2e2c8ccc,0x0007d9e547cce509,0x00073b8f1902fa58,0x0000c31805d21dfa}},
    {{0x000140b741887605,0x000490cd29bd1c0f,0x0007f308ee8d7d25,0x000275aecba30f74,0x0000780fa9561b0c}, {0x0007bfafab75c4b5,0x000f2bd8d7c718e3,0x00065faa7126ee22,0x00084992c17bc317,0x0000c7fdce2c0389}},
    {{0x0006e725b1a6606d,0x000e6576abca1b85,0x0003e60b5a32ce43,0x000b5e491da7eb02,0x0000f4529d1fd659}, {0x000f1cd618e6a1c1,0x0003d3b5f111ef6f,0x000aee2dc2902aa9,0x000819dbfeafe73b,0x00003af3de73bc78}},
    {{0x0008ffd479c62248,0x000654fd6beb4d68,0x000ebb327cc04add,0x00075d822732ea65,0x000044a14f2a186a}, {0x0002035bf8fb9958,0x00026d9f7591361a,0x000e0a6a62a3e29f,0x00023597cfb7041b,0x00007ddf6f52755e}},
    {{0x0001437de25e2c58,0x000a749e6e860bd4,0x0004848f10153cd7,0x00021532257cb78b,0x000082b7e982d724}, {0x000a791c09ebadfa,0x0009cc48599d4809,0x0007f5347df19150,0x0003790eb5e46213,0x0000eda7a00a335a}},
    {{0x000cb72c3119f7b8,0x0006335b4e574c18,0x000df0fee556561f,0x000efa728a3e48e9,0x00001de12a3aa369}, {0x0007bd62de5ff0d8,0x0009cb8e1debaebc,0x0000eeafa40c9382,0x00041ab5aef3f42a,0x0000f23bb1d172a9}},
    {{0x000007ee68dddd09,0x00041db7068d3bd9,0x000c45236df97f5e,0x000b27fec3b2979c,0x0000781fbd0bf529}, {0x00048429ebf0462b,0x00018b77dddaa659,0x00040b96a20bdeb6,0x0009b32be3321f34,0x0000677d50046519}},
    {{0x00093f5b430ae985,0x00063b607652d48b,0x0004cb9ee7647460,0x0008bed34ed097f7,0x000006e6a9aa175f}, {0x000dc50978b6e14f,0x0001b2110553d449,0x0005ca3c3412890a,0x0005f156e99a5a79,0x000027e794aaa77a}},
    {{0x000337bb4674f974,0x000faaf40bb50fe2,0x0001da97103f3a93,0x000f86ae5da89eac,0x00000d28934fa09e}, {0x000fe143abd373e0,0x0004d19798f1348e,0x0005faddb07be1f3,0x0000fce18709f123,0x0000a65d7f258bb4}},
    {{0x000ec2ea13bf8a9f,0x000fff94d1c2fc03,0x0004a5e758d72c01,0x000c2538fcb23537,0x0000519f25ad891e}, {0x000031644a896ea4,0x00095a8473f8d465,0x000e93c5c4dacb49,0x000ebe7a4d3ac4e1,0x00006a7515c98397}},
    {{0x00003531ef7c3513,0x000151a1adfcb1a2,0x0000fe90dea9dc2c,0x0003b8148c62d66d,0x0000b432f7beeb90}, {0x0009b4a3a3eb7360,0x000233afcef8ad73,0x000553d8625eca21,0x000dda60321e643d,0x00001b01349d116e}},
    {{0x00018c3569e6b0ee,0x00024b0d2fb5954c,0x000a0ecb65c4006a,0x000a62dc0f497e6e,0x0000b96b836c3a3f}, {0x00010ca5b00f3cf2,0x000d5a4d44403cb8,0x000ca83b4a082049,0x00032849181d8221,0x00007f7edd74f65f}},
    {{0x00010a1af882102e,0x0002f1c8b66b8d50,0x000cb8b5c86b5ba5,0x000aa20f54bd38af,0x00001096c5fa2608}, {0x00026d294ccad71f,0x000702638eb68c00,0x000abeba69f87807,0x0007937a69ba5105,0x00008964bbd724b0}},
    {{0x000ea9ea2bf0fdf7,0x000eb49d812be215,0x0005067fc7c83d3f,0x000764be2c803ded,0x00001fb9b50ab062}, {0x0006b70932d37f40,0x000d09395b17d0e8,0x0003a6022e7f0771,0x0000b27ee57052e5,0x0000c6cf1f16992b}},
    {{0x000add9e8bef59b2,0x000614c0c4be9be8,0x000e8fd1ff296e27,0x00093497783204fe,0x0000741476659093}, {0x000e8eb504b04abb,0x0001bcf379fb506d,0x000b9b91e1361604,0x00058b7cb22333c0,0x00002497bd48c840}},
    {{0x0004e4dfa0cd999d,0x0008b8d7ba3d9c29,0x000f6ce974ea95f3,0x000c95eb8a425f3a,0x0000f716a99f71ea}, {0x000edb51e52dc87b,0x000b25a37471e30f,0x000e4f019949d742,0x0001d40be1fa0a07,0x0000f2656c3c690d}},
    {{0x000f1a6bbf53c9fe,0x00054f2c7694ab45,0x0003232eb20d9b90,0x0006e109a9e361f4,0x0000bc91dee0ee17}, {0x000789bdbed0ccfa,0x0008288b3f1bee5f,0x00028f5d1ef0caa0,0x000ca42aeac3f01c,0x00006007b363bf84}},
    {{0x0006f0a64f93a622,0x000b3a5637862d42,0x000380c6ee69a504,0x000e6fa7057de947,0x0000433d4e4199f5}, {0x00023cf1f314c175,0x0009f1ff15bc3feb,0x0009fc8449252302,0x0000e595c6fae70e,0x00004481bce01d84}},
    {{0x000f51b3f1021673,0x00053d64db91443d,0x0008e54c650a1225,0x000220d157dc4221,0x0000a3341db93f5c}, {0x000f3d7a5bd331cf,0x00098ff4240a45b9,0x0007ceab2fcf47cf,0x00096f888d766253,0x0000ef3c60ed0577}},
    {{0x00097e010ff08ddf,0x000968240b00767f,0x0008602279b7acee,0x00099242875c872d,0x000019a7093413c4}, {0x00062417e2d75285,0x0005d70899ba18c1,0x00020ca0eb040adf,0x000bc187c981b514,0x00008b8cf4318d4f}},
    {{0x00080a709a32342a,0x0002965305d1f38d,0x000bf1feb4d161e5,0x0008904dcd385285,0x00009237da3aa1a2}, {0x000aa5a46cea858c,0x0009ce6d6f2234ac,0x000c28dcf76092ac,0x000e838a0ac0bd91,0x000030791072687a}},
    {{0x000accda4225c342,0x00029636e0fff56b,0x00021ccb1fb397b9,0x000dc741822beffb,0x0000d48cbd35cefc}, {0x0006d5bfe9ba3d6a,0x000225360b6d5563,0x000741b6001dfac4,0x0009b486b1b23b18,0x0000ef14d08ff4e9}},
    {{0x000f90e78c1f3bb0,0x0009b6f85de2028b,0x00037d91cf6b7783,0x000a3f03a27b6beb,0x000069ac8d736c15}, {0x0000c62e806bd30b,0x000056746a7ab9f6,0x0007ab1b6c245999,0x0000fe72037ecf0c,0x00008ca60c732f21}},
    {{0x000abe30741481cf,0x00040b18ce478cd1,0x000e7f8c34c982fe,0x000f0fe79cffb728,0x000074960aec39c4}, {0x00066aa9050b893e,0x0000122edd8925c8,0x00092c673fe40d52,0x0004b39f8c9033a8,0x0000ce1891820586}},
    {{0x00005206bf1ee33b,0x0000e4979d7a9a80,0x0009b650b8c12ac8,0x00054e4da9f88d79,0x00008aec7e264a80}, {0x000ae68f7b28d79c,0x000387cef16ca493,0x00089b6b0a4dc3e4,0x0003e40509431dcd,0x0000bbe744fec78a}},
    {{0x0005978ad410ef01,0x00014cc3515d61f0,0x000a46f70afcb4b4,0x00041970a01aa3fe,0x0000884ec45da55a}, {0x00063b35165dbca5,0x000cbc71ac33d0cd,0x000e4c38ef210420,0x000cf3a0f23b9fb7,0x00008858d7174d5f}},
    {{0x0000478139115bed,0x00093f433881438c,0x000447a7d8813dc2,0x0001188cb8732df2,0x0000f920508aa0d1}, {0x000bdd9b8248baca,0x00051a0fda74f21a,0x0004f3bd406ce881,0x000c164428836dd4,0x00000a2424cb008e}},
    {{0x00089b69fbbbca39,0x000b1669463edd19,0x000ccb304c3b438d,0x000a7733db961ef9,0x00006f2d432afb6d}, {0x000acc1b78bef59c,0x0000abcdba630ae8,0x000bcad61d6beb51,0x000b213bab1c81a0,0x0000f6c677215aa6}},
    {{0x000314509f77691d,0x000070083e4fdae3,0x000d7f1f5feb96d3,0x000a7d9f0c18c1cf,0x00001b7ddfe0651f}, {0x000db98fcc9de7a6,0x00069a529dcdc450,0x00097718843d4122,0x000d3e0ad913fe75,0x000005594f0670c8}},
    {{0x000e4506cab3068a,0x000d1d2494770a89,0x00030ec9b9955748,0x000846ab8cbf8946,0x00007c89daf9778a}, {0x000acec4f4606444,0x00078c364d73231b,0x000fe41c31286866,0x0005d3f1ce47c3d8,0x0000e365480c68c0}},
    {{0x0003e4160b45a121,0x0003baef5d6683e7,0x0004dd85a1e42102,0x00071f5e34c234f5,0x000091f9fbced850}, {0x0007767771328099,0x000d49be9c6b664d,0x000a38f38d829f06,0x000ec330eedef076,0x000026c48800340e}},
    {{0x000736dd0e1d6e43,0x0005022facfe3f4c,0x000191340b7da1b5,0x000d914f559d6ff2,0x00004e994ce30fd5}, {0x0002295702306bc8,0x00057ed0842bb003,0x0002112cacc1577d,0x000b4491fdafe49f,0x0000ad39b895860d}},
    {{0x0007eec37bfa3de4,0x000b16863791d4ec,0x00079f652f765dc5,0x000986d0c1bbc9c3,0x00002abf602df07d}, {0x0001e932edcf3171,0x000edb53f5fb229b,0x0009b60fc290f0be,0x00091a4acbc35e94,0x0000ba30ad68659e}},
    {{0x000dd8d9660b26f8,0x000350ca1223a663,0x00032ab3d4eba231,0x0002804991c779fe,0x000099f830e34a06}, {0x0000e71d3111ffed,0x000005ce14589dcb,0x000f365f377370cd,0x000623a24a8ccbf5,0x0000059fbf358ace}},
    {{0x0003a4098bbc3934,0x00004dcd090a5572,0x0005a7255ffc94fe,0x000185dfe7e5e6b6,0x0000bee85029ef3f}, {0x0002743db2177911,0x000d5e6bd9ce4510,0x000caa6d30f32aac,0x000f4f7b671a2e7f,0x00004304bbc2b68c}},
    {{0x000a04d9e64e4d35,0x0002ec1e1c9b0135,0x0000551455e12027,0x0002be716a3c508b,0x000085f4f1c5deaa}, {0x000fae6e86f4a15b,0x000864a7631005d0,0x000975559b3bb56e,0x000c45a95a184010,0x000086bd840e2d14}},
    {{0x0000c3fb351ec55d,0x000a716ba8612e75,0x000373c466979ea0,0x00032b4b9a776a63,0x00005a8b35671cd3}, {0x0002093dd7493ce9,0x00006ec41ba2b630,0x00026128f18e92b4,0x0006d1dd3049143e,0x00008405ec34615a}},
    {{0x0005e208a0356f29,0x000e456a9eac7617,0x0001f6a6f856d9b0,0x0008e436387a6c14,0x0000127cd283e4d8}, {0x00000f6a32221562,0x00012f58a6e1e3b9,0x000372ba690134c2,0x0000101938ae6152,0x0000a86d5af405d0}},
    {{0x000699670a64b1ab,0x0001fbf935745441,0x0002aba2b5b797e6,0x0007c9bbf9463769,0x0000dba14e270cb8}, {0x00013412230852bc,0x00022cfc37cc9c35,0x0006bb6af3ec8fc8,0x000ff9c5283e7b80,0x0000a3777b633ffa}},
    {{0x0004f15ce0554be8,0x000ecfa3ddcbe763,0x00055667be6039ae,0x0001a5485efcc93e,0x0000e042ceb13077}, {0x000e81d073599e34,0x000d6585f158bd8f,0x000f7f92cec7e3c7,0x000d61a31bb59a5b,0x000045f686d482c7}},
    {{0x0004eda272cf63fa,0x000636f1a9b8a218,0x000e1b6bb618ea24,0x000da926f4254f89,0x0000afeb6d402035}, {0x000c73357c46ecb5,0x000afe899f44ab86,0x0006183a62887e7c,0x0002c32e74795194,0x00001a51e3704cb7}},
    {{0x00044bb9b131bcf7,0x0006417f905f29da,0x000271aea17d6518,0x000225822f44b473,0x0000442a5c8529e6}, {0x00050fa2d6e447c8,0x0000dfcafbd2ec61,0x000f4ccd550401ca,0x0006a0f1350b7a4f,0x00001ec4502e2e21}},
    {{0x000bd15bf9662113,0x000335bcb1799bcd,0x00031ca94fd47034,0x000e1949d595cf1e,0x00001a8e934c2d2e}, {0x00034f38faa8ec78,0x000cbe16f46d9dc4,0x000bae7880239684,0x000b553e8a39b8ef,0x0000f6b6e14a3ec7}},
    {{0x000b937dc23032aa,0x0003d9c256e1f314,0x0009f15c9e65fc03,0x00090371034ea18b,0x00003c9a3c47dcaf}, {0x000484226b0c9336,0x0005daf367bd47e5,0x000896a1e101650b,0x00011d3fe8f106a5,0x000030553fa62618}},
    {{0x000620f5d69edeec,0x000d7a4eec8de791,0x000287a787907f50,0x0005ea68c4827aaa,0x00001a26fe08385c}, {0x0003a8e0e67d376e,0x000c9cb8e62ecdd8,0x0006423b3147defe,0x000bab0d5392e6ea,0x000093a79e3c20b0}},
    {{0x000e6ca8c201225a,0x000d361ddc9c9290,0x000842db93584608,0x000de2a6a6a74023,0x000052a66d55df1d}, {0x000ae8c9463e80db,0x000b580b54c73462,0x000d39a08482e062,0x000d4f4e9168d66b,0x0000432fa82c4408}},
    {{0x000cd6a07c166baa,0x000d0aab204c73a5,0x000f172b51bb0308,0x0000f224f298465e,0x0000bcb5fbbe0394}, {0x0003887f31da1be4,0x000fab42c7ea084b,0x000288810250c3d3,0x000243da8e6bf318,0x00006e11ea969a39}},
    {{0x00042beab44de79b,0x000d1bdf4e1ef56f,0x00092d95c84dc218,0x000ac84ec350fbab,0x000078c07677a9e8}, {0x0004fbd04103d16e,0x0008505240255fd8,0x000f4c2e83bf1669,0x0000f248fbf6016d,0x00003b3a59853adf}},
    {{0x0004d0bc9d68c082,0x00028f23db2991b1,0x0003cc0616167f9d,0x000e770931c7b4b1,0x0000da5ad5d2e0b8}, {0x000d6695dfec5d44,0x000981be910db292,0x000c7ac75239d091,0x000574e433511309,0x000082d8c29306e3}},
    {{0x0002be7195675921,0x000957bf6119ef73,0x000d96cb0c4d5c87,0x0006f8fa6a706d42,0x000021e1cb73d95a}, {0x00093b14fe798a38,0x000ad3f85e91623b,0x00033662ce9ac003,0x000caedbca9b36c8,0x000092ff41dd7e0c}},
    {{0x00076b51b75fec0d,0x000340db61af3e02,0x000abd899caf72bb,0x000472cd7bd7ae60,0x00007641cac436d9}, {0x000f1a178cf6f1cc,0x000000d23b7cffb0,0x000f77b796e5b6e4,0x000f33328af949d5,0x000010f779508865}},
    {{0x000eb802f32faab8,0x000060554f3b532e,0x0005ecce4b511538,0x000343924e7bc29d,0x0000c15966b6c62f}, {0x000f12a31d85149e,0x000702536a1b1333,0x0006deae7e597135,0x000a1cb884c1d3a3,0x00008b957c6d3bc7}},
},
{
/* digit=8 [{1,2,3,..,}]*([2^56]*G)  */
    {{0x000a0db802ad8e2a,0x000198c71fc20913,0x0001af4b76762aa1,0x000d0991a59e2221,0x0000724ce9039cad}, {0x000bf205e5876d57,0x000c736f68df81c5,0x000ab6ba1fb2636b,0x000ffe34868e7098,0x0000261df12d1037}},
    {{0x0003fb0efa0b1ffd,0x000a3fc568975624,0x000bdb4591f15f6b,0x000439654edf2cac,0x000003491ab55faf}, {0x000f3c88c630e16f,0x000e7a922cea29a0,0x00036b058547f279,0x00065d2986844536,0x0000159df225491f}},
    {{0x00016886aba2e444,0x0002ff5dc5081177,0x000694e142d2637f,0x000aae0245602bd1,0x000056094e9d2d91}, {0x000aac623d3970d5,0x000712ba9937c039,0x0003188e393e6d1a,0x000724cb6f2c4b0b,0x000051c7142d857d}},
    {{0x000a6c4126387d4f,0x0000d207fd54b018,0x0002d2c2fa82305e,0x0005af7f76e4d82a,0x00007991440733c6}, {0x0008b1ad2efa1bdb,0x000aa0154ec58403,0x000b501e885ff98a,0x000882de171aa384,0x00007914f6044142}},
    {{0x000ab01c6935b4f9,0x00003b6de76d230d,0x0004d5a6213a18df,0x0007963145617526,0x0000823e1682c1e6}, {0x0005e79ac9b872f3,0x0003ce7021be0c18,0x000c686947c500e0,0x0000a6319f616513,0x000045678a89295e}},
    {{0x0000c88440eaa722,0x000e347df565ba08,0x0000930155047bb6,0x0009d6475a78682d,0x0000591de4ffe082}, {0x000f7732b9087359,0x0001861be64be6ff,0x0005a48107286612,0x000bbfcd5daff943,0x0000410a05140a8b}},
    {{0x0003711d4a4e4fe6,0x0003fe30c63f29e9,0x000a2de989dabddd,0x000323866f1580ec,0x0000b9de281a175a}, {0x00007a398f7e9455,0x000debaed06f5308,0x0001392b17b31e3a,0x000de3ce5bf10e00,0x0000f2a8f37e8d28}},
    {{0x000eef460cea0d86,0x00080c089ea3e5c6,0x000d79ed4ba91ad4,0x000b168d4eb1f87a,0x00004c8dd11d9a52}, {0x0007631e210a2732,0x000522f1cfd893f3,0x000c313c40f24058,0x000538b4a53f3f1b,0x0000805ea5ac03cd}},
    {{0x000f2b4d9647871e,0x000698c6a70f2bf6,0x0000618fa5bbc040,0x000f35bdaacafdb1,0x00004d56a93f6a15}, {0x0002747db37534d4,0x000940549a7cacd3,0x0006eb9286c071e0,0x00086eb8426639ff,0x0000fb0a02399634}},
    {{0x000263cc8597555e,0x0000bcd376a4bf19,0x00078d8efc8cd230,0x000ecce815e792d7,0x0000672dbeb03db9}, {0x000ca483874e7dcc,0x00062391ae793e10,0x000b5a3cd1e05af9,0x00033f3361c5cc5e,0x00001ee94edad6df}},
    {{0x000e3a27b278aaf5,0x000acb57977526c7,0x0006911103ffb78e,0x000ed702ab4ad712,0x000051d4dd701893}, {0x00006061e1dd4f36,0x00024dbe375be15b,0x0000d19abf430996,0x00010fcc798197c9,0x0000dd790c374a6f}},
    {{0x000330e15cde34f8,0x000d285ca782df9c,0x00013e0f4ad9ca71,0x000b872d7e70e9f4,0x00009c965ed8166e}, {0x0006bfdf82982e7b,0x00029a67518e8d8e,0x000332d8a97d85f5,0x00001948637867f7,0x00005ff8016f7f28}},
    {{0x0004eddddb576a2e,0x000f99c20d415c51,0x00088bdcb245ef5e,0x000767739e179128,0x00007e8feed3b2d1}, {0x00060bf9c8d8bd74,0x0004fe343ddabcce,0x000534d9ae42b1a0,0x000cb78d550b1cb4,0x000062a4b409550d}},
    {{0x000c9aa9f5ec19fa,0x00036bab280e495f,0x000ec8135bd5fe5a,0x000257848b5c6e13,0x0000761ea009ba1c}, {0x000dd3c7a0d41127,0x000e4675e99a1705,0x00055926d841432c,0x000ebb9724b23770,0x000008204e2070fe}},
    {{0x0004bd37f61b0433,0x0007488b1baf6c6a,0x0001ff33dd611c9d,0x0003daff36d77f21,0x000012e12b486b0e}, {0x000d3d308ad3a01e,0x000cffbd52d205a0,0x000a3c9d1ddc263a,0x0008c49be3889951,0x0000c3cbb88dc5e4}},
    {{0x0008494d5ac38a60,0x000d1abd383b64d1,0x0008d5867de2630a,0x000e7c899c27a88d,0x0000cc4dc229cdf4}, {0x000e69248c51c51f,0x0001de98813939c0,0x000c9fc3540049af,0x0005acb02b92dd45,0x000015dbe915bf51}},
    {{0x00030100f6fd2798,0x000b5cc6b3f2de4c,0x0002cc9a1693c61a,0x0009d7cd8f059e65,0x00002cf62e1b8fd2}, {0x000b441e397cce3e,0x0004b8ee5b2a90b6,0x0001f1bf731ac8fe,0x00044622a0067d97,0x00007c2cb7412bf5}},
    {{0x0005ded4da08c914,0x000c57bc50d57705,0x000c17c0e5e74346,0x000674093e88cce1,0x00009d958b500cee}, {0x00011fd4c2ef91c2,0x0003d68c5fc39edf,0x000a3b166dbadb86,0x000c83e5a523a4dd,0x0000e1e7d5670101}},
    {{0x000e3abd49188ad4,0x00088dffda2a80be,0x000f3b05945c192d,0x0000c7b93d42d6a9,0x000002b90dd3fd2b}, {0x000346bd29b792b4,0x000c03609852e2b4,0x0009c492438fc4c5,0x000f90a6d5d4b916,0x0000d555a212879b}},
    {{0x000fdb47bd87a424,0x0008b5138112db69,0x0008d1d2f115354e,0x0005bc50db48e3da,0x0000aac2eb70e66f}, {0x00051bc6aba63664,0x000e262acc9ce72b,0x000438ba3085117e,0x000822be56bb230f,0x00006d5cca79124d}},
    {{0x00053f5fe3dc39cc,0x000b414d5f67bdc8,0x00046b348c10dd5e,0x000770a76e02dbd6,0x000009c3240fcb02}, {0x0008fb52645c9dfe,0x000c18c396fe8d53,0x00092dad0baa2238,0x00018629d37c8b0c,0x0000c60386360546}},
    {{0x0004a8de81e01bee,0x0007f8321592e20c,0x0006931b55bb7970,0x00076794a7e10024,0x00005ebf25e72a07}, {0x000483a0f5a9edca,0x0002bb646d9e6312,0x000e37073230f82d,0x0002517b5dddff68,0x000029ce765a98e3}},
    {{0x0000ae6e544c6ea6,0x000b57855552f6d8,0x000b8a5e25ebab2d,0x0003d955707f9c00,0x00007b357c483d08}, {0x0005361eff79a535,0x000156e0268e623e,0x000996462124b446,0x000a24e231e90f3c,0x0000bd6b1f150e05}},
    {{0x00040b77de486a19,0x000cf6c03fc07914,0x00036c6bfd63554f,0x000429473dad2c7a,0x0000929e308049f7}, {0x00070a9c2bbc1283,0x000621dd51016272,0x000eed7cf3413478,0x00025a8e63501e29,0x00003512397dbb12}},
    {{0x0006891e7084f0f2,0x000fd6a38da9e393,0x000256ae79ed2f3d,0x000d874a6b4d7cd2,0x00007695b9534b5e}, {0x0006e9d024eb60ec,0x000c40f326d7afea,0x000852c01e0e4684,0x00071b37bae69e1e,0x0000a388523fa1cc}},
    {{0x0007b4d81320b2e9,0x00042b4678e1317e,0x00031c45fcb6ea5c,0x000c542ee5785311,0x00009b995cc107ba}, {0x000eaebcec18878a,0x000a9849b1c2e018,0x000ad5438bae1123,0x0007805e180c0e02,0x00002ce8e4160ee9}},
    {{0x0003c9f0bf831b63,0x000e9bbb471a25f2,0x000ed4ce91f1e7dd,0x0008472d76956795,0x00005e67d84a19be}, {0x000eab76f5a65259,0x00060239051663e7,0x000a9f4ea42d2626,0x000b8a344f8f5d2c,0x0000bb99d60d6793}},
    {{0x0008053bb8d37d24,0x0000355c03827c18,0x000a8454066ad23b,0x000f6d341b9405ea,0x00009fdcc57978a0}, {0x0004e26d8aafb17b,0x000c4ec79ef02ddf,0x00008c46fe8c88b8,0x00016777aec8ea64,0x00005ea6fe832ac5}},
    {{0x0003b361878c3d3d,0x0007921447678781,0x0009b469595fe31b,0x00055924b0bcc3b2,0x00003e4b82a2e59e}, {0x0007f61727308214,0x000569f22b76dbd2,0x000233c6e2a1b59a,0x000e7aa7cea941b6,0x0000a51665729aa9}},
    {{0x000cc4b553fbe60d,0x000b1cc8f5672bc8,0x0004471a809c494b,0x000e7ff3633cdd40,0x000094b3115ecf90}, {0x000e7e954727f93d,0x000b292aa6dd5242,0x000798c3d8b2f132,0x0009e8fae560b438,0x00009604a24394ff}},
    {{0x00074df40c36a876,0x0008139bcd46117f,0x000f04c1dd9ab144,0x0007151706edf335,0x0000ca29fddf0c9f}, {0x00077943d7b52cc2,0x0005759e0b8ef052,0x000c4fbae923b66a,0x000b4312d8827f47,0x0000b2cac97b4362}},
    {{0x000ba3b3d8c333e3,0x00084249ddfc6f82,0x000412b21bbeeda4,0x0003f2feb78ebe73,0x00000f4a98190b90}, {0x0002b13fcaefd68e,0x000db2497727d8a1,0x00050310717e05a5,0x0009b4f4db117595,0x00002bad33ee056c}},
    {{0x000aa899669a94d0,0x0001eab7a00c5660,0x000041a733d2c8c1,0x0009450c1e253b75,0x000017bf47981a80}, {0x000f809d4fd21a7d,0x000be6533241ae79,0x000d829dd7bdcd33,0x000be78a25e57321,0x0000c09f94cc338d}},
    {{0x000f8d0a468848c5,0x00047b41a21d9ca1,0x000bc0e5b17c3f9a,0x00029374333d5705,0x000030912604ccc2}, {0x00008d0d6ceeefc1,0x0002a8c72cc8005f,0x000e6cd79d355262,0x00085d0e66445e88,0x0000b6ec8a4e04c2}},
    {{0x000dbc54066477ec,0x0000a8c5bea950c1,0x000684204e2e4f7e,0x00086fee8955629f,0x00009b1f71580e9d}, {0x00087fc2c0029688,0x00027479146bdc72,0x000667694cbc6782,0x000b7b2f7af3baef,0x0000f7f90385b159}},
    {{0x000bb32253f3a82d,0x000b3a639c9cb63d,0x000360890138bc41,0x00057b610a116196,0x0000ab4e04b9e339}, {0x000ae727cbd17ddf,0x000a2b1a48784582,0x0004ee4100db6d3b,0x0008cb38cff9eb42,0x000029b0c8dd23a8}},
    {{0x0005ed5e3f62c22d,0x00032b06f482bc86,0x000b2a80097544a1,0x000c7f76ed319dc3,0x000088eb3caa8336}, {0x000408416a3468e2,0x000cfcaa5c73b399,0x0002ccb5869caecf,0x000834622f2f7c10,0x00003ebea2e23bae}},
    {{0x000f634159c3f145,0x0001a314fd75ceb9,0x0009e502cefadb01,0x00082007b8010960,0x00008a2bf184a15c}, {0x000886d3ec835a82,0x00004bf7840e310a,0x000d8eaf18c9f355,0x000c84d39c35be1c,0x00003fa5437b08b0}},
    {{0x000e7c76ba48af4d,0x000a39c3a01a8fd9,0x000c62e23ddb4853,0x000913a6ec0c12f0,0x0000b9479a5d516f}, {0x000b51d7e32dbba9,0x0001abd8aa7d25f0,0x000afffda4d3a475,0x000270e67e9ae172,0x0000c1fa7bf9b1fb}},
    {{0x000931c17cdd8a73,0x000e0448a021a8ba,0x000920e03df7fecf,0x0001bcbd374eea3f,0x0000c62edf80f11e}, {0x0001ce6736088569,0x0003c0fe97f45d51,0x000ddb622fb70fe3,0x00042189193abf63,0x0000bace900bcb83}},
    {{0x000f81a878a56754,0x0004f75c479fee4a,0x0000afb5829b49ce,0x0005854186889ece,0x000032530cbd047d}, {0x000be7c429c1cf6a,0x000cc541d81ed275,0x000d999296d29cc7,0x00011ced6e04b532,0x00007aeadda8e71a}},
    {{0x0001699a94bbbc79,0x0000b3ed33d3b98c,0x00012db7668dbab9,0x0004d7e3a0ec5fbf,0x00002de225c570ce}, {0x0005c39338ab6850,0x000f612c245ee97d,0x0000222a78aa03b1,0x0001e27e4e3af28d,0x0000e34817cbf8ba}},
    {{0x0006fd6e8a4a3f4a,0x00070c75489636df,0x0002579d316b0e9f,0x000fe12b5fb3bc1f,0x0000fe57d4f72a95}, {0x0009a194ceff9331,0x000354f75a487036,0x0004549b046aab24,0x00032749a77772fd,0x0000f44e63c940f8}},
    {{0x000f73f8f359b8e8,0x0003626aa63db40c,0x0000ebb81b7bdea9,0x000ce970626f7e55,0x0000c692abaa0eb5}, {0x0009cffcdb9d6804,0x000f4c9bb068b774,0x0004adbce122a50e,0x000b00be247e3384,0x00009320ea728f86}},
    {{0x000300cb47746a83,0x000d765cce2bcb1c,0x000afbb2ba8b05a6,0x000c89050d56aac6,0x0000f10deb3e6496}, {0x000f6adeb5e3c3ca,0x00005b59f7d73f44,0x00034333fd8fef09,0x000cccc06179b892,0x0000d42424834343}},
    {{0x000cd7b1178680b4,0x00067205cb9300e2,0x00022f86af9a63f5,0x000dce7ea9cb6c53,0x00004736f3842b23}, {0x00053bf6f5d17905,0x0001af4b062f5ef8,0x000c8e412a224d5f,0x00097adffffe0026,0x00003f676531b201}},
    {{0x00046ade65aa0b35,0x000ab957bcc5a7c6,0x00021fd3aa044a8d,0x0002d742145aae3e,0x0000d79efcd7c6e3}, {0x0006479ffb6a9280,0x000fcff2758345e5,0x000cd168eaebbf6e,0x0001d311cb1cf204,0x0000d5fd7233e385}},
    {{0x00021f9564df392e,0x0000cdfbb4120dea,0x000697ef6773fc9e,0x000b33b64b26b1f1,0x00002ed2ba1b7d83}, {0x00069e6145eab824,0x0008a8dbc68bf47f,0x0005827d6b1acd9f,0x0009476929807897,0x0000cb8cab70e2ce}},
    {{0x000ed39da3052f0f,0x000d683870bcdc6f,0x000c41480005e7ed,0x000791569848974f,0x0000beac60351f97}, {0x00001799275b950a,0x000212527d574202,0x000173d93889bee7,0x000bea8685758a76,0x0000cfa1096d830e}},
    {{0x0006dbc7d5bcd224,0x00049799a90fe43e,0x000bf8e13f9e8a5d,0x000a40e9cc8d918c,0x0000f177852be5ed}, {0x000b278ab0123dd5,0x00010994e23c910c,0x00023635812c11f7,0x0002ee5d1ffddf6d,0x00000572865c55b3}},
    {{0x0007eec59607df89,0x000f6fc041bea2df,0x00025c8a86ba453c,0x0000ffdb8cd4fc82,0x000014b0c0ae3f77}, {0x000cb43d27069607,0x0001c526ab3aa02c,0x000c9d06bf4b1f88,0x0001c5df41cbbb56,0x00004c4747afd9b5}},
    {{0x000a373fd41c7efb,0x00008eee150edc52,0x00072492cd833b3f,0x000e6300f3ccb31b,0x0000df8c0cc0bc7d}, {0x000a3eb385d47b1a,0x0009bb3430739063,0x0004ff4afb3a8a1d,0x000739f02eb25348,0x0000cc1efa44f33c}},
    {{0x0000f4a61e1db8d0,0x000240c3ad0a8e2b,0x00003e752f6d15cf,0x000f1a4cb501fcec,0x0000253b9aa06d6b}, {0x00012854f610f356,0x000b9e867e0b0f0d,0x000cb4fae8d8d727,0x000e686ca560b0d7,0x0000fb6839787c32}},
    {{0x0008c30ba2a7b38c,0x0002c05a1e186e3f,0x000aa6ac9caa3aff,0x0002b57828d97c22,0x0000aa7fc12f8eff}, {0x000efe970785dc5d,0x0009dc8818f3ac30,0x0009c0b682ad0746,0x0008e4675851d1cb,0x00008a8897cf8c31}},
    {{0x0001252f65cf5ee5,0x00088f29ac5a604d,0x000ac9bbce3667bf,0x0006a0c6475eb601,0x00004bbc154f2060}, {0x0008776fe257543c,0x000a239d34de6a98,0x0009a87768ce62b2,0x000fab0fe16c0d6f,0x0000926673d22d5d}},
    {{0x000b2b3ad94a7b97,0x0008fed58b128f18,0x0008946706b30053,0x000479259ca13ce2,0x00006d23f69d840e}, {0x00025e4177e33430,0x0001bec8e41e4120,0x000d93e910ab22df,0x0009ade579d0c842,0x0000e273816addac}},
    {{0x00002ccc6fe7dff9,0x0009b502353dbed7,0x000ac7e295c845f3,0x000f70849f73ac4d,0x0000cd4776c48c6e}, {0x000669075bd0861c,0x000bd7cfe206c5c1,0x000ed7294a8a2fda,0x000631c9abfc3e62,0x0000ac1761b8c654}},
    {{0x00056155c59e3804,0x000fc6e8eea72563,0x000b382c5c09c5a2,0x0005601fb0724e41,0x0000a8641a0b7d43}, {0x0006e955b7a680f5,0x0009f5c576494068,0x0003be93435b2e37,0x00051a6a679fa13c,0x0000a5238a3c9d8f}},
    {{0x000957c5dad3b707,0x0006a860fe3b104b,0x0003bcab2013b711,0x000909be66aeae78,0x000014befe48deb9}, {0x0009073742c9ed9e,0x000a54923d3e39f5,0x000340d1ddd320c1,0x000b66ed03354572,0x0000f7d8e0dc288b}},
    {{0x000a09a0d72bae2a,0x000846530c949b89,0x000fc27421739535,0x000c46467b80b4a2,0x000049fd2b8b03fa}, {0x00047f3041803387,0x000a220b9b0be858,0x00019bcc545b9dc6,0x000a8ba2614c8a67,0x0000f019df8137ad}},
    {{0x00091858054e09c5,0x000179f271fdc8ca,0x000544ccb6eaaa79,0x000a8115523b3f72,0x00000e9b891c122a}, {0x000c7af09e9c2711,0x000a1a2a3a281d16,0x000a7927fc4edb0f,0x000f2cb10b6c326f,0x0000487e43472560}},
    {{0x000c0c37e2cff914,0x0006f180c765eabb,0x0003ddc4575d45d5,0x0008a0dd271d5c6a,0x00006393dbeb0d29}, {0x0008b4d194b3cc34,0x00073b2327d37a43,0x00016dc625fb4e30,0x000d1937f15f8154,0x0000fbc9f81b7d07}},
    {{0x000db8bec3a5d60d,0x000e4aa12f4eec94,0x00084204e9449ca2,0x00024cefe7cfc0d6,0x00000c8fbdf94de6}, {0x000813864f28dbf2,0x0004ab156ec6f5ad,0x0006721654073837,0x000938a6d1b62c4a,0x000068b432494983}},
    {{0x0007e91a84283e66,0x000bd6aeeb6f7400,0x0008a39d7929a015,0x0005543ca7019543,0x00009dac0d6ff2a3}, {0x00049431bd9902dd,0x0008243c9a6f36ef,0x000314d8d81ff65b,0x000423dd900e14c6,0x00000a4a34591300}},
},
{
/* digit=9 [{1,2,3,..,}]*([2^63]*G)  */
    {{0x000383af5664e7e2,0x000b6de6b7968a12,0x0009f4c5338a7675,0x000c15b898bae977,0x0000425a4bff82b8}, {0x00042e3b2dda3220,0x000b8c25241d990c,0x000f6aea17aabb56,0x0005ec6348df82e9,0x00006ce9658aa8d7}},
    {{0x00002787f882d1b1,0x000092838067fd23,0x000e893587ab9dde,0x00080ecb05c101f9,0x0000374fdfb598bc}, {0x000b09697248eb9b,0x0007e7ad923f4c84,0x000109184ce9bdb8,0x00013b128cf5cebe,0x0000ec24ef3b3889}},
    {{0x000944e7099b0bd8,0x000b1d537ca60adf,0x0008486e846852bf,0x00068d48e47fc8c7,0x00000d6c7de2929b}, {0x000987a8e27182cf,0x00074222fc3b99be,0x0007d0d1d309bede,0x00052f53cb0aad2d,0x0000f65f3dd24bca}},
    {{0x00020afe823378bd,0x000482dc3af323ad,0x000605e6877ccdc1,0x000ae077795ffeb9,0x0000845b442d429d}, {0x000ff1016818e3da,0x00066b078681d060,0x00031508ce71189e,0x000e406443b1e66f,0x0000623d9847ce12}},
    {{0x000cd6f7fd3f5519,0x00031e2aad87484a,0x00089654d2767308,0x0009ab132e31f05e,0x00006d3deb114a4e}, {0x000838481a653456,0x00035a31e914dead,0x000e292969158f5a,0x00028101fed010c0,0x000004a96f918ab8}},
    {{0x000bdfb703ba17af,0x0002cc4c9c4a5470,0x000b10c4a0a49397,0x0009166a2be76243,0x00000e3312fbbc81}, {0x000e0d4441ca1098,0x0007c4cf80735a8e,0x000250bc8597d46c,0x000ae9d302662bb7,0x00000b98758a9150}},
    {{0x00029cb244f2a00b,0x00002a5ca85559c2,0x0003d6204ed00e65,0x0003736e24ccaea9,0x00004d64bcfaa3e4}, {0x000b99a1975140f1,0x00011452dcfbdbb7,0x0003320cd47e6913,0x0008d1132c93a100,0x0000c845f62ed4f9}},
    {{0x0007c03d7c90a692,0x000ff6139f403262,0x000a916341661a22,0x000a50f3c701c63f,0x0000fc4a23f87ab0}, {0x000307b826279712,0x00040ecc37944070,0x000d90e024f1cfb4,0x000986d684936aed,0x00008b59b0818a0a}},
    {{0x0003cc56e8a58cfb,0x000ef645720b7ad2,0x0002b007e30ba2a1,0x000aa9db14cb4a09,0x0000d1f68b371a1c}, {0x000e1ce22bb53b31,0x000e06d532c443f4,0x000a47f15e80c1ce,0x0009bcc885a253d1,0x000061f7667f031a}},
    {{0x0001ec094d82f598,0x000e76868c8fc9f8,0x0006eb6e2aa85998,0x000f863c0b776229,0x00009ebfbdd5d6cf}, {0x000c395d97adaf8f,0x0009b131054a3d02,0x000c908ef314a2c3,0x000dc1eabe4e52a9,0x0000074223caa8fa}},
    {{0x000960a997f80b8f,0x0002574eeafbe347,0x00063a35458a6961,0x000959c7e7364dc5,0x0000b4cf05fd40e6}, {0x00049a6133af3f0b,0x000e62fe5ab6cc23,0x000fab20cf050c2f,0x000bba8ca2cf4997,0x0000e6736055bfbc}},
    {{0x000ef812191ed798,0x000315e7a6df324a,0x0005ddb2427d462b,0x000068f036fe19e2,0x00006eb983703d74}, {0x0008114f4f93c566,0x000e92bd193d9efe,0x000ee2b5a701a0ba,0x00003dff40a1ad85,0x000032ba327506a3}},
    {{0x000e85754a60d6f8,0x00078cd09cea9b87,0x000d99e0a120c995,0x0002e2c46af84652,0x0000cdebf2e2b109}, {0x00059f3155bc92d0,0x0008b8beca561249,0x000b156131d692d6,0x000046cab8309442,0x0000e1db93bb8bc3}},
    {{0x00091e5ece80aac8,0x0004c050f1825938,0x0006020f5726a25c,0x000a35ec48344664,0x00007fd9893709dd}, {0x000c9bc10425f548,0x000d2a56bcbf5675,0x000da5191679c8a3,0x000303a7e6e78063,0x0000f14860aa1e8d}},
    {{0x000bc50407ea0a28,0x00025007431b93e1,0x00055d0ffd5cf6dd,0x000aa71a55e8c0ac,0x0000f7f913113bea}, {0x000075d17988cb54,0x000b0f10950926bc,0x000b82f37b6b32bf,0x000e90e2937113ba,0x000081507f1a3652}},
    {{0x0001af7dc8c1da8f,0x0006951c6c9cc65d,0x00013a9509e4508a,0x0005bfe1ccb78920,0x00009fd6a67c65bc}, {0x0007a0698fe8bfa1,0x0005330e47adbc82,0x0008c7bae1477953,0x000e2a4028e9aefe,0x0000e977aa9f875a}},
    {{0x0003cf64d646bbcd,0x0000731b0f3ca569,0x000d322aebf578d1,0x0003eed7bffd65bc,0x000052a965205742}, {0x000bf947dfca9551,0x00086f7f3c853793,0x0007560c93ea9354,0x000c6925cdcceabd,0x00006d6f1ca191c5}},
    {{0x0007f133182d35c5,0x0000458e49b6d3bf,0x000ddcb73784e7a6,0x000a6aac37769247,0x0000fb26f76fabcf}, {0x0001ec3853bf14c5,0x000e7aa2a072ab68,0x000d7447c7e088fe,0x0000ff4d93e78cd8,0x00009fe9f418ede6}},
    {{0x000bd19d394d62fe,0x0008b38a0d8f64ab,0x000d938764136c16,0x000f4e72039b4ef6,0x0000849491679644}, {0x0009ba557055c06f,0x000dc7bdb007a9d4,0x000ba1745af2aec2,0x00015963a29318d7,0x00004187f01e40d3}},
    {{0x0003790c271585da,0x000ed5ad056f666e,0x000ee31740b9f498,0x000f8992c64d1268,0x000057c0938d8ebd}, {0x000298e2374bea71,0x0009768daf973b0c,0x000a2d513284e305,0x000c9eaf3e9e5fe2,0x00001291b298bd83}},
    {{0x00007ba27d3f2f53,0x0003b984e0b60811,0x0008eb875a3de64e,0x0004b33536bb951e,0x00007b9dec8b54be}, {0x00097920a0321af4,0x00038ad145d78b4c,0x000398b33b4205a3,0x000662f72f46d835,0x000081db115da0a1}},
    {{0x000d732092e35463,0x000b86781f2b173c,0x0003cc924b3fdc2a,0x0000dd4011f8eec0,0x0000d8fea672cc8d}, {0x000be33d826c6f6a,0x000a55623182076b,0x000d30071e7711f0,0x0002af15f3579d49,0x00000e7e0ed76e1b}},
    {{0x000d7abf4bb64eed,0x000c77dcee5b655c,0x000413063595edf1,0x0008c03bde3f3ddd,0x00008473cd3eaabc}, {0x00009fca27519070,0x0001a00dfd0763f0,0x00073571029941ca,0x000cb885e258bba0,0x00006ca17e26473d}},
    {{0x000a5610e0e8924f,0x000ff65b0e50d4e0,0x000400c48de61d42,0x0003ab903b10a4ed,0x0000007b9332ca3a}, {0x000f94cac8105ccf,0x000774a0a98a0b7d,0x0006b6f26564134a,0x0001f89637e2a236,0x000050ac987f5af1}},
    {{0x000a8d78638737d8,0x000c7cba5d96bf5f,0x000baf6465e23c9b,0x000bce6625837e83,0x00001f7b1951beb4}, {0x000cfde3643f8760,0x0007e0b1a62f4c1b,0x0009f918acc64067,0x000b46863c488c82,0x00007eeb70136714}},
    {{0x00038b733005eaec,0x00069bc862a3754b,0x00082e20a6c7da3d,0x00057108fdec85db,0x000022986577100b}, {0x00050a08db1555eb,0x00042a9d5da8256d,0x000025309b01beb5,0x000ddfa119befeff,0x0000030fdcce76ca}},
    {{0x0005d057caacf707,0x0003d6856c44b3cf,0x000bb66402bb6e67,0x0005d6fcf6d21aa4,0x000073ffa1ebc9a8}, {0x0007b52ffeaf8928,0x000b35e49a37db24,0x00070c9914f1e14d,0x0001ec5174b1f793,0x000068dbdc6a0007}},
    {{0x0002077a6effe60c,0x000e9ae84ebb9b28,0x000a90020b39c7e9,0x000c72996fc825a4,0x00009d2dd8f89811}, {0x000de4719ce198b8,0x0002073bd8ffd842,0x00091284580c3d61,0x0001c29d754578eb,0x0000e5723eaf004a}},
    {{0x000ea43768534f8b,0x00051abc588d36b7,0x00095d1fc7b73df0,0x00059713790bd820,0x00009bab617eb6a4}, {0x000918138f1334ab,0x000287a8ecff86f3,0x0007dc27cafd58e0,0x00090f2bea43a4a5,0x0000876309bff8e0}},
    {{0x00040a23110d738d,0x000d4d107a0cd20e,0x000fdfb6a9c754af,0x000106b9828ccb2c,0x000019c605440704}, {0x00026be98b9211c5,0x000da44d15bd9119,0x000db2afb42c11b6,0x000ef7dcddaea218,0x000006a2d4b20f0a}},
    {{0x0001358309571482,0x0001812df972a300,0x000a8cab38d53d41,0x00080cc32e21acfa,0x0000e6a672ed9fd1}, {0x000d45c4e36faaca,0x000be60297f9cf33,0x00070c34df7f4d7f,0x00001dcb91ebe024,0x0000d911f768257a}},
    {{0x0007255a2e0c5dd5,0x000d22bbbf673853,0x000ab32207a670b8,0x0008fe78ebe9b99c,0x0000fdde390be12b}, {0x000115f1b1cf88b4,0x000fc8cd1c7f9323,0x00039787a00aa2bd,0x00052384bc65bc2a,0x0000b21156bb8e1d}},
    {{0x0007c6bedf5eb992,0x000ccfb71e9c6a08,0x000a23eae9cb1f72,0x0007b145f4b20c36,0x0000cdd6cd364c1c}, {0x0002b96009e153bf,0x0000791667fd4b16,0x0006d6b0e682b36d,0x000dce91c1e9f97c,0x0000b3acb50ee02e}},
    {{0x000ffd490f51cbae,0x00013a606f79d85e,0x0009bf4dbe0ae081,0x000c1de9ba256a47,0x000044c5bde85698}, {0x0003bc53c7a38530,0x000bb62a6e6e5c80,0x000103b8eb6cc532,0x000dc7a5791e202a,0x0000707bc1728e28}},
    {{0x0000b00ef08771e0,0x0001e0a13ee687b0,0x0001b533b57773fb,0x0009a5ccaa4259f9,0x0000b79966f77917}, {0x0003e85beb00e9ce,0x000df3ff0394ced9,0x000c6bf70673db5a,0x0003f1d646c1a702,0x00007ad3795a15d2}},
    {{0x0009e4bc97bc7da4,0x000771d5ff2a522f,0x000985f8205c96c1,0x000f2cc4eaadd196,0x00002c57d9e6d752}, {0x000d1929233b3620,0x000e75373d1e4ac7,0x000b30d44f4b9421,0x0007bf6bda441140,0x0000bfb154cbcad3}},
    {{0x00070a4205b81469,0x0009a9885929e3d4,0x000ad5364994946f,0x000dfb6f3fb7423e,0x000003c1097c2e3a}, {0x000dc4ea3c0c73f6,0x0000a781ef8a533b,0x0008fa9cfdfb0cba,0x0000a169994d9edc,0x00004caf3b9da044}},
    {{0x0007bff77c009156,0x000b45f526c72d31,0x0009ca544fe44325,0x000af0abe60485f3,0x0000d0555feb6700}, {0x0009417bc4ccc145,0x0008e6c415362ec1,0x000df5ddfbceb3a1,0x000947ada3efdb22,0x00000c675f6c474d}},
    {{0x0001b02ff106393d,0x0009ab788c98851e,0x0004e8fd1bb09653,0x000a43a2d782d5da,0x00008c9f428680c1}, {0x000ad17045780bde,0x0001b95cdcc517cc,0x00061b333987fc28,0x00047c5787ae170a,0x0000f427985ca04d}},
    {{0x0008761292146075,0x000a0cf3aec278b9,0x000329f90f12cd22,0x000d72cb478d1718,0x000082d33765d490}, {0x000d6264ebe63b58,0x000388509017bfc0,0x00049f0b28500032,0x00044eb2df475953,0x000023dc015fc527}},
    {{0x0001a099d4037afa,0x000c7d2a4f51d503,0x0000b909ab658722,0x0002f75dc1387e94,0x000054c7cceb78bd}, {0x00084d3f96fe1299,0x00029004be5e603f,0x0009034366d312d5,0x00042265d0b7585f,0x00003b342c682c11}},
    {{0x000abe562108741f,0x00090edafcb0db97,0x00050a1e77625189,0x000612928f4ef0b5,0x000028436f533db9}, {0x00066a445e95a984,0x00061b7395817080,0x0008a14b66b45ca8,0x000fda5f298d70b3,0x00009d4a0366568d}},
    {{0x00099ff0ea5b0fba,0x000aa38e73001b62,0x00067dc4c57987d3,0x0006d5467cc55ce3,0x000040e6da53b93b}, {0x0009e490c345dc3c,0x00054155af276568,0x0009f77de77c956b,0x00064f912443ecdb,0x000013d1f2e35d2f}},
    {{0x00069dc8827b81ba,0x000ff2e3d5a36319,0x000f13ca81af30b3,0x000d3db2c866e0bb,0x00001728b7fa6e1d}, {0x0006d11ba4e53cde,0x0008c3f44d47dc80,0x000de776c71aa9a6,0x000377d5cb45efd5,0x000001fc46a09355}},
    {{0x000b7f02f609bf48,0x000d851c333890b5,0x0009646d5de532e0,0x00050dd82571cd4d,0x0000381d38f402a4}, {0x000a13f8fe5abf74,0x000e980cfbe80cee,0x000d8244e4e987e1,0x0002547265bb3560,0x00003bb71799807c}},
    {{0x000711e9d0717f73,0x00098bcbfceb725e,0x000af2faf4e210f9,0x000aaffcf4b3dad3,0x00001d7b1680a432}, {0x000a9fc79b356741,0x0009b13d5198f7a8,0x000714c9efebfbdc,0x000e9183ee381471,0x00008113de151b1d}},
    {{0x000b068e8dac101f,0x00082a77a77808b1,0x0005fe83ee2d68db,0x0009cd82fcc849c8,0x0000ced2c5678a6b}, {0x0002eaa12ebbd351,0x0006fe07a1b126f4,0x000c1b353de97cf6,0x000303776ab40f94,0x000029ea20475cdb}},
    {{0x0001c2d1586be5b9,0x000cc911b89d6385,0x00075acf780e9258,0x0000604f7cd421d7,0x0000cadd878a2dad}, {0x000218369356e650,0x0001634ebb7f5e99,0x000cda3a8202c34c,0x000abf90720028f5,0x0000fd4e963d3750}},
    {{0x0000f0db1730827b,0x000d644fc900fdd6,0x00037410dd37db24,0x000309b2d883f43c,0x00003acdbdd5534d}, {0x000703eac7e1a004,0x00004f5796e43be6,0x0008988176129b8d,0x00003dd7ccc20dde,0x00003c8ca33f4853}},
    {{0x000d0c1c7047f195,0x0002fc7ed2afa267,0x00088562adc95dd6,0x000098dd5add39ac,0x000066c878035e61}, {0x0004fefb47537004,0x000a5a743ef55e47,0x00047591d972f249,0x0009adda486006ed,0x00007c2df25f0a81}},
    {{0x00056ba80ce1e1cc,0x000e67cf1faba833,0x00089e7a051528a4,0x000c6753125898cd,0x0000607dcedb32bc}, {0x0009d23e8c6cd3f2,0x000ffcb09ace85e4,0x000b7d6c1505f623,0x000df6e74aae2597,0x0000001f7693e568}},
    {{0x0002f4fb58a08ff9,0x000b22b767ddd77a,0x00020e33dc68c924,0x0007b51b436b1d3d,0x000015859ad34f0d}, {0x000bb551c67e100c,0x00072572c5dcce84,0x000057987a70e414,0x0002b07c8616056a,0x0000bd0d7de543e1}},
    {{0x00091ff11bfcf2c7,0x000d9646c09265fc,0x0000510cfe52d918,0x0008aa8cca65d05a,0x00007afc5385da20}, {0x0005903d91d0fa38,0x00048cd25652dd29,0x000688d81a6042f6,0x0009e3be9a92ed90,0x00005df7150a5df5}},
    {{0x000edbae38271e0a,0x0008b5cc06bce54a,0x0001bfd7a369474c,0x000e44e3c9d39cd5,0x0000e2bf2cdfd46d}, {0x00082c92389f1ca3,0x0005c88dcb5d5b81,0x000a825a0e26bc70,0x00005671cf4bee96,0x00000b65e1f6a6a6}},
    {{0x000a928368d1a456,0x0000e11cb329d7af,0x00041e0414116b46,0x000a28451a71e385,0x000027ce6313e7a8}, {0x000e5e5782687675,0x000f0685af014510,0x000d3b826aac14a7,0x000bdffd100fad1e,0x000080ca2ea3195d}},
    {{0x000a01041994c103,0x000f47a314e14992,0x00008ef0842886db,0x000927a87388d695,0x0000b98c4ff30fce}, {0x00097d3fcc147238,0x000a8c29c45c7e2f,0x000f67220c5a2e9c,0x00037e0bd4619da3,0x0000189f33c99079}},
    {{0x0006fce6fd4eb1d2,0x00096d33c1253a1c,0x000e10ffc8333657,0x0002c4acbc619c17,0x00003e3f4c29d31b}, {0x00042a47b0149578,0x000ebc09d858af7b,0x000c49e700d501cc,0x000b440ce075301f,0x0000f231d5f803e1}},
    {{0x000ef3caffa4bdec,0x0002ac777c54035b,0x0003cd0bc68eba77,0x00045b2505bebe91,0x0000e4644ce7cd8b}, {0x00042777579dea15,0x000298fca9661f18,0x000590619d9f2264,0x00054720eabbb3fc,0x0000e6455a9be8fb}},
    {{0x000a577c0e475eea,0x000d6bc1436c96d9,0x00016236e94d021e,0x00008c00a8850a9b,0x00004b2d015d7f50}, {0x000c9dc4c6f4a38c,0x00028553656de8a8,0x000a90c362732682,0x0002bf3d15dd9142,0x000052c5e5dfbb42}},
    {{0x0000cbe5411c8dfd,0x0008a17b7a24b8c2,0x000b9b87fd8cb545,0x0005e6a11f9fc178,0x00006c1feb2d790c}, {0x000c58e0b0881f88,0x0003c321556f92f3,0x000a34013603d060,0x000d70aff166a927,0x0000d99e1e8e4319}},
    {{0x00020a329430fd34,0x00091b753e241ff6,0x000dc9b1f4a806fc,0x000873c09454c63f,0x000053aade33de2d}, {0x000c8ed7cf2adaa3,0x0009418f8a188df3,0x000e4faf13fb7d84,0x000bef84861cf96d,0x0000860acea4d6d0}},
    {{0x0001d18705dde70a,0x00011272a18859a9,0x00033f5014638a28,0x0009304080653c0b,0x00008c599a15b5b1}, {0x0001a5a4482a49b3,0x00092f456786cb4c,0x00064ba9b7822d73,0x00018755a97a72d7,0x0000b095c5fcf342}},
    {{0x00068b2d8952a5dc,0x0001384c32454373,0x0001e2922c3926d4,0x000aa3dca16b1fa7,0x000037a2bd72600f}, {0x0000a741ebdedfbf,0x000e23ed58f44104,0x0007baa3fe459532,0x00006a13286a4d62,0x00000256f65a8e61}},
    {{0x0009fdf904d40a4c,0x000a46face48942e,0x00021d60e882feb0,0x000dd0396add6456,0x0000900d2cd7fcc5}, {0x000a7b9be3cfc441,0x0003708a50df4de0,0x00082f25a62b3146,0x0008d616896ec237,0x0000efc52dd341af}},
},
{
/* digit=10 [{1,2,3,..,}]*([2^70]*G)  */
    {{0x00074cd669b25cd3,0x00058c67881c256b,0x000c2d070504e035,0x000ce9e47e328af1,0x0000334f9064ef41}, {0x000e26a1c2dcf305,0x0006722062f65cf3,0x000d10bc4005653d,0x000d490fca65ad22,0x000019179d890699}},
    {{0x00026e7838ac11e5,0x000e2a5a280f9fc4,0x0004127710bbdb6c,0x000c0919081aeb17,0x00009d3642b34a2e}, {0x0002ad9a69ff2662,0x000684c317570d7d,0x00000f6f3f188512,0x0005163b33b1c24b,0x0000d7b1d0e34234}},
    {{0x0009ff3fb1c1c89c,0x0005aabccb1a5742,0x0002d53a4eef7623,0x000053470aedff2d,0x00002e085185e01f}, {0x0003bc9f5fe3ea55,0x000e66ca1fc53dfa,0x000605f7ffc83fe6,0x000716623aa4d317,0x0000f64c0b56ddf9}},
    {{0x000674732b26ecaa,0x0006a9b93619c51b,0x0000bd8947d766ea,0x000f1f8da8cf9566,0x000039fdfa96c371}, {0x0008371eaa4eb5cf,0x000f1c2fe16a83bd,0x0006b6beb3c7b8ee,0x0003dfb56c848ff3,0x0000baf4cad5a849}},
    {{0x000b862c0fdd559d,0x0003472c11580706,0x0008b856520b2638,0x0006879e81a90197,0x000029294aa97e5e}, {0x0001e0f85a0008ae,0x000842f061b6095f,0x000af5f1784d787b,0x000532b513ddfaa0,0x000056317941cc65}},
    {{0x000d1d3a33d19d98,0x000d7df2ca8dcb4f,0x0007f4e6b5456b29,0x000f5ae912a132ae,0x00000f2c9a6887a5}, {0x000e27431535c2c9,0x00023aba1f2ffbd4,0x00049250f22df234,0x000935fba35d186e,0x0000929b2503d242}},
    {{0x000c9391c1b57c4b,0x000d954532e6f2ad,0x0004d08859d320c1,0x0004f4b4c12b6234,0x0000d868d83b4346}, {0x0000ea15c6c613ad,0x000238397325f0de,0x0000c2f9dc73b139,0x0004b7db504ce64c,0x0000dc963c4af5aa}},
    {{0x0005e02dca527597,0x000576587c548e0b,0x000cc2767c475cfc,0x000859476ce6a9bd,0x0000665715a85b0c}, {0x000b469bab32bb4d,0x000d0b6de7c31b91,0x0002327265da0fa4,0x00047cf1f57b245a,0x00006cda9501707b}},
    {{0x0008d572808b4fc0,0x00011694ede0e70b,0x000f8b71405a8e19,0x00015233c02d5353,0x0000ab4ce2e44ab2}, {0x000c47dfd222e80b,0x0008cc293dda614c,0x0002292f07c1d085,0x0006cbfeae2c20e7,0x000061ec173fa523}},
    {{0x000876bc63806f07,0x00024d66914b313a,0x0008170d851534d4,0x000b76faa20f3de5,0x0000aab05f61a766}, {0x000664f3ab471d0d,0x00011fdc64a701f2,0x000ea68223acb6e7,0x00013a23fabc7bb1,0x000090227c181a7d}},
    {{0x000ce1496c8edd99,0x000b6594d679e5a6,0x0002b74d6e54b8ba,0x0003a13ee780ee06,0x00000955d9961a01}, {0x000cd19a119ac211,0x00082f7e73061c51,0x0007bf37a3de8103,0x0005363b406e5945,0x00006f8f87f664ee}},
    {{0x000815967b132401,0x00064ecccb2576eb,0x0005d3b7d625290b,0x000ec5d6f358953e,0x0000a5226a7375ae}, {0x000abb11ef347a92,0x0007143ccb0f7b41,0x000c82f4ddf3c9db,0x0000dfd73dd924bb,0x000087da47b38012}},
    {{0x000aa601588458f9,0x0000975e5cf241d9,0x00060b80ec71bf1f,0x00029fcc1fb01f45,0x0000823f9d230d8f}, {0x000657c67a86fd8d,0x00034e709b0f413d,0x000642ec3286cfe5,0x000ba7caac701a18,0x0000fa3bb61f6852}},
    {{0x000801b0303fe8c1,0x000fbe0cde9a2307,0x000713051354d6fb,0x0006e735aff62229,0x000025ef6c00b818}, {0x000306588dd6cb80,0x000a99185c90f436,0x000ae928b4ff1484,0x0000b1c883be31ae,0x0000a9c05acf7be6}},
    {{0x000b28128cceb413,0x00082eab515e529c,0x000d8b8e887dd9a3,0x0002d5b9d67b20e6,0x00008b59180e89cb}, {0x00059e2abcbade3b,0x0006184d19e316ec,0x00044d27ee72fc4a,0x000c67731c05e18c,0x0000a8c4db3ec2d5}},
    {{0x00048bb35989f3d6,0x0009b3067fb4c320,0x0001a0ffbcfe88ff,0x000004e03be2c82f,0x0000fcbfa01af932}, {0x000f814e7e4cf8e6,0x00024ee9f240c53f,0x00086fc0004f7b88,0x0000ac34de98e74d,0x00007917ef356057}},
    {{0x000c6c4a11a11477,0x000d8b1cf6d0d720,0x000694efa1c1285e,0x000e0c1350e984be,0x000078cb9118b03f}, {0x000bf89c99dbbb29,0x0004fbfdfc88574b,0x000eee84278a2c53,0x0008ff0a649b25e5,0x00003d025e893279}},
    {{0x00037a391d54688c,0x000c7c592115f719,0x0007653bbcda0dcf,0x000a69f5817c7617,0x000029a05f07e803}, {0x000753fad30733d0,0x00072bd1849daff3,0x0002fca30fa2fd8a,0x0007feecaa47e99b,0x0000b0731727e7c5}},
    {{0x0005a21b38ecce44,0x0006e415c2abd742,0x0002c0e950133c0d,0x00000ea72b809264,0x00003015ecb9ba58}, {0x000360d2878775ae,0x000bc41c8e4f6d21,0x0003c10aa67f95a8,0x000900e292f6829e,0x0000a4ee43081d92}},
    {{0x000fe9693df562e6,0x0002fad17b8b0aa9,0x0003de3c362eb368,0x000d534ef25783ce,0x0000ebda4537f429}, {0x0003627aba553bd5,0x00097af716fc435e,0x00095a844547dbf0,0x00093eb262399131,0x0000588e07a230c3}},
    {{0x000af60d3202fb41,0x0004c8c7c74a1d4e,0x0009e5b39057f717,0x000f7cf49850c859,0x00008d151014d7b0}, {0x0008fa60b07a5144,0x000d9ab459ce85f3,0x00097edc90f40721,0x0000fbad27012797,0x00005754882b9450}},
    {{0x000dbfc225b16955,0x000deb78b51638a3,0x000458d99f09b93c,0x00061e32d72821e7,0x0000340498c56d86}, {0x0004bf05323cf76a,0x0002ff7ffc746f1f,0x0007d6ce5b44bb0a,0x000c88717795b069,0x000004ab2bd3e89f}},
    {{0x000605a2ca22e4c3,0x0008ac2d7351ad97,0x000eab2e88f2760d,0x00021fc887db7e2e,0x000029bc5ec3ebf3}, {0x00086560b7317f55,0x0004d18b91ce9d01,0x000b6f646f4fb8e4,0x0002a1695833078c,0x0000d6a694f08f66}},
    {{0x000c95e3b72c81be,0x000e8a03275a6b4a,0x000d6b09aa4f69a1,0x0002be1ee61ad29f,0x00002844ca4e17dd}, {0x000e76f8794eee2d,0x00087cd0bdb33924,0x00040e3f2ddfa70f,0x00072fa4a906265c,0x0000b96580f51259}},
    {{0x000023b688cad9cb,0x00076df8951487ec,0x00010c9cdd6ac550,0x000ae554e43a52b9,0x0000fef35226f5fe}, {0x000cbe7fdb2ed39f,0x000a0a5e1bf9b554,0x0009afefe7699601,0x000c50b5d7563445,0x0000010fb3404117}},
    {{0x000279f9137ac6ab,0x000249953bb50af7,0x0000826f6345477d,0x000865968a387bb2,0x000005a5cf531199}, {0x000c5268a915e259,0x0009720c4f4b65a7,0x000b7b99cd26125c,0x00058b59772469f6,0x0000853ae820ffe3}},
    {{0x0006b4b6ec89e3e9,0x000333d0ff1c8c17,0x00059b5dc3204606,0x0005662b172727c1,0x000080e1bebb1c71}, {0x00018894c4864ef8,0x000a9eca02e2c6e8,0x000cab3d09dad501,0x00060af51c7c848e,0x000047e4fa35bc16}},
    {{0x000570befacb28ea,0x0008743dc8f455c5,0x000f40096cf59c5c,0x0004b182c494694d,0x00003c0fc958c313}, {0x0003107f39793424,0x0000cce996b712e9,0x0000246006fd67c3,0x0007be905a6fad26,0x0000fbfc527a687c}},
    {{0x00095e1c222ce3ef,0x0005747315cd6f47,0x000423b7afe75d5e,0x00019bbc54314d23,0x0000ef8b8f77d09c}, {0x000803127214c810,0x00015ffb94e2fbe1,0x0006d06ac1164fef,0x000f30476727cb12,0x0000a8113857ebf7}},
    {{0x00087efddf19eaed,0x000e96b6e5f5f6d7,0x000ece472e89ecf0,0x000c927cc82cb9ae,0x00000feebacc040c}, {0x00099970ce1340b7,0x00074081fa310631,0x000f300ce340cba2,0x000a1055a8739566,0x0000fa0cef064603}},
    {{0x000082c59b5bc93f,0x000b65fc16a6d50a,0x0004bee2ba80b4cf,0x00016533174cf7dd,0x00006aceb571e5f7}, {0x000006d350847cb5,0x0008616d7f8911a7,0x0008b0f735565146,0x000122795d2872d6,0x00007b8ca3d3efb5}},
    {{0x0000a88e8800df98,0x00025448903b908a,0x0004349a5a375804,0x0005b13ac924efa4,0x0000a5e450fd59f3}, {0x000055716f999f92,0x000de9af288dca33,0x00069f12c2367b4d,0x000284d0897fc5ab,0x00004fc4fac80274}},
    {{0x000eb7eb35f2a934,0x000d353268becc03,0x0000a4174b282d2d,0x000f5ddd6356402d,0x0000e7ffa1bdee1a}, {0x000aaa4d2ca7e708,0x000704fc0f9760eb,0x000357060cd33f91,0x000d81e7eb1971de,0x00003d746cad3a0a}},
    {{0x0005e0ddb5450c74,0x0002a674a2e0aec2,0x000bc7d3441bdd25,0x00079a58f6e1b7da,0x00001d2cad53a42d}, {0x00076a79d2639d68,0x0003f32fc3bfb513,0x0002bfdf25a3776e,0x0005d91a51232583,0x00009aba866b1079}},
    {{0x0001534fdb96049f,0x000d73c129cc545a,0x000caf544a6dce8e,0x000d95f07d61f6ae,0x0000dcef4f010d17}, {0x0003b9847259e03f,0x000e08eaf94b5a31,0x0000a320a3862f66,0x000f35bfb4c3fc13,0x00003ce88af25ac5}},
    {{0x00084f5111ed5705,0x000b79be0976a8d9,0x0009ab22e7a6498e,0x000cda52cf1ba030,0x000013d88452929f}, {0x0006f21a33ad72d6,0x000e27b4947e3ec9,0x0000022021b0fa2a,0x0009c5f35557b5e4,0x0000f01ef8814f2f}},
    {{0x000c2442542799ce,0x000f9b3064143739,0x000f1d943ee0b9f4,0x000e26265a704416,0x0000e87d46c8a352}, {0x000a8e3615322bd7,0x0008190d24dbc6d6,0x0003d81377ed07b0,0x00056a2a112749e9,0x000094697b190dce}},
    {{0x0004cf425219eac2,0x0002cb6fb9207e1b,0x000cc82f73e79b1e,0x00073ae27f3c4a54,0x0000554f3a88ed84}, {0x0006de42a1700f2e,0x00006f9c40687f07,0x00093ba557a83e9c,0x0000a11fbe078a85,0x0000e7643032099a}},
    {{0x000f9abfe9907a6c,0x0007cc63f2dfda1c,0x000bac69ee3043cc,0x00041648aa637938,0x0000bbada2c4f2c0}, {0x0001495c9e6f03da,0x000fb7b4eda11e13,0x000b4954affd78b1,0x0009d34c115f6b0b,0x00000db881c07854}},
    {{0x00029e61ad8613f5,0x000c9ddb326c11c4,0x000869e2813f8b2e,0x0000b0117db8ee3a,0x0000dda75e5f5ffb}, {0x00073327c49cc58a,0x000d0c3da6be20e6,0x00070dd5c65cada3,0x000ef461959c8261,0x0000fa5cb2cf4faa}},
    {{0x000e000a34fd0c8a,0x00058901bb98ca77,0x0006eb2905cd2973,0x0003336dda93946a,0x0000934ccf97e513}, {0x000c1d692b201b8a,0x000f029af6321234,0x0008d9dfac9c7c2b,0x000f582d8679e67a,0x00008046ce69fc1a}},
    {{0x000ab8eb6e0336a9,0x0006ea229cba0232,0x000dedbcad54fcf3,0x000667a7a0cc9245,0x00000a2c42237703}, {0x000b601fbb80bfde,0x000a2c63fd8939e8,0x00049e20428365e9,0x0007aca1417dd6d7,0x00003f11af7e1f8b}},
    {{0x0002330b4c09a0de,0x000902a37b9c9a53,0x00036cda4e95cf6e,0x0005ec789015573d,0x000029deb51579af}, {0x00020a37b9ea8e07,0x000799397a517f13,0x000557b7511fa4f0,0x0004370b092cc886,0x00004fe2aea14013}},
    {{0x000b5c6a9db98dcc,0x000dd04a3aba71dd,0x0006608f14057254,0x0006b8b756359d19,0x0000c4455860c9f8}, {0x000a2e774f5cc99b,0x000300a46307126b,0x000302ddbaa681cb,0x000535fc96dbf608,0x0000c681d0076c06}},
    {{0x0004d84c9e62370a,0x000a69eb6fa1f9bb,0x0000ef588241feb6,0x000245740d6249c1,0x0000be2d5006f181}, {0x00041f73dee49528,0x000c00da95bad9d3,0x0000e049a1eb457a,0x0001bbb11190a486,0x0000110d97c60ffd}},
    {{0x0009877303f6c251,0x000a1c17dc10f282,0x000bb8dca73e7560,0x000a683b3ec4fd74,0x0000a9f75e1bb560}, {0x000919d9da696d60,0x000d217fedcd3ac2,0x0006adcd9d53df79,0x000215470c8bf19e,0x0000b0f430bfb8a1}},
    {{0x0004ec0bc6dcdfa8,0x00046693c98632a8,0x000bba59e9150cd8,0x00022c245639b8fc,0x00003d4bb7590c93}, {0x0004d6a04c6abc20,0x00066201cd556fb0,0x0001e5e4afc3d001,0x000ae07774cab315,0x00003d6c82521fe2}},
    {{0x000c32cbecb96f49,0x000a3005ab64ddcf,0x000baf06df924953,0x0005e8ae7d321d49,0x0000b2d331a8c32b}, {0x000d67cb123fdcbb,0x00088a617dcd4f59,0x000e94c2e5129661,0x0008ad46352e5f1a,0x0000d5565de6b48f}},
    {{0x000e6659b3560d39,0x000ffa229f90747e,0x00023180522e466d,0x0004d6c4a3f828c0,0x0000e455d80ec3ff}, {0x000e2eebf20d3aec,0x000c736f73d855fb,0x0002184b7e5febc1,0x000b11155c63fc28,0x0000a428c274cade}},
    {{0x0001c636e5373dbe,0x00086eb6f714bd17,0x000e1b6a90d860ea,0x00060dc93cbac42b,0x0000d34c45c4c0f5}, {0x000659cadd09b1eb,0x000ccdb20e3300d0,0x000141729d71e84b,0x00060e782510dc77,0x0000ec0565e653b0}},
    {{0x0009e4d6e92f36d7,0x000825cbda73f299,0x000665eeb18db8b5,0x00018f9cfee6e9a6,0x0000ca23779281ee}, {0x0005db4b1418ca14,0x00024447b1c7f54f,0x0004f104fcae5744,0x00000ab06a6080e1,0x00001054c45b9651}},
    {{0x00055d5f2446ec83,0x000467a9ebe2680a,0x000c77fc1761cda9,0x0005aa015446cd46,0x00001c27acc7da7f}, {0x00077703a89b1b78,0x000cd191b9b97518,0x00013cfd2ff9eac2,0x000e94ceb77c72d1,0x0000fb9cf6eb1afc}},
    {{0x000c0193744cd46e,0x0008b3ceea178d94,0x00014a628cfe494b,0x0009d6820be8421f,0x000094afe6f01bc6}, {0x000e28b4eda452b7,0x000538785cad4748,0x00037da88fc3c7e7,0x0009fc488a0a24ad,0x0000cc96f2897d92}},
    {{0x000f9f92b892fabe,0x000e8fb2e6bf1cfd,0x00099f05d11cf6a7,0x000c3b1597b79e80,0x0000a26740afb0a3}, {0x0003b35d8b31a83f,0x000396846e25cbc8,0x00082f6f006b2f50,0x000a658d89e03e35,0x0000db716db3d591}},
    {{0x000d177e1fa4ed0a,0x000dd5607e4daf0e,0x000573a2cc2358b6,0x0002b7ee7eca899a,0x00003a1628589e78}, {0x000f908d149527d0,0x0002262175b94b20,0x00013e200c0bcd10,0x0003975b06898fb3,0x00008491f71c53a0}},
    {{0x0002d700f31b0e00,0x00019237b591c539,0x0009fe9bccb246e6,0x000017bf39be6432,0x000028e4046f6380}, {0x00046c9c0d21521f,0x000fd73f252bbf1a,0x00043fdf02581ac2,0x000babf43b3c4272,0x00001a5ee9169a81}},
    {{0x000e5448aa1f7350,0x000f3edd6264a716,0x000253daee2205fe,0x000b4e7addb5be46,0x000055192f8f04cf}, {0x000b2643882ff890,0x000c409401a9d5ae,0x000413e0c8a16ec1,0x0002f7f8a4fe486c,0x000089973c8ecdb6}},
    {{0x000af3487f6b18cd,0x0008a3d07d2ec763,0x0000e5a1521e2961,0x000427104e65b30c,0x0000bdacad3f1ac8}, {0x000145358f37a6dd,0x000d004a44da735c,0x0009eebe68dd299b,0x0006b05a62c5ac63,0x00000ac76876f8b1}},
    {{0x0008acf5a8209bcb,0x000560df7a62c194,0x000c1fb14acfeda4,0x000df2c2224f5fad,0x00003404df8d5798}, {0x0009a77b70e54968,0x000520108a2364b0,0x00015fccaf6ebdf0,0x000566e36cd047b8,0x00005e46d74586d1}},
    {{0x000844d8e8ce5587,0x00092279b1356b90,0x00091add341ad4ae,0x000a7d2fa10f0f42,0x0000148c77380f8c}, {0x000496d6691d4cc8,0x000782bb8243fd56,0x000627db185c1156,0x000a5418645f44bd,0x0000d506007bdf79}},
    {{0x0000bd279fead68e,0x00056182e4e75be9,0x000dd1b6509c30b6,0x000ed8c47b692128,0x0000f5fe87abfda7}, {0x0003143dc3675e1a,0x000c502b0a119eb5,0x0004fe0aff458d3c,0x000a31f46a7b233d,0x00005acb343f0376}},
    {{0x0002d15eee0e0d34,0x0003d148684f5225,0x000cdbe9722216f4,0x000c5cce42f45a7d,0x0000e205d19ad51e}, {0x0000f64c68b5fa7c,0x000058e30f053866,0x000a6c9cb5f06a10,0x000f6f5287fecaf3,0x00001883d276db11}},
    {{0x000527672331c67e,0x000a87a64576176e,0x000c391a5c3662b4,0x0006c076cdba095c,0x0000f9220fdeba1e}, {0x000ccfc868b90cca,0x0008290a8b4bca9a,0x0000e92873faa03c,0x0009492e8d17378b,0x0000a47f8c64e176}},
    {{0x00028cb6de5ee8de,0x000cd5efcb0928d3,0x00077e0ccf78a9c3,0x0001c402efb29bef,0x0000459ba0ccaa24}, {0x00015eff8dc3bb71,0x0001926d930b21d2,0x000c2f8d6a0caf81,0x000f17b13725955f,0x00005d65bf7dfab7}},
},
{
/* digit=11 [{1,2,3,..,}]*([2^77]*G)  */
    {{0x000f9aa8775da137,0x000593a6332e3942,0x000acdfba04c12e0,0x00036116cc38b202,0x00008a8960a21793}, {0x0002d21251bfcee2,0x000d5d5e4ebe7fd4,0x000ecd2b4f06757e,0x0004179312209cb9,0x0000116a47ce63c7}},
    {{0x000fff36dfdd5049,0x000f7ce6110d0407,0x00098a9fc7cb9e1f,0x000926e424e2d9ea,0x0000835121b0ef1b}, {0x000d9bfa74da96b0,0x0002cd0f068f3fbe,0x000fb3442f781253,0x00047bf2a224f7f4,0x00003b3786a0183b}},
    {{0x000297122b1f3105,0x000638dba8324c9a,0x0007684493f6706f,0x0006825bd6946011,0x0000954fb43f082f}, {0x0009146aaba29f01,0x0004e9c6324aadf7,0x0008d8428f5d9954,0x00015d922efe9529,0x0000d292e4285a89}},
    {{0x000eda370bf670ce,0x000eff959124f0b7,0x000cac220c098413,0x000042e12faaaa26,0x0000895133539985}, {0x000e3efc5819a77d,0x00057c57c1941637,0x000d0cc10c5d3a74,0x0002ffae97c4601b,0x0000cc0b9439604c}},
    {{0x000eebc15ab85274,0x00019d13c980241c,0x0003a82e05366ff3,0x000eab4894fa90a8,0x0000f875d5053ef5}, {0x000f960988cc3ea5,0x000ead66986792b7,0x0002473220ad7ea6,0x000afad402fea6ab,0x0000112495728583}},
    {{0x000f4636a79fb44b,0x00090857f24b3d06,0x0000bd52a5b7cd91,0x00064839569b4ec8,0x0000d1b1ac7d83e4}, {0x000a69c7aac7f865,0x0006f8fb84cd4b3a,0x000b5e37812c149e,0x00091eb184db0903,0x000048acff136f66}},
    {{0x0001299f5efe435e,0x000b7f1400ac2880,0x00059719edb65124,0x000c51a678fab01d,0x0000165002ee9aa8}, {0x000bbf3f226f941d,0x00011de495d3deba,0x0007d94842b6a345,0x0003d2d9919c7098,0x00000d6590e37520}},
    {{0x0004ee9ebab5f9c3,0x000ee5aa2862cfa0,0x0000825883683453,0x0005a0745585d074,0x00009825b8191988}, {0x000e1d078fb65329,0x00028cc58f8e9d76,0x000caa6ecd94a45d,0x000e336d0acf4acd,0x0000622e82ce2bfc}},
    {{0x000008a44a2706aa,0x00041b1add588771,0x0007569a605cb923,0x000def6163a01430,0x0000a568614fb2eb}, {0x000f81a9ffce874d,0x0004c0a48585c4da,0x000233e6225a5f0a,0x000d30ea80e24f54,0x000012a0f8a98988}},
    {{0x000b7355cdc2f284,0x000d2a27b9adaef6,0x00093f3b59e1ed0c,0x000b746910956189,0x0000c77d5df71c8b}, {0x0001803652237193,0x000739b9537fbfa5,0x000a62d938c3a3e5,0x00058e9ebd4a1293,0x00008b4fbeec3446}},
    {{0x00052179751d0b7d,0x0000f901f8a82fe0,0x000136ce503fb389,0x000dba5498f02145,0x0000cb7cf9a661f9}, {0x0007016c2992806e,0x0001add3eb9fc4a7,0x000307dc5f99dbd8,0x0004c304da7f5ed0,0x00006fb20bdf58fc}},
    {{0x000325b563f62c26,0x00088e338763fd2e,0x00070b882d81d583,0x00086a60eec0789c,0x00000900a5d21f5d}, {0x000b2fb282b41ea8,0x00039ddb91517ee8,0x000f77556d931d68,0x000bf902f126e703,0x0000b19f00d7d3a7}},
    {{0x000110e849fc28b5,0x000b011096883b49,0x0007657f512d21a5,0x00011f76afc44bf5,0x0000746d7f32aaff}, {0x000037a74dc795a3,0x0002395a1c198937,0x000a8ef1664ed39e,0x000c26cdb84ee945,0x0000696b907f6d28}},
    {{0x0009d6f7600276fa,0x0006d3198ab29dd7,0x0005cb1d12f3e169,0x000f3329a912fc79,0x000030c403e7632d}, {0x0005a8f5ede17ddb,0x000859c12cf6284f,0x000881ae76605fac,0x0003ae8ff98c78aa,0x000023ec368ec733}},
    {{0x000130cefa1d5675,0x000a003664f802bf,0x0004bd36ef9058a3,0x000a3113c314fc7c,0x00002389880af8c5}, {0x0007ec1959838d48,0x000fb01ed3b95705,0x000f59b95a2c3c69,0x000e21c93ecb7a35,0x0000427f7b9b8f6f}},
    {{0x00004ae4288bb5a2,0x00037f3270264a85,0x00010b20b51cafa3,0x000a0e9e414efa30,0x0000157a33e62123}, {0x000d80dd6415cd8e,0x00020677cad8cac6,0x000c9fbc4f37610d,0x000d6dae155e1c85,0x00001d0a4ba60f48}},
    {{0x00067d8c0e279e91,0x0008245afbee6855,0x00078ddecf33ca01,0x0007946ed3edf19b,0x0000f617d59ab035}, {0x0007945ae089290f,0x0005fe0200f2c492,0x000bf24784884e8b,0x000928852fe9c760,0x0000ffcb8771fa43}},
    {{0x00066fd3da53da79,0x000b479eb0a7ecd0,0x000b2d549c3fc2d9,0x000b9c3ae4337ac7,0x0000ad4d200fc335}, {0x000f93463a303081,0x00096441398584c8,0x0008f0df55fc6eb7,0x0006d5481aed496a,0x000038658e97f52a}},
    {{0x0009033a9a9ec889,0x00029548d2a17999,0x000b47721fa1d736,0x0008158e33920d87,0x0000045c74a58e24}, {0x000307917a0bc1d9,0x000057635c548972,0x0000f6f88a032dce,0x000d42aa81563402,0x00004682835e5a05}},
    {{0x000ff28d04ebc165,0x000507686c2c4e6f,0x00063dcb51fce3da,0x000d9fe06896b6ea,0x00002e5ce05439c7}, {0x0009d2e6bdf7eace,0x0000afa52e93e883,0x000674e412921b90,0x000bce92640a5a16,0x00008b7c0dd9fa63}},
    {{0x00028f0d3d5e18ee,0x000c30590eb006cf,0x000aec8faba412fc,0x00093e1f0888bc96,0x0000616d1fdc8348}, {0x00044c101c5f2508,0x00006dc12d0c3c51,0x000280f9293afec0,0x00028d276ff0f7e6,0x00004cf82b9fbef0}},
    {{0x000644eb6ad3daea,0x000f9da617bed4fa,0x000591916a0aea40,0x0004a62c8bc21622,0x0000b14787fa4323}, {0x00029dbaddcfdc82,0x0007d2c3a56f1f85,0x000d278b64ee5284,0x0007a85b4f7a0572,0x00004776f3f249a9}},
    {{0x0009bdc6a9c5425d,0x000a74cb2e08037a,0x000c41e34d0fdfda,0x000259c1bfad07fa,0x0000ef71695d1f87}, {0x0003cd312e6c539f,0x000dfe79874c3b10,0x000e03e026c03074,0x000366d7932c1541,0x000049edec49dd5a}},
    {{0x00048153ce2a6ced,0x0005cb374595998b,0x0001d374c1a016c7,0x00056bdfd770e4d1,0x0000152c3e66158d}, {0x0004234660137887,0x000baf4ea70fc909,0x0007a4061d5c4126,0x000a704f10817eaf,0x0000e2581ebc91a6}},
    {{0x000b859e2c097385,0x00023910a6cd24e1,0x000b5f1edfe2b5b0,0x000a39c796e06e2c,0x000061b222422caf}, {0x000f6e990b5ae344,0x0000276106c10652,0x000091bb1af35abd,0x00082644cec3093f,0x00005d1cd36bc1c2}},
    {{0x000fc1520ced10f5,0x0003010001daedfa,0x000eaefb25ebd7e8,0x0001d7614a3f50ef,0x0000f52e9b2b27ec}, {0x000b038acc2e629a,0x00014e35ab802696,0x0004c8730d623772,0x000307b05e87064d,0x00000c762bd34c12}},
    {{0x000e308ddcbf0bd1,0x000b96a5dc0cf082,0x0006cc07a52337c2,0x000fe84ae58e4cfb,0x0000659e706d98c1}, {0x0002ec7dd17741b3,0x000486171f471006,0x0002a5bee3b6d6b9,0x000eb91bd92dd984,0x0000975826a09b31}},
    {{0x0003c9292ce02260,0x000d0dd17ee212fc,0x000bd9b2da2e3c4b,0x00035318456b64ac,0x0000a1961934d45b}, {0x0007febf09ab4caf,0x000002c812353920,0x000942e1afcfb9c6,0x000a778eaf0948fc,0x000043ec3002cc4d}},
    {{0x00064b180a723820,0x0001aa42c8b77ff8,0x000fb95a1ada2085,0x000241ea27c78812,0x0000c96b8e900b7d}, {0x000a8792d5ec82d4,0x0000509cd684235d,0x000785d18e35f6ca,0x000788a287dd65ad,0x0000e9f2d7e56386}},
    {{0x000b08a242d1b6d6,0x00041b0fd09c63e7,0x0000cea65281d8c2,0x000dd0e09cd34ca3,0x0000cac233c630e7}, {0x000013f31fa41372,0x00054e81b46f3496,0x0006319dc9ade00f,0x000f520220b1fc74,0x0000e2b1a530749c}},
    {{0x000606de55192498,0x000c5809c40aa334,0x00096632d3890f16,0x0007e02bad0a1796,0x00005d185bd38bc9}, {0x00077cab67b3412d,0x00046a2cdd3292a0,0x000c830a347d5c0a,0x0000aa324c123aca,0x0000685c38fa87b6}},
    {{0x00038414a19d3175,0x000e6a1704e8a59a,0x00040b43fbe48253,0x000ce06f982b9219,0x0000d5b7bcfbcfc2}, {0x000713f4576e6000,0x00031b8ba82c39f1,0x00005f1c4af7d65c,0x000c3034d34805c2,0x0000f4899f930218}},
    {{0x0009d84b49c30b6d,0x000c425a60175a5c,0x0000a9f29180d182,0x0006fad47d4cfa1a,0x0000b40b136882cc}, {0x000d6a7c603f3345,0x0001bae3d9f84dde,0x0002e1b29542ed45,0x000b004616436a00,0x000003fa1413eddf}},
    {{0x000cfbbd57abdae4,0x00020fc5888c8737,0x000a4476d73cd5c7,0x000218725a0deed8,0x00005bf9e51796ff}, {0x0002e189a1751dcb,0x0001228d9683dc50,0x00093baabf58f351,0x0000af8fdceae65b,0x0000cc7a48df0733}},
    {{0x0003e0d34f77c46d,0x000fbc6edb0f3c88,0x000068e756b0e5b0,0x000e78037099eec3,0x000038e0b3c5fb3d}, {0x000f6109612e790d,0x0001867cb2863958,0x000f3a5af9ead942,0x000e99527c7a360b,0x0000669299225f30}},
    {{0x000378d02aded289,0x0003c0423ea0efed,0x00076140c21c9274,0x000f78ad1a14b332,0x0000f0a890144187}, {0x00021349cb6cb96e,0x00056d9c9076e14a,0x000e9750cf7a0c30,0x000eb4b264c96979,0x0000fb23ad7c9708}},
    {{0x00082f88233a37da,0x000d23f23abb42d1,0x0004b3734df9d345,0x000d6521d54ea368,0x000059fae532d7b1}, {0x0007515524ef218e,0x00007a73ae6b69e7,0x00058efc608d1521,0x00074e26beb85e78,0x0000aca7c3b8b78d}},
    {{0x000c9e891767e9cc,0x000a6db0fc3a5dec,0x000195eb1598acc5,0x00005382d1cca30d,0x0000094de8c7a92f}, {0x000eb3338b3392a9,0x00013886c546dc13,0x0000d496c04db373,0x000adde62bf2b9c8,0x00002f299eed9137}},
    {{0x0008bd479af2b8a7,0x000ea590b94dddfb,0x0009b3b12d8c5034,0x000cf0e1ced752cf,0x0000b36722ea39b4}, {0x00069628a0877b3a,0x00015bad064c4d30,0x0008ac446518bb7f,0x0006b03992b46ea9,0x000065fc30503fde}},
    {{0x000bc2015b83fd15,0x000dc269799522b1,0x000b535f20b2820a,0x00069a5142759c76,0x00006f2ac98f9822}, {0x00083169e636983e,0x000e591e55c80622,0x0005a4241aa4d2a1,0x000591cfdd294197,0x00007b55447387c4}},
    {{0x0003498722f42f3f,0x000a59410f413e15,0x00032a6354667481,0x0002956d7b04af7f,0x00006a645082d4e9}, {0x0000da5be5d8d302,0x00093df7e7583fbf,0x000d7c2be3abd8e1,0x000a000194d9418a,0x00000149bc9eb3d2}},
    {{0x000f986a073e3517,0x000f9b73f9e38de2,0x000a58bf2571610c,0x000b0af920fb7224,0x00003d4b8dd4ddf2}, {0x00030e4ce112c73f,0x0003bf36e1c67f91,0x0003453afe2dc80e,0x0005ac201a013e91,0x0000c59ce10e30f2}},
    {{0x0003b1cdc7f8928d,0x000ebc41452df139,0x0007451137f6868d,0x00053ce9613ed210,0x0000649aaa42f694}, {0x000b7ba1a932b30b,0x000f2a4924b83721,0x00040f1f33138c74,0x0003dd58146c6cea,0x0000e7f4ae83e138}},
    {{0x00085f185870b6bf,0x000b92eed3fa9528,0x000d2b635e2b8998,0x0007568a94e9d333,0x00000526592b1491}, {0x0008aab3be513b25,0x00045303376d3cfa,0x0007c72c989eae8c,0x0001f30e65c1f409,0x00005b94d4c0e401}},
    {{0x0003d066fe100843,0x00074d0b7004bb28,0x000967116b79d60d,0x000cb60757a89246,0x0000029e71f8c407}, {0x00065bff0dfe7d8a,0x000f7f471826dacf,0x0005753bb87557ed,0x000d529de1afaaf7,0x00003c27f0415370}},
    {{0x000c10c40e0ad658,0x000d03d36ac61fc1,0x000143c6a50f0060,0x000b87a02cab6659,0x0000aa0ac941392a}, {0x00077a9d795672d8,0x0009caada373a423,0x000f29a04260b72e,0x0002e8475833e9de,0x0000035e64a7ec99}},
    {{0x0001b1e50eb884d8,0x000fb550dec7d443,0x00015188fa1435ef,0x000fed29334dd65c,0x0000cd2d5a342204}, {0x00054e8f171c4219,0x000d2a2a4537bac5,0x000bde4f44854e54,0x000cf4c3773aace3,0x0000a962593e8aa2}},
    {{0x000a77a80d8d4ad6,0x00075f34cbc4dbca,0x00009e3fe02abb2c,0x0008ca980524452e,0x00006411b8d00213}, {0x0001764627b7712a,0x00023948a2b5cb5a,0x000858785cea3d52,0x0002036e6e748680,0x00000042eb925ac7}},
    {{0x000751674ece9ae9,0x000a512b2c44e9c8,0x000e88fccc205168,0x0002c75cd9811607,0x0000f9001ef938ff}, {0x000ac81e5a48ef97,0x0002e0109b2bb3fd,0x0008c3273e7e9d5a,0x0007b2dcb6ff8d2a,0x0000cc1bdbc8ee70}},
    {{0x00056fa2bf280369,0x000a9e2e674b01be,0x000c71f07ded96d9,0x000002b55134dba0,0x0000dd1195c38794}, {0x000266f2f86721fc,0x000adda42ae0dc28,0x000d8561fa395767,0x0008fd2270c1219d,0x0000d0cfc1b86620}},
    {{0x000bf27baf63ff66,0x00009ebc66252bbd,0x00081af1cacfa286,0x0007812dbb29b31b,0x0000fb9396e63aab}, {0x000ada1d38323f82,0x000ad4f13aa595b7,0x0001d791ee24a41d,0x000c0b1e03dfd84e,0x00007cfadee3c277}},
    {{0x000f91b24c3fdcf9,0x000dc39512d9d6c2,0x00079ea474581c15,0x000b3037480385b4,0x0000d036170f05a4}, {0x000567ff9990c1cf,0x000c52022e9733fd,0x000e053c243f4d6a,0x000e8d640b9aa656,0x000085f487e4d5f7}},
    {{0x00091898d9f31562,0x000dfbe0453c7472,0x0009e6b7f7af420e,0x0004b20e2b916673,0x0000164bef06f4b6}, {0x000b80fc51993f6f,0x000c34d3d86975a3,0x000ff3c930f61aa4,0x000b4918539af658,0x000059a8d10c4494}},
    {{0x00066e89fdfd1ee2,0x000e2e6e602e0282,0x000d5c751cb890ad,0x0005b84b04a46bd2,0x0000ce8ef41b6ed0}, {0x000a5fa420cfae5a,0x000f8b6e315d4386,0x000903ae604fd4ff,0x0004b04a393c9fe1,0x0000cd608fd28510}},
    {{0x000b3e82dc9c8f33,0x00059d7a2a568260,0x000ec023ab8ab819,0x000b4672639387f7,0x00002043db1d435e}, {0x0003a6c41ed2e7cf,0x00005ab1014aa9f9,0x0007dc38d75705e1,0x0004e061bd047969,0x0000eb648e51640a}},
    {{0x000f0f57c547a961,0x000d990237650041,0x0004510d6c34d742,0x00063c4132ff339a,0x0000408528595bcf}, {0x000a71c3fe658de8,0x0001c3cf64c2960f,0x000e6a5c2ae5ee0f,0x000e11651433eea4,0x00003984cde74fca}},
    {{0x0000003ac6f58504,0x000341671c32ea49,0x0002b8921facbf78,0x0004fa3c67b6d380,0x0000873d3817bc08}, {0x0000d0e2edff3bef,0x000ceefbd4439499,0x0008b941acf60583,0x00068f3529a5a269,0x000098b50bd525cf}},
    {{0x000a25873e60025a,0x00053855a627b0b2,0x0005a4f0d708e8e4,0x000b258de1632834,0x00003056505bfd84}, {0x00090d0a530bf0e6,0x00043c0c25a53dab,0x000f5fa79e358944,0x000b501d65285c91,0x000077599220aadc}},
    {{0x000decde86b39648,0x0003ad7ad0f350fc,0x000fe462f1844e2c,0x0003d39cc52142ca,0x00007a06c317b146}, {0x000867e4dc14e8c7,0x000ff41bcd37d80a,0x00032c5b0675151c,0x000653c449373f36,0x00005a57dc103d6d}},
    {{0x0000a2a7c0db9bfc,0x00011c2811b663de,0x0007ec267d1c9049,0x000b23256ba8b300,0x0000534d306792e2}, {0x00026c1d52004b5a,0x0007a3f4dc127efd,0x000d195c762760cc,0x000221924b8c8b14,0x000026c7b7eb7f67}},
    {{0x0002f18ed29ebf14,0x00098c2b10a9d4ab,0x000a74882a5d041b,0x000d5bf9c651a0c2,0x000088a4278579c9}, {0x00051235c715721d,0x0000e9dced4d4ef7,0x000ee67bd5212bc6,0x000d93da86c0e051,0x00006c0ebc2e5127}},
    {{0x00070438f33a86ab,0x0006a9c27c7efe20,0x0005fcfb1eb8742d,0x000157f616499b3f,0x0000133c81b68e98}, {0x00010f66856c8633,0x000cda9e424d843f,0x000454d474e9ef7f,0x000d084addbbba56,0x0000f1d7dd5fa3c0}},
    {{0x000d7b41a5dc9f16,0x0009ef12f95203b7,0x00013189c2fc91e0,0x000aec2347a9cef1,0x00002719ff12516e}, {0x000d3b82a3b61af6,0x000df7f38b308736,0x000bf80445b12e06,0x0000c743ba9b2725,0x00005ba45f8b88ed}},
    {{0x000261f56f9e574d,0x000455263e563df4,0x000e18043b012748,0x0002a907208773a4,0x0000ddabf1b7aae1}, {0x000554210f1c434d,0x0002ff3445d34069,0x000445f11b6f9f3a,0x000dae4831b39805,0x0000edfbc2a2b1d5}},
},
{
/* digit=12 [{1,2,3,..,}]*([2^84]*G)  */
    {{0x000c554483b6753e,0x0006801db8f9d305,0x000886fd9162b06d,0x000476456139bb92,0x0000ea4a8915ea88}, {0x0008d47007a48524,0x000e4818a4c5c808,0x00015a22cdb69736,0x0005f81ca589aaf2,0x00001d936a1d6f7b}},
    {{0x000ab2dcbd28cd7d,0x000a1162cfc4011b,0x000cc1af050d89ce,0x000063b3e8402465,0x000083d0e91f2d65}, {0x000f946464985316,0x000f0b6261148253,0x00038d8cb0463eb2,0x000a2eaf46232053,0x0000d3acff868021}},
    {{0x000dd5140afb7993,0x000bd8f7f093f0f0,0x000c26e525fd4cce,0x0006ac8e6399e015,0x0000a1f765c42a88}, {0x000b1ca956564f4b,0x00094bcd0652818d,0x0009c185081d8880,0x0008442cde2c9ec7,0x000025a44064aecd}},
    {{0x000f5f559bf4a74e,0x00050b61dbdb8ccb,0x0007c812ac18b374,0x0005a3f24ba94aac,0x00004f5dad1bf4c0}, {0x000b7e537d97e833,0x0002de512f6471df,0x00071b5884053ab5,0x00043d89f56b8b9d,0x0000c58226e7c64c}},
    {{0x000f0f17bc532082,0x000fed58cc574ab4,0x000e10b8d86bc64e,0x0007d2b3542fc362,0x0000a757378d0112}, {0x0006ccd629ef57cc,0x000f7b5d9c080f6f,0x00088029c11069f6,0x0000bff2e914dc87,0x00000558c2f6e839}},
    {{0x000da9445a23fc09,0x000605eeb8c005a6,0x000fff46275f912d,0x00078b2667155c28,0x000052569c27476d}, {0x0000ed991150c753,0x0003d9531b755efa,0x00075e9f483c52f1,0x00031dab94d69b7c,0x0000df793c3e38af}},
    {{0x0005af0c0e6e3ad8,0x000fa2bd1fd197e3,0x00019540b108b614,0x0001cf02f81fa984,0x0000838602012d96}, {0x00015ecd5143acca,0x000e93ececd5fb07,0x0004ae6741960659,0x00087c273955714a,0x0000f440efd280a5}},
    {{0x000e7c32fd3348a4,0x000777077b4c8efe,0x000fe73e11c88faa,0x000b96ecece59c8d,0x000009715b464a77}, {0x000aa5d14df28d16,0x0005301318185b7c,0x0005350981bb9857,0x0009644ee837ada5,0x00006a9819ff80d1}},
    {{0x000a414f9b65e700,0x0008351d28b72fc0,0x000807cb5eaeea1e,0x0005c55f09163a37,0x000086eb6b36bd63}, {0x00044698cc2a4ea8,0x000466e5324dbb10,0x000664773c425160,0x0003514ef5e7b9d3,0x0000bfc6b8578654}},
    {{0x000f3a37768912e9,0x000fade19cf47741,0x0004368c97f7e0cd,0x000b78a509039326,0x0000e3961c3955f3}, {0x000d1b5709e33830,0x000bcb212af98fb2,0x00071b5c07cebb92,0x000dab556ee7dd40,0x000022c98a5e5d55}},
    {{0x0007c40f3d55f440,0x0005850ab4bcb8d7,0x0005dc2904c0ecd9,0x000fc094f9552e74,0x000065bde9a45b12}, {0x0001b213e07d2a05,0x000dac491152e816,0x000bbb468a73324f,0x00022eaf5017795a,0x00000333c55c0892}},
    {{0x0002fde94b3766cf,0x0007174a526e10e3,0x00046da5e56aac35,0x000ac2d0c1c51f5e,0x000035efc2472eb4}, {0x000da0a323be075b,0x000717ec17895a91,0x0008ad7c571d2b3c,0x000bf89dbcd26f41,0x00006d4343245d6e}},
    {{0x000dc2eac62fb9f5,0x00084e51c141aa70,0x0009798c2bb7e6c3,0x0002dbd11d4a05b6,0x000074f72cf5e639}, {0x000fd435dd15c827,0x000425e3562b0e0d,0x000886af23f9d33f,0x000b98eee1982216,0x00002d9339f90269}},
    {{0x00046ab0a3564848,0x000023087b4fdedc,0x000aa974dfa3f8b2,0x000c5683df032518,0x00008d37e3dd003e}, {0x000b497bcaf07eb2,0x000a80cfce97a4ae,0x000e8c971e5379fe,0x0009ba740afedac2,0x000087c1f6eafee3}},
    {{0x00083a26aac344f6,0x00074201b2856380,0x0007578c50361026,0x0005b40a8a67be24,0x0000605b8627889a}, {0x000aabd30a19439e,0x000ca53f88dd0bbf,0x0004a3ee818767c1,0x0006663ec91f08b6,0x0000bcc3862cf387}},
    {{0x00084ddfe58cda46,0x0003b276513902f5,0x00002aed28befe9b,0x00072ae88c3c7ae7,0x00004c8c2205288a}, {0x0001cb844e502e5a,0x0000d9ae644c5df9,0x000c1aa51015e574,0x000a6be30714bc7d,0x0000f41ed76cc10d}},
    {{0x00033bb53beeec19,0x00007eefd1662fa0,0x00011a9bf3b2cd1d,0x000d5a31a0c88f70,0x000032688031e363}, {0x00016c08ae3a3eca,0x00015b3281e6f092,0x0008a75e39d7d5a3,0x0000909972d7b786,0x0000c65def428795}},
    {{0x00005874e890e300,0x00041d95ddabcf98,0x000368cbf916f257,0x0002fcdd589ca455,0x0000f2d91af1373c}, {0x0001207d3f06d40e,0x000b5b5367021a75,0x000f49339cc99d98,0x000d3d50f580d82b,0x0000a7749f8b2793}},
    {{0x00086dac65846f84,0x000b8b184a18be90,0x000f50dfc9f9163e,0x000bdfa618f3c6e4,0x0000afe515af4887}, {0x000e16cfa60c51e7,0x0009ee647322d93d,0x000691d42a467932,0x0002e56863b1a893,0x0000c8721a2b5b90}},
    {{0x000ee5987897056a,0x0006fff7338cc84d,0x0003cd0a29f7d1a7,0x000f4c1eeec55391,0x00008625bca9aef8}, {0x000f0fe0533242d8,0x000ddebee7314e38,0x00034542be2dc785,0x000311e6d17be942,0x0000a2343b6a2094}},
    {{0x0004301cf477c5cd,0x0002ab6a3d1b7d53,0x00030cd8103b9cfb,0x00095e6e96f2ce03,0x000038fbea44936b}, {0x000b90a008acc54b,0x000a8904b3609016,0x000c686bd1acda20,0x0000e048114fd494,0x00005ab0f4d4d8f9}},
    {{0x000bdef90ead4f46,0x0007246d293b9ec5,0x000303573d9de112,0x000f45aadc6dc3d3,0x00001af5d644db85}, {0x000f4601e63bbd49,0x000a087a714b4af8,0x0000935870f2f324,0x000f960a6914e009,0x000012ad683418ae}},
    {{0x0003354792bcf5ae,0x00007f41be3c88c1,0x000c142b47e1eca6,0x000ddebdc8cbf3a6,0x00008e5a41a3acc1}, {0x000d1ff364d640ad,0x00071b7bbff3b08e,0x0009b246ca485c01,0x0001f1e241e73b86,0x00008915bc9ac6a8}},
    {{0x000cb418d14bdcd6,0x00009b819b92ec5f,0x000ecaff2142a74c,0x00019578fa6a421a,0x0000cda9a55a8acc}, {0x0006359363a78d5a,0x0000ebce5d6e8f57,0x0005c404f6dc243f,0x00056438b0c481d8,0x000021f1152ba645}},
    {{0x0003438f3e2fc0c3,0x0002778ec5d0bef6,0x0000bab2acfaf639,0x000a613040995c34,0x00009c33c69e3d8f}, {0x000a7896b97bf0fb,0x000d924183025e51,0x000de7e95ff5c9f9,0x000871ae0c7dd05b,0x000034587b2ddc5e}},
    {{0x000a79da8f271b1b,0x000381332a91ce35,0x00037e9d38ecec65,0x0005eaabd737de2e,0x0000827fb571e37a}, {0x0002f6167f95c9a9,0x000a0030b5abafa6,0x00086b6bf174705e,0x0009211f763fc83d,0x0000ded86cb103bd}},
    {{0x000f7cf342886a76,0x000e724e6bc2322c,0x000265932e8929ba,0x0005ba669f694ca2,0x0000767c25712d5f}, {0x000c9821f6a99f7f,0x0005f36eff86ec2b,0x0005ed3486fe21b9,0x00084100857e6f4b,0x00003ba09b776464}},
    {{0x000a956c6538d32b,0x000ce0ebaa99bb77,0x0006e54dfc273705,0x000ca26fc41d2862,0x0000ec59f9c31c58}, {0x0005dddbc05f1be4,0x000eabd6ef105f32,0x00011aa76a1b687f,0x000ce473e0cb49ae,0x0000f0197e08a6ca}},
    {{0x0006580b23d6fb8b,0x0002f22ce000c4dc,0x00088dc5c9518521,0x00070c22efb775fe,0x0000e08eaf386d96}, {0x0000f9e5bdd09ac2,0x0000337c16dba3d8,0x0000363489849e43,0x0001c3c9be67c37a,0x0000d611ceba3199}},
    {{0x0009d284701935ec,0x0004f56adc223b4e,0x000d1eee70422ff8,0x000e16a6f16e99eb,0x00005bde8bd944aa}, {0x000c5e0516c8252f,0x000bdb9bbaf3e0fa,0x000b35adb2dccf13,0x00031f937c0cb137,0x00004bea07b8f8ab}},
    {{0x000bf359cf0ad3be,0x000eb4ce9011d0d0,0x000eac2cdc3b6101,0x0008c802272d1fdc,0x0000ce74ad8a8b66}, {0x000e8fac38d80fc9,0x000537f10c1a619e,0x000432c10ce4a266,0x0002836eede88f40,0x0000bf1a37e07a03}},
    {{0x0002775c8d90f0f3,0x00029d5b535f043e,0x0009d75c2586f7e6,0x000648a06f699957,0x0000735f63f9f6b8}, {0x00040e7726af474e,0x000bd520fc28421c,0x000f156aa1f46680,0x000b48b41f5251e1,0x000071b7c6df2177}},
    {{0x0001cfc4cbfca31b,0x000f57ed1f1f84af,0x000d23dc50912828,0x000085f1b1048a1b,0x000002a9d0f5f8e3}, {0x000caf1497eea594,0x000546369358a96e,0x0007ce467f4e2dcf,0x000867022d181302,0x0000af96b3e41c15}},
    {{0x000872dc000aeb4a,0x000cc793dc01eb7b,0x0004d8c005622aa4,0x000edbf05a0f117e,0x0000cda49f07a17d}, {0x000c8c1f58a0f7cc,0x000e8d9b661613ce,0x000639e32b5f0a90,0x000ecad3e495fbb0,0x00009ea83415cbfa}},
    {{0x000d0c201f5ce32c,0x00016577157dbc72,0x00073d070c744357,0x0002426c39bbf87d,0x000042537dcae3af}, {0x00021ce869d0da00,0x0007377f351b6617,0x000d8fe45a48f43b,0x000cfafa73e6ae19,0x0000ed3189970de3}},
    {{0x000ae762be466e04,0x00021e7720f0ade5,0x0002843c06a19691,0x00013fc0033576f0,0x00004a129decc0c4}, {0x0008e8867fa59016,0x0002d5e9a56b0dc7,0x000237f5a534e8d8,0x000fa748cb4f9d00,0x00005d9983dbb9d4}},
    {{0x0007d12937513371,0x000403b7cbdf14b2,0x000bcfac2b7fb8e8,0x000d9866bfdce003,0x0000db5c06aff71a}, {0x00031018effa29e8,0x00004fbcf727d6a1,0x00022a8553be0ad9,0x000bf7969cfb64da,0x0000e985eacf416f}},
    {{0x0008e834cedc78a2,0x0005c97f5478967f,0x000c186a2a467c85,0x0009469dee8aa6cd,0x00006d837221b315}, {0x000629dbdec3f949,0x000478eadc28ad1d,0x000bcf7c9c16219c,0x000b53383eac76a4,0x0000c5ec8b33a0e5}},
    {{0x00007c0f0e12ca94,0x00018bf91307ba11,0x00071d9ab1a24d3f,0x0007747bf130fd05,0x000079c81e5f13b5}, {0x0005fa3e80924361,0x000c57f2b1fbeef3,0x000248ba50a359ac,0x000af11a98df62ec,0x0000363f004297c0}},
    {{0x00019cde83118148,0x000e64cb25d0fba2,0x000c4ad7b162ac09,0x00058e222b481ca1,0x00000cc2a53bbb20}, {0x0002508860462ab2,0x000b158a37864da9,0x00086722e4f10c86,0x000d14158a829423,0x0000e4fb785f8862}},
    {{0x00027d333d753d0e,0x00099a2600a68bd8,0x0002fa817222a7a3,0x000b8713381a4c58,0x00008f9cd717634e}, {0x0004b7b30e02de62,0x00075c3ea937f197,0x0002821c922ac428,0x000a3c40e3d9b177,0x000003323a2e093f}},
    {{0x000fc05a7e4d4e55,0x0008f1cefec7348f,0x000192a2b46ee68b,0x000353c77d99e99d,0x00009d818e97658d}, {0x000392d3e49f6104,0x000248caf3c8ec9a,0x0003023ca2d7b6c1,0x000b2c8a0f354f8b,0x000074921f13eab8}},
    {{0x000df76d07f39331,0x0003d350ece61581,0x00081c9e57d42e69,0x0000f9cb516a8c9e,0x0000d6335e12edb9}, {0x00090961506c4c3b,0x0005bc7192868ceb,0x0007bcc0497dec67,0x0002067339d0df2b,0x0000cdd06eb70f33}},
    {{0x000f7ed789462fbf,0x0007ef672b19b20b,0x000e33cd81a16b1f,0x000f12f89df2aa89,0x00005dea3af5b77f}, {0x000838649cd0da1e,0x000c5bfcd2a2c5be,0x000c32ff1d3c1e34,0x000f06839599cfa2,0x00007239d0120da8}},
    {{0x0000e69d0c2b5ec3,0x000b79db1e73bda6,0x0008b9c4a330f8b4,0x00035cddc5f73aa3,0x000006f789e69775}, {0x000bfed204c713d0,0x00093bf9b2e7bd72,0x000422f0f0282a2f,0x000a48b205e175a1,0x0000d820622b824f}},
    {{0x000e515a23d90057,0x00022d89b47f4c3f,0x0000548b05e86278,0x0000426dc052b635,0x00005bef95a0b629}, {0x000089b8f8a1e0dd,0x000c7a412f79fcbb,0x0002f0be65d47bba,0x000090db03dec5f6,0x000085fb777a8161}},
    {{0x0007aaf19ae92fdd,0x000b5b9b429c59f5,0x000ef392e01cd435,0x000166a7e522b3e3,0x0000ce727a8ae2ac}, {0x000a5bed9bc9a546,0x000c27594ab2b1ac,0x0008e070e66e8389,0x0007d19f80cafd14,0x00005a8fbc95dc3f}},
    {{0x000cc3bbb7c912f1,0x000bff31beae296c,0x000fa0357fab8a10,0x000dfefdef6e8a9e,0x00002f8fc87142a5}, {0x00042101a914d6cc,0x00008a1ca0911556,0x000418ad615b500e,0x0002d61e09ea4513,0x0000e1df01fe2923}},
    {{0x000e5cc99cf67fd2,0x000ce5fb36c081a0,0x0006e1396618f51d,0x00059123402398bd,0x00009ecfd4e3d980}, {0x000e341bff7f018d,0x000c1f6950d1ea13,0x00091e965892d500,0x0004e189b9fe1910,0x000072842d82d9d7}},
    {{0x000cf638f90465fb,0x000755cc7173d4dc,0x000b1dada810c125,0x00004d9dfedee32d,0x0000d16f02f61958}, {0x000aa8044614721e,0x000015fccdbc214b,0x00003a0873eb45a7,0x000b58c3b0135086,0x0000180d15fc5f69}},
    {{0x000a048c4901672a,0x000b2340b7ff98dd,0x000caf804fb759b4,0x00075f5cad446960,0x0000319c7e6dceb2}, {0x000b09071211838a,0x000d7c9c2382267d,0x000bf6ab01dd36cd,0x0008da89262c392f,0x000032c1ea49aea1}},
    {{0x000deaa5ca6ee65f,0x0004c1800a9c59a9,0x000680184e358c6c,0x0008d4ad86de1415,0x00000b504795d3b3}, {0x000795b139b52e54,0x000ee69f5a0fce3c,0x000b814ff6a9423d,0x000cb742a66e5645,0x0000032d10e19448}},
    {{0x00072569564d217a,0x000429fd0889deee,0x0004319cdca4ef8f,0x000f3e3b6ac95065,0x0000f32517aa4f71}, {0x000b21b117693d29,0x000183555154e948,0x0005077940c71c7c,0x000c0754bdaf53be,0x0000cc60c2cdf8eb}},
    {{0x000b43f7dce0b1b4,0x0009c72824968563,0x00065de307f4a3b5,0x000b7842c8a92f9e,0x00002c0e25912368}, {0x0004adf586027566,0x0004f78ce7e8eca4,0x000a94b38a6951fd,0x0008f5eaddabfb1b,0x0000f4735e8fe842}},
    {{0x0002dc3c7e725420,0x000d3f88fcc2867c,0x000ecf5483ea2af7,0x000783793f2f306b,0x000045bad8bfd57e}, {0x0002ca4b36818218,0x000835b27feb5f63,0x000453187115ad6a,0x000070eab7ca7b7a,0x0000719ffe4782c5}},
    {{0x0000593929af0d40,0x000e5664a3d91ab9,0x0001e9eb544e57b3,0x000d2f624b4757ae,0x000032347a13f3b4}, {0x000d1da32f451911,0x000266acc7aa2e45,0x00091a4d237ee7c0,0x000dc21ed6afba7a,0x000010b7c3ccaa69}},
    {{0x0001d7c699cfaf4f,0x0007ca6c922936b5,0x000449a44405d498,0x000f2f24d9456a6c,0x00003f6e5ffdbb14}, {0x00037c452dfb4b57,0x000926a4b56d7971,0x000a9f7ea115ed0a,0x000d5afaa27d8ea2,0x00003adc089d4a10}},
    {{0x000d5a0f6239d756,0x00018c596b9e37b8,0x0003af1688d17ce9,0x0005a37b04b307bf,0x00007aa9f6053a7f}, {0x00074342f5e14850,0x000fbae0c42ca37b,0x0000e1ec491136fe,0x0000eb4e610854f1,0x0000f0ebf7930ca3}},
    {{0x0007b6e75a63ab1b,0x0001d7cbd366e9fe,0x000fda58c355abe3,0x00062d68e49464a8,0x0000bcb1280d5e57}, {0x000777d197806999,0x000a9ecf9715de06,0x000f6afd589c8aee,0x0004af4e62d3ff71,0x00006b88426b88bc}},
    {{0x00074d1d902ef8eb,0x000cdb0df8d05362,0x000e73dab4f8bd22,0x000917798e1bb263,0x0000747ec50844e3}, {0x00053692d52a05db,0x000f6ca8d9b29727,0x000f02477bc17e87,0x000f3a1726632e3b,0x00003ce08d4ab050}},
    {{0x00048d2262daaba8,0x000aa837e39f0f7c,0x0009320f1da31454,0x000ea364915f9041,0x00002e8921d77b9b}, {0x000423a958563826,0x000a3497921fbf0a,0x0000461a0e93409b,0x000ec5b86536c442,0x0000775d4ee0d067}},
    {{0x0004ed2cae04d7ad,0x000171ad7cb36930,0x000d2d311bc08ed7,0x000f695e13619e36,0x0000d2e0eeab2d2e}, {0x000ee6772c62de91,0x000baa1b52e55366,0x00004bce2a244410,0x00054fc30c34b0bc,0x000005c73893a90c}},
    {{0x000cccf4a1a0cca9,0x000722bdc2035d63,0x00057bd07cf346bb,0x000f316c79ae4fd5,0x0000ac63d30daba2}, {0x000ff39d838e4cd7,0x000204741c2e1f2e,0x00069d840c3461d8,0x000a84505593db6d,0x0000741dc28c944a}},
    {{0x0000876a8b27f44b,0x0008bb19870aa30b,0x000f8e9ec31cc2ec,0x0004c4e60731153a,0x0000c55b52b0033d}, {0x00089b1ed9e1929b,0x000e314409183cd1,0x000e19b9a4f6719c,0x0007dd490b7456b3,0x00001a8b428feb17}},
},
{
/* digit=13 [{1,2,3,..,}]*([2^91]*G)  */
    {{0x00023862936ccd46,0x000c9f3bb8a5bfc7,0x000ca23157985ce2,0x00081bc9abd0a0d9,0x0000af5b9895adc3}, {0x0005faaee4832a45,0x000d59f64358253c,0x00046da055a2f27c,0x000f568dc06afc75,0x00002ba011d7eeb2}},
    {{0x00055fc1cf25ca24,0x00020e1d348934fe,0x0002536cb0ab57ca,0x000233ee745fbe8e,0x00003e16abce68d9}, {0x000e1c0522422409,0x000a5979e6309e7a,0x00066b196881b4f7,0x000c1edac5fd108b,0x0000142c6726f6ee}},
    {{0x000c2137390618df,0x000be970f27a0fee,0x0002f4c961a17241,0x000f8a198a977f70,0x0000195907ddcf67}, {0x000f379501c8471f,0x00059ed6d515c9a1,0x000bb63a198210a5,0x0001b9124b243403,0x0000ed746bd02b9c}},
    {{0x0006e74ded67841b,0x0004cc8fd37f409b,0x0002803b1af55986,0x000c3bf000b91399,0x00007ceb09bcb37f}, {0x000f8d459310a1cb,0x0007593dba573a77,0x000ed294ac4fff32,0x00092052bf2f7fbb,0x0000fe022e7f7a32}},
    {{0x000c7a6ac040f2fb,0x00055a54b073122b,0x0003e7acd6ce751a,0x000107d66c28518c,0x00003aeca2c1f0ec}, {0x00033bbbdafae2cc,0x0009f8fa7af36884,0x000dd647c01943c3,0x00009696d6c87579,0x00001c20d14c8db3}},
    {{0x000a61a0c68f6032,0x0006a9123a83491a,0x000bd0c5a9dc2dd5,0x000db59a99946a29,0x000081228cdb3c43}, {0x000cd2ebd0599303,0x000f84227c8ed033,0x0009053e94a3bae2,0x00069f434a9ed1b1,0x00002474f03f1410}},
    {{0x000126dbaaed16c2,0x0009899463a3470c,0x000eb820a2fb87f6,0x00066fd977557dc9,0x0000a9950295b8de}, {0x000646dbf257d07b,0x000e7a4e19ec84a4,0x0006a7eaee3f42b8,0x00025c05ee05cfcd,0x000057200c018815}},
    {{0x000d1bc968cdc161,0x0009f62c0803d083,0x0007eca12854bc1a,0x0008683a5785328d,0x000052551f11c77b}, {0x0005bb2ee4edb660,0x0002b2b5a388ab4d,0x0004ac3bf9559546,0x0003650232668dd4,0x0000b1b0d76d1f17}},
    {{0x00004047d03bfb04,0x000267ecceeb6096,0x00091101feb19ab6,0x00010ef35c6beedb,0x00003595d5f45735}, {0x0004e8ad3b49694d,0x000206d570226401,0x0007f45f06b32f3d,0x000807cfb7433dee,0x0000c15e03794afd}},
    {{0x000e7a6211af3d16,0x000c95e02ef4989f,0x000bbdf2c96b6185,0x000b8ad9fd10ece4,0x00003291adf91780}, {0x0003b209aa3794c1,0x0008e8ddaca35358,0x00074558fbaca474,0x00087d9bbf1f277d,0x0000f61a073f7b35}},
    {{0x000d8adb85ee3f83,0x000ebd78bd46cfa0,0x00011af45006aa9f,0x000c03cb789b856f,0x000038718b3de225}, {0x000b87d218ea96d0,0x0008296dd64f240a,0x000a55d762afba77,0x0000c106f6b48540,0x00001637a1067f29}},
    {{0x000fe903a2ddee0b,0x000c2147304ab5b6,0x000bce46578683be,0x000529212a7403d4,0x00000a0c11ee7628}, {0x0002eeb8c98226d4,0x000acd7eace9cfb7,0x0007ed1f6bef5b8a,0x000c572a94bfb860,0x0000fb6e6fd9f827}},
    {{0x000129845c7d39d8,0x000c08fc8d104a0a,0x00091c5df9c60f44,0x000c84addd4d5bba,0x0000117fecbad4ea}, {0x000e5b606f925139,0x00040714a55c0cef,0x000e33820c14e7e6,0x0000982da6e9998e,0x0000df370032e21c}},
    {{0x000f523358513503,0x0001fd64adfb3997,0x0006889ad5e8f89b,0x000efd415f1bcdca,0x00000dc5193d322a}, {0x0006d6646cc33bcf,0x000bc53d4982b948,0x0008f8e8fa9ce266,0x00054acf5820c0d5,0x0000307c2eb0ed58}},
    {{0x000613f329e775c2,0x00074e8d77c0eda9,0x000f3edcede373e6,0x000303ea32e7c5f4,0x0000ace4b9dce770}, {0x000d62a55c54561d,0x0004408d9c3361f9,0x0005d18ac4c51c97,0x00082e094177a277,0x00004c611cafa47c}},
    {{0x000f298db093d970,0x000d8fc659552b85,0x0004088b59c6d6fc,0x00017f0a2d06747c,0x000086eba0701cbd}, {0x0003e9934facc02a,0x000b5a33252cc71a,0x000700d0a64d5a86,0x000a74776c01c506,0x00000d58cf6a3492}},
    {{0x000e24841127be4d,0x0006109c01c62f85,0x0009d1e24f0d7950,0x000f9906c5f8998d,0x0000d14baa86e1ba}, {0x0006495cd2b7045c,0x00079b660d67c95c,0x000b91fd538bc207,0x000698f1bfde9d01,0x000069d46f82ef5f}},
    {{0x00054cb598765316,0x0003c6ee2235eecf,0x0001d05682fcdb79,0x0000cf6e6100f9ff,0x0000dc6262cd1fb3}, {0x0002721130ab0425,0x000fd66b83432c4b,0x00068d04d701f922,0x000c56e867326ed1,0x0000fa2450fdaf47}},
    {{0x000e18b2b572c025,0x0007aabc185629d1,0x00011115af0a8c3d,0x00059e153c5e496b,0x00006571350e5f65}, {0x0000804bcbbda06e,0x000ba4057dba77c0,0x0005a19dc3818e66,0x00007db6d31ee3f2,0x00008435030e7d57}},
    {{0x00046d989cf9775b,0x00008bbdbfa6a9e1,0x0004e3b35a8bc449,0x000972cffc49e7a3,0x000053ed79153d43}, {0x0008b080e14ff257,0x000ace79b7fe22f9,0x00059f0939c733aa,0x0000aeb72dd048de,0x00002619ceb8b79a}},
    {{0x0001e4f65ecf7496,0x000ae8ee251022a3,0x000790a0b8ce447b,0x000e5b7dc58d2831,0x00004c7c03b41e33}, {0x0008b362b8088d3b,0x000cbcb87bd9c6d1,0x000cb48e67cf5c74,0x00069f85efc38c53,0x00003fa36fb3ee0e}},
    {{0x00043ceed8105788,0x00090734b644bac6,0x00036bb8ea2711c0,0x000b3810041eb459,0x000093c69a1b4b83}, {0x00084710540e3d01,0x000d719e03fd4f77,0x0005e622babf321d,0x0007b11922ccf87d,0x000096e359a83944}},
    {{0x000fc5fc73da9b5d,0x000b1595fc9ab291,0x0005a95066904c34,0x00015959fe032bdc,0x0000b4b92b11f12d}, {0x00034add676f593d,0x000519f1f0786c3b,0x000697738b1c970a,0x0009584fb4963dc9,0x00001084921d81d4}},
    {{0x000b5da661dacece,0x000f6b0cd23bd2f4,0x0001cb076a96cfbf,0x000ee755e6ddc3ce,0x00006cb5574c3f61}, {0x0003a2123b371d00,0x00074a4a55ca4cdf,0x000b8d605f7131d5,0x00082c751d8514b8,0x0000089e6493eacc}},
    {{0x0001884e243e59de,0x0008f13be7d12276,0x00090809ee25d4f7,0x00092c13560a056d,0x0000cbd0fd7048aa}, {0x000c7cf11455b365,0x000880bcf192c1c8,0x000ee71e5bebb543,0x0001694d7bdb0baa,0x00000e46da8bb58a}},
    {{0x000ef46c771c87f8,0x000f7f262a6e438d,0x00050eb2f306408e,0x0009c80d5cc4d430,0x0000385ce31c91e8}, {0x000059abc1a67c19,0x0002e387ea4cab0c,0x0003e03c8b9bbf51,0x0005c84742501cfa,0x0000918e418e3d1d}},
    {{0x00022bbef09486e0,0x00010f5c122211d7,0x000b2de7adf0502a,0x00049b5ef8799064,0x0000cd147024c20b}, {0x00090d67f2d70c08,0x0001cc8fbaf0cafb,0x0001547cd4a1a267,0x000146a52fc4ab4f,0x0000fe8ec3c3592c}},
    {{0x0007c5d6d28ee3f0,0x000c1f5e25a2d30a,0x0005a067148ab16a,0x000b0e3e550cbb99,0x0000cdbad202b2a5}, {0x00093875ccf1d8a9,0x0005756ac2a6bcdb,0x000720061b8c60e4,0x0005ffd19c95c274,0x00006cf02b509a1c}},
    {{0x00091e12337f16c0,0x000c7393588f049a,0x000c7530b5c0408c,0x000e8d167beb1eb4,0x0000bb3b2a2771f5}, {0x0000d4b2f53140be,0x0001dd263d66660e,0x000799cccb650354,0x000900827c699d37,0x00001ecf8af970a8}},
    {{0x000b005909514a74,0x000ecbe20fc8996c,0x0008fe96ae8999fe,0x00053c02484ea215,0x000081ece97b1b2e}, {0x000b646f679d3fed,0x0005b8da2343f2fe,0x0006cabdc877b5b6,0x0000406a1d29230e,0x0000aedcbd3b6bca}},
    {{0x00043b54f4b39c27,0x000d249a5720a07d,0x0002cb9000f597f6,0x0003ab0ac7a0dc36,0x0000fc9c13cdf3e6}, {0x000c0eb22fd82d5c,0x0003b8a81a1aedd4,0x000364a7c0e3f20e,0x00046fbf635e9939,0x0000c199b407168e}},
    {{0x000014cc44058054,0x0004050153cddf02,0x000dba3274172b05,0x000f0217ddb34198,0x000092ae38e923a0}, {0x000179277af42fa1,0x000c90d55c033ee8,0x0000a9f8725ae26f,0x000fd2debf1b8171,0x0000ce7e032b9a99}},
    {{0x000a44861b8554c2,0x0000a3a94aeb35be,0x0003e71fba83aa07,0x0001d959d8dc768f,0x0000eb913a4c91a2}, {0x000e183a28b0b33c,0x00088becfd84e460,0x000c958afe20d5c9,0x0004b5d299882015,0x0000649765aefe9f}},
    {{0x000230fd8633e864,0x0001f08ee9e87f37,0x000e6f193bf5b4b2,0x000cde4fcb7532ce,0x0000104b82017ce0}, {0x000132f59550b517,0x0009ea49ea36c092,0x00091a39ec7cc727,0x000b70bfe7e175f2,0x000021a2ab8b1372}},
    {{0x000eab9e1005ec21,0x000f75e979b06cba,0x000c6a4d8a9df400,0x000a67cc9a2af77f,0x000035cd470f6031}, {0x00096537b57815e9,0x00097e2741ed2894,0x0009a6fac39520fe,0x00003d6cc06b9003,0x0000eee76b0b2e06}},
    {{0x000f7b48f6edb04b,0x0005a929e3038237,0x000f7857536e7673,0x000901ecac573596,0x00004eb199d3fae8}, {0x000d3cac11a43ab4,0x0000d55fddc2f291,0x0007aa2635d37480,0x000ab944155f4673,0x000043238379f1ee}},
    {{0x000de044927b3f1d,0x000241bc54ae6068,0x0001082ef75dcd95,0x000d7d5dae8d8aba,0x0000eb60878f5e1f}, {0x000c905f7e55fe92,0x0001e240bd8a7772,0x000081d2630467e4,0x00059a6904f58040,0x0000ecaa62c1a4d8}},
    {{0x000e9f68575333da,0x000f00ecfae86bca,0x0009f8c83e13f2bc,0x000c5c3e371a2ec9,0x000037a85cb421a7}, {0x0005b5a329bbed02,0x00045419c8fd74f1,0x0009823120e28310,0x0007e3cdd91afbd7,0x0000839b1b682506}},
    {{0x0006e9d3ccc341ba,0x0002150f316b25f3,0x00080a38e4c7c7e3,0x0003c01f7e4d50a7,0x0000c3ea0d40f57c}, {0x0001c7b30f55321e,0x000e7d20d94bdaea,0x000a029fadf45df8,0x00097ee167f6b768,0x00002aa6cc9459c7}},
    {{0x000c17a91f1ba0e5,0x0009787593f0d015,0x000f9ce851544d29,0x0000a7d6fd2eac07,0x00006e42a2d03161}, {0x00047f0cf39d2dc2,0x000e394ce9aef618,0x000c79ad7bb38167,0x0007952cfa312fd5,0x00006e9508b6606b}},
    {{0x0004a9337b6501f3,0x00038724b1274086,0x0004b9735e20280a,0x0005a7b1685a2355,0x000049e5df053c39}, {0x0003d8976fcc51f6,0x000f211285be64a1,0x000a5a1dce61af27,0x000534f6c0f84385,0x0000330e4e187016}},
    {{0x000e341cd1abcafb,0x0009212e247ca60e,0x000d11cf4928ec27,0x00068275c242a86e,0x0000701b7f29cc07}, {0x000113f0cb2d0c5e,0x000a0e15728ff118,0x000ce069dd37a910,0x000e33fbaf062392,0x0000da9bf4139bfe}},
    {{0x000d893ecc8a3843,0x000aee3422fc03c4,0x000bc5cc45125f34,0x0003fa03d850b732,0x0000d9db328e612b}, {0x00093a198c9fdc42,0x0008d59f8b1b219f,0x000cf49c0b2febe9,0x00075e07a055d8a4,0x000070db58a14b84}},
    {{0x0001b49f9f74da4b,0x00079c277b30b6ae,0x0007a713eb7573ce,0x0004bdf55e41397d,0x0000c4c19bd84865}, {0x000931c026a86997,0x000de2bca5cf171e,0x000656b2300e38bb,0x000d5f65e8930d8b,0x0000ceba324ca80b}},
    {{0x0000f392145ceee1,0x000cec5519c0f83f,0x000ccf35a80091ac,0x0003f61fdd589fd8,0x0000aeb32670044b}, {0x000c35391cc68921,0x0007d7a227dab6a6,0x000a75a4bbb2c563,0x0004940e0441f13d,0x00000acf8254d41e}},
    {{0x000b7c2475bc8687,0x000275d5d3d4a8e7,0x000998b4c20aa04c,0x000a5a3f2c0804e0,0x0000f72faa30ab18}, {0x000cd37890ebf796,0x0000909c43568186,0x000ac20ea2015287,0x0002acdab79ef3d0,0x00008e23170d603d}},
    {{0x0001b7430856e702,0x000e326886326e48,0x000c9d6b951f2e59,0x0004074d31e623cd,0x0000e0b17d35a649}, {0x000830e9a2c52388,0x000c4af19a13dffa,0x0006e6405881b51b,0x000b8fb31e1b7bc8,0x0000bc0283606a6b}},
    {{0x000cd1399b0fbf20,0x0003ae7bfaaa7476,0x000515068398a2ea,0x000ccf4a67748a0f,0x000052c9dbaa0de7}, {0x000b107df0bab755,0x0000bf5cd043bd9d,0x000ca0aad0f46f5d,0x000122d95fa8e659,0x00004b88235175a9}},
    {{0x00063c7b5bcf7a13,0x000e4a0fcad630a2,0x0002e5101cfd5a29,0x0009bffc7f24c1e2,0x00003d1eff35a181}, {0x00005715a33e4b08,0x000243d6669d649c,0x000cac16fe982911,0x000ca0d08374e968,0x00008326799f5651}},
    {{0x0005bba6afc5ab95,0x000f1153dd46fad0,0x0005a6b8ed84540e,0x00031d26cc136a2a,0x00007c4b8712243d}, {0x00093b3f4bd9ae24,0x00099ed80b28abfd,0x000a5a784db8f876,0x0006abdfb9bb8a47,0x00007c9037ec1306}},
    {{0x0008517c194a6c3b,0x000ff8b4e080bad5,0x00095ef1ab25163b,0x000fd601840b3f70,0x0000f57e65fa20a0}, {0x000761f8718a4635,0x000026a37b1da3f5,0x0007d62b14f1d622,0x000a97dd8bb7dfe2,0x0000b65d15c8388c}},
    {{0x000fb630f9f3c36b,0x0003514f1507f908,0x000709730fc5a09d,0x0001a551491ecda3,0x0000eace9768d59b}, {0x0005fa0c62ba40c9,0x00057a73f9217bef,0x0000e19c42c546db,0x0005238d4079ca10,0x0000ca0c26f55313}},
    {{0x000ef817c3b2618c,0x000516c3678b7d65,0x000af4eab31e6d46,0x0005e838846fbf7e,0x0000cf31a0360563}, {0x000d8d7395cabd57,0x0003bfdfda36daaf,0x000e52df3d83d332,0x000c0c667a2f6684,0x0000e1a16cbedcfb}},
    {{0x0009566376fcec40,0x0004537333dd7cc5,0x00051d3c0941a4af,0x0000dbfb72206ff2,0x0000e6496b4df3a2}, {0x000340da7a61207b,0x000de24d61e2c6b0,0x000afa106554c6de,0x000514a942394f93,0x0000959becd8bae7}},
    {{0x000e7c288392edd9,0x000e09e87173c5d5,0x000badf27f43f861,0x0000875f56cbbdc6,0x000059011eb4dd0b}, {0x000b4176f01cea75,0x000d52c23a0d6c81,0x000f0b5d771b4b78,0x000415b0fd29a184,0x00006d4d765d5cff}},
    {{0x0004fbf6e5ab1c10,0x000c5e16117aed34,0x000068ab71d61e70,0x000d5853f76aac64,0x000041afad97ee21}, {0x000f2590f3380ea0,0x0000057fe06e1782,0x000ac009aab5f995,0x0008523a89866ffc,0x000010ad3182779e}},
    {{0x000edf9d8e340aa5,0x00013c432c9525be,0x000c5b0938e52347,0x000f7f2b547dc9ce,0x0000337edbcd4751}, {0x0005f8d089a8d34f,0x000849d94da27c6b,0x00021344d3091355,0x00019ae8dccbb520,0x00003db4afef5bb0}},
    {{0x000221483572979c,0x000f488d38f240cc,0x00001d197443feef,0x0007cba0ff6fdd65,0x0000c8ed1a1e245f}, {0x00043ac345ea9f35,0x0007ed4c13607cff,0x000ee8dc785c5171,0x000ce453e3b03a22,0x00000d9cd4fd626e}},
    {{0x0000e350ac33d68a,0x000cd316d7ea5a59,0x000d601e37ae8df2,0x000a613a4ef1b40d,0x0000b969a55dfd9c}, {0x000b7d820baae471,0x000789e5546e638d,0x000adea90d131722,0x000588b4bafc01bb,0x000020136f521961}},
    {{0x000719f9325b2400,0x0005ba8ad2510bfb,0x000c18046ed327c0,0x000dae7c4bb581f8,0x0000f5c43bf2821c}, {0x00064d2b8967b272,0x000ff2fc977093bf,0x000e43bcf14f6a54,0x000c6150374246de,0x0000edc1c38954d2}},
    {{0x000d28e4579a1c60,0x000a23ad0bc91684,0x000159efe0e89838,0x00013c18b907beb2,0x0000f982933523bf}, {0x0005a3d80fcaa3fd,0x000e71da29914720,0x000260190947110d,0x00044d6527935a8d,0x0000b8cdec4b3dda}},
    {{0x00078460ca8fa191,0x000f5396fa5eb6d6,0x000f8451a2349560,0x00008834935f4c4c,0x00009300128571d5}, {0x000dab31e4ba5a79,0x00014b60c848233f,0x0007e000ae8f45d3,0x000156c4a44930f5,0x0000e9ee0a99bbad}},
    {{0x000d5403bff252a4,0x0003c2c93f8b1649,0x0002ae1a111254e6,0x0008a652e0510e35,0x0000025872deaf32}, {0x000f49fcd577ca3c,0x000a66df694207c9,0x00088c106ad78c7e,0x000eacacb6deef66,0x0000ae91691d5244}},
    {{0x000a1a6556a90c69,0x000f247842e0528e,0x00055287f1f99c51,0x0000834918eed56d,0x0000addf95032778}, {0x0001770d1ffbb4c6,0x0006ee9a94d1ca36,0x000a5c9aeb4f8224,0x0002c9a6b1ea0ae2,0x0000815b08430763}},
},
{
/* digit=14 [{1,2,3,..,}]*([2^98]*G)  */
    {{0x000dc06264c6edf0,0x000ee76ada9f8a5a,0x00093a29ac0d4b89,0x000bd589805d8eab,0x0000a3f857d466c7}, {0x0008cdc0af4d7692,0x0003a4587e2c7fe4,0x000068fb7ac8249d,0x000cf84bb97b33ee,0x000025f782d1e221}},
    {{0x0007b344d830d611,0x00090706b372f099,0x0007c5d82081ecfb,0x00062e5f1d371461,0x0000630e68f8309b}, {0x000027ecab0d0e7b,0x0008eeffeefc38fb,0x0005a3f00f139e51,0x0006235555687383,0x0000000539130fe6}},
    {{0x000a7d994abc3339,0x000eada42542f0dd,0x000d2774877be20f,0x000d3e01fd92532d,0x000045b905b58c4b}, {0x000f4f6018764c26,0x000b906b0e9ad737,0x0005a7ddd213dad2,0x000979cb47e139ca,0x00007e5ac0e28093}},
    {{0x0005bb244b1a7745,0x0004d3be15ecec3f,0x0006b92215c50b54,0x0005c2343f4af69d,0x000061a0fb33d6b8}, {0x000996c8fb6c5f4c,0x000f7c15d9d2bd46,0x0001d8db7e469c42,0x000997e76e202eb9,0x000079e3e7b012a6}},
    {{0x0004e3dba4f34c34,0x00037e53915042c8,0x0002eb606a8d77ef,0x0004eacde90607b9,0x00001bf86bfff708}, {0x000dcfe17dc51185,0x000be051f4755508,0x00005d090cce6cc7,0x000d86e74d036824,0x000003082999813d}},
    {{0x0008952a021a9b5f,0x000accd265a08868,0x0006f5e0a1762020,0x0001ec077c5bca7f,0x000051a150e7a0c8}, {0x000c4dedb17071d6,0x00091d7d3367b9a8,0x000cb4a59fc13868,0x000144624e29dd68,0x00004aa6d75f039a}},
    {{0x000a3fa97e6e0640,0x000d7477c822e5cb,0x0006d71cfa74fbe6,0x0003b6e7f42fe5a5,0x0000e15e3b313245}, {0x0003747e55840168,0x0000f0b46d9f18e2,0x00012b245efd94b3,0x000e0e8bb7ed74b5,0x000071a6634049eb}},
    {{0x000afafb42e29add,0x00018d9ad91573de,0x0009c54ad6e3aa89,0x0007703a1f57b2de,0x00004626948ca4b6}, {0x000abbb815e6ca50,0x00035b40f7f54940,0x000a08f33a48dad8,0x00084e31e14799ef,0x000095a109d11471}},
    {{0x00002547eca94470,0x0004a32c671602cc,0x00040116a86806e6,0x000e8db86a0dfb11,0x0000467b5c6238db}, {0x00065c7b3957d267,0x000579251baa175c,0x00083f53398cd355,0x00066bef5f51a807,0x0000599690598dba}},
    {{0x000a1e066f254055,0x000e6ae221534d5b,0x0008d3bb91428e24,0x000b46795bd47970,0x000023f090e0e98d}, {0x000018f58c20dcc8,0x00068a6f249e38a2,0x000915d4db72af54,0x000729b41ac98972,0x00001f3ec32bf5b1}},
    {{0x000c30853828ecc8,0x00003ae49031a5b0,0x00016d35710f0304,0x000166de6aa30f87,0x00000b38f0b6be3c}, {0x000422386ba22348,0x000d2a6b4a859201,0x00069a2f618226b7,0x000dabb6b9065ae6,0x0000a1c3854e2ba7}},
    {{0x00086a14823ea47f,0x0000554a1c55f1c1,0x000a974aa782f893,0x0008ae49b3fe8e67,0x0000129a2c97602f}, {0x000d903dd777718a,0x000e76223c4293a4,0x0009a1637ef4efe8,0x0000b2f996c38d78,0x0000dfebadce6272}},
    {{0x000d950e92810589,0x000774dfa90b0136,0x000039faf2b175ce,0x000e185a260a83db,0x0000561f8e4b6c93}, {0x000ebf0e2fe28b50,0x00034acbe16edd05,0x000320d07af8414a,0x0004430be5fad27f,0x00000ee98f0868da}},
    {{0x000cae8c6791947b,0x00007996853c4c82,0x00019a0f47f2509f,0x00004935af953959,0x000027cd71f58bb6}, {0x00083fd8bc62211c,0x0009bfefe89d61da,0x000ddddf3c87eab0,0x00047e03a5e0f6f5,0x00008b3c456c5505}},
    {{0x000137df36f714f4,0x000582323ed21aa9,0x000cc68386a00b41,0x000bbd594ecffcce,0x0000cecf5b089abd}, {0x000983eaea96fcfe,0x000b24d12f6ae33a,0x00053fa16977b26c,0x0005befbcf594bb7,0x000088d8f7495883}},
    {{0x0007b8acedb9388e,0x000400efbaa8ca48,0x0000a06b17cd0588,0x000a7400dc760aec,0x000015cdfa858e76}, {0x000e7f3b8048b0e3,0x000ffae832778b42,0x0006b52cfbc15e64,0x0000d578158f0142,0x0000af7e47c0508f}},
    {{0x0008eb22823149ed,0x0009745fbd4f13e8,0x00047180965d7326,0x000b40df9c9b9a8f,0x0000c9f0be3c6954}, {0x000a28f9b361f46a,0x000c072e07a5a9d2,0x0000f2ed0ac3a2dc,0x000392aaeebda466,0x0000336c3e9cacdf}},
    {{0x000d1d43afceea08,0x000616a9cef394de,0x00024432a5bde0a6,0x00043191915f59c4,0x00002f62d7e1fcac}, {0x000fa75ea0b786d5,0x000a12c9de645b54,0x000d5287986117cc,0x0002a68bb817b967,0x00001ceae3eadae0}},
    {{0x000b7ef5b2d3b2f1,0x000000070d048432,0x000c6c03e4e7e07b,0x000c7ff417809ed3,0x000025fe6da4c479}, {0x000e17e440a00118,0x000671aa9008cffe,0x000c32ed6a56c499,0x000f577463eea607,0x0000831162ce69d7}},
    {{0x000e4805943376fa,0x000b1eca3608d8c9,0x000ed34782092af8,0x000ccd599e1ef20e,0x00008d7322137ad2}, {0x000f359d5c8c0d56,0x00038757adcde109,0x000514301b31564f,0x0003bb5fcb028045,0x000004f028be60c4}},
    {{0x00058323cd637177,0x00028200d4cf1cd6,0x00046e38835c4220,0x000d0b6ca712117f,0x000024a80f8a1923}, {0x0009bb310add934b,0x0009b0984f44f959,0x000603516ff5e5c7,0x000bbee13c21257e,0x000090eda9f674c5}},
    {{0x00005458fc6dd126,0x0000947af627b5ab,0x0008f966ca449c6d,0x000b0cc003e78cf1,0x00008256aa596830}, {0x000a0e079d35b70a,0x0009940a5f36cb04,0x0000c3f2d26877d1,0x000730ed00d82660,0x0000ab865b6523ff}},
    {{0x0009177f2d61f6a6,0x00066af811bf4a06,0x0003b1c247bd378c,0x00062465ea93b39f,0x00009171cdde60f3}, {0x00095252b216763b,0x000749e6bd882dfc,0x000ff92142ce99f9,0x0000524b31478981,0x00009b67920e8098}},
    {{0x000f5eab873e5982,0x00002b05e8702523,0x0009e3071bab7eec,0x00049dcb63dd8dd0,0x000065a0588f39b8}, {0x000f19f79a322046,0x000b6ebf2f4ddf97,0x0002dafc0af5691a,0x000d2c5d445ac1d5,0x00000c9570bf9541}},
    {{0x0008c920c8a7eca8,0x00034d2fb0311be7,0x0001335f7aa6a1a4,0x0005a8062bc8fbb6,0x0000934c72c41287}, {0x00035614cdaa4860,0x000b9d9596f7a99a,0x0008ec39c47104fc,0x000fd127b936a44b,0x0000930bd26ecf89}},
    {{0x00031bd38f4959f4,0x000209f43efcc5ff,0x000222f36c2b77df,0x0005f4ea5ceeacfd,0x0000dad55f834b8f}, {0x000abbbfbb9bf288,0x00085dc8869ed851,0x000c867e63c03f7e,0x0008257f770d1a05,0x0000ee1f000730c6}},
    {{0x000b8711de100539,0x0006ad95dfe207b6,0x0006cb512680143a,0x000f506e2c18fddb,0x0000bce3ca0378e8}, {0x0004eb8130d57fba,0x000fa5840b8715bb,0x000c84823eaae39c,0x000b26629e9d3145,0x00003031a8c8c1af}},
    {{0x000fec3fb7df9633,0x000f793017b5239e,0x000d417edfbe62de,0x0003a2bd4ed6d43f,0x00005cfa222922a4}, {0x000cd26d9111ed55,0x000332b5b95f6de9,0x00094dce34d4e23d,0x000ea1652aaebfcb,0x0000a74a2880fcc4}},
    {{0x000b85e6b698c60f,0x0006bd05bb9009a9,0x00080f4cd386aba1,0x000414fc79987378,0x000022a41cd0ade5}, {0x000386b37f02931d,0x000144ed3b36adc8,0x000831113fcbf024,0x00062655c85d148e,0x0000abf8c2abb579}},
    {{0x0008a280beb3d98e,0x00022e4dceaef7f5,0x00019e2cd5a2c67e,0x000d97b0a1fc4ced,0x0000ccb55ec7430e}, {0x000927ea8db4dbb2,0x00054287f738760d,0x0009e0694ad868fc,0x0009547719050c59,0x0000b8bd54ad1b07}},
    {{0x000b919915296235,0x000b9440eecccfab,0x0000df1d4f7f9db7,0x000fd803b66d2b79,0x000021f810f61fb8}, {0x000374ab0babbfca,0x000b1da810b6567a,0x00007019ae31b3a4,0x000e6dc732421879,0x0000aee1fd5d3d9e}},
    {{0x0003dca799b1e8c7,0x000498f64369d75b,0x0009b0643f842b8f,0x0001b609c435b8d7,0x00009e18a4dc6dd7}, {0x00093f286cd43de1,0x00000522ebfb1d7b,0x000981ef58ef5f5c,0x0009a7c511d1c979,0x0000079e84ba8d07}},
    {{0x000e22bd3c256aa8,0x0002fd4c94bbe5d5,0x000ad29c666de35f,0x00035e3b865874b6,0x0000224e3c128523}, {0x000d5f4d614945e5,0x0007845bb7831b45,0x00099e134cb89357,0x0005ec39f9f5f9ca,0x00002f887fca2984}},
    {{0x000ef0e4412d59f4,0x00035ee9036e0f4d,0x000ddd0c48d53893,0x0000fc472a1ce74a,0x0000a17b9b8404fa}, {0x0003f18afac2a705,0x000d43fe74db5f3c,0x000c2267174d55ce,0x0000895e0f14e108,0x00005dd34a549d92}},
    {{0x00026468b946678b,0x000bad393b4640d4,0x0009805afa144f1f,0x0005586d58b328cd,0x0000b5a443e9ccf4}, {0x00058637fc0a22d1,0x000e069b47544588,0x00019ddb88467c90,0x000d6df432509399,0x0000e17ce7f02ef7}},
    {{0x00091620e2b9010e,0x0003b1a55e8e98b3,0x000c2c0459f0e8a3,0x0001e1dcfff42fc9,0x0000dd65a82c1053}, {0x000a151f4aca9977,0x000c1b7e25a6edab,0x00038c1f361d8bb1,0x00000cd30261823d,0x000058c4491cd6bb}},
    {{0x0001b0cb59285f27,0x0000f4ffe44d5c38,0x0003e8dac0335ca3,0x00035f7325d84a82,0x00005079b33341fc}, {0x00012eba3b28d558,0x0004bcc94ac65271,0x000e2e85b998a96e,0x000224df60868980,0x000070d7cdb23165}},
    {{0x0004ee5b665a2bf1,0x000dc11697de8321,0x000e9fb2b99d4d00,0x000b6248a3b6b7cc,0x0000ebb83a1c6e31}, {0x0000e7f18e605d33,0x0006d595cf04d7a0,0x0008c209f036abd3,0x000f7b5e7c03f37f,0x0000202f91c41e8d}},
    {{0x0005fed58160235b,0x0004f5fcdab49aa8,0x000ad6f5b0d663cd,0x00046955fcc1cc31,0x000055aa92af2c90}, {0x0003cc5ae6b06c50,0x00057eaea58e748e,0x00014924cb8d73af,0x000859aefc2fbb85,0x0000055f1f24388c}},
    {{0x000b0ed88e1a7efb,0x000e7ceefbfc0fce,0x0006d857cea82848,0x000cba7abdcd838d,0x0000ec1dae8cead4}, {0x00000a669ceda0f7,0x00011d3126dfc250,0x000f4b9ca2e7c1e0,0x0009b84cbfd34e07,0x000040e4bcfea9b1}},
    {{0x0003f728819ea128,0x000b06e16cf36161,0x0002919408897f08,0x000e528858cfd6a6,0x000058155bc25fd9}, {0x000ae2986292c0c6,0x000167af291c84aa,0x000e79cb6ec4f1f0,0x000c81fd358f1993,0x0000ce475e3b0ba1}},
    {{0x000f785374d12d02,0x00012d98caadc70a,0x000d42f2a8babbf5,0x0006c2fa867fbae1,0x000053850d2b0795}, {0x000def812567bf3a,0x000d771344b51fe6,0x0006e684f2a6edf9,0x000c5e0a73f6690e,0x0000e282dbcf75a6}},
    {{0x0006d9be5836ecb2,0x00020a13c0defb0b,0x000e52387a145e68,0x000f89ba1fac2f4a,0x000009824d57a58e}, {0x000dae8413ed668b,0x000ade3adc47d3d5,0x00080a12938ac94a,0x0001e632ee79ec52,0x0000a4e43332753f}},
    {{0x0003b2a5bc9d9932,0x000a0b017d90e7c9,0x0008d33771f5faba,0x0001f007e829cfb3,0x0000a6756330d4e3}, {0x00071776f7f71d2a,0x0006552d8f758b90,0x0004bfebc559f745,0x000c49858fe49424,0x000017dcb740493d}},
    {{0x00036a95aead4696,0x0008faa7b0da3af4,0x000525e90dec1412,0x0008746bab082157,0x00007f8eaf99f609}, {0x0009610fdfd3120b,0x000a43ab469f1ec9,0x0009ad77bd19d496,0x000fd9a9a5d8758d,0x0000da7732d94025}},
    {{0x000ed2476d66cd25,0x000cfb4dafef99b7,0x000305d194636025,0x000c900c1346a4a9,0x0000bf0491ebcdab}, {0x00076b6079e2c2ca,0x0008b0b6c5b084b1,0x000dc7edc14533fe,0x0006f61b6cefcf0f,0x00003ee45c6b478a}},
    {{0x00092f1d816eabc1,0x000722ec5d199636,0x000d057ce2867339,0x000d5e74d26433eb,0x0000e5c102c41805}, {0x000cee82359f79ac,0x0007e6aa805964ea,0x000dc458eb929320,0x00072db27bd3f9bb,0x0000da2bf8fef359}},
    {{0x0002a01a0a8db27a,0x000a64fac978817d,0x00003993bedf7365,0x000f0423b74a2535,0x0000333bccf9f3ef}, {0x00020cdf3fdfc059,0x00040b069a38f55f,0x000d5dce6c8fed38,0x0006a5e2563db264,0x000065193986cacc}},
    {{0x0008add2e2366c41,0x0007d5b50c4b1c42,0x000492b8899d7804,0x0004015c2e9b786c,0x0000f1dfde4b6b08}, {0x000d8bfe14c5f775,0x000829260c708e76,0x0005519b1411e966,0x000b9c856fae8b5d,0x000022c66ad8a1ce}},
    {{0x000b24afec4eb474,0x0009ba269084ce0e,0x000929f95b4dc777,0x000103abb56c569f,0x000039c57b19bb9e}, {0x0009031d0f495421,0x000062aa769f5f16,0x0007f07c0d92f631,0x000de2bef7db92f6,0x0000309aec890e63}},
    {{0x000cd3221ad58754,0x0002a8fe3bfffc16,0x0007b21f1823e90d,0x000f9fd19412d4c9,0x00004e8e63528a95}, {0x000e5d23d1dae12b,0x000a643cacc7fff1,0x000061101366f4ce,0x0007da91960c70f9,0x0000b2e33c5a3b2c}},
    {{0x0000f0bc9de883e4,0x000832bc530773e8,0x000d6df7a905063c,0x000a3c143b5a28fe,0x0000e8befcc34662}, {0x0007800fa2c481ae,0x0000406435301c79,0x000f58b02d2a187a,0x00023349b0fc5eaf,0x000039152a95f548}},
    {{0x000eef8fa126aaf1,0x00086d7f5322c9ce,0x000e1277f0f736ba,0x00079b9f64d938c5,0x00003a4c8e990669}, {0x000b0604ed199f47,0x000bb8abe33c1b87,0x0009c5ec77b8ec2a,0x00068db6e60ca7ff,0x0000e2cbee08542a}},
    {{0x00097c18666cd322,0x00082e95d7c8b9ef,0x00093771f688714b,0x00001533c086020f,0x000059d210c8cad6}, {0x000146ca0174b83e,0x00073cf08052cb68,0x0003514a6f0317c9,0x000ee2740ce05a48,0x0000abd0c44aba33}},
    {{0x0007d09b4e2c6759,0x00045d92c0b09bb7,0x0009f5fadb7aa0a8,0x0006eb2aa8468c02,0x0000370e2b02e3bd}, {0x00010c5a05206771,0x0008d7564df22bf1,0x000eb5eadfc154a9,0x00080f2066bbcc22,0x00004986aca010b1}},
    {{0x000304ad640228e4,0x000ac74a48b12e47,0x000d9f11db8146e2,0x0005ae640f64bb3f,0x0000acaf40843993}, {0x000ef32dfa787e99,0x000d6ba59fa31a9d,0x0002fd7827169dbc,0x0007a251119b89c6,0x0000bb57c8e0e96e}},
    {{0x000a64d08043f76e,0x000da608af1ec1fc,0x0006d54e3eb16ab7,0x000343e63bacf520,0x0000468f9a504a0b}, {0x0005095ccc8689fe,0x000dbfc0d9ad075a,0x0007a7114b6bd402,0x0007cde5f2d4add3,0x0000ebcb63ead038}},
    {{0x000f2b16e394b9b4,0x00089a6e75339f88,0x0008cab78c7f95ab,0x000401234f291dc7,0x0000822d72a3dc49}, {0x000c53f4bd8392a2,0x0002d49a448fe0fe,0x000a59bac7adae0d,0x00085a96b5bb8fca,0x0000dd8cc17c987b}},
    {{0x0007f9fe72d2861b,0x000fbe6490d8b0f2,0x000f57650932916c,0x0009a9e1d65e06ec,0x0000368b49073e56}, {0x0000a09ec18478ba,0x000abce485c1be25,0x0009c2fd23e9d0cb,0x00070b0b05a40e0a,0x0000c0ac2a141ed4}},
    {{0x000b7f57b5a811f1,0x00003a332880bf5a,0x000f6ed2c331b72a,0x000c931b13881ef1,0x0000c494779169fb}, {0x000ff8589c026ea0,0x0007bf5b9f354528,0x0006516d66583a3c,0x000f0465c5c1aa93,0x0000533827189b9f}},
    {{0x0005d47b7457ae62,0x000e4dc51a1c0b6e,0x000a10b057309d30,0x000b80ea82422056,0x00006b7b1f3b4fd2}, {0x0008248dfe28471d,0x000da74653e6332f,0x000c48220afb600a,0x0002c84e00411034,0x00009c3060c6f37c}},
    {{0x0005a2209fb690bc,0x0001a6a994eb0794,0x00095af9bd66e6b6,0x000d3705c195b4b5,0x000080dddd3881f8}, {0x000d168d5bdbac0a,0x0004b0d2f72778b2,0x000fe8afb40cf8e5,0x0002a796b74d05e5,0x0000b591f243ce3f}},
    {{0x00024db163540742,0x000b30cc20fd6460,0x00051c51aa345835,0x0005a09a17bb71d1,0x0000277fb5139649}, {0x000d2c2542771796,0x0004d1f708634ac1,0x000d7e0ba72c1b8a,0x000e347e4f17f54b,0x00005fbc77bc2e9a}},
    {{0x000e083726268248,0x0003e07229767fec,0x00046e11f43b98b1,0x000a62eb12d4a2ea,0x00004a6f742ff8c1}, {0x000d16b330001ec8,0x0003aebe7cce5d32,0x000632924719bb7c,0x00039e6ff7ca5c15,0x0000f3e8d249e5fe}},
},
{
/* digit=15 [{1,2,3,..,}]*([2^105]*G)  */
    {{0x000f55e0ced7400f,0x0003959d5ee8a6a9,0x000d3d46dd0617bd,0x000c3976364d4eee,0x00005d6544ad3ddd}, {0x0007dfe795845bb1,0x00083b8c79468842,0x000dc535a3e15078,0x000da895f764d5c3,0x0000ff1d2743a1cf}},
    {{0x0003913423373fef,0x00099abec687f2cd,0x000c07192b34ea8e,0x0003509d102ac466,0x0000f4fa4a09c2d6}, {0x000f87ba71f45a5c,0x0001a2d1230874fd,0x000228058781f14e,0x000e8a4b4499f2d0,0x0000de5d3cffbca3}},
    {{0x0002e2e7392ec41e,0x000f0600583807b9,0x00044309ceb93a1b,0x0001bd4299d5f2dc,0x0000d341d792fd4f}, {0x000f7da2004fe859,0x000e680815368116,0x0000f675be924d2d,0x00063913a6fbfc35,0x00005c62b2743092}},
    {{0x0008a0d964e634ff,0x00016c532fb1c163,0x0001f4d76384f515,0x000adb344233bc23,0x000006bf9a0792cb}, {0x0007491415365c1b,0x000c3dd1431327e5,0x00020f4fe2b3068d,0x00070d4734ccd16b,0x000095b95b5bf075}},
    {{0x000761a38bb70b8b,0x0002166f263692b7,0x000d87e0b6acdec9,0x000d4767e1fd967e,0x0000224a8eaf9729}, {0x000363860e37a986,0x0008c4b2e8807f28,0x0004c4d7e510f286,0x000ce1a869283ca4,0x0000c3368915a32c}},
    {{0x000ff0d6cc67c43e,0x0004588de301c896,0x000096bf10683593,0x0005e94798800c86,0x00006f62ea26dac2}, {0x000a1e2efe6138ff,0x0008a3848069990f,0x000443db897dd7cb,0x00054d1aac07ca40,0x0000b2c088eca6ed}},
    {{0x000757ff5dacb5df,0x0003409dfa108aaf,0x000d1d3c5b1d8fa4,0x00021c63739d04cd,0x000002d31bfad6af}, {0x000e35f347dbf5cd,0x0006989679f1e20e,0x000e1a052e17f4f1,0x0005c7e7fe010b19,0x0000b14dd7d01c8e}},
    {{0x0007e840f9e4040a,0x0000a26798b65abf,0x000aa3d54ac179a9,0x000acbb1e5e42083,0x0000903524ea794a}, {0x00076ce040ccabc9,0x000befaca5bfabb7,0x000925f5fab22e60,0x000bb22783ab4b8b,0x00005d8af2205673}},
    {{0x000f399058b20522,0x0000dd5d61d0c0af,0x0002ded111c639bc,0x000df9d3a3f3688f,0x0000b2d2d7fb44a6}, {0x000af40a6c2a4094,0x000fe11fdb14a199,0x000a1ab6062e9058,0x0007ef709be94066,0x0000fa64f9da0087}},
    {{0x000b4a8964e772ad,0x000159d89cc553ab,0x000c8bf365c823e9,0x000a41337be0bf3d,0x000033f0eb462664}, {0x0008667a8e33616b,0x000bb9985acdac62,0x0003608bdf3a9d74,0x0005f0bcd80283fd,0x0000986dd5d601fa}},
    {{0x0009de4efcc85c15,0x00096f139013d950,0x00057dacdd1eab4d,0x0006ecb65bd6678a,0x000055db869cf233}, {0x0001dd30ad5ab142,0x000ee6314b871bd5,0x00033a0d66fdc7ae,0x0005777e6357c61e,0x000026c5eda33aa4}},
    {{0x0006dc5456e8775c,0x00046e911188ec30,0x00090025c7708950,0x000a20b40e8e0032,0x0000e507b2640d0c}, {0x000d535e705092a7,0x0006166bd3b5bcb5,0x0004cd250c59127e,0x0005550d02d21554,0x0000e39d008a8c05}},
    {{0x000a050a62fa45aa,0x000e1007a06593d1,0x000091014c6dbd3d,0x0004f5b6d0706a49,0x0000f6d6e35f5c39}, {0x0003b19cd3f850d4,0x000b5e7d85a52f32,0x0009e78ab4f434d5,0x000e32db2b9c0723,0x0000b10cf992d5a3}},
    {{0x000f592e7efa4378,0x0000fd0f0290dce3,0x000a14ca9b7d8b33,0x00085bdcf8aefff1,0x00004f13e355b1ab}, {0x00008a0f61a817bf,0x0009c5549bdd0f62,0x0009a0730387141b,0x000a93fd602598a9,0x0000cd8cdef9e264}},
    {{0x00004ae9a503381f,0x000a859248c8366d,0x000f3a32b04731ef,0x00078d74accfc96a,0x000061c0b6905f8e}, {0x0000ebd5f59d1b15,0x000331d6846375ff,0x00082480114edc5a,0x00058cfd89817663,0x00006f41ecdeb28a}},
    {{0x000aba7b5341a587,0x000bbbdbc220d5f2,0x00002e2f859f0298,0x000c85b9d62c9cff,0x00004cb6beaa83a0}, {0x0009ed02cf8d6bf1,0x0009bdb17547e9ad,0x0003397b4afb4753,0x00091a79f573a86a,0x0000919e0860dce7}},
    {{0x000d88918e2f47d3,0x000f6264e8e698b4,0x00076fd1ccd75cde,0x000411bc9ae6e276,0x0000d08e3e91b76a}, {0x0004a951353f00ca,0x000e856c3a8b5bcc,0x000143eb164cf5f9,0x000249e23f45b2a5,0x000001ab36c56983}},
    {{0x00042bf7db15975d,0x0005d84f2911ff78,0x000a7eef9c1ef2df,0x0009ce3c9dcfc71d,0x0000f79ee6983307}, {0x000ec3041bc41cb1,0x0004a53e33bf1432,0x0004e1053cb62983,0x0003a7aa20e23f98,0x0000b8294d01f0c0}},
    {{0x00048d0372d37ea5,0x0007626c450c99bb,0x0008f91caa38c50f,0x000b126bffd090f3,0x0000f3229a1aac39}, {0x000fd864b7a8296a,0x00036564a892a1ff,0x000a8d75bf858c5d,0x000d9ad955b9a736,0x0000da662d7fc17a}},
    {{0x0006ba795e751920,0x000846f147608e81,0x000ad1441e7d892d,0x00005e448a0cfc30,0x00005a4d96d983e1}, {0x00004229da172130,0x000ea801e09a0949,0x000fe63f9fc0e627,0x0001c8d681971a10,0x00004012304767fd}},
    {{0x000a19b17530f16f,0x00043fcb789432ba,0x0001dd7acbc549a0,0x0002eb708cbe384a,0x00006369e0348ead}, {0x000a6090c1b89596,0x0001c1598ed95616,0x000f9fbf0c2ef829,0x000f07a5a10b751f,0x000083266ab6634f}},
    {{0x00006753208ff59b,0x00024fc44d274298,0x000b8da4cc5e633c,0x0001eedd9e76d668,0x0000984dc35fc919}, {0x000742fdc2fb0b16,0x0003f1a37ea501bc,0x000ccd5c8f47f7dc,0x0004a12079fcbe1a,0x0000d15e05379840}},
    {{0x00012f5c7b57a458,0x000171b1fea8f655,0x000933ccf5a81d61,0x000369e7fda656f5,0x0000c0ab37cf5bb4}, {0x000b16333f34c676,0x000fff92c2932e05,0x000f70718aea2f68,0x0006ad4391ab6d2d,0x0000b621d11d77e2}},
    {{0x000ee9cb342f4650,0x0009e9f60819a72c,0x000640fbba78926d,0x000eda1a2390b4ef,0x0000ca57e589451f}, {0x0008eb97ffa2d64f,0x0005596f4451997f,0x0004125bb6a63afb,0x0002c6b2bdf70c17,0x00006643535dcda9}},
    {{0x0003cdda9cd82b35,0x000509e3611c4e81,0x0003f16e05c37f8a,0x000b18efdffa6c50,0x0000bf1aed211a9c}, {0x00082a34eed8ee8a,0x0000444ef3243f53,0x000e9936c0eb0c00,0x000a9ca6ba337bc5,0x00009e6106f21806}},
    {{0x00025aa6380f2af4,0x0005491d9d165dff,0x0008eb846ca78f20,0x0003a9f6e0d46b69,0x0000928b01e0eb89}, {0x0000f19d4744bdd2,0x0007232b1a35b4a7,0x000fcfede71fc522,0x000c5bdc58c9372c,0x00001f4e89d71396}},
    {{0x000b414c8ec0e785,0x000a1033d145c6c2,0x000e07a15d9a7bd5,0x0008686748b7db2f,0x000064f63f44f8f7}, {0x0007c5bd8808eb44,0x0009724642e6865c,0x00059e076e717c8b,0x0002161fb2086420,0x000012f7226e4689}},
    {{0x000812cbca321347,0x000e632740ba2570,0x0001db927a9e88dc,0x00052b0aba4374ba,0x000031227b96461e}, {0x000cd5dc06746bbe,0x0000cf772208a93f,0x00002a73b5a86ada,0x0008c08bbb02ac6e,0x0000f0196a56dc06}},
    {{0x000d114588509806,0x000fb66505d56d8e,0x0005d67e3ade8c1e,0x000119098b390daf,0x000036106afbab3f}, {0x00018cd4db085aa0,0x00060de60f8f3920,0x0008384555865e57,0x000c8b560c8a7794,0x0000bb865e6fb6e4}},
    {{0x0009a2695dcb03be,0x00082dce5033ad58,0x0009607c5c6bfee0,0x00022ae3df25d171,0x00000969faa0ee1b}, {0x000ba9a77472ec5a,0x00093546739c439c,0x000ea5d5c7a4c0b8,0x000e1e00c8fe66ae,0x00009ce280523997}},
    {{0x0005978b851b77b5,0x000283c18a02a8b6,0x0009ba7aa0364b0a,0x000f94a6337a27cd,0x000046af7665f865}, {0x000ca9cbf97d5b16,0x0002237045beff1c,0x00083538584b0821,0x0002838dc37d07a3,0x00008db8ece96033}},
    {{0x000c181d162aea79,0x000e82e60793d69b,0x0007258aefe6f5c3,0x000ff59bc53c6eba,0x0000fb553ca68c8c}, {0x000a8ffea309a6f3,0x0000b9a56441bca8,0x000e2c97bc141056,0x0001715ae34273f8,0x0000514b5e4a2efa}},
    {{0x000c99927b057ad6,0x0006c8df3e109788,0x00042efcbb33a466,0x000e21d25a75adbb,0x0000e29ea59779da}, {0x000921fdb43a94d1,0x0000339d1820fc2c,0x000ca4ed5d01956e,0x0007bd7de58e797b,0x00001e6e6b666ea0}},
    {{0x000db2987fced620,0x0009ec446ac47b5f,0x0004a043cfcbd482,0x00041a6a0c7495f3,0x000012af53d2f54a}, {0x0006ad3c90c6bfe5,0x0009e9382b437e60,0x000b911675112180,0x0001fe21b90ecd21,0x00003c0b3c579d34}},
    {{0x00027b6e3c50668c,0x0006d6d8d96df5a4,0x000da74b2f2f21c7,0x0004a2b1e238a1ad,0x000010d7b0c82fc3}, {0x0003512ea402316a,0x000e879853dbc21c,0x000ce88096dab781,0x0007d667b34f9207,0x00004b1eb299bb04}},
    {{0x000d118c309e65a1,0x000fabfb4147a551,0x0002cb43addff781,0x00012d35f7873d69,0x000027471214c7b1}, {0x000d72dac4e3e7ed,0x0007353a272c9f63,0x00092a6b9af262dd,0x000220bf901e7534,0x00007a7efb0540e6}},
    {{0x000b0ea863d4195d,0x0005368db7c846e3,0x00005939496972ef,0x000a5e8c21297c56,0x000067666c5eaca1}, {0x00025d8b0dad395b,0x000865268b8fdc43,0x00006bcfdef1f33c,0x000a4774da449704,0x0000a1358f89d014}},
    {{0x00029a88642c8c87,0x0008c8e1555b9104,0x00039a9aba22bed1,0x000fc7e5fe7cb866,0x00000202dfe03ad7}, {0x0008d27cd6bd32a5,0x000cf32a6b477ed5,0x000dfd6a90e47d00,0x000f4011739d9316,0x000009017911ff40}},
    {{0x000b591cfe2d8435,0x000da2d587d5570f,0x000368c95c0226cf,0x00024b0fb7a4d410,0x0000747cde3537b4}, {0x000b950273cff74b,0x000e13c9336c4563,0x000c3960d19448b9,0x0005749ac83ef9fe,0x00006bda1afb9c11}},
    {{0x000fd3c13fb0e65d,0x000fa286d2d8dee1,0x000429aebef8efe9,0x000941fc4bebd474,0x0000003c2cbf1f69}, {0x000b443a5eb895a6,0x000b471ff243422f,0x000bd3be819ff465,0x0001c38b9d452cce,0x00005d9b85ed78f9}},
    {{0x000375126cded2da,0x00007e9257a8c6bc,0x000dee102a30f31b,0x0008fe55ab4546ff,0x00000dd53a3fae81}, {0x0005cbb5a649fc4a,0x000817a77abd2632,0x000e1e9abc600dd8,0x00067b95baef2e23,0x0000de3e4fb2653e}},
    {{0x000383df4f38b019,0x0004818f9a6a720b,0x0002d4e1a9ca0f4f,0x00035b6d14a33e46,0x000044289f623629}, {0x00007a387d0c040d,0x000b1fa4bbe11901,0x000d31de4afc1507,0x000d61847236f98d,0x000092524f93ecbb}},
    {{0x000133e59049afec,0x0005726f65d7ad5c,0x000c20ba29b6689a,0x000fe847a4377af2,0x00000527d1b09af8}, {0x00040fab9f632b99,0x000399c6fd2087c9,0x000492e8aa07a977,0x0006bb6bf24157f1,0x0000127f701cf38b}},
    {{0x000a5446b8fad411,0x00094c04141b6e5b,0x0000c0c227c20ebf,0x000d5a04ab83fce1,0x0000bcb816fe010c}, {0x0003b1f39b167b8b,0x000508ecf57d0da8,0x000f43aa56b9dd56,0x00056a8cd6338fd7,0x0000bbded8d9e446}},
    {{0x0007cc07c0803c55,0x000f213fe5473232,0x000a3cfe69566daf,0x000b4b379c15809b,0x00005eb247e4e96e}, {0x0008c0ee69a81c78,0x000ca494920f6e7f,0x0000bf99b798df73,0x000a22034f1f6531,0x000097e6aeccea96}},
    {{0x000a954927e7800d,0x000a826d0a072de2,0x000d54515c3845d4,0x0009d7df7dea11cb,0x0000bd898c3c179c}, {0x0002dadc7f97ca3e,0x000c0dc928e98ba2,0x00044da48b29b42f,0x000aa74a564df536,0x0000634de334dbe8}},
    {{0x000fefbdd58c6c26,0x000505d10919ecdd,0x00022059482fdceb,0x000567341aff5332,0x0000c224f55a4389}, {0x000cb2becafcf4b7,0x00068c9356cee825,0x0005bf8155b2741c,0x00073337ed23e3fa,0x0000db5fb517c0d7}},
    {{0x000bd96248ab8040,0x0009230d301d5d87,0x00070e14ad7011c1,0x0003d21ef8438468,0x00006554bc48fe6a}, {0x00060d553e3bc93d,0x000d4998ea4a6e08,0x0008cdd7522b6e14,0x00008239e466a48c,0x0000715f93d875c7}},
    {{0x000ebb47ef45b374,0x0007b2b58c3731da,0x000e00a0e3d0dc78,0x000bc2a199fdb8b8,0x0000bfed2128b73b}, {0x000e635d70a51a82,0x000ba44f2975b044,0x000dad6e7aecd152,0x000a50eeccc149a8,0x0000aa60be904d47}},
    {{0x00057e2a9da811f5,0x000d8f3097464c41,0x000484e775d2c457,0x000cd6e150802622,0x0000d436e5ccb8e0}, {0x000b7da9c87674cf,0x000a0e9207076833,0x000861876e15b63c,0x0000a8cf27564749,0x00003acadb457197}},
    {{0x000409f6aa3e6037,0x000e9cd0f03103a4,0x0003670a08cb8a11,0x00029d97e7af5af4,0x000033d7696897ea}, {0x000513f584bf83dc,0x00003556fed046f4,0x000673b14b6edf6d,0x00085fcef8b7c83a,0x0000b1cd839a4b63}},
    {{0x000185d2c4242479,0x00097a295f96baea,0x000a2a8c7280ed03,0x0007ef7fc1f8550a,0x0000d696d88afdda}, {0x000ad885a9e3c7bd,0x000370ee8f9c98dd,0x000bda7835528be5,0x0009132edb484473,0x000039c54d3c3c08}},
    {{0x000279ed119371f3,0x00001fce787efaaf,0x000c87c24f135eb6,0x0009d979f366c07b,0x000041ca760045fc}, {0x000acb26b190eed1,0x000fcaffe42e29c7,0x000d6d3ab87c3da8,0x0008c050fea0c3b1,0x0000f921a3b9c2b3}},
    {{0x00019080b28583c8,0x00084271f1c9cd2f,0x000d88b4d5344abf,0x0006e6a1fa410880,0x00009780cad6113a}, {0x0008fccf32dc4852,0x000c09cdb1201d95,0x0009f592a499a670,0x00020202a5504704,0x0000b368bdb51e7b}},
    {{0x000bf0d270faaadb,0x000e467299302de8,0x000d5b29c9761e25,0x00038c9a2a3ca3e2,0x0000cc9ce0564bca}, {0x000feb5640283cae,0x000933c755cd2702,0x000ab454778cdcf5,0x0000f1802df412fa,0x0000a3fa943ac400}},
    {{0x000b9788e6e633fd,0x000544369ee142c4,0x00015ff93aad8109,0x000247c388415df8,0x0000bda8886b6aad}, {0x0001ae09bbfc6389,0x0003224a5c85ae86,0x000c8b0d806937c2,0x00033767015db086,0x00001093bc829ba2}},
    {{0x0006738d95956325,0x0006c14fe2f45374,0x000738d03b49c9e4,0x000f4f514a895f38,0x00004126445d21c6}, {0x0001bdd19accfc3f,0x000c75923b83aa21,0x000d4420ccc62233,0x0008570259ea62dc,0x0000ac5e9fd95e6a}},
    {{0x000f02f1e3020f7e,0x000abf391444e199,0x000d33d014595d4d,0x000243d1b275d094,0x00009fe416192225}, {0x000927e9313cc8ae,0x00007cbfad2bd631,0x0007d6f47c38a96a,0x000212ca8293dcf8,0x00009e934e1b8edc}},
    {{0x0007e895fac16188,0x000c48ddace03666,0x000ea05367de0677,0x000beff7720f6b94,0x0000f0cfc3ab04dc}, {0x000ffaae7332b4aa,0x000376aed4df1fee,0x000d7d9139fe5560,0x000cec33e0ed75b6,0x0000b793cbe3ee57}},
    {{0x00004d1db2df89a2,0x000fe1bb790eea99,0x0002e037ee87f71a,0x0001a43ef529bd8a,0x00003f57ccee309a}, {0x000e652d001535bf,0x000531e580c75add,0x000537db16a02484,0x00016ec744e0c9ec,0x000031da47f5dbff}},
    {{0x0004c7e6c2a25fa1,0x000d2f543aa6ac56,0x00040245d6d44b13,0x000d4cfd0af04138,0x00008a3e6f94f447}, {0x00053a1887a0b642,0x0004e78ebfe0b50a,0x000560e378ad1f19,0x000ddca374718976,0x000076c2fad52831}},
    {{0x00033c240fe437af,0x0004155b36bc99b8,0x0001d74ac6678611,0x000a5b24b825c503,0x0000dc5a9fb55609}, {0x000f6da55d8b0a12,0x00077b276db4ac76,0x0008fc93aacf912a,0x0005dd0cd8b799c4,0x000026948bba026c}},
    {{0x000e5dc6a8543fd2,0x000c1dd380d7e3a3,0x000f3ef8413c4a39,0x0001dfdffc537730,0x00006f878d18b4d0}, {0x00050e41bd35c986,0x000f502371f32ab5,0x000f1a88844ef8ee,0x00013ba15e21b99a,0x000064aa063b9517}},
    {{0x0000dc7a8ef6fb13,0x00029eb3893a9f55,0x000be61b7ffb9975,0x00084bb486f2c400,0x00007200d4bf41dd}, {0x000b00036c8f5e50,0x000f666addc17762,0x000741de8eaa75d7,0x0006e2beadda312e,0x00000cf20707c3ce}},
},
{
/* digit=16 [{1,2,3,..,}]*([2^112]*G)  */
    {{0x000263e88928ae78,0x0005b4e82be78b48,0x000573a10668411d,0x0006003ba7a1e67f,0x000055ce3d847374}, {0x0003d7e7e0444965,0x0003b5779daedf79,0x0006fec0025603ce,0x0005537019312576,0x000058c17835ab3a}},
    {{0x000f3801bf458e27,0x000267db440dcbaa,0x0009ae263c36f812,0x0007e4c9536223b8,0x0000a3cc7df0233d}, {0x000b1cd94cbeb372,0x00039f4807f8b9d0,0x000c597324185b52,0x000edcac170724de,0x0000d2110bf132b7}},
    {{0x0006829bfc72b079,0x0001d7df36f44abc,0x00071f67bd4d4b36,0x000dfe954c4d7c53,0x0000ce1626d4ce63}, {0x0001b137ff8ce06d,0x00074664f8dd7874,0x000300b6012fe268,0x000838c0a9ba2942,0x0000ccd61cd61418}},
    {{0x000561feaf4022a9,0x00054750df9b560d,0x0009e8873c0034a5,0x000babe5354bb528,0x00001434cb13b39b}, {0x000661885c701bf4,0x000024ea8f5c6d71,0x00087a94fb5f8163,0x0001f69289cb22b9,0x0000fc615e56fb16}},
    {{0x000183c12ef9b892,0x000bca4be6ce2dbc,0x00034f0eb5247e9b,0x0009319bfc5e8667,0x0000d7c61ce40520}, {0x000391e7aecc2dc4,0x000502b7dbd4b402,0x000c8e5c4c4cfbd9,0x0009e83613bcab0b,0x0000346c5d1041e3}},
    {{0x00061fe951496001,0x000940d172cbd2f2,0x0007178c0c43ab46,0x000faf9dccdec82f,0x0000adca0a729af1}, {0x000d70cf6f648cdd,0x00020f732870a2e6,0x000edafaf9b5c25d,0x000106ce0db1e405,0x0000d951a4245711}},
    {{0x00083ffb1021d71b,0x0002312ad996176a,0x000fe8f4b2e72ec8,0x000a2d26d3a1eb2f,0x0000d0da0974fbb1}, {0x0007b253b22acbc9,0x0008e75e121ea26e,0x0001d0d96ac731e4,0x0002d71a94473e82,0x00001f7b3a36202f}},
    {{0x00038deafeaad237,0x000df374aa4943cb,0x00049341a28d1f25,0x000da0001e16e457,0x00005d5a690e8563}, {0x00039cc322cd1a1e,0x0000e69f3d0f0287,0x0001f380debb0624,0x000965b31a6ca354,0x0000e9cbcd994718}},
    {{0x000c6922682f05da,0x00017d91dac21c30,0x000d9a935d39a514,0x0001318bfcdaa873,0x000086e4fe5534c0}, {0x000794e1a75fbff5,0x000536f457094f58,0x00038cd634ba889d,0x000e8fdf2b2976a5,0x00008ca32ea075ce}},
    {{0x000d5a656febc1de,0x0001902e98f903df,0x000f488a40aafbb9,0x0000728ee7bae61c,0x00004af95a5c8955}, {0x000e37e156e3a046,0x0004accd7ad577a5,0x000b8bf99c4f1997,0x000c3dc8efc06d64,0x00009535e542d847}},
    {{0x000c071894059e33,0x000e16afeee5055d,0x000d7c4e58da0f59,0x000f92484480872e,0x0000d26d813b9d7f}, {0x000db103b383d063,0x0003a77d69385adf,0x000f5cdf0dbbbe77,0x00044de79f617d94,0x000045aa4efb1858}},
    {{0x00024757beec731d,0x000827d28fdb9e94,0x000c2342a93d6395,0x000aa543b7350b9d,0x00003ff4ae312e55}, {0x0007f066a93f5d0f,0x000b7bb2a8d24025,0x0004453ce9313341,0x00018ac52053dcf8,0x000034eb883f74c1}},
    {{0x000eaef662e4d0d3,0x000059a256134cb7,0x00039f0720131fce,0x000403b640ec2ad1,0x0000bf5af241564f}, {0x000e90b3a2dc95fd,0x00011936e70af541,0x000cb4d905df5c12,0x000eec1d816ac3c6,0x0000f7bdb6871a08}},
    {{0x000a5314edacbf64,0x000cea476e8d2cbb,0x000329c989b5d217,0x00006210a624d6bd,0x0000117009f54cea}, {0x000f3c08ecd2255b,0x00003a9d114b6cd3,0x000eb5279e0c672a,0x000350f0cf81ab63,0x00007bd811141a39}},
    {{0x000e5ad10c0f9e13,0x000ca384048e1e66,0x0002e8128b54f642,0x0003a4179217c0e0,0x00007023624a2bbf}, {0x000303ed950a4a7b,0x000f2ab587314f2f,0x000579025c85df88,0x000da0e847c3dd28,0x0000ad36a42e0005}},
    {{0x000f3942e984ec00,0x00069b01d25ffd3e,0x00052e58aeb37752,0x000648244408f942,0x000050a44776d1a5}, {0x000a111b2f83e4d2,0x000a55031541fd7c,0x00010e5caab3d571,0x0008ea6a31cb7862,0x00004f23739f63cb}},
    {{0x00034d5aa351e7fa,0x000767b6bdceee2f,0x000c32c404785e1e,0x0005856ee43745dd,0x00009ac4c31ca9a2}, {0x000d00120efac828,0x000cbe4c18a7102f,0x000f056f5a74ffbe,0x000556b56adf5d31,0x000034b8508f4fca}},
    {{0x00072bd8e4e38d94,0x00066bc1a50e3f67,0x000eccca9fcbfd5d,0x000094357266d3bf,0x00005d1ab86354c8}, {0x000e84f97431deeb,0x000b71de91ac3fca,0x000c099c7cfa4e84,0x000438463acc3dc9,0x00005a3b751b8423}},
    {{0x000ae45e109ee44a,0x000869005ea9c422,0x0008dc7eefa037b1,0x0007cb207cd5ca5c,0x000002e590572ee6}, {0x000d6f711e0c867a,0x000b67004688c5c8,0x000ac0175a217761,0x000d346dca0af57f,0x0000834eafd30443}},
    {{0x000031a244eb62a0,0x0006e2bc5ae2ffe1,0x000da78702a1ecdb,0x0007d86a6091a100,0x0000efb1036654d2}, {0x00050d8f92e2f743,0x000f3b2dd2ae5d9c,0x00085081efcb5469,0x0009bb2381877fc6,0x0000a09d4c8315e0}},
    {{0x000d2bc606eecd87,0x000ce811461f32c0,0x000d2a5d24c90b85,0x000778f04514b56d,0x00009c7f1fec2e61}, {0x000670973b59d05b,0x0009bb1567fe8aea,0x0008152ae455eabf,0x00049b39a03b8257,0x000076e8321067c3}},
    {{0x000293372ff91a46,0x0006b775c576ea7b,0x000a3cde27e9c747,0x000bf429095d14f4,0x0000218f90c2db67}, {0x0008acca306563ab,0x00024d4b59a65276,0x000cf8c68ef2c300,0x0008a593a9f027a1,0x0000fb08f6575918}},
    {{0x00001bb71891edaf,0x00064a5d6ffe31b4,0x0002b148e3202aca,0x000672cd924679ac,0x0000f9aae98a214e}, {0x0005dab10356c4c1,0x000a2de53c8e3a1a,0x000fe283ee091971,0x000d484dfedf9266,0x0000a8b4a0624aae}},
    {{0x000cafe59e1c69e4,0x000ec2f66c9b2eab,0x0004aa0e4ce53351,0x0005f826078a7569,0x0000640f3228ba1a}, {0x000925c496579dc0,0x00038c97b76be7ee,0x00049904eb6310b9,0x000d1abde130dd9e,0x00007e9c5c47ec9a}},
    {{0x000747bf4a461c92,0x000604cac505b161,0x00039e37325036a3,0x000e3d40936c8564,0x0000d8a870eb02c7}, {0x000b9d2f973fb7f5,0x000c1a615f5d3397,0x000a0a4c943f3401,0x0002887b120a3cc0,0x0000f101a1ac6662}},
    {{0x0004a3d4fee19353,0x00015d011130b451,0x0005ac2c73b7caa8,0x000becf5b0c09c90,0x00003f82f1440fe4}, {0x000b4ab74f14c961,0x000bba7943306bd1,0x000b78631291e728,0x0009cb5c97bf6fe9,0x00001c908352f56f}},
    {{0x000a431a92b58b20,0x000f68a51d86d62b,0x000861d00fcae533,0x0000dd371413a4a8,0x0000cf49037f8657}, {0x000eaf4c3d1f3eb4,0x000521e2f9631faf,0x000851b77e971282,0x000ea6acb91a72c4,0x0000206da3cce7c9}},
    {{0x000d754a64d62c61,0x000ee0355ea5a1a9,0x000e8ba7266cd17c,0x000a54959bf91b62,0x000070bfd9a18d33}, {0x0008a1b0be98472a,0x00030fe418fb02b7,0x00052676e46d3013,0x0006d3b58f556cbb,0x000078fb2237e0f1}},
    {{0x0008653a9f8bb2b0,0x000e96befa270587,0x0006dad18832ede3,0x00068e53b0c689cc,0x0000db79f085c9af}, {0x0001c7d93d122b99,0x000db352a7a11671,0x000c8f1e726becff,0x0001d858067471da,0x00007d1cc378fead}},
    {{0x0007f002486685af,0x000e214080b0257d,0x000cb1b8970c4633,0x000a75ed72c06edc,0x0000da0218c79771}, {0x000f32f5200f7c7b,0x0003a69a8df75540,0x000d5f6e2ddffd2b,0x000fe2ec9a3ffb8f,0x00007df766b5d4e0}},
    {{0x0004d27b3dd34f56,0x0007de6fca2c5512,0x000787744861e22c,0x00006ce2f3d6847d,0x00001ec88437590b}, {0x000c281f52950ec0,0x0007bd6b5c7cab50,0x0003c2642b1c400e,0x0003890397e8e47e,0x0000cf7d2df12202}},
    {{0x0003266882874e03,0x000a89e81d0194cc,0x000549a334f700e7,0x000ebbbe4d500db4,0x0000433030eb4bf5}, {0x000d4c6fbdcd9292,0x000d720ac8474589,0x0001ef26b9eb5ed5,0x000acee19219c5ec,0x000001a7fc35fdee}},
    {{0x000f286f78c7ae3f,0x0000f6fe1ca839e0,0x0005678a2b39fbed,0x000a8e7ba6e825c9,0x00007d7bcb5335db}, {0x00060809ff657696,0x00043fe88e0ad6ff,0x000de58633c659b1,0x000251056cdae14b,0x0000b0b64689f024}},
    {{0x00008e21178a099f,0x0009afd88898f531,0x0006270b71af681a,0x000926359a6e55cd,0x0000e1e802206d9d}, {0x0000c10a39d0de19,0x00011dfc0b3fc87e,0x00058de46f676bbf,0x000ebc32f304138e,0x0000fd44af065751}},
    {{0x000837bfd2c4dafe,0x000f55cb3e99d194,0x000e83b433ea9169,0x000d019bf4f952b7,0x00005a04c25b21a2}, {0x000bf1e7dcbb4739,0x000c3be7dffaeeaf,0x000b4829d1ec04ec,0x000909474be22c14,0x00007e4c57a57cd7}},
    {{0x00061cc613abb95e,0x000cb58aa468c130,0x0000103c600933a2,0x000a98fc90deaeda,0x0000ce472cea4bfd}, {0x000ffac971727969,0x000fb1241fe002c2,0x00094fc710ac9f69,0x000df476c5db7755,0x00008ee99ab46283}},
    {{0x000da7a9e6fa679a,0x00050244f9571a74,0x0002bfdb99609f5f,0x000a0ca351106f8b,0x0000726ad35b71e8}, {0x0001399059b1506c,0x000d5f4c5d58d7c0,0x0004e983e0eec7d9,0x00024d47eab45931,0x000073b2a5db146b}},
    {{0x00053cd8ac3fd6e5,0x000911ae915c1c68,0x00035e452713cfe5,0x000bf9b5b88ed861,0x0000768dd4358000}, {0x00055d4bf4bc4280,0x000cfe3ceae694b1,0x00039860a90b33a4,0x00044533c50782b7,0x0000e0258fbe654f}},
    {{0x000483703eb7f60b,0x0007d6d369a806b8,0x00012af7a09ec39b,0x00037d6f136e5aac,0x0000dd8a6565513c}, {0x000255d417353feb,0x0007cebf91f97a59,0x000d5caba59e9564,0x00024a85f33bf2bd,0x0000a4be8c2c5c77}},
    {{0x000796c75120b49d,0x0008a90e9b928b9a,0x0008f95c1622af0a,0x000ede13d8b3fc2c,0x00003c265423eb9e}, {0x000ebc9a15bd7812,0x000ae6b2d10435bf,0x00011101cea171ae,0x000e63bfb9273095,0x00006dd7cd57f8d1}},
    {{0x000198e5d68cb6c0,0x000c190df284c844,0x0007e36c27d05eea,0x000e6fa431aa9dc0,0x00003b61254ff61e}, {0x0001a8e2b8663dba,0x000587bc144f1d1f,0x0005a87f2ae85cbf,0x0000fb374e6f7b1b,0x00008c121dbc747f}},
    {{0x0004c7bb9087d92a,0x0007c0e6a9bc8960,0x000c69ec2a7a547c,0x000ec22623c94a7a,0x0000525b055cda91}, {0x000b110ac44d3bf8,0x000f1422b1652063,0x000642f08b288324,0x000c8d48a8d2d517,0x000012612181f2e2}},
    {{0x0008cc568e4c47a0,0x00034c3e8a1d2cf8,0x000b8406ce8cac5c,0x00032c23bc082944,0x0000bb19f797a36a}, {0x000f360a586e48de,0x0006e44743247522,0x000e06255c5208aa,0x0004e8f858612ae7,0x0000b4ea39d737ef}},
    {{0x000bc460db94e995,0x00005080649d163b,0x00096d07ee0617ef,0x00093fde45ac2df3,0x00009614177e10ff}, {0x000dbd16ee571c89,0x000a36b028cc1b9b,0x0003821897ca0e3d,0x0005b2397d51cfd3,0x00005ff63bbd9c6e}},
    {{0x000776420861ada2,0x0005c1493e967a64,0x000d92b3fba264b6,0x00026a2e174e2760,0x00001c08d1309e77}, {0x0003add07c55bcbf,0x000e21a28772cc02,0x0006ed92bc89eea5,0x0002ab9f631e159e,0x0000237c626df26a}},
    {{0x000eb0be483e60b1,0x0008a8144da94b61,0x0007e3c9442ec74a,0x0008d5659b08da90,0x00003a62569751ae}, {0x000a60e8fe99eac3,0x000c83f07f5cddae,0x000b6a2c4f4d939e,0x000c3686516e4f8f,0x0000ce14006ae498}},
    {{0x0008be5037f0aef1,0x000400d9612b3b49,0x00000f5494e4a5f1,0x0004b350178c1bec,0x00002194ca390f0b}, {0x000371e991e9b508,0x00066f5513d3e57d,0x000bfed44a8a1cd6,0x000d0caaae2503dd,0x0000e2217e3ec2d1}},
    {{0x000de10dc8a838bc,0x000cb4db84f09e5f,0x000fc31b998d83b9,0x000d314cdae49c2c,0x0000e17fbf4482ca}, {0x0003d5685bc44cd4,0x00011b173b41f973,0x000b6c609b97d020,0x000fa8129cec8ae7,0x00008eb425aa9285}},
    {{0x0000d499bbee7027,0x000794e7726f36ed,0x000f7e50f1106588,0x000372016e8a20bb,0x00007cad5d314d87}, {0x000dd1a9c4d420b0,0x0002e0853dfe07df,0x000883f4657bcb1d,0x000e264db07a30b7,0x0000d54953a43577}},
    {{0x000b7bac5d80fad0,0x00044b2255967200,0x0006673244b80849,0x000399b432f19ed6,0x00007a899f7c61f9}, {0x000ec5ef6da900c1,0x000f95e8e63010d3,0x000ee7310e72fe29,0x0002467c0da3b206,0x0000d1381a884ad6}},
    {{0x000647f72ba142a2,0x000510a8a8617f04,0x0008c5b890377f95,0x0000384970fca731,0x00001b0e8d4dc56f}, {0x00069cdcd6ed4bd9,0x000dc638ead2b445,0x000d215fcc875e7a,0x0003c6dc06beb69a,0x00000645a027babb}},
    {{0x000b0431983cd6ed,0x00007bf2175a80d4,0x000798d7519a205d,0x000fa59086f5341d,0x00007f0d0b4ab66e}, {0x0001892cc0405eac,0x000cbf6a8145fae0,0x000fa60ef8231d5f,0x000d9bcd49a89231,0x0000ddf2a97a89fc}},
    {{0x000d2ffecb831b3c,0x0006c64be18ccf99,0x000b95a73a3566b9,0x0006ade17af67343,0x0000bb14c802d2dd}, {0x000046d9f8cb107c,0x000510d859fadfd1,0x000c8a0784b62dc2,0x000c0a6ad339c802,0x0000cd11269bffaf}},
    {{0x000468da94f038ab,0x000bb71bb5963514,0x00006cfbbfe6dae2,0x000e61154fc00490,0x0000bc8ae6a43e13}, {0x00044f06569f3f31,0x0006aa775eff10e0,0x00034b8704d0054d,0x0006b4251e6260c2,0x0000ef2a9d02c95e}},
    {{0x000ff430a65cf5cf,0x000e5b64c8a24667,0x000eac3ffcec204e,0x000777251bae8db8,0x0000c0889a098bf9}, {0x000fce13803c0161,0x000401026ff03bad,0x000f5e552f8dc21d,0x00091ae48fc57a54,0x0000609011dcbb57}},
    {{0x0002643d816f6738,0x000c3753f6e86736,0x000879b02d8cb868,0x000c7e594838c395,0x000067972ca999f1}, {0x0007d34dfd7c1088,0x0004614e333a9fad,0x00058a876d7b6624,0x000108e3cfac8612,0x000025823b4b5af0}},
    {{0x000268f6a19bb9b3,0x00070a8958a2b4db,0x000e8549f04fad60,0x000d9a69a06eac4e,0x0000d03548e51195}, {0x0004f596dcd373eb,0x00006334b296340e,0x000d58c42a009c79,0x000881171c453a68,0x00001b31a3104480}},
    {{0x000638d6478b071d,0x000d506ebaf4c8e1,0x000f38ac3c0decc2,0x000ef39e647b5165,0x0000428075e5d414}, {0x00028b3e3fe5a0cb,0x0009c6c2309c09a7,0x00009c0e65089762,0x0000d298398ccc4d,0x00001a2ece4161ce}},
    {{0x0004ed542000ffef,0x0006547c39491113,0x00093d2fae58456c,0x000070c2b32044ae,0x0000c506a795a7b1}, {0x0000510c08f5f461,0x0004b53bcfd62e25,0x00072129bad0f10f,0x000fe39c16f090ce,0x00003107a2433ad4}},
    {{0x00094ca6b8261d16,0x00015268752c1c63,0x000960928360a4b3,0x0000531849d69193,0x0000f72583b238ad}, {0x000fb502a8493e40,0x0006bd817731e757,0x000993764b0c236c,0x000d4f08682dde88,0x000027590fa24c64}},
    {{0x0004af2f50460797,0x000d37f2b0ce2a1e,0x0009a8ba740bbb10,0x0008100c3fd4bc4d,0x00002775b5aff598}, {0x000144f7f34177e8,0x000d1f57ccfb628e,0x000e818c9097dd78,0x000458b5e547accb,0x0000c02a026db11c}},
    {{0x000ce91cac08c3d1,0x0002b2736bca265d,0x00089001c395d92d,0x0000fcf505b6519e,0x00008c614d9cb52d}, {0x000ab8803efd70d8,0x0007c604446b154a,0x000619c8c4d96a6e,0x00064ae8fc9320b6,0x000068e0fb54c0f2}},
    {{0x0000cefcf4e70ec5,0x0004e2cf688d23cd,0x0008a11035bb79a6,0x00062874c5aaedce,0x000057759d2b1417}, {0x0001d559128402a1,0x00048367bea79cef,0x00096c617f84a0eb,0x0000d3fd7070c334,0x0000553c0472599b}},
    {{0x000d20f989b9e29c,0x00099deae2b2ff99,0x0005ec2b4b690d6e,0x0008df9c55072b82,0x0000bbf457111cd8}, {0x0009822f0aef2354,0x00029207a036f4ad,0x000ed9f8978a6431,0x0006e9dcb5c728b1,0x0000b9e20713e8f7}},
},
{
/* digit=17 [{1,2,3,..,}]*([2^119]*G)  */
    {{0x00041fa6a39c7f6a,0x0009eb5589baab08,0x000627ba2093d7e4,0x0005a1f11df73ccf,0x0000a3a9614f842b}, {0x0003036faf95407a,0x000a6b88f15492a3,0x000ef2aa8c72f6ed,0x000797929383c9bd,0x00000d4b788e861e}},
    {{0x00028e853253b32c,0x000764a3d3e50baf,0x000523564b25a2db,0x000cc7f385d655ff,0x0000d11a0255d54c}, {0x0005cc1bf209a125,0x000965f5e1df998c,0x000023464fa162cf,0x0009a40a48610028,0x0000fd3f9f50b2cb}},
    {{0x000a5228e90b176f,0x0000c1c3bcbc9702,0x0005ae8e770765a1,0x000f8b56923d8d2e,0x00008e74adba5e4c}, {0x0008ac1d36d9dbc1,0x0000bb6bcfb20110,0x000fa9d7efcf1d34,0x000aaad4625764cd,0x0000a06c7fa8fafb}},
    {{0x0006be82919499b2,0x0005b2e0e8754c2a,0x000ae54ff9e14e89,0x000853a30ef155b2,0x0000ecea0175c713}, {0x000d2365ed695a76,0x0009c344487f8ecb,0x000cbd5f7dd9d9ec,0x00093f8a2fa3c895,0x0000b4000583e162}},
    {{0x0006dfb3c80537c1,0x000928b656a8e73c,0x0001a720c007d242,0x000f0f7f2f75140d,0x0000307b44bb2faf}, {0x0001a93776043d2a,0x000131bbd300fe21,0x00012b8b0d581890,0x000bbec7aa05b0c8,0x0000c0d90f4dd862}},
    {{0x0001ca3ee253969f,0x0009e918dfe27423,0x0006aa687b67bc7c,0x000dacd55607b710,0x000066e8c14a024b}, {0x000f5d052e5ba875,0x0000afcc0c31ef9e,0x000cda3636263f60,0x000872630cbc5ef3,0x00001148ad0d4f22}},
    {{0x000777b4aa7e5304,0x0003615e1bdfba24,0x000858bacb14b766,0x000b945ec88b6fcd,0x0000bd20cb06635a}, {0x0006f5bdaadf1ec6,0x000c7d8267bddc7d,0x0008015bc00a297f,0x000366ce5cbef6fb,0x0000bef7be68218b}},
    {{0x000a98c52873cedd,0x000a4dce333a9777,0x000c49337107cb38,0x000d4e5d090eebee,0x00009c1f6657ee06}, {0x000ec426251c702c,0x000182c9b521b4df,0x00075e02a1270247,0x000e54af1cdaf2a3,0x0000dc7ffbf6f46f}},
    {{0x000522738eddba89,0x000f79659871f8b8,0x0003d82764c79ac3,0x0001c2fc21f3b82c,0x0000caedd9348e18}, {0x0001c424c016898b,0x000369f16a2211bf,0x000d0ee361012838,0x000e2f5b3b65c786,0x0000dbd3e2f44b64}},
    {{0x000ade03aff4bb02,0x0008b4529f4e17b0,0x00043bbb7fdbc450,0x000dd77af503eac2,0x00002cee72b9a511}, {0x00047cc71bb2a4b8,0x000c42f41d52bb5a,0x0003a786fb0e56c3,0x000b64068993ab40,0x00002c6197dabf9f}},
    {{0x00037d63972795aa,0x0009bbdc815efc80,0x0007ab6e71ef405c,0x000a874747c3c51e,0x0000f1d220edee78}, {0x000211ed3c96c1b7,0x0001bc179709211a,0x0000e0198510be77,0x000ea2a633d65d9e,0x0000562f78442b7d}},
    {{0x0007889df799db5f,0x000ba012c603f759,0x000ca505b101e3f2,0x0008490b743f6b4f,0x000042757e975d7c}, {0x00039e82875f4bb1,0x000f8ff53a5da9f0,0x000ec746f6aa587c,0x000474838f092ff9,0x00002758b9877567}},
    {{0x000825e7bf6ef16d,0x000e3b0e3eed4f65,0x00082804995e95a3,0x0009ac66e3d6ef1e,0x0000140e9150990d}, {0x00048379d22a5ca1,0x00006beaef803d57,0x000d94eb0997a2d9,0x0006df77b8617ffd,0x00005a68f3e15466}},
    {{0x00044939e5337133,0x000022bfa31f90af,0x0003a6b0a68785ce,0x000614dc6b2e1ac3,0x00004b2ee53c3f17}, {0x0009ceacff767259,0x000500352afe92bc,0x000b09c4726df2fa,0x0009aa62ed60a55b,0x0000d183787441ab}},
    {{0x0005c96dda71597f,0x000683e67ec813b4,0x000d724183cd30fd,0x0006536b8f8530d6,0x0000632c3ac24270}, {0x000b011fe29506ef,0x00057d43147ea463,0x0002a70211a49273,0x0008988dfb701702,0x0000debd588711ec}},
    {{0x00090744b027acb8,0x000909729b2dd4cf,0x000c784e4eef7dfd,0x0006feaaf145f925,0x0000ec26936eb073}, {0x0003622990de2b9d,0x0000059c4c7d2565,0x000f374f6997d858,0x00015e6db4239a6c,0x000061e73252bdd5}},
    {{0x0000c24d522fbc0b,0x000a942bb73d7298,0x0001ead460b4f626,0x0001ddb380775ed4,0x000081f005390776}, {0x000d2a88d7ed3d9a,0x000a953ef7cd9a17,0x0008cb51593a12b6,0x00041c930e0d8397,0x0000396686f3a8cd}},
    {{0x000a7aca5295f85c,0x000d1715f010ada4,0x000137d62ed99476,0x000a2c1fcf92691a,0x0000965ba19a5dad}, {0x0006e96b9c400652,0x000a0f797bf078b5,0x00027bfa01d46a27,0x00088481a98f9ead,0x0000e828cd3a93a3}},
    {{0x0008afbdbd10a431,0x000d106c891c4914,0x000c9e0e75d3c212,0x000d14e69985bb06,0x000006751cf618c4}, {0x000a3dc9130b9b81,0x000c1201b63586c7,0x000247844a994f46,0x0000e8518f9b96f4,0x0000552e79eb2973}},
    {{0x000a7cf36346748c,0x0004f02b5ab08498,0x000a67c8add8490b,0x0004083da6e9932a,0x000000ef8174e556}, {0x000ebdb7e8317689,0x0009dcee991652fa,0x000b17155928e7e7,0x000bfb43e0c0dcf1,0x000061d9f54d10b7}},
    {{0x000fea920dc3621a,0x0004c5a9ef80adda,0x000bf625b196feb3,0x000c75a487e45e47,0x00001586634f3500}, {0x00078e658ad24f8b,0x000b7ec508d6416e,0x00086e5d355ff7df,0x000160bf2a2a10f6,0x0000e97f906d9cd7}},
    {{0x000cf2ecce6a83cb,0x0002141a1def5419,0x000b08f6b415a133,0x0003ee9d14d27344,0x000001759dafa67d}, {0x000806af6fec05ea,0x000d7b011a04ca90,0x0001b07594714b39,0x0003766edb734998,0x000077fdd00849e4}},
    {{0x000869459607c4c7,0x000c4a2823d2a191,0x000f0c346c25108b,0x0007d785158a6d3b,0x00007e489373cae3}, {0x000a7f304840c842,0x000a08f43f2912a2,0x0002fbe1729e4bb0,0x00028709c4f280f9,0x0000201f93611efb}},
    {{0x000ad0bda7974af4,0x0005389c05296416,0x0004cb76abda5ecf,0x00088f85f754c7c2,0x000047c39eefff6a}, {0x000ef4343c9b4a94,0x000d4bb7a27b96c8,0x000f48abe786978c,0x000ca9cd7614727c,0x000061d39a4e9882}},
    {{0x000b2bcdba7c5bef,0x0002040e82c7d98c,0x0003da87f7a20776,0x000de1523702befb,0x00001de9d096e046}, {0x0008b008f178210e,0x0000448332b989b3,0x00042b84ffde25ce,0x00070d3efeacb710,0x0000f18da37a2d17}},
    {{0x00060e26735666d2,0x000fc57f5610acbb,0x0007546d4a7366dc,0x0003a833bb5f11b2,0x00001d815c609e9c}, {0x00095cb0437ffbfa,0x0000948f5b486c09,0x0006bd916f7bcf31,0x0000b87395b09b27,0x00004e8d8c9a4070}},
    {{0x00041de5bdbd9371,0x0007be38711fa84d,0x0006f2cb401fcc83,0x0000193a4baf92d1,0x00005c9fa811626e}, {0x0007ce2ec2720c70,0x0008351012112d54,0x000741181f3df95f,0x000fb101caa1421f,0x0000a6d145391ef7}},
    {{0x0003e76f52e737b3,0x0008b153cd4c597a,0x000b1f2cb690af03,0x000fe5aac80ff54e,0x0000f1fde4870f82}, {0x0001d9fc80aa5815,0x000701e0254a9b91,0x00008d9e03b39021,0x00058cb9d9791e0e,0x0000755cc5bcb5bc}},
    {{0x0009e0c2ce860434,0x000fad99789d9347,0x000ca723a383cfe4,0x000ab93713011097,0x000015d43c8d3294}, {0x00089eb941c9f1c0,0x00077e0a78126ce0,0x000da428594a8b44,0x00045995df8d73b1,0x0000085b5acc6ba9}},
    {{0x0007d41d3b9f2be9,0x0001e317380a4f50,0x000743cd69a185b7,0x000a3cb0ef1dd23f,0x0000c6f878d3ac81}, {0x0002defd67e4c7a9,0x000b3b6178e5ad5a,0x0008fa9c2073e098,0x000e3f845fb5d329,0x00000ed787e92ecd}},
    {{0x000c2092f308c0e2,0x000cf372518753d3,0x00059ce271c67fa0,0x000b1d3d864e401a,0x000067229588778a}, {0x0009ac48d524d467,0x00099d0876b9e6ac,0x000365b626974faa,0x000f2027749d4cf2,0x000070d784766bdb}},
    {{0x0005d1d7ca4afe69,0x000f7a9e7f152ce1,0x0003ff356ee399b9,0x000662e7d64a6c2b,0x00004e83beaf5730}, {0x000c85f020b5cda9,0x0001bec166277cc4,0x000cfd24f3afda30,0x00076a744e4b56c9,0x0000a9916a5eedfe}},
    {{0x000fa6272bc5acf5,0x000cefa642bb8d4c,0x00068f5594a97456,0x000df80bedbcfd29,0x000069874eb72838}, {0x0008a12ad07adf76,0x000a250132b7f40a,0x000e03fac5809168,0x000a22c9ab9c544f,0x0000df51bc0f4dd0}},
    {{0x000ad692517a2b9d,0x000b734402ced5e2,0x0000f7b228d8914c,0x0009398f05425fa0,0x0000ec8d276b76ec}, {0x00069d5463a061d6,0x000728f1acfb036d,0x000cd88a2d6ddbd4,0x000ba149b9378346,0x00002bbbfad499d0}},
    {{0x00010c3a4809f81d,0x000743c8ba6258e1,0x000de0fe62140ab3,0x00009b8609de61a8,0x0000981e461acd1e}, {0x0003461543c36db0,0x0000f993771d6b06,0x00033281a273ba0d,0x000c77143e6ff6e1,0x000035a642c2fc19}},
    {{0x000ef8af2b81260e,0x0007770b18ec5710,0x000a1ea80ad37192,0x0004707b4022fecc,0x0000fe51b5f7bf41}, {0x00093d72d28d2eae,0x0009b90c140f34a6,0x000335e00449e2e1,0x000091fe11c41f75,0x0000eaa50b2c1865}},
    {{0x000cfccee288755a,0x00076204618d3307,0x000b666fc9acda01,0x0009c38ee7071f98,0x00006f3fade76154}, {0x000c58c20c01f25e,0x000a2f9c9a157e82,0x0008d7ef9691b1e0,0x00034c9b3ea053c1,0x0000fe72dbc256d6}},
    {{0x0005764654f25ab6,0x0009ae7b52161674,0x000bc1c4b22e7a1d,0x000c905ff14471fa,0x00008d2388cb4775}, {0x00068e06e8a88b79,0x0007d25e7385d977,0x000b4997f422d547,0x00018f9575d9ad31,0x00008a642eb9c009}},
    {{0x000635f43433b57d,0x000665e0a64cd543,0x000f7611b6157565,0x000371fe20970719,0x00008f08a7576fb0}, {0x000f528e7c19e126,0x000d86a273b686fd,0x000ecb6a9eb7491c,0x00099d7cc31d126b,0x00006d5b3b32c1c2}},
    {{0x000d0b2e25cc9404,0x0007ea222455a916,0x00089fc82928a4da,0x000ac5c3a8de8988,0x000064f26e535f2e}, {0x0009e29fd63260f0,0x000dd3e24fc71457,0x000bae4202864593,0x0003c6895e5601a6,0x0000c5a1f6069911}},
    {{0x000dfcc37d0c2daa,0x00007dfc9cca7ffc,0x000b7d28f4112fdc,0x0000060424fc5c4e,0x0000dc27dc84402c}, {0x0005cf0f7a1c6f9c,0x00072632a0fbbeb0,0x0001285f3c9bf405,0x00052cb7ba5b1373,0x000024a1d802dd1c}},
    {{0x00005e8e5d9c7c3d,0x00038f7b6bf10095,0x00089e65c94ef08c,0x000d589c3fc80399,0x0000512ab462c8e0}, {0x0006248da5cee075,0x0004b0bf71366122,0x00009b19f788483f,0x00068461ae7d4670,0x0000e3240047ed4d}},
    {{0x0004a8045830ec3f,0x000ff27347bdebd9,0x000eb6a8bec329d4,0x000a3bc9be726d25,0x0000afd3ea7f8f65}, {0x000de1f94e8ec819,0x0000fd5786e2d77e,0x0008c8d2f48236de,0x00088e979e9d9bc8,0x00004177d03e4855}},
    {{0x000a920680b0b442,0x000dd67952d80308,0x0003db335984f1ab,0x000ab57e1ee014c2,0x0000efa311d1fa2b}, {0x000fa774c0978f94,0x000d6ef134fea6a1,0x0003be2502663d93,0x000589a91cb57c89,0x0000e81b2b61a07d}},
    {{0x000445556f590009,0x0001d606164fbd7f,0x00055c8b39ec5161,0x0007b36417bf0954,0x0000bfb7b6cc3e60}, {0x0007ef44ff8e3e17,0x000ee02f7cb58de9,0x000726935b92e359,0x000ec248d2c5ba66,0x00008f73b6ca1537}},
    {{0x000ea9a101c27ebd,0x00088450bc2d762c,0x000a6b7821eaee2f,0x000e7617f29336dc,0x0000bc610f11b9ee}, {0x00020c50b2e18605,0x0009a3531a079c62,0x0003c6f4589a8346,0x0002726dc650c838,0x00002cf4bee72e9b}},
    {{0x0005ef53014f895c,0x000dd9551573a2a6,0x000147dcafddcafa,0x000427c62e1a2646,0x00006be9a834c331}, {0x00031b08c02f0e7f,0x000609f1f2c5658d,0x0009db9bc2cb949f,0x00041b03603bb15e,0x0000294d7c597e01}},
    {{0x000f7cbdd4b39e30,0x0007591b53bf0d2c,0x00051085bc0a78af,0x000d6563b36998a2,0x00008f29a516edf9}, {0x0002df96b9af9b9a,0x000aceaf18ac1998,0x000cb38bd6224ff1,0x0009b595e64776cd,0x000086b39f9d62a5}},
    {{0x0006cc6d42576447,0x000663d1585e0963,0x000718b6eb780a69,0x0008a786d3112c4f,0x000050513009055f}, {0x0001c1f94b567f55,0x0008f04cad491658,0x00005055750428c6,0x0005942f8ebe9db1,0x0000bff399ae72d9}},
    {{0x000b37679ef9c071,0x0007c79b043a42e2,0x0001c11d543e3065,0x000090850df636db,0x0000cf5e687e4648}, {0x0004641c28d6f0e4,0x0009d91286f41e3b,0x0005a6a95105c1d3,0x00040a84b6eed5a4,0x00004f9c5c40b1f7}},
    {{0x000635917a1fc0e6,0x000de448fa1d343e,0x000d04e3e582a0ed,0x000b5be78e3f3810,0x0000e69322253204}, {0x0003f2d8fdb2f68b,0x000dd150d2fb477b,0x000e74fd46b26937,0x000832fb96b093bb,0x0000fd4236540d29}},
    {{0x000627c7da59bb55,0x0004a420a8a1e312,0x000b69e2db5a517b,0x000f174190a03a06,0x000034c0dc213d8b}, {0x0007341656c0a5bc,0x0004601ccf3374cd,0x000728ffe8da09bf,0x0006f93d580e29f4,0x000070d257e9d4a4}},
    {{0x0007cb0ef9a7de8e,0x000c7be468b6982a,0x00013cbb99b936ba,0x0006099f3a374002,0x0000d5e01e4045c3}, {0x000fd2a477e5592a,0x0008ab788c4a8e5a,0x00062949464a88f7,0x000f822e6ed3ab7b,0x000049956ac60d9d}},
    {{0x000632ac60494b85,0x000755001958b3c9,0x00092a6b084635a0,0x0005d4a6261cd6ca,0x0000c5c5a09d09d8}, {0x0003c778bbdfbed1,0x0000571017535054,0x0007f0364db303b2,0x000211c2f39c2c8c,0x0000b2228378b171}},
    {{0x0001b82327cbef8e,0x0006712292a1eb20,0x000d0aa8149ef800,0x00044484bd3c30a6,0x00001bc4794e2151}, {0x00007c4a40a45ab2,0x00072ef2f8c60537,0x000ab01c42dd4a68,0x0004c68445e92c6b,0x00009930cf73325b}},
    {{0x000e0f195743160d,0x0005e665920d09ed,0x00037949c34c1646,0x0001563924baaef5,0x0000864d65b629cd}, {0x000d0645d626af27,0x000b919ee5e27e75,0x000bcf4e3b28ade6,0x00072b450f7afe7d,0x00002fc16bb41c90}},
    {{0x0001f5474504517d,0x0007449fd75747aa,0x000d80fd4dd4e899,0x0000fb1503a0575a,0x00000bcf27aa872b}, {0x0001562ee6845a9b,0x0003adcbda3beec7,0x000e87f54cea9040,0x000d9aa4b0fd3e40,0x000055424363272e}},
    {{0x00000c0c822a63bb,0x0004adabf48f17a0,0x000c2629e0a4d95c,0x0005564c47efec06,0x0000fbcf94b6fd09}, {0x0007de8757b55d12,0x000113777841f5cc,0x0003e33bdeb58cf8,0x000534cfd0dd9945,0x000091a701a6191e}},
    {{0x00034fc2d6c998c3,0x000f5f1753a09b2d,0x000707feecebe5aa,0x00069ae9d032ee76,0x0000b6aa01f1d59f}, {0x000215a8ac67882a,0x0004aa4451eab1bb,0x0003598726a6d1c4,0x000ec7ca810ae0fb,0x0000c1072b2ff7a7}},
    {{0x00062dfef6c9d3f9,0x00089e8be45575b3,0x000c3679a444f608,0x00071da3d3cefd86,0x00009c6b4fe674c5}, {0x000df41f2400d99b,0x000e475f7d54f051,0x000134e5aa9dfed3,0x000b7685cd7bf7e3,0x0000b240168e9d1c}},
    {{0x000f0d440f9f2318,0x000c0a943da7cf17,0x0009cb3de587af78,0x00062e9e6652099c,0x0000b949476ce142}, {0x0005db129e890250,0x000a0753258e9fa5,0x0002708f8e51d5ee,0x00097e68246e57ab,0x00009d5a84444486}},
    {{0x000537887ec45f50,0x0004ae322bdb29f2,0x000adb167eb07940,0x0007ad30b3e3e19d,0x0000cd3891451308}, {0x000e460bdfbaf9e1,0x0006182f1a4179d4,0x00095e491e6878d6,0x00021d1b6dcd2c5e,0x0000e017c1488203}},
    {{0x00015e8bff7115fc,0x000daac297105666,0x000baadbd6bf7eec,0x000495ef121aecb3,0x00004b4a97a0b0f0}, {0x000019c825163c75,0x00095c56e3c4a123,0x000b6668b677a76b,0x00092bc127011ec5,0x000076ef43ce65f6}},
    {{0x00079e1d0309f4a9,0x000d470e28f20534,0x000381c00c0cf6f4,0x000f7d93eb4f59fb,0x00008542677c1440}, {0x000f92b296bd38fb,0x0002503a89b42228,0x00027708a23f058b,0x0006defa6cc068e8,0x0000ed74c5c5e932}},
},
{
/* digit=18 [{1,2,3,..,}]*([2^126]*G)  */
    {{0x000bda36cacdb2cf,0x000910b10ef58eee,0x000d29b4c26a98fa,0x0003e3520f48c766,0x000080d336a84be4}, {0x000adf4bead7d2a2,0x0007e7f8e550baac,0x00016417827824fb,0x00050949f19c4c62,0x0000c4b8ae7907f7}},
    {{0x000429a647025b7c,0x000f6df2b6d14a77,0x000609d41bea840f,0x000070b3276b7b67,0x0000d649bb3d432a}, {0x00057149509e594e,0x0009f596b64efcab,0x000a64e95827d522,0x000fd96c407e119a,0x0000c8006ba42564}},
    {{0x0001f1f6379bea52,0x0003f11b63e85354,0x000bd1b7caedef57,0x00000814fa04ef2b,0x00000ba83d7a9136}, {0x000975bc42555421,0x0003bef8e88beb41,0x0009541ba9f5aed0,0x00002dcdb28a4ddb,0x0000c066be89e1f7}},
    {{0x0009e6504120719c,0x000a1d96a1faf50c,0x000f5b3b23b7d22a,0x0009b4c352bf7130,0x0000978872929651}, {0x000356cf46ef6d36,0x000d4b97e2b6d316,0x000745689d64bc86,0x000562e5f781a12f,0x00008e0f6cd43d40}},
    {{0x0004a418781db583,0x000ddb124e3c2a76,0x00081c4f1f2539f9,0x000d86b17c619fe1,0x000024aecc3f2e6f}, {0x000536d45da54e56,0x00008208d6bf93b5,0x000bbdebc0443405,0x00079e4ec013e263,0x0000aed5ad15e7e7}},
    {{0x00005bb45d491a70,0x0004f423f59393d2,0x0008aca8510e837a,0x00078a4b50263ba4,0x00007b7f90bb8d6b}, {0x0003e303142c350f,0x000579c8254cdd54,0x00007552b0caff31,0x000f3c7248599467,0x0000b09e2c65643a}},
    {{0x0000623413605a2a,0x000e240c98eef219,0x000f738bd35a0ab1,0x0009cd49fd931436,0x00004b15c7d1bfb8}, {0x000dbe8e750cc8c8,0x000b2cf64775adee,0x000319f210d69428,0x0004c23bb86bcc34,0x00000692bf71bc31}},
    {{0x000dfb3eb9b38812,0x00060a94cb32edd2,0x0002674cf6680001,0x0004a91b08a68240,0x0000a3f5713fd970}, {0x000b550f67fb936a,0x00009cdf975dc67d,0x000d4f8ab994e401,0x00062714fffa287d,0x000076cbd2a37974}},
    {{0x000e793d6134da7d,0x000bfbaad67700c8,0x000044bc3a9b1458,0x00077a29db52c0a4,0x0000ae12105ecf19}, {0x0002c2d93e614751,0x000a3490a4cf1ae9,0x000abd69904507c2,0x0008d306a123b893,0x0000b8500fd782db}},
    {{0x000abf3c48af855b,0x0003d34d16708b4f,0x000a6ed07a282725,0x00019f730cb8f53d,0x00004ed0b7fb72b8}, {0x000816f3f3cbd30d,0x000d59260df36d85,0x0005cd9529f3ed7d,0x000918b8a442833c,0x000032c62276ad4e}},
    {{0x000505323819ad11,0x000a66c1746fd93f,0x0004515701dbeb19,0x000ac25d76041aa0,0x000039541e46492f}, {0x00082e4f5acecbe4,0x00047f003d36ac5c,0x00043a011a75a08d,0x000a029ab7481052,0x0000a07bbb938ff3}},
    {{0x000313ef5b5203b0,0x000154281306d809,0x0007c4b68fff9649,0x000164f75079e9fa,0x0000ddc7de06c72a}, {0x000a43bee64870b2,0x00058d075707ead1,0x0007b284d06638d0,0x00026466a4426597,0x0000eaeec425f7aa}},
    {{0x0009ce770a7c3145,0x000bb6337494e900,0x000a3e657770528c,0x00046d72c5c2351c,0x00002af88081301c}, {0x000002b6736a4987,0x000c03a730f22f8e,0x000a208d941c9745,0x000aed32506797d7,0x000039e0f2030605}},
    {{0x0003d4dfd808ef40,0x0004a58fcc7a1a47,0x000d19ae0ad86492,0x000cfe1443bf900b,0x0000040e88ad8cdc}, {0x000fb32cf6f58d39,0x0004562194b4f5d3,0x000375f3350db919,0x0008ebda78332dc7,0x00005e8bc45b952d}},
    {{0x00037937dd5f4dc8,0x000ad87dee916fc5,0x0000f9f838cdd726,0x00035bd06c293d17,0x000082c987f7d4fb}, {0x000e6e2af0881b65,0x000cecc3a59895a3,0x000db383e0d7d33a,0x00049900fdc70f9b,0x0000f53161d8db37}},
    {{0x00019a6df48dd005,0x00078c392aee7d99,0x00047da22270b610,0x0004292dad3f50d6,0x00004f9084de0936}, {0x0005ceb1e6d4f40f,0x00031c3e122362e4,0x000da2cb1ca24344,0x00089b025e58689c,0x0000ccbfb734d9f3}},
    {{0x00056e296b1d2a7c,0x00059aa411c51ff2,0x000534da9f87d206,0x000e1eef18a860a5,0x0000cafe63ce745f}, {0x000de8dab4468f3a,0x0000fb7e0c6a3275,0x0006193be6dadc7b,0x000ba599d3ced6ee,0x0000dbb9b3d4d796}},
    {{0x000f56c3e083f9ab,0x0000f603effd3017,0x0009c1d0099ea92c,0x0007d4e4fbe0dbe4,0x000058f3d2157ba5}, {0x000ca441fd54b954,0x0001acfab07e949c,0x0004453173fafb5c,0x0003e4c363c1d941,0x00009a533ea85b8d}},
    {{0x0006b73590d7896f,0x000cf513e5a6272a,0x00050b6b74115ef2,0x0008e802ec0c8d3c,0x000049dfcec6abc6}, {0x00026d644b778478,0x000145e3ef68d48e,0x000f9b1877d7f703,0x000ca9888630059d,0x0000e9f78f370136}},
    {{0x000cde2c3f33edbe,0x000ec5924d163d97,0x000758c8e3452e6c,0x00032d47700eb684,0x000001d15f0a9f82}, {0x000418cc0818999e,0x0007ac6d0ed810c4,0x000b5e011052bb51,0x0000cd43a902bc60,0x00002a9eeb8b57ff}},
    {{0x0009cbbf986df839,0x000414b85d3a71d7,0x00005e069c77aa0d,0x000f8f79dbf4a89a,0x00001526933b2c78}, {0x000844b710bed445,0x000cab49b00f7c1c,0x000718415d8c3d66,0x000865e5b99f683e,0x0000f111505bec98}},
    {{0x000b317b5fec109d,0x000ee60dd74ac94c,0x00063fc3e8bcf0db,0x0005aea594aafcc1,0x00002fd718e53283}, {0x0006bfa2ad47da58,0x00065d79c62c0537,0x00022ffb34140d60,0x000316bdfd12c941,0x00008ff86a718219}},
    {{0x00005b5677be2211,0x000de539062c2e91,0x000ee1b283c1d085,0x0000ba39a96ec9f8,0x00005bef7b5be408}, {0x000d5fcee8efdc4c,0x000c2f4b6689630b,0x000821b7000e829a,0x0006ac1efeb571f2,0x0000900fa02078a3}},
    {{0x000ac0bb76286c73,0x000d00f0c3a98fed,0x00087e24013a68d6,0x000322ae9cfa421f,0x00001657a067cc6f}, {0x0002945e67c00f12,0x00008ced22dd80a8,0x0005f0311374391e,0x000812c96c16f73e,0x00008be3307fc625}},
    {{0x0000d24be55cf092,0x000bdccaaa5ce5da,0x0008f0f8dc643eb3,0x0000f68b247fa097,0x0000c0f660a3692d}, {0x00041339e5f44cd6,0x00038483a65d698e,0x00067c073941df7a,0x000ed7f027b59c3c,0x00000823924cbd81}},
    {{0x000e36f7b744a49f,0x0001e8cea2841e6e,0x000a884d4e78ac9b,0x0002006211afc386,0x0000bc9bb9210e86}, {0x0001811b825aa7d6,0x000fb8213b25406e,0x00056e2bd62d5f8f,0x000b0d142d4390b7,0x000075f859df9893}},
    {{0x00057cfe953f406d,0x0006157c97bac651,0x00024b6d0bf2ff3c,0x0000073279a7e31e,0x0000cd7666235cc9}, {0x0005f46b2d76ca4b,0x000b0c3acdad6d7e,0x000d9e9e19354299,0x0000b8f783e65fb7,0x00000c641307f969}},
    {{0x000c59b6284008a8,0x000ad0ccb64fab61,0x000697bfa47d385d,0x0000a004d91fef33,0x0000201b805d7b1a}, {0x000b4cdbd7634bf8,0x000a8b1db7c95182,0x000a7b2b0dc8df9b,0x0004e30b652cca38,0x00009346424294cf}},
    {{0x000967ec6fb1f7d1,0x00013f8595e9532f,0x000760d79b0e83e4,0x0005cb6f0edab69a,0x000015764aef0bc4}, {0x0009ea00e9a799c7,0x000ac5b817fb15d5,0x000ad401b2f89864,0x0007afaa02dcaefc,0x00008c0d626305da}},
    {{0x000f2627ea780449,0x0004d0e16afee339,0x0001b1273fed7f14,0x000b2aaf8ae2dddc,0x00008e33f95fb10b}, {0x0003ee06234667b5,0x000f276fd3a5674e,0x000130d66a2b11a9,0x00010566bac7e07b,0x00002e0bb494f27c}},
    {{0x00054f5c6635026b,0x000a5a2c274a495c,0x0003d78d5e70c783,0x000d415596f0ba22,0x0000bea114aab96c}, {0x0006e4a26ec6994e,0x0003684f55dc21ce,0x000cb57be6c33dcb,0x000313516f6d6dbd,0x00008f669b41b988}},
    {{0x000c339ae3dc8edc,0x000f91873e0a1cd8,0x0006e937184cc542,0x000c8d374985e854,0x000064db8f80da1e}, {0x000fd63fc2e60274,0x000092f545cfdc42,0x000f97827e622ee9,0x00065dad12fb4d99,0x00009f63d4cea6ee}},
    {{0x0001d6efcdf88357,0x0008d95feecaa92e,0x00070e0938b6f590,0x000a9f0529925a20,0x0000cc42d8fc5d2e}, {0x0008c449b39c8e3e,0x00018b9ff21e615e,0x000c5b91c41f334c,0x0002004dc2fadbb9,0x00006d8605de3771}},
    {{0x0008cef52c6038cb,0x000595e25e5d6385,0x000a8e39d52faa35,0x00038504ffcbe219,0x00000875f8ef9618}, {0x0009872453c11381,0x0005c29f2eb78994,0x00004e6c20daf621,0x0005430dcf55501e,0x0000288ec97e36c0}},
    {{0x000c030591d26efd,0x0004d6d48ef7dce4,0x0009fd5d0405d2b4,0x0009ebbe289fc630,0x0000f97f0f01043c}, {0x0000b590022dc8ea,0x0004f976d4fbb359,0x000cecbf9a4644fc,0x0003207c99203ebf,0x0000edece41acc46}},
    {{0x000a362d721e9089,0x000a8925abc2aab2,0x0005350debe2e21e,0x00009fc91b3baa47,0x000048d66950c56c}, {0x000efeca03b29fb8,0x000f6bfda542da62,0x000139636634ba83,0x000c501c74caf2cd,0x0000b76d82e0f5b3}},
    {{0x000f6a56da8987c3,0x000e1aae6fe463a2,0x00059cd2c45e1dbf,0x000f0def678e8651,0x0000cea256fdc1ed}, {0x0003034d6ed1ba9c,0x000d0bf5e4dac73e,0x00084887837e23c3,0x00093ecd182d4808,0x00009476a1eec1f3}},
    {{0x00052dc77d7fb769,0x00013ff38f95cc7b,0x000733f795b3e21d,0x00090f612de561ca,0x00000f59a5455061}, {0x0007d48864196b53,0x000db4e3286957a1,0x00022d8d9ef59a96,0x000546011073136b,0x0000f1697c656115}},
    {{0x000317c1f8fc48ed,0x0006c0c0118eb24c,0x0000b3a095d3b7f5,0x000bbb608213550f,0x00005d5ad61f1fac}, {0x000a62d9583b13f2,0x0003577ecca5129c,0x0008c4140f3beafb,0x000b94480bfb33f0,0x00003f0a96a83959}},
    {{0x00031c65de0895cf,0x0006825228776fba,0x000cc88cce49fb2c,0x000d50e32472dd56,0x0000e65850b7a0d3}, {0x0002d9997abc2bc7,0x000247d47511ebbf,0x0000c31ba0b5abb4,0x000ba45f83b7816c,0x0000b1293a82eebf}},
    {{0x00014867763f2007,0x000c9a238ab540ca,0x0002810892f80e56,0x0000ae04b954b5a9,0x000009638ba155c2}, {0x00045f04b72df059,0x0007c79932f148e2,0x000f4ad95262dd9a,0x00058706f74ca482,0x00007911b864b69c}},
    {{0x0000b9c737140708,0x000667edd421d9f3,0x0008968685c81d98,0x0002788a4eac735f,0x0000023a157c9f57}, {0x000b4b003c82278b,0x000a81472fd167f3,0x000e0926bf38ac74,0x000e573126c462f5,0x00001ca6838518a1}},
    {{0x0001d85ac1d95c07,0x00033d583ca23351,0x0005118833877919,0x0002e080183f6e60,0x0000ff39e0469cbc}, {0x0002e04f226307cc,0x000f4bacaf9a2435,0x00074e2a51232d0b,0x0004f77d72b628f0,0x0000acec834b62bf}},
    {{0x0004545c8ad66709,0x000cfc688d8046a9,0x0004edfdc8d75925,0x000f05ae813c9e06,0x0000f09d9f9bb086}, {0x00062ca1db3df5b7,0x000c5b5ffcee14c9,0x00098918be83ad5a,0x000ac894b0684569,0x0000a8eed798d0b3}},
    {{0x0007970ef932b7f4,0x000f2ef627b27d5d,0x000b1f232a660b84,0x00047a67e2544348,0x0000f46ef3c81556}, {0x000ae5e50254dbfc,0x0000dbc8b8f53a6f,0x000f81f9760130dd,0x00056daa15ae29e5,0x0000531c6e3d8872}},
    {{0x0003fc5aec293c17,0x000fae2a8b3062bd,0x000d294391c65007,0x000ba8bc7a567060,0x0000e892b188f41d}, {0x000fea5c9cbb5a66,0x000a06ddbfb94b09,0x000a553dda4501d5,0x000c2b5f030fbe8d,0x00009f35d7661397}},
    {{0x00053c7d6c32ad49,0x000e202b6f62edae,0x0009918ca0e11d30,0x00064c3b7cc78f3d,0x0000aeb2ed04daba}, {0x000308348ade515d,0x000a42f73385ada9,0x000c1e0d66b4b6db,0x0008698732c86253,0x000004118fd191f3}},
    {{0x000796becef5c499,0x0007cd9c3e671366,0x0006808dd995c7ed,0x000e24412560f80a,0x000092c05fbf5a45}, {0x0001d3fb0df606cc,0x000bfd721b8febb4,0x00095b3096c03c24,0x0004db6d2624db4d,0x0000abed17dbcf2b}},
    {{0x000c4df41f71eab0,0x000a65e016a9a3c4,0x000dcf582ca058e1,0x0007f71ec4c968da,0x000026cfe1cad268}, {0x00096c924f46e504,0x0004491a46f19726,0x00070b7c43b16a8b,0x000da051694c0dab,0x00004ee2a129241e}},
    {{0x000900a5814e9247,0x0005613cf2606c1c,0x0005cccca1791d81,0x00048d0077d293ce,0x00006bc874a43ebc}, {0x000037e17cc1b585,0x0001d8d11bf83c3b,0x0005987d393c01a5,0x000228591bf583aa,0x000025efdb1260d8}},
    {{0x0003d91512d96c5e,0x0007e4b4ad0fa8de,0x0007b0bb68b040c8,0x00043c9dabe6dfa3,0x00000d7ee9b62348}, {0x0006da6bed5911cd,0x0009a6ece7ff38f6,0x000e5dd83880a808,0x00053087b04129e5,0x00001bbc6c30ba0f}},
    {{0x000e84dbadaa5f56,0x000cd377815fe20e,0x0008c62698e27faa,0x000347e02c37a9b4,0x00008e9bf569f39b}, {0x0007b248d318a6ae,0x000474a21df44e51,0x00031719dd246130,0x00074f8d75f0927c,0x0000b89236c1ad86}},
    {{0x00017308e1e58e7c,0x000867db13b9dde7,0x000306f021259e44,0x0001a4349c8e56e3,0x0000b578ecfaafa1}, {0x00084505fc0f3955,0x000c9cf62fa54df9,0x00036b0d416db73b,0x0005d79d27a78dac,0x00009d0ac179612c}},
    {{0x0004b0085e82cbc7,0x000abb85d10839db,0x0005f3bffdf52af9,0x00079078e4cbea13,0x00006cbba6b97a8a}, {0x000b82422c5fa00d,0x000a3ab275192d04,0x000e62fb0c96cace,0x00026b9b5e0fdcda,0x000028851c8af90b}},
    {{0x00012449f8c83d3e,0x00021b484ffb3484,0x0002a03c330d56a3,0x000de8f64f1a4e29,0x0000968c4493bb60}, {0x000b81bd33e1a3ce,0x000aa34a593e8cb6,0x0001cdb8a73950dd,0x000c5aca2dd94ae8,0x00002196c60ad005}},
    {{0x0002ecd9e6a86c14,0x0005bf4b4d550dfa,0x000030370fc52488,0x00002d4d8f6fdb09,0x000086c76907c7c6}, {0x00017c32a9829592,0x00024cd68ba39a26,0x0004748f380234c0,0x0006b496816425bd,0x0000b82c805a4841}},
    {{0x0008d667d5dc4d15,0x00099cf2f678940d,0x000694f978881dfb,0x000dbc7192ed98d2,0x0000de896634885e}, {0x0009ddbb3cc587e7,0x000d4b22b2d17299,0x000c81311033e3ff,0x0003b651ec3fe79f,0x0000aae471a0e640}},
    {{0x0004cd3ea6e3d753,0x00060a108f5907d1,0x00041859d6c895b2,0x0006353d871a05a2,0x00000971096c4c9a}, {0x000fa44e4d592627,0x000e35522b5be21a,0x0002456c5b24ea58,0x000fdf656200f0b2,0x000002a5a001b93e}},
    {{0x000a930b41d968d7,0x0005f45cda83c150,0x00048023ce9f4ff1,0x000af875c0255a23,0x0000618af75ec0f1}, {0x0004f16f88f7d864,0x000f11b9e30e6555,0x0008bf8f34a212db,0x000a4894a74095b8,0x0000f73c218673af}},
    {{0x000719474c355ac3,0x0007767feed9b317,0x0001495f898e9455,0x00044f2e1c716c37,0x00008656ae1b3716}, {0x0001a34aa65dcb6a,0x000d0b1c27a68be4,0x000536b1b2ce4de7,0x000a67af11085552,0x00009a395ffaad98}},
    {{0x000d3f4d7c754474,0x000c22c337ab180f,0x00072abe02a8ff15,0x0003fc10970c2e93,0x00003c652e722cfb}, {0x000c02f3684913d4,0x000297055bcefbca,0x00000984f91a0cab,0x0006a13ef0aec851,0x000083ec8cccc61c}},
    {{0x000a2ec8681d7400,0x000eb2e1e27bf54d,0x00021ca664bfbd0b,0x0009eecb3fb586d7,0x0000407b0b572888}, {0x0009fa49e7df0d49,0x000c8db83e5cf139,0x0008d62a8d255ab6,0x00064e972c4b357c,0x0000b7d17a711fc4}},
    {{0x000bb7a820c7747c,0x0008591aae71b534,0x0000ffe0e9e5c12a,0x0006d406fec50176,0x0000f79f9725d57d}, {0x00087fd706dc3021,0x00069d9f06684b74,0x00056d2a20079b4b,0x000da7fcbf83e575,0x0000880dacfe1d20}},
    {{0x00058e9c302ba867,0x00031efb88acbef5,0x000b99aabe4819fa,0x00022ba1871c5dd5,0x00009777c5931fe9}, {0x00099616dc64a369,0x0002003ba21a955b,0x000169185be37b58,0x0004c6afe824b374,0x0000bfc77522de74}},
},
{
/* digit=19 [{1,2,3,..,}]*([2^133]*G)  */
    {{0x000a727255b1faf7,0x000452ecd6f25da6,0x0004ecafd5a5a652,0x000bad00768839c1,0x0000a47db65e8b03}, {0x0008ff333559d9cb,0x000966d9582a7941,0x000861751aab0822,0x00061a8937485277,0x0000e70755598baa}},
    {{0x000d0b3a9d6e707a,0x000deb1e6b972802,0x000a9cdc816ee683,0x000300c2c0420274,0x0000882a6225668e}, {0x0005839e9d3e56bd,0x0003671e54dd8b9a,0x0004f99975d7c4b5,0x0007ae4fc6ef3c37,0x0000fc5b94dbc8c6}},
    {{0x000a6cf4e2db7b3d,0x0005cf35c5c3f019,0x000bdb6f316a364f,0x0006e1221c2e18a4,0x0000dc4b2200d39e}, {0x00078f1c8e821915,0x00009b22f686d8fb,0x000a305a94c1ab12,0x000cd236717c6df2,0x0000b14404a2f1a7}},
    {{0x000bac5f488d5a8b,0x000732f43799d874,0x000877268650340b,0x0003966fe4b48921,0x000034a8a84a9b2d}, {0x0000e4682408320c,0x000cb0f0f018a4e6,0x000fcb65b28d1028,0x000898348a10c5df,0x0000188d1de6f0a9}},
    {{0x000e203166a36c7b,0x000b4b6efd58b491,0x000b8cf6095cca77,0x00087b5779dd6452,0x00003dee080aa1e6}, {0x000516401adcd8a2,0x000c863c78749a85,0x0004b4b58a717ce5,0x000b1c6419ecb4d4,0x00001c953dfc5f7f}},
    {{0x0005a4caf12ba860,0x0000c62e1874ce63,0x000fde52b08d1a6b,0x000a7df06d9f7da7,0x00009e538c0d777f}, {0x000d8554da32762d,0x000fb42b270d4ac9,0x0006c0faa9638fdf,0x000554ad39e13597,0x000052af20a0ab43}},
    {{0x000de3d347ef0da1,0x0000e86b94de0d5d,0x00081ede6978f54a,0x00004b7554d28aca,0x000093f67d8e3d7e}, {0x000d6d4b2accb9b0,0x000eaac44bfff953,0x000334bb519d0743,0x0004597cb4782f84,0x0000e289c03cc10b}},
    {{0x000d7c4e6d753278,0x00056ab83d3f5734,0x0003ee15022d081a,0x000b4954cbe1d2ec,0x0000296520fe0c21}, {0x000b30c9f320aecd,0x00021106ddcb4b09,0x000f1b1848a3530d,0x000247c734a80168,0x0000496e464291ce}},
    {{0x00090a90c5f1581d,0x00021f437e8ccdee,0x00069fdd47f1c872,0x000a9c2e4357299f,0x00002d0483696306}, {0x000b5fd8d746c503,0x000c8bd661cb171d,0x0002cd43b1cc7a71,0x0001118c6769457e,0x0000150b880fe3d7}},
    {{0x0000f541d58b53b7,0x0006631c29ba2789,0x0002be7fa10f036c,0x0004b70db1abcfa3,0x00008eb4ca6712a3}, {0x0007134fe95a5dc8,0x00009bfdd4921a07,0x0004074f4fc33414,0x000344776f51e869,0x000039fcc742b48d}},
    {{0x000b7d00d6409a81,0x000dd67668b16ac9,0x000adde6b0cd175b,0x0003b8db64a49847,0x000077b648118844}, {0x000b3a9b85df3c57,0x0002bc406a3f3c24,0x000c75b3c764621e,0x00010e175b8c2793,0x0000b0bdce77a0e4}},
    {{0x0004813b51c2e64e,0x00005742d51835f0,0x000ecc30fadd8650,0x000bedf50410b627,0x000021e7232979d7}, {0x0005b9c764997bfb,0x000b0468d42cf2f8,0x00060163f7fd4379,0x000bda4d0bb60197,0x0000a925ae795940}},
    {{0x000c27028b18d58d,0x0009810f017ccd8a,0x000df69987d79344,0x000c3b7f59b76dce,0x0000dae304e49afd}, {0x0006d38b645dc0df,0x0006de4e4718ba52,0x000f7e2d51a37fea,0x000a96abfb95fdb4,0x00001485263258e0}},
    {{0x0007d52ce0614c9e,0x0004e699b20813ee,0x0006fd82d87f7d47,0x0004dd26820af588,0x00005ed613674375}, {0x000d90e6407c8b58,0x00045ffbeb5f5d2b,0x000b95218b07597c,0x000bce1f2697c7b4,0x0000512e42cb5fed}},
    {{0x0007ba3ac56e0291,0x00063e80caf76d16,0x000402f16cd63473,0x00035e2bb89abbd8,0x0000bbb3d5dfbc8e}, {0x0009ac52a39e9a6b,0x000961b06920b768,0x0007fad592b5ca40,0x000305260906fb21,0x0000df04971052ab}},
    {{0x0009f76f719e0c19,0x0009462eab4521c4,0x000093d14459bb4f,0x0009e86bfea8af42,0x0000c845c0599acb}, {0x000619f255078fa3,0x00078ac8483e27a2,0x0002f48e15d94779,0x0006657197c26f1c,0x00001b0bbf55242a}},
    {{0x00058c998e87eec5,0x0009d5bf41a5e976,0x00045718c33c7d9d,0x00008841dd908702,0x000048d0cab1bd20}, {0x00064a0500d4afb9,0x000806c82de8d3f0,0x000fd2028c970708,0x0006951017002380,0x00009d99f573ff71}},
    {{0x0005b58a79b2ebda,0x00028acfec229986,0x000fb08398ff8388,0x0006debd733c9ea8,0x0000aafb0b851b1a}, {0x000791b3602750dd,0x000f1eb59cdb2015,0x0005a8c5e25286fd,0x000fcdbccb6aa395,0x0000b0031f1a9f9e}},
    {{0x00036c2ab12c2213,0x00029a74288bef01,0x000813cfd8d67fb8,0x000edc144e8dbaa8,0x00001e994264cc9f}, {0x000d9b6095487f1f,0x000fbce801322d42,0x000d781e3f5b5610,0x000a5f163843cfa3,0x000018ad797760f0}},
    {{0x000104980838bd3e,0x0001d4b775d53e56,0x00032e1224b44db2,0x000b72ba0d374dfa,0x00002d1e993def8e}, {0x0000a19b53d7c05c,0x0001f3fcbd21bd3d,0x00040bbe6188a3aa,0x000cde0596e5ba59,0x00001c6391029e21}},
    {{0x0002b014fcbe1856,0x000b95e13a2b28d5,0x0006d0d4b135f7ef,0x00088914fd801d5a,0x000039be473b9886}, {0x0005da0db71ae0b1,0x00021d1359895df5,0x000fdaa6f9a87424,0x00086a4b6a38e436,0x00004b52ba6a46aa}},
    {{0x00012f2761b2f3c5,0x000c6614fc53bbdb,0x00042cf5cddc872d,0x000f394469eb926a,0x00000be240fe2dd0}, {0x000ba88505bde5bc,0x000093955a18ec7e,0x000d0aa3265bd9f6,0x0008cf2aba473ef4,0x00005612ed21f6df}},
    {{0x000c255f6facee1e,0x00050647746dc2e6,0x0003ba4f655a3120,0x0008bc9b08c0899c,0x0000ebed9359dd89}, {0x000b9c2f4be6d27a,0x0000379fa923f100,0x000ecd610db4fb74,0x000f5c0a7070baae,0x0000e5703880295d}},
    {{0x0002792b86361989,0x000c70e0ea1d1795,0x000cee4b2945e4cc,0x000e49191f5928e0,0x00005a092513973c}, {0x0001517aa0eec014,0x00022752e7d55c3b,0x00099eab1d2d4b0f,0x000a05485931759e,0x0000052fe15cd96c}},
    {{0x00079adbeed33d6a,0x000d9bb0b38172df,0x00014e338c2cf0c2,0x000c9072e49e377e,0x00006fbab6774105}, {0x0005c6b6657d9f8b,0x0007430c8a4f90d4,0x000273d11fc0a286,0x0004aa737c3f3d03,0x000085bc56c4d2aa}},
    {{0x0002379568227447,0x000d5a076a384854,0x000c19f6f86ca3f6,0x0001602451c729ff,0x00008f792dda5ecc}, {0x000f7755d8802213,0x000bd503649e95d2,0x0004c555e4ab7e6c,0x00014024efaf7d22,0x00008f2776245832}},
    {{0x0003c0c7fc837d12,0x0000c7efb2ca73af,0x000f96a119684707,0x00064f56fc1c5a8f,0x0000616d7204226b}, {0x0000d16d3a7388e9,0x00086882de5f323a,0x000e0dd9dbd81663,0x000c0961f0e26e4a,0x000063cf17e2495b}},
    {{0x0008a4eeed230bed,0x0003d0d557870091,0x000ee3dfbcc65b1b,0x000d4ec313899e1b,0x000034cc4615e318}, {0x00033c138a95f8fe,0x000a9bbf13a3a311,0x0008ef1d5a245a64,0x000b9c9d0bbf5c1a,0x0000d9889cd87380}},
    {{0x0006bf10834f02c6,0x0006e01e457cc3a7,0x000006873fbea818,0x00084c35cf9b69b4,0x0000f15793516087}, {0x000fb13cc05f8ada,0x000cdff5bcccc418,0x0007c49b2d54eb80,0x0008d54143bb4a8d,0x0000da62cdad2bc2}},
    {{0x0003138c57e0d795,0x000edaf3c2b5f7c2,0x00093802977df609,0x000f578d94d77af8,0x000044741cd9805e}, {0x000fe570c9322596,0x000592415a9bc8ab,0x0005e9bd3fe94d08,0x000c8e55ad18e986,0x000069c5461d43cd}},
    {{0x000d798d927c8bd1,0x000814dbe62b28e3,0x00071e6bacb5f66e,0x000791daf2930488,0x00002760f363ab82}, {0x000fb66661da3b86,0x000fc1f4f6b755e3,0x0003fd1f289bbecb,0x0009b11762446e5b,0x0000e4bbf14d6d68}},
    {{0x0004365872cbe5af,0x00013550dcea306a,0x000e8ef29eb2b51f,0x0000e37d100ab735,0x00008b0e721f1781}, {0x0003dfa6b34d3b08,0x000b96fbd55f946d,0x0007e3d70db70874,0x000d6f1c8c13ccdd,0x000067a70e52d644}},
    {{0x000ff9a5bce55c35,0x0000f532d926f394,0x0002cb267ae6b423,0x000cfe98bafbbea3,0x0000a47e9ec49a68}, {0x0001fac4aeef377b,0x00065088b8ca39aa,0x000fcb1b33346e68,0x0003f37c4595cf03,0x0000553a9a1f2973}},
    {{0x000db5078afd98f1,0x0009a5b1d544b457,0x0003cc22ac17ad50,0x00013f9c1f670349,0x0000b99d9c60b42d}, {0x00070f5e725ed33e,0x000ff4e76c5e3634,0x0009bb5aa3712ced,0x00077c075d63270e,0x0000feb5464092f1}},
    {{0x000266f5a6fae80b,0x000e77cf1d11cf5c,0x000c25058047f7d4,0x000d72477c80fbc1,0x00002ae841fc8624}, {0x000298af8ec94027,0x000f332b3001e607,0x00057ef418781d9a,0x0006e8f3cd58c10e,0x0000ae32ae0e9391}},
    {{0x000e957ce0b54fb1,0x0006972fc16c8d59,0x0009e1ac6a5ec5c0,0x0003cc0e2a509f44,0x0000ae99269d43b5}, {0x000dcfe7f8edbf2d,0x000c4c38a98ab0de,0x000f2b7fe3eb2afb,0x000251d41c2c671f,0x0000eed98b1d120d}},
    {{0x0007bb64c21224ff,0x000ff9321251834b,0x000b9cc1597d501f,0x000a592604354ccf,0x0000558105b4b952}, {0x000e794b05479262,0x00063092655e2220,0x000e9a375065befc,0x0002a52d2ca9bacf,0x000070e81eda0f95}},
    {{0x000c09aee59dc5b6,0x0006cb27787722db,0x0005983dff716c05,0x000b4410ab2999dc,0x0000ae99f605e39d}, {0x000a294b8a218144,0x000f9bdcdec057d9,0x00013071db4aa486,0x000cb97a73b9e06e,0x0000df58e4a10434}},
    {{0x00068854ccb5cd86,0x00099dfa38302192,0x000c6d69b04ec80a,0x00057f0b4854370f,0x0000695534ea04ee}, {0x000848f83b02064b,0x0002521616e17746,0x00016cdfc7d6dc14,0x000e2fc170a55382,0x0000c5b8c572de15}},
    {{0x00031c02e59f130f,0x00069247772d5603,0x00074879039b6cd8,0x0005614566fae8b3,0x000048c68435d8dc}, {0x000c560826cc061b,0x000ed2785591eb7c,0x000662c22886c967,0x00001f926b7e0d13,0x0000a566862f57c4}},
    {{0x000008cc2d2b80fc,0x000f5cb30fd3cfcf,0x0005075763e6f872,0x000b507b8d542c1a,0x000005ea27771e0b}, {0x000c23881dac761e,0x000cabc5e2d0bbca,0x0002d7913f2786aa,0x000fbe4390fd746f,0x00000c3ae903f765}},
    {{0x000fbd330058a1d6,0x00002ef54fb2b3c9,0x0008118044f97ba9,0x000b32b660df7427,0x0000e5c26ccf676b}, {0x000d3b470f7e68e0,0x000e721fa57e439d,0x0001dcdffd33db06,0x000ac717c7489a8f,0x00007ed817eec38a}},
    {{0x0002b4c45f41a24e,0x00055384c01b0f07,0x00027702295b3c4e,0x00021305b5164d72,0x0000213182bcadfc}, {0x000702c3c59da1dc,0x0000a16ef0a14df7,0x000d1c39e1032dcc,0x000e831d50a0d7c0,0x0000644edd83072a}},
    {{0x000e10ecfc435d32,0x000d54284c66de7f,0x000050600e3840da,0x000645f7f5805c2f,0x0000742262a04570}, {0x000079ecb500097e,0x000b82599044767d,0x00048fcfba3571b0,0x0002688ed95a5d75,0x000064270f1e0c8c}},
    {{0x000a352dc9346c12,0x00023d6f6fd90c8d,0x000b10eb8580e708,0x0001c595b7b0f310,0x00007adb908efd25}, {0x000fbfa7696a0663,0x000ea1f8a2cafde0,0x000feb5f1555b2d3,0x000b2d6e3ef80a48,0x0000afa35e99343f}},
    {{0x00009298d4b6dbfb,0x000061e47941a985,0x0001fd13f88f9bba,0x000f2b1b2d1d0d09,0x0000fb0457f5ddd7}, {0x00012be21119e4a3,0x0008bebb0f558503,0x0002cd850fffa065,0x00088482acdbcb76,0x000045182c46b168}},
    {{0x000a84723ad876d1,0x0000f44279fae932,0x0000d0bc65997267,0x00005d8a11945700,0x0000641726724e50}, {0x000b9a05034241c4,0x0003db865000b9ef,0x0003bf2b3fd17345,0x000b98f1f94024dc,0x000095ee6f7d1d97}},
    {{0x00026356f22e6e7c,0x00024c3361929d42,0x000551b739519480,0x0006ba8fcc02a12b,0x0000c866d3c65741}, {0x00082ef71dd1d595,0x00088888e5b5dac9,0x0002351988936e99,0x000912104b788baa,0x00005b38d17ef74e}},
    {{0x00078e44dd47b196,0x0006e3a7433dd3ac,0x0000e11737fb1f59,0x0000f52fec79569a,0x0000143a6b04cb9e}, {0x0005dfaa4b44dc9f,0x0002f6a3f86504ff,0x000e7730114be502,0x0005c09e9f83c1f6,0x0000a40c0dddb1a6}},
    {{0x000ad7a5d9a7c749,0x000bd0b3e979591a,0x000b18984b0c8837,0x000c930f85a5824b,0x0000523198d420b4}, {0x0008c2966f8c5ecd,0x000c7529d2eed63b,0x0007a1cec89e0293,0x000ce2ee43e4b31b,0x00002b2eb6888152}},
    {{0x0004dd204d849aaa,0x000d7aac3dc6fc74,0x0005bdf821345352,0x000d21fafcb0f7ae,0x0000c9bb14c6adc8}, {0x0007dbb7c46a380c,0x0002f91f52fe0303,0x000095c182afa9ec,0x00053300cfb28879,0x0000759b435956ca}},
    {{0x000ec5f3969f68e0,0x000700e5f0e3ef78,0x000faae20f28d8af,0x0009c666fe212050,0x000038ae7b9b88f0}, {0x000157ba6e527edb,0x0008a283e2353b72,0x00056665a3b00c20,0x000fb0165eb77eee,0x00007f6601175858}},
    {{0x0001cfbcf87353f5,0x0001b45b7fba97e9,0x000c88529186f293,0x00017cb9b7e1b550,0x00008d032cbbc13e}, {0x0008803b380a2bc6,0x000ce0e1eebebc7f,0x0000b3070c817171,0x000219f2106f56d1,0x000043c2b31388af}},
    {{0x000e260a60f350a6,0x0006b02cac1de1ec,0x00028ab680baa38e,0x00084fa849c9cc42,0x00001ef5b54b9710}, {0x000d93de4657ad0f,0x0005315d84295f24,0x000d5350e7f70518,0x000b1b81c02b900a,0x000086bacb6bfb11}},
    {{0x000b24f6599254b3,0x0002db150c28450e,0x0002523f2e8c805a,0x00016e26bd712d3a,0x0000cb4ef15dd141}, {0x000099a2e6f10b03,0x00002209f4af5024,0x0009230a1a79e9f8,0x00021b395212446f,0x0000a9513044d617}},
    {{0x000a8350780042bb,0x000fb7e23271391c,0x000a21d82290ac12,0x000018afb2dc3763,0x0000debc97de697c}, {0x0004834481d067c4,0x000bdc1916ceca62,0x00074c52ab470d9c,0x00057cbf28f87f59,0x0000397d4d3c4093}},
    {{0x000666ce7e64dcc5,0x000bfd2765fa9474,0x0009f08475f3c2aa,0x0004f9d5e1f47951,0x0000ac986961d2f1}, {0x000df6492b43447a,0x0007e6aa220eae5f,0x000687d74899951c,0x000190b730db55ed,0x0000fbcbbde88500}},
    {{0x000a91cf73f6d56d,0x000dd4ac318013b0,0x0002e920d4b81d0e,0x000af89bc5c79628,0x000009d7f0a3bdb6}, {0x000654d7b2096ba9,0x0001bac0128551c6,0x00000c2c28355efe,0x000725460cf1f377,0x000031708465e5f7}},
    {{0x0004c76c4fe9380a,0x000c3951a5ba03ba,0x0009390e3a0d1f19,0x000afc40881217e1,0x00004df0a88e83a7}, {0x000384ea5baa9628,0x000bb158f86192b3,0x0008e81ff877e966,0x000d6c002eb4c264,0x00006978687377e4}},
    {{0x0001f239971de4e9,0x00066b14c2bc0eae,0x000eec2d481fcc62,0x000e4ad4346cda42,0x0000812e9df26d7a}, {0x0005f2aa6c2765b2,0x000c0d4e6727b197,0x000cf9203e0c7cc3,0x0006a71e0008e593,0x0000cc328562e6d8}},
    {{0x00041b3f24c2e3f2,0x0000057bc18560ae,0x000dab87a402cc26,0x0004fc026500b9d8,0x000039eb743203ec}, {0x000cad3bc772a9a3,0x0003237fe16c560b,0x0001e4e176f45fb2,0x00086a0c35cb9a4d,0x0000b15ebf1dbd99}},
    {{0x00084d9c6bca11af,0x000efba4998ed17e,0x00030f688bbf5028,0x0003d90bfa347c4a,0x00003511c41bb988}, {0x000e04455e4a4408,0x0008eb1d2233b9f9,0x0004641f70bb7f2a,0x000bdb4bed7797bb,0x0000525831ae528e}},
    {{0x000feb573b5f15b2,0x000c92dc8b2b488e,0x0008915cb16e2b26,0x000bc6409f7cf294,0x0000643f5d55e347}, {0x0009c716263c840c,0x00099899481ae3bc,0x00030c337aa831fb,0x0008390b15f01b4c,0x0000ccb40e5e4096}},
    {{0x00034dc70a22059a,0x00095bf4dd319094,0x000ae3a347a94846,0x00022943c512ea17,0x0000f04ad0dee788}, {0x00057b3916c3e773,0x0005eba57fff134d,0x00040dab29c7a71f,0x00005e7267cf24ed,0x0000d39e69d8fe29}},
},
{
/* digit=20 [{1,2,3,..,}]*([2^140]*G)  */
    {{0x0008a58ed016cd2c,0x0009dc5bbdaedb58,0x0009d19885238728,0x000afe3665291aaf,0x0000f811206507f0}, {0x000a1acb3e875c10,0x000b5e9738520bc9,0x000b92c017b2fc48,0x000d82b6aee9ccf1,0x000062c002883ebe}},
    {{0x0000bfc1cb150958,0x000d323c4b7d62aa,0x00022080f25a592e,0x0002c2d0f11983fc,0x0000ee53be304d89}, {0x00037069d21f2963,0x0003e06e21bb46bf,0x00016283512c9c3c,0x000a67545bb2988e,0x00005bfe9d31adad}},
    {{0x000ffe7d4dc02b42,0x000fa98dc963d65b,0x000b49d8292da276,0x000c09ae3c49b3e9,0x0000d5431f45032f}, {0x0000664a7193cbb1,0x0005b74ae8346136,0x000506bf40d18877,0x0008baea2b86bf65,0x0000caf5ff39d91c}},
    {{0x000a3c28239094f1,0x0002a7547af8d168,0x0006f05d9a001ef2,0x00048b8e617195d7,0x000046b964d7a1f4}, {0x00087515a695697f,0x000f6e306cc6952f,0x000023ac96fca948,0x0000113b6adf1cd3,0x0000162f07c0aff3}},
    {{0x00048e3747fee076,0x0006b0d9898348ee,0x000bb6470ff98685,0x000533883290ae3e,0x00002a3d0c700bbf}, {0x0000cabf7bd10d8a,0x000bc597ff059eda,0x000be93bc3ae7d83,0x000241f3fb57e695,0x000038751d9c581b}},
    {{0x0009f4d266fe37d0,0x0001760efc6d5220,0x0008adf5ade25d2e,0x000f03a0868e028b,0x00009d6b114bf7a8}, {0x000ea7aedf8eb0cf,0x0009fb1cec06b1ff,0x00062e007b93aad0,0x000ddc47d356e3a3,0x0000f4c08726f1f8}},
    {{0x0002fe66ccc2faa5,0x000e00587d9fa66a,0x000e403eece74ae7,0x000a225f516ff2ba,0x0000d7e840f4377d}, {0x000c2e2512283ec5,0x000ed6d8436ba415,0x0002293851324017,0x00074b2665c85d3d,0x000061f518ef05c9}},
    {{0x0001472c11f2e3f8,0x000f1235e29595f7,0x000cb9e5a4678386,0x0000d17bcc861c54,0x0000988eac405b68}, {0x00035f6f32a0837b,0x000a0526e17e28b0,0x0008d388e1404513,0x000f50161698c9fe,0x0000290d6d02d161}},
    {{0x000e406349253af7,0x000d0541fb134eda,0x0003250ff90e5eba,0x000f014ee0bc4f4a,0x0000642c5dcc7c88}, {0x00087e04f81b7760,0x0007fe70876a68d8,0x0001713f35bc975d,0x0004f149dd30b653,0x000069332df09855}},
    {{0x000ae7c2d9437a12,0x000c29850a20044f,0x00048fd99d2889e0,0x00019802a1d48fe5,0x0000f30505df8965}, {0x00029dc332e26e50,0x000aaad107e92aff,0x0008fd1562aaff01,0x0002079447e8e0e0,0x0000a12a48f5f9b6}},
    {{0x000d35f7339a4cc6,0x0003ce58997c960a,0x00043b09663f8920,0x00086a9cabcc6fe5,0x000039df7b26f9bb}, {0x00004ebedc941e64,0x000a6c597d5e1f73,0x0005265ba7702fac,0x00039a977b7848e9,0x0000c0f2844cca29}},
    {{0x000dbd0c20287ea4,0x0007f00fcae2255a,0x0006723143b1f47c,0x000fdba1ca3b9a4e,0x0000a61bac73eb36}, {0x000d0243021dac3d,0x000f566be9665cd8,0x0007af8bea21805e,0x000fc6df478b1ca3,0x0000ee9bcbadfe87}},
    {{0x00079ee748becd5c,0x000fb2987ffe5418,0x0007a1ffc02d6eee,0x00056fea13c0fed1,0x0000c469e61b060f}, {0x000a5fdafddb3776,0x000368241f08c069,0x000473ca9d3dc589,0x000a42ebca40d7ce,0x0000bb3880b5b1fe}},
    {{0x0003d7e9a039d299,0x000ba8ffe689e1ce,0x000a4b476b07cf06,0x0005849486dae5df,0x00008b49ee4dfe4c}, {0x00043c12bbee57f5,0x000913e24f4393b8,0x000ffe1e8a443ce5,0x000d0a6060aa2a71,0x0000c42edaeca67e}},
    {{0x0009179cd2d899c7,0x00018a17e501d737,0x0001ed55b3c10df5,0x00048ca04cecde6c,0x00000472a0b8057c}, {0x000052a555cd31c5,0x0005e9616214105a,0x0003eccda90583ec,0x000ea0cb4bacb30c,0x00008fd7c1a7540e}},
    {{0x000f42db00490cd2,0x0000c875327c51bf,0x0008e6a820cf37cd,0x000a81bb95829eb0,0x00001100b078ae33}, {0x00022e00511257b1,0x0005f34ada3e41b7,0x0003409ef3752978,0x0008b1f12815fe3e,0x00000e75bd15cb42}},
    {{0x0006d6b5522c8d1e,0x00020c4a6e6885b0,0x0000674f8eb11a13,0x000d2924af2210e0,0x0000da23f4f5a620}, {0x000ca47360f31777,0x0003d3885edeca1f,0x00023929c46c52bd,0x000db6297cea00a9,0x000049714f519cd2}},
    {{0x00015a866630391b,0x00035087f3dd975b,0x000f2793a140b12b,0x0006fe1693367845,0x00002d5263bccea2}, {0x0006ef773fa9b4cd,0x000b902c1b552332,0x0001ac526ad1de38,0x00006620625db61e,0x000003a7023f0df2}},
    {{0x000651d3e64ea2e3,0x0006a54af43e7a32,0x0003ae4c9330df34,0x000236a6234eb5e1,0x0000759979693586}, {0x0008b45a9d54dd05,0x000e8978baa36a6c,0x0000ebaa91e3142f,0x00008dac63becce7,0x000003546ca0617c}},
    {{0x00094d5565a427ca,0x0007ad634538fdc5,0x0000250b2a522b76,0x00055a43ef3e4b9f,0x000011bf92e19348}, {0x00072023ecc683ce,0x000ea22ed8cf7efc,0x0003fc8983d51051,0x00075d723fc11811,0x0000633cf0cc488f}},
    {{0x000ba977892ce284,0x000b4cf71171d65a,0x000030c443d4463c,0x000202ca09b1099f,0x000056bf294a1a66}, {0x000a54aeda67248d,0x000d88b53799a85a,0x000ecc75a25eefd9,0x000ddc8babc0388b,0x0000a2fbe4a79e00}},
    {{0x00095a2a1a8636b1,0x000233d7f690fd6d,0x0009ce730bdac772,0x0003be8fed0f34c3,0x000049bee0dc1db5}, {0x00000cdcd095ded2,0x000d8b21e3539d6f,0x000e3d0a33e83d8f,0x00022450c4084ba9,0x00008d82e03dfafd}},
    {{0x00051869548ddcc5,0x00070778339d1ea2,0x00035f5f50d6f915,0x000e57fa01f58a4d,0x0000841779dd56a5}, {0x000f9ee31d9a47c9,0x000d12d602675ece,0x0009553f46c32b16,0x000eacdcd3c358d4,0x00001f6870b61f3f}},
    {{0x000628f163be6450,0x0005cd9c95d766bb,0x000f6a04ec28e610,0x000c81dc5fc2b063,0x0000b71137ccd020}, {0x00075183bdc05d4a,0x00016d6bde53c0ba,0x0004d7c49a68f235,0x0008d99b6b877a74,0x0000336e49572d6b}},
    {{0x0007024b4657059e,0x00054cef3d11f446,0x0003050457ac1b21,0x0002913d9da01ad5,0x0000b9bcb5753d0c}, {0x0007f76845c2dce5,0x00038068a539d060,0x00087fda517cafe7,0x0006476a3fa020c8,0x00005d290857bd93}},
    {{0x000092acd18e938c,0x0000f8464b918049,0x0004df7e752475a5,0x0002fde898e40329,0x0000287032729a40}, {0x000569905ec6b4ba,0x0002cfe346da592c,0x0007a24d3ae26557,0x0001e988692d9424,0x0000d3469d8df997}},
    {{0x000c0c46de1a94d9,0x0001e6f60e7509ba,0x0001814113ff2984,0x00011dee43d289c6,0x000082b07bdc2bd3}, {0x000f143c2c8cc0b0,0x00062d458fcb4868,0x000b290b3fd69d9a,0x000c0ecd23f4d8da,0x00000b05a52925f0}},
    {{0x000d9a283c536a93,0x000606d6de13d945,0x0003f7737b671559,0x0009ba66c6cc19e4,0x00003fc1b1d79963}, {0x000562a67776f95b,0x000cad8332c80b59,0x000985a2553fa97e,0x0007a0d727ab42a4,0x0000e8b82ed15b64}},
    {{0x00038e15452a1658,0x0008ec07d0a74207,0x0007878830171954,0x00059bac99ed3f63,0x00009f0f97c7517f}, {0x0001965ce020f57a,0x000438613db8102d,0x000c51ab225ad31a,0x0005e2bff0e582c6,0x00005ddc35e3ae14}},
    {{0x000fd23340796b5e,0x000244ac37f7a6da,0x000dbe23ff187911,0x0002ebb7c0ba278b,0x0000966a8a7ef6ac}, {0x0000656ed69c1c7b,0x000dd0d9607f7b6d,0x000ad9bd90340e14,0x000f7e0e40027a74,0x00000579cf7ce74c}},
    {{0x000a4a6a443029db,0x000d35ade4c87e84,0x00062de4100e89ee,0x00097010cdaa8575,0x0000847c3b75ba72}, {0x0001ce999ab945cf,0x00008688e09a9735,0x000d23c79201d508,0x0006dc217c5b0e19,0x000019d1d199e64f}},
    {{0x0002e32a7846845b,0x0008812fb2a589f1,0x000e90b88698136a,0x000814075eeda86f,0x0000f51b3d5754fb}, {0x00051260155595b0,0x0001d15da3c67d16,0x000140e2d64ddbfd,0x000dc7d8b5f5f20c,0x0000f851ed143a53}},
    {{0x000a956daaf5fc5b,0x000e309911eb23d1,0x000ec8c6b1504ee5,0x000ae12b96b7e04c,0x0000b90457102eb7}, {0x000f92df9e505e56,0x000f4a99a48ae2ee,0x0009af17826cba30,0x000679b8bbbc3531,0x0000173fb3989c78}},
    {{0x0008c28d0d5a2453,0x0001b72c3ae14d66,0x000253ce4f0708c7,0x00051484000a3ec7,0x00009309c4f55650}, {0x0002432cca3eca7f,0x000ca9872fce7dcd,0x0004a7f072317326,0x000e46d7d6868a46,0x00002b388e557070}},
    {{0x0000a1cb9e317b0e,0x0007686d711ded9e,0x000795851809a425,0x0008f153b3f1818e,0x0000d86c68fea802}, {0x0006abf4b7386739,0x00066a8acbc7e643,0x000a1ca448e39d09,0x000f6b81ecba6cba,0x0000b3922a40e4a8}},
    {{0x0002eda200d56537,0x000c11407fd1b8c8,0x00026245193f49e0,0x000b4f9680d4a834,0x000087c24bcc7dc9}, {0x0007394081d392c6,0x0004a065b74266bd,0x000b68e1b771b55c,0x000ad0c13127dd7b,0x00004fda7e5cd833}},
    {{0x0001b8779c1d0b47,0x0005ec5490f634d9,0x0001f8d01b7ced9f,0x000168ad06fe10a1,0x0000d38933d35353}, {0x00083efd496b859f,0x000068aafd56bb9b,0x0000ab4c451c3d2d,0x0001760199f69b45,0x00004f69ed69d503}},
    {{0x000d12f2dc71d6ed,0x00042873d131f911,0x0002f868f327b8c0,0x000917defbabf904,0x0000be4cf0dfeea9}, {0x0003a085c409e88a,0x0009aeb4bfae3400,0x00086f86c0eb81fc,0x000f9a5b91f6c11f,0x0000e0a0c02204ca}},
    {{0x0002d3ae9ccb3990,0x000a386ea321f4cd,0x000d286fce5d33ba,0x000d3cebb04af8c4,0x0000fed10ee266ab}, {0x000e7bc2e8e31050,0x00057520aee8c544,0x000ce0a339acd068,0x00016a6f230a6ff1,0x000075e1ddd84516}},
    {{0x000487cfa067d791,0x000998485f2e74ba,0x00090c71ee89da30,0x00025626b84584f9,0x00009454c2a51886}, {0x0004c5dd0d1b619d,0x000adc58a1b4f365,0x0006270fe416156b,0x00048f3ee0862486,0x00004e631cb6096a}},
    {{0x000d441dc42369c4,0x000382251bd526ee,0x000e37dea0d84bc8,0x000584bd68a92370,0x00002e0d68345dda}, {0x0007c227fd8dee47,0x00048d0a275abded,0x000c3b0af42e5ba5,0x000cc19c02809fe4,0x0000921ff2645404}},
    {{0x000de9f9684495a6,0x0009aeb8877a37c7,0x000d90721210b3aa,0x000e4725d8d1ea9f,0x0000a2fa64d2282a}, {0x000cf23abf5b2492,0x000693d5625863c4,0x000f2269b836d47c,0x0009574447f14d0f,0x00008a199e166c12}},
    {{0x000f1b41c43f8b0a,0x000c5c92e76aa8ef,0x00075e03be67ce10,0x000c96b9463a7ff1,0x0000c9d06afed35c}, {0x000b46fd3cde2980,0x000abe85c9d9c413,0x00090aace2da8075,0x000e0512bec57f1b,0x000053813aed6f3c}},
    {{0x0002d5a447d4f496,0x000f4cc8b20d45ec,0x000418aa14176c8a,0x00046f0dbfab3afe,0x00007f1b0c286c98}, {0x000399890aae6ec0,0x000cfc7435ee3b17,0x0004406fd3b6b369,0x00040be2ba195cf0,0x0000499740616294}},
    {{0x0000732badc26dd7,0x00095818d5141997,0x000bb5614607b7d7,0x0006880fb44d9c8a,0x00002af102cfc840}, {0x000ac0001b8ab28c,0x00095c267369f525,0x0005973685ec0685,0x000bfbaa025f9a67,0x00003dc0b77f0b1d}},
    {{0x000e6447298e5722,0x0009fd0c41f0b8d2,0x00063b53dd21c481,0x000fbb57d4fc248c,0x00007b8a669230e5}, {0x000412928c65556d,0x000525fd21fda1cb,0x0009148934fd899b,0x000cb3873e258005,0x000018bdfa0f4f09}},
    {{0x000257a9696db0da,0x000c6e1ebe6be7ab,0x0000ca7d82e3d900,0x00097095c69765ff,0x0000d64c3bbe074c}, {0x0004df32910ad555,0x000467cc458a6d2a,0x0000c4ac0377e6db,0x000f1093e2b3b04b,0x0000049f7467348f}},
    {{0x000169e23b854731,0x000c33e4abe5efac,0x000fd974f020f438,0x000a0585fe459ecf,0x0000dc81273d088c}, {0x0008b457450c4b5f,0x000085537b7106ee,0x0004064b559c8970,0x0008ed1e0bbc258c,0x0000c9e438969c32}},
    {{0x00002b120b62bc55,0x0000bc38a5440b51,0x000dd5bf16b581d6,0x00073e09f25725b0,0x0000e14d4eb778a2}, {0x00040298b8f7908c,0x000f4748986c1100,0x00095285cc66b0b9,0x000f606450bf5cf8,0x00008763246fb0b2}},
    {{0x000225d3ce00fd73,0x000562eb7a0a5fde,0x000b4dfc8355830b,0x0001747a548d6584,0x00007847c613610e}, {0x0003b60593ab7bd1,0x0006627b0acd38b0,0x000dddee8f6a141d,0x0008febdfc7a5ff4,0x00005caefa8d4b00}},
    {{0x00062bce0697db84,0x000364744ceaf19b,0x00056d73ed4ae9f0,0x0002e794e38b0f08,0x00001b958bddc911}, {0x000e012417427134,0x000459f114d48028,0x0006a3400cfc75c0,0x00058727f66fc710,0x0000756a6e62a482}},
    {{0x000219fe0b28a503,0x0006d50aecc17ee2,0x000b2435a97443af,0x00001d69d66a83c3,0x00000f96b615a755}, {0x00081a62fb7e0fb7,0x000a7c62b16f41b8,0x0005def12d53a09a,0x0001ef4471c81af9,0x00008288a92a8022}},
    {{0x000c8e03ffcc6378,0x00014bd82b7e98ab,0x000d883a9ce80865,0x000c6a7adb20e161,0x00008a1096cab53b}, {0x000e056288dce6c5,0x000cd762fbd62fcf,0x00047ac13d2142e1,0x000347c471a47759,0x00003efed5dffd1a}},
    {{0x00071f160d9b4fc7,0x00068ccde2a4414d,0x00076c3b61dd617f,0x000e354a6e4e01a4,0x0000394adf687f7f}, {0x000ace232376e7ce,0x0002f140cec9de0d,0x00033c69dda8f7d0,0x00032704299d10d8,0x00007b0ca9ef9df4}},
    {{0x0006175bbdd36444,0x000a4a9f510cbe77,0x000b49c3438fe5f8,0x000aa894881ab300,0x000081360b1cd545}, {0x0007e5993bcd0e48,0x0006045c198c176b,0x000dafcbc3541e85,0x00011a7fe785de3f,0x00001e918704e8ed}},
    {{0x0001b16510a4e3db,0x000cec6d1df534ba,0x0003cf6dff71bd1e,0x00007410def81561,0x0000e0dc1013565e}, {0x000f21a48f9585d6,0x000c6f1ecde37262,0x0000bf75a4803ebc,0x000ff11f11cb9818,0x000073d6d772e7c1}},
    {{0x00059115abc00ba2,0x000cb26283346405,0x0008740e0a87969c,0x000d13385833ae70,0x00005dac93f5d8ac}, {0x000474e1140c01a2,0x0006c16df16ac717,0x000f357675f37a81,0x000ca0828679abbc,0x0000ea1c1b3e843a}},
    {{0x000e6660da9a2e5c,0x0000a16aaba8f9a2,0x0000b0f1059a100e,0x0009bff504cde526,0x0000976e00939024}, {0x00047a5c49758124,0x00088fcebc829f02,0x0001304805038f43,0x0006e00b76e9a157,0x0000a4de4f473e09}},
    {{0x00004366e61d6724,0x0008876389533579,0x000a479bbe7f7414,0x0009e747e452682b,0x0000eaa1b7c1fe86}, {0x000039271078dc74,0x000ee3d381ab86d8,0x0006994cd10f6bc7,0x0008a6b5d9fbe311,0x0000aea87c1a2a42}},
    {{0x000ab7ba68c31022,0x0004f457d6aca783,0x000dbd1c13359695,0x0006f46d44d935d3,0x0000ddba6dd9dbfc}, {0x0009cd2d080265cd,0x000149797b3be503,0x0002299249e3b52b,0x0007bc0e30ffc768,0x0000209779d3d5e1}},
    {{0x000f9ce2a49386cb,0x00068985f70cff66,0x000479f3b00cc1ad,0x000fbdbdf292f316,0x0000fe7032ecf9f6}, {0x00019d7e849d0bd1,0x000249cfa039b34e,0x00027fcb6b7edb80,0x0008ff327d2e6371,0x0000d2b6d3758911}},
    {{0x000242405e3c60ec,0x000e43c80b9566b8,0x00010ea9d9b080a3,0x000e2687f432ff7b,0x0000ed8dcda9fac5}, {0x0009b28d87f8b2a0,0x00043ca1256e54e6,0x000a8cd15700f2af,0x00073f0b2cecd0fa,0x0000ed3ff9133f72}},
    {{0x0004550dc5a3b02e,0x000f5412342343c5,0x0006db191c975ce2,0x000a20f3bd209a9c,0x0000ef49682be20f}, {0x0006351ac6c47b86,0x000ab813a62241b8,0x00015ecebd6574ce,0x000f1186751398fa,0x000028d91f9cbecd}},
    {{0x000f6978b74df5f8,0x0001129ebc5501ab,0x000b5901ba0c64cb,0x000d8e622dcdc072,0x0000ebedc46638d2}, {0x000a78bab0638bbc,0x000e9c428abdd0a9,0x0008a8ed5636732d,0x000dc7c12d1f0e06,0x0000c1be2ebfb1cb}},
},
{
/* digit=21 [{1,2,3,..,}]*([2^147]*G)  */
    {{0x00041c6aa03286f9,0x0003770815b0f7b0,0x000348c284d38d56,0x000cd5c0fbd016dd,0x0000353258e98148}, {0x0002a661efd9b9ba,0x0008dd5eaf283913,0x000595edc99487af,0x00040c2b55829810,0x00008f3adaa1cb10}},
    {{0x000dd15cc4abcc6d,0x0007acc11a85a0ea,0x000e38c7cfb75800,0x0004e9a4844f7d00,0x00002e87f21868ef}, {0x0006dbfdafb2737d,0x0007c78ecbcb6bf4,0x000c3294b6571d8c,0x000d2861c088a49b,0x0000659cbbd569a8}},
    {{0x0009b01652619368,0x00097cc76f780883,0x000ad592edff2cc9,0x000558427112d204,0x000052f6c13013db}, {0x000b41e1bc721e44,0x00022128ce489bbe,0x000c29c730081266,0x0009efd2b1381a99,0x00009dda36961899}},
    {{0x000a8efe8dfc0aac,0x0009cb206c5feff9,0x000e08f69e7003e0,0x00088bdcea678c07,0x000046cbfbe7e7fd}, {0x00081f0181edacd6,0x0007c93bfad4cf46,0x000166e29a349916,0x0004fc2da8f82140,0x00007573537b65ff}},
    {{0x000bebd8693c0ce2,0x00010dc55e193bc7,0x0000e0dde6b99ca8,0x000d3d417badbf94,0x00003a2ff7257f49}, {0x00060a0c7bbfddb5,0x00081c1118dfd409,0x000b93b5a839109c,0x000a3b4702087141,0x0000534d9835ff20}},
    {{0x0004d062b05c59a2,0x000f5879c926f51c,0x000c6face7f545ea,0x000d0985a415dd36,0x000001497b737669}, {0x0007660300e35aab,0x00062195020d6f9d,0x000f8f2766a25988,0x00016e4edb995fe9,0x0000e827d9aa3b54}},
    {{0x000d3fcce93a152b,0x00024b91cc4b50f5,0x000d575f2dc97aea,0x00082a9bea228491,0x00000b0f559c3e87}, {0x00059372ba709ae1,0x0003193c52d9a904,0x00023ee401efcc7e,0x000302d47c1d80aa,0x00002c8592c8fc92}},
    {{0x0009708665ae5753,0x0005c56a03be8192,0x000d0ebf2fcec8fd,0x000acbb56af2db74,0x000082e5523113ae}, {0x0003f42e6dc35a1d,0x000e073f338c297b,0x00031eda91747ee5,0x000685f205a68c1a,0x00005a4916714ce7}},
    {{0x0008f1dbcd1c229e,0x00061773f6f1844d,0x000b29bcde833251,0x0009f684f808b930,0x0000a5e1fcfc8609}, {0x0009762c3a5334b6,0x000547b852bd1766,0x0001805b9b973ca7,0x00035282b13c8977,0x00005ad0b2362ab1}},
    {{0x0005af1b45cdc26c,0x0000c675c4635dcc,0x000b44dcd5bf1c0a,0x00064f5a3a7131e4,0x00004f42e03a4878}, {0x0009d8e6279a73f4,0x00083cfb4946f6e0,0x000537fe046fcce8,0x000d988539949b2f,0x0000ac6abd6d779b}},
    {{0x0005d5a30f177232,0x000e2df357dbfc95,0x00019bdcb3d911f3,0x00080abc003ca457,0x00000224695fee54}, {0x00070ac4186c55f7,0x000970319fe286f7,0x000f87d49b139392,0x00060915c89b2e48,0x000098096c2f2b08}},
    {{0x0006538c7cd583fa,0x0007504a26b85672,0x000751b6cd45e59d,0x0007acf63fefec94,0x00006952679a5609}, {0x0005299959d65ea3,0x000bf04521f25d19,0x000bd9b1bd07cbc0,0x00070fc519431095,0x00000659b6ab7a79}},
    {{0x0007da91e66c9574,0x000db441e739dd4f,0x000fb78e063f2620,0x0009ce36edde855e,0x000048530862d43d}, {0x000d326b7f93428b,0x00051bd23ff3de67,0x0002465efd4d3577,0x000e73c428efd466,0x000015e8b1961a78}},
    {{0x0002b67847e6ed6e,0x000e4c4145b4f3a8,0x000f47bea8e5ec4b,0x000709c101bbbe13,0x00009d64c85e6167}, {0x000258b265c6bb03,0x00052603cb62b641,0x000250984d93deb8,0x000184b5dac1f036,0x0000af93396d0909}},
    {{0x000454335c724255,0x0003604c60816548,0x0001f152c66dc7e0,0x0009f43ccde48316,0x000077cb80034588}, {0x0001b1a2abd9c810,0x00068976064aced9,0x00035e3f6e20d90a,0x000233aa7895ed69,0x00000b721fe71914}},
    {{0x000d5d2047e6bce3,0x000c5f2809e64a06,0x0004d29f57d77556,0x0005ec248cb3669c,0x00008e7d6893f712}, {0x000931b877a115c3,0x000d470ee473cb67,0x000837d7a680ceaa,0x0004ffd6fb968f2c,0x00003fd042aa3584}},
    {{0x00064b623466f8c0,0x0008b9ac46b1538c,0x000eba98de2d82a3,0x000aec359395681d,0x0000ec5727adf754}, {0x0001f29793223a53,0x0004f341230b56ae,0x000acb4a49d60698,0x000a48020fcf8ecc,0x00007f03e722fa1c}},
    {{0x000ffae3070a4cd2,0x0006c399579ec252,0x0009c2399abb8b5b,0x00058f54502d33d1,0x0000d2a871f20c1f}, {0x0005a7fcf9b1e2ad,0x00026c80ecd64f25,0x00094c286464daa8,0x0007fc8c2edbd839,0x000055ea342cc28d}},
    {{0x000e3f38fa4d2ebb,0x000a628413f152d1,0x00063d684664336d,0x00099a6d07b3bf0e,0x00002d0a21e1fc6a}, {0x000404c2235d7455,0x0000aeab84670292,0x000ec318fdc3d200,0x0005e4ed594202e0,0x0000b11acb9c1288}},
    {{0x00046804810695a3,0x000de9ba648df863,0x00051c17067ea77a,0x00015a8eb8039779,0x0000789adb2007f6}, {0x00094251845852f8,0x000597dd3f5a4cf4,0x000e0ca98f3213e5,0x000cdfe4111dea4b,0x000092e80e45f558}},
    {{0x000a77ccd1cefee3,0x000ada8387b76cec,0x000d53bdf4c487a2,0x0008553f0ee08fb0,0x0000ecf034e8072f}, {0x000d2cf4f5b884c3,0x000eecc4f5c4d598,0x000c4b8e274becd4,0x000fe18c1cf74be6,0x000033bf7648e6a5}},
    {{0x0003309c7f4956c1,0x0004bbd8072c2e72,0x0007386ff557979f,0x000400bd4c7d2735,0x0000d3097df1694f}, {0x0005419b24eddf2b,0x000fdec834dd8149,0x00008eb07ebf4b08,0x000944251b925cec,0x0000cf5bd49c0873}},
    {{0x000cc2b7fb7521cb,0x000cfca0448c3e29,0x0000c79198983000,0x000fa291122a2253,0x0000d819e4970366}, {0x000f14ca4bc473dc,0x0009d3f09a14b90a,0x0007cbc4041d07a8,0x000c0822fd840600,0x0000cc4468dc6484}},
    {{0x0008e2d3ac836bc5,0x000fa9f064bbcc21,0x00031a1b07517bc7,0x000b9cf6d996bf89,0x00007baa282710c0}, {0x00003689803b8618,0x000b9bc669415358,0x000927d51b0e7c4e,0x000917e22409c259,0x0000bd3b557da0b6}},
    {{0x000c21b01b14908b,0x000de4a8a31f4d7d,0x0009e8787bcbe4d4,0x0009e9ec73c5ca1a,0x000065165667e1be}, {0x0005566f103c7aad,0x00068820ea33101b,0x000afa05ad1acf04,0x000445b6f0613b7c,0x00003aa0c574081c}},
    {{0x00087a329c8ed384,0x00092d62bcbb14af,0x0004e3df6cf9f17d,0x0004809f2aca4e9d,0x0000ccfeca144a51}, {0x00041c1043c54414,0x000eaa7c807bc51f,0x000cfbed8d9c0b13,0x000f8173166f05f5,0x0000edbf62fa73e0}},
    {{0x000fa8831a8af89d,0x0007f4021d8aff5c,0x000dbeefd7a8d79a,0x0003ee6c7dc72f5b,0x00004336006bff0b}, {0x000e58807631b0f9,0x0003b6ca73f467c0,0x0002ef220dd8f222,0x0008681b33098d75,0x0000a8d5cb00940a}},
    {{0x0003a4465384338c,0x0002212dac4e37c8,0x0001527f99ca46a7,0x0007381b651de843,0x0000c4920dfc4a73}, {0x000defe279009365,0x00039c537acb711e,0x000d3684b5f0845f,0x000b186a2879fe49,0x000022890953f9ea}},
    {{0x0001888a21d8062f,0x000e6963bb268fdc,0x000fec2167faac6c,0x0000b12e8fefd495,0x0000fde1d1fbfc68}, {0x0008c3a8ac6e9251,0x000f165cd203fb4c,0x000da224da3bcfee,0x0009c76f7dcac95f,0x0000d2bc8ba06270}},
    {{0x00089f169709f64c,0x000ac1b2dac6c136,0x000f04db98b2b71f,0x0003d6ff19b52803,0x0000984ae8728ccb}, {0x000b07419ce76448,0x0006d40a72dd7560,0x000ce49974f769d2,0x000dc4f4b5d8a990,0x0000484a9d5d3a20}},
    {{0x000d0288e3a46587,0x000ff69f35c7af94,0x000ef3387d56412e,0x00038a84fec04a52,0x0000600f11d74aa5}, {0x000b58c2b1ee7fb6,0x0002d3e464c1a9a6,0x000491727fa92dac,0x000d338d06f7e0e9,0x0000c00602b9dd0d}},
    {{0x00025ec2a0a97736,0x000894c54fcb0993,0x000c79b1272a0fd3,0x0001dcc6d7533abd,0x000003f49dcc0749}, {0x0002691f11601ac4,0x0004f081e7ff4653,0x000af4c3b359a421,0x00031b5ba1c105b4,0x00008a6b864d6305}},
    {{0x000fd57dfc2a81d6,0x000625b39bc719c1,0x000bd95af6db2f85,0x0003bed53048b27c,0x00005b3082cf3fe5}, {0x00075165c86fc86c,0x0002759020878e09,0x000c8d6462169c4e,0x000a7ec795ff10df,0x0000740ea7b723b5}},
    {{0x000c734b07d5d331,0x000c0fc9ac292c4e,0x000275f2fa5774f9,0x0005b64cb6519644,0x00000932f708d9dd}, {0x00099e5189916537,0x000dab579fa96e9e,0x0003d581a498ab6c,0x0008466030186ad2,0x0000487b0b95ef84}},
    {{0x00035b4387096d4f,0x0003df6e71b2ea65,0x000937553df75f29,0x00010b31d49965f7,0x00006c0c5a717d4f}, {0x0008a025671103ec,0x000e123bb180d8a5,0x000b43b65a239855,0x000f61fa25b52a09,0x0000f771fc550da3}},
    {{0x0001111d075e5253,0x0004096fe18d6290,0x000c240dc07656fa,0x000abcb58d552e84,0x0000e3c9762d4f9e}, {0x0005b0b103502350,0x0009f566340da097,0x0004d4fa8636d51a,0x0005251761de667f,0x0000e20349d77617}},
    {{0x000804e04fc602d9,0x000ef28a89d0ded4,0x00086f1cd8ffccc5,0x000cc149f28d2957,0x00001630741537d4}, {0x000f2ba70b640180,0x000b39ff8919aa63,0x000ddf64f6350c9c,0x000ed9819793e411,0x00009e24759c0d79}},
    {{0x0000f19f4fd5dffc,0x0001ceff4bc9c7a1,0x0008f73cf0116b0c,0x00061f4e478201cb,0x0000d21b82382518}, {0x0000765f0c491b5b,0x000013baad4faf40,0x000300e32e5639f7,0x000d8d4ad69ae26b,0x000039328a470b33}},
    {{0x000c84a820e49c2a,0x000632dbefb4207c,0x0003a58a5ed4c55f,0x000382bac82b1f88,0x0000b15eb7c77391}, {0x000f20e1f1265f7c,0x00061058e88c9ab7,0x0006384f1cf8b862,0x0003879fb6321663,0x0000cb9aeb634518}},
    {{0x0008bbf43ae6df99,0x000e2d6ab4528524,0x0005334bce88a401,0x0008055ec2fa9a47,0x0000d4dca87805f4}, {0x0006ced09a787cb1,0x000d0999c03d5db5,0x000b45d8fbfd1741,0x000babb6f0173a87,0x0000a2096bb2323f}},
    {{0x000a21bedb16d4bd,0x000e6b75d1d16e09,0x0006bc64045b4bcf,0x00039d063765236c,0x00000a23f6f637d9}, {0x00074751ceb98088,0x000dba263631ffca,0x0005c24d5fa3b792,0x000afdf1a7fd6b25,0x000059077c5a10c5}},
    {{0x000da27ddfed9085,0x000e4268009b9ec1,0x0004b5d55add639a,0x000c645ca7d97f79,0x0000f7c88b1f440c}, {0x000dd0e67085ac15,0x00091a87c0cc8497,0x000956ebd13e13f9,0x000f43f208267e50,0x0000950c4ee3dc87}},
    {{0x000767687730a906,0x00086fc6d094b775,0x000902ef6b5667e3,0x0004940ab659cccb,0x00002c5c7ca26500}, {0x0007b7f151927dcb,0x0003251daf1587c1,0x000e13028bcd4fe6,0x000bec56ed9812dc,0x00002b1a165bd153}},
    {{0x000922b16d41f3ed,0x0003171dcd2ee6c0,0x000fb901db1d6685,0x0003a9ae9e9a3b18,0x0000fa1c572a62e6}, {0x000eddd1acbe3647,0x00057c3b62c81e6b,0x00095ef93b30ae10,0x0007c242fa98c96d,0x00004313bd27d329}},
    {{0x000590d655a44d1d,0x0007a791be183844,0x0003d3938484d868,0x000d526b8e7d0675,0x000025aa4d1a7d94}, {0x0002fc193234941e,0x000c53450cb67e66,0x000dd6fd063acd11,0x000fb3683bb3f0a6,0x0000017b88e1cd67}},
    {{0x000dfe137bc4a4d3,0x000a6f70d1220567,0x0005d43015bd4b27,0x000073c03a5810f2,0x000038319b9cc364}, {0x000e596aa8cf3d1b,0x000eff7eb1c9ff82,0x000b8e2dfd434646,0x000515518b703e5d,0x00000fd92c1335d7}},
    {{0x000f2ed01b9068a2,0x00003e0f5e11999b,0x00081ad391d14a72,0x0000ec9e891cb005,0x000034d551dfbd27}, {0x000e3e94269c7442,0x0002bdf2d623f98c,0x0000ac69fcba079f,0x0006b8e6df04439d,0x000094022be24a1e}},
    {{0x000624f1ce0f1e4d,0x00066318ff1e2b3e,0x000cf68fd9152d17,0x00026fa5d91b3a87,0x0000450cb4e504c4}, {0x0006852e3c9f1ef5,0x000539195d3f5568,0x000858b621b8887c,0x0002f2742dea5594,0x00008e75022bf2f9}},
    {{0x000b07bf5bdb8d74,0x0005adfca4449042,0x0002e1d1ead50f78,0x000484f785f4721a,0x000049993fef7c9f}, {0x000c8c0c7eeaa416,0x000b7f465774cab3,0x000a78325aa244d0,0x0000243470b1e003,0x0000822e9e020093}},
    {{0x000c845fa39fbc60,0x0002293ec4ec1d40,0x0006379a019debff,0x000755eda9d51a99,0x00009f94dc7743ec}, {0x00010b3843c61a6b,0x0009f974867d68ea,0x0005dbef26fadbc5,0x0008f2b3e875258e,0x00006cb8dd761e1a}},
    {{0x0000ad3ad5e6e384,0x000e291dd98cff89,0x000718231c43f57a,0x0006f21945dfe8c7,0x000061970b97a133}, {0x00082cfd677dce23,0x000f52f49f824e05,0x000b7784bdd02efb,0x000b85cc1c90ef12,0x000014d0c33b781f}},
    {{0x00060c791130be5d,0x000a3b5dc85a2ad9,0x00089ae96957ee66,0x000500bf4143b0b4,0x0000de968fbf16d4}, {0x000480887ad52fa6,0x0000d040ca0e6706,0x0001fc876898a967,0x00096b92364ae69e,0x0000dedc76278467}},
    {{0x0003de2fb18ca7df,0x000864975906c34c,0x0008c99c77a4177c,0x000744f9db29337a,0x0000758b714ec06b}, {0x0000287f5082885b,0x0009f9b49e575a58,0x0009f2005dcaeb2c,0x00057c4f90329a9b,0x0000e7c828178ce3}},
    {{0x000070cd2e84852f,0x000127c1c04293d3,0x00082b797b024206,0x000ae76c1b1ad1a5,0x0000f75b079c03e1}, {0x000e4e6207b73a21,0x0008751ccacd3daf,0x000a230c168e33ef,0x0003bebb75b39a80,0x0000ce273b967045}},
    {{0x000e4cf7ea2bf1e2,0x00002aee47c0de34,0x000ad4d02064992f,0x000d96aed6f23dc7,0x00000258e1fb9565}, {0x000d4dca99aff602,0x000578622da2f6bd,0x00013f2c376d4555,0x0004856bed645115,0x000023c2392fbfc8}},
    {{0x000c65742561338a,0x0000f335e54959ea,0x000e714b02e99bd9,0x000531924d4cd35a,0x00001199bd5dd95a}, {0x0009f7a238d15ffe,0x000e09222be15441,0x000374b05d41934b,0x00061df1d9a1aed2,0x00005508ba021f85}},
    {{0x000279df95030f56,0x0000f9ea1ab0d177,0x000f99992a351c3b,0x00064e9220c44b6d,0x00003455043e8fbd}, {0x0005de277b82a5bc,0x000ac3b68530cd38,0x000ca086694c0653,0x00063ce81e602ff2,0x0000ef40f405268b}},
    {{0x000b7c3a8d2bbe19,0x0001bb32fc4ebdbc,0x000caf9eea029867,0x00095c27a58c50c3,0x0000c0ab3cd9d1bf}, {0x000e9607ac0e8a6e,0x000fc1426abde891,0x00074904b992b549,0x000b98a3dd1a72aa,0x00003c2e33afdede}},
    {{0x0000a5f93a4e96de,0x000c85e5eafc25af,0x0005a62bdb7ac424,0x000558424b99e578,0x00003c24c7e4a4ea}, {0x00094a38275f9857,0x000c9c7fa4275e32,0x00081251fc7ef065,0x000800bc303dc5a0,0x00001f0537c463a9}},
    {{0x0009bd0faab7ac3d,0x000e80f256cd6560,0x0001cdf6644f220a,0x000341d90e8fe916,0x00002d221d5ca965}, {0x00019a678ae67ba6,0x00030f33b841d032,0x000d5af5d16ce5f4,0x00070b06fcd2214d,0x00007fcb30a9c986}},
    {{0x000c6d4993412281,0x000466c0976b7162,0x000e48195e68d8b7,0x000a7c3a400a9f5d,0x00003f11324f1feb}, {0x00068a9ee5214a73,0x000895b4a3f14392,0x00035066970be472,0x000438b2cae53e6e,0x00000e849079c7c8}},
    {{0x000ab4705ac23184,0x0007e535509d183e,0x0001a9d696cd87c5,0x0003178c8f88a2f8,0x0000610bf6f3760b}, {0x000d814c4dca8a05,0x00010f8ceb1157a8,0x000537398b47d20c,0x000424fa8d6446e9,0x00001fe7a476cec4}},
    {{0x00072bb2d03ec2ff,0x00025023cd075ac0,0x000d7ecf72f0f3d6,0x000efca8d8dd2d56,0x0000a3d270a63597}, {0x0005bdb8fa49c984,0x0003984320dca40c,0x0004211099e72bd4,0x0003af1f17bff561,0x000078129a3f3005}},
    {{0x000cb54f682dd291,0x000a10b13967c1cd,0x0009cda2fbf3fcfc,0x00038cfb00e857a7,0x00003a87c6a0cf82}, {0x0002489b23f1d3cd,0x0009ca41c9084179,0x000f0d3e98ef9e8e,0x0007bab2cdc4e833,0x0000e159ac26b23d}},
},
{
/* digit=22 [{1,2,3,..,}]*([2^154]*G)  */
    {{0x000b73dbe429e6f4,0x000c3138ffc05f82,0x000a3b67f590e285,0x0007bcb900484c1a,0x0000aec77b3d8941}, {0x000e442032e0e61f,0x00070b271f75c0ad,0x000b1798d01dbbbd,0x0007e3958d61f8ee,0x00007c8bd0d03ca0}},
    {{0x000e6d0844c0e6f2,0x000c3284a1e580fb,0x000933260fbe850c,0x000f1d49fa978af8,0x0000f631a40a5bff}, {0x000151afce47898b,0x000d97771637ce9d,0x00029ce3be231f37,0x0001bb143714824a,0x00008614e5ed8aaf}},
    {{0x000e80c351d61ae9,0x00034e58cbd057c7,0x000018bc8ecfdb95,0x000c2ca5a58c2283,0x00007d50125d76ea}, {0x000465a381106373,0x00041f1dd517dfc6,0x000184218d7ec5e4,0x000ea6cc1e142bb3,0x0000006ce0efce95}},
    {{0x00003b993a36842c,0x0004ff423a275d4d,0x000ea1fe70c60a7c,0x0001025151148bb1,0x0000be81326d9e64}, {0x0008d837d64990b2,0x000d2db8c89e7194,0x000692e72baae2d5,0x000e8c0dd17618c3,0x00004b6ea9b40d6f}},
    {{0x000fd692bf95567f,0x00053ebad159ba68,0x000340f3a53fec60,0x000ad6552431579d,0x0000df4e7d133f2e}, {0x000144d67c90b92c,0x000167158f063ae2,0x000abd10013a5c86,0x000729b8ee2bc967,0x0000b9abf1b96668}},
    {{0x000f140c73562945,0x000cfe3add38ebf2,0x000df7dbc2a2e566,0x000476e0e3f9dbd8,0x0000ae24bb41e6fc}, {0x0002d58819c1c23f,0x000517b2f5b645b3,0x000e863c8b271901,0x00069def3f6a2be5,0x00008f784e4c8202}},
    {{0x0005b1d21ec38f34,0x000d1346ef526b08,0x0001aaf39a530ac7,0x000336aa7792bc04,0x0000759ab5765fb1}, {0x000d665388e67c77,0x000e31ff335430b3,0x0002f4df0b037e8b,0x000bb1010d23084e,0x000085bacaea9944}},
    {{0x000e2601dd188f66,0x0009e8c268296001,0x0001a9eeecbb5766,0x000b9f7ae1f2b5d0,0x00004069ef9b9ba6}, {0x000798a2fcf1d940,0x00063d59f8620844,0x0009af2a19d2299b,0x00026abee6e38778,0x00001f7192df4bae}},
    {{0x00053eb08c850a38,0x000ec6ad45b295c2,0x000029b17c77b7ec,0x00066724f2c9dfb6,0x0000f4bbf5043f22}, {0x00027dfbadc1cfc0,0x000c9c9b43c55b3e,0x000f3904abe353eb,0x00010196a71e4ce1,0x0000960958fa8fb7}},
    {{0x0002fce77ea0ed70,0x000f5ed5ec66f089,0x000f00db8587d743,0x000085766c95169c,0x00005b6bf27de7cc}, {0x0003e7f9cb37cbcf,0x000f9ff50ac46924,0x000c0bf82abe04a4,0x000e20c506429d30,0x0000cf6603411d09}},
    {{0x00079d7ccf998928,0x00053aec1803601b,0x00023b4297648463,0x000aff355968bc95,0x0000d5d4c0854553}, {0x00057ac873f512b4,0x000cd320d16e1b4c,0x0004ed91186b08c1,0x0003e4608228cf7f,0x00004c70e3dd005d}},
    {{0x00088f1944156ff7,0x00011e971438cb5e,0x000058fa1b18ee73,0x000cdcb89e85f304,0x00006e2f51891388}, {0x000232f34ba5cffe,0x00003843e83b0cce,0x00097c9aa7eaba9a,0x000ece9610dcd10b,0x00009f5f0d594daf}},
    {{0x000986810095f72f,0x0001ac29a7c24844,0x00032e78ed086800,0x00098f626c35c5a8,0x0000d83403c23bba}, {0x000a7f5c20ac35fa,0x000d88d0bbc7266d,0x000e582bac8b42d0,0x000935657786ea28,0x0000bf7fdda51e43}},
    {{0x000de66539c57709,0x00029ab48f57c79a,0x00053b7f7c92d81d,0x0008ccd6929d04ad,0x0000d6805ffa633a}, {0x000c653e3c30e224,0x000a25014af38c1a,0x0000fb9056ff7e72,0x00036e84863461cf,0x0000feff997e9cd2}},
    {{0x0008f4fbfe1bb87e,0x000b234bf5009643,0x0003e08355419bfe,0x00059cb34567fe1c,0x00007cd632f8cfe3}, {0x000b06cf3a3127e3,0x0004a9a97e2d7d25,0x0007d0094b3c4c3d,0x000715572ac1af4e,0x000097c70eb31cd4}},
    {{0x000a30dbbe55bebb,0x000acbe0f0b73fc0,0x000b583ca72ac528,0x00058a26c3397a15,0x0000690f6fc7ed03}, {0x000c62882b679996,0x000a4e77a75d9acb,0x00038d76d9db5245,0x000eece8f87c7f73,0x0000595862fdb1d5}},
    {{0x0004badd8661917d,0x0005007f84c3acbd,0x00040fa3d59ba026,0x0002ed184e937c66,0x00001369d0f0a780}, {0x000fd94d28839e74,0x00021cd14e0c49ef,0x0007442dff19b151,0x0001044685338c05,0x0000b46081f8392f}},
    {{0x00011d53d358e352,0x000ad7cfd455b082,0x000bac2fd8bbbf06,0x000acc8cd30a233d,0x0000d70c7b7f7357}, {0x00026832fec7aa71,0x0005d1d2ead1c40d,0x000b7a761f51ab79,0x000816ec07f749be,0x0000c5ae5e6830a9}},
    {{0x00099bbb81316b37,0x000eee7327744649,0x00036c6dd3fa17e1,0x000cf40d417b7a4b,0x0000cdaf38243743}, {0x00092c6085af8552,0x000765fbc2a4eb0a,0x000a3aabcb9c1f75,0x000715c991d08c04,0x000063b26b5053f4}},
    {{0x000869e8f8653478,0x000498cb16b98bce,0x000bd2b92786668b,0x00070a1e52fd90fb,0x0000fcf025fb7145}, {0x0003105fe53d4b78,0x000c7d1f08cb8199,0x000e90aa136b8d03,0x000adab87b877995,0x0000ff5b8a7416f5}},
    {{0x0006181e6127b8f3,0x000e26986975931a,0x00050fa780fda309,0x0004c9cbf2d51ead,0x00000b52ace1f172}, {0x0007cae0f0e4d834,0x000d5d6c4773705a,0x0003f0301bc79516,0x00008598de8bea90,0x000050e748954ca6}},
    {{0x000313f2b32b8c07,0x0008ad46a7a7864a,0x00071aba203009b8,0x00019786bab2c270,0x00009eea2825dfae}, {0x00022bea3c6feb06,0x00067e299123604c,0x000aa7d5ba6e907b,0x000bc50302538712,0x000018eb27f3228f}},
    {{0x0005c9df43643466,0x000f22a16dea2da5,0x000026ad0fac5dd5,0x0003677c40f2faab,0x0000af1895ff0f0d}, {0x0005cc7072a95ee8,0x0002231880e3d2a1,0x0003245ac109f07c,0x000a3343e7d98a81,0x000053adddb5139a}},
    {{0x000da35f08f5eeaa,0x000b0c8141361e77,0x000274120e93a89c,0x000d2380e4856041,0x00001a55e742ddff}, {0x00047074615459da,0x000a3cae4a32bc77,0x0002bc1e180630de,0x0008995de64b3ee8,0x000066bb84bd1667}},
    {{0x000fde701d4ff7a0,0x0000c53f426d150c,0x000b25dbb8593360,0x000302331d9505e7,0x0000ed1a8e859f94}, {0x000ba4e5e0f86f6b,0x0001e557b53b35d7,0x0006087ef1317fc7,0x00069a1f34ef53a5,0x000023a1a44d68a2}},
    {{0x0002686d46f85357,0x000f2b2aa5adc9c6,0x0002bcd92779e24e,0x000ac2af4f9ea4cb,0x00005036fdea645c}, {0x0009945ac233c5b5,0x00042cd0ab16222f,0x00096a9d0c598bc8,0x000b25254749518e,0x00006f6d06bcc429}},
    {{0x000e2d17828d97f6,0x000a6cb1d21e5e54,0x0002876e02980d80,0x000fdd11debb54d5,0x000002f74e3fc7a2}, {0x000a25518c05c3ef,0x0004a101d6408d80,0x000ed1c406f00af2,0x00036f5c1f6158d6,0x0000932ec7aec045}},
    {{0x0000dd90c8eacd14,0x00051c277d39ced7,0x00037b995a86eabb,0x00069c2d692f5dc3,0x0000aaa65fcbd3f3}, {0x000fb8dac3487ba7,0x000fd9030bc0445e,0x0005b00d8a303975,0x0005ebfc43a8d1f7,0x0000cf7e4b1a80b0}},
    {{0x000e7d3babe2bed5,0x00008ed9aa788262,0x0009ae8cf61b9b73,0x000a2cb8859a7ead,0x000009dd0bff2a08}, {0x00089563be5f62a1,0x000c60b33a1ce2ba,0x000eb11c00b2efd6,0x00076537bfd95b86,0x00001760e857be9a}},
    {{0x000df2f2e4d68602,0x0005e7f162bab259,0x0008073b4332202d,0x00097922f1857cec,0x00001ada3db5ada4}, {0x000feabac21545b5,0x00044b8366fdd7cb,0x000823597e0a8ab9,0x0001b19ca5ad3fd4,0x0000556946280dc4}},
    {{0x00068bc679af7df3,0x0004d09bd4c65b7c,0x000c3d5c8bb79f15,0x000a8eb5a55faae6,0x00000e146d53e240}, {0x000bb5275fa8a745,0x000f9bc67f8fc6e7,0x0004d7d55f437e48,0x000162aaaac77964,0x00008f7b8a4e25c7}},
    {{0x000addb9871528de,0x000efb8f6e9085a4,0x0002b3dce56c416d,0x0009f9352c94a7f5,0x0000cb572963cc8d}, {0x00073bb6f154d061,0x00094ceb155e9479,0x000479f043bcfa01,0x00094fef2ebc01a0,0x00007c190148abea}},
    {{0x0007288c1fd2f6a9,0x0007ccb5f2f0c85d,0x000cd8ddf6f0d1dc,0x000d6d1b46cbab39,0x0000a99e4c52cc37}, {0x0006b442e61e355b,0x000805cf7f7f0461,0x00062ca1fbf6d2d2,0x000a6685af0aca3a,0x000059f9cee65508}},
    {{0x0009830a1370ba94,0x00066f630ed4cc2a,0x000c49043c9c70f2,0x000cda45b0a9a339,0x0000981cac0d3fd4}, {0x000fd2b1537c0568,0x000d2df567bfdb10,0x000f06ee7b678713,0x000035476bfd49ac,0x00007e163ef8dffc}},
    {{0x000a43558915672f,0x000c1ac1fda86ae8,0x00060c9a1cd95a10,0x000104f8c2f7429f,0x00008f5ad3637888}, {0x000c8fcf90898e9a,0x000df624e89346a2,0x000c1fea87fac86a,0x0004b83fd83bf0ac,0x000084646a23ba36}},
    {{0x000f4fb4cc23cc0e,0x000d0fdfd051e92b,0x000f292128680d8b,0x0001f9e822e278e0,0x00007d4d9e59445c}, {0x00015c16f300247b,0x00007aa90db5c335,0x000342a9caef4b57,0x0003e1dcae37a135,0x0000333cb5dfa28f}},
    {{0x000acedb3b302867,0x0007a112c1fd206e,0x000c8ec52d01b8c9,0x000b94e452325cab,0x00009f884b8bdf35}, {0x00097e89f70cf04a,0x000d749d1ae5ecdb,0x00044351436bbabf,0x0008abe4530f2f42,0x0000bb3ffc216d9c}},
    {{0x00001be0aef6af88,0x0003999c0a70d435,0x0003287b2e21580a,0x000a5b6ddd29cc9d,0x0000458091850c10}, {0x0003a83b67e26fc0,0x000ea4f022126008,0x000f9f5f013525d0,0x000f6daa2f518f8a,0x000004d78d00bb76}},
    {{0x00007dce35d51eb2,0x000bd3f986bf114d,0x0006bae418c11481,0x000fad9aa9bf9aed,0x000077c4aa6b8996}, {0x000c111fbadb653d,0x000475bd860ae81c,0x00037b28ab206311,0x000dced3249e29fe,0x0000f13e34b76224}},
    {{0x0000d8d46c6cabee,0x000f1556df1e311a,0x000bc9a29620950f,0x00069f3a256b625a,0x0000845ca024ae37}, {0x000bde60adf24a88,0x000bb4cd5c340731,0x000458b3da58fa82,0x000fbd43156083f6,0x0000e80538fd3b33}},
    {{0x000d5c8a4f806766,0x000e48d81dc67831,0x000430a5bacb70bf,0x000d86bda3b12c13,0x0000e602fe106d61}, {0x00026aa4d9ab33e0,0x000174ef7d6aae6e,0x00040016264165cb,0x000be577ac555a74,0x0000910d31ed147a}},
    {{0x00081f76af0426f7,0x0008410d604b45b2,0x0009a1d45d6fd752,0x000806aa4fbd4908,0x0000c1de40f80886}, {0x000bf8d15847181c,0x000703c99e3ba93d,0x000125e520380a85,0x0007d15781da897b,0x00000c67ed4697fc}},
    {{0x00028041ae87db81,0x0009887b3bc50e3e,0x0003fd20d364a165,0x000aadeb000f0f28,0x000038d839993e13}, {0x00085d6a8b8661a7,0x000b34e820a8623b,0x000eab235775fc13,0x0003ba5f2815b147,0x0000d88868130267}},
    {{0x000d1e00b2843c2b,0x0004df08cfc65f61,0x0008c6f049ce3d0e,0x000d175a3aa4f905,0x00009ff1be643e16}, {0x000c16adf8587d83,0x000242fe78408aef,0x00047747318730e3,0x000fe910dd08eac8,0x0000bef97b69315d}},
    {{0x00099942d00d801c,0x00081d20b58aab1d,0x00083cc49dd642b9,0x000a89b8d67ee603,0x0000d28c6d5ee521}, {0x000f3f9e69075ff4,0x0001d35323720055,0x0007768d68b51dbf,0x0001e7c55669a92c,0x0000298cf352d79d}},
    {{0x000f2548f7c0a953,0x00011d0960107f3e,0x000e0af7bb667c89,0x00064816f354cac5,0x0000d50791b116b8}, {0x0006848e4fd86c6e,0x000c9b7eb17c143a,0x000b947b4f8a167c,0x00060e30ba6169c4,0x0000133e463aa3a4}},
    {{0x00029106d1d6a7ce,0x000ba4385d93bdd2,0x000ee80a9f04f720,0x000132b787a4ec14,0x00004ea21e5863a8}, {0x0000364500d59b88,0x00060f60934a7413,0x000ef1d84166c20c,0x00031d1fab6365d3,0x000088cd5fbaa114}},
    {{0x000d32fedbd19814,0x000221d0419272e7,0x000c4ec059041e52,0x0004de9d2dbd541b,0x0000443d10dc8775}, {0x00078b0d3f94e824,0x000ad40784f9f399,0x000fcf6218b57c8e,0x000b5e55522304d1,0x000047969a949e6f}},
    {{0x00011391108d6518,0x000f28d0956f98d4,0x00002d8f8d2ccf71,0x000b41502b1a4d7c,0x0000df02a4b0a6b6}, {0x000be826697a7400,0x000bbaede068213b,0x000c698316391575,0x000947ceb3b39955,0x000092ee9cb03fb9}},
    {{0x000acdeec1fc6432,0x0002bf85fe71a639,0x000483fcd152b2d9,0x0006a076d90c3e2e,0x0000f765abd75a8f}, {0x000eaa6605b6e935,0x0005d4661347735e,0x000b692ca9771efb,0x000033f6b4f4f2c0,0x00009e887ec099c1}},
    {{0x0000f5f11e1df448,0x00062268eb0e4b3b,0x0007263a3032513a,0x000cc00b41244642,0x0000522b093085dd}, {0x000a4316959d64c4,0x000aece72aeebcb6,0x000a57e25bca4137,0x000a307ad4f570ca,0x0000ea827aee1273}},
    {{0x0001c403871a258f,0x0003c3e40bd72b4f,0x0002aef142a3cf29,0x000c0c94b6f5d42b,0x0000c868d6bb0915}, {0x000fdf303a147183,0x00075f9ac83d925c,0x00078cfb4a2974c2,0x000cc66f8a5e4142,0x0000ffea4657d7cf}},
    {{0x0003d2857b0fb80c,0x00071f7a356b4ff2,0x00028236aa740396,0x00073184ebce593e,0x0000eeb59035372a}, {0x000a4ef592e84599,0x00099e31e3885ac7,0x000dca9f931251e7,0x000405a7e073ded2,0x0000ffaa7091f0ca}},
    {{0x000993353be2eb86,0x000523cb41aea060,0x000f52305f75d323,0x0002da1c19ae132a,0x000005aaaff1356a}, {0x0000b58337d86433,0x000ea1fc9f91fef1,0x0002a47dd5fb33df,0x0009e296da6bdb2b,0x0000d30051c46b7e}},
    {{0x0001396d37931aa4,0x00042fe59d13f6e2,0x0003436e3bc1ea61,0x00095019fd93e242,0x00008077ea00eefa}, {0x000d18f2e5c1305e,0x000ee6a4b029fad4,0x0007af0a58115f19,0x0006774913164569,0x0000f85f4ccc0bf6}},
    {{0x000abfabc6473ac9,0x00076f8f0f80e13e,0x000ca19fb9dad550,0x0000add3a04f0b57,0x0000371e049416e8}, {0x00061632d80ea152,0x000278e8a04dac3d,0x000220d15df178e2,0x00019959c39ef8ff,0x000054bc5557480c}},
    {{0x000faf5f45158e7a,0x000d1f1c1ad0350b,0x000f15bb4fef27d8,0x000e3fc4f652ed78,0x0000166e75983350}, {0x0002cfe2e4cbe8e4,0x0008a56c51d904f9,0x000ec83d02ce2901,0x000b1cbafabfbd51,0x00001176ec3b0b9e}},
    {{0x00085b4bca3d230c,0x000a63179d4ba4da,0x000a166590810b39,0x000b36088f040c03,0x0000773154019362}, {0x0004e8f53d96a2e5,0x000b3ce80126aff0,0x000eca232cc5998f,0x00000d61e47aa73e,0x0000dd3cdf403670}},
    {{0x00055f69d0a7a33b,0x000d34ce0392f3dc,0x000bee0d7944608b,0x0005132e2a2b5516,0x0000cb2be45b0370}, {0x000fb9ef66b067f6,0x000160aba278abd1,0x0007f0556104063a,0x000b4519469ecf88,0x0000d00218f6f0a9}},
    {{0x000775dcbbf023f3,0x00045ef40d8ecd2b,0x000eee1c75c73796,0x00033027bf36185b,0x000082791736f63d}, {0x000d829fc7d15216,0x0003028b4561845d,0x000fbbee37cd94d7,0x00092fad0aff8b0a,0x0000180e25ae0f03}},
    {{0x000f7e62927d7a9a,0x000c839904e36315,0x0005df42f47d356d,0x0009290393e21cd2,0x0000466787630e0d}, {0x00025ee6ced93469,0x000f010090774044,0x0007a7592fd8fdb2,0x000a03dd870e7a31,0x0000e332fd788110}},
    {{0x0009edb975ec2c09,0x0005175735d65d1b,0x00064bc88e72b8be,0x000ef80b4c4c003f,0x00003be7738bb2d9}, {0x0006e0fd72ac494f,0x000ecf9a7a5fdcc7,0x000b1e5a2028d854,0x00097874b4af8b2c,0x0000b21fce5d8966}},
    {{0x00092d9ee6a8ebf2,0x000f26040d80ea6a,0x000852efe4c46437,0x0005037006c5176e,0x0000866683ba0c93}, {0x000bfd0134476305,0x00040e03c13b63bd,0x0008885347ace166,0x0003339702e75cc7,0x0000f159cdfbc73a}},
    {{0x0002a9170ad6789d,0x000d2234dc9ad48f,0x000f2a7d5e25f59e,0x0007a488b843c73e,0x000027897d1cc561}, {0x0000fd3365d34202,0x00012bb48f85ef77,0x00069764c4ade689,0x000d9404b74787a3,0x000055e4a1bf0653}},
},
{
/* digit=23 [{1,2,3,..,}]*([2^161]*G)  */
    {{0x000e715ce388849c,0x0009bb7a2d2af7f9,0x000661db13a1607c,0x000108dedcca8040,0x0000b1a7d04a99e3}, {0x0003a8e4d163dfdc,0x0001783f0e3121ce,0x0001fa2958fee10c,0x000e438b956bab30,0x0000a007e991f63f}},
    {{0x000c2bbff739fa94,0x000c017ea854bdf5,0x0007a64f91d3bfa6,0x0000fdc41fb9d90e,0x000083aa0d7f2c19}, {0x00010d24d367c028,0x0004597010d57ebc,0x00032c5579b43146,0x00072bbd8b596396,0x0000ddf287538ee7}},
    {{0x000d002aead503ac,0x000702bbfd247478,0x0000b804d9f4d7e3,0x0002ca633f318949,0x00003505e7867a6d}, {0x000e5d7dbff73d80,0x000335f9e633fe97,0x000ec9aa42cc3a3e,0x00034df252891ec7,0x00004900747ed888}},
    {{0x000d54830481b038,0x000e2747a4cb9b56,0x000c55970078ce04,0x00066e74e17ce4fa,0x0000ea3c99c7fdac}, {0x00047874a0836e33,0x0008462862478e13,0x000af3763a660e33,0x000f8efb8318cfbd,0x0000993ecdd67d59}},
    {{0x000143d1036960c6,0x0001ffe5607a28b5,0x000be0da767df772,0x000db340e2fc542c,0x00007bc3d3e1614e}, {0x0000a909a4228534,0x000df6d0a4402b66,0x00036e7c5f663676,0x000900fa2bc94c05,0x0000d5caab23f5a3}},
    {{0x000c9afe79e70193,0x000d0fec85a37b5e,0x000a360abb585419,0x000883bc10053d78,0x000097415c9102d7}, {0x0000686637dc9a27,0x0004c4b95f42fa66,0x000cd93361d4b524,0x00042e32721d0b6a,0x00007db0d3bdbc70}},
    {{0x000bffcda8b06d6c,0x000713d8d2427048,0x000cd16bb5d30666,0x000c2197309cf437,0x0000a11a6f46e8f0}, {0x0008bc17a71c4e20,0x000a92d41371975b,0x0008eb0f5349e195,0x0002ce43cc3800ca,0x000041f3bf72ccf0}},
    {{0x0001daeea3ed0905,0x000e1bd5e3c53fbf,0x000c1100344d6a8d,0x000e5e4699602597,0x000060ea92b03fab}, {0x000e180e331a3fe2,0x00080a41fd2b20f8,0x000cdb94814472c1,0x0006c8ec624980f6,0x00000f649cdb7533}},
    {{0x0004ac13e9d9a85e,0x000ac7ff9c45703b,0x000329fbf150d4b2,0x0001fe9bfe98b07d,0x00006ef7b3a05b5a}, {0x000f985fb40d4e51,0x00028cdb30c4b3f3,0x00069b998490bd1f,0x000ee22e2266c121,0x00005d8c7fd5c464}},
    {{0x00017c9deb217fde,0x0000d74da8211aad,0x0001d8f1f679025c,0x00046eae0861688b,0x00003593982918fa}, {0x0009d1bfbf4ff519,0x00072a742f2a69e4,0x000bc2636c0fae9c,0x00046b33d049c63c,0x0000197ec842285d}},
    {{0x000624c23eaa251f,0x00071318ca3c4e9a,0x00095832234ba387,0x000151f4edec7eb9,0x000040bfde516f7b}, {0x0008fa54043404cb,0x000a18aa5c602ed4,0x000ae3268e047506,0x000d7eab79eb8def,0x0000d3b0628dd6e8}},
    {{0x000c4cbd66e8fe68,0x000dc69d604cf338,0x00037b6dd97e28fd,0x00035b246f37d007,0x00000272666649ae}, {0x00093d37810cf944,0x000a459f78ac9a38,0x000ce165aabf2ebc,0x000d640453946fae,0x00008fa3bf971e87}},
    {{0x000b48a8dba5c4e8,0x0002279adf9d8dc3,0x0000634c4f3162b0,0x000b99b53c9ff728,0x000007d5d4dfaa42}, {0x000ff5483cd41f20,0x000f99d21f8d8aa4,0x00081bda1da27bb5,0x00014e9a023684cb,0x0000f7ca6a09c875}},
    {{0x000567e48aaf12a4,0x00072c6ad9edf914,0x000cbc02cdd34885,0x000546ad9d3126ff,0x0000421b423fa8d3}, {0x00006150c5383199,0x00071eb71f6ae471,0x000ba9109ff4978e,0x0004c14e33185f0d,0x00001b2adaf1a25b}},
    {{0x00022a2429dd8dec,0x0007cd18b13b0a91,0x000b0ceea09a2c07,0x0003e4cfd65c5719,0x0000c9bfb6cc8897}, {0x000ab8bb6da6f448,0x000361113f5c0f75,0x0004bcd4ce388639,0x0009b3c84e7da532,0x0000c1fd90d251ff}},
    {{0x000043aa2a095bb7,0x000f9b9f786a3956,0x0002db051d57f81a,0x000149260ef94740,0x00007bf6371cac51}, {0x0001f2f5c58d7ca4,0x00040f7f7b148a02,0x0007371672527386,0x0004b3f38f333829,0x0000dd7a77b276e8}},
    {{0x0005457a7eca1884,0x000cbe9cc41123f9,0x000136109bbb2c81,0x000d931b767fb526,0x00007e27c293ef66}, {0x0003f2073a6659c9,0x000dc1c5bb8bcb6e,0x0009084018ee6a36,0x000ecce3dcbff9b0,0x00008f3df8af2dc0}},
    {{0x000d83214c8380e8,0x000a3ec7ffe0ad3c,0x0000a2a618aea404,0x0000c47d0790d1b1,0x00000273e67906f3}, {0x00015287e729a739,0x000c7793bec7e17d,0x000acf922b6820b6,0x000254244b10a6d9,0x000075cf6a5b4cab}},
    {{0x000e81a727320b70,0x0002224f04c96aed,0x00023666fc18bf83,0x000b00b1675a97e2,0x00003640ad09f382}, {0x000efc15509f9819,0x000644de6fa11fe7,0x0008a4478b13a59f,0x000e660ba6778ad8,0x0000f50b5ac51bf3}},
    {{0x000335a6248572ee,0x000fe809fb5fe516,0x0009687ddec290cd,0x0005b5dde9196a7c,0x00005c7d5573c17b}, {0x000ca4c51c772072,0x000a292ca0ca7c47,0x00061427ea87854a,0x0003e4b62b22808a,0x0000c0e5c44caaf5}},
    {{0x000cad5d48a4d850,0x00038d63ffac15ef,0x000132f45987e66b,0x00026ccf724889b5,0x000098deb93b1efa}, {0x000c62a168e65f44,0x000179a62036dfda,0x0008c6dbc9a4ca00,0x0000127fb88e937e,0x000082fd3c4bc09a}},
    {{0x000f3ad4813e9d65,0x000bea963f775c93,0x000f6998a46925b6,0x00042bbe8efab45a,0x000029a003ea7de6}, {0x00043182741135fa,0x000c3b74e1a693fe,0x000868769efe7061,0x0001612e436da60a,0x0000de122bdce426}},
    {{0x000e61a87ddb5720,0x000452750c03edbd,0x000b38089eb41621,0x00024498574681e0,0x00004444c5108b2d}, {0x00036ed4405c72c4,0x000be6b96571a817,0x000f46d03728b4d6,0x000d22955878f06c,0x00002f2165d6e0b3}},
    {{0x00094e84458cd24f,0x0003bef3dc9a70f5,0x000015cc27ea5fec,0x0005fb57e2473ea9,0x00002182214585b4}, {0x000ebd801e198aee,0x00041dd30f306bbd,0x0008a039acb01cbb,0x0008fcba8a783d98,0x00006a26d47437cf}},
    {{0x00036d49031103bd,0x000fe7923cfb91e1,0x0009eb93161c2874,0x000b42decc591c88,0x0000df51011dba39}, {0x000990ab10e9def1,0x000b6e7f06951c4f,0x00063898370d2788,0x0006086393208c48,0x0000fe1f66e971ef}},
    {{0x000b1d4d77c20846,0x0003b33e6323e50a,0x000985e8c9dc50c0,0x000486a05634b919,0x0000032a15357882}, {0x00036b5f08065726,0x0001971634554a52,0x000f5fabff87414c,0x0006926e37e37906,0x000043513f70d8fb}},
    {{0x000739d209dee688,0x00006a1bf22b1a5c,0x0000f4d7e2ebc0fb,0x0006423d3abeed81,0x000036c96818fb4e}, {0x000d76faf0aa49ac,0x000c17dc5923cdc1,0x000780973c293b0a,0x0007d05101c6532d,0x000094adf9339dbb}},
    {{0x00046923a1ecf415,0x000a0f9ea7f71cc9,0x0005779649d48858,0x0002e729830f9f5a,0x0000a791f0968938}, {0x000b5938d2d48da3,0x000e4a63cc188eb4,0x000352d09bbdb586,0x00085e41ea2ca55d,0x0000adb9408e7ccc}},
    {{0x0000274ff274c238,0x000cf4ed75e4ccfb,0x000a58613ca6532f,0x0002f08974ef32d2,0x00009439f94f5580}, {0x000e9bd5e20f70f3,0x0008a3a320b0c62e,0x0009802b6b371846,0x000eb1e8d6efb074,0x0000fa8cacacc87a}},
    {{0x0007eae23823fcbb,0x0007a6db12378b1f,0x0005b04d466a2702,0x00074dc0e7967d3f,0x0000380c34854b55}, {0x0003c2ba3855dc42,0x00079c231fffe07b,0x000441be0c2f630c,0x000d9ac7ff5f1f15,0x000079fc2752ae5b}},
    {{0x000d5c7dfb3b7db6,0x000f2ca2b44387bf,0x000dd902aca2989f,0x000944ef359e06f4,0x000056de67cc5e30}, {0x000a7f7dc035890b,0x000b9b3ae32060de,0x000a3a327bb2950a,0x000ad059416d8521,0x00005f50358a117c}},
    {{0x0004d697d518207c,0x0008e8767b105e78,0x00004f1169c01bf5,0x00094aab5136a0ca,0x00007aff0662c2f3}, {0x0008afdcb5efc86f,0x000e9d607a6dc3be,0x0006fbaec814892d,0x000876bc381a1cec,0x0000804cfbddb73e}},
    {{0x000450c84a71f470,0x0001720cbb4694c3,0x00056165c8b36095,0x0003d3e5828b276c,0x000045bbc6744164}, {0x00051eb64e2708b8,0x000f53a1d23ebe35,0x000cf38009d06145,0x00098675fca31411,0x00002fe56c9b4d77}},
    {{0x00089e8111b8d201,0x00028297bce0d27e,0x0006a7f74f80e76c,0x000d806d8e7591d1,0x00003296fccf5a57}, {0x000b45c6234aea5e,0x0006dbb033b176cc,0x00001216b62e1303,0x00059592a07ef8c3,0x00008ded78bdb4a6}},
    {{0x000ba2653b58b0d9,0x000642b1c2d703cd,0x0000554cb792e88c,0x000b255ed4d6bdaf,0x00007f42217534e2}, {0x000de0e9cf5e143c,0x000f7f941fa77e41,0x000e9891ce2c2bc0,0x000551a51e978228,0x0000c49845f6fd9d}},
    {{0x000072da6b911236,0x000b00c92cb9f1c0,0x00011381534f49ec,0x000547bce7c215c9,0x0000dae67dc8e0ed}, {0x0001fe5736a8717c,0x0003fdb486b086b4,0x0005017a01d7b53a,0x000770705d0f3b3b,0x0000be31d50dc547}},
    {{0x00031863932c2b1f,0x0009f501ea21d51e,0x0007b61c6b454bba,0x0007c33cb217df73,0x0000437c6550aee4}, {0x00044ddc161b29fc,0x000c0745a7be39af,0x0008b4e070c24b6d,0x0009ad9f92882f93,0x000012fd81676997}},
    {{0x00027b5c52289a6d,0x00032826de7fbaeb,0x00017117cc11f3cc,0x00032957907378e9,0x000000bca115722b}, {0x000ac722f5f70b15,0x000c503d941e10b4,0x00062a5c2c8da21e,0x000534a9a3154dff,0x000008a1f7b230d8}},
    {{0x0003ceff9e7ddb51,0x000d455c86afb70d,0x0007400b6fcc1c34,0x00025964e9b9b522,0x0000c5cc14c5bb83}, {0x000dab9215029d5f,0x00095e492977ca58,0x000c4a20aa8d4a22,0x00079b19ad26e547,0x0000d91ae79427ea}},
    {{0x000785990e90367d,0x000a07e301b6cf61,0x000f636872d8e93b,0x000ab534875194e9,0x00009e9353e6c1d6}, {0x0003bbdf1baa0db0,0x000c20a4cb66f8ea,0x000ab37b0f01de77,0x00087161e429924e,0x00006efdcdf4befb}},
    {{0x000058743128a14e,0x000e066c3cd7d9ca,0x000e7e113a4a62ae,0x0000fbffb51b4a5f,0x0000cea959c32023}, {0x000a40cdef43eec5,0x000504a425d60020,0x000bb9d80185d21f,0x000572b5f2b10cbf,0x0000666c56168409}},
    {{0x0000890f3b3930eb,0x0001779057c83ef0,0x0005d2430da067a2,0x000527201bd76b42,0x00007acf20f1cd5e}, {0x000b427b09507e58,0x0007d0ae9fe8ebe9,0x0001249697373a3b,0x00059d9893406aaa,0x0000e193839ab695}},
    {{0x0003e416acc4f41a,0x000c0e4846f77700,0x0002367dc52fe292,0x0003b7ea2b9fb2b4,0x00004b818d575942}, {0x0001acd23a6740da,0x0002e5fd8bd4aaaa,0x000dbddefe835656,0x000f8fa01421ea02,0x00000ea7a8551c0e}},
    {{0x0004fb87bb00fd80,0x00047858e175eccf,0x00085edcf225c4cf,0x000c38fd395e90d8,0x0000c586da7163c3}, {0x000add010694ccaa,0x000a11f48044f949,0x0005c948f8de7c64,0x0009280114c685fa,0x0000715d4a32473d}},
    {{0x000e9f8ae08c8338,0x000c24ac457f9136,0x0007263471950b1c,0x000630b176b52349,0x0000e8f83579b684}, {0x000f9d951a40fda3,0x00089ef984f41fe3,0x000cddfe9a94991d,0x0002c27fae887b02,0x0000f0c63c32ebc6}},
    {{0x0008af107ba4d8d5,0x0003fbb10a2c242d,0x000f5b66318b0abf,0x000ce7ec492bfd61,0x00000fb5641a0bfd}, {0x0004113b1af6e684,0x0004855508208921,0x00033ccaf19c703d,0x000f8a48d57f4293,0x0000d1b2b012f3aa}},
    {{0x0007bfe9a941e18d,0x00055afc95f9e3ce,0x000005028fe66b94,0x000660d24af86ca7,0x0000eaa16abe3583}, {0x00042b18956071d8,0x00069c5ee733a2e0,0x000c62790d044917,0x000243845bb68654,0x00003a6cb05a0b5e}},
    {{0x00023c0963370038,0x0004f22524f47160,0x0002b7ff5d5eaddf,0x0008db0d442eb80f,0x0000556e77aff7df}, {0x00075e94c9c29a9e,0x000f494e0b218d01,0x000e6d2ba70c6541,0x000cd9f24ffb8b01,0x0000c6ad519d7d87}},
    {{0x0006285b576c16f8,0x0001de9045f059de,0x00073148979af3b5,0x0001d1be76385156,0x0000309c88e12487}, {0x000c2eaef778ff77,0x0009e31d2d017dc4,0x000396fd24eca05e,0x000f6feb4f3a3681,0x0000a6b0a015343c}},
    {{0x000eb84a8ff46d92,0x000e9fb21b2cd2a3,0x0007ea66290a8efa,0x000bf97c2fe9112a,0x0000c3722457ee2b}, {0x0004b94de41e2c1a,0x00070bb0903edd96,0x00012b5c31d350a5,0x000a101dae61431c,0x000045a6d6340610}},
    {{0x0004e955e16f4b09,0x00069c988f51727f,0x0004df57c7386200,0x000bdbe4bbb1fa5e,0x000074b4ca3ca24e}, {0x000dcfef41e02f97,0x000d622895da0cf7,0x000400bcaaaab9ed,0x000e8d05fbb139e2,0x00009606bc9991cf}},
    {{0x00007c5d049d81b1,0x000af8afecbf4e38,0x0009913b9af5ff22,0x0007bf2c6b5e2220,0x0000094dcf820643}, {0x000323f6bb2b4620,0x0005b4b00c0dd155,0x00004087e0e046ba,0x000c8dca3773450b,0x0000a3ee21010695}},
    {{0x000e23bf4f40ccea,0x000d69f16f378bb4,0x00081b75cffb5728,0x0001f674fcd6adee,0x0000975281c93b18}, {0x0001fa9b52577c5b,0x0000ddc2d2be26f4,0x0001deac33380425,0x0005e5008eaa09d5,0x0000fdd6b2fd7884}},
    {{0x0005aeef4710b606,0x0009620131b1a6ac,0x000ed6b51ad3a398,0x0001f7326c04601c,0x00004fed7c15b6f3}, {0x00051ae4e75e2291,0x000b2b77e46a8eb4,0x00024864f5396c6b,0x000a307fe44bd15a,0x0000fddf9a7fb162}},
    {{0x00004463e73b8ec4,0x000f55cec5c6d935,0x000affcd58b06c2e,0x00044e00ad788e57,0x0000872bf18a0fd9}, {0x0008d14e5d71e574,0x000d2c3030bc88b1,0x0005dddd1ce58ea7,0x00057d1f9dc7c5a3,0x00004d1818d515b6}},
    {{0x000ddb8bf4b54748,0x00023305f0daf6ed,0x00052038139d4af5,0x000efb7d652772de,0x0000069ae58d16c6}, {0x000bf73dfb68fd92,0x0003fde5dff8e66d,0x0005f967c0e4a7d2,0x00069cea388c3b52,0x000000d338cf626d}},
    {{0x00045c714519e589,0x000e0913096476e5,0x0000d02d7cf59be2,0x0008386476786752,0x0000a99633c4e597}, {0x0000911b961f3964,0x000589bdb3f722c1,0x00040b0284c204f6,0x000310c471f04659,0x0000b8f29400b771}},
    {{0x0007580908012844,0x0006c059281b1ac5,0x0001c35df7e30017,0x000950b68a678586,0x0000423082ebc843}, {0x0003aee90a09598e,0x000a9913987d1e31,0x0002a51b3792cb2b,0x000d1a18355dcf9d,0x00002891458b1327}},
    {{0x00059e6c45add90c,0x00035578dc6b43e3,0x0002ce37e6ba1e8c,0x0002e4a6505c2877,0x0000b821b953f4ae}, {0x00022256fceb3969,0x000fbf38ecb4e108,0x000eef42aaee7a3b,0x00075dab0d35094d,0x000025f891427625}},
    {{0x000bb97d0edfa1ce,0x000e46b5d78101cf,0x00056ac5655ba12e,0x0004dc4b371feede,0x0000daa9c221667c}, {0x000b374aafd9ed41,0x000ac3a4679a8a4c,0x00000de55fba1126,0x000b1bafaeade880,0x00003e746cdf818e}},
    {{0x000990ec0f88d5f8,0x000288b4c7c62b24,0x00084d7118dfe4c9,0x0009fca983eed9ba,0x0000a1b21a93ca27}, {0x0008872895a60682,0x000024e18c538587,0x000ca73ba0accfc1,0x00000837dd0e2487,0x00008513be562083}},
    {{0x00003f947b6ea260,0x0001bb7a4729c734,0x00032750426849a0,0x0004026b72cf4cd4,0x0000c0fffc1c5d6f}, {0x00085c96173719aa,0x000c05910bfce43c,0x000acef18e018793,0x00032e0f069d5faa,0x00009fae2afd5c69}},
    {{0x000acf01ed8bd7cd,0x0000263477c55128,0x00078d6112535697,0x000b9055421fe02d,0x0000f1a20e6ea246}, {0x0005ae7d073d4a89,0x000bd63778b84373,0x000bc7a37abb5f3e,0x00009b5483301a33,0x000036ae26c63a8e}},
    {{0x000061c767eff576,0x000dd9ea79a1ccc2,0x0003437b2eba650c,0x000cfcac1b11574d,0x0000cfb31a0d11b8}, {0x00054f89f42bfdbc,0x000cc2703661fe7c,0x00070d58a8d1569e,0x000bba5a9527776b,0x0000161cf8545e19}},
},
{
/* digit=24 [{1,2,3,..,}]*([2^168]*G)  */
    {{0x000c25e9f5170aa7,0x0001f8f5338bd76c,0x00040201a3c0073f,0x00012ffbf6fcc231,0x000009be87d49f50}, {0x000bfe953dc74903,0x0003d8653153dc6e,0x0000eb06e85facca,0x0003077c47d716a6,0x00009f6514c80bee}},
    {{0x0007b09654c48577,0x0004fdb0f5200d71,0x0004e6cb015e94bb,0x000f88dcf3519dc6,0x000059d275f2ebdb}, {0x000ec0fd11aeb819,0x000c8be9fb8ae833,0x0007d57ad2893bce,0x000e52f8ada66e74,0x00002d1bbca1a1e3}},
    {{0x000d4246631e6f4c,0x00052539fdfdb824,0x000b8f0507304674,0x00065e29c10ef5e6,0x00006b779bb7066a}, {0x0005a5380f5abd81,0x000523a56e993fe2,0x000c373f30122a40,0x000a4ff3a52697bc,0x0000de214925f8e6}},
    {{0x000a957eb8abd51b,0x0001bb0ab69abf50,0x000e7252ad43d460,0x000fe24207ecc4bb,0x0000964c4fe8348f}, {0x00091eb0668c06ef,0x00037f512c2d1c55,0x000cc3a429333eb0,0x00061923cd82147c,0x00008b93a9d6c59e}},
    {{0x000cc48773e35954,0x000e214b22340fa4,0x0007830d996f413a,0x000907b196a2bc70,0x000037ecd06850c4}, {0x00039bfe3ef35b95,0x000b82f5d6ce3ace,0x000d52cc302fad75,0x000d0d41e6e89210,0x000090aa6d71bfce}},
    {{0x000dc3c8f4aa5889,0x0003a50cbedadb5e,0x0007a52111e6d592,0x000a80177e437ee8,0x0000df8d7c441860}, {0x000eda8cf92436a5,0x000296bc8560bcf4,0x0009734d2066ad91,0x000059756ccdd882,0x000043cd11c08558}},
    {{0x000077ab273751fb,0x000c255f1d1bdcb6,0x000d46eee885b68f,0x0006411656e793e5,0x0000bcc61e8b1ba0}, {0x0004299f88dfd877,0x00072838b3a069d4,0x00011a67cda79c15,0x00041b6a28140e4e,0x000038faae273c96}},
    {{0x000cc732728468c7,0x000bdfa9a3bd9569,0x000d743f442bfed7,0x0002dd74b6f74702,0x00001de0fb3c4843}, {0x000e7d2fa94e43b9,0x000e83587eed4ca6,0x00099758a506eec9,0x000192a4a5292aa3,0x000006038c3c85a0}},
    {{0x000e8448ca36b091,0x000724026db2dc96,0x000a6f0c367dc2bd,0x000865e5b7051140,0x00009f8943f82b64}, {0x0005ff5fc9a5ec8e,0x0007001fcd7a9b31,0x000237cd7ebe7ebb,0x00005c2a5148967d,0x0000e997301ffa6b}},
    {{0x0004c665b9eac65a,0x00052ba5a915a9f2,0x00066278cc6bdeae,0x000b249b5e33760c,0x0000ebc09e8ac7b1}, {0x000caea5a6199620,0x000be60abe7d7c0b,0x00088044342ec817,0x0000a54835970666,0x000050d8ef2ff279}},
    {{0x0006c27846f75d05,0x0002cbb8971b0591,0x000fef98918d6613,0x000d3bb003639aad,0x00002a37323294ad}, {0x0004bdefdbf09029,0x0000fea38bc50670,0x00075dd7401061a2,0x000972a86fb9b7f3,0x00002a9ef8a399aa}},
    {{0x0004bb6ac1207afa,0x000e9580f1b1a4df,0x0009301d506bb9e3,0x0003ddb25c740d34,0x000024a77e6b0e29}, {0x0009997ebbefc02a,0x0000f9bee7b2e05d,0x000c3f6c1d1e9c60,0x000930fe3607022d,0x0000b29cca36dccc}},
    {{0x000a13edfc3232c8,0x000071af81e3d653,0x00093d6ba80325a6,0x000faf2033e68207,0x00001c7c20a162eb}, {0x0003995532aaaf64,0x000c4aecfc68ed5a,0x00098196ea438ecb,0x000c5c5fff04de2b,0x0000069d497969cf}},
    {{0x00016cb6ab4f0071,0x0002ebe7c2a951b2,0x0001507db4c9e3b8,0x0000e1bf7e75c535,0x00006b09f4ba63d2}, {0x0005b11f97734d28,0x0006dc581c376458,0x000cec0864a46ba7,0x0001fc733dcc712f,0x0000aa53b9688ed5}},
    {{0x000da0620844de29,0x0008013f258339b4,0x00080097b1ef8c8a,0x000716541e0eaa04,0x0000c5dfd5748615}, {0x00091ec9a14f247b,0x000b9fd915415a11,0x00018caef9331112,0x00097f0fe5bf0968,0x0000636405ec0ca8}},
    {{0x000dd20ccee2cb48,0x000695b1e68483ba,0x00039267fb005c14,0x000991f285b3686f,0x0000596c8811740c}, {0x0000039d01b2c886,0x0000066b542dfb66,0x00090ad7b941b21f,0x000fb42690c453ab,0x00002b8741e90fa7}},
    {{0x000af8194dadc627,0x0001edf51bfe1834,0x0009bd348776705b,0x0001ad70ee1dce5c,0x0000b26f64d4ae19}, {0x000a67e9b9267406,0x000dbf7a60d3b5cb,0x000bbaec7f815e13,0x000b9534b3ab92f3,0x0000d60d991417fd}},
    {{0x000ce9cfb15625e8,0x000fc4db106913f8,0x000b2c9cd8cedab6,0x000a59e395243e6e,0x0000434f60bd1431}, {0x00012f01f634f2cd,0x000c40ae9ddbe0ed,0x000b866c6a73238f,0x00081e4ad4d13cf2,0x0000375a9d4fdb5d}},
    {{0x000cffc53160c73c,0x00007539809f73a4,0x0005b23b923b3241,0x000b5195c30c96c5,0x000094fdb86cfd44}, {0x0009dbb264a47a78,0x0004d93efb5e99fe,0x000e9a68933cc2c1,0x000ffe8e878bb037,0x0000f7d2e44d123a}},
    {{0x0007e32ebbba9682,0x000be1ca85ab0b5d,0x000c9697a03f4a69,0x0000a0e9870318d2,0x0000e8015aabeaf5}, {0x0008c0ba7e1dfd93,0x000f56bc29921b79,0x0001d1608f5ae798,0x0000ee85a0922135,0x00007f26d995d2fb}},
    {{0x00089e5230cc1b43,0x000be3c41cfda991,0x000292450b3d3c1d,0x000dd89d5989e496,0x0000cfc1ecde9524}, {0x000d6a36c7493761,0x00031f1678e9dfa7,0x000a563232985073,0x000479ad7e48450c,0x0000ac60c6fc5646}},
    {{0x000e435ab0cf52fb,0x000756ea25b6a16d,0x000034b17c2186b4,0x0001f2fc7036334a,0x0000bd1c9eafb0ed}, {0x0004b6d249b21b42,0x000c8600552f96ed,0x000bfc49b2fc4e76,0x000ab86179a640ee,0x0000742b6f2cd85f}},
    {{0x000836e93b510939,0x00034ecdc5de9094,0x000cfec954c59e8e,0x000659f87fcc53cf,0x0000a4568a7a9057}, {0x000c03e5826f6ff5,0x0002f83faeae31ed,0x000b8b111d7a6557,0x0001ce6cb4bee145,0x0000e343b357add3}},
    {{0x0007124356c03ca5,0x0005e9256c013890,0x0003b390b3f0ccfa,0x00096e541ed7e668,0x00005b7692759858}, {0x000db7904f1906ec,0x0009f798fee14430,0x000c762aa8e0adfd,0x0009c408beb39255,0x000089f982ccad3d}},
    {{0x00079b689457b765,0x000fea0f5b956815,0x0003aae2e20e7df7,0x00036deeee3b323c,0x0000b98cee329d35}, {0x000cece61a5f45d6,0x00042e78c9cbc2e3,0x000ecf95735d7b06,0x00009e205e0aa2ca,0x0000e5839c503b44}},
    {{0x0008f9208fcdecb3,0x00061b66dbf41f69,0x000a1af91975c299,0x000495d23b37428d,0x00003d9b8eb27748}, {0x000c26ec038dd208,0x0007733cdf67d14c,0x000f975e452454ca,0x000c01fabd49971b,0x0000982b9f5186b5}},
    {{0x00082d71ed519447,0x000dd9063242dd6c,0x00086537a94dbe4e,0x0007e5159224fc27,0x000080fe5639583f}, {0x000c13fce88adb1a,0x000bc57f2f24f1ae,0x000fa63cf0fdf9e6,0x000b6d90fd8fafda,0x000044733d44e643}},
    {{0x0001fe8821de4787,0x000ad971ee6fb14a,0x000eeebab19b43ff,0x000fd6931813e718,0x0000f9d90866ab81}, {0x000ab8c25b81d6ec,0x00085bd040950086,0x000b02351a4be98f,0x000418cdeb6e4418,0x0000e57c7e8aa473}},
    {{0x00026d051d0b0c81,0x000c03f43bb4e055,0x000108d9671ce09f,0x0001db9508e74a7b,0x00001f1327927748}, {0x000b0010c84e7c59,0x000517a0dad7005a,0x000eefc16dacdfff,0x0009472e6bfbd9e3,0x0000daaed22249a2}},
    {{0x00068df75e5be29d,0x000385fff9a99479,0x000bb571140db0d9,0x00046304b0b4cfd7,0x00001addb26ae24b}, {0x000581856fb91014,0x0001696d3fdf03ca,0x0009d9e027eb9076,0x0002876031e89681,0x00003e9950d59c6e}},
    {{0x0008caae157977b0,0x000674349dcf9d6a,0x000b699a60e8b54c,0x00076b8f3c4ad763,0x00005cc559c43b1b}, {0x000211ff4c8d557b,0x000e78905358fe5c,0x00083936f8309b2c,0x0004af64acf5051f,0x0000481e7e0c6fec}},
    {{0x00053fe33c602daf,0x0004cf85cb7ed0f4,0x000d1adf62c3095c,0x0002834573d068b4,0x00002d0fd0243c96}, {0x000b5a83acc5f984,0x000951b8242871ac,0x00042785559a72b1,0x000383e0b9e6f513,0x0000eef0713ace69}},
    {{0x0001642514077632,0x000b7843397d07f7,0x0004342ab2e8b92a,0x000548eb3dea716a,0x0000fd46ebf66d9f}, {0x000108bf0b8a44a2,0x000444151a9a68e5,0x0006fbd93700306f,0x000a840cbdf94002,0x0000c577ee629894}},
    {{0x0000bca8d5a234cb,0x0002ada976341eed,0x0000d8f5b9ffe4f4,0x000614ea32e31bba,0x00009640fc08e2ba}, {0x000bd3091a3cc172,0x000dd6813f60e5d6,0x0000955ef6102e8d,0x000c318e716035a8,0x00007083188700d7}},
    {{0x00015232afdb4a80,0x0002497d796b320f,0x000fcb99991c4603,0x0008a8e8ee7f7f71,0x000086a97ca03731}, {0x0008e6620f196d18,0x000bfb677ecebb7a,0x00084316a2c3361d,0x00098a5a92e2000f,0x0000ad5b02777783}},
    {{0x000dd0efcada3ed5,0x000bc43a9054d4be,0x000db0e54123501a,0x000e0f955966efef,0x0000e31aa4eeecf5}, {0x00049cefca5df228,0x0001b845465e6d45,0x000595d6a9287939,0x0005be1879d8875b,0x000050e3ad18c18e}},
    {{0x0000ae732271801c,0x0005b803d1ed6ccd,0x000be65e61856a37,0x0006cdb05d43079f,0x0000757438954a07}, {0x000ff113986411c7,0x00005e8c6b438f05,0x00082dcb49c55eac,0x00095ff8773437d6,0x0000797c7879b91a}},
    {{0x000418f19e79e5c2,0x000898e184288dfc,0x000811bdb644c310,0x00017641a8142536,0x0000ec41eefe56df}, {0x00005b4e27fb6bc1,0x000f8e054fba1edc,0x00089e0e1650e5e9,0x00095692ab6f4529,0x0000fbcc505276d3}},
    {{0x000281ca2dfe6dc8,0x000110de712c653e,0x000ee928158404b6,0x000cf6d7e6105cd0,0x0000d388140e6953}, {0x000ed39f0617f89f,0x00067a61a5286d8c,0x0000ab74f3f1e213,0x00006e8ba2227632,0x00002cba3b64a144}},
    {{0x00019bb3ef88b573,0x0009c9454c264310,0x000e75b084b05970,0x00090f0042faa6a0,0x0000c42b966c283b}, {0x00069924227e2345,0x00081e764b1d0c29,0x00085621fbc826d9,0x0005ac4deb50a990,0x00003a0c83012d01}},
    {{0x000eedb8289fe19d,0x000455d8703a0f39,0x00069318dd303312,0x000f22bc207eb1d1,0x00009a1b36be080e}, {0x000a07cf89baf3ea,0x000d625b41a9e3cb,0x000bfa4f0e365656,0x000ce1cc88025770,0x000065eacea3656e}},
    {{0x0005c19ef45d6b91,0x0003ff6ee7a1c188,0x00095b614626c796,0x00008cdf716625be,0x0000905d59e52e68}, {0x000e8445d0e57d94,0x00010289d5e86e38,0x000258e2d5292144,0x000960edda6c726d,0x000078f149d15866}},
    {{0x0003b373eeb3be5d,0x000008cdfd007c91,0x00020d539c7e74db,0x000a226c08d0199f,0x0000f14535325914}, {0x000f5b02288d3d99,0x000c450de2506ea7,0x000a273bce6ad41d,0x000bdbc8e36df7c0,0x00001ad366534f40}},
    {{0x000602ba827d0dcb,0x00091adbf560c3f3,0x00013a340f90f764,0x00093eb8c55e59f6,0x000080ec3bdb9d66}, {0x000fa139bc659726,0x000f737f930cd576,0x00052013011430c2,0x0003652c9fa7479f,0x00006624def0a0e1}},
    {{0x0009772769b19129,0x0009d1ada7cf07e3,0x000c9a259ebf722e,0x000cc4241ca31714,0x0000b844dffaaf8c}, {0x000a55fb9723c092,0x000761a9a645934e,0x0000f493a79cd872,0x000410ce7fa8a9c6,0x0000992cbc50218e}},
    {{0x0009ec972907a41a,0x0003f2fe9e468bbf,0x000807c9a4ff51da,0x0000ea9411ccb7b4,0x0000798a299aa8f4}, {0x000bb39dfa6de2ba,0x000d102a830388a3,0x0009be6602815a52,0x00097420a96dc3e2,0x0000698523b7ae24}},
    {{0x000e5e2695331daf,0x000aa511993e978f,0x000890d5eea027e9,0x000380801eac0409,0x0000079a353c8f13}, {0x000d2aab807ac122,0x0003153b7b007d3e,0x000c8146f9dc100f,0x000de36f0b42a3f9,0x0000837fb01d7d39}},
    {{0x000bad9ce4ff7c82,0x0001f47732d9a89b,0x000ee5faee22e6f7,0x000d5ea181969613,0x0000e30cc88547dd}, {0x000c36cde1dae9e9,0x0006bc67c475249f,0x000dfb408d12c773,0x0000395cb3b91c3c,0x0000d1c1cf946d61}},
    {{0x00040f67eafffb16,0x000b5075d48b2a76,0x0002c7c72f3112e3,0x000256a2a08a64cb,0x00007bb6c8e3ab45}, {0x000cdb3da1c5cb8b,0x0003c150935de71c,0x00071dd0d002611f,0x0001db99d4d16d56,0x000038a095f1bbf4}},
    {{0x000d0fa367f54448,0x0003146d9fd69644,0x00003ace9de42457,0x000b4368540bef28,0x00007344421ec2ec}, {0x00080473886c71dd,0x0002dbd4c0da1c7f,0x000e1b1b8096a337,0x000b47b29c3663ce,0x00009b850a4fe4c5}},
    {{0x000e92e2711f6c64,0x000b96297ee64980,0x0000a0287ce98611,0x000f59621aee88a6,0x00003a13d7736ee6}, {0x00042a0c754f85e6,0x000e90b3dd1a56d1,0x000bc903c6539c68,0x000a0c394962bd7b,0x00000c0dac7c0d84}},
    {{0x00006ed5888a2297,0x000751181c6bd971,0x00001fa29f66bddf,0x0003dc751ce5d2c6,0x000030a703678c28}, {0x0001544a52f8cedf,0x000be7386c005d73,0x000b3a1020b312a8,0x000964a3e7d61e3b,0x0000cd0a1f2cc51e}},
    {{0x000bbb7730637d22,0x000c0ee69ffebac1,0x000752c78cf96785,0x0003758cc83733f2,0x0000a885c698de85}, {0x00081b51bc9dd850,0x000b4da7bf040293,0x00006ffb160bfa60,0x0008090cb031432f,0x0000a5961de3acd8}},
    {{0x000544e3c5d8a4f3,0x000d695380f1fb71,0x0001dd2550cdfc3a,0x00008c41c6df5c9a,0x000015751273680e}, {0x000829ee56b6eed1,0x0008736e5950fa14,0x00084ee6a21b66ec,0x00068cf12d853922,0x0000aacb8733b362}},
    {{0x000744efd56dcf02,0x000d5ea49439ff91,0x000ae04d42849b3c,0x0006a13b6e556b78,0x000068bec5e02e90}, {0x000aa440bca4d3c9,0x00061e186837ca14,0x000a14da69cfee5a,0x000e96cde0f100bd,0x0000a67e8a765191}},
    {{0x000e0aa93f9d4461,0x0008116ba5c9f703,0x000eec78f1b1b2fe,0x00027eda47d1be72,0x0000185448619cd4}, {0x0002b1e0e6c02d92,0x0005c61712615570,0x0007a197ef949c1d,0x000c916bf10a070e,0x0000fd96d47b2de6}},
    {{0x000688afda1eadac,0x0005b4195e38ca30,0x000eef15dd8a8720,0x00033df5b11f7a9b,0x00009f2a47d71132}, {0x00023ac090f6dd40,0x0002214691c3f9a8,0x0005cbd3a69343c1,0x00055aad1e8ad7b1,0x000084d228267ea4}},
    {{0x00086fe50c54cbcb,0x000f653d0a7793ff,0x000c8c956c1fb89e,0x000283d2e92f9f9a,0x0000056a14c921b1}, {0x00089485a04b6501,0x00077ea06a75ec6e,0x000a3c4a6d6534de,0x0002a89696e721dd,0x00007fda5cefe58f}},
    {{0x000c5318d0e40d7e,0x000f6a538eee8279,0x0004e48a6eb9f6e1,0x000da4bcb94b8cff,0x0000c4899eed700f}, {0x0002a357b45aee63,0x00099a0087e74e39,0x0001e767f55766e7,0x0000e932c5c64a26,0x00002c5fc6626169}},
    {{0x000c2d890c562791,0x0001c4070cc2c8dd,0x00054def1b70c1f0,0x000d5c30fdf7b1ee,0x0000dbfe11c8f13f}, {0x00065c130ac48a93,0x0003ce26b496f369,0x000fd989f121c642,0x00072c727a8a1055,0x00003a348bb24777}},
    {{0x000dcd25a190461a,0x000a106657730c58,0x000f65f30110341f,0x00052183383995bd,0x0000425c381d25fe}, {0x0004adfd6e549001,0x00041290a9292ea2,0x000b76df784221ca,0x0001819281717876,0x00003c6286226714}},
    {{0x000956ce903181f9,0x000756047fd2cff5,0x00082b850c30f551,0x000016a192cb7cc1,0x0000164246ae1ae0}, {0x000fc004f248d82d,0x000270a5afc4b0e4,0x000bbe52be2cd809,0x000bcc98f97e693a,0x000059d87c21fa20}},
    {{0x00041646e13ab52e,0x00054c259320b618,0x0000a293fa0cd0bf,0x00055b81537d75a9,0x000051de543bb104}, {0x00001de5fec9a0eb,0x000afab3f9905655,0x000b5b3263792733,0x0000f68755608613,0x00000d4e6f054c47}},
    {{0x000710267c542a45,0x00079aa6faea8981,0x000ab176cd6156ab,0x000dab6a3f451e57,0x0000377dae7b0730}, {0x00017a92f3c84900,0x0003ce118d488c05,0x00076348955e451d,0x0001227de12fc278,0x0000a2604acecd69}},
},
{
/* digit=25 [{1,2,3,..,}]*([2^175]*G)  */
    {{0x0000f07eb83bd033,0x000c42728bc15e5b,0x0007503622eb0cfa,0x000572855689e6d5,0x0000ffe17a0fa82e}, {0x000666a2a34814bf,0x000cdc30d17ce550,0x0008d4ebe4148a9a,0x000ee9bc0fe3fc26,0x0000237a4fb4ebee}},
    {{0x0001c57cbb6521da,0x0007e013ad088fb8,0x000e523b034683c9,0x0003fd973cba032f,0x0000bdd5593a2694}, {0x0002b0ee317fe3b8,0x000b0cf3aa3671bd,0x00053dd74d87c697,0x000950259f03a8c0,0x0000bd48cf81120b}},
    {{0x000c2d85f00903b9,0x00023d280c52e198,0x00003f2253a05cf2,0x000053ca5bce1e21,0x000095953ca7afa1}, {0x0007eaf045a97253,0x000b61ef1e17ab18,0x0001cc69a1ea96f0,0x000d886265e99974,0x00009d16dd8088db}},
    {{0x000070d24ea591be,0x000ddb1395a861ea,0x000c708bf3a531a9,0x00045cf5cab52096,0x0000f8dd80a0756c}, {0x00018008dc9efd3b,0x0008df4b56e64d3e,0x00050e16e3f81f4e,0x0005b29b73276fb7,0x00003164beeb41b9}},
    {{0x0008e3a4e414233d,0x0007c6b84bc799a9,0x000bf981390050aa,0x0001b5245d5f66b0,0x00008ade8eaa35b9}, {0x000dd15f5c095ff5,0x000754ae9f8d06a9,0x0001d477cbbf72a4,0x00022cbd33b02ff2,0x0000807cdb0901cb}},
    {{0x000ee8912650bd3e,0x00053f782a39217e,0x000618997e9887ca,0x00025a0184c0779b,0x0000f717203cdc98}, {0x0002d521bdde7363,0x000c28fb3a2da14f,0x00001a0c2ef900e1,0x000e1af7a79f2377,0x0000b5d67fcc63cb}},
    {{0x0002eb021df78d51,0x000b081c9f307643,0x0006e5c92268a6e3,0x000e68d0b6f1d616,0x0000780b514a1250}, {0x000363c9b4b5ca38,0x000c14058ae8d88f,0x000abcfae84c017a,0x00001c021a267bf1,0x0000352d6c69a7e8}},
    {{0x0000ce578ee0421a,0x000ce61cdee800a5,0x00088829e74b485e,0x0004993b7a9f52f5,0x000021992713481a}, {0x000d96b4c61e5ad5,0x000c4dfe48a2ed65,0x0001425d4368e4fb,0x00016f34820cdfc5,0x0000a61d206e3b36}},
    {{0x000e3ec504534afc,0x00004ec7955c88a4,0x00050fed6537707e,0x000f6d10700e71b5,0x00000877ca57aa69}, {0x0002364134c7dfdb,0x0005855b263b3933,0x000dd5682153885c,0x000150675240b632,0x00005d29c6405791}},
    {{0x000b0d18666db72a,0x000f2d06582741e7,0x0001793ca3db5107,0x00077db29e38bab0,0x000084e11850de3a}, {0x000c8c2f41c8d79b,0x000501d15f801de0,0x000e2fa4edb21191,0x00055b0e59608ebc,0x0000e2af30fb06fa}},
    {{0x000365bea852e986,0x00023d23f18d3454,0x0002a0a0c61de9a0,0x000db69a0b114ba2,0x00001a64b5ee88ce}, {0x0007873ef9d06036,0x000df11ed48a5e35,0x00071a5b115f7948,0x00021de1c334adcb,0x0000265cf2f68415}},
    {{0x000cad85cb2c08f1,0x00013050f5bebd73,0x000c923a2320bf0c,0x000fbc656f4c2f1f,0x0000b53d151eb2a0}, {0x000b47255d36eef0,0x000a7b1171c22301,0x000724d1552a8c41,0x0001e7407c769b93,0x0000a4c8f8e5501e}},
    {{0x000ea34e3d43a020,0x000a28fe86195962,0x00015f931be0edab,0x000b1a5b51a1a2e1,0x00008f3b12193b36}, {0x000f4bbef5440b0a,0x000163cb97e2f791,0x0009344115a98d55,0x00030bfa810b1d2c,0x00009ac76ae97e64}},
    {{0x000a89f24dbe5bbf,0x00027581706f6f1e,0x000b2064b8a59052,0x000c28e5a7101b9d,0x00005819dae01ddd}, {0x0008e03d02d3f29a,0x000fbf2a1752e0db,0x000e534102f0d5bc,0x00036cd64e0d1f26,0x0000e99c7c9e4cab}},
    {{0x000adc1b52d2c43f,0x00033f467ac3b66e,0x000ff7454896c1f4,0x0005b725476ddb98,0x000076bf8f2486b1}, {0x000fd017adb3aa43,0x000cb44c8927398a,0x00058f3e9553da51,0x0009000230e271cb,0x0000539e7977c345}},
    {{0x000fad0b915022c3,0x0002106d7a523ebc,0x000335d2c80fc99c,0x000c9cb1584ffa37,0x0000e03e0f554705}, {0x00006adb6d93260c,0x00003a928e28cd3a,0x000cb2640092877a,0x0007e59d702481ee,0x000096acaf7a1b0d}},
    {{0x00043348d46add3e,0x00017b9f7c368909,0x000a1f1374adebe3,0x000cf21b998ac50b,0x00006e1a007a85e5}, {0x000fc1c2509d7d1e,0x0004e813db920aac,0x00064a506bbbc35e,0x0005c8293e917e2c,0x0000a0658874c8bf}},
    {{0x0003c2cd968d2bbe,0x000cd4c6eb2327bc,0x000bc548ced0417b,0x000e8d485d4af2f9,0x00004dacd98b166f}, {0x000b9e5cc5ded1dc,0x000ae2a98ba23580,0x000492a536faaf10,0x000e70e356736920,0x0000e510a11666b8}},
    {{0x000f3f1dc1e8b2dc,0x00066500e64a04a3,0x00036c76bbd3bb86,0x0008bbbf79e266ec,0x000021afeb04482e}, {0x00077f89864546f7,0x000725833277b7ee,0x000c09d42161b114,0x0003b6320fd7a5fb,0x00008b814a9efdb6}},
    {{0x000a001441991ea3,0x000ddf08d40e88f7,0x000233055e0b07ef,0x0001ccea6feaab02,0x0000bc15f20a5108}, {0x00095e60f38e9c6b,0x000c2ae91436b227,0x000f0513590543c5,0x000e03be4e76138c,0x00005328faf22271}},
    {{0x000a10d536481292,0x000410288d8eb4c5,0x00019c657d7affd4,0x0008693fb147884e,0x000050afa8840f2a}, {0x0004ae9998b069e2,0x000cb30712223137,0x000e91fd044e1f54,0x000424e7c6c23e5b,0x000007d112a47f0f}},
    {{0x0000f60ce2868df5,0x00049dc327eeea11,0x00046812a36db546,0x00080d91bf0f5a1e,0x000048f22bd3d877}, {0x000dfe5037a0b7e2,0x0007ecb51339b1cb,0x00071e2f0fd2d522,0x0001f8676a49b5a4,0x0000c769f1a6e725}},
    {{0x0002bf88dc2f0a70,0x000a3e68dc50f43a,0x0006cb84e98ae70a,0x000c6a2dab22067b,0x0000b91bfae77104}, {0x000ca4c4e1a302aa,0x0007c10be63cbe8f,0x000d88a1c0a2bd81,0x0005edd219abbb19,0x000010f5e51606e8}},
    {{0x000a2ad1f09fbd80,0x000db1f885fd8bea,0x0004e03fbf5c1af0,0x000c71abe93ec293,0x000068d6944c156d}, {0x0008f5795e2c39d0,0x0007de2a058c1fb2,0x000f391b7a363cec,0x000c511d56812b80,0x0000f1912e543c50}},
    {{0x000fa1bea2fc7856,0x000facf2d79b50ca,0x000b4dc605ee792c,0x000e37949b168ca7,0x0000f9f755e580ab}, {0x000214f4f0dfe3d3,0x000cb8f668d68881,0x00035d50ad3e2ab5,0x000d53349af8b5fb,0x0000eaf332242029}},
    {{0x000b3c0c5daf0c95,0x0000abd9ca770b96,0x0007491231340717,0x000c014e3753afa8,0x0000c1c50ae93cc7}, {0x00019a912d2fa053,0x000518344b1ceaad,0x000ee6c426f62582,0x0001b96bc3e144fc,0x00001b86a8ec07a6}},
    {{0x000f7a88ba02f836,0x00073dda3e59c0b9,0x0009cccb19acdf4b,0x00089607ecb07e22,0x0000e179a7fe03f0}, {0x000d066aa749105e,0x000cc15f2c1af78e,0x00014bae07f26f5c,0x00089e31dede1a78,0x00007ba2b8802bf3}},
    {{0x0008fa37e8bbf903,0x0002caeac4c26d3b,0x00054f9cd941b0e0,0x000695d6897bed90,0x0000879936aa651b}, {0x000a4948166b0278,0x0006106510d0399a,0x0006d4927293dbad,0x000dc9d16600bdd4,0x00002fd5ac433045}},
    {{0x000ea7b9f63a3889,0x00052557fcca4d89,0x000f2529e5e6ada2,0x0008362a0cdc0208,0x00008c8b9774d48c}, {0x00017a89e8d0e96d,0x000e14b6920ed486,0x00029494b799f387,0x000de743c654d3c3,0x0000a2f31f9adfaf}},
    {{0x0007183488f904f9,0x000017bbed9c088a,0x000762e0db3b3f4c,0x000a3f18431c2c9e,0x0000d188af79e181}, {0x000747e667c0d1bd,0x000e968e2a6500ae,0x000769759bb4bffe,0x00055beab9f86803,0x0000262d46060ae5}},
    {{0x0000f4053aa9a78f,0x000f79c35e544089,0x000fd839d2c910e7,0x000055db8e7ca105,0x0000db97ad2b5831}, {0x000eaadbd3c4f7a6,0x00049ef7c107421b,0x000f045e1644c17b,0x0004119453602525,0x0000e5c41998aa2b}},
    {{0x000ae5b06add8234,0x000ece621122e9d0,0x0005aa6bbb8095fb,0x0004f8f151cbaa93,0x0000c30736f0d3f2}, {0x0004bb0b2c0934c3,0x0007af112376af19,0x00016cc005f81abf,0x0002b33e6640b099,0x000054837f425912}},
    {{0x00060e6aff8da2bf,0x0007b2b372a89876,0x0003629cb60a2cfb,0x00061c0c2676d696,0x0000a734b56f2086}, {0x00098761fa9a1967,0x000560b82b8f4fd4,0x000c50fbf8a331bb,0x00006ab7b7096885,0x0000ee75dde39230}},
    {{0x00076dffc96c21b4,0x00063017c3d1bee4,0x000d9abd38be81d2,0x000f32f709fcddee,0x0000acb956a0808a}, {0x000b9e25e66f3281,0x00033831c8a599f0,0x0007eb06721417f1,0x0005cd4833b0079e,0x0000493a266fb576}},
    {{0x0004baa2d5668523,0x00003689fc40b0ae,0x000279c28d2c7f3e,0x0005629534d2937e,0x000098a4d84f2ecf}, {0x00035f14cb929a91,0x00061f8963790393,0x00009e7b7b25a5d5,0x0001016ac69aab90,0x00003d893e043064}},
    {{0x0006b786a36bceb5,0x000f6c58efedb4f1,0x0004457a463ce9bd,0x000b72d69b1127cc,0x0000fe789e83b3a4}, {0x00017c51f7e29b87,0x0001531fdf820296,0x000f2588967ed30b,0x000ed5a3df57f4a1,0x0000ce6d4a94d6a8}},
    {{0x00021eb676b5af75,0x0006aeb5c3a18291,0x00043eaf051ebc58,0x0004ef8bd71c578c,0x000001fbd625ad3c}, {0x00032c1d4663f519,0x00045aeb159107de,0x0007a554a8e64c3b,0x000cc9cbc678ad96,0x000020a01fc96657}},
    {{0x000be89bb43950a1,0x0005817b762b4266,0x00047f7019afa059,0x0003ca4a2c7f75fd,0x00003dbf549fffe8}, {0x00097451ad446c62,0x00064f101758f41a,0x00094ed44c88f148,0x000c5d31f7dab03b,0x000007789b3fa42d}},
    {{0x000b763df689270c,0x000edece73483d7e,0x000aee476fae171e,0x0006c30996252a7b,0x000068c6d9b71408}, {0x000802d40be0a180,0x000279f7214afa5c,0x000a50baf4c90054,0x0006601236076d44,0x0000f1a4df9f611b}},
    {{0x000a1d871f3ad971,0x0001471f93998a18,0x0007cb6b4089cfe6,0x00046e2888680be6,0x0000a4a0b67496c8}, {0x00051504d9720c99,0x000b82f1dec98c6e,0x000bc6615e19ef35,0x000cbff674933ffd,0x000029e4752286b2}},
    {{0x00010cf8006801ed,0x000ff3f96b824680,0x000ece9035f8b7c1,0x0004370ed08d2e0f,0x00008e43d7f5270a}, {0x0007758e8c30cba1,0x000a4c5e382f556d,0x000374942bed58f8,0x000f7b4d390b896a,0x00003148cdc67c81}},
    {{0x0003a9cd5c44392f,0x000e47bdfe21ed29,0x000491c1481a25a7,0x0006fe1cd7dae300,0x0000b9d3868cc4ee}, {0x0002068ada03a6a0,0x0000340f5762442b,0x000e0b53a208f677,0x000762b2ee05976c,0x000047fee704c66e}},
    {{0x00045be28bb6cc47,0x000bf9a6e2427822,0x0006b0e18c349f9d,0x000d413cbad70f27,0x00005db7ba2cd50e}, {0x0006fa76a8688440,0x000f17cc272cd775,0x0000a9aacfd31874,0x00081d50e472af63,0x000031b1bf3d98d8}},
    {{0x0003b11d230fb125,0x0006dafeaf84ff7c,0x000c87a66c21c356,0x000c83a7fe395ccd,0x00009e0055334e3f}, {0x000b297d762bcd8f,0x0004090b1e777788,0x0005f7ff73f79031,0x000b978916e41f31,0x0000d6a86b093da1}},
    {{0x000049a7d1255d7e,0x0008c8b12a9250ae,0x000341efc83f0f58,0x000003e1e125c570,0x0000f75675c0a287}, {0x000daf8b1258cf93,0x000cabe2242a1697,0x000503d8cea55b42,0x0002e7bc47653393,0x000010c33e17e789}},
    {{0x00005ea79f286771,0x000e27569d6a75ce,0x00081e4e2f605135,0x000742a515ec1123,0x0000af60690f9618}, {0x000edaa92529d0d8,0x000dd00e97be79b0,0x0002108f6ae93abe,0x0000519721405467,0x0000ef5c7cd11264}},
    {{0x000d7e85074cf812,0x0000fdaef4fbe1a1,0x00029585e7cd8874,0x000bf4683db12a45,0x0000f263cdb933fd}, {0x0000daef9cecfd73,0x0002d1cb1ad9ff75,0x0001e2010333c1bd,0x000602f2eb13e6e4,0x00008c434479fa32}},
    {{0x000f364154e53c02,0x000b2c50b3e176ec,0x000b8ac60e89a87b,0x000d69c11fc58ebe,0x000070424c27f1ba}, {0x0003d753d21bb139,0x000b6450de0ee6cb,0x00061e4b1f84aa55,0x0003f32665545bec,0x000084a236952f13}},
    {{0x0003559faf384825,0x00038d591b30f3b7,0x00072436cb28e627,0x0002d24feb572f5d,0x0000a8b72daa2f39}, {0x0003eb59a42e3589,0x000e94348dc3c258,0x000373f8afa9d0e6,0x00065df154badfc5,0x0000c01d9c6026b4}},
    {{0x000a5d00987d7af1,0x00054d16fb7aa127,0x000a5390ebddde5e,0x000638bdd6eb95cc,0x0000ad6055b0a46b}, {0x000e6fcc176765e6,0x000a926d17614afd,0x0005b60ce8f86b23,0x000cb7cce2306fd5,0x00003641982b357a}},
    {{0x00025cfb6810afc0,0x0000d2ca6813e5c2,0x000d4b0af3ff9d91,0x00060ae0e7a3e4a7,0x0000f245dbc069b1}, {0x000feb26a5cb6ec8,0x000bccbcb43885f0,0x000e47433ac2cdbc,0x000d82e118d811be,0x0000f794b01a4d8c}},
    {{0x000b7da95b4aaf8b,0x000e80a2c2af911a,0x000a345252c2ffde,0x000120078e3c033d,0x000043c12ac705de}, {0x000a2b459a347a22,0x0008ec984c45ab7f,0x0004f78db43cb528,0x000713cad280f6bc,0x000082a8e65b4562}},
    {{0x0005a98aa0ade635,0x0007b2a62c54a937,0x00023803b526bfcf,0x000b028e8fa38d03,0x0000e116fb100b08}, {0x00099fca2c266e2a,0x000cb41473a5abfe,0x000cbd4a3edc82fc,0x000ee0a832b0f682,0x0000c6da25c35e5c}},
    {{0x00004550befd3bc3,0x000b40a480954444,0x00050861335df122,0x0002e8d27b00d3c2,0x0000e5cf22108602}, {0x00032b19ede4f65d,0x0005402e3b45b297,0x00081c377a4b3990,0x000db8602b61ae64,0x0000853d2136c902}},
    {{0x00041daa3fade2f3,0x000c4f5787b60696,0x0000017c50c733ce,0x000cae7f1ea7c369,0x0000822da6a5138f}, {0x000278eeafc2f192,0x000da7b7d5aa7a6f,0x00077a2da02fd70e,0x000a24eb85681571,0x00004c69d2e8b3fc}},
    {{0x00061ccef0bb0ac3,0x0005ae0f16b6abe3,0x0006987ba1d88953,0x0000e4764662ef0f,0x0000fed054617265}, {0x000889078fd300ed,0x000dc644c4935004,0x000723fc14e7aeb9,0x00001edc7f36fff0,0x00004b9f194f4d3c}},
    {{0x0002cce358b66aac,0x00016e2bf8e318a5,0x00084f0df71d65c7,0x000699f185f6f605,0x0000d06b9aba0d6f}, {0x0005205b7b70371e,0x0001c3cc258b70b1,0x00064ef797aab8d5,0x000ae313d81500be,0x000091b0d1e2d796}},
    {{0x000c14085cd77a2e,0x00055b024ee5e095,0x000a1a0b278a5dd8,0x0005b23d4b412cf3,0x0000f1bb25ca44f8}, {0x000da53ecc55a1cc,0x00040b943b5047b6,0x00089e5806f90cad,0x000403b58fa8ea96,0x00002429e57eaa6d}},
    {{0x000fdb4fc9660aab,0x000ae4b79d49d8f8,0x000e3da0cdf3ff94,0x00095a287b418943,0x00000220fb3bf163}, {0x000a22b7dbf3af75,0x00010e4436d28b1b,0x000a5068eb344ae3,0x0005e62736f5e1f3,0x0000f7041a241e82}},
    {{0x000ddbeb3f0ad80e,0x00075c157deb17ed,0x00083992e4d16850,0x00000290b495d7d2,0x0000c100310a5d3f}, {0x000f68ee053ebdad,0x000e0742709e626d,0x000d131a85412994,0x00030749a376ce4a,0x00006015a407e49b}},
    {{0x00032582654c7441,0x00053280089731ac,0x000bb5cd371832d1,0x0001aaba1ddd1d3b,0x0000ce419eac3358}, {0x0009570f5151ed5a,0x00076d6327900c1f,0x000c1968aa5e7f59,0x0006745c1da0190e,0x0000929c46f7b7b8}},
    {{0x000957b50de1fb7f,0x000cd8dfe690465c,0x000125b716eecbf0,0x0006b08cc2cd7fde,0x0000cd58f093a3bc}, {0x0007ffe391cfca39,0x0001ad8536a941f1,0x00047fec75582f2a,0x000ad3a9a7bfe386,0x0000e968cdb6aa35}},
    {{0x0003c22a58371af3,0x0009c11c7d557ef0,0x0007d54999e44d4f,0x000d7878f8030b46,0x00009bd72fb1023c}, {0x000507350d5a894e,0x0000975cf9c22941,0x0007ee69d55c81fa,0x000da33294738695,0x0000dcd116f20c82}},
    {{0x0003d73ce3e731f6,0x00067ef5c65f87ca,0x000cdad304e237bb,0x000b03dfef249e4c,0x0000d7ab5f93a8aa}, {0x000687e71c7835b9,0x000ada6bfddeaf3c,0x000b7e2419bf388b,0x0008a2c3f86d5779,0x0000dbf47353ff02}},
},
{
/* digit=26 [{1,2,3,..,}]*([2^182]*G)  */
    {{0x000d03b214a50ffc,0x000ef4d64a402d36,0x000aa27d487e7e1e,0x000960971f296c17,0x00001a46349f6f07}, {0x0006c65b2e7b77fc,0x000e7b3f579f668a,0x00003a0809d29fb8,0x0002f59cccc9b480,0x00008b96ae5ed56d}},
    {{0x0005623d2692dce7,0x000bb1439ee234b8,0x000abb782d3d06e6,0x000ad2f5b24c26bb,0x0000e1e5daf85aee}, {0x000f6b36e620b2be,0x000a6ea10ef984fc,0x000e9c789089a1c0,0x0008b74663659974,0x0000964db299747a}},
    {{0x0000e9e78a6de0fd,0x000e2abdcd0cfd27,0x00058ced92b387f3,0x000ff3a326731463,0x0000d2b37033bfd7}, {0x000a11f5037eb879,0x000c93128308bcfd,0x0002cecfc87b981c,0x000a5ce342d6130b,0x0000f944d511fb1c}},
    {{0x000f4a7a5b2673fb,0x0002ae68fae4404a,0x000f3366ba0604c7,0x0000b42cf803c9c0,0x0000ee8762def9c5}, {0x00068b0cc0c37ee0,0x0009620fc01bad69,0x00028d071cb3006d,0x000f8e637903ab4b,0x0000248af8b7ed90}},
    {{0x0004cdaba9bab8b8,0x000b4adf23c61405,0x000ea4e3112b10ca,0x000cff8f40c789d1,0x0000f3193286f762}, {0x000bc201e35954b8,0x0000e44d9cd0d7e3,0x0002dddc5389fd0d,0x000726e698571e6e,0x00003a64f0002bc3}},
    {{0x0007fb0822f35da0,0x000f09896ddacf82,0x00029979bd5bf27e,0x000381fe1269fc42,0x000052db83e4e95b}, {0x00050a861613e2cc,0x0001b06477bfb26e,0x000ecf598588df85,0x000b11c80fd01053,0x0000225a35dddd00}},
    {{0x00008399fa0ca14f,0x0009af16e80f4a00,0x000377c5e70b4acb,0x000c7c3b7a59ec93,0x000030724a30aaf5}, {0x00045d067262f443,0x0004b25982507749,0x000bd81b974e4f49,0x000a4d9132316fb9,0x00009a156b7e230d}},
    {{0x00040413b3024eea,0x0005d69b55098af7,0x0002a1af66a8f315,0x0008239a731304b0,0x0000e91a74955492}, {0x0003e0c7ee6a3f82,0x0008e0bd9c79b191,0x000152ebf5971c24,0x0000a198183e438f,0x0000d267b51648c7}},
    {{0x0009e678da935547,0x000192f9368350a5,0x00092c6744306b26,0x0001c83d266e0e8e,0x0000ff9bbcdce63d}, {0x0006b94ad0d71138,0x0007aa419046b6e4,0x0003f4797c423b94,0x0002636860d19aed,0x0000349f4cb07f5a}},
    {{0x0003e6b28a2b8001,0x000d21d65179ca2e,0x0001871c7a0e4390,0x000d93c4cf04dd6a,0x00003d99bc265487}, {0x0004e3cb86057988,0x000c2fe15fb3216b,0x000560cc19a197d1,0x0004a67b74e959eb,0x0000f4e1b585517c}},
    {{0x0004cc98e585076f,0x000e80aad228c051,0x0004600361200736,0x0006fca66598227e,0x0000a461711c06d4}, {0x00065a584be71d79,0x000f1f684055450f,0x0003eef672a8e1c0,0x0009f9a749b821fe,0x0000188a93a6ca82}},
    {{0x000d9a6edbbf0204,0x0007fde9666ee420,0x000b10356afb0a5c,0x0004d7dfc83b0c37,0x00000e52e0312799}, {0x0009e4ce359cd84b,0x000bf43f9183ab0f,0x00099c7e0393de76,0x0004427f846ebac9,0x0000439eeb2f8904}},
    {{0x000fce31fa271e8f,0x00085dcd6ab53339,0x000bf17ca52896f3,0x000c00ceed5c8afa,0x0000aead04245383}, {0x000a90776147dd2a,0x0001155288ca6668,0x000a7aac8449f137,0x0004f1a2e10e32a3,0x0000c8394d4d3c0c}},
    {{0x000f50c692933c5a,0x000c78ee682abe36,0x000b3d9a6c4ffe44,0x000be5c7b7730907,0x000000a137e49709}, {0x0001aca96183079e,0x000f9f04811611ad,0x000e37c96ce57770,0x000dec262fa1d23f,0x0000e281f8c1077d}},
    {{0x00025dacbfdb5d2b,0x00008995387e4bda,0x0006607c2701b7ab,0x00021e573e7f7184,0x00007a3aa3d01161}, {0x0000e9867cd0a313,0x000894b24ebf17cb,0x00086622314b0868,0x000340b1fc343aaa,0x0000480efbe0da3c}},
    {{0x0001cf09163daf1a,0x000e3feb1c836f08,0x0005a4a98decbf2d,0x0000d647b2ceaa70,0x00006d8310bc54fc}, {0x000b4c2600d63727,0x0003e4d5e8071ebd,0x000666689b444f65,0x000194168bb5dd62,0x00000c6b36071bc8}},
    {{0x0003c4390dc638a6,0x00084ed1e9bfb767,0x0003234c2e027266,0x0007342738b46e6c,0x0000f7959e2d7589}, {0x000dd45f4888ca02,0x000eb5127527806a,0x000e9bae4eab90bd,0x000a8b2d4fa5ffe4,0x000087b16d15c5a1}},
    {{0x000095b3fc633a8a,0x0007316bca0fc94f,0x000d8b2668cd3581,0x0008cbfa5aa5e026,0x0000c8c21a873920}, {0x0003e4ecb61679d4,0x000355a4fcc28c11,0x000ca6257920c25f,0x000b82d2d14b872a,0x000011540c35e1d0}},
    {{0x0006e26c82c45233,0x0001a997670789d5,0x0002a43f81b41944,0x000726ab8025355b,0x00003f01d8297cfb}, {0x00048146db204a06,0x000c7e02913ffa0e,0x0009ca312337ee0e,0x0008727e2840e097,0x0000fc4d0f49b524}},
    {{0x000b8a12308e33da,0x000337ec4d8beb7b,0x000c1659146b745d,0x000de150304503d7,0x0000d024f01e4921}, {0x000a6c823f9984d7,0x000eea03c4fda33f,0x000cc3e9c09105f7,0x000b318d61bb4a13,0x00006e743847f379}},
    {{0x0002cd374b837d25,0x0006c2ce00b7c947,0x00043b58db8cf662,0x000ecfef51327052,0x0000ac22adc4bf4f}, {0x000d1d45993f14ab,0x000739554cb38af5,0x000a81d9c426f8b4,0x000c7f0bb7e92096,0x00009053648a82fe}},
    {{0x000ed373accc4794,0x0003f4fa67ee2977,0x0000311becb2042d,0x000b24d99c7a2ceb,0x000036169432637f}, {0x000893691b72a9eb,0x000ecc61e9fc1546,0x000f6ea558e349b4,0x000779af664fd7fe,0x0000108ee2c5323d}},
    {{0x000ae27d9b8b43d8,0x000f3dcc55d2272f,0x000fb53844004b23,0x0004b76bc98d5c82,0x0000ce7f298d8e2d}, {0x000e2a94d1a64a33,0x00061562e50f2006,0x000029eca89ef15b,0x000ee81c47d9d4c0,0x00001a9fd03172d1}},
    {{0x000e1f968fcfc9eb,0x00006954531ab241,0x0008e861c066d0b4,0x000dc8c192eba4ff,0x0000ce2adf88d121}, {0x000aad0af982f095,0x000e37d4476b8527,0x000cf5d53ffa76e5,0x0009468c298e73ad,0x00005bffed75e1d3}},
    {{0x0007b7598b4f4c18,0x0008c456357c5e26,0x00015f31642f0a26,0x000bc5a0a3a625d5,0x0000d18b2d13a25f}, {0x00020409ad1c3378,0x000465836e75f72c,0x0002c5ec514b90a3,0x00016a126f9a9b39,0x0000d930609e4c2e}},
    {{0x000c5bc32c3d376d,0x000ee0c900c8573f,0x000eba03819e1ab3,0x0001b7ec2fecc561,0x00001001e880c624}, {0x00029ce1174fb908,0x000642285b2c2478,0x000e27cd432e3da1,0x00017bfd02b9a902,0x00007f7b6a8b6d20}},
    {{0x000b1e4ecc5b0dae,0x0005c2c0e62e9f5a,0x0006c9b1bc80f2c5,0x0006a81d4c1fe7be,0x0000c726d37bcccb}, {0x0001e5d17cfa0d17,0x00024f9bf26ab169,0x000ae21bd95ea4e3,0x000c96246db5808d,0x0000a655e7c27c6b}},
    {{0x000c7fa80a03a60a,0x0006bec2b0bd1212,0x0005bf438beb7af3,0x000a43da5be37048,0x000068eef804296a}, {0x0008674e2d968fc6,0x000f0425a5c48998,0x0003907aaaec9eee,0x00004751bd315af3,0x0000485845c77215}},
    {{0x0002d3539f63c362,0x0004eb689b184334,0x000fbfda21a18b97,0x0003b8d5ec44e740,0x0000b3ef041e5ea3}, {0x000172b46d952e28,0x000695f9dd9c7154,0x000c09cc503a2dad,0x000a80b8da9fe4df,0x00006bc6f98f03ef}},
    {{0x000aeb710af227b1,0x00042752ebd12219,0x0007f5abe6fddce3,0x000db478c999a0d0,0x0000464bcddc627b}, {0x00057116a55b2f45,0x000c46f39dc73fc6,0x000bc331ade611c7,0x00096a74bc1efafa,0x0000696914d1a572}},
    {{0x0005d9abb772a0a7,0x0002a585878f4775,0x000a12aabfef29ac,0x00077327bdcdc5cb,0x00006acb1b0fff47}, {0x000942a009622cf5,0x00060793cbe33a99,0x0004e6319018ba81,0x000462893e1ab4e1,0x0000067a7a34b6f7}},
    {{0x000c5d6a01c29e20,0x000c5755b9592a39,0x00003bd60271462e,0x000f05b7ed4bed82,0x00002c26351eea6e}, {0x00034a423d7cf134,0x000f08beb438aa4e,0x0009c47c4106b0b3,0x000affb4d68d1672,0x000093c8daf9d600}},
    {{0x000ba868113c9a1d,0x0000338cd1fd0610,0x00063c596a184b17,0x000121f53902bc06,0x00002a0f700a0162}, {0x000d41437a1108ab,0x00028b89ad88ec92,0x0000900636b15cde,0x0005693beb3a30fe,0x0000f596d95269aa}},
    {{0x000383992de6a0ea,0x0001c0eadf49d191,0x000b6249f08b65ce,0x0001bf26ab78aa37,0x000036b6d694e14f}, {0x000cd0f12f4691f3,0x000c7064c2be3f58,0x0006959713f90dad,0x0006d890ca9925ff,0x0000501135076e91}},
    {{0x0007b0cd9dce526c,0x000768dafc03b308,0x000d34455379120c,0x000a2d9703f89047,0x0000693de4cd17fe}, {0x000b57df03438758,0x000d3febe5d03f63,0x00006a2f5070a0ea,0x0005caa95fc81462,0x0000a1d0ef60cf4f}},
    {{0x000faed6a35b31e6,0x00027b0d2c666a29,0x000c0459970c0221,0x000d9efff00dd62e,0x00009fd870cfce88}, {0x00072489fe1ebe36,0x00056c3b41919584,0x00047468a39ca80d,0x000ed62caf69e96b,0x0000f68b71d9b183}},
    {{0x000f69c3fcce6d5b,0x000cf30e7ccdbcc6,0x0008023f7571be87,0x0006101b76ba1de8,0x00008ff4180c3051}, {0x000651f6c7323796,0x000d92757ac444f2,0x000e84bd2228de69,0x000d6650d8cb40a0,0x00009a11dcee05e3}},
    {{0x000a9ef3a388cd6d,0x00079a08b3f94c88,0x0004ed893c32273c,0x000eaa93278afa0a,0x0000804db1067191}, {0x0003ed02eeb1eaca,0x000aa269e85917ec,0x000b98ab4063caf8,0x000a9141573324dc,0x00003c41f6a74303}},
    {{0x0000a2c274fafa67,0x0007661f730e3668,0x0002382fe8bfcaf3,0x00019134ffd8ed37,0x0000935125943aa4}, {0x000244800946cd0c,0x000df0e459918728,0x00032302f204b042,0x0007899c8ebafedf,0x0000be5328a81cb7}},
    {{0x0006d0031fcee36f,0x00055e0a95cad3b7,0x00011f2abc910fa9,0x0005739da8677699,0x0000b7ac64a83b18}, {0x0005369151002784,0x0009d0563f5b5d1b,0x0007eef50df8b5bf,0x0008efc54918844c,0x00005ba66117f7e1}},
    {{0x00017aaebb23a9a3,0x000fad1195b0c4f6,0x000a08f41d8d5df0,0x00015b6a2f309dff,0x0000436a93489d4e}, {0x0002a63bf9a141ab,0x000fe97001b45cb3,0x0004f5b5f37347b5,0x000d0a7ffc6ce12a,0x00009b94f9ad54b9}},
    {{0x0006d07205aef3fc,0x0005231a57be8a89,0x0005a94a39f4563e,0x0003e9dea91ed89a,0x0000f63dabb48ec7}, {0x00024642fba4d373,0x000230b44974c808,0x0004d50af40a7979,0x00079137f5088ce2,0x00000609fca476c9}},
    {{0x000e8b2818c83ff4,0x0002f8faff6baa52,0x000d294722da303e,0x000f9977a2d4c556,0x0000cf6d037dbbd3}, {0x0003f7b469280f8b,0x0005bfc44a6f2f63,0x000adb24e051b615,0x000224ead0ac57d2,0x0000adcd2c71b8b8}},
    {{0x000f8bf1604c0532,0x000c14fadeb8bf40,0x0000e2ae1f370c05,0x0003afc120728f88,0x00001b8f66baa365}, {0x00075ab77c2209cf,0x000d8c32043fe2aa,0x0002c82e849b56c7,0x00012fd42038c184,0x0000fe0f8955a57b}},
    {{0x000d850f732fb7fa,0x000609faf4d7ae20,0x000f7f1924417e70,0x000349fc42eeeeb6,0x0000a6a934517190}, {0x00018b7cf247e02d,0x000f500de589351b,0x0009687358eba05b,0x0009fc5f5739e627,0x0000ddef5f556d65}},
    {{0x000774d30f504541,0x000f79d101da68e4,0x0005271bce5362f0,0x0001e6faa152f180,0x0000b838e945b4b6}, {0x0004064dd6323f11,0x0005ebb09f685488,0x000d8d4d8dcd854a,0x0006b7868850b02b,0x00009b7ff60aa093}},
    {{0x00094c377476a6c8,0x000f8bd879dbc613,0x00067c19587966a7,0x0002fdcaec3c6f44,0x0000f61ae7f6b03a}, {0x000e1fad21564449,0x0002c030664334ba,0x000c37cd03a60116,0x0003c2589ba1879d,0x0000869a09a56a80}},
    {{0x000ca054eff5af2f,0x000c2afeb00c909e,0x00030409f4f95238,0x00042f33519755ec,0x0000a031194f7bc2}, {0x0002d9d860515c64,0x000282b7c41b8262,0x000d58ae84b75001,0x00033911d917c2ec,0x0000382de3015dad}},
    {{0x000b6f92039287b2,0x000424f610648a17,0x000f670c6adaa03e,0x0005ebcc4155c96c,0x00008a428fdd5ded}, {0x000dc8bef29ae895,0x000feb853aa156db,0x000d58735fdd8c1d,0x0008ef18dbe67090,0x00005223ae90f12f}},
    {{0x000da0a305e720fa,0x000a9efc2a6ba83f,0x0009bb0d2d9ee4f0,0x000f424f84963425,0x000028fb31a147c9}, {0x0007a129692f9dca,0x0002c69d8dbf3308,0x0004070a2d33c240,0x000e53497ed09a9d,0x000056c1a642f857}},
    {{0x000fea20ff9207e7,0x000cdcba65125a16,0x00026ad2a6c19e9f,0x000dc711f4cf52db,0x000097fefb6bc4e8}, {0x000a94c4f27e69b5,0x000570e2212029fe,0x00031e5f3eb7feca,0x0005eb519c7da3b5,0x00007bb88afb91d0}},
    {{0x000a7012729021cb,0x000f25e2a3025023,0x000308907678c8f1,0x0003c3d53c45e204,0x0000ef510928bb4b}, {0x0002e7148c22ff2d,0x0008709b3aeae6c4,0x0007356abf6dcc9d,0x0005788d1b63fe8c,0x00009e378edf3940}},
    {{0x000ddeb357d98af5,0x0001e85a4558478c,0x00080a0cbd7e0c6a,0x0001dd3ddac79b65,0x0000056d8d40a6df}, {0x00091ba3a685470f,0x000a930cac5404b8,0x00005c3833644e17,0x0003a3e93f00d595,0x00008ff0d37e4337}},
    {{0x000882736c20485a,0x00008eebd8ed436b,0x00008765d62ca0ee,0x000eb404c1e6a63c,0x00001f51c3d2f4c5}, {0x0001dead0e0240b4,0x0005dc01cee53aaf,0x000ff1626340c23c,0x000eeab99ab3c4fb,0x00001c9f03e31c0c}},
    {{0x000ae756a6906fad,0x00063f4f9ceccc4a,0x000097866d772f72,0x00049ade04e7abe4,0x0000daaa2d4ec655}, {0x000f24569a5e1b2d,0x000cf346e0eedaf7,0x000077bb20e192c6,0x0002e1123812eec0,0x000043676cdfbb9b}},
    {{0x00058d8a85049646,0x000da101751a9416,0x0004052f48e7403b,0x00083e451d1f0c3c,0x000099b66e6f5e43}, {0x00099f641750313c,0x00052d7eb737c5b3,0x000781bc1f3ec6ea,0x0000d8f06b519c58,0x0000207bc899b604}},
    {{0x0008f806abe9cc03,0x0000a9a929601fb3,0x00009bbbf082d14e,0x0002f8208e30f142,0x0000554af3ba8279}, {0x0007f63f5b712db0,0x000f5e6bec6bc64b,0x00064a6500c0f15b,0x000c133fac18ffe8,0x0000426e543866c0}},
    {{0x0009d4ef17dca9b7,0x000a30ed49144714,0x000b7c7c7ff66bc6,0x00050b6f85c5627e,0x00001b5beb731ddf}, {0x0006b5a5059abd38,0x000239a4d95c865e,0x000fcce6a4320b87,0x000f54de8482cded,0x00004902e9c46a14}},
    {{0x000b7856664976a7,0x00078969c15376b1,0x00040ec0985a2ed7,0x000c001d865d85f0,0x0000f36fd193022a}, {0x0005392113e30f9c,0x0009f74dd0ed247a,0x0005828f69efb3ea,0x000a340b38e8b204,0x0000360f51bc06b3}},
    {{0x00080676229e895d,0x000b73902cd1daa3,0x00033ab334e9238b,0x000898af084a55e4,0x0000ad12d95a215d}, {0x0009537f56338b7b,0x0006b9ccc450a222,0x00005543a3bcfda1,0x000c3e65d49dd006,0x00007bfd6c4ca559}},
    {{0x0004e97c95dade65,0x000a255cb184c7af,0x0001913f02135561,0x000dacc6ec185432,0x0000c67073eac645}, {0x0006dbb0217a30c4,0x000ff3ddda1e0927,0x0001ccae8f3399c2,0x000457eca9825683,0x00009678071934aa}},
    {{0x0001b26feb7180b0,0x0003efd985904aad,0x000b49ff165faabd,0x0001d381a30fea11,0x0000c5c8356509ff}, {0x00001e0aa66f02a5,0x000536ad9cf84113,0x000abbdc628e871a,0x000d020376aaac57,0x0000a1378acc9219}},
    {{0x000d95e7668e901f,0x000060472569120d,0x000fc85db23dc73c,0x000aa6886846b97d,0x0000132a04ded861}, {0x000d5373fb18ede0,0x0004a57df5ac83b6,0x000da2aea92385a7,0x00022238fd2cc831,0x00002fe0eb0e035e}},
    {{0x00024cd9846e4d56,0x000a4f069d729131,0x0001f60df8dab9fc,0x000503b97c211a7a,0x000006e35fac3fa2}, {0x0003c474bc694434,0x00075c5dfd89e498,0x00042a47aa5934ee,0x000302b62af4f70a,0x00001298623271cc}},
},
{
/* digit=27 [{1,2,3,..,}]*([2^189]*G)  */
    {{0x0001b9cf1fff1383,0x0002e979256fd16d,0x000024e5cabb7109,0x000174971f93d488,0x0000f4a50d323ce2}, {0x00069687a5e60329,0x00035725ef1c291b,0x000d78bd756a79e4,0x000d4bb336a131fa,0x0000a42d2de19780}},
    {{0x0000770b1fd77c42,0x00073832340c46a0,0x0008fa3e971dd6ac,0x00055cfef494e03a,0x0000a4bd01ea78ff}, {0x000549569ec3b61c,0x0009fab41b9cb0b0,0x00085d069aee9d31,0x0005df668e37395d,0x0000222a186cd468}},
    {{0x0009034839af8af4,0x00043f6fb866f9e9,0x000b3d4bd58c9dea,0x000f06eb6869dd3b,0x000070c089100bba}, {0x00084c12d0fa30f3,0x00063a684ef0b7b3,0x000c5e098f27fa26,0x00008ba673334a74,0x0000febfadaaed70}},
    {{0x0004aabd136b85c6,0x000e5936fc61535e,0x000d5983d0ba7b67,0x000ed94d56bc23ae,0x0000fafa92939d12}, {0x0005ed1e9964a345,0x0001980b9f13e261,0x000c2d91983b5b76,0x0007686f1cf68c47,0x000002a1721de2ca}},
    {{0x0003d97f0a373569,0x0009541867b5c615,0x0002be69e5b1a6cf,0x000d318011508202,0x0000616a3fc9c362}, {0x000f8fb5bc1d92d7,0x000014a7ecae4920,0x000a07c0dbe70008,0x000136174fb9a821,0x00004a51fb854142}},
    {{0x00094501f646ae21,0x00093a3042a9aa65,0x000c3d31b80e7d9c,0x000f2a8addb71e1f,0x0000e4b00409743c}, {0x000cfea457fca237,0x000419bd5f99c642,0x000c9c750bb14dcf,0x000201a965cbd91a,0x000003a84781aab2}},
    {{0x000fc80219d626fa,0x0003948b0d1fdda0,0x0006db88bb4e6b39,0x000ff4f7b88d70b8,0x00003574172195ac}, {0x000d5e56f3d1172c,0x0002cead1829e0f5,0x000565f4996ea68d,0x000bab6b497081b3,0x0000f563edef0941}},
    {{0x00052442b55502c1,0x00010eecb291d39d,0x0005128fee4d7b18,0x0007125122549f56,0x0000056059074287}, {0x000a0909597c6015,0x00008af2773cc6e7,0x000b42443316a926,0x0006dec8c5b194f0,0x000077ea1102d890}},
    {{0x00069a576212f358,0x000506a394e93535,0x0009b22ea1ceb350,0x0000677ead07678a,0x00005b082f491db8}, {0x0004a81bf9ec1ad2,0x00071aee7ba0c916,0x0004e80a1337bc58,0x000abdbd5c577480,0x00000fc252a5dd59}},
    {{0x000a054c1e13f877,0x0003dcc6b450cabd,0x000d3144e7b6b2ae,0x000ed4c39ca22c31,0x0000f9567c38732a}, {0x00084e2f2344d0aa,0x000ec5ad8d221d7b,0x000e1a873a63bb2f,0x0009666a6747d67c,0x0000358844479c6b}},
    {{0x0007d2edba4a511e,0x000f2f775e00973e,0x0006cd11f44770c8,0x000bfe41e571cfc7,0x000075b695fd8542}, {0x00006e872fba8b1e,0x000e6a6534ab0dc0,0x000f0febaa07564a,0x00029bcfde2d885e,0x000025ff3bd3db13}},
    {{0x000f42c3d41c8e40,0x00027896206e317b,0x000581e8807e38f9,0x00072dbb1ab849ed,0x00008c003afb741e}, {0x000b05a75a716b03,0x000c35acc098339f,0x0006bb409efb624e,0x00044ea061fe93db,0x0000639c1c4896a9}},
    {{0x0005df2305ee4c95,0x000fb06813dbe2b0,0x000f5f222f613984,0x000e07b842f57781,0x000029d555fdb379}, {0x00085c8602f378f1,0x00078c23e6a3833d,0x000b5d0c4a1b72cb,0x000d5feb45473e34,0x0000db9aac6b4203}},
    {{0x0004b65361be7b6a,0x0002f2fb6b49ee6b,0x000913c64c9b2f8f,0x000d30a7c4338ec9,0x0000f69135ef57dd}, {0x000249afd7bdd274,0x000d7c213f9526e6,0x000247857a28573d,0x0005a9aaa2885378,0x0000cb194be632fd}},
    {{0x000c83d371b3f5e8,0x000cb5a067330a04,0x0001dc3a2fef33cc,0x000b187549f824ec,0x000091fb8cc00b56}, {0x0005b558729aa3fe,0x000dcc9c90c35486,0x000ebaa7ccca0c6a,0x00040c03f91930e5,0x0000d41e9d7170af}},
    {{0x000369c517263725,0x000f5b9c4d8f25e2,0x000af08d2fb833d3,0x000dfff4079aaa6e,0x00007b1dbc5eff3e}, {0x00095ef86114ccdf,0x000218447b952ff6,0x00028ac9591e2d52,0x00061a5f9065e821,0x00005b37299373e7}},
    {{0x0006de0bbde89cb9,0x000178894e0dfd48,0x00099f1f42306512,0x0005ae303a17d3a6,0x0000e98f7a864629}, {0x000854fd72db1c36,0x00018599b7d0f8ec,0x00067d94864ff03b,0x000a9a11c827deba,0x0000e7fc586d6b42}},
    {{0x0003905c60a37318,0x00020e672390fffd,0x000cc82bc8f9ef8c,0x0009dd202cb0dc17,0x00004b4757605370}, {0x000bd76d355ffa78,0x00062640c3b569ce,0x000d7be663352441,0x000fa5cc00063e7a,0x000041ec6b307eff}},
    {{0x0003445ff1d4f48d,0x00019ad186af8290,0x0003ec32546962ff,0x000c74bee7a65ffd,0x0000f3c5bfad6d70}, {0x0002af7a0d407d12,0x0003b49a55ee5914,0x000e67fde3d1641a,0x00017386bd678d4a,0x00006a7789b10f86}},
    {{0x000279671048d213,0x000fbf93af1c754a,0x0005ef03eed832a3,0x000166c4c086a7ec,0x00002ce472c668aa}, {0x00083e191dfa1fef,0x0001f9f62e555da2,0x00033e09245f9681,0x000834d7128c2232,0x00005980492cfaa4}},
    {{0x00005ed385c6f58d,0x0001e940322f855b,0x000abd1bdfe12344,0x000560254323ce5d,0x00003f3272b8e138}, {0x00091b1129ec9aef,0x000937dae4ab0926,0x0003b89972cd1064,0x000feb302abe5ff3,0x0000ac9ab092ccdb}},
    {{0x000ab8834fcbe7cb,0x00079a36285466b2,0x00021763ddf9573a,0x00087f23dd49e9d1,0x0000960a7dc34467}, {0x00024b2027d5087d,0x0008789865adccc4,0x0009d56dc06f79cb,0x0001e483a7a6349e,0x0000439526bf4c6c}},
    {{0x000850573c100bd9,0x000e92a154270a32,0x0002c03764947229,0x0001b3abcb8d85d4,0x0000c6b864e12fb5}, {0x00099a63a0948b0b,0x0003d11e7737521b,0x000f11ee54cc22bd,0x000c0f3897c28fe9,0x0000887a86105810}},
    {{0x000e64b613b901f0,0x00020b63d0cf3e5a,0x0000509aed92b157,0x000a4af71b397af8,0x00000f70a508ac7d}, {0x000443b477982ac4,0x0007bfcf80070119,0x0000ee5d52ca6ab5,0x0000fb76fea256a7,0x00001425f8a18955}},
    {{0x0002520e8f5fdd9a,0x0004415b44379a62,0x00013a5cfb245513,0x0007ff26da58b6c6,0x0000c62c15ae2094}, {0x000a325e4261f9e4,0x0006f038d32e2ef0,0x000ef3fc6abc70f6,0x000e30d93ea52afe,0x0000eebb6abb94e6}},
    {{0x0000247702ed7bce,0x00034f5464e44269,0x0009e8b128e5bb85,0x00080926518e624b,0x00002be136277a21}, {0x000471e16b34ec34,0x00012108d0ce4dbc,0x00009af5e6abb920,0x0002e754d17d1efb,0x00008a48cc1afe3e}},
    {{0x000e0422139c98e7,0x00020a9fb3a64484,0x000e10ede0bcc79d,0x0005a6dc2fa5ba99,0x0000ef0d52b0fc6c}, {0x00063d55b1d96541,0x0009f6d4c86785fe,0x0000eb9acfac3d5f,0x000572a8f2469101,0x0000dcb464d4523f}},
    {{0x0004f69a1b9f6cfb,0x000ce213f5056161,0x0008b7d48946501e,0x000149f12d547fe0,0x0000445a285c7f6a}, {0x000c4823f1a2ea23,0x0001385a5394c778,0x0001c1b9366acedc,0x000ab1c3ad0d81be,0x0000a11359b3675e}},
    {{0x000fad96e9cd5888,0x000b7a1e29d6289d,0x000c4b2381c4c5f0,0x000230ec1a276eae,0x0000dbfa685019cc}, {0x000f4922efdee4bc,0x00075cf61a1c6547,0x000edaf4fae86ec1,0x000804a8d53bbe31,0x0000fd5e6fb848cf}},
    {{0x000990f9e61819db,0x000a087bf284d04e,0x00046cc595c29ec5,0x000d285ade5df61f,0x00004427bdb3cd77}, {0x000aa52009715323,0x00064ee140eb5a6f,0x0007110a230db79a,0x0005beabf7fc498a,0x00005a15127fb48e}},
    {{0x0007b770b5f6a321,0x000f362ee591d72d,0x000bf83136cbb8cd,0x00084a2589241c8a,0x00004ee648e03895}, {0x000bb8cbdefa6e1f,0x00067c4e78df9a78,0x0002e73ca978976c,0x0001b28eef0426bd,0x0000de8fdba87229}},
    {{0x000066e356b5ba28,0x00042d6df6f58037,0x00011deaf6527ec0,0x000997dd3caa6655,0x0000dea9d72a1583}, {0x00071e5d50786fae,0x000acede2fe32d7f,0x0001c5ebbc758eac,0x00052ae508ead45d,0x0000105b61fc2cd2}},
    {{0x000a424820880205,0x000253ccc5077e5f,0x000f8c3fe20dc632,0x00062cc0c59b343a,0x0000155e23d52734}, {0x000ac65688011857,0x0001b16ae629218e,0x000d6756f09ff09a,0x0005fb7b7fd5fd37,0x000039a7040ebf80}},
    {{0x0003f9fc60cc69b0,0x000dc05b085eb973,0x0006e237d7c4ee9f,0x000c1aa988f662dd,0x00001d5d34fe8760}, {0x00031c971d36ad9a,0x00021af6097f9cda,0x000a112b99050a85,0x000760dd5b19501f,0x00004b8f2b2a3525}},
    {{0x00023daebb9c4933,0x00067f5f980754fd,0x00044b040f42405c,0x000cf1365bb83ea9,0x0000607651d34cdf}, {0x000cd8bdf6af7f24,0x0009f667d24992b6,0x000fdb2cba8a3b43,0x000216082779e2aa,0x000088707ba1c834}},
    {{0x000625373378cf7a,0x0006fbf97109acf9,0x0002a22d6e706614,0x0003b2b54dde5fc2,0x00007e3dc99d87cb}, {0x000e1cd88864bc14,0x00094f0b89418e8a,0x000a64fc194c02ee,0x0006b75b5f046f5a,0x0000bd2c8c6b65ac}},
    {{0x0002c8cf2c1c71b8,0x00034ba2d46ae80e,0x0005f7bfd38ee996,0x000b7c07f17b75fa,0x0000c9cda0385190}, {0x000ab3a305fb5758,0x000f9bedaa65e5b5,0x0002fd3ce5ea38ea,0x000693fb2d8b1c01,0x00000024b4599946}},
    {{0x000b3720ed0dfde1,0x000d03618777a3f3,0x0001f1f7a5cb0edf,0x000e6286b75f35df,0x0000463e61ef6663}, {0x000b207d0b79891f,0x000bc03f51f18bec,0x00045012b8dadaea,0x0000ea4f5238c4d9,0x0000e7374d260339}},
    {{0x000b9cdebf558d6e,0x000a7fe8cd19b8fc,0x000466552cced26d,0x0007ab4a23901802,0x00007cffa718628b}, {0x000bbebacd192e54,0x000631e137725179,0x0003765188e7a414,0x000a907dbaadfd47,0x00002b4be3e6d8da}},
    {{0x00094dd9e1077a92,0x000ff54da5dfa25d,0x000275244547d0a6,0x000af9942339905e,0x00001db13a32ed62}, {0x0009e8b2ff2ea6f0,0x000ccdb7c81f268b,0x000c0b9228169c5b,0x00091f33ef28ab69,0x000063fd42c2ea96}},
    {{0x00026bdfdc8fe7b7,0x00006cf1c07e97d3,0x000cadbd9a6a9283,0x0002d6bf51c2ba05,0x0000b8cb99a356d3}, {0x000ae7bb14928177,0x000b0e246da65b16,0x0004b026ae4c5b8e,0x000f61a66781bfd3,0x0000dbdfa283ad1e}},
    {{0x00056863c55d6206,0x0008826bbed476aa,0x0000f81fe2cd68ff,0x00028ab98204a548,0x0000057156e622a3}, {0x0005fd89b91e90fe,0x0003deeafbbf9bdc,0x00098a9587ab8014,0x0002738fcf98e3f5,0x0000b981ec89c6f5}},
    {{0x000b316827a46307,0x000a300d18683649,0x000f2fa071726038,0x000d3794466aabaa,0x00003b21867de806}, {0x000d2944b3ec91e9,0x000fdf4baecce9b4,0x000c417b42945b46,0x000aa79fdb7f35bb,0x00003a9f897a4e64}},
    {{0x0005a34d2eebeba1,0x000e6afd5bc4437f,0x000b456c7dd1b3d2,0x000b4153b76695e9,0x00003307619aebbc}, {0x000956bb3e38fdd6,0x0000426ed87648e5,0x0005f711ecd8c046,0x000079d6d63de859,0x0000dbf4b9f107da}},
    {{0x0007e175ead15d39,0x000561b4f3f83c33,0x00011b177a1402ec,0x000a58752be2a08d,0x00000da4d4e2fe92}, {0x000e6e8276401658,0x00032d6c4199ae4a,0x0001faba2e498fdd,0x00014b1af4332ef3,0x00005ba35a81c223}},
    {{0x000649050769b34f,0x00083bfbb56c5761,0x00021ee2541366b4,0x0008704cdec9bb64,0x0000d7945159c0d3}, {0x0008bafaf13e0aea,0x00036e13e82d5eb7,0x000339761f9d8d47,0x0009eca4591e67dd,0x0000d96c07568a95}},
    {{0x0003d5fd2029df76,0x000a5fb33c0e0f3c,0x0001ff5fc68759f4,0x00051f621da14b63,0x00003caa71b11ccb}, {0x0007c30a7e617c2a,0x0009b711ffee663b,0x000759b3ba8a1266,0x0007f0dc13775b68,0x00007e1383f3a56c}},
    {{0x0002e53bb23c1e0e,0x00092de4f81808c0,0x000027ce8893cbad,0x0000f3ec1a375761,0x000021cb492d2c4f}, {0x000aa3245f82dbb4,0x00069cced42a6e8c,0x000b6d15012948dc,0x000fb237260c2eac,0x0000ea4c9c423931}},
    {{0x000296fd70720795,0x000229b349f0d757,0x000372c7ecdb2d87,0x0000ab683986a30a,0x00008eebfefdf917}, {0x0007b20676f23d23,0x0001b68216600cd4,0x000d60209e8a6542,0x00056e7d5a86ec0d,0x00000dcc35fe04cd}},
    {{0x0003bd54c9a586b6,0x000b8854c7485039,0x0005a40f4ec5f1bd,0x000289a4e41a1f76,0x000049dafe50ee7f}, {0x000fd6e34d712730,0x00053fcc6922c67f,0x0006083c963c85d5,0x000ce0b410b01af9,0x0000bcb42a6ffe90}},
    {{0x000b767ca282a4d0,0x00020bd980476c87,0x000bfbe1aabbbaaf,0x000b88e6d7f7cc73,0x0000b94422c7d82d}, {0x0008f139b5e18b15,0x000af37294afe4be,0x00004cff3264b3dc,0x000c73112544433a,0x00005a6007937b5b}},
    {{0x0004af8e5428d95b,0x00010191ac710f35,0x0007cbedd6b7a565,0x000b814d7e43f856,0x00001c5e2eb7d556}, {0x000fcff49a2a7cf6,0x00072f558310e77c,0x00038dd2bc421df3,0x000a70595301fb38,0x000070f7e2a9b2d2}},
    {{0x00078d66e9dbffa4,0x000fd8c7ca048a86,0x0007e3eda5c2456e,0x000dfc3b87b2b93c,0x00008309da1e8c6d}, {0x000d753512b919a2,0x000af02b49c6907b,0x00097e34d80b0b22,0x000116caf4066684,0x0000a329ce0d5c8e}},
    {{0x00018e79cbc3d261,0x0005c013dcb21798,0x0002b229899226c7,0x000ec7a427d40e6e,0x00009be63696ee9d}, {0x0002ca736795eca8,0x000ab6fbe78de343,0x000bd2519b13a095,0x000f556bca40cafe,0x0000db7209b1f081}},
    {{0x00073c09004f67ac,0x000b29108a8f67d1,0x000d371b9f9fcb0c,0x0007a067e6fb34ba,0x00007b352a5eff65}, {0x0004bcafc8686e3b,0x0009f001e6a411ec,0x000e8fb4225c8102,0x0006a982156a2ca9,0x0000d80803a38166}},
    {{0x000da2e4dabb9727,0x000355d6f6b308ba,0x000f1255aae1bef5,0x0001611794716339,0x00007b4e604aae5b}, {0x000972e788159151,0x000fa3d326703740,0x00098bc1191d5969,0x00078a0d4a378bf7,0x00006a59fa849d24}},
    {{0x0000fa58dc098923,0x000a1856964a0842,0x0006b9932f4e037c,0x000814ca2cabcd97,0x000078dcf9cd7aba}, {0x000a197dc3eebe13,0x00042e556e9988d9,0x000157e412bf69e5,0x0009df4f48dcf986,0x00003aded6912caa}},
    {{0x00084e2f15edb89d,0x000ca9cc6e956412,0x00012680b1917ab9,0x0006783f51439caf,0x00005d29d2d26dd3}, {0x000ab0638623d5b5,0x000fed329f9f8df8,0x000792dc163a5fd0,0x000655955e82993f,0x000069608a1e7223}},
    {{0x00050665c639e317,0x0007cd3a0be23b31,0x000d42c79903f0b3,0x0002c444001375bb,0x0000929d6d962097}, {0x000772643d922771,0x000edf18c8218c66,0x000ac87392e06af9,0x0002719c1204c4eb,0x0000d70ae05eaaac}},
    {{0x000b98d73f6132c3,0x0002d06ff3aa0dea,0x000114d3850749fa,0x0007044ffa876d9b,0x0000f45872e2fb66}, {0x00016ce3d2f5b6fd,0x0001dbce4a5c1e39,0x00023420be2346fc,0x000ad2073526e3aa,0x0000ec42bf82e3b4}},
    {{0x000a0e0400250d20,0x00073477185ee8db,0x00076add835f002a,0x000b3b5382a489fd,0x0000bee501d59ba8}, {0x000f808fc2a3269f,0x0005a1a324483855,0x0004b0561e253e07,0x0006877e92305edd,0x0000fe56709ccee3}},
    {{0x000c69fd4d6e9ddc,0x0001efe17ab5ebee,0x000e8772fcc9e90c,0x00075476218c92d3,0x000034d8fe876b89}, {0x0009a53714b3d5de,0x000392d52e8cffab,0x000f9a84a7982c75,0x000969339421caf1,0x0000be235f473bd7}},
    {{0x0004db392168c345,0x000a7d3a892289ad,0x0001c36832b48c85,0x000ed9a7ee4e9c5f,0x0000c04e75e82317}, {0x0001be0108fab1b2,0x000295b25288526c,0x000465a6858de779,0x00095b9a8e5cb36a,0x000089a16a0405f4}},
    {{0x0004dfd0a2e212af,0x00036b8548f44a8d,0x0000661b76948703,0x0005acf11a3d8f18,0x00001c00c194d622}, {0x000d5c1f47b27588,0x0009b03b8c767f30,0x000cb8a097b7b205,0x000c759ac3acc6de,0x0000805e35066db9}},
},
{
/* digit=28 [{1,2,3,..,}]*([2^196]*G)  */
    {{0x000c38a2a1d9a703,0x00081b56c40e7912,0x000dd8e69ee22588,0x0002cd3934da3f86,0x00009ea1c46f7d16}, {0x000bbb8bb266d6f5,0x0008f24907c529d6,0x000f29a7ebd75276,0x0002d5547c914e08,0x00001c5ef3df3449}},
    {{0x000a76cc5116d7af,0x000eadafba1a14c1,0x00024709cc081b48,0x00081c7e2a466abb,0x00008b57f0616a3e}, {0x000f956ec6c161e4,0x00000fb95d4f3aeb,0x00097cb468593666,0x000bf252520b3955,0x0000ed97cbc6ae5f}},
    {{0x00086b91a9173051,0x0002f80999c69a5e,0x000310070a4efd46,0x000f45d8957ef5bd,0x00007ce05888474d}, {0x000f95d561b01a26,0x0009d0c4e3c33152,0x0006abee75a4662f,0x00001c4bce657471,0x00009c915c04da63}},
    {{0x0003fced8aa40761,0x000b87e4ac77d3d7,0x0005ac612e5b0c4c,0x000de0d7711889b3,0x0000d21f2a009398}, {0x00066281b56378cd,0x00067c47fa3c2881,0x000dd18a00054474,0x00087c02c8db20bd,0x0000cff165d7702b}},
    {{0x000b9efc0d760cf6,0x00050c278d0980c9,0x00007feafd3862e1,0x000aa3eb68afab38,0x0000647da2895fe4}, {0x000f70e5bbb84fbf,0x000d1eef05b4940e,0x0004b7c6fbbfd8cf,0x000db93150f3a4b6,0x0000b3e4f8d0efd5}},
    {{0x0005488239f8e105,0x00014cfadc9e08bb,0x0008dc975fdc87d6,0x000be3c9a3d0798e,0x000016550e4b2cc2}, {0x00023a4e3abd5d4c,0x000b906da2001e44,0x000060bc93fedeb4,0x000093dc27fd9104,0x00004cd7ca88713b}},
    {{0x000fbf542fa80e44,0x0005f10928bc0a3f,0x0006293cef2e8b64,0x000a898509b32c4e,0x0000b22619841e62}, {0x0007f5cec0217b2b,0x0001d20d8159ff53,0x0004247eb95b2102,0x000f96a510270434,0x000007a5eaff6c63}},
    {{0x0004d031f8bb00dc,0x000b5e02bac4ddc4,0x0000aed50c213344,0x000e05b337dca4b1,0x0000c86350c6fcad}, {0x000a47ddf9ce7cad,0x000feacff71799c2,0x000bb0df8204bce3,0x000e5f8261e40571,0x0000e0c599f1adf0}},
    {{0x0001b1bb94f507fc,0x000b0e3b80fd0544,0x000d3472c146d60f,0x00084fae8223732d,0x0000101a1e7f36e2}, {0x000e5e9e34bd1816,0x000f545cc7b24119,0x000d9ddc782a4857,0x0003d7ca719e13d3,0x0000d9522fd316f2}},
    {{0x0007bed302860d5b,0x000b5abd9969e2fc,0x0005b5076fa90a70,0x000ea613dd5e38e8,0x0000f8c38f07a470}, {0x0003fd5e928fd844,0x0008d2c777f94dbe,0x000e5e8ee0421bb0,0x00090b66f1472441,0x0000b3088fcb535a}},
    {{0x000e1ae7289c2895,0x00025afe82ac1535,0x000bdff2cd902878,0x000f4ef1b8d241de,0x00004fb71fcc98fa}, {0x0004222f68f44d53,0x0002c233b26fdb58,0x00075ebee32eda92,0x000808e057bccbe0,0x0000e4465cfeab5b}},
    {{0x000dfdcd833d339a,0x00020e7a389e4f2b,0x000d23683025a3a7,0x00035da3027d310d,0x0000fdf534e8caad}, {0x000c3671c7931bc6,0x000295770ef2045c,0x0000c060bf62b8ca,0x0000be1c0672ffae,0x00003930a309702d}},
    {{0x0001923fdb3e29eb,0x0001b817d72ab678,0x000b46b1a5f7f642,0x00070769c8c3e584,0x0000d0238e461de5}, {0x000c2ab9f826b572,0x000076be5f5577c6,0x00026baf39420c61,0x000bfa2c745c1765,0x00008bee5c5cf98c}},
    {{0x000b34e1ffbd4f2a,0x000747c36e6384e6,0x000188caf2580fc4,0x000021a1cc113e97,0x0000166f801bb0a2}, {0x000ee689dc2b83c4,0x000fc7170038b4d4,0x00020d913b44f23a,0x0006f4916eaa0f95,0x0000a37abc373fb5}},
    {{0x0008e478edbc9edb,0x000b6cdbf59f53be,0x0007bc01ef6645bc,0x00030d7b078b0e6d,0x000048412e9378f1}, {0x0002f15c532138a7,0x000dc14eed557fb9,0x000c77fae6fb3f15,0x0001ec558fe1463a,0x0000f318b95338a1}},
    {{0x000b7438e5468e71,0x000caedffb29bb1f,0x0002ff19da1a8652,0x000de068d72097f2,0x00007621c88c8098}, {0x00078d98bb33eb05,0x000422f044eced99,0x000e8c4b19e1266e,0x000800261d9ad034,0x00000d3bbc0defd4}},
    {{0x000b6e60f54419ae,0x000b6eca8a0201c6,0x0007bd20f02e3c59,0x000f848a270d2b43,0x00006c057044b677}, {0x00047dc47384cc81,0x0003e307e3f7012d,0x000f9a650ee8e3f4,0x0009500539cdb1a6,0x000072f13befc47a}},
    {{0x0007e2ac62f29ecc,0x000c7076b6aa4df4,0x0008c07b37559318,0x00062001974448d9,0x00008a44c6309b81}, {0x000e2de6bcf14f8a,0x000f4990ab063f22,0x0004697a9bbec1c2,0x00030cecea565c48,0x0000fd3da1c5e5d8}},
    {{0x000aabb0b18a6f6d,0x000e3c002fa1b7dc,0x000818bf3e956799,0x000cb0a09f9d8ac6,0x00004c37af29089f}, {0x000975ede76d2691,0x0000edc449b75047,0x00054acd30477815,0x000fff298f1059ac,0x00007ac93c57a2ee}},
    {{0x000b8d64baf52f42,0x000b09a3292f23a0,0x000456c047f3f84b,0x000fc353ae21c75e,0x0000110967ba5ea7}, {0x000db604a4420675,0x0000bc0332e07024,0x000f18635c4ebf20,0x000ecf2e0f788c83,0x000050d2e58fb836}},
    {{0x000c9678e5433b08,0x00070837189e593c,0x000f524cd351331b,0x000d2130907177b5,0x000027851eca7500}, {0x0004709b248eca72,0x000a87322fbb36f3,0x0009e73d0e54945e,0x00023d52f940920a,0x00005827d8bfa825}},
    {{0x000b019bac0eecc0,0x000cc707f8790281,0x0004e858045722f8,0x000538e7e32b5f38,0x0000c291610a5aee}, {0x000c51ee868e43d1,0x0000b754959a25fb,0x000f424af9289eaf,0x00069ecaf0bb54a6,0x0000923b39262f9a}},
    {{0x000eb037fabec5a2,0x000f5113b5f773df,0x00015a54ebc1d2d4,0x000181f233f0f51b,0x0000fe807bffeb66}, {0x00046d05b62ce294,0x00098d67cf9c5ed1,0x000a8fc4e5cef5ef,0x000aadad520b5c8e,0x00007039215094ef}},
    {{0x000a1db4a22af952,0x000cb9edece623c4,0x000366394458ac70,0x0001dfb057f7a0ae,0x00001fe7a1fbcf33}, {0x000d7cf370fe2a14,0x0005732e78fb4925,0x00055e87c37f393a,0x00011bffd64640e5,0x0000ec4a5ddbe8c0}},
    {{0x0004d4d3a17880f7,0x000daa8f972e8527,0x000d1a6e2ec1bea4,0x000c27636300963b,0x0000efe1ddeeeed6}, {0x0004f3e8c69f40b8,0x0000b1029582dbbf,0x000af32882bd8807,0x0000a6c9827573a8,0x00007105abfc154b}},
    {{0x0002a5c62b9097eb,0x0008d4989c3a69bd,0x000c39b3112f1d05,0x0000d73bfed8eb5d,0x0000a4dd7028190d}, {0x000df21e7c9ea92c,0x000cb9a2427202b9,0x00055d8cf2e18cf8,0x00000d9225aa33bc,0x000093d58b32465e}},
    {{0x00056d7e3c7e81fc,0x00063f455beb34d8,0x00041bac0617ff16,0x000d390004aab0d3,0x000066a594a7db36}, {0x000674ef21314c13,0x000cd499799bff44,0x000674e5b127989b,0x0006f3d0eac3e533,0x0000475033eb386f}},
    {{0x0003be03f488b066,0x000afe3e2458f80e,0x000cbb0ca9c1df72,0x00032d854724a756,0x0000f294d9ced004}, {0x00099d4fed7a8bf1,0x0000a3d4dc031bbf,0x00098fe4b4fa6535,0x000d3d62a156b316,0x000061c892ad39b5}},
    {{0x00057062dd51b0e3,0x000fb0b6ede2e44a,0x0009b84b4bb2e66b,0x0003892b535e65bf,0x0000f04bbbd4cfae}, {0x000e254b0efecf74,0x000c7b425efa6f99,0x0006fc1223cb5014,0x000ed3775dda3b47,0x00007d91e4176c7b}},
    {{0x0001e11238f17189,0x00055477448462ca,0x00076d1ca907db73,0x000957e211b110df,0x00009f00d6031218}, {0x0008148bbf09b400,0x00081c3bb9e89771,0x0008b25f9e1f66b9,0x0003658ee958d873,0x00008ea2bc754377}},
    {{0x00040ec2f8b18d2b,0x0005720588c7874c,0x00012febf68a4ccf,0x0000ad74cc5bc416,0x0000c0cd6c894bb8}, {0x000a5770732df031,0x0009df7b0dec4b86,0x000bf3c40616b170,0x000ad41d43d29a1c,0x0000eb2874f42570}},
    {{0x00075fff53df8b53,0x00080ad93ea9fdeb,0x00094201518d77bf,0x0007e5c4c968a760,0x0000623567d0a637}, {0x000b5f86a4738b2d,0x000027189c03c512,0x00071bad6653470f,0x0007c87146d1d64f,0x0000a1a59a4469af}},
    {{0x000b514e53719c74,0x0004263a91d246bf,0x00026ec908be45b4,0x00047bf0842913d7,0x0000b483a7ba011e}, {0x000411dadfaf9c39,0x0005f75f1a475043,0x0000622a4242b2a6,0x00076430694e65b7,0x0000cb0de0487bd5}},
    {{0x000a48d97cccb4f8,0x000039d242ee958b,0x0007a2d265fc7e92,0x0004f9b0346ee66d,0x0000ae6d9eccb1ec}, {0x00071cb876b50704,0x000b3a208b80528c,0x000e466e83bea7e3,0x000f09d38293ce87,0x0000f7bc81782076}},
    {{0x000cc15e3a833811,0x00027d31aa50385b,0x000d0e82633ec551,0x000ec7922987876d,0x000070d03a64f875}, {0x000cfaf5650d15f6,0x0003473ac211140c,0x000c98877e0f73f0,0x000c08a75c5c482d,0x0000622d09e823c7}},
    {{0x0000b7e8cbf9ba79,0x000cd6e710efc7c9,0x00077ce47b6bd4ab,0x000960be8ff09b54,0x00004e8f8dbc6cc5}, {0x00021368a1283c7b,0x000f518b32eb7e5c,0x000cbf5b162623fa,0x000005dbef4d2e43,0x000088b15fa01ecb}},
    {{0x0000073cbb4b6ec4,0x000b0a7babe5c5c5,0x000fe549f4ecc335,0x0008c322d1e8f812,0x0000c49af93d1581}, {0x0002b2e39f0417cf,0x0003d9808a14c3e1,0x00017386e20adee0,0x000690f7522d1fa4,0x0000be41fb5f632d}},
    {{0x000d671707701933,0x000297bc3160d8f6,0x000cd76c64b8a53c,0x000dd64e0e6d9406,0x000034d74fce765d}, {0x000daf8269a471c5,0x00075ff07d0520f0,0x0007f32fb264506f,0x000b4a0a95e8f527,0x00009abfb62dfbd9}},
    {{0x00005b5fd8e98e12,0x000e14ad70cc06de,0x0008fa21ed10a09e,0x000d8d84fd47afe8,0x0000d6f824d23bd3}, {0x000baae0dd9c557e,0x000ad65982a3dbde,0x00009c77a82ec43d,0x0005bf745e0fa843,0x00003f0eeb6c0fc7}},
    {{0x00088e490854a78d,0x00018930eadc94c0,0x0006910aa320ffac,0x0000a278a57e2f16,0x000051dd5b2d1423}, {0x00005547cd73a6e7,0x000cfd1d02fc869d,0x000428efc74b6a1e,0x0001e7c08394445e,0x00004579b6ee7a03}},
    {{0x00024c9bcf01037b,0x0009474916aabed7,0x0000d51d09748fda,0x000cd6db5cd430b8,0x0000dfdeb4fdd00d}, {0x000893bdeed91a80,0x000f120778a2597c,0x000058a2e837a8e0,0x000cbf18735f2428,0x000099a77bb6fe13}},
    {{0x000ab7d29b0fc1d2,0x0000c2ff82ad4240,0x0003e8b1824be74b,0x000b66033eda9291,0x0000639f82a1d05b}, {0x0000f2c91ad5de88,0x0006ee9ddf6690a1,0x0005fc7fbf5d854f,0x00072ac4ded94a95,0x00002682d9b714a2}},
    {{0x0001a874ed7acebe,0x00029408c1b46ebe,0x00096d405f800d1d,0x000d48657b969e8f,0x000025248132720c}, {0x000113432ff0aab9,0x000ed7506e97a2de,0x000f3ff61e19447d,0x0008868795e67865,0x0000dd308ae491e6}},
    {{0x0000c4982db65ca2,0x0007cd8b3cfa5d15,0x0008b3c34d779cee,0x00007ce56f66df9b,0x00002bad9190373e}, {0x0007dacf82c7cd70,0x000170cd5e21faae,0x000d737aa745c2ed,0x0003683c666088dd,0x00002a7ff3c66133}},
    {{0x000a25b51b2364ab,0x000cca23ad8f56c0,0x000cc5060f4037d8,0x0002d7b40bd50e15,0x00003c6b05849780}, {0x000dfb5580a54f98,0x00017736f3f4da3c,0x000fd025f36ffc28,0x0008e648f7012618,0x0000d358c70b39f6}},
    {{0x00058b4c855a6e77,0x00057c0c522b55f1,0x000aab00625e8fee,0x000e46856ddaf929,0x0000358453361f0a}, {0x0009303af2d55212,0x0002aa5a6f6c0d2d,0x000148546bae13b5,0x0008b24d4e4ab630,0x0000d7472f84840d}},
    {{0x00053970acdb5e8f,0x0007fc269b0f06da,0x000ed8404fc5b791,0x0007e86e017875d8,0x0000ae584763a508}, {0x0008f45064b6f293,0x00033c845a65aaf0,0x0002b4eb7bd3ce36,0x000130fa6c359a38,0x0000a8bd9f84a685}},
    {{0x0008edd0663f8f91,0x000dfd59df5ea31a,0x000b723f079a56bf,0x0009327b892c2263,0x0000ca95b5e3d558}, {0x000ff18c4e8a781b,0x0001e49ef80c48df,0x000240760a2bb746,0x0007c06223d5cf77,0x000078f428a9e459}},
    {{0x0007912ca1754a1b,0x00092318062eb864,0x000974e01c1c5675,0x00077e15df7992f8,0x0000a5205ad4cc39}, {0x0007e259fb6cbd53,0x00069eb726a354b4,0x000e567fe8f54419,0x0009e27f6dd9bb81,0x00001e04658e6f27}},
    {{0x0003571b3d512de4,0x0003b7ec1208dbee,0x00021dbe93f6b7c2,0x000e0305001dba00,0x00002cde309eec3b}, {0x0000e38dd838d4f1,0x0005ed3f3ec2efea,0x000695c674c80611,0x000b53a586d725c7,0x000023cf980c45f2}},
    {{0x000b294c00e93609,0x00036582b06d7012,0x0002b6731864a65d,0x00038b0faad9a9f5,0x0000f77e45dc3d84}, {0x00049e1125dd970b,0x0006521b5e3f5cef,0x00026ca225bd9b00,0x000e53d27026153a,0x0000ffc6effc2de9}},
    {{0x00049dac9eda55e0,0x0008ed551742ae1e,0x000db16b7071ad42,0x0007e519f35180de,0x0000acf03adba5a9}, {0x000674fe200f7515,0x000041ad6226b24d,0x000bc185532514d9,0x000f57098d181f26,0x00003a47ab5d1829}},
    {{0x00065694a7f9b78f,0x000f181f805c903a,0x000293f8c82ead90,0x000dc417c53de726,0x00002878d513c8f0}, {0x0005fb44bef65dc1,0x000c159a08f75e63,0x000e766741f4f5d0,0x000925d04127a52d,0x00000eabd36a8ede}},
    {{0x000b38bd3f9e6f35,0x000a429a8af3f5ad,0x000b3d4c94dd8b95,0x0005081f01c01e1e,0x0000a43459cea12f}, {0x000266c93a596f15,0x000fbb27f18ef36e,0x0005dc2d06428594,0x000875dbb1d59fd7,0x0000123eea204f7f}},
    {{0x000b96fae7ffdf8b,0x0002c722fe26e092,0x0005b25bf727e271,0x00079b4b3ece9d22,0x000029e084fabe5d}, {0x000cd0f3353903c6,0x0000436a938bfe7c,0x00097acfe3f67b99,0x000bce9cd2d1a3c7,0x00006253f0aaad9f}},
    {{0x00044bbce9995733,0x000f073624473dd5,0x00033abee446da98,0x000978d07a005203,0x0000caeaa7309d7f}, {0x000150d1bf2bcd41,0x000ccb53f84c0b65,0x000ac6215464c51e,0x000609e277528a4e,0x000098cc59ce3166}},
    {{0x000efcad4a7da4d5,0x0008301bbee31186,0x000b3db7feb894f7,0x000f1f8ace71e7f1,0x0000112c9354a5eb}, {0x0003b627286dce6e,0x00095a30713afd8d,0x0001c6f0a0610827,0x000d93fc4c531160,0x0000964d3161c3a4}},
    {{0x000ed7017f788ea0,0x00094674852856bf,0x000c96919c78850c,0x000d11c15e8987ef,0x00008ec3fd406441}, {0x0001d9a8b2134698,0x000beec4889b6406,0x0003f1ad5d6f0bd8,0x000240648f309015,0x0000e5b581f2cb82}},
    {{0x00027926c5189337,0x0002741b168b71e7,0x000a4a599fdcd605,0x0007cba7afaa4cd6,0x00002940e9635844}, {0x000a7689dae16a8a,0x000dba4b641f4ffb,0x0002ff98dda84226,0x000dd3217fd968b2,0x0000584b3c0e2f5c}},
    {{0x00031b6de16fdb99,0x0008582a440f2355,0x0001c6e1855a3304,0x0005300eec11c310,0x0000d21585a61848}, {0x00011b3ef7a3b94e,0x000505e21369d2ce,0x0004b130e8bfbb57,0x000a18b7f8363266,0x000093672301cecb}},
    {{0x00006d08ad2b8a84,0x000174564b2255b8,0x00072579bbdec57c,0x0009ce6932d9aefc,0x00002be0f18664b2}, {0x000379820c03f35b,0x000b81cc51d23ac4,0x0003b05894b88c59,0x0003d5999a808624,0x00005debcd1e1590}},
    {{0x00063183e156632d,0x00095cc68bbb24c7,0x0001bdedfb33c7bb,0x000fc8798ec08681,0x00004d45061bb8c2}, {0x00096921fd5268a1,0x0006fb5a73e1eaff,0x000c44fe9ef420da,0x0002d2e7d1a2a7ff,0x000099f6ec68c8bf}},
    {{0x000b091537d50e00,0x0004c4d8240e0105,0x00088289db80bb3d,0x000f2516e62e6a1d,0x000049b3d353af60}, {0x0006c1e8a9308ea7,0x000a834375ce9c5d,0x000bb4bf8bdb7520,0x0000568aac390a23,0x00000b0ddd236d48}},
    {{0x00072da34e3add6e,0x000a25b562a221be,0x000f893f7463701f,0x0001b78a85dc4a41,0x0000b8945c02e7af}, {0x0004515392a4b278,0x0007224cf9eb4248,0x000a36d27223dc97,0x0000469b1c26a8fb,0x0000c8a286157f29}},
},
{
/* digit=29 [{1,2,3,..,}]*([2^203]*G)  */
    {{0x0003d44e194a9fdf,0x0002786ca99f031c,0x000ad1c1ca8706b5,0x00016f6144a3f729,0x00007cd191d19930}, {0x000032e9850c5a09,0x00064ac49359a6c2,0x000556cf735b82bf,0x000ee923f58e8bf0,0x00004134d7aa14f9}},
    {{0x000d9bb86ddaba10,0x000af2ff8d7f7ad8,0x000598bba183ded6,0x0009e01bf6f62c72,0x0000b0e9cfa9acd8}, {0x000fa485b832c346,0x000511c3faaf2d1e,0x000b424d4c7077aa,0x000d2f6f4b824a1c,0x0000e6cb10d909b1}},
    {{0x0002f3ece47545bf,0x000cc82281bab5ca,0x000fef90fb8bf71c,0x000bee7b6c1c7445,0x00009f6c799f8590}, {0x000043420d1a0c68,0x00050384ca2526ca,0x0006d804758be80b,0x0004f8d0335e99b1,0x00007f6cdd65f76d}},
    {{0x0009dee69ba8813b,0x000aa6bce2ade252,0x000b5e21e2f41814,0x000311e74086449d,0x0000fd363bf4202e}, {0x000eef53cd037a91,0x000f421162d3c6c0,0x000c1bfd296d4eed,0x0006d0ff1ba38cc4,0x00007b7b0d0ae516}},
    {{0x000118e549825790,0x00087608d2b36a6a,0x000db2f0bc20e5a2,0x000100d9275dfc96,0x0000fde447ee7b6c}, {0x00028286516d65bb,0x00018776f794bb5d,0x00073d44dfb1675b,0x0007d7116902d37d,0x0000b303e3549334}},
    {{0x0002b20e7355edc0,0x00029cd368ead897,0x0008b57463d27897,0x0009c3165bfa78bc,0x00002fe2446e3da6}, {0x000b89e933220b48,0x000cf81af9f1c16e,0x000c693a260f9ee9,0x000a0fd40f000040,0x000052f4665ea9b0}},
    {{0x000e8f27a45c0327,0x000e86dd8982d9c4,0x000e56fb7618c159,0x00082ae92801f788,0x0000cb0bbd114f00}, {0x0002622a7b7bdd1f,0x0001cde8a1787ac9,0x00079d3f0007ae73,0x0002f8c21efea529,0x000059193889e5c5}},
    {{0x000d6baee189bb56,0x000e053f037f48a7,0x000fad7013164603,0x00005fdb161acf55,0x0000e17a5d95e63f}, {0x00019ffe09ff7228,0x0008cace368cf35f,0x00091ae861843311,0x0004e6206e370ead,0x0000ddd9c9e96ad8}},
    {{0x000c45cd3f314ad9,0x000d67364744703a,0x000b4a453c3af51f,0x000b9543050e4e10,0x0000fc178295f043}, {0x0007775ac574c8d3,0x000779f0b9acb4d8,0x0005b7ce50c8b03d,0x000b17132e5af1fb,0x0000c9a4f064d508}},
    {{0x000f522e5ae3e277,0x00035c35e812e660,0x00042cb0bdb0d2f5,0x00094342c735bbee,0x0000907ea8901582}, {0x000ec0462e80ee09,0x0004686fb3008f47,0x00006f827e223116,0x0009550860a2ce31,0x00000a75951e7b8d}},
    {{0x000f70c1ae342323,0x00018ad9615f80b9,0x000cdb22b183eae2,0x0007f44fe13030aa,0x0000096480bb3134}, {0x00051223b16a6387,0x0009942d6ff78220,0x0007ab9f39c0104a,0x000222d1b2b20f04,0x0000e09b38b19739}},
    {{0x00015cdd08fa5ad2,0x0009abe3f073baa9,0x000000d8e4981763,0x000177db88ef6f94,0x00003eaac824bcb0}, {0x000eec6acf802868,0x000ce8144efca222,0x000da7040d7d51ac,0x000194f0b2b6495c,0x0000cabd0cde140b}},
    {{0x00017df57e74652b,0x000f4607f76a84d1,0x000a479ff1f3d544,0x00007f04801c4412,0x0000698c2293de3c}, {0x0007faa80f480970,0x000345e6a405407c,0x000b9c66fdd33168,0x000aa0cb4a878f56,0x0000967b41c670b8}},
    {{0x000e336c7c6f0782,0x00096d368d37636b,0x0007cb94d59ddda6,0x000066012877b72b,0x00001a597b4c1bdb}, {0x0001a77f61e01063,0x000941d2f7f6a765,0x000adc00b4c447fc,0x00091ec195fdceab,0x0000225175f8fbf6}},
    {{0x00092cdef9b9f47a,0x0006904c0879edbb,0x0006347c48b0eaac,0x000a434c1967d357,0x0000a127c7caa1a9}, {0x0008363c59d19935,0x0001d39d521da939,0x0003198ee98fb3d9,0x00029ecfd6c18cdc,0x0000c77256b8e3c5}},
    {{0x0004c3f4f7c6da11,0x00061ad5689997f7,0x00062877229a2a25,0x0007088588d5eba7,0x000058d5cc44dfa4}, {0x00035cc9a95c4417,0x0004bc289fdf6e40,0x00019b3a507f5383,0x000ce233b96c0c50,0x00000c852a997bcf}},
    {{0x00074ab6e99c27db,0x000700add209d2de,0x0003682485035083,0x0001df8625e5b7c7,0x00000b17bc10dbf5}, {0x000a3800fdb2a3d9,0x000dcddadf173751,0x00052591af594942,0x0009ba307d31c514,0x00002993a31f60d9}},
    {{0x000f10830427f20c,0x000f3b328a7fe500,0x0008f3641b8a00c1,0x000ddb433bdf6377,0x00009d207a3e0f16}, {0x000ad2c986b8e3d4,0x0000a50419f77145,0x0002215e5dba85f9,0x00036043616de9a7,0x0000890c85022c4d}},
    {{0x000c79fb017c6831,0x0007a3ac08d0d0c0,0x000029dfa2a4a427,0x000ad7d78feae29b,0x00008d9adfa5f678}, {0x0009c5a65d795f42,0x000b9846b9bb1ee6,0x00058ffe0f45ce60,0x000e91a8c1a88f3e,0x0000be10bcc58190}},
    {{0x0005faab9590cb5e,0x0001342fabcea57b,0x0003e7b2710e9804,0x0002cc1450419041,0x000074d1a8f02914}, {0x00094b897325bd19,0x00008ae2d222f310,0x000d2bd77ff05aef,0x000980085cf5bd1e,0x0000b0fe23af35c4}},
    {{0x0004fcb8b197112f,0x000f08c2d9a81289,0x000d49a846e64b4e,0x0007aa5f20e1a8fa,0x00007cbd1a7ba201}, {0x00064a4a4bc89168,0x0001fad822dd3cda,0x0005d3c95cf37a38,0x00042789c1ac2c12,0x0000ff1fe3c1d92e}},
    {{0x00092a5b1d033025,0x000fa30de8fdc44d,0x000a4e718fcef607,0x0004fbc816269dfb,0x0000bf7617c683f1}, {0x000de6a2dba301dc,0x000825272ede6fb6,0x000b46c3e8670aae,0x000f2ae811ace7dc,0x000059fa6d27c8ae}},
    {{0x0002c9a0ef6d99fa,0x0009458f7d2ffabd,0x000a81b1810c0ec1,0x0000355e7c18df1c,0x0000c49e954b5556}, {0x0006c6fcf3518d17,0x000b3430cd0f57ce,0x000ed76dc6ca44be,0x000fa9be95d0a2cb,0x0000228db9607d58}},
    {{0x00029d5eb1852497,0x000c231b03be4c4d,0x000b6be41e03aa73,0x0000c8bd817ca00c,0x000045736b555b18}, {0x0002467e0d2667c6,0x000112c70e0b53ce,0x000ce135f6da78ac,0x00097cce5c18f0ce,0x0000e522cc53caf7}},
    {{0x0002eccb8b0b2cc8,0x0001b5ccf40f2f60,0x0004aebd14979660,0x000e7c210c1a93ee,0x00006c082ccfbf4d}, {0x0005a29cf6241ec3,0x00051c57365898d3,0x000c5cea4126aa24,0x000fb5f29b7ff954,0x000035d47dc88418}},
    {{0x000e379fec34dd00,0x000af10f04b2da8c,0x000244ba7b67c67d,0x000b291e6c1fc84c,0x000064b8ffb56a4b}, {0x000f0c726a01b425,0x0000ab4e63c20a03,0x000daa4bfc15dee4,0x000b2ba598f42985,0x00000412dc5ee9a6}},
    {{0x0008e2b0cbea7f60,0x0008aa38f3dd0462,0x000bbefab03aae77,0x000928ca9669f559,0x0000980eab114d68}, {0x00060ecf7e0890f4,0x000add678a21193d,0x000e75ce55e32dff,0x000b93e865c3741f,0x0000c6b7dadc3ac3}},
    {{0x0000ebc9c7982a25,0x000c291e4d112cd9,0x00016c66bcb45331,0x000f8b46194b0c7f,0x0000dfc74610f6eb}, {0x000d1481dd4169f3,0x00038b5f60af605b,0x00009d46e7986887,0x000bb629eb8a4bc3,0x00004d4d57fb25fa}},
    {{0x00045dd030229a4b,0x000f628bf05c5a04,0x000c8ae68bb98061,0x000b9637143f5451,0x000055db14aaf091}, {0x000c500b3ec39fe8,0x0009d418e00ae4c8,0x000f274dda387c10,0x00044d258b0c3190,0x000082d86c4dad00}},
    {{0x000c6b74352596ac,0x000bbda2c19cc12f,0x000372be7ac616b8,0x00068ef8dd414a4a,0x0000a5c3507d3814}, {0x0005c60076424b1e,0x0008521878c8f96f,0x000720621f0ecd3b,0x00092f64b81e74eb,0x0000538ab09b9a9e}},
    {{0x000147af5c6b6fc3,0x0009d626e2d99fe0,0x000e4efc5d3b7322,0x00023ead978b1f26,0x0000f06e93347735}, {0x000048486ca8b31c,0x00068bde8b51ab05,0x00034d7e9ebce61e,0x000b3f2f10632b10,0x000093e107c4e9cc}},
    {{0x000a93461fccf159,0x000ac594ab715187,0x00023895d730753c,0x000cc5a17e2ac232,0x0000ef8cc49c9735}, {0x000ae251f43e9bef,0x000f1381286e7f14,0x000ece1bd4bbc7ec,0x000c24d2741d2d9d,0x00004d288de19a8e}},
    {{0x000485ef01499626,0x0001422c7178e581,0x00079cbd8df6a745,0x0008dba5d0e4b656,0x000073799e051574}, {0x00030e5c106aa63a,0x0007bb8bf1bfe2fb,0x00051e7a789d99b2,0x000550c0acf7e0c2,0x00003f634d522030}},
    {{0x000bba47947ece86,0x0009f8484a1cb45b,0x0001b504f55b8127,0x0005f5297e6d1f72,0x0000ecb79c9e7225}, {0x000a586963b03fbe,0x0009a9a594524654,0x000722ee4a3b403a,0x000ab40a3e93989d,0x0000606778e918ca}},
    {{0x0009e70fcdb5c523,0x0009777edeab081f,0x000b6321e92e6fc6,0x0007d56dca6cbab0,0x0000481a9a365925}, {0x000c9c830d7147e8,0x000d7ed3c882eb18,0x0002ffe1754187e3,0x000ba41b2d1d263d,0x0000d9341cfa1024}},
    {{0x000c73485db43e65,0x00072de631cdb39c,0x000dddde68822312,0x0009f1cca53521df,0x00008999320f891a}, {0x000dc155336fa529,0x00035bc4fb3d5300,0x000d60db809e08ae,0x000611c315d50e15,0x00009de175044122}},
    {{0x000fa9194d351ac8,0x00074be1275acbad,0x000d047459aa08d5,0x0006b7f0a2a4d8f4,0x0000b07256b61364}, {0x000b6c992e60611d,0x000e5798e15351c8,0x0005f15a3b1f6a0e,0x000ebc7ea67466ba,0x0000be447e50b869}},
    {{0x0005d7c17fc06372,0x000ab2ce49cccaab,0x000161cd0f703ffe,0x0006f3af701e3650,0x0000a22686632fac}, {0x0004ffc699f8f077,0x000cbff2b120fb16,0x000f1296557865ec,0x000e28bb4519d52c,0x000031c60ef40cec}},
    {{0x00058f18eab52d1d,0x000560d708260815,0x000f6f11289d112b,0x0003447238d0bb08,0x0000ec9f217619aa}, {0x0009a34620f0a1e1,0x0008b55172a98dc1,0x0000ef9ddda42dee,0x000e7f1fef171e88,0x00001dc69d22f38b}},
    {{0x00081cbe5c6b0ffc,0x000a70f127a082a1,0x00036c3fcc49c7b5,0x00032943bcf4908c,0x00006403b86cd8db}, {0x000d0a77264c886d,0x000074c46e8308b8,0x0002b835f05f0d1b,0x000920f60b800c29,0x000049222a687aa8}},
    {{0x000576f2d8ff940d,0x0008af6e9ad4ff42,0x0001881bf2265dc0,0x0006ff7cb9f24d1e,0x000088c9c79e4b0a}, {0x00073d5b18e1c9f9,0x00006a4d2af38012,0x000cf1d6666875b3,0x0001d3988b576672,0x000045dbe0545fff}},
    {{0x000abeb891f1ec6b,0x000fd53801df03ff,0x000b2923fddd0a86,0x000d0d90338c4e04,0x000093b7a1c89855}, {0x0007c6d30f5cdae0,0x000fec5d2630aa27,0x00063d74b39cc985,0x000af9d1a3f8d39f,0x00004b3d5f66a46b}},
    {{0x000c9f671d7b1d51,0x000a34d571ffd097,0x000e017c1332810b,0x000ac856d2de4856,0x0000b5ac59d08ba6}, {0x000c9395a299f7d6,0x000550364c6c872d,0x00073ca853f70ad0,0x000d64e23185ac4e,0x0000a0dc786f885e}},
    {{0x000365ca2f6cc753,0x0001950b7492d550,0x00003bfbde327978,0x000b87d29fe0d9cb,0x0000746555bd48ce}, {0x000c895bc1abe035,0x0003dbcf3d569c94,0x000bf1343778745b,0x000ef3214b6486b3,0x000047aa6736af22}},
    {{0x000a2fcbbaf2c939,0x000d9fb3b552fd25,0x000b6e203f0b0875,0x00062eb1f0689b22,0x00002dad5d7a6b6d}, {0x000e02be2a7f8910,0x000f4be85299fed4,0x000459f8ce325e28,0x000f4d4865b62c76,0x0000b1af905e5737}},
    {{0x00052120e85c6041,0x0001ba10be26a162,0x000d804fd3ec775c,0x0002eaa61440fb52,0x0000068ea63e38d2}, {0x000b7fc5f961a053,0x000cc635146d1c90,0x000e33657bdda345,0x00085ee9c9428d6b,0x0000446275189867}},
    {{0x000784a3c5468e85,0x00047984ba27c370,0x0004066d7e5a8330,0x00061c6d875b96cd,0x00009ef1394bc3b5}, {0x0008a9fa2de76220,0x000e636f54a420bd,0x0002ea4587bdbb30,0x000e5caf449dd5f0,0x000010d9580bf257}},
    {{0x000bc0df5663cc09,0x0008ce45bea99fdc,0x00066c8aadefcd5e,0x000c717280653351,0x000013d1b8e2e804}, {0x000e2ee1bcaa98d5,0x000a89c86e998159,0x0007ba8b8fd3241b,0x000cda83ec96ed7d,0x0000cbcf8e5c4088}},
    {{0x00013b8639ee43e4,0x0001cd5b01220ed1,0x0003036576d0f097,0x00062825f0577f4c,0x00008ef888dd7597}, {0x0002f120ef9824af,0x000bdfedb88169eb,0x00096098c26c3113,0x000fb30d47829f28,0x0000b9a090863684}},
    {{0x000e1d9cbc3fde8e,0x00004d7bb98ff2fe,0x000f525f9a307331,0x0005b55bcd46bc61,0x0000018644ffde13}, {0x0006b02f72aa32c6,0x00064f4c36a1c7cd,0x0000fd885a8f4dfe,0x00087bd6ea8c9b1e,0x000074cf3eb4034c}},
    {{0x00073bd32b3ce74a,0x000ae1cd16e13987,0x000ae6b331a3b6f6,0x00046de18f795e62,0x00001b268c2eac8f}, {0x00069500b796bcb9,0x00084b0bba811e96,0x000f2ccf64d07f55,0x00041c6d9453b627,0x0000ab5a6b96d1e4}},
    {{0x0006ec3a747b5540,0x000399f0d80c1e58,0x0007fdb082affb22,0x000eb0c210e996e8,0x0000e95e547a6d00}, {0x000c9c0049c9c5cf,0x000e0f520325da72,0x0005ebfd1d560466,0x00076497d952c276,0x000045f0b3696836}},
    {{0x00008a22bc43724c,0x0003c41e774eef64,0x0003a4dfeb9d0e74,0x00004b006555b0ab,0x00005d1666eb0348}, {0x000248fd93a49062,0x000be3c4df2ca530,0x000998ee3e168071,0x000d38f9f0133243,0x000048b66cacb6bb}},
    {{0x00089d9f89790db3,0x0005f889a66e42ae,0x00077b13eaca57e7,0x000143092c735596,0x000008aacec1a523}, {0x0001e6516c69967d,0x0006f9a3b6e5c1e8,0x0009f29dfbf864b7,0x000799dd8c521037,0x000071100f81f8ea}},
    {{0x00095a4465926123,0x000cefa1e2ba3fe7,0x00026ef78e5b31e1,0x000a78581fbbd306,0x0000cae68ad41793}, {0x000c18c2eb0d08ca,0x0003ef8c811ae66b,0x000e2252da9bb52c,0x0008a2c5369b8118,0x0000bd6b4123893e}},
    {{0x00098fbeb198837b,0x0007e591d932f152,0x000a139813f9b9d2,0x0001b9a3399f77e4,0x0000a1298c3d05c0}, {0x00022a6bfb15d6ef,0x0001033da01cb0e1,0x0002fb9fda76e2c7,0x000f5fbc3f0ec949,0x00006c65aa22897f}},
    {{0x000c71c17acd4295,0x0001011c393d2328,0x000286245219bdd6,0x000cba4b683f2657,0x0000f802506bd066}, {0x000b96620f24420c,0x000fa4428c9d74ac,0x000aacb236ad94a3,0x0002c648f91ae4f5,0x0000fa1ce59741a2}},
    {{0x0003b3ce11cb6f2d,0x0004d34dc8b8ff58,0x0002fd7cc9dfed18,0x000f048bfd16a8b9,0x00002ef21c9d0bcb}, {0x000be2a7a86c43c4,0x000ab9dfeed3f183,0x00013c43d69b6205,0x0008db23413a7f78,0x00001d39c7d32aa1}},
    {{0x0005b43063f50fcd,0x000194e360c3747b,0x0003b425a290fd4f,0x000535e867f57238,0x000025fd6b026625}, {0x000adc9d6e1191c5,0x00026e3cd549d280,0x000ec1539adc8332,0x0000cdb1ae29236a,0x0000810251d55eab}},
    {{0x00029cb4887c43a9,0x000bf0ecbf8060fe,0x0000dc5c04dd638d,0x0005a407f09b063c,0x0000c90890142afc}, {0x000c7f52d04bee9f,0x0006e697fab88589,0x000126de25d7c826,0x000402657a0ae9f1,0x0000e4761b55036e}},
    {{0x00025a23ef5de284,0x00092f812e80c46a,0x0003fc24edd7ca58,0x000462dfde4b0b1d,0x0000cd2f0f0bb018}, {0x00086a72d1cc82af,0x000c2a483fcf4d9f,0x000519f9a53040b2,0x00086b7b2c6bb96c,0x000049adc46ab823}},
    {{0x0008d0ffa742f123,0x000a2df6bdd73b6b,0x000a1cc8e1a0bf73,0x000c4aaf283aa1df,0x00001ce68bd7aa7a}, {0x000282e1f607c5f2,0x000ef137e8b5ad86,0x00037413093d7e59,0x000744f3271f905b,0x00008c6b4eb4ee8c}},
    {{0x0005cb112391f8f0,0x0008641ea3f94138,0x000a010f48cd20ed,0x00039d7c395dd04d,0x00005c716598493c}, {0x000e3a42b6e9113f,0x00069cfdaf0139c0,0x0008a7df12e8d24d,0x00074ace4e33416a,0x0000674561bb3fb8}},
    {{0x0002c06cde003641,0x0007882475bc642a,0x0000572001a99da3,0x000608dd4b142d6f,0x000093c30c54e876}, {0x0005a56a6f3399b1,0x000625608bc9ef4a,0x000c52c2c93c2f89,0x0002135ade60f126,0x000004d9ce986570}},
},
{
/* digit=30 [{1,2,3,..,}]*([2^210]*G)  */
    {{0x0005587744fc9b0d,0x0002235a186fab45,0x00014d4716a6ca8e,0x0008e21b61f724f3,0x0000f3f72b99a2c5}, {0x00080e1a9312fb07,0x0007d9cef9613e14,0x0003e5490ac148ab,0x0003955a1c207543,0x0000f96356794b0f}},
    {{0x000819be29f68267,0x00009fe4deb38664,0x00050b6e73cb6078,0x000558aacd6e06b1,0x0000279daf8f7d63}, {0x00018e07f25095c8,0x0008331cfc9f5f26,0x000782972feb9f2c,0x000658f802fca94e,0x000038c50f53e7be}},
    {{0x0003d4ddbebe9fdc,0x000143df4bab03d1,0x000400f0c967a672,0x000eb663cc254819,0x00004477f6a2dd2c}, {0x000ee0d4c3d37c69,0x00009f15d2633c34,0x000643fc0eb2b41e,0x00009b2d010432e1,0x000030aa45907c25}},
    {{0x000ec65be9e92878,0x000c55c6b87a3bca,0x000db423a40a8edd,0x000575f207c56c36,0x0000de77bbae2005}, {0x000580d56553246c,0x0002d79f3040d372,0x000398bd3d4cafaf,0x000cf3e0535cea88,0x0000d8835ad63a58}},
    {{0x000938515a35e548,0x000bad5845ecfedf,0x00085e8461dfb3c4,0x000503cd8b2d66fc,0x0000a93de3d98e57}, {0x000f822006f36a34,0x000a47a6f9bfc29e,0x0009551254d51965,0x000048cb979c84c0,0x00001df6019a10a8}},
    {{0x00078cab73289d88,0x000b9d9fa4701c6b,0x0003396e135bd0c6,0x000974c909a06d9c,0x000019ac99ac8f6b}, {0x000ceba50d80dbc5,0x0001303b634316a2,0x000b684d771cc7e9,0x000516e058c5049e,0x0000292ba043dbc8}},
    {{0x00038fbb6d7a003c,0x0005cf09193bfc73,0x0009d8f07894acea,0x000acadc9f445791,0x0000d19f61fbcab1}, {0x000ee3f4a227ca59,0x000da7f63d2a427b,0x000791f62bd40826,0x00024a161e806c1e,0x0000add1e908c47f}},
    {{0x0009ab29ea7ebd27,0x0005e96d975a66cf,0x00089209baa3ca4d,0x00014f686c002e33,0x00002fc9f0d6de64}, {0x0008c324e1c3942b,0x0000f90ac257b88c,0x000d3ac5c6940150,0x000a881ab7db6e14,0x000041cfa9e1e973}},
    {{0x000cd33ae6949b59,0x000c4ebf33ea027e,0x000599a62bed515f,0x00080a74262307f2,0x0000658216a1a59c}, {0x00032e776bfdb8c8,0x00017f7f1e742947,0x000e4d1cd2135990,0x0004b293f38844b0,0x00007a0099785d21}},
    {{0x00037890b4606073,0x000bb550c322b536,0x0004ba1bce567534,0x0009e06d2e436e29,0x0000a4c94f2a27ce}, {0x000138a6812a277f,0x000f29b99d6648ce,0x000a581647b50956,0x000333ece9cb729d,0x000027d4916a975c}},
    {{0x0008ffdfd9dd8995,0x000722772d432015,0x0006c364a3ab59c6,0x00070a5bf413de34,0x0000d46f8062e931}, {0x000b960a7a4ea0ea,0x000695d0db76048e,0x000e021533582f16,0x000878c9174f8cee,0x00005573b093f78c}},
    {{0x0008ee06f4cb971e,0x000eb1dfdb17fcb4,0x00055a1b0f4066e7,0x0004c7cd2cec053a,0x0000ebdb6c1c4266}, {0x000350374bfd9193,0x0007524863bd2f5f,0x000948b9fb7ad01f,0x0008761103a17657,0x000010efd69bf34f}},
    {{0x000e391227b7b918,0x000179b0e8190ad9,0x0003188ad2f3b5ab,0x000db428f6ac1ae1,0x0000ac2d65e8d7e1}, {0x0005fad05741fe5d,0x000766f6f06a7260,0x000ce0f46f458b8d,0x000fce97f099d97c,0x0000ce699ff7d01f}},
    {{0x000d627bbbfea21b,0x00065bc86f5b59c9,0x000cbb800712f816,0x00030ace738f6336,0x00006b1e3676ef63}, {0x000629b9767990f6,0x0002ea49f8676b78,0x000441c77086b44f,0x00050133cf0e09be,0x0000f290415611c6}},
    {{0x0008e4736e5a00cc,0x00089440d1089750,0x0001a583a42edd9e,0x00093fd719bfc55b,0x0000b56d2dda07ce}, {0x000d6fc706e0a7f0,0x00032881de026303,0x0005d65f6c087882,0x00067db008ec67a8,0x000014533f4dc722}},
    {{0x0002f3d088db12bd,0x000fcf97a9b2b8b5,0x00019e14ff0d94a7,0x0001362fa0525b50,0x00003579f0be0bb6}, {0x000f2ad6651cd253,0x000f8099f9cb7e45,0x000375844682073c,0x000b76f4525fe726,0x0000a75ebc0af507}},
    {{0x000f75b1f2819cef,0x000f19e282729c41,0x000e04765719be03,0x00083fadad0e2c38,0x0000a88c8f8e6bca}, {0x00095351371d8ffa,0x000a01a80f584579,0x0002533ae7490891,0x00012b5f33fb816d,0x0000bbdbc03aae64}},
    {{0x0009a60af672be3e,0x000fbb1bf99b39df,0x0003def3e27b2b86,0x000698ab5d32dc62,0x00000c7f112674f8}, {0x0006c0939385470a,0x000d3c072ad3f6a4,0x000e841d647176dd,0x00050201733adfd1,0x00008ba67afea17f}},
    {{0x00061ae2b3427567,0x000dea4fd3f60fe6,0x000698aad50aa6e4,0x000b8d08d2ad5882,0x00000e1b9baf7513}, {0x000488bb1d898d7e,0x0006ce8c0168ad39,0x00091a4ad9a1c7e1,0x000819b619ef164f,0x000047df7d2d85b7}},
    {{0x000feab634bed6f8,0x0009357dce07ffc6,0x0001f22c07bc045d,0x00020284bf369c39,0x000000ec5355d927}, {0x0004492e1ef8e017,0x000bebc2c0cb9bef,0x0007f47cb55429b9,0x0001452791fca0d9,0x0000446d21780520}},
    {{0x0007bbe224fcd24c,0x00073d7bf6169471,0x000ac5c21a5a8b44,0x00039b7699434475,0x0000c24ec0229fa1}, {0x000ef056abea3468,0x0001b5631170484a,0x00014686e31baa0f,0x0008aa6711643949,0x0000ab5fe36c56bc}},
    {{0x0000fc5e6fc64867,0x0007fa43f868a21a,0x0003a88ba36f8db7,0x0002e70eb5ad6bdf,0x0000871d27ec8c07}, {0x0000eb5d0d0dfac6,0x00046fcb36133cf6,0x000b30f407d7c7a9,0x00000d6528aeb587,0x0000c3c8285253b9}},
    {{0x00054b828518597c,0x0008972f858fb628,0x00099871d157ba17,0x0007e3f4033329ca,0x00007518282b4088}, {0x0008335b1c0daefa,0x000b28c6fa72dbe1,0x00044e1cdd57d324,0x000b9e9bd8eb94d6,0x000090a27421fd2e}},
    {{0x0004aa7033c1794b,0x000b58d101a5a260,0x0009e75d4582f913,0x000c67d11d071709,0x00000c26db9ab4c4}, {0x000e2fd553fa1538,0x00092583731d4527,0x000ab1e032a78837,0x000565e5708eb33c,0x0000c48e233e93b4}},
    {{0x0000f3606cd3c7e1,0x000f9cf3f1a25ffb,0x0003c6509d6f19f6,0x000fc6ce3b57e1f2,0x0000c8aa53c29394}, {0x00013193e35bc970,0x00071c65a63e7410,0x00003fc0f1d93591,0x000631583a7d1998,0x000061d7972661e4}},
    {{0x000f3b0ec646b6fc,0x000ab80b5bc4d4b2,0x000e871c1dc2998c,0x0006f2466508817e,0x0000fbc22289a212}, {0x000d2a00a06285a6,0x000173fe65578efc,0x0004a98cb75bf247,0x0008fac92d989d9c,0x0000948f4932b9f7}},
    {{0x000845cf66cfa8d6,0x000482a7592908e7,0x000938c783adbd0a,0x0003fdf2c40e9dc3,0x000081189439bf8c}, {0x0001dfbde2120af3,0x000ec8f666c61cac,0x000049635e3b8104,0x000b570d910b372a,0x00003b0a13fe3b6a}},
    {{0x000bc798fcd4c386,0x000e2d3e989b0ec2,0x000354b0ebfb4e64,0x000ad6b241e9e539,0x0000e64b4499f9ea}, {0x000824a5c0b286bc,0x00095daf822450de,0x000b5e3cda89f6da,0x0002c25d832cbc77,0x00009df72511f703}},
    {{0x000d12e444a0e491,0x000990d76c78030c,0x000c2baffeec0fbc,0x000f8c635cc28c64,0x0000eed641f9bf3a}, {0x000c2a90ac6e705a,0x000a41dfdafd6d8f,0x000c5e6d0fab169c,0x0009e24840dfe5bb,0x0000261cb58c5df6}},
    {{0x00068c7c8f041f5d,0x000195a9be95746c,0x000e714fd26f00e2,0x00086a2fa5e86163,0x00005265628346d5}, {0x000d2f1ae615f3b1,0x0005881ec186cd66,0x0001f8ebdd09686d,0x00062642c2578874,0x0000b8d0ec7aa3ef}},
    {{0x00058a6e2678b76a,0x000c3decc2e12e45,0x000400578f26b5fe,0x000e9c64934cdf4a,0x0000ac4e70084d31}, {0x0005269ba3707c6c,0x0000ea75e26ae313,0x00076aec64c7ef65,0x000cede81346c1e0,0x0000e7007b498e3f}},
    {{0x000ea93372944b60,0x00032e7f0407c535,0x0004662e884f3908,0x000ff3b4dba2af07,0x00002dd0c0bfba19}, {0x000a01101857f415,0x00002e9c6bfcd3bb,0x000b305efdfbac49,0x000f445da2626ecc,0x0000907070059481}},
    {{0x0007b22d683b3a49,0x0009bcf9beabef21,0x000c7562a038a49c,0x000910aa13a5841f,0x0000c9389d6162bd}, {0x00075090b585818a,0x0009316773fa9595,0x0009848a8d0f9dd8,0x0001f651555c4021,0x0000d05a8d89f69f}},
    {{0x0004d24ad962db65,0x000543238c6a727e,0x00075965517dee3d,0x000a85f8def34db8,0x00000d3a88c6d24b}, {0x00034a623ebab5d8,0x000bf7b417eac935,0x00037ce6949c24d6,0x000036e934f11b54,0x000018002a7a5455}},
    {{0x0003123c18986e41,0x0004271e4976ebd1,0x0009925168a8da06,0x0004b18aa1334900,0x00002665721f0fa9}, {0x000b0ff43133deb8,0x00000a9c1b9fdf83,0x0006c154d3516d4b,0x000d735850f7ed9b,0x0000e079bec8fd08}},
    {{0x00069c12865882fc,0x0008d9957a5ac327,0x00093aac73f8192c,0x000ceac6fcd6d246,0x000006af48a5b01e}, {0x000026027353e4aa,0x000e1c3a62c87965,0x0006a866c4b5c0d4,0x00057ef67206ffc3,0x0000f866c2bb479c}},
    {{0x0006024ef491d5db,0x0004e2704aefb3f8,0x00074dc8b5853c6d,0x00063b3be06adb19,0x00000a163a242c3d}, {0x000472d0e212765c,0x000adbffde000bf9,0x00095dfc6114a063,0x0002ffa142ae6b29,0x00003767dae16b26}},
    {{0x0004392a32caaba8,0x00067d4e7317e8fe,0x00062cd25f60018a,0x0002429928340b9d,0x0000d019c13c0075}, {0x0005df10a659460f,0x000ede055af81262,0x000fbaec0f8c8158,0x0004dd990e40671f,0x0000f1d47ce0cdde}},
    {{0x000b86d5de825fda,0x000827ad5ef1c31e,0x00017d3651481ad4,0x0006f11c7f12dd40,0x000023ccbabe1ee2}, {0x0006b90aaec673e6,0x000becfdce1eaa36,0x0004ffdf0bd56245,0x000f51bd73c118ef,0x0000fc7f3b398c76}},
    {{0x000b507845c7e712,0x00083994ff8becf0,0x000b099529c1c424,0x0000bc950938df6d,0x0000f211f0736bc4}, {0x00067c661de70ba3,0x0001d734eec5882f,0x0008914f01a0144a,0x000a3c5faebc04d3,0x0000aa86b02d5b26}},
    {{0x00019c31bec876f4,0x0001988ea72cfa1a,0x000ee8601d01485d,0x00046183d3520a82,0x000047ab80a29f96}, {0x0004251df44392bf,0x000a29983d364de2,0x000a88da2e7b5ba4,0x000954f4e59b9a0f,0x000037e6c24257f1}},
    {{0x000e6dfb09a4ace1,0x00047c55d4e26d05,0x000e515e1f45c89b,0x00043f7bd69ae93f,0x00005479b4aa9e09}, {0x000ba9bbf74ce4ec,0x000f332dccae40b7,0x00003a3676d0e1de,0x00089f9a692179b6,0x00006ac8d0990a7d}},
    {{0x000b612be9f087c7,0x0005d2b73fa0575c,0x0002ca2ba11c214a,0x000ed841f6a65480,0x00000b110025c00f}, {0x000d80afd4f314e3,0x000f3c64e352cab2,0x000798d050b2af3d,0x0004185885404c7a,0x000023d177bde8cb}},
    {{0x000178806542640b,0x000d88c52d25f44d,0x000446d579176f30,0x000397051da7626c,0x00008886aafbab41}, {0x00015912cf9cea49,0x0006e21fa90bb0ab,0x000908b221aaa808,0x0003a7333bfb3941,0x0000ff4d7efda834}},
    {{0x0006e39f3414f11f,0x0009d29f664e12c5,0x000500f05843165b,0x0007ffcb61460ce2,0x0000626de1e0448f}, {0x000c9f888fd60e9b,0x000814b7c85bdd05,0x000503d082652999,0x000f69928a0fbae7,0x000079af9aa5c51b}},
    {{0x000b748853dc369e,0x0001d5c46a9c7c80,0x0004943a99974554,0x0007adda66e0232a,0x0000290429a60883}, {0x000995ec151d853c,0x0008ff3a1822fa7f,0x0006eaede0e6bbab,0x000cba88badae027,0x0000c256d3997a8b}},
    {{0x000e2a41663b8554,0x00092366f160ca96,0x0001c123d905387b,0x00034e0adcd7509c,0x00007b1f6e4adc08}, {0x000b82f6a17de8df,0x00016127f77fa75a,0x0004d788321ad9a0,0x000a97ae85ad92ca,0x0000b54c99e120fb}},
    {{0x000bffe361a46388,0x000fa4c0605193de,0x0000fcdd0adb800a,0x000f5618356c1336,0x0000436032ec11de}, {0x00053a068b16e75a,0x0007a5a6a6730ec0,0x0001a5ba4dbd79ac,0x0005fe6729055356,0x00003a575af0acad}},
    {{0x000fdc35bf0c9f33,0x000da45b9b398957,0x000ad7beef5e41db,0x0006432a7c818563,0x00008c2e1c2b7db9}, {0x000b00db46177027,0x0003e2b378f87bf1,0x000a0f28a308889e,0x00097ba082187936,0x0000acef7ee2ea51}},
    {{0x0009390c918d6270,0x000362caac635c08,0x00015b8376799de3,0x000eaa821a885535,0x0000cabcf406953c}, {0x000d04fc7648475d,0x00098dc7d882d0c2,0x000aa0b4c0a7dc6d,0x000adf01bdcf234e,0x00000e2626b268f4}},
    {{0x000220825ed35afa,0x0009576f7cccbe00,0x0003a8d37c11d3dc,0x000bd7a0701b842c,0x00007dc318423ed8}, {0x000dc6851e23a270,0x0001482baddbc17b,0x000ef80594dcf07c,0x000635f48b62fcd6,0x00004ba3f7faffe9}},
    {{0x000df3379d5aaa09,0x00053e95a9719715,0x00094035e04096ab,0x000371086a53ef79,0x0000479c7b8f06c0}, {0x0006071ec85431de,0x000b4d8ac75c33e6,0x000b91fc3cf2421d,0x0000c5a713565a6e,0x000093f6b5095293}},
    {{0x00053433c213411b,0x000f19421558a32f,0x000cb3419d7893da,0x0003e94fca316dfb,0x0000374884a86a35}, {0x00018637e8891bd7,0x000dda699e3631dd,0x00099f03059dff7f,0x000c475d060ebfba,0x0000bdd0e28de233}},
    {{0x0008625a553631ce,0x000a9796b7c66042,0x00069e1a8d149b49,0x000b9d24bf15c71d,0x0000499b36421998}, {0x000c53bf713ec42e,0x0004b77890566781,0x000528324cc47d1a,0x000e99ee4752d162,0x0000b9b11a1afa93}},
    {{0x00081a0ffb5c9c9c,0x000e055f0aae4142,0x000f67533c055cb5,0x000ba1661d64b05f,0x0000d37a37649d4f}, {0x000fbbba5ad491dd,0x000cf8282ecf7198,0x0005ccb6e6b04c81,0x0007ebe65a66949f,0x0000c80d786e0584}},
    {{0x0008203f4211c7b1,0x0002f22609747204,0x00046dc191e8d62d,0x00019cebf4ef9152,0x00009163ffa00eb0}, {0x00076e6fe036a5d9,0x000f17c8eb9e7d4d,0x000b94224aca7e98,0x0007dafc52c4dd07,0x00008fcefbaee74b}},
    {{0x000f5f295afbe525,0x000dabfbf6f56e65,0x00029dd9bee154ba,0x00075fc7e43056b1,0x0000c6703f05bb43}, {0x000575770ca61480,0x00034ab150f37095,0x000ceacefada8fcc,0x000f68dcc0b53bd8,0x0000e9010313dffa}},
    {{0x0003c71f5c8dd248,0x00064afb2df6f44b,0x000c4e22d86f05fd,0x0006bdb2e524154b,0x0000823ebb857629}, {0x00050ddefbd1fc06,0x000d57e3a6573398,0x000e9fd87a05db65,0x00097c5a82bfea97,0x000012602f1dc978}},
    {{0x000d464401ebe000,0x000aae7249d91866,0x00036dc90713e6e6,0x0005568974870842,0x0000783ee0137c6c}, {0x00074662eccf7759,0x000d7f6b891712b7,0x000f43eca62ac342,0x000072ff0edd30ee,0x00008a7880f860aa}},
    {{0x0006cebf5ed71c29,0x0009efe22291ed90,0x000b496537c3d7bd,0x00085a93bb5041ed,0x0000dfedb68b74e5}, {0x00072c8d5958c8f8,0x000afb5d5f31f91d,0x000f4d874ee28bf5,0x0004f7e7a69fd006,0x0000529fdae49ca5}},
    {{0x0004deb5cf2cc3c6,0x0008c9d887dc815c,0x000d6a375e22f1ae,0x00076773ad520b03,0x0000de108610ca0d}, {0x0004e8cb47e14977,0x000ad0aea66d4a4a,0x000783042dd19814,0x0008d9e54672563b,0x0000b890128daa2e}},
    {{0x000808410ee3d23c,0x000392a615b14640,0x000d2683f464306a,0x000bd3ab01e405c2,0x0000e70e8511df3b}, {0x000fdca6a9e839a1,0x000c9403fb89e6fe,0x0006a9fa129439dd,0x0006d65462b965b3,0x0000f3fd2b9110f6}},
    {{0x000afdf466dca9a6,0x000ca27896b1bc08,0x00026b7aac5ebb91,0x000b7ee6800bd153,0x000059f83a9b154b}, {0x000160df796189f5,0x00088ae54694e160,0x000d66289e9c55c3,0x000b00a2b43c3c19,0x00003413ff683fcd}},
    {{0x000aad2f31e88186,0x0004568332d1f745,0x00085e5b8099a8b9,0x0006911240d922f2,0x0000f5f060aefdca}, {0x0008a8cc9a6632e2,0x00009a8ad40a2cac,0x000b2ec9b7267e5f,0x00067797ad93d424,0x000056880826d350}},
},
{
/* digit=31 [{1,2,3,..,}]*([2^217]*G)  */
    {{0x000c5b31b84523e2,0x000be6e4ef99ea3b,0x000a69918305e9d7,0x000f226013092787,0x0000aeef51df4898}, {0x000935d577020efe,0x00047c06a751ec81,0x0009737700fb9a01,0x0008f210ddae1671,0x000078a0d0f4c882}},
    {{0x000d5e8ccd993818,0x0000454160028f27,0x00035c9e5ac962fe,0x0003961bd348325d,0x0000f7888f9d08c4}, {0x00028e7cc2ce2849,0x000864e2a7ab864d,0x00004f4743155567,0x000056ef40757409,0x0000de9ba7203fc3}},
    {{0x0005c0ee77817ffe,0x000841cea362486f,0x0007dd9962de3465,0x00073b6d58d6ef81,0x000092b6a9f738f6}, {0x0008e609ec8a67f5,0x000d874bf95d4493,0x000f082668cc88ea,0x00018e51a53b6999,0x0000c44968fda017}},
    {{0x0006d9a9c9c7ecd6,0x0004277106c7b597,0x0006ce73e23fd318,0x00098a67c30e1c70,0x0000f0d0fe2ac602}, {0x00005926a46c71a3,0x0006512eff4774d6,0x00068ac6f253f036,0x00014e045f24b5e9,0x0000148b466e0cd7}},
    {{0x000fcfcd84a929d3,0x0002ad54a2149937,0x00096084028ac0c1,0x000a98eb3a256be9,0x0000a028f7a712e1}, {0x0003ed11da5648c6,0x000765175dac0cf5,0x0007e6793730e016,0x0006e12887741adb,0x00007b90747e694e}},
    {{0x00095060b7f3155e,0x000baaf4df36ae23,0x000b773beedb6ad9,0x000e9434c85948c6,0x0000285db363d9d0}, {0x000ba7a7d1c9fea8,0x000fd444e8a8f514,0x0001079dfc491f23,0x000423e35a941ff6,0x000029feac4a3859}},
    {{0x000f263a7b127166,0x000ffda74297f963,0x0000d25cbda01050,0x000eb7ffa92a1540,0x0000d4cfd6140a62}, {0x000ec796b38c0f5d,0x000b3301612e7e11,0x00088f375bb456a6,0x000f1d2e639ccef5,0x000023c5b7ec9322}},
    {{0x0000d0706eeee3b3,0x0002383bb3c41af5,0x000789d57412b36c,0x0004f76f161f4348,0x00009d54f9fa323c}, {0x00098713416de57e,0x000f289880622fb7,0x000ffa44b6065378,0x000ae646228a95c0,0x0000e77ebc11e012}},
    {{0x0002e057a7667ee3,0x000980621f16ec01,0x000dc6a70ce7de5d,0x0000ab25dd09f571,0x00006ba631c46be3}, {0x000a3ceb0468f0d6,0x0005cca0a4b4f979,0x0006814d43b03db2,0x000c037bf72fa0df,0x000070b2e22306cc}},
    {{0x0006e4060e56d291,0x00073f9eac2a60a7,0x000609574bf57884,0x000850711a75007e,0x00004257875312d3}, {0x000515eddc745f56,0x0008085a3ecc7070,0x0000354544ed84c9,0x000a74204234e39c,0x000012c06b29876a}},
    {{0x0003f156c03f4661,0x00016f589034ebea,0x000b6ec7176a4552,0x000ff259e041df5b,0x00004ed99b1037dd}, {0x00086d386ad2e060,0x000fad2ab5238d4b,0x00011e6c46846865,0x0002b3a450957a0a,0x0000c5d260143d1e}},
    {{0x0008e38152258344,0x000fef5032e4a93c,0x00001424b43ecac7,0x0006743325458b93,0x00007f95a9785eba}, {0x000a205186d9025c,0x000035a7fe558fef,0x000a3c8776c0b58d,0x0009496073e77a5c,0x0000b53d4427a2a0}},
    {{0x000aa0fa4a2e211c,0x000f72cc7932a003,0x000c29fd7e905873,0x0007a0116f12125d,0x0000e442886f9b48}, {0x00007e055af80e44,0x000c596df90f2dc5,0x000d6c18109d73f5,0x0001df729ebcf653,0x00004160bd446d9c}},
    {{0x000fd2d788ba6520,0x000d76ff5738c9bb,0x0007fb3242d9cc46,0x0003339c8d8920af,0x00005c508f078998}, {0x0009e3679f4ab8a7,0x000e2634f4ee182c,0x0009bfae6cc835e1,0x00046a9f81c34f84,0x00003d0468bc1916}},
    {{0x0003b15660f59ef7,0x00088c12554eef23,0x0009330a3a321c51,0x000b3626b05480ad,0x0000c022c30d43d6}, {0x0000661046f68e00,0x000e80e8e9ae5d65,0x000b4697993ae49c,0x000eb1d32afb6dc9,0x00003f033a44cbae}},
    {{0x00087e5163cbc0a8,0x00006ae98f3ee679,0x0007b68448c3e107,0x00085d27aa4bdafa,0x0000aae2dbd0b3f1}, {0x000ac1ef01e8f3c8,0x000854cda9282656,0x00092a068b13fa74,0x0009658322dae1bb,0x0000f651015f4306}},
    {{0x000161d5feff15b2,0x00050345887b8e42,0x0007f685e1f8bca9,0x000a5e069e055b08,0x000014e3f1706090}, {0x0005bacd466e93c2,0x00024cc6b95b9719,0x00056a22d1b25609,0x000c93c6c0448103,0x000081192897bb0a}},
    {{0x00036a0c08a594ea,0x0003b66986efe95b,0x0002f86466896b35,0x000998b3227efd50,0x0000227f683c30e5}, {0x000dc9ff42ea5c5c,0x000e34f0f1d46fea,0x00047ca2cad6837e,0x000856ab3a67ba93,0x0000f0eb2cce452f}},
    {{0x000a1589e0b82fbe,0x000de449e007aa58,0x000d14a4ee633c68,0x000e61af8fef7e89,0x0000f60872f433ac}, {0x000016d64afd1619,0x00060de62c698aca,0x000269bb3d24f6f1,0x0006b7f138fd2d41,0x0000d75248556ff5}},
    {{0x0005206689b92bee,0x000843322d9c7cc9,0x0009915cd7756249,0x0003f02dfc1956ca,0x00005236e7bf69e6}, {0x000a95adca139b5d,0x0008994070b778a3,0x000f73bdbd4254b2,0x0000abac251dcf19,0x00001d28ad0b0466}},
    {{0x000a1cb8a87fdd06,0x00090886a6941375,0x00048f1903f9324c,0x000cf3376989c09c,0x00008b982f180de2}, {0x000716ea40012c9a,0x0001f5874d1db96a,0x000ec9471af0aa5e,0x000a1ab118cd78d2,0x0000f9537952f8cf}},
    {{0x0000b7eee1e1bf2f,0x000297cd743a214a,0x0006a906ae3eb720,0x000f876830a1a414,0x0000eec17838e9e3}, {0x000c737251493343,0x00025cba6f7cb12f,0x00039b703deff11a,0x0000f4e3aceabbfd,0x00002ffa04f9bc74}},
    {{0x0008f06e2aff6bdd,0x0009c7332d94e0e2,0x000f1e13c0a81628,0x0000ff353b4e659f,0x0000c3f048b4016c}, {0x0002e01399fc2da4,0x000c7348679e5b47,0x000abca0e8e7b659,0x00038dd0e20e577d,0x0000dd894b007fae}},
    {{0x000396824f4dbc09,0x000ef06eb9cd7555,0x0000b18acd3df1a5,0x000c18b8dac35ee4,0x00001c7903921397}, {0x0001731faf0f10d2,0x0002d760c1326c4a,0x000f6f5ffea89051,0x000fc39c0f9ced36,0x0000da37d490e5c2}},
    {{0x00023c3b69935ff7,0x0001b3e28de35919,0x000607e0e5dba168,0x000e0a1c7a1ab695,0x0000bc842d58c6bb}, {0x00050d68e758fca3,0x0000ca556db21bc5,0x00047dbec3ec857a,0x00078a4f47c22922,0x00009b45db21fb1f}},
    {{0x000d2b6ed3921dae,0x000414a6a41de350,0x000e1bfe1f418863,0x000a7247d4440aa1,0x0000b202e69be99b}, {0x00035efe5f191a91,0x000303646d9b68c0,0x0007fafb6834e5cd,0x000afd13b66152d2,0x0000e96ff34fa402}},
    {{0x000b50e619a7cc77,0x0000dee84fe2d25c,0x0007ba3f798fa246,0x0003a2051c8c69ea,0x00001559f9755949}, {0x000191005085716a,0x00048db5ae91d058,0x0007c9a5df811350,0x0001e3e76081f3fe,0x0000a0f5614b8aeb}},
    {{0x00018f0a36ef4ceb,0x000febaebf8d4eae,0x000e5c11972c983d,0x000173cfd8c7fe1f,0x0000ff0b6553b58d}, {0x0009033ebd26a6ee,0x0009ca7741c57b63,0x0006d6d0466228cd,0x000813a88d56d595,0x0000001ac00370c6}},
    {{0x0005d49926257fb8,0x00077f587dd695d7,0x00072592f34e8e90,0x00023c28f9cfa11c,0x00008d9950a9e218}, {0x00075ebe481c5af1,0x00050e45ff723481,0x000f61f5abfd66c4,0x000a368b3c547be6,0x00004be914ed594c}},
    {{0x000d4cb73f9b6f7d,0x000e6906174ac89e,0x0004880c64f0fe98,0x00036ab58f236e04,0x0000e2d38bcdc3ab}, {0x000079f3c7af69a5,0x000d95f71ef374c3,0x00041a7447c72579,0x0002667971715ac4,0x0000cb5f998473fa}},
    {{0x00092f2379f7fce1,0x000b91a877864bd9,0x000364c15e47690f,0x000ea25416b9dd02,0x0000a7502960f53b}, {0x00054d4ece71149c,0x00063a28d0321ca5,0x00027b740cac9de6,0x00064ca0b521c06f,0x000059d3a7108c18}},
    {{0x0005870ea005a99e,0x000ded4e493a6467,0x0008b6342b1f047f,0x000374e92a439f17,0x0000a8cf07331051}, {0x0000b513642fc657,0x000dc5e958827812,0x0009b568996f4efd,0x000bfc8f6ef537ee,0x00006743642f3440}},
    {{0x000e3950009e8bd3,0x000279e9228e1db5,0x0007ea75e0e087a5,0x000f0b16adfbb8b1,0x000019ff54645b70}, {0x000dbac58096735c,0x000bb470fce96e38,0x00074907665c92ce,0x0003152b53c9925c,0x00007fc121cadb2c}},
    {{0x0002ee6e219e439c,0x0008fe4475fcfc8f,0x00032583de9c8ba6,0x000c3513fd771433,0x00001a001f040451}, {0x000cd5f7de1cf983,0x00085bb184294f07,0x000f814357b1fe00,0x0001ccad465687a2,0x00004f0c50019ffd}},
    {{0x00030d60cc283637,0x0007dd26a89da97e,0x000f66c26f3bdc24,0x00028716946a9f2d,0x000049a732f2b2fe}, {0x000eef2bd92b8614,0x000b8f3412a393ac,0x000dd110fa90e595,0x0008b581363eb9d0,0x000070f21b629f74}},
    {{0x000fad5927308e4f,0x00030bb54d64004a,0x000a41ebe0fe1a31,0x000560cebeee51f9,0x0000dac11edecab6}, {0x0001e3b630efedfc,0x00077c2beb530f9d,0x0005792e9f5dc319,0x000a71d1a7ea1706,0x00007af663c8c1cd}},
    {{0x000da7bfbd9bb256,0x00088f98890312d0,0x0009548cec55316c,0x000574630b21bcd3,0x000068afb84e9c85}, {0x0009deff6c589987,0x0008e55e9876e7b2,0x000294123dbb7769,0x000712eb8772a9b1,0x0000839395ed1e6f}},
    {{0x000c0a30eb328e86,0x000d5f3a638185aa,0x000c9547dffb413a,0x000f6fae6f8615ab,0x0000e8a6e4701dce}, {0x000b06cc1508bb6c,0x0001b02dbc1f68a9,0x000300f8c0971c4b,0x000fcc371a6d703e,0x0000572fdf15650b}},
    {{0x00014db965071922,0x0003fd3a06369215,0x00011156ac525f3f,0x00027cdb39a981f8,0x00009ff3e0ddcbaf}, {0x0009eefc2c911a83,0x000dae8564210d12,0x000e48efd1688b3d,0x0001eba6dd9308c0,0x00001e6c71545583}},
    {{0x000239152df58a36,0x0008b88e7897dc94,0x000725ab0da0e680,0x0005712ab70e052f,0x00002dfafe3d4212}, {0x0000c2b547371a4b,0x000f4634997de154,0x000cf959ac418e8c,0x0002b4c8fd0e263e,0x000002ca92f3a644}},
    {{0x000805c84e906013,0x000919f4512d7d81,0x000b903bdb4e8554,0x000102020b9b4abd,0x0000a2f04651f18c}, {0x0006d4fa96d8846c,0x00065f0a7d84a420,0x000a4f5352b5e62c,0x000aebcd087cf50a,0x000089c1c7665b9e}},
    {{0x0008e8c15f4490e1,0x000c711806b5723b,0x000f3dfcc9e3ac69,0x0003592e9cdffd09,0x0000676c5f59ab6b}, {0x000e90769fc0122e,0x000ab513ee51387a,0x0006265ef72c716a,0x000395f648e85a3a,0x0000f4445a0a69c7}},
    {{0x00018151ce7faf96,0x0000532c5b17ec8e,0x00077e27fb8ef2dc,0x0009410a4e7962b7,0x0000c7bebe0dfb90}, {0x0005b36791119157,0x000f9791b658b9e3,0x000be736d2983a2e,0x000e11010136896a,0x0000c94c6654ec0f}},
    {{0x000406ad44de0c1b,0x000c823978422f9c,0x0006f3621ed79654,0x0001a45243e9cb05,0x00005a526aaf5259}, {0x0006e9a9952c4041,0x000855d7a5dd0ef8,0x000dfa8b751cd3ea,0x00025c3d5a28b82f,0x00002a085cddda12}},
    {{0x000574c792dd046d,0x000f5db7e04c0de0,0x0002d73f5299ae27,0x000f2bc6f076a4c8,0x0000f2221a703b2e}, {0x0002417d54d5b7b6,0x000fc839da3fd624,0x00044fe6c06c3727,0x000aaebb622fca7a,0x00001614329d0960}},
    {{0x000325aa1dbc71da,0x0003a3f618cb10ed,0x000260f367d91c3c,0x00030ea528ea5e8e,0x0000e7f55131cb6b}, {0x0004e5c73aafc584,0x00007632d1f4e563,0x0003a9ada2a5f580,0x0003d5c9f78e98cd,0x00002612d9f9a844}},
    {{0x0003160cc8cf665b,0x000e9e2cfb82d281,0x000edb5756ac3c06,0x000e86af8cadc78b,0x000071b8a8a9cc1f}, {0x0003f77d6e5686cf,0x0005209f60fd7801,0x0008985728540dc7,0x0000e66d1006fb9d,0x0000dc1d2d11771e}},
    {{0x0004b1a3a9ebb91f,0x00079e23c8e26301,0x0003f0318faa7688,0x000cb05ca5649a17,0x0000ebcaa67af4d9}, {0x0002c158208295bd,0x000371886d2c6ec3,0x000e776fbf3d9c03,0x000b7362ad550edf,0x00001334c9a2dcf7}},
    {{0x0005cdabf52ae483,0x000f0023da388f9f,0x000ea4f0b62843e1,0x0000cd6ef53468be,0x0000740e9f1ab937}, {0x00048cac670d194c,0x00029ef042cd432f,0x0004ca10792b2164,0x0001b35141393fa9,0x0000aa5fc8cb5d0c}},
    {{0x0000b35727eb78be,0x0002fb568e8e3d15,0x0001e26a3e2ebfea,0x0002fe87e6eee810,0x00002e0c18aae6ca}, {0x000ae2e653b7bf2a,0x000aaae347811b25,0x000b752f14d7c1f6,0x000db47d5881de85,0x0000780051b01dcf}},
    {{0x000c69e25aa2f590,0x000fcfeff037dd97,0x0006795b3afeec1a,0x000072a7aa5584f8,0x0000bd60ddffb0ab}, {0x0003d1d63579ef96,0x00038bdcb0ce53e6,0x0004cf4f0c7d0452,0x000c8c0caec14839,0x0000f6a443c4bfe1}},
    {{0x000aec68e12bb566,0x000cadd2bf62c823,0x000164fe059a6763,0x0005e5b4c9c33897,0x0000c530539c6f12}, {0x00069d17e4ca16f3,0x00092006835fcdad,0x000446dd2c99910f,0x0006bb216844cce3,0x000072cda8fd616a}},
    {{0x000043b5b6bfe4cb,0x000c16005febbe5c,0x0009968d097918c5,0x000f4e4a462373a4,0x0000b41b04486447}, {0x000539244c050f62,0x000a32282ebb4b0f,0x000cce069df1c278,0x00019d3afcac56b9,0x0000055958d3f6cc}},
    {{0x0005beb93e6a98a7,0x0001afe915c2b32c,0x00073fe92bbdb3df,0x000079b9f6b3c836,0x00000e14fe20db48}, {0x0007c1023143cf73,0x000f8f3cb4626a39,0x0004f700663c36e3,0x00032fd7c3f3a263,0x0000681de4ac3a90}},
    {{0x000e480c11b6a9ee,0x000d18da2ed97ee4,0x0008b99486776294,0x000a1dcdde1ed3b2,0x0000d4858b9d272d}, {0x000b8bde14ee45e7,0x000f52dae44f1c3c,0x00050b513d37586f,0x00076d444fd07f6a,0x0000af995ed1d2ea}},
    {{0x00044d16e12de73c,0x0008fa09833ad676,0x000cd6eff8c6eec8,0x000211ef8af11042,0x0000dde13acc2a1a}, {0x000e1eb4ffd0ff5c,0x0007d068a68888ad,0x00042fbf6b645660,0x000e072b8fa57096,0x0000277b6578737e}},
    {{0x0005f4f9aa856e82,0x000f2619d7efce68,0x0003de1a8a355582,0x000a02db631aaf40,0x0000ab82cdeda7bf}, {0x000e072b3caaef56,0x000a8199f1d82785,0x000d0fbdc36aed81,0x000cf338edd76909,0x0000ee323f0115ec}},
    {{0x00091002ce826ecb,0x0005070eb620e97c,0x00030a866284171d,0x00087fc5ea32117f,0x0000e6dc3918a37d}, {0x00077c1f1c8587bf,0x0006106dfc0658fb,0x000423e93d2aa347,0x000d9893fef10a37,0x0000e7353a966099}},
    {{0x000cd1f4fed94fd1,0x000122df66a25b2d,0x000312cbb38fa84c,0x00087fa9de6e108d,0x0000e58b82e39071}, {0x00062712709f1afb,0x0008220f16bf0299,0x0000e9cc7fc74306,0x000d421bdb073052,0x0000513ee8efcfab}},
    {{0x00068279bad9b185,0x000b327666c7d175,0x0008c9c1dd36184d,0x0004cd676a4d1d70,0x000008a102f5f44f}, {0x000c7971cffbe4aa,0x0003a2729dcd0b70,0x000906aa5389c9b7,0x000ba57ecfcc1302,0x0000e349023971ac}},
    {{0x000f9aa0de1a61d9,0x0001f5fa5b318663,0x00043909cd0eb9de,0x00070dd7cd579618,0x0000a3eba0c2f73f}, {0x0001563d342860ad,0x00037b084a171284,0x000349978d04890b,0x000779882982abae,0x0000299f32178cc3}},
    {{0x0009f8c49c28aac3,0x00063d222aa77172,0x000103c13f3dda6b,0x000d9a62596af21a,0x00005e568bfd037b}, {0x0001e0a3cdd62251,0x0008c79442a934a4,0x0005966bddbc1924,0x000d996eb83bb296,0x0000d90edb6dce94}},
    {{0x00040493f8013851,0x000ede0d970de34f,0x0009faf7a3b27f40,0x00096ad59ba58757,0x000057262f97764c}, {0x000fd035bf8844cc,0x0005a298a25a667c,0x000fe862aa4f48dd,0x000cfe02fa51099d,0x000012af89f023a9}},
    {{0x000031e9fdea2db1,0x000832d1378f3a95,0x000a5138980ba7d5,0x00069a4bbdba0178,0x000013224e7af549}, {0x000465bcc967c9e7,0x0002d4159c9f2428,0x0007c9b27802478e,0x0008fa77cdc3d6ab,0x00005eb845feb91c}},
},
{
/* digit=32 [{1,2,3,..,}]*([2^224]*G)  */
    {{0x000b2d9543778c7e,0x0000f184ad17cd35,0x0009a46cd9fa03ad,0x000d6d473d03630b,0x0000d62ab38692bf}, {0x0004c753b746abb8,0x000a9805cc3c45f4,0x000dcf780bd4f09d,0x0008b45e59befc01,0x0000428ee8930818}},
    {{0x000e7e4fe75c81d7,0x00043a055bf3f186,0x00035ef774abdc47,0x000c9255708754bd,0x0000dc4ba227334a}, {0x0008b967e563c5e5,0x0005ffd12d0380e3,0x000770a428f47d00,0x000757a882b69d41,0x00001a9a96d95f73}},
    {{0x000a784242f916eb,0x0003881ba08bc794,0x0005598b45b14359,0x000d754b78024dc8,0x0000f1f6b99a6382}, {0x000032cfc2cfa484,0x000c8e929e3f547d,0x00059d8829cc674e,0x0003a46aa7f2ecfc,0x0000788320c644f6}},
    {{0x000719cf322c469b,0x000508f3f43cf975,0x000e62459967e01c,0x000174d43d2e7f3d,0x00008d9e6307095b}, {0x00021eba643504f0,0x000978c05daa5177,0x000a1e00ca592f59,0x000eacc0e1e26416,0x00003636fec99769}},
    {{0x000f92768319d8df,0x00052450c06acb5c,0x000f8507a4008c6c,0x0003b281d931f721,0x0000415627b3750a}, {0x000f1a6fba4408d2,0x00097d431af170c9,0x000e56bd0b53c06d,0x00067f2c806e5c24,0x00008d4461687aa1}},
    {{0x000c802e66289036,0x000a3e8fef25bf13,0x000531667a83b699,0x00062916e69a9032,0x0000326f5c93428d}, {0x00025675e2faf33d,0x000b9c7672692bbf,0x000dc358ce94e379,0x000e142af942870d,0x00008672198b68a5}},
    {{0x000f91306ebdde85,0x000deccb55825166,0x000e2bed929a65cb,0x00089e0295a92cc2,0x0000e1f181df2c17}, {0x000223e7b6db2362,0x0001fcafee6e4f52,0x000d6487f3719ea2,0x0007b3ae4fb532be,0x000028642271114a}},
    {{0x0002cedb269ab580,0x000d60cc26c5261c,0x000b8d89fae34d79,0x0001b3b61a336289,0x000038143332f363}, {0x0002e8df47ebad1e,0x000adec248835328,0x000adff3c2c72144,0x00017c5c7e5f1fb4,0x00000b437c44a55d}},
    {{0x000f096ee9f20f71,0x0002602065c66848,0x000be0ba3d5ed400,0x000170008711a9db,0x0000c675cabb9082}, {0x00001a5382a25585,0x0009146dcc0627aa,0x000b9e8cd2497f62,0x000ce9d3863516a6,0x0000450d5c077a1d}},
    {{0x000bb204eb1ee993,0x0000248697876b8e,0x0009b153201c458b,0x00061176db7875fa,0x0000a7194d5e99bd}, {0x000677cfea8c0c4a,0x000a3b5e4b4ebf64,0x000a40a1a68a382e,0x00017da42f53941e,0x0000cf37a3fd9a99}},
    {{0x000f89d531aa521b,0x000d2cd651bbe08a,0x000e4807dc9acf2e,0x00064b6fd48bb09e,0x00000c23a0ed988d}, {0x000accaacd9c0465,0x000107b9102820de,0x0002f26b1b74087c,0x00024fc03e2a1a8c,0x0000e96ef37c79f5}},
    {{0x000728e8507807fb,0x0000036e51fa4423,0x000c53ff715475b8,0x000abd5504dd5344,0x0000af2d60b21d24}, {0x000bcbc1aee6b633,0x0005403e9323219e,0x000c98408f908e14,0x000b388b548ad17f,0x000090118c4e2230}},
    {{0x000dee15b199bc28,0x000c3ec9bdce59de,0x00065ca517f3fca5,0x0008ae7e6b17138e,0x0000784fd240f6aa}, {0x000b34895517b55d,0x000b5fbb4bca8fc7,0x0009e51560b1461d,0x00084b390e438efc,0x00008237a0c71050}},
    {{0x000f4029482f6db1,0x000118db548d0404,0x000c18f0bbf747da,0x0001ad66134afd23,0x000094dcd37be9fe}, {0x00063b0dee6fdae6,0x00067ddfb415ac18,0x00080f9c5669ba44,0x0006d1752f950c9f,0x0000804af7be1120}},
    {{0x0002ac943502b506,0x0004a8db8753f15a,0x00091c2ab67133b3,0x000a77d46c93c8cb,0x0000eb11fc244912}, {0x0007ed2e8e4fb729,0x000c26141a84a0bb,0x00028a4201f1077b,0x00044796a9fb7240,0x00008a44d90c3a6b}},
    {{0x000b1148a2a41ffc,0x000c4865b95ebce8,0x000339dcdf6479e2,0x0005ca788dbd8b54,0x00002ea6baafdd0b}, {0x000edbe9b9fed913,0x000b6fe6b2206245,0x0001105f7b61f901,0x000d311b9cd2149f,0x0000736ac5f8b6fe}},
    {{0x000559ba097b695f,0x000aa4c95ed7fd2b,0x000e2778f8711990,0x000cdc8cbf812ce5,0x000005cbb9ac407c}, {0x00027bd9059f0688,0x00032d37e6550791,0x000b95e9ffc012b5,0x00026ca112f8f653,0x000081248e6edfeb}},
    {{0x000fd09736f5292d,0x000fed6e1546c027,0x0005355f15af57c6,0x0000dd4d11a6061f,0x0000478b38244148}, {0x0002a6999d7e8576,0x0007e0506d5152b7,0x0002a801e7ac65ff,0x0006595b43ed6866,0x00009951fde545e7}},
    {{0x0001a071295d542e,0x000a51a0cc328460,0x0007e1fe3156a9fc,0x000d31bc6de53c42,0x000060f47cd2c597}, {0x000fe89df3012d41,0x0002da5a61ccecc0,0x000fcc1cfbeb7505,0x0003e0edb233e400,0x00001296a606f2cc}},
    {{0x000af7da8d3682b4,0x0007212de42eeccd,0x000e95389b488c0b,0x00018a5aeeda5a59,0x0000474193abe0b7}, {0x000ee97fbc642a3d,0x000cfc9230f0fde2,0x000e131dd8901307,0x000d7c11c9bdb27c,0x0000d12ac316724b}},
    {{0x000d17162e8e5a89,0x000bc66e49efb223,0x00032c9d77f37db3,0x00008043efc71fee,0x00006af3cf6922ce}, {0x0008b9edfb4d41be,0x000844d25cc9d80e,0x000b65b33958a078,0x00079779756de346,0x00001047c9633e6c}},
    {{0x0001564562861678,0x0007624f5cf93034,0x00042ddd963d4ea7,0x000eaa5452277ebc,0x0000f778004d947a}, {0x0001d5def2c56adf,0x0003ae9887f18ecf,0x000a1bf7ebc72b29,0x00097380809dd58f,0x000017a4ef6dc806}},
    {{0x000ffbc9689eda66,0x000883cbbaca1e51,0x000bd0b4d8274f68,0x000fe6bc2914046c,0x0000ec4eebe6b263}, {0x0005ffb314eea5f2,0x000725a4dacce9fb,0x000c953fe6a21a13,0x000ec703932270ec,0x0000c0a405e7c67e}},
    {{0x000c2104134b7fa7,0x000cb3ca29958ec1,0x0005393c52936dfd,0x0004c4da1702d97f,0x0000076b85955721}, {0x0004e97b47458ce3,0x000b0255e87b6495,0x000978b25d48c2ed,0x00049992e3869a33,0x0000244683c71001}},
    {{0x000bbb5e9143e442,0x00055db9d859c5c0,0x000375cb2b951190,0x0001b1733a3e81f9,0x0000ac5b03ec9ddb}, {0x0007d302948b0cd7,0x0004f9a6575ac87e,0x0007e4790e2f1bd4,0x000630d239465cc1,0x0000495665c00aab}},
    {{0x00003d0220dd5b89,0x00050373b8bcb287,0x000b0ad2922a78e9,0x000846833d2f1554,0x000074a397b3fb03}, {0x000d9918bc837c91,0x000769a8126c6a24,0x000f1b5a8b117dd9,0x0001af8d5aafba53,0x0000dd131159eb82}},
    {{0x000a397f380ea2a5,0x000e34cd48b2b67c,0x0008c1b9089a0492,0x0000b7cfb2598235,0x00000f8994fbca51}, {0x0001ef0d4dc6c624,0x0009298199b2a1ec,0x00087db3d9e0b8b3,0x00099bbc93b64cd2,0x0000cd843c51f5fb}},
    {{0x000f2327e09ec79d,0x00048f5c71fc1d62,0x000a82286325e75b,0x000fe92ccbe59c8d,0x00006fa414a59f54}, {0x000724008dcda821,0x00010b18f8339015,0x000cf347b8cc0b11,0x000128d6947544c4,0x0000ee012db1fa6c}},
    {{0x00050c20403a0188,0x000194e8aeedbe60,0x0004a13ba2ac81b4,0x0004e49f3507ba09,0x0000a84889026e6f}, {0x0007b081fb782f23,0x00008c896e27b256,0x000d7b64ff3aa055,0x0008e9a6a881dd34,0x000087a29a866dca}},
    {{0x000f6328d9d29d96,0x000d08db211bfd9b,0x000196c59440e6de,0x0006dfc8e0e709a0,0x0000f9e5f4bbfa4c}, {0x000465c50215dae0,0x0005eb2929551f20,0x000717e82209b62c,0x0005f3c4562e90e6,0x0000e285dee28eb8}},
    {{0x000205c0600232bd,0x000431f8827f3763,0x000527014aa51d8a,0x000c1fa849aa3f41,0x00008ba1d2ff2e5d}, {0x0001bc02ae95f211,0x000374b719625b66,0x000a5dfbf82172e2,0x000b0210053bc018,0x0000a5c238000900}},
    {{0x0006fb6e9e7d0596,0x000bb48d628f76a4,0x000537258d83215f,0x0000496c09409290,0x000066b4a0c8e820}, {0x0001553dd1a5b840,0x00079e8bc4811584,0x00014f392f62ee96,0x0004d21271a3266c,0x0000c58bc7ed96c9}},
    {{0x000f14924e235001,0x0007aac142e06662,0x000c167087c97cfa,0x000e77976870a24d,0x000066e483cc4979}, {0x000f427bdff1294c,0x000acb0b96b81737,0x0003562de53d5748,0x00004ef798c420eb,0x0000348b0d67a82f}},
    {{0x00034268181809e0,0x000330cf8b408ce8,0x000667cd7f1007cc,0x00096db7b5dbc432,0x00004a5fdb5ab287}, {0x0000a0bbf904ec7c,0x0004515938c30e2e,0x0000e23f53a28bcd,0x0009f9b087f747b9,0x00007ca540d88594}},
    {{0x0000d0129cd59a23,0x00046c9cc596ba69,0x0006da59b804d17f,0x0003a7fcd9be29ff,0x00009391f4a28708}, {0x0002481b5b5fd7cc,0x0002560774cebe2d,0x000e9d1e0bc3a862,0x000a4e0a9a5290cb,0x00009ae842e67c86}},
    {{0x00070bee0bc209ae,0x0001fa68d56bcc57,0x000336ccfc8acb05,0x00056142ff984b5a,0x00002395e2c8eaf0}, {0x000ee62df7bd9c4d,0x000e990aead7b27a,0x0008b9905f304af8,0x00087890cb620c4e,0x00008a6a079e2dad}},
    {{0x000c8dcd3073a282,0x000eccbae3857ecd,0x0006a1bbf1f16623,0x000a2b699d780d31,0x0000a776063eab23}, {0x00035739c18802d9,0x0008be6cd5f5211c,0x0009c468c8a0afc2,0x00066879d94b3d64,0x000009f3b2c364ec}},
    {{0x000a623675caa390,0x00028de287f93701,0x00038ba2ae9ab86e,0x0007f403801b55dd,0x00005f51848e944f}, {0x00047ca0ec88095e,0x000876d34449537b,0x000f35de03bacc95,0x00060e05b1b4f1ff,0x0000e43d1be7522d}},
    {{0x00091191b64ddcb0,0x000c0794106d2195,0x0003f8ccc8b5d196,0x000c12c9dc943645,0x000075d1ab7bf58a}, {0x000f0de89450cd20,0x0002aef9f6ef6324,0x000c1a78a35e6afc,0x000a26e7aaebd3f9,0x00004364f4e1540f}},
    {{0x000647708e12eadb,0x000e541c5a2c7a67,0x00065c0fd50feaec,0x00094ee408014a21,0x000031b912b28fcf}, {0x000e4a198d6c20a2,0x00014241bc066c87,0x0003cfb9a4b52b25,0x000955038acdc322,0x000092e10576361d}},
    {{0x000de1ccb3d8e2fa,0x0007927ebdcc0d1a,0x0002337815f56cdd,0x0000d85fffd1121b,0x00003cbd45e59c0c}, {0x0007f3a600093df9,0x0008803285131a3e,0x000bc6bc473d5036,0x000a13a8c656b44d,0x00000f99f5a3c8cd}},
    {{0x000e2b91357917d6,0x0004af49c788ab9d,0x0009b75be9a83bb4,0x000609521c19f260,0x00006e8679e9c4c9}, {0x0009644a604a9c50,0x0006a166441a0a62,0x000f865732bd6b62,0x0004a024589222df,0x00009ff82ef1d308}},
    {{0x000eb11759f3013a,0x000c301c5150e323,0x000fc70dfc2b0fa7,0x0005d3b88ecf6620,0x000062d12a272f04}, {0x000692973b38bb4e,0x000d47714e446b89,0x0004821687518ba7,0x000a53ba0fa24858,0x0000f49c5dc1b4cd}},
    {{0x00074d983ef0560e,0x00040d3c61a6ebd3,0x00049367c38c1271,0x000f0b2401895ccb,0x000001ef869f5737}, {0x000614a7234ff845,0x000dea374efd0e7d,0x000f6ee62c289cdf,0x0009ae62ef2db27b,0x000014784cee48aa}},
    {{0x000159129c7218f2,0x000a4b541372a190,0x000bd9f602675cae,0x0004cd6bce2b878e,0x00002512bc39576b}, {0x000dce0a8803d993,0x000c6cb44bb6fca3,0x000f6629ead7ed05,0x000912b0c7932084,0x00004002232bf471}},
    {{0x00001d2621033b58,0x0001f8fc3dd965c4,0x000ffb247e571eb2,0x000a0595cb93a225,0x00006a8adbe4947a}, {0x00051a6245eb6e91,0x000576eef743cb9c,0x00071f3cc875e4bd,0x000d32e4f4b68e10,0x0000cfc7a753fcc9}},
    {{0x0004b5ad8454309c,0x0006a96c32757c42,0x0002adc838288f2e,0x000629309a27d6c0,0x0000768fa5916f5e}, {0x000ffe6b0e8c2f5b,0x00052be31993a968,0x00095c2da86b50da,0x0002e92416e8bccf,0x0000ead84d4d2c31}},
    {{0x0004170fe1d6eaee,0x0000fc0d00121e46,0x000299ad5553d9d8,0x000da5c3949da0b4,0x00003391fdbfb09d}, {0x000007f4de911dcb,0x000013813852ad9b,0x00059598b370cba1,0x000b9b0b5de1bad6,0x00005d49170081f0}},
    {{0x0006b63bfed067e9,0x000222470ef49d4e,0x000e7714fcfc954f,0x0003504782951149,0x0000a36523156374}, {0x000bffff641c505c,0x000a9e6f797f68f4,0x0005b45bf19da0eb,0x00014b7ce6bed3d2,0x0000cf9f5296d91a}},
    {{0x0009f207b21eb218,0x00028586cffb7a0b,0x0008f3fbd0c3918c,0x00078201c70c1850,0x0000fb503e59c258}, {0x000cfbaddcbe4dc7,0x000f3120734c0d9c,0x000bd2bfeb7c7b4f,0x0001a34a1db6fa8d,0x00005381611bf031}},
    {{0x0000a263cc6eff32,0x0002da89d5f5188f,0x000998b48a9b7274,0x000a6a1ab7e090ce,0x0000c9c108427eed}, {0x000f32ca05971eb5,0x000453079a84fa1b,0x000b8e4604f377cc,0x000af86c83784d7c,0x00008f9d8ae61637}},
    {{0x0006bab37064a7ba,0x000afe0450e00b42,0x000d6875d28c4234,0x000c62f083b2f98b,0x00000c3d4377d759}, {0x00076976a45017b2,0x000880119d2b1ae5,0x0002e89d560ca989,0x00017efbe57b32f3,0x0000d217b1d4d05a}},
    {{0x0001246609a703d2,0x0008581f5ff0012b,0x000ed431681c4d33,0x000889e339cc9e61,0x0000c41d7af37992}, {0x00040e40ee5add10,0x00035ce326c02808,0x00011acb7ee358e6,0x000753b73e148f47,0x0000b41cc70c70ed}},
    {{0x0001e8a27fc5bb80,0x00023f9ce2773a00,0x000f5d4d0de3c75a,0x000ae0e67462e5ab,0x00005f356d1edad7}, {0x0005eb5f99aa27f3,0x000299fa1850b2d6,0x000ed719ea950e23,0x000f6d30fbc3a134,0x0000c607bc2d868a}},
    {{0x000e0dfc812789b9,0x000bf86fbb02a48d,0x0004c91b7d673e7b,0x0009d220bd69b769,0x00007aa28a6d3b5b}, {0x000c81d68bb3e89c,0x000a9675845e91f9,0x00021b13aa03e749,0x000266a5bef7793d,0x00004d522c8aac9d}},
    {{0x000314f0f6a1c7c8,0x0008a2a54dd0d604,0x00034a4a739d70d0,0x000841041cd0a4f0,0x00004a610e679a6e}, {0x0004259d51ad71d0,0x00042afded7b4144,0x000ec9b81308724e,0x000c0385af63d00e,0x000069d0017809f1}},
    {{0x000cc7faf31bc33c,0x000170b86ea12ac6,0x000118a6da045fa1,0x00064c601bb95001,0x00000823d360ce62}, {0x000d0907a77ed7bb,0x000c5e207baeca4a,0x00060d6267b9621f,0x0000becb62bef413,0x0000d67d9cdb9a0f}},
    {{0x000944561b2ae48d,0x0007606ca32aa2ce,0x000a0f576a73ae7e,0x0001f59d79acd4f0,0x0000f91e47274349}, {0x000f58ed0786fa06,0x00003b6fb73155cd,0x0008196d63d3af60,0x0004a1abf0728a90,0x0000cc301947a07d}},
    {{0x000173fcda66688d,0x000968f54078a044,0x000b892a6e4f3e8d,0x0000a6e9a8aa3f76,0x000003f2358c3edd}, {0x000c73ddba515a86,0x00031571066fc332,0x0009a52dd8494f4f,0x000596f40df54b23,0x000033c2a77c2737}},
    {{0x000ccc6a38469a7b,0x0000dfeabba0419f,0x00010b4aef255f07,0x0006f5fc0d85c473,0x0000844714199f30}, {0x00044a1800f79726,0x00003e748495b202,0x000fe708b728cd1d,0x00039fdb9df876a1,0x000044dfaeed2e69}},
    {{0x0009efb3b1befb52,0x000dd3db9ff2d119,0x000d54531b9666f3,0x000ef6ae6ecaa250,0x00000a5b3d55478d}, {0x00017d0cbe53c8f4,0x000f93025e9358c1,0x000f7b33ecb21d3e,0x0009e51f5b49200c,0x0000a7b0480bbb55}},
    {{0x000419c661687e70,0x000df62ce653f542,0x000907c00a126d6e,0x00080f9eed2326cd,0x0000422a8722b335}, {0x000534595c60a63b,0x0001ede5c24ec59f,0x00040fac2dc4f284,0x000b07e5a5d36fcf,0x000093bb56108a49}},
    {{0x000250012f4ef06f,0x0009f321814949f5,0x000d1cc017a50bad,0x0007969417282b08,0x000037ff4efb3e13}, {0x00043412190a4c29,0x0004b018dc035a37,0x0002185201cb14ca,0x00062453f92f5aeb,0x00006f2a7e6de00e}},
    {{0x000cc31c7ee87f99,0x0004ff0f8aafbabc,0x000a827098c656c9,0x000768469f364b3b,0x0000447f273ba78e}, {0x00012a02b0c76f80,0x000531f409e3b92c,0x0003182511cfed50,0x000d99f57fb201e9,0x000056a73dfa1e29}},
},
{
/* digit=33 [{1,2,3,..,}]*([2^231]*G)  */
    {{0x000a2dbe215c3b8b,0x000f884ce45689c6,0x0001d2f99ea9d0b4,0x000bd1cc1cb2174b,0x000007f8af7769d6}, {0x000eccb56ca3c064,0x000c39f4aea85da5,0x000dfcc2e6466598,0x000634cd8c935e85,0x00006ec507784fa1}},
    {{0x0009bc96b496a337,0x0001a1b2a3f800a5,0x000d4849519c3461,0x000db18fc2569c8b,0x0000b3cfcd94befa}, {0x000b4eb10b12d26e,0x000c1e97882a2059,0x00063f99dce2a002,0x000c447d77efe3aa,0x0000db216f26ed6a}},
    {{0x00018c63ece662c0,0x000a493d31f196f3,0x000906fc16932e12,0x00049057ef719d82,0x000018862ee36f81}, {0x00038809d700b8c4,0x0007c005edd01de2,0x000ff477e0932f9a,0x000e87c6433b3745,0x000003ad9c08d54a}},
    {{0x000c11886bc24c43,0x000e560aecce0485,0x000f9b2977cba2fd,0x000e25b0e545401b,0x000025a455e793cd}, {0x00031a786e57de70,0x0007942d10e0c90b,0x000728cff7ca8ade,0x000d9169618b125a,0x00006ddeb0245afa}},
    {{0x000527e462b3815e,0x000471040d6d3d81,0x0006a10bf201ce2e,0x00030111185978fa,0x000050eb91c129a9}, {0x000e282a5d067477,0x00069217051858a0,0x0004001b5ab39043,0x000546a05205fa47,0x000092822e494ea6}},
    {{0x0000adf6b5dfc7f2,0x00013e0797f2d1f2,0x000d16de2c2918ec,0x000bf5a4b2e613de,0x00009b8761499478}, {0x000f016f7b3256e4,0x0003de3e31def4dd,0x0009e833ac658d9e,0x0002df9cf95488f0,0x00007b7761d27f55}},
    {{0x0005841c4e740ce0,0x000b177b99bc2a6d,0x000904ce22809135,0x00082f03a03fc8cf,0x0000705c0bf36b5b}, {0x000056724d3e873d,0x000a122406826f04,0x000e68bc339873d5,0x000fe7ba392091ad,0x00008baee7844c64}},
    {{0x000929675be6922d,0x0001213a70da1b6f,0x0009a47bf6932638,0x000303b2b11e85f7,0x000061c91b9a2552}, {0x000f571053bef378,0x0008b2051d390a9a,0x0007f02ef5fb0b6e,0x00041047f4682ca1,0x00009401362dc590}},
    {{0x0007de12cad37a4f,0x00067f0d1f0a5333,0x000e96610c120cd7,0x0006283c745aaf2c,0x0000076bfca61a10}, {0x000798e91fe1dac9,0x0001ad2dd163c294,0x000e1f0a0c8c6588,0x000935de3e18d763,0x0000ba965532ca62}},
    {{0x0007623440b9b877,0x000a956d4db76d55,0x00020f4c8385ebbf,0x000d33d8735cdb8e,0x000016f0b0a75dfe}, {0x00036c0ba0e7092d,0x000d6dfad54aad69,0x00060683455d3376,0x0007bf127965ffcb,0x0000681b61bb1f63}},
    {{0x0009fcb83e9c7da1,0x000095ad4e66dedd,0x000319f0c0213304,0x000440bc0916b195,0x0000b5e953298188}, {0x0004bdc725dd35fc,0x0002eb60236de83f,0x000f3212cba2f5b6,0x0006b84c9c629414,0x000096bd8d34a8c1}},
    {{0x0004d6dc80f87d6a,0x000f7d8a2163bc94,0x000ceda80be2312d,0x000b2aa43026be75,0x00002edd166aede9}, {0x000c606ca8c0666c,0x00010c2bcbd751bc,0x000382e1aeb1ed71,0x000c659561279121,0x000056fe8e73cf6c}},
    {{0x000adbcbc1c3b15f,0x00046039a4313266,0x0002f2dea642ad5a,0x0007adadcfbaf904,0x00007547c5c21508}, {0x00015c16ec80761e,0x0003fa9e8435733a,0x000d36a8d8a3a115,0x000a4ddd0a6919aa,0x00009e7377d0e427}},
    {{0x0006e39e2d28ea84,0x000e750985b22c70,0x00029d6b3707d572,0x0000eff5dcca6438,0x0000aefa25e7768d}, {0x00017dff52661252,0x0005251d4caff7af,0x000902575f409232,0x000c7c7a8e670e6c,0x00005774dda3abf1}},
    {{0x00001285e5eb464b,0x000cecbc4c7510fd,0x00036c854df0124e,0x0000a49a1c719cf6,0x0000cc1c52a5ebe0}, {0x00070df7350f9229,0x0001991f61845b72,0x000192d67dac63a8,0x000be321af84188b,0x0000748d9575b564}},
    {{0x000b281c9947edae,0x000fa609d25cf20c,0x000adaa68d459e53,0x000b86b0a79588cb,0x000097fec12d5258}, {0x000b88cb27d7e1dc,0x00050c5b8023206c,0x0006b92572ba3d39,0x000d3a3da394ded9,0x000058c9b408ddbc}},
    {{0x0005a17512d500c9,0x000bf90baf002f44,0x00044b074849f6d7,0x0009a667b85738a4,0x00001d723bfeecaf}, {0x00019a4f16591f2b,0x0002d5b54c67aba9,0x0003cb20eafab933,0x00052d84b720e282,0x000036c1b31c4a53}},
    {{0x000dc48359ae88b3,0x00095b94925a7673,0x000d28c38c7da6d7,0x000449b9611f43d1,0x0000507e76bb8c39}, {0x000a4109b143d327,0x00085897b4d64670,0x000ec856db407a04,0x000c3391b35a7c2b,0x00004729f04e48e2}},
    {{0x0000e287d444576f,0x000fa46c0fcedfc1,0x000c4bc495541641,0x000dc4c61a898da2,0x0000c49474474950}, {0x0005d34a86e99ff6,0x000dde84f0eb279c,0x0008b517448eb4a2,0x00020f168c48d9af,0x0000d2e2947e6a6c}},
    {{0x000d4b7fc5ddff94,0x0008b8cd5d76c4ee,0x000e6ec7533c62e9,0x000b64d05167db0e,0x0000723b4547dadf}, {0x0003255992390795,0x000cf88d2ea48646,0x0007f30d8f37975a,0x00001460943feac1,0x0000681ac9cf176a}},
    {{0x000b8b6daae521b7,0x000adbdf2be35556,0x000f2c0e8441695d,0x00052433bb1bc3fe,0x0000a6eeb8381b5f}, {0x0008b6d0a7d65ee1,0x0008d0ed4f2aa649,0x0009d15a7352ac47,0x0008209e26a67a00,0x0000eabbbcca5492}},
    {{0x000ce07d1a83db8c,0x0001217601ca6e80,0x000bf1f026fe55be,0x00067c6a6a9b77f3,0x00002da4da482151}, {0x00050ce0660bb9c8,0x000c647dbdd30a3f,0x0000ce6acc0badf2,0x000af2afe2cb4eb2,0x0000df11e844ac4c}},
    {{0x000bcbea50bf7b2c,0x000d6fa5e1ea7e76,0x0005104e4d183277,0x0003530de5287e95,0x000061dbeae917cc}, {0x000361797e3c36a8,0x0006a4c11975d8d7,0x00056ffe587eac28,0x000ec4cf96fe62e6,0x0000ff2a60a5ece8}},
    {{0x0005b7d6b5c17565,0x000e725336dfb23f,0x000f699eb5967d95,0x0001d71cc4a1282c,0x00006f2d1e5dbace}, {0x000cc2260eba8909,0x000a041a0642f2b6,0x0009abfc6cbfaebf,0x000997d9347b4051,0x00006c695a44b98a}},
    {{0x0001ae8291d465ef,0x000694bf89326d90,0x0001c482f1ffe9f3,0x000d2382bad4525e,0x0000168c52db0bcd}, {0x0006017568b375d4,0x00089290b50e580a,0x000f160a15743a92,0x0005551201b0040b,0x0000581e3cdcd77d}},
    {{0x000874ca4cd68d8e,0x000f8c4484600f4f,0x0005c73324d85176,0x000fecbac7c97f28,0x000079aa93211324}, {0x00075824d0274253,0x00064d8b475d6b62,0x000eaa57375d9aa1,0x0000f362be914bdd,0x00004995d6eeabfd}},
    {{0x0009820f41846ba3,0x0000604085981174,0x000978a94fd1bcdf,0x000d0ba2fed0a907,0x0000ba1d2eda2efd}, {0x0008512656b5739f,0x000594918c39e3e4,0x0000b6224e9c896a,0x000d5bbb1875d792,0x0000b93012187315}},
    {{0x00019ed5ba8931b4,0x0005acd90608de3c,0x000b33a89ff0f3a9,0x00089e41298c1df6,0x00000292d30c3fde}, {0x000d7df4a273bfe2,0x000087b011c26348,0x000a2dc24b8b9f1f,0x0000ad39d9d45852,0x000067daaf3663ad}},
    {{0x000dd476f0bcde8e,0x00074f1aef494e4f,0x0004bfcbf6a3568b,0x0004f71520bf6fc8,0x00000306160f678b}, {0x000e43f9114c874a,0x0006a66a6723e3a0,0x000fa916c94626c1,0x000e1a4c6dbb2fcb,0x0000a2a7851b6164}},
    {{0x000f6c17b91cb2fb,0x000022d25723d046,0x000c4a5d56108b74,0x000423bab6def6ce,0x0000c2cabcf84f05}, {0x0009b3aeef06e341,0x00032ae65511bd33,0x0009815f724c639f,0x00015a5666c8aa1e,0x00004c097c5786e0}},
    {{0x000b7ddec96a31f1,0x000bb6126e7d0171,0x0003107612ab4881,0x000f991937b21ce8,0x0000c2f1836cf5e4}, {0x000f324d669b052c,0x000bbf0d0024898d,0x000fedf68f963603,0x000e5446be060625,0x00008eaa3a89c4b0}},
    {{0x0003578addae3db2,0x0001256b65bb4a56,0x000f89bb28f673ae,0x000ce0f3897587f4,0x0000e7b5627e000b}, {0x000373d4ebc646ed,0x000c26c01b67d1af,0x00046e755320c491,0x000df2ed183b1a53,0x00003dc80714e3ef}},
    {{0x0001d181707854b5,0x000e045ed6440d70,0x0008141226b65beb,0x0005fac44ea8ce1b,0x00004d31afc2b255}, {0x0000f1d4fd98ed23,0x0000361122a75ad2,0x000dba8c53597134,0x000fd9b5173a0d9d,0x00005c6b22beb557}},
    {{0x0002ee43acde4fa2,0x0003572b4de2188c,0x0009e491b7321151,0x000935ef340f8681,0x00003ae38901b2ff}, {0x0001fe8fde235367,0x0003c3ac4d9e99a9,0x0002c2b7c3253510,0x000130bcc3a87d5a,0x000018cf5dc1d05b}},
    {{0x000b0ea388337482,0x0005bc0ab3d81a29,0x000f26100c68ffe3,0x000c3d24c4d4108f,0x0000f14a32ccd1dd}, {0x0000a315097789d0,0x000b428d4c71c703,0x000a782fabac5dc1,0x00014d3bba4799bd,0x0000e5c67c1d3f71}},
    {{0x000dee9bee66b26b,0x00040993141604b7,0x000f8818745348d7,0x000064a5cf2b66d8,0x000035fa570e7a60}, {0x000e3b2e90a9f6a4,0x000a93d618844b8b,0x000e1533c3136043,0x0004b406fc07f2f6,0x0000e68110e4d8d2}},
    {{0x0009c06a197144e0,0x000a0ebd90e8998b,0x0004637e982d59c0,0x000346ad1dcaf45b,0x000059c29fb15ffe}, {0x000e68bd0de11ce1,0x0000ef9123f1e4ad,0x000809e2e7028807,0x0001a38b44fb792e,0x000021fdeb0bf5a4}},
    {{0x000b525dfbbe18f4,0x0006ce6bebd7328a,0x0005014218d893eb,0x0007f27415906d1b,0x0000683c30795a82}, {0x0003859154db22e4,0x0003c459a6b28d30,0x000d54f8a9fdddf8,0x000441f5e0dcb8f5,0x0000b323984a4542}},
    {{0x00020890ea27494a,0x000e1e35ace9abf1,0x0005949a7637aefb,0x00092a65ed6aed2e,0x00009fb6d9b1e31c}, {0x000c850fe43da55b,0x000c7a2aebb47154,0x0005a1f29c49139d,0x000f8c8a3b6609e8,0x0000c0e447c73747}},
    {{0x0003b83c899e16c9,0x0007290a4c485b88,0x0005c11ac3264056,0x000b31c23fdf0557,0x0000d6294d704452}, {0x0005adda6fd01b3a,0x000ed638d76cebf3,0x000bc2a591640d40,0x00090bcb6beb8873,0x00005774079636cf}},
    {{0x000d07a4df05112a,0x000c75ef10b3ed9e,0x00000dc454558b1b,0x00068ee57b1c4e11,0x0000c05303af0df1}, {0x000ff70dbf770c49,0x00078abb8add6239,0x00051783cf1da24a,0x00085717000ea909,0x000083c07443aa20}},
    {{0x000e669c9aa38ff1,0x000cdf9b6663ec67,0x000fbaf822c76f14,0x000d8f2e05f459fa,0x000081bfa0e72146}, {0x00031960fccc9403,0x000079ddbab69572,0x000c0f236afff64a,0x000c6b8a2dc2b77e,0x0000cd9b9db0072c}},
    {{0x000f50005e38e681,0x00011d2a53bfce83,0x000d3127de4fb9f7,0x000a7389040d2691,0x000090991b1df4f9}, {0x000f4d487fb49c70,0x000acbf3cd2d4b92,0x0004a8e9f3453a0d,0x00056284948bf480,0x0000bf9b42b8763c}},
    {{0x00085bea7295b89f,0x00032c67fdbe5c4a,0x000dfa99ff9b5214,0x0003dcf7dd419d4b,0x000053b1b1f00c14}, {0x000fc48e64a06587,0x000c86e4c0bd1189,0x000f07b904597445,0x00012361c88b11d0,0x0000de6046f7d84d}},
    {{0x00087bbacc585b5c,0x00054110d0cc505c,0x000cc9394ff5fa6b,0x000013753c1362a9,0x0000f747b69989a6}, {0x0001acdff683da86,0x00085c9ade093e40,0x0009346cc256f729,0x0003da9907d05802,0x000068d87f52e4e5}},
    {{0x00072320892f7939,0x000ecfb65e03e668,0x00005b60e8867af8,0x0006db6855960ac2,0x00007cfe82946f8d}, {0x000126504e895a59,0x00082f9ab1ae37c7,0x0003475b8072a97d,0x0009b271cf682e37,0x0000a001e427da0c}},
    {{0x000f56aa1c2ac6a2,0x000b0056bb5e8607,0x000840d5e7b5a2f6,0x0002a8575fce01b3,0x0000bd0d02a2a11f}, {0x00020acf5e461b5d,0x000143f8b7882cb9,0x0005684f429c8f84,0x000b43261bec02c9,0x0000976e4c74bcf7}},
    {{0x0008818531ad28e4,0x0004e2d377207b87,0x0004885027f26899,0x000503f289ead51e,0x000098cca8ee68f8}, {0x000c970b5c5d77dc,0x000080459981f27b,0x000b87fa1544bbcc,0x00070d2411cca590,0x000054ea81cf6071}},
    {{0x000086e61ca59dc9,0x00021cd8c326fa3c,0x000811dadebe13e0,0x00041b5d83482a0d,0x0000a49369b21466}, {0x000c7cd8304d967f,0x000e9364df0d6130,0x000343b0e27f449a,0x000d17ab76d37fee,0x00008a1d0ed05ee5}},
    {{0x00046cadc6205653,0x000ab65343bf3181,0x000556549569c932,0x0006bd0af34c44f4,0x0000ee209046d270}, {0x0000c0ef40c6247e,0x000dedf91b009463,0x000bb38be3f102c0,0x000064d340ea43f7,0x0000e2d7c507278a}},
    {{0x0001fc4894efce0e,0x000d16f705c791bb,0x00001c6f5dcb8966,0x000e5e4eff50cb1f,0x000096a8482ad3cb}, {0x000dec26d0cfd830,0x0003040d53e317a4,0x0007f8e26336612c,0x000559bd95bdd1d6,0x0000ccd1e540626e}},
    {{0x00068bdee681a9fd,0x00019176d44b5bc5,0x00088a36d1aaa6b0,0x000c7bf9e56290f9,0x0000b5d955ba2779}, {0x00025fcd134d4965,0x0005ff8f9c5b8014,0x00085dfc847e63e2,0x0001a0634eecfe39,0x00008b0e4909de31}},
    {{0x000397d6afe3edfb,0x000ead213cf0c484,0x000fe129db20b9ba,0x0004aa03eebcca16,0x0000ac8b193bcbab}, {0x000d00ec766789a2,0x00007b641c6280af,0x00012d36a671a1b6,0x000788d44e1010d6,0x0000e906a8a2cc4f}},
    {{0x00085346f1857b14,0x0003410a4089af78,0x000c2398d5cc5098,0x000b93ca8a5f67b0,0x00004695f3af907d}, {0x000f016bdb075823,0x00067ed27633c156,0x000a99381e81d34c,0x000d88bd4282e4c4,0x00008536f5808ba6}},
    {{0x00099ab2afcd854b,0x0007d8eda94411de,0x000c8a192d747cf5,0x000c2d246295bece,0x00001424f4c40f48}, {0x0001c25b3f186f40,0x0003eb32b7394006,0x000ddbfc3b2985f6,0x000d7fda0dd1d8fa,0x00009df5df39c2fc}},
    {{0x000736cb9995a1c8,0x0003f161f3b15ad2,0x00016b96e4f367b2,0x000c18470c49cfa2,0x00001b9d55b9d130}, {0x0005a5f78a9f0c67,0x00021aa433e2085d,0x0000dcf549740986,0x000faed0c9af8ba4,0x00009380b92d46a9}},
    {{0x0002c88c54018551,0x00029c0673e5a8f4,0x00054155f79a8500,0x0007f49c76fa0d73,0x0000e0e7821cfcaf}, {0x000a0f6255d3014f,0x0001c980f9fa8f28,0x000cc0b0ed7bc620,0x0000f657b694eb76,0x00003dc3e7fd436b}},
    {{0x000900f0e2ab22a4,0x0007485db521beeb,0x000e657e4f9fc7b6,0x000645a1ee59ad38,0x00005db32d0f9721}, {0x000237fe16ed3e0e,0x000bbb7178cab7d5,0x0001c17f2278f133,0x000c4cba85c30874,0x00007993168c23c7}},
    {{0x00019588e7f16445,0x0007acc30bbdcc18,0x0000d00fb3765dae,0x000e56c47a4fe57d,0x0000540123b0db2d}, {0x00027a35c65a51ed,0x000209b84b2313a2,0x0007634784e94bf1,0x0001a877d76a3143,0x0000a49efebe4d8e}},
    {{0x000c9dbf562fa402,0x00091c7548693347,0x0001d08b33389499,0x00003924b7a2ed2c,0x000073ffa2df5839}, {0x0004bddada7df426,0x0007a35d8ec44b5a,0x000d0629a0a53add,0x000c22216b46cf5c,0x0000156ae4a410f7}},
    {{0x000684c43a0908b4,0x0008578d18268934,0x0008e8668505170f,0x000d80851c09a959,0x000081f6e0c2f121}, {0x000e6b0e93141606,0x0003960731d37a3f,0x000fc8e4b7861d75,0x000aec6eb173ec4d,0x0000839de40cf2b4}},
    {{0x0009da66960a1d07,0x00027d771fe97d30,0x000fac3ad619dafb,0x000baf9f688aba90,0x0000f8d73eab08be}, {0x0004a8a35306c347,0x0002ece26a385f6e,0x0005297e499a6cb6,0x0000e956434c7490,0x0000f8fac1dfe93b}},
    {{0x0000533de36faba0,0x00016d1b717153e6,0x000e7b6a46cd71d1,0x000b0d8454ddf26c,0x0000d2dfeda7af6e}, {0x000a49d8f229e942,0x000aeebbb5a51c05,0x00026ea87b89faf8,0x00040f65455941df,0x0000270c9e42b6c2}},
    {{0x000fccb792331f1f,0x000bbd5f4310303e,0x0005487a9aa841df,0x000687415985039d,0x00000722f292f10a}, {0x0002b63fa69dbac1,0x00055c77189d6d9a,0x0001b8b7eb40e9fd,0x0007b2ad14152df7,0x000026e00b8e2fe4}},
},
{
/* digit=34 [{1,2,3,..,}]*([2^238]*G)  */
    {{0x000164b77ff9c88f,0x000a2ef7eb4901c8,0x0004be8651e6510a,0x0003146b0427bac9,0x0000014ba0639f38}, {0x000079d912a4b87c,0x00053718addb5b8b,0x0009350d61f10a85,0x0008cd383ef5b3aa,0x0000b3050be022e5}},
    {{0x0004372d2fb6aded,0x000801214c59b7ee,0x0009a805676222c1,0x000393e75f878b61,0x0000bc0e9d60d556}, {0x000dcc68fb3aa122,0x0008198ce83ad58a,0x000c586f80dd8a70,0x000608da5fa2a4de,0x00005c1fbffecc79}},
    {{0x0000cd3410794975,0x00002f17f97e1c7c,0x000edb80180e62e3,0x000677d857c7cf22,0x00003c5dc338930a}, {0x000919ff266e4f08,0x000d7ce8b10eb218,0x000a415a98781060,0x00067eb9c65da11c,0x00000a82892a18eb}},
    {{0x000e99ea38b2555e,0x000c2d0f78b90aed,0x000f899f908f42d0,0x00045b85d2246e6f,0x00006affd17a8110}, {0x0007243c95adc81b,0x0005ff1b55034f43,0x00020858fc587c33,0x0001203202a22342,0x000031c328f6ed23}},
    {{0x00094131d1a510a8,0x000fb492e59d9b18,0x000d46eeacaad4c2,0x0001e0f8cfbc62bf,0x00002d9b92bdc756}, {0x00054b85d74c27e5,0x0007ec6f99df2367,0x000ce9d06698647c,0x00058b504025de05,0x00006aaf1cab6c68}},
    {{0x000994dd11fe6a9d,0x0008eba83bfa0e00,0x0001b31f14d4500d,0x00041e927422e49b,0x00000c3d5fda89be}, {0x000bfc9eaa562805,0x0000baca1c2c7a32,0x0000a870fecfd05a,0x000e1425337b4e23,0x0000170a512337a8}},
    {{0x000ce57b66ce8b33,0x00017e3f3e322882,0x000fd4d1b4d897aa,0x000a30a6df75816f,0x00007c5429d1c726}, {0x00001a389212e06f,0x0008462c37e1fc25,0x000bf5f267708a70,0x000088314bab6b3b,0x00003e8cf2215d7b}},
    {{0x0001ca59294b3b6f,0x0008266971b412b0,0x0003fc23a009e882,0x00035452a7149569,0x00005836d205ffc3}, {0x00041dbb019e639c,0x000004f228ef2720,0x000c74f69a1c8850,0x0009110f82baac62,0x00006c6dc96e97f4}},
    {{0x000cebdedd438eb2,0x00067491a855ec0d,0x000b83f8e144f459,0x000c0ddacb21f3c6,0x000017a832750eba}, {0x0002281cf11b5e08,0x000c27889bbd621d,0x0000eb5a495a0f12,0x0004fca13a692b6a,0x00009360a8e55b15}},
    {{0x000c8e9a166a355e,0x00013d1882ac523b,0x000719f73df1639b,0x000eec37a772fb6a,0x00000b5f4f23d476}, {0x000f7e07224ee886,0x00021d0a2a679ee5,0x00027786b2648c3d,0x00080ad189601c14,0x00005554b996f704}},
    {{0x00085c70ed8b7a07,0x00080ff5ac69721f,0x000229dbea53ae19,0x000124751f671465,0x000026c04728ff80}, {0x00077fee956c748e,0x0005e60b02d0294d,0x000be3040a2ee31b,0x000b41001c513f66,0x0000124ec995bdb9}},
    {{0x0002a05eef749b88,0x000bb345f0296e45,0x000ca0decb1b42ac,0x000a45c34c8832a2,0x00000ad9447c3da3}, {0x000bd418f40be07d,0x0004656d8d611385,0x000b4a01a333c0e0,0x0005b7da85289120,0x0000d53f63e89842}},
    {{0x000b1030f7484975,0x00072638cc84ef88,0x000da3c65c73ce22,0x000f0fcae17f1301,0x00006f3f5a252d97}, {0x000c09e996d5598f,0x000a57310512997d,0x0002aa7f9e694253,0x000b70e1bfdb23ac,0x0000064f9d6804f2}},
    {{0x000e6573eacaea0b,0x000e59b058bd265c,0x00018847df779bb5,0x000c3b678c0d39ce,0x0000ca9ee0828efd}, {0x000a29bc7409894f,0x000c8845e22607a3,0x000bdea795bbeea4,0x00059242b80706da,0x00007c709434bcc0}},
    {{0x0008ffb240e3f455,0x0008556a6fe6a748,0x0003f5486e2d2ded,0x00044844798dbb44,0x000001050e8f96eb}, {0x0002f32ccee8cca7,0x0005765b412f7202,0x000a163954aedf33,0x0000057cca4d0d83,0x0000e78e9b71d3f0}},
    {{0x000ffd0f38bd9188,0x0009b09114aa4975,0x000b8b6035798f34,0x000fb588ff0f5489,0x0000206e2219ddcb}, {0x000fcf8f821d742a,0x000dc1fbd6f34da9,0x000702c041ed9195,0x0009dde18d25563a,0x0000b89d7575171b}},
    {{0x00061fbbe6d6db62,0x0006e63bc763d31c,0x000286d321f07966,0x000195bc5e14c35c,0x00001600cfa9dd08}, {0x000c3c815ed8598f,0x0006fed767ed31a9,0x000fa58d2625008e,0x000a2a33e8005f67,0x0000a1b81d42e593}},
    {{0x000e39db02b697a5,0x00078d8dcf8a266d,0x000715a9abbdf72f,0x000d03033cd5e0cf,0x00003393e3d87890}, {0x000b10a596c6ff72,0x000ea2c1ffb438b0,0x0000785544e805be,0x0000a95e6d16d794,0x00004806b6418ed2}},
    {{0x0003c28b02565d5e,0x0007d5fa9a84ed33,0x00087b17db552969,0x0007d18d709db6b2,0x0000409c35a8857e}, {0x0000777198594e1a,0x00013ba1996d94c2,0x0006d6c719c95731,0x000a209aa81eefbe,0x00006ea2d1d24a2a}},
    {{0x0000e3d894cee1e8,0x000477071278725a,0x000e8d65d9c5ec97,0x000993f9c900d4bd,0x00009bf052b7d32a}, {0x000ac8b02844a89b,0x000f631c9d556098,0x000ad2c6940519ec,0x00089816ac904985,0x0000c65a021584cb}},
    {{0x00047d3f3cd9f24a,0x0001c7f8a5e5779c,0x000bbab07ed17207,0x0004e1d7fd448a70,0x000021c3bbf36482}, {0x000b4d80d3b11d25,0x0001b97fcb26f826,0x000f528f4f86db6f,0x0003d789800557ff,0x0000663c86f8f635}},
    {{0x0009ee695e5a5075,0x000b919d6729edaf,0x000b61dd4a9723a0,0x000611b1586f96c3,0x00008566b6eac708}, {0x00090af73a830815,0x000615254047d580,0x0007aef29bec2d5a,0x00092f6291bc2b1e,0x0000eabbda6cf8ef}},
    {{0x0007c0801e864ec4,0x00015d26f447ee51,0x000264c5b394057a,0x000ab54aad486936,0x00001a0403c8e25f}, {0x000f7a8a4659ea6a,0x0002d1bb980af413,0x0003681ec617ee00,0x000b355725932b75,0x000004af07f35eac}},
    {{0x00090a00a5ea679e,0x00042580d3b41835,0x000bbd5c4dea2f9c,0x0006aee218b68b26,0x0000c25f328cab12}, {0x00064ebe2ea67e19,0x000017ca33af5ff5,0x000e8443bc7fab12,0x000fcb6ed74b4cb1,0x00005ea985061107}},
    {{0x000c21ef95df3779,0x0002c982d5270ba1,0x000ba11436031d1f,0x000a1a8a0967f9df,0x0000ae6a5eba6c26}, {0x00012ea2c092ccc9,0x0004117991571e9b,0x0004fed8c28f898c,0x000f9c7d71f312d0,0x000041fa4fc14344}},
    {{0x0008d9030a2bad30,0x00069b5a65848afc,0x000b84311cbe35b8,0x00058c03c5566460,0x00008cb2a3f860b6}, {0x000df7536be38e1b,0x0006d87e7fa21eb3,0x00001ad6290d1f0c,0x000eb810bf6f5cf1,0x00003208e36ab1d3}},
    {{0x000df5d231c91e4c,0x0001b04babfe5cd7,0x000ef58bbdc77085,0x0002bc2357ac532e,0x0000b5c3bbcfa9b1}, {0x0004ae41da37806e,0x000d71c7d7131ce2,0x00003eb2a144c5bc,0x000449e6a7caabfb,0x00005ca49bed40b1}},
    {{0x0003b89bd18f3d12,0x00016f2316cbf28d,0x000482896f8e6c7c,0x000e778e62adc34d,0x00008bddfc697813}, {0x00008eed3e3e9d68,0x0002fe9f8a3d153c,0x000d994921af5ead,0x000a79c09952b705,0x000069094582de86}},
    {{0x000602c441b88cd0,0x000bcc20f7e71964,0x000ececa70c2a3c9,0x000f16fa225449ec,0x00008d5f586ad324}, {0x0001d115f0909ea3,0x000fc97c961679ce,0x0004d1588ead7203,0x000773fdc146623e,0x000053a8ea43b1f0}},
    {{0x0009c4809a0bba36,0x00009d9a25c286c4,0x000d5a52060f0403,0x000cff7d9efe137c,0x00009b20f1c2576f}, {0x00078ce06fa3e86d,0x000c77f529c06f14,0x000c1aad527c7769,0x000a54cada78329b,0x0000cfdc46bf1bdc}},
    {{0x00010cd2058985aa,0x000552e40f6a34b4,0x0003e1a2087169d6,0x000feeaa1773f3ab,0x0000a8f013b7117a}, {0x00075210df843d49,0x00035b92e42bd467,0x0006eaf3ecce3434,0x00067ed3af118378,0x000053710064d275}},
    {{0x000b1bba80892cbc,0x000c43c116286ff5,0x0000a537bd1a5cb1,0x0004dd41b6297424,0x0000c9e812b1f69e}, {0x000fb4b5fc8601f1,0x00025def2d88f167,0x000097bead9b6112,0x000f8c0dec297878,0x0000a5bfd4cccee3}},
    {{0x000058b90fa84dff,0x000b95e24fa1bb46,0x000c99c141fa4b7f,0x00021f36fc4b15c5,0x000072ede8886dd4}, {0x000db218df104f8a,0x000d8929fa061e56,0x00031369dba8acfc,0x000139ca445c97ab,0x0000aa7da404f985}},
    {{0x000459fd466786f7,0x0000835940e6a840,0x000323c0080d2d9b,0x00021bceb6682b6e,0x00000ea0e0da968b}, {0x000b8e9e1c90e07a,0x00000efe4121cbbe,0x0000849c5d166c93,0x00035bdf729b9cad,0x000020e1465218fc}},
    {{0x00062a0d6f379255,0x000b70dda2ca99e5,0x000ecaa30b5d30e5,0x000a688e3a88f1fc,0x00004f71443553af}, {0x000916b0bbc4b3da,0x000778f700e9314c,0x0008470ccc4bf1a1,0x0005e5a395ebe872,0x0000286cde27e46b}},
    {{0x000f5cdfe6b7d846,0x00082cb76457a1e3,0x000f3b9f74697b1a,0x0004560f07699d92,0x000028a5e6885a15}, {0x000742ef4c2f1f4d,0x000e56fb6d72c4ed,0x0008faf1ba1dca49,0x000ca351c97d7358,0x000087771442b909}},
    {{0x000d00ef6e81de3d,0x0006e2eef62dd862,0x00034f24d63d21af,0x000c7950c94d5766,0x0000a5a468b10066}, {0x0006314bb09920b7,0x00046433ceeafbe0,0x000590fbbe003195,0x000e38446743c58a,0x000060b8843b0644}},
    {{0x000c8a2f33ef7892,0x000014bcb8cc69d1,0x0002dc33430b7a34,0x00007b190c3a3959,0x00003317543deedf}, {0x0009efc31735b604,0x000fda1ad6889634,0x00021830c3784c8e,0x0007f7a98ea1604d,0x0000198b9ed3ee3d}},
    {{0x000802942dc95293,0x0006c607840b614b,0x0007638241011618,0x0001a891626667c7,0x000070fae3ebdba7}, {0x000e767cf31f42c5,0x00037886da27ff5b,0x00092f5eedb3bfca,0x00092071df531c71,0x0000a96add241b4d}},
    {{0x0003414c0c83975e,0x000af2aeddc23ead,0x0004d9fda7d76f8e,0x000ff1110efd9e98,0x0000f15023276067}, {0x000a0520d36f0d27,0x00065322372861ad,0x00021d9344f19d56,0x000a4fab8999bd58,0x00002a7b9e9d02fa}},
    {{0x000e6f66be15bbbf,0x000516ab8735bf29,0x0004d4bebda1a8ad,0x000fa68f061186d8,0x000009f9261ec025}, {0x000668b5b3fc0a45,0x0004af0a2c0ff9a9,0x000282c2bc1a8bb3,0x000ddb6c3b1e0b34,0x0000492f782c6d6c}},
    {{0x00069b4c267cd575,0x000f0f8ff694e887,0x0005b7442ef62630,0x000ae31d653545b0,0x0000bc15dfb1c514}, {0x00074dc7419111ed,0x0005eb2728c3a9f2,0x00099a7d7ad03866,0x000fa05d8bfc5cfb,0x0000c82b07903c82}},
    {{0x0003de54e014c472,0x000560e61eab8f72,0x000f8cf303460a19,0x000c58bf40488c19,0x00002ba1ddf14e5f}, {0x000aed63d9564f0b,0x00077c5ee525ae10,0x0005271ab84a9fdf,0x000b311db9987806,0x0000c50919caad39}},
    {{0x0006e874c69e8a6d,0x00032ff1ff6a3eff,0x000e47e1fe98ab13,0x0008fe8b0aab1917,0x0000a9ac0b6b9835}, {0x0004bc04f8bcb879,0x00083e021fbaa981,0x00053100e36bad61,0x00027f3c2bad3e08,0x0000a510218c5f1c}},
    {{0x00079c291c3fac17,0x000e406762ecb91a,0x00013af2e1a7b0db,0x000eba4e6ce29057,0x000053a167cb4639}, {0x000c07bdeddcb8a5,0x00067183cdd67c61,0x000128f146849aa2,0x00077df6fb0823f4,0x00000acf75062e13}},
    {{0x0003ab8aa1b413a0,0x000ad9f830d7fd57,0x000b78539eb24027,0x000bf1c67bd704a6,0x0000c3195072ee6a}, {0x000bf133f8b12d87,0x000380475ed535cc,0x000990604c95a5f7,0x000535334f567cae,0x00000582b15227a5}},
    {{0x000037febb43ed1f,0x0005fbda9e9827e0,0x000aa2514e69769a,0x000cd35866ce6da9,0x000060ec889f5458}, {0x000a6da95e75646d,0x0006670efd9bf0bf,0x00024a9dc8b0395e,0x000ea954fc07a1ed,0x0000f86eef9860f5}},
    {{0x00072012ca58fbc7,0x000d4c78a8cd5b1b,0x00068b7af601e664,0x000a63128123fc55,0x00000084c070ef02}, {0x0005a8e658751508,0x000195ae0550346b,0x000d111eeefc4be2,0x000fce20fe4c6f46,0x00003a287fc76838}},
    {{0x000be4e9312c54eb,0x000f0cda2786e630,0x000d6ceae55abd5a,0x00091e346e84f200,0x000022eede6ca985}, {0x000356024525d0aa,0x00045586290c118a,0x0005c6e264b2b3b4,0x0005742743dac9f5,0x00009827e4a6a765}},
    {{0x0002a6dd9cfb4cd8,0x000f94e215cb934e,0x0007b3210b4858a1,0x000417a6b0a4b56f,0x0000befcc636ca75}, {0x00004b44b52cd3b7,0x000e7d15df655d8e,0x000f5c7d81066051,0x0008319bf3c2bb26,0x00001fd03c43aee3}},
    {{0x000a7603cb34c2dc,0x0003d057be5ae4c3,0x0002a595a6d0f925,0x000e18e4a3e6cf15,0x0000bdb8d991f000}, {0x0009ebe420d29fb1,0x000a2deac279fefc,0x000be608d12593b8,0x000c2f8c1e1867f9,0x0000eb5a9f81fbda}},
    {{0x000421680a0ed616,0x00052f2f3c60e7e7,0x000419cfa67feadd,0x00070817ed6225a4,0x0000fc0a15bd1cf9}, {0x00005b2338e5c066,0x0003160bddbc9130,0x000287049b60afe7,0x000489555a8336e4,0x0000959d1b6599b6}},
    {{0x000420ce0721159a,0x000f3b431364134f,0x000a77054c77e7e2,0x000491139bf22e1c,0x0000068bc7711297}, {0x000e3f9245e5d473,0x00083b6ccdc556ac,0x000a7a2b057ab72b,0x000b7e04442765dd,0x00008a61f6aeb745}},
    {{0x000e96dd576a73a9,0x00026d0897ab34e8,0x000fe2f8ff6c7c7e,0x000a5a99c1721c5b,0x0000d26a77a616ad}, {0x000b65c58aa4fc27,0x0003d809efc1048e,0x0006fac2acd58b42,0x0006717ad71cac4a,0x0000645d4fc1ffd4}},
    {{0x000d73a164aaf5d6,0x00013d6daf2c817e,0x00075d36a7d62437,0x000d90df8c94fad6,0x000026a8207e0f81}, {0x000826b934843b84,0x0008b84eeafc1dd4,0x000dd85215de1db7,0x000128812417e355,0x0000ae2d30deaad5}},
    {{0x00051dada3211cde,0x000c64018309c929,0x00044e2d5c6376e3,0x000d9d80ccba2315,0x000025f7a4a621f6}, {0x00027257fd00e719,0x000b2f36f2fefad5,0x00022f938ceefce9,0x000665f7ca6333cd,0x000077ef898fcf04}},
    {{0x00081bfe708b52ee,0x000c42359c865bd7,0x000be20854eefe76,0x000e15fd0ae7807d,0x0000c6305412aa5d}, {0x0007eb6ec1300871,0x0009cb3a7019cfc1,0x0003b73c3064cd8f,0x0008e6c1c89da37f,0x0000329e0ea397cd}},
    {{0x0001b5e44c3250c6,0x00006ceb294648c0,0x000b962637706782,0x000130c3b3acfe89,0x0000a6dce5b66ebc}, {0x000aa6186ce36869,0x000b1852bf94c5bd,0x0004c261dc5ebfe3,0x000f138a1bef6195,0x0000a279dbb67a1b}},
    {{0x000879d90e03a540,0x00098a4ef9ff4a24,0x000a26c0ce8f5edb,0x0003796474413661,0x00004350b4104b6d}, {0x000757164564536b,0x00057d4f4adebe01,0x00050b82d298dc7a,0x0005b791e2842835,0x0000a781123e3c5c}},
    {{0x00007c48619e84ab,0x00097a8e0f19b2f3,0x000b3c9db52cf19a,0x0007e35d5659ce7d,0x00003886ff23b704}, {0x0001aaf58811dc26,0x0002bfed52b1bbd1,0x0007104ca16ad476,0x000b79c4f1138a88,0x00007658715f7d62}},
    {{0x000f110ecabcba82,0x0004da27d56ef2b7,0x000dc00cb29c9167,0x000ea38be30c384b,0x0000551fbe178550}, {0x0009ceb4b6cda9b1,0x0001c0f8dbf0f1e2,0x000ff617a844614b,0x000b9bb65d23f3e8,0x0000463bcf08ebf8}},
    {{0x00046fb3c9c2f2f6,0x000d8bc887881058,0x000acf39df0c62e8,0x0005e06d804143a8,0x000012fea1c85697}, {0x000fe3dccde965f2,0x0008b508c90850a3,0x000e602055cb2212,0x00026281f1187920,0x0000af846cb5a96b}},
    {{0x00094218aed1a517,0x0007bcb7d8e4e5ea,0x00070f71ce083200,0x000c497f01ba571e,0x0000e6ebb21847cb}, {0x000aed8c6da82ba6,0x000ab2db4b4da475,0x000a869cd33a684d,0x00064cc689a3ac37,0x0000ae1ee3463a89}},
    {{0x0005bb9f1e1c66ff,0x000777e629c50f4c,0x0009fd3d89dfbcb2,0x000022138efb8fcd,0x00005816bef7a97b}, {0x000fefc894aa6e34,0x000e9903a64777f7,0x0001f799abf92380,0x0007f487d3d67ad7,0x0000656fe81b0c1f}},
},
{
/* digit=35 [{1,2,3,..,}]*([2^245]*G)  */
    {{0x0009dc05b0daeb6a,0x0007ab1c9719331b,0x0003d0d262ae4dc8,0x000f3de5109dd56d,0x0000ad73296a5d14}, {0x0009fb2ac31d9136,0x000163a6acd79e56,0x0003de3fe8aed60f,0x00087300abd5213d,0x000039462f009289}},
    {{0x00020a59b6efa79b,0x00089cfab3fb90fb,0x0002133c42d820c4,0x000a360c8d738663,0x0000971de4ead8f2}, {0x0001f841e142f900,0x0003ccd560f2a34c,0x000e1379d650f3b7,0x000d1d007fad6aa7,0x0000b1bf229b9aa2}},
    {{0x000bb724b855a969,0x000c193ee3fa5bdf,0x00081b7e4fbe8611,0x00094f40258b7810,0x000069302e6ce1af}, {0x000a01254526c745,0x0004141d611305a4,0x000ed085a7fc0c93,0x0009be3d57407cde,0x000071742a3a7834}},
    {{0x000014a8c1f3bf07,0x00073102160f5085,0x0000c42214175c4e,0x000f472abaa79acf,0x0000dfe26a0804cd}, {0x0005aae6f42d4acd,0x0001a1106a667256,0x0009bd963bc85414,0x0008a723b2b776b4,0x00002e675791ac54}},
    {{0x00067e282d8e77ae,0x0000ec55fe6a99c2,0x0003bf9a2c0250ad,0x0007bfa7c31cc937,0x00001ae266831856}, {0x000738a847ecbcce,0x00022dac7b970a0a,0x00088ad41f4b09ba,0x0004ba5b4ead8383,0x0000ba6d2a78d509}},
    {{0x000e67853c1c0424,0x000ba067d80a0c28,0x000861c400f926de,0x00063b09e1a3bce2,0x0000fc011f0af635}, {0x0003dedbb918e260,0x0000921523ea0b52,0x0007bc667773bf8b,0x00086b039e89a24f,0x00007701e4145ce2}},
    {{0x000d665659750b64,0x000d981e7b419f25,0x000fc4ca88f75ecd,0x0002d199aed274fd,0x0000d837ba7e0764}, {0x000405c0720a84bb,0x000ef4af02130827,0x00080e040098122a,0x0007d9f41d3bcfc6,0x000033b4e1e14860}},
    {{0x0007596d7efa47e7,0x000f87ae55f9ba41,0x00018c27027f5c32,0x00038f7626dadc8e,0x000092ffbbe90edc}, {0x0009f3f053fc1017,0x00081a3a20f73dc5,0x0006fe6d0df44113,0x0007b5d805ac5f21,0x0000201193396b7b}},
    {{0x00031a2aa5514055,0x000aa37a81ddbd9a,0x000cad5460bb8634,0x000043fa6ecf5041,0x00007ba1f9908b03}, {0x000b451a99c6a86b,0x00003d70f946e8da,0x0006874cbe002fcc,0x00047b59ffb89cc6,0x000098339a4a6b4d}},
    {{0x0006655d65ec88df,0x000d6e79f896eff1,0x000d38236946c197,0x000510068781a8c4,0x0000cbe735a054e3}, {0x00062486280cc181,0x000cd52f7a4924a4,0x0009772668ab80e3,0x0006ec2371a3f51b,0x000083cd4419a909}},
    {{0x00061f179879b951,0x000df0c07e6ff0f8,0x0006434d1b7fed81,0x000899e3c92db27d,0x00005fb78635f682}, {0x00007019f0959708,0x000123fd44581616,0x000f3cd7af2e4c82,0x000d794d693d2a88,0x0000a039a63f0492}},
    {{0x000a5a141c4747c7,0x000c91edbabb6659,0x0008cd292c269efb,0x00017244e70fd00c,0x00005746625ed20b}, {0x0001a886d579ca7d,0x000ce93524c3eb4b,0x000e55b6cbbeb85f,0x000ac397f9b15372,0x00008d4f84e13615}},
    {{0x00014bfea7be6361,0x0000f328d17ed214,0x000ea80165d13b52,0x00041cc1aad9829f,0x0000c636f9bdefd5}, {0x0000ae640d4367fe,0x000cfcc82e5d8210,0x000bf012b1a13811,0x000a40021a0ebf68,0x0000ad45395140c8}},
    {{0x000093d07e16c03e,0x0008c6451c1a84f0,0x000852fb8e51a85e,0x00027647baccab5c,0x00000422dfc5ea59}, {0x000ae8d127196bf4,0x000b0cd1f307d1d4,0x000f0c06f05e1809,0x000207246e68d69a,0x0000bcbd7a6ea8b4}},
    {{0x0005696102fe7961,0x000128787cbabc0b,0x00047e5568e8a8ab,0x0009702b888f7629,0x00007005dc539317}, {0x000060a74a16a3d8,0x00059d11f5a2d057,0x000d3eee179fdf94,0x000b1336970f75a5,0x0000b65be596af2e}},
    {{0x0009a12055784ff3,0x0007e7ad17886a59,0x00083e1be483ccc5,0x0009c2326844874a,0x000091668f7d203c}, {0x000ccc39b9c01312,0x00079a1a3a021ae3,0x0005da5e7959cb5b,0x000b1b1efee9f28a,0x0000e21b1fe45033}},
    {{0x000b7effce6692d1,0x000d13f99991b95a,0x000da1b42890b0d4,0x000cec15a2ba2f18,0x000018e795c7c8cd}, {0x0000ea0ad07b7906,0x00006d2815a727cf,0x000f20348a8fa2cd,0x0000bbc96ae70635,0x000009c2b7d97f76}},
    {{0x00046418aa05aea8,0x00032c224067ea96,0x000401680c850519,0x0007cca8ecdb3161,0x0000a6a937b896d5}, {0x00066b96e440f85f,0x00058873f7cca1fb,0x0001e2cd22d99b85,0x0005da4df8221d94,0x0000a05eba0d7a8a}},
    {{0x000ccce912fa29fb,0x0009036040b56b4f,0x000aaa682139e237,0x00037b99fe6891cc,0x00002cac906e3f6b}, {0x000c39a68efd2423,0x000f8bc753e95cc7,0x0000629055d8668e,0x00004e48e5d349cb,0x000092775e6d287e}},
    {{0x0007764026e7e174,0x000920bd6ff6034a,0x0009b2c9a18833c8,0x000cb370c9651f3d,0x00007e2a44c0c972}, {0x00096a65b39a0b5d,0x0001d09cbc9e0807,0x000b2736f0b90d16,0x000112ddcf44a1bc,0x000042acfae127da}},
    {{0x000a76b6b44ab8e2,0x0009970211cceab3,0x0007bcb9b4bb22b4,0x0002bea529e44146,0x0000e0960bc476de}, {0x0009eb77378cd806,0x000d80e280c90b95,0x00014d594586a4dd,0x000310e90d20f04b,0x0000702dbd838d2b}},
    {{0x0003a01c57e6e9d5,0x00050dcc40c8c9ea,0x00090cba6fe563eb,0x000cdf395633b94e,0x0000c9d1045e8592}, {0x000d2588f46a6120,0x000b035c6210c59d,0x000e8248377f9aa0,0x0001aa4bc93a5152,0x00009dc56ac7a30e}},
    {{0x0000c564a8ac4c7c,0x0000d81af1627a56,0x00070a724e6dfb29,0x0006e7fb2bded10e,0x00002349505c61bf}, {0x000695464c03716f,0x0003bbcbebaa5c11,0x0008aabafd07239a,0x000af38c2eeda57e,0x00005d614c1d1436}},
    {{0x000e2d0f37b76522,0x00070e55eb8f1e79,0x00012eab7fa064b1,0x000522fe70f9abc2,0x000086b2a1081854}, {0x000fa02edae5aa1f,0x0006c5bece8a7b0e,0x000db187a76faee6,0x0006c55f3bafbf59,0x00006262ab51cd1b}},
    {{0x000bbe31e35d4f00,0x0003907a6029f9fd,0x0001b672f257cd8f,0x000429f29248e19a,0x000039e13d803d69}, {0x000c3c7908e58df4,0x000b0c985ea865df,0x00061454801424f8,0x000683ceefa02118,0x0000ab80f32400a3}},
    {{0x000ccbfa3d84058f,0x0005df204d3c0698,0x0009081ed4ca5c5b,0x000e64a883950e9e,0x00003c31bda6008e}, {0x000eba6a97909010,0x000507b1fb8d71ea,0x000c9169209e9956,0x00037554f52879e7,0x0000877f94c1ed32}},
    {{0x00041833560eed57,0x000a8ec17822793f,0x000852b85ba8088a,0x000eb3fbd9a1b805,0x0000c928511df25b}, {0x00049c211a3b0cf4,0x000018434a1def45,0x000091951e39b0e8,0x000d49dac937eddd,0x0000e6ee324776c1}},
    {{0x00037b1d92a17bf5,0x00096a699f0dc99a,0x000418df6afc0eee,0x000e8cc36e947922,0x00009cd84baf92d6}, {0x000fb2308f6ca879,0x0004189720d764a4,0x000e233b6e8157a4,0x00069ab8b5bb2ca4,0x000095141e790e65}},
    {{0x0009a7ad4edfeab9,0x00058ba474c78c2d,0x000efd6802660b1d,0x0005206e51d4a61f,0x0000d0fffb51a30d}, {0x000df5af5e13c41d,0x0007aa82333d762c,0x000e12bdbf9f9cad,0x00053d28e2c067f3,0x0000c214dd58c9c4}},
    {{0x00078f73d96f6c3f,0x0009940a0114e12a,0x0001b5edb91b616f,0x0007802baa7c46a6,0x0000bbaf38454705}, {0x0007732bce06e6f0,0x0003fc6ea51ec6d4,0x0005ac7dbbd02767,0x000aa24c78933088,0x000003fd48baf268}},
    {{0x000f8cb8b6b4ac7c,0x00022da8657e62e9,0x0003e709fac0ceda,0x00044cb8924265f7,0x0000c2125359b00d}, {0x000a800aa4354d4a,0x000d4c76651dc137,0x0007663922833c83,0x000b7a7093741920,0x00005c10ea46162b}},
    {{0x000b2b4671f489d4,0x00020e7e4b59a1a6,0x0004a86d078a8249,0x000b641af729005d,0x0000ea40b308107c}, {0x000def837872ffaa,0x0007857e65950d35,0x000ed651235c3f22,0x00011d318b69bc2b,0x00007d4a4d9d4cd9}},
    {{0x000fd6bd4e1c6acf,0x000b32bebbbb5828,0x0006ac0ea31f3e32,0x00040df9c1459119,0x0000c2fd4bfc2e76}, {0x000758062d718466,0x00050f36b4cdcb16,0x000ce037ecddce26,0x000d9b542106c49a,0x00001395c0f493cf}},
    {{0x000af914a54fc7e6,0x0006b42c62b10386,0x000d7e90af5bd329,0x000fcca6ab95b008,0x000058cf981705ac}, {0x0006ad0ad9ea67f5,0x0002735b7f791274,0x000a4060040b2faa,0x00095a83921bae30,0x0000ffd2c5e32b21}},
    {{0x000674b3b3f874f0,0x0007d4409b672a9d,0x0000672a80e68f8e,0x000a89bb24a6bbac,0x0000764bbd0e6bff}, {0x0009c13926cecbb4,0x000855e317e76a63,0x0007ef017f7e5c24,0x0004e80cc86df969,0x00002f0f42dbf4c7}},
    {{0x000b383892850d4c,0x000fac8523726a45,0x000089ef29685093,0x0008bea48bf7c4ea,0x00008aeda7a9e560}, {0x000a3efd995bd374,0x00059297e7208f9d,0x00083d14216bcb93,0x00036a46e7fc0aee,0x000007b7c7bbdeb6}},
    {{0x000994e8c70b66c1,0x000130bc81bb46d0,0x000e193a3bdca94e,0x000df90e3c0eaa9d,0x00006ef1f3cb51b1}, {0x000e07f5cad99fe6,0x0007bf8cf7c18d04,0x0006f9681ba9db21,0x0002692711c2a3e4,0x00007a115d42378b}},
    {{0x0003015fb3d08b6f,0x000c4f6c706ce14e,0x0002810d3977d0d0,0x000113a60a8549f6,0x00007a49710c6b40}, {0x0006aaa6c9b79e08,0x00001c5d3a5208aa,0x000f719168540d4a,0x0004423dbcbdb8ca,0x00008b82b284445f}},
    {{0x000621189521a131,0x00084775b0e3f2a7,0x000ce99086411768,0x000ba2af92188e83,0x00005862571e2559}, {0x0006c25a01159e10,0x000092ee012a048e,0x000ac9e25f213af8,0x000a7eb2d7503aca,0x000090ced06d85df}},
    {{0x0007e9d9f2f897e2,0x000607493cf5a89c,0x0006d18655a12aad,0x000b1e1b64925a04,0x00004203d3d79adb}, {0x000e22319c02fe70,0x00061fa0ca3076f5,0x000fc06ebb171574,0x0003534d5b2e1b98,0x0000ffaca4b07d6c}},
    {{0x000e95aa6360241f,0x00033dbc40dbd017,0x000e41655d78a47f,0x0003ae0c5478f797,0x00000bc57e149c3b}, {0x000dae7e92fcb87d,0x0003e73d7446c12a,0x00038f6c156141b3,0x000d7b8287f1b57a,0x00002551bb07d0a3}},
    {{0x000fd03ba124dcca,0x0005595509e778f5,0x0003963210ede681,0x000218ecbd904ba4,0x000057275ec31263}, {0x00098cc31aed8686,0x0002beb9be3d4ea4,0x00082eebaa59cd5c,0x000fd1991ab4d3f2,0x00005b2b384a3ded}},
    {{0x000f10557f7f4aa8,0x0003141d09cb5332,0x000b95beb2cef476,0x0004c82395b067df,0x00006a03a2c01446}, {0x0007dfef0be79d46,0x0001874b97275902,0x000f1f7d4d0de182,0x00099478e33b191e,0x000006558b7e81b4}},
    {{0x0002253a17cfb28b,0x0008ebf590ba262d,0x0002d72dd21664a7,0x000c4587d06f2f4c,0x000078a8de65b6b7}, {0x0006920bc17757f4,0x000cced7a68a4b12,0x0009387c7e16b5bc,0x000b542e5005a393,0x000035a62cdf92da}},
    {{0x000c560972894920,0x0000c17d3c2a87c6,0x000f1f08a4bdb0dc,0x000b2096faa4d313,0x0000f5c7607dec01}, {0x000241e51762f134,0x000fb8b10c63b6bf,0x0006515f30290df0,0x000b35eeaa2454cf,0x0000f60852859665}},
    {{0x000ffb9fdfce9b8b,0x000d43b966a89729,0x000dfbd7523680f5,0x0004c7b2c6ef98d2,0x0000bddbb8a5b1c7}, {0x0009eb62b7763240,0x00018e7f61e7f249,0x000509a885746186,0x000dad9a93d36959,0x000078c35a5126bc}},
    {{0x0006dffe227d9c28,0x000f28fcd749c021,0x00055e1af43fc164,0x000360f372e79f59,0x00000013b15b60ce}, {0x000642c77d088ab9,0x000603408ad40c33,0x000e18e96bf7079b,0x00099f840d636eca,0x0000098c58ab14b4}},
    {{0x00077dceae2302a1,0x0003c806e6c54271,0x000040bb8f335915,0x00091da3eadeb94d,0x00009926a3190114}, {0x0000b030aa56fd94,0x0000717246b8a0c9,0x00086222ff4d2833,0x000a76bce47d40bd,0x000009d403daad8c}},
    {{0x00049006bdc08788,0x0002a29d68a05f2d,0x00010f595a285de4,0x000fb4d722cd48f7,0x0000b96085211d89}, {0x000ed5908b41453b,0x0009af492a0d2a10,0x00067065f4429afa,0x0000d313f5f74aa4,0x00002f8641f9b3a4}},
    {{0x0006ef58b386c69e,0x0001a846d58225da,0x0007c90a64e5c80e,0x000f8c90401eaf20,0x0000f4a430a9b672}, {0x00083d647db36e0e,0x000066dcdadc8cb2,0x00012d7df32946b6,0x00087fb7f7b1c8b7,0x00003c85bb7e9e41}},
    {{0x000f20bba2439114,0x0008ff1b65fc2e61,0x000bd0e126bb920d,0x000d9abec02fc3dd,0x000015d3897b9394}, {0x0009c1cab00a9be5,0x000d661f585cd907,0x000eaf788c0705c8,0x0001aea79d859521,0x0000252c9d8f4143}},
    {{0x000b2d546f92c5d7,0x0003d47db7b536a2,0x0009dff2df753503,0x000b555388239913,0x00004372074066a3}, {0x0008723137e3f7e9,0x0001485151c6d57c,0x0000aa2a55b532c8,0x000edd04c3cc6736,0x000002f7dcf55657}},
    {{0x0006d3ff179e220d,0x00068eb3de8acd58,0x000fd1863a8fa7c9,0x000f449cd5617fb7,0x00003a190b0c03e8}, {0x0003da277108421a,0x00071f8b6dc858d4,0x000e4ee68a60e733,0x0007f658c12f0abb,0x000025d073738153}},
    {{0x0003d6dc16b4e186,0x000656aa6bd02ef6,0x00089e652e089004,0x000d744acb852631,0x000092e329517ff8}, {0x000d8b234333e0b7,0x0001098802c15416,0x000dadb64e1c1b30,0x000c8f225decbe5f,0x0000d948a7a85c34}},
    {{0x000c6469dc81a049,0x00001a4e55e5d35c,0x000fef56b28459f3,0x00059cd0155f5c27,0x00001ebe8d5d8309}, {0x00085c4a7131df9f,0x00088fdec6667457,0x000715d18057e535,0x000cd2d684d8573c,0x0000a9ca6c7cd549}},
    {{0x000e2e3446f9e281,0x000846c258bb86ce,0x000f37d5b739bc37,0x000c9b9746166b21,0x00008414a89a8b8e}, {0x000bb1b9f25ff8ad,0x0002a4dd50af0d98,0x0005b5a78084af6f,0x000ddb4667c708f9,0x0000c1e90d79e098}},
    {{0x0000f830f7f7a925,0x000962af6600ea3e,0x00042c1e3595c08f,0x000cafae22538bd4,0x0000b3101d3fcabd}, {0x00078afde4e64419,0x00007b0a9e895fab,0x000894659c483333,0x0005c40891f85893,0x000036cd9f687b51}},
    {{0x0000fdb1e5a3d569,0x0009b0374bf3035e,0x000a9b06d21be1c3,0x000609411de8deaa,0x00005478125def93}, {0x000338bc9cf8d1b1,0x0008608556303bd3,0x0001d00508c2e2ca,0x000a2a6d1106d92f,0x00001e1311fff629}},
    {{0x00008c0c7abe48cc,0x000a32325b3f3714,0x000cdd15b7dbb702,0x0009f3c37123b082,0x0000f285904b770f}, {0x00005a5f3b665bd4,0x0000eb9cff9258ce,0x000ae583f954f24f,0x000e2d7d0276a007,0x00008112308cea23}},
    {{0x0006ebf442107be7,0x0007b1a909f1ccdf,0x000684e1ca8ff7cb,0x0003f085d46ef075,0x00007121a630d6bf}, {0x0005761fbdeb7490,0x000711a947654819,0x000865547aecae1a,0x0007358f2f2b4382,0x0000d528600f8f9b}},
    {{0x0006e9b28d21be4d,0x000d16dba462a3c9,0x00054aae39c8bb2c,0x000b130de6632450,0x0000287f45d91f55}, {0x000e421a7d459f3d,0x0002a3b3137c7299,0x00044882490d7904,0x000bfb28faff33f9,0x0000bfb8dc9f56ed}},
    {{0x0006eaf73f22dd85,0x00040159d50c4c19,0x00084c5827c96b79,0x000f295616bb5386,0x00009e99fb634b73}, {0x000fa8d3a114007f,0x000921cf2fb36503,0x0007d77d78896f76,0x000aa84fde09fec7,0x00003da7be4c60d5}},
    {{0x0002bfa99958d23f,0x000c81847d0a62cc,0x000dfe7c5fb5c76d,0x0005c6e11e7e50b2,0x000088e3280b0e5e}, {0x000682d38e3cd1aa,0x0008a2d2a17ecd17,0x000fbf0977af10a9,0x00050e0a422c42e4,0x0000a1dd9f7d6448}},
    {{0x000e96433c0805a5,0x000d7869abf94e41,0x000dc5ed1e35cc84,0x000f55a120bac5dc,0x0000d5f11d73cf91}, {0x000b444c48e7a259,0x000d3d34f5e7ffb3,0x000617df908d9b25,0x00074f19c9a1d296,0x0000b424cec270cf}},
},
{
/* digit=36 [{1,2,3,..,}]*([2^252]*G)  */
    {{0x0004e9d192cabe16,0x000136ac20d6f4c3,0x000b9a9a95ed7b38,0x00037f743f5452cd,0x00003e7e859d699c}, {0x000288719e08654e,0x00055a84a99d8b7c,0x000b5e1d47df6f11,0x000affb8f70d6ecf,0x00000f85856658fd}},
    {{0x000989794fdccb99,0x000664d2a5d09eb7,0x000f3dbd4a6c29d7,0x00006c08e7b46244,0x0000d3275732baf1}, {0x00078611cb5eac27,0x0009d9c76502f96b,0x0008f3ffdf832947,0x0006d50496b021f2,0x0000f3bea3e2eab2}},
    {{0x000d467bef953373,0x000f071bddfa0d77,0x000be423588d7262,0x00060e99185a1f4d,0x0000bc436399b964}, {0x0008c2ad1207560e,0x0002054fdbb7908a,0x00099c759edae8a1,0x000c0e4e054bfa36,0x00002db152ab5cf2}},
    {{0x0006019816bb79c3,0x00025d9ee9893bd2,0x0005c447c9f4d46a,0x0009c26760f22454,0x00003b25455b00de}, {0x0000cad04873a72e,0x00074e432c4decdc,0x0006750b41e24738,0x0009f681a6c25f63,0x00003d05248bbaa4}},
    {{0x000481d262409089,0x00085ea18d0661c9,0x000e20eb4c37806a,0x0009090d6babcb16,0x00008acecc7050ae}, {0x0006575fb2de613b,0x000121a2f094246e,0x000405eec4b33ebe,0x000e1064f6eb1a6a,0x0000d337e63aa2db}},
    {{0x0001242ccb9661a4,0x000e4b4b735a681a,0x000038cb78b1e57f,0x00048653161304f1,0x0000e5b9a8a398a9}, {0x0006e7de5b2bfae6,0x0000b846b3a7915a,0x000464483729cd42,0x000aefe28c607ed3,0x00003f2fb772d468}},
    {{0x000198fd906ce680,0x000617f59c8fd445,0x000002f38f184755,0x000e15c2f310b252,0x0000a4410ce1ced3}, {0x000ed8c1a5559846,0x000e72884eb22a13,0x00019d74e6e7911f,0x000e37cee1a905d1,0x00006f730d7170da}},
    {{0x0002fb6223e426f1,0x00089ec0aa53e22b,0x00041c88f08382bc,0x000f3ce723df210f,0x0000eab10c6e3af5}, {0x000e9ee919f420f9,0x0007feb7d658384a,0x000d6cb287d7bf16,0x000e7944e141cd92,0x000072357ff59e5d}},
    {{0x000c56b5bf5b4709,0x000351a00ac5adc6,0x0000eea7fa5bc587,0x000fa53e96a1bcfc,0x000037fcff36ffa5}, {0x0009f297dcabee43,0x000a97014f90ac36,0x000a4fb4897cf19a,0x00023c3e53d9a7ae,0x000088e0a1c87728}},
    {{0x00085910c59fc2ff,0x000edd337895b65f,0x000511aab9da9784,0x0003096a69799310,0x0000e52ae4181572}, {0x000749531e18c1e3,0x0008b80751a2bb45,0x00001252b398f247,0x00055b499d5957ef,0x00003146d57f9c23}},
    {{0x00016eba4eecc3be,0x000ce1567b234d2f,0x000efba21f561158,0x000a7d55857190e0,0x0000320ec77503ce}, {0x0002c5e31d91219f,0x0008a202612ab98d,0x00046d14dd97213e,0x000914064ebf5b24,0x0000252742c3551c}},
    {{0x000892bae35f8fff,0x0007393a7330c288,0x000e452adeb6025c,0x000fa6fdb0931841,0x00000230ffaf8bad}, {0x0009c569666cb64c,0x00028c9c1a11d83c,0x0006d175be8ee2b7,0x000fc1d4d08c60fb,0x0000e59f68cfb17a}},
    {{0x0004746057984cd0,0x0000120adf81173d,0x000dccffa456524a,0x0003ddbb34c2a11e,0x000094498314e67d}, {0x000864a8165bdf84,0x0001548f9fd22672,0x0002502dc589998c,0x0002ff4896359671,0x000033a8860e87ea}},
    {{0x0004df6843c364e9,0x000b16a5ee86621f,0x000f9457ae1f592d,0x000240793da6c122,0x00002d742b08fcfb}, {0x0008c3f73811884b,0x0007e71f910c2c7a,0x000405a5a15bfcfb,0x000f363a542968cd,0x0000a72904aaf04d}},
    {{0x000ffef7441e12e9,0x00042919f0edc246,0x000792a5bbf274ab,0x000883a1dbf3b485,0x00006fed0fa498e2}, {0x000247ca159aa0db,0x000cb4ac34f0f016,0x0007adee02259b6f,0x000ab0e110a89e6a,0x0000df1a3bccde15}},
    {{0x0009939fe95894f3,0x0006d80da64f7f5b,0x0005668fb3c50e7c,0x000b18adf2c440f9,0x00002885888ec566}, {0x00067d3ea0cc76aa,0x000b0b26bc3ba506,0x0004568d5f276915,0x0001f136016d96ad,0x0000a9984da49550}},
    {{0x000d0ed6b7a871b6,0x000ab42c02ff0806,0x0009af12f46ee10a,0x0005d377ff131d77,0x00005a677099acd8}, {0x000ac9b951626815,0x0009abdb942babd9,0x00036440880eb706,0x000163339c586c4f,0x0000709ca935dc3b}},
    {{0x000ff3ccda445aca,0x000f0859e39c86a5,0x00090203fe429386,0x0008a52bf2703bab,0x0000720aa0200a65}, {0x0007538fdce5c9c9,0x00015246ebcb614e,0x0001842f337ae4a6,0x000828acc435ef95,0x00005e104588fd92}},
    {{0x0003cab9fe36412f,0x000c67555bd68737,0x0001bae6459ab06a,0x000fa54dfd187fa0,0x0000876a919b3578}, {0x0002b2279ace5b23,0x00067ca98cbd005b,0x000e40955a4d14a0,0x000970e03ea45012,0x00007185a2170d87}},
    {{0x0005612acb6e9367,0x0000244b28116bc6,0x0000fe9ace978300,0x00001bd8b738ef68,0x0000764500d3e681}, {0x0005a153f84b39ee,0x0004d79c4f71c297,0x000ad48b40f23e0d,0x000fe1df83cf30f0,0x0000ed994a14ad8c}},
    {{0x0006efacdd042013,0x0003311876df9490,0x0002bc23a0bac093,0x00009572e8adfc0d,0x0000c9e44ac33ba1}, {0x0007febbe90ab31f,0x0000bd134ef68004,0x0007788b8aa2b3eb,0x00025338748a1e98,0x0000b0f3a19b0368}},
    {{0x0006fbd381cc78af,0x00071706d2d15d34,0x000ee95e156dcdce,0x00005368df42e000,0x00005cd53efe90cd}, {0x00031ea895eeeb96,0x000ccf55d9280aea,0x0007880c92d842de,0x00017146595637e4,0x0000641ce44806ad}},
    {{0x000824118043c9a3,0x0005cf70caa98b65,0x000f51f396391481,0x000f7d40813d12f8,0x0000547dad76afc8}, {0x000149d080befd0b,0x000b7195cedc7d61,0x0009dc3f0e5886a2,0x0004cb9a99003a55,0x00007bf2af415c17}},
    {{0x000b64ed8b470837,0x000667567a1863c8,0x000a8958dda010c6,0x0009d8fce07e107c,0x0000333c3dcb7dec}, {0x000eef3725031b69,0x000b3d8017798df6,0x0004553846f57184,0x000740a78efac9c4,0x000091dcab915273}},
    {{0x00034d3d7a665eae,0x000176ef69c8e8cc,0x0002d1efd49af983,0x000c8da18040aabd,0x00003d8b47daa6ea}, {0x0002a6ab05930688,0x000ae5a1d5b5c164,0x000ec89eb5f6487d,0x000e45cd4ff7be70,0x0000da3d01424bad}},
    {{0x00038654291e9930,0x0005df3ebe005344,0x00051191326bf2e8,0x0002cb4d29e094e5,0x0000c2bfc12b6dc4}, {0x000c45947fa997d1,0x000efc7b04beec10,0x00092b0b4c905403,0x0008649820b0076a,0x00000768c5a27aa6}},
    {{0x0004fa4594af9a68,0x000599a9cc36d9eb,0x000b7f57263399f3,0x0000337fb3d0ceae,0x00005ca399f0e87c}, {0x000ea931d2385710,0x0001ed59e07954dc,0x000a7c626181c100,0x000429eb1a4ec0a3,0x000096fa65837c79}},
    {{0x000024de86d1520e,0x00030986cb7e66af,0x000efe7c68e15b56,0x000d805f49c36865,0x0000ab5898f85171}, {0x0005276853f145ec,0x000381824620abe6,0x000b802ce92b4fb6,0x00036d087612db6f,0x0000a0d67a1b76f7}},
    {{0x0004f2782c6ac72a,0x0003cafa67117a5c,0x0002aab6fb1c93c9,0x0004a540bc21b67e,0x0000934f022b3868}, {0x000d03cbbc8303f2,0x0004a4fb67b44644,0x00075a8b54b44e4e,0x0007e18bf968e89e,0x00000f6f42ac1a37}},
    {{0x000486f46ce1f619,0x000037a2e0f90539,0x00020a418cea6f5e,0x000ba43f6c178ddf,0x00006ab2cb90f6c4}, {0x0004b1c6938cfc22,0x00020e13845f695e,0x000d68e0193de57e,0x000ebc9ff5be6cb4,0x000002c5058b0d9d}},
    {{0x000c3c04fde203fa,0x0005baff5dd91577,0x000ef4054c12be81,0x0006add827ff0b61,0x0000a1f02d5283f0}, {0x0006692f1555eecd,0x000c44b0a336ee5a,0x00082f8f5b11fe2e,0x000da11c05d843a5,0x0000c68bae17ef36}},
    {{0x000ee12df5fabf2b,0x000be45a670b441d,0x000c610623c7e5fd,0x000d5872bd798c04,0x00009e1db3844e1d}, {0x0005ddaf191ee063,0x000f3d7cea2df0ad,0x00086387d70cdf49,0x000cefd8af41cf1c,0x00009846533056ae}},
    {{0x00021d62549e2b45,0x00037cb224e3c015,0x000678b1ce2f4b85,0x0000525f28baa01d,0x00005d6e33c34710}, {0x000d0d35e745bee9,0x000f90455fdf7490,0x000eb3d3ef5582c0,0x000a223455ee33cb,0x0000ede029ddb7d6}},
    {{0x00094f9647c9d90c,0x0009ae5f214b69bd,0x0007a420dba58efa,0x000a1778c3aa70bb,0x00005b6de0077a42}, {0x0009d9ea019d4132,0x0007f0e583e34c87,0x0005be0ce07a75bd,0x000b6b3d395891e3,0x0000411317743abc}},
    {{0x00071e9d9637bd7b,0x000aa30673d89731,0x0004f6faaa823ed5,0x0008bb2383e64b03,0x00002b4b7d4e2602}, {0x00010fb3c893e582,0x00051b773cca2248,0x0007552b33ebecfb,0x00069cecde31e97f,0x00008f7134559072}},
    {{0x000b81bd0d95dfea,0x000920c24df0288c,0x000310dd6c5ef9f3,0x000d5abf1b0350c5,0x0000ad3ddb3e8a48}, {0x000dd398b526731f,0x0005384805e5c192,0x000b7e61e9fed2fe,0x000e23cfdd2588ba,0x0000c740a3eef5c3}},
    {{0x000eac2018c33f78,0x0006fe797f0c8057,0x000b588aee816f24,0x000cabc89d091be7,0x00003cd7be0bdaf6}, {0x0009197eaba2edb2,0x000261290082c9bf,0x0002d252eb7c7e7f,0x000069d1ae302bc4,0x000059df1546cf2c}},
    {{0x000c6ed00d94ec36,0x00088e1af59b2c21,0x000e2ff2bcf61175,0x000869457c578360,0x0000523a23621201}, {0x00034a09be29e76a,0x000690f5c6bae145,0x0006b6f117764e98,0x000976119eff6ee2,0x000083c1f34b5380}},
    {{0x000aa5996ef32628,0x000199d82779220a,0x000d1241a4aeba26,0x000ed2f9f34d5f06,0x00004acf34a65fce}, {0x000315c7f2ccd41e,0x000c5fdf0096ae54,0x00080691f3391667,0x00052631991b02d6,0x0000c48b23574895}},
    {{0x0008812c701e04a9,0x0002050be8112a19,0x000edb9dd4072896,0x000fd219a3328fa8,0x0000e4723d681c68}, {0x0004a362eddf7e14,0x000fa26194b59490,0x000cc6e78db8c366,0x0006655f1cc62e79,0x0000d82e71dbd404}},
    {{0x00042661e0e01d69,0x000365b508430cfc,0x0009c570783ab355,0x000126719831e04a,0x000080fe3aa553aa}, {0x0005fba614f1229e,0x000ff23b90b04642,0x00088bd06048f481,0x0003938fab45f5ed,0x000081191df8129f}},
    {{0x000e6fa9951025d2,0x00041ecbf164a4d8,0x000d2f4e8491ed8a,0x00055b97fd6f9239,0x00006956adf726ae}, {0x0003a64e362a0314,0x000daa7b2078d584,0x00085660784da40f,0x000e2e4313534367,0x000074d604a28332}},
    {{0x000a9eacf4537898,0x0002535b7ed6beae,0x000d61511432f159,0x000edfe8ae015426,0x0000e7ad54ed3027}, {0x0008791dd6d06fcd,0x000cbb7fbce3acab,0x000bc7d0c0bc5826,0x000ec5864d8cb9b5,0x0000d5249e385260}},
    {{0x00031d9a10b92593,0x000b60bc06806933,0x000608f7d34ced3d,0x000e6d0d2006d8b2,0x0000aed68ceedb49}, {0x00015ad47c543ae5,0x000bbf84989e807a,0x00020645060e02d8,0x000196b5ba87d4ae,0x000068321bbe2e41}},
    {{0x000fa99480713a9b,0x00006bf34178f755,0x000be4593bc93577,0x0006d10a3c6ef3f1,0x0000310bacda7514}, {0x00057088f40a62e7,0x0005ee7b59e56baa,0x000af9ff64d366c7,0x0004ffc6b10b30ad,0x0000d6bd4deb6eb0}},
    {{0x0003bad7134faa7e,0x000c0b033f5eaa35,0x000e4f98ff42bcb8,0x000ec9a998139559,0x0000f99dd5db139f}, {0x00009ecb311e12f8,0x0002adc0a4dc54fc,0x0005c0b088460433,0x000ce37796ea0ae1,0x0000ece0022c632b}},
    {{0x000a05993f51c69f,0x00070bea577129dd,0x00064408337ea113,0x0005a48ba7c02c90,0x000035f93ee50fde}, {0x0001277019f51c41,0x0006adfd4c1abe93,0x00083e23a3e47aca,0x000aa67a89f9df66,0x000092d1f5304fa0}},
    {{0x000ac330d6c7b459,0x00082e88c3411e11,0x00005313b3e445d1,0x0006bc33cc1dc4d9,0x00004685343106e0}, {0x00051b83920ae37d,0x0001c71d6750f1e5,0x000b709a1faade96,0x0007149f2dc25e54,0x0000b71cc89b494b}},
    {{0x000f3f8d09521bed,0x0008512c9daab73a,0x0003da2ba27d45d8,0x00053296a099b7b5,0x0000e7f2156e567c}, {0x00017ea24df91ea0,0x000270e60988d6c3,0x000418dde749e07d,0x0007a0c55165c906,0x00000189658e7c42}},
    {{0x0005554a920980f5,0x0004d83056f4f7dc,0x000745be3258ac61,0x000646af5b2b9c78,0x000032efb61c140e}, {0x00065f3c23f4987a,0x00029a1787327ea8,0x000b93558610d559,0x0001dac6b44f9ef7,0x00008c3f3947610c}},
    {{0x00036c41c02e3f96,0x000c00d78de5829f,0x0006cdb1416e315b,0x0006d6039934b045,0x00005408b5b7c401}, {0x000046423ee53cf9,0x000ca2000b9b28d8,0x000ac80402e6f559,0x000737cf3b0e8eab,0x00000a478fff164c}},
    {{0x000d5dbc3bce5259,0x000a79bab068adc4,0x000702cff0e692d9,0x0009162104dab4e1,0x00007c3b223bc6e0}, {0x000a4bae9b92e722,0x00066cd5c34091b3,0x0006af7b98c5842b,0x00046e36bf2afb32,0x0000e0928bb0a702}},
    {{0x000e1f1c48f51b67,0x000e3017ad888cfc,0x000124d6978fa7fb,0x00020cae67af53f3,0x00001d14379ab093}, {0x0006d3efd5b32f13,0x0008955fa05fbe53,0x0000194e6d931907,0x0003184e5f4c7300,0x0000f48a960c8670}},
    {{0x0004dae073946e67,0x00069e56390f104b,0x00034438ec69b46a,0x0003d9a22a832b30,0x000078dfabdaf745}, {0x00083fe3d2f9dc1d,0x000b45b9863f9203,0x000ed43a45a02d9b,0x0004dc1e596b8494,0x00001045a9c041b7}},
    {{0x00016c0a59ce7847,0x0003816390641219,0x000c52eac415e082,0x0004dd076ea35e04,0x0000e4629568ba7c}, {0x00071b6a7b975de1,0x0007b677e54ee47d,0x0004a7e4c03aec55,0x0002fc9359233ebf,0x00003b0f0abe072b}},
    {{0x000dfefe8800dcd2,0x0007813d211bb68d,0x0006e883a7a79b7c,0x0004ea45689552b4,0x00008de706a7de1a}, {0x000c4e3d983df145,0x000fdfedeea597b3,0x0000e50daef33ef9,0x00096c99395a861b,0x0000f4ee038dd678}},
    {{0x0002fa9a80943602,0x000a160fc4fb1606,0x000a18843d079884,0x000fdcfc9ae67dea,0x0000de5999876f2b}, {0x0001e086666832ff,0x000ac7312a202d98,0x000df4eb39af1d51,0x0006ba69df8bab4d,0x00004f813058f3c4}},
    {{0x000e4d9deba1f764,0x00046544992ba84d,0x00062571d3ef1e08,0x0003d6cdf5b4eef3,0x0000c6b0de82e039}, {0x00019759c17b4e15,0x0007eb4e8f856535,0x0002db7b0e1f35cb,0x000a2de21c2ce964,0x0000ede5f6162f54}},
    {{0x0002e8ff962e6fb2,0x0003791b5f6c1220,0x000daf6cb28042fd,0x000a0d5f509fdfe4,0x0000a70291c45d04}, {0x000e258b0e2b68da,0x000b17fac85bdaf9,0x000d1b986bf47d76,0x0002f63d6778a846,0x0000223266c01388}},
    {{0x000f6489e4813958,0x00073454ba37e004,0x000852a0cf198eb2,0x0001c1d7d37038b3,0x00005057db2e3939}, {0x000ab92ce347b4c8,0x000ca340fa0188c7,0x000ef094a8b99eb3,0x00014dcfa7df268e,0x00005a65feda02ad}},
    {{0x0006ea594087938e,0x000c2c29c1b6b97c,0x000fcd2e662321e1,0x0007d0edd9981f5b,0x0000571509bfdac6}, {0x000506cccb99c73e,0x000781554bcdd381,0x00076723b50a8b0a,0x000df26130d1d4f5,0x00007791681ec370}},
    {{0x00016a84ca2278a7,0x0005b22100cbee90,0x0008b97d91e063af,0x000ba251ae16b457,0x0000b228a1a62245}, {0x00037ce46041bf2a,0x0009154529a0343c,0x00093bcf590509e3,0x000354b75ffee430,0x0000d443bb4bab01}},
    {{0x000f1435aaae6483,0x000a104f999a4352,0x0009f21ba7c9f131,0x0005b56e3000fcee,0x000045e97d130480}, {0x000862d2138a5c21,0x0006da716279c728,0x0006fa6fa150dba3,0x00084fa32f114503,0x000020200ebf2740}},
    {{0x00090af2a4f30bb8,0x000233a2204ec06a,0x000572fbdc316dfd,0x0002843a0475a78f,0x00004ba9e239c4e7}, {0x0009abfc1137d0a0,0x00011346b7ea4127,0x000361a1d3145421,0x00011092560f9c0e,0x0000e66391042bad}},
}
};

#endif //(_DISABLE_ECP_SM2_HARDCODED_BP_TBL_)

IPP_OWN_DEFN(const cpPrecompAP *, gfpec_precom_sm2_radix52_fun, (void)) {
   static cpPrecompAP t = {
      /* w                = */ BASE_POINT_WIN_SIZE,
      /* select_function  = */ gesm2_select_ap_w7_ifma,
      /* precomputed_data = */ (BNU_CHUNK_T *)ifma_ec_sm2_bp_precomp
   };
   return &t;
}

#endif //(_IPP32E >= _IPP32E_K1)

#endif // _IFMA_ECPRECOMP7_SM2_H_
