# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ORACLE_RELEASES += 9

.PHONY: all
all:: oracle-cloud-9.$(GARDEN_ARCH).qcow2 oracle-cloud-9.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/oracle/OL9U5_aarch64-kvm-cloud-b117.qcow2
fetch: $(GARDEN_DL_DIR)/oracle/OL9U5_x86_64-kvm-b253.qcow2

$(GARDEN_DL_DIR)/oracle/OL9U5_x86_64-kvm-b253.qcow2: | $(GARDEN_DL_DIR)/oracle
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://yum.oracle.com/templates/OracleLinux/OL9/u5/x86_64/OL9U5_x86_64-kvm-b253.qcow2)

$(GARDEN_DL_DIR)/oracle/OL9U5_aarch64-kvm-cloud-b117.qcow2: | $(GARDEN_DL_DIR)/oracle
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://yum.oracle.com/templates/OracleLinux/OL9/u5/aarch64/OL9U5_aarch64-kvm-cloud-b117.qcow2)

$(GARDEN_DL_DIR)/oracle/oracle-cloud-9.x86_64.qcow2: $(MAKEFILE_LIST) | $(GARDEN_DL_DIR)/oracle $(GARDEN_DL_DIR)/oracle/OL9U5_x86_64-kvm-b253.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/oracle/oracle-cloud-9.aarch64.qcow2: $(MAKEFILE_LIST) | $(GARDEN_DL_DIR)/oracle $(GARDEN_DL_DIR)/oracle/OL9U5_aarch64-kvm-cloud-b117.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/oracle/oracle-cloud-9.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/oracle/OL9U5_x86_64-kvm-b*.qcow2 $(GARDEN_DL_DIR)/oracle/OL9U5_aarch64-kvm-cloud-b*.qcow2
