/* soapC.cpp
   Generated by gSOAP 2.8.124 for calc.h

gSOAP XML Web services tools
Copyright (C) 2000-2022, Robert van Engelen, Genivia Inc. All Rights Reserved.
The soapcpp2 tool and its generated software are released under the GPL.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
--------------------------------------------------------------------------------
A commercial use license is available from Genivia Inc., contact@genivia.com
--------------------------------------------------------------------------------
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.124 2022-12-04 21:01:09 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->version && soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, ""))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->version && soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (soap->header == NULL)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (soap->fault == NULL)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (soap->fault == NULL)
			return;
	}
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code == NULL)
		soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Reason == NULL)
		soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", "");
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault == NULL)
		return NULL;
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)(void*)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)(void*)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault == NULL)
		return NULL;
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
	{	if (soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode == NULL)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			if (soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode == NULL)
				return NULL;
		}
		return (const char**)(void*)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)(void*)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_fault_subcode(struct soap *soap)
{
	if (!soap->fault)
		return NULL;
	if (soap->version == 2)
		return soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode ? soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value : NULL;
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault == NULL)
		return NULL;
	if (soap->version == 2 && soap->fault->SOAP_ENV__Reason)
		return (const char**)(void*)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)(void*)&soap->fault->faultstring;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_fault_string(struct soap *soap)
{
	const char **s = soap_faultstring(soap);
	return s ? *s : NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault == NULL)
		return NULL;
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Detail == NULL)
			soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		return (const char**)(void*)&soap->fault->SOAP_ENV__Detail->__any;
	}
	if (soap->fault->detail == NULL)
		soap->fault->detail = soap_new_SOAP_ENV__Detail(soap, -1);
	return (const char**)(void*)&soap->fault->detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_fault_detail(struct soap *soap)
{
	const char **s = soap_faultdetail(soap);
	return s ? *s : NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, NULL, &t))
				if ((soap->error && soap->error != SOAP_TAG_MISMATCH) || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, const char *tag, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
#ifndef WITH_NOIDREF
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, tag, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, tag, NULL, "xsd:int");
	case SOAP_TYPE_double:
		return soap_in_double(soap, tag, NULL, "xsd:double");
	case SOAP_TYPE_ns__pow:
		return soap_in_ns__pow(soap, tag, NULL, "ns:pow");
	case SOAP_TYPE_ns__powResponse:
		return soap_in_ns__powResponse(soap, tag, NULL, "ns:powResponse");
	case SOAP_TYPE_ns__div:
		return soap_in_ns__div(soap, tag, NULL, "ns:div");
	case SOAP_TYPE_ns__divResponse:
		return soap_in_ns__divResponse(soap, tag, NULL, "ns:divResponse");
	case SOAP_TYPE_ns__mul:
		return soap_in_ns__mul(soap, tag, NULL, "ns:mul");
	case SOAP_TYPE_ns__mulResponse:
		return soap_in_ns__mulResponse(soap, tag, NULL, "ns:mulResponse");
	case SOAP_TYPE_ns__sub:
		return soap_in_ns__sub(soap, tag, NULL, "ns:sub");
	case SOAP_TYPE_ns__subResponse:
		return soap_in_ns__subResponse(soap, tag, NULL, "ns:subResponse");
	case SOAP_TYPE_ns__add:
		return soap_in_ns__add(soap, tag, NULL, "ns:add");
	case SOAP_TYPE_ns__addResponse:
		return soap_in_ns__addResponse(soap, tag, NULL, "ns:addResponse");
	case SOAP_TYPE_PointerTodouble:
		return soap_in_PointerTodouble(soap, tag, NULL, "xsd:double");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, tag, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, tag, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
#else
	*type = 0;
#endif
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:pow"))
		{	*type = SOAP_TYPE_ns__pow;
			return soap_in_ns__pow(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:powResponse"))
		{	*type = SOAP_TYPE_ns__powResponse;
			return soap_in_ns__powResponse(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:div"))
		{	*type = SOAP_TYPE_ns__div;
			return soap_in_ns__div(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:divResponse"))
		{	*type = SOAP_TYPE_ns__divResponse;
			return soap_in_ns__divResponse(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:mul"))
		{	*type = SOAP_TYPE_ns__mul;
			return soap_in_ns__mul(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:mulResponse"))
		{	*type = SOAP_TYPE_ns__mulResponse;
			return soap_in_ns__mulResponse(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:sub"))
		{	*type = SOAP_TYPE_ns__sub;
			return soap_in_ns__sub(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:subResponse"))
		{	*type = SOAP_TYPE_ns__subResponse;
			return soap_in_ns__subResponse(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:add"))
		{	*type = SOAP_TYPE_ns__add;
			return soap_in_ns__add(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:addResponse"))
		{	*type = SOAP_TYPE_ns__addResponse;
			return soap_in_ns__addResponse(soap, tag, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, tag, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, tag, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
#ifndef WITH_NOIDREF
	}
#endif
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input at level = %u body = %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other && !soap->fignore)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && !soap->fignore && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, NULL, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body && soap_ignore(soap))
				return soap->error;
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, SOAP_MULTIREFTAG, pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE_ns__pow:
		return soap_out_ns__pow(soap, tag, id, (const struct ns__pow *)ptr, "ns:pow");
	case SOAP_TYPE_ns__powResponse:
		return soap_out_ns__powResponse(soap, tag, id, (const struct ns__powResponse *)ptr, "ns:powResponse");
	case SOAP_TYPE_ns__div:
		return soap_out_ns__div(soap, tag, id, (const struct ns__div *)ptr, "ns:div");
	case SOAP_TYPE_ns__divResponse:
		return soap_out_ns__divResponse(soap, tag, id, (const struct ns__divResponse *)ptr, "ns:divResponse");
	case SOAP_TYPE_ns__mul:
		return soap_out_ns__mul(soap, tag, id, (const struct ns__mul *)ptr, "ns:mul");
	case SOAP_TYPE_ns__mulResponse:
		return soap_out_ns__mulResponse(soap, tag, id, (const struct ns__mulResponse *)ptr, "ns:mulResponse");
	case SOAP_TYPE_ns__sub:
		return soap_out_ns__sub(soap, tag, id, (const struct ns__sub *)ptr, "ns:sub");
	case SOAP_TYPE_ns__subResponse:
		return soap_out_ns__subResponse(soap, tag, id, (const struct ns__subResponse *)ptr, "ns:subResponse");
	case SOAP_TYPE_ns__add:
		return soap_out_ns__add(soap, tag, id, (const struct ns__add *)ptr, "ns:add");
	case SOAP_TYPE_ns__addResponse:
		return soap_out_ns__addResponse(soap, tag, id, (const struct ns__addResponse *)ptr, "ns:addResponse");
	case SOAP_TYPE_PointerTodouble:
		return soap_out_PointerTodouble(soap, tag, id, (double *const*)ptr, "xsd:double");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)(void*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)(void*)&ptr, "xsd:string");
	case 0:
		return SOAP_OK;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_putelement '%s' failed for type %d in soapC.cpp\n", tag ? tag : "", type));
	return soap_element_empty(soap, tag, 0, NULL); /* unknown type to serialize */
}
#ifdef __cplusplus
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ns__pow:
		soap_serialize_ns__pow(soap, (const struct ns__pow *)ptr);
		break;
	case SOAP_TYPE_ns__powResponse:
		soap_serialize_ns__powResponse(soap, (const struct ns__powResponse *)ptr);
		break;
	case SOAP_TYPE_ns__div:
		soap_serialize_ns__div(soap, (const struct ns__div *)ptr);
		break;
	case SOAP_TYPE_ns__divResponse:
		soap_serialize_ns__divResponse(soap, (const struct ns__divResponse *)ptr);
		break;
	case SOAP_TYPE_ns__mul:
		soap_serialize_ns__mul(soap, (const struct ns__mul *)ptr);
		break;
	case SOAP_TYPE_ns__mulResponse:
		soap_serialize_ns__mulResponse(soap, (const struct ns__mulResponse *)ptr);
		break;
	case SOAP_TYPE_ns__sub:
		soap_serialize_ns__sub(soap, (const struct ns__sub *)ptr);
		break;
	case SOAP_TYPE_ns__subResponse:
		soap_serialize_ns__subResponse(soap, (const struct ns__subResponse *)ptr);
		break;
	case SOAP_TYPE_ns__add:
		soap_serialize_ns__add(soap, (const struct ns__add *)ptr);
		break;
	case SOAP_TYPE_ns__addResponse:
		soap_serialize_ns__addResponse(soap, (const struct ns__addResponse *)ptr);
		break;
	case SOAP_TYPE_PointerTodouble:
		soap_serialize_PointerTodouble(soap, (double *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)(void*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)(void*)&ptr);
		break;
	}
}
#ifdef __cplusplus
}
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_dupelement(struct soap *soap, const void *ptr, int type)
{(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	return NULL;
}
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_delelement(const void *ptr, int type)
{(void)ptr; (void)type; /* appease -Wall -Werror */
}
#ifdef __cplusplus
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{	(void)type;
	switch (t)
	{
	case SOAP_TYPE_ns__addResponse:
		return (void*)soap_instantiate_ns__addResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__add:
		return (void*)soap_instantiate_ns__add(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__subResponse:
		return (void*)soap_instantiate_ns__subResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__sub:
		return (void*)soap_instantiate_ns__sub(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__mulResponse:
		return (void*)soap_instantiate_ns__mulResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__mul:
		return (void*)soap_instantiate_ns__mul(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__divResponse:
		return (void*)soap_instantiate_ns__divResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__div:
		return (void*)soap_instantiate_ns__div(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__powResponse:
		return (void*)soap_instantiate_ns__powResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__pow:
		return (void*)soap_instantiate_ns__pow(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap *soap, struct soap_clist *p)
{
	(void)soap; /* appease -Wall -Werror */
	if (!p->ptr)
		return SOAP_OK;
	switch (p->type)
	{
	case SOAP_TYPE_ns__addResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__addResponse*>(p->ptr), struct ns__addResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__addResponse*>(p->ptr), struct ns__addResponse);
		break;
	case SOAP_TYPE_ns__add:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__add*>(p->ptr), struct ns__add);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__add*>(p->ptr), struct ns__add);
		break;
	case SOAP_TYPE_ns__subResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__subResponse*>(p->ptr), struct ns__subResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__subResponse*>(p->ptr), struct ns__subResponse);
		break;
	case SOAP_TYPE_ns__sub:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__sub*>(p->ptr), struct ns__sub);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__sub*>(p->ptr), struct ns__sub);
		break;
	case SOAP_TYPE_ns__mulResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__mulResponse*>(p->ptr), struct ns__mulResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__mulResponse*>(p->ptr), struct ns__mulResponse);
		break;
	case SOAP_TYPE_ns__mul:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__mul*>(p->ptr), struct ns__mul);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__mul*>(p->ptr), struct ns__mul);
		break;
	case SOAP_TYPE_ns__divResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__divResponse*>(p->ptr), struct ns__divResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__divResponse*>(p->ptr), struct ns__divResponse);
		break;
	case SOAP_TYPE_ns__div:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__div*>(p->ptr), struct ns__div);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__div*>(p->ptr), struct ns__div);
		break;
	case SOAP_TYPE_ns__powResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__powResponse*>(p->ptr), struct ns__powResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__powResponse*>(p->ptr), struct ns__powResponse);
		break;
	case SOAP_TYPE_ns__pow:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct ns__pow*>(p->ptr), struct ns__pow);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct ns__pow*>(p->ptr), struct ns__pow);
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct SOAP_ENV__Header*>(p->ptr), struct SOAP_ENV__Header);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct SOAP_ENV__Header*>(p->ptr), struct SOAP_ENV__Header);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct SOAP_ENV__Code*>(p->ptr), struct SOAP_ENV__Code);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct SOAP_ENV__Code*>(p->ptr), struct SOAP_ENV__Code);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct SOAP_ENV__Detail*>(p->ptr), struct SOAP_ENV__Detail);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct SOAP_ENV__Detail*>(p->ptr), struct SOAP_ENV__Detail);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct SOAP_ENV__Reason*>(p->ptr), struct SOAP_ENV__Reason);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct SOAP_ENV__Reason*>(p->ptr), struct SOAP_ENV__Reason);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct SOAP_ENV__Fault*>(p->ptr), struct SOAP_ENV__Fault);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct SOAP_ENV__Fault*>(p->ptr), struct SOAP_ENV__Fault);
		break;
#endif
	default:
		return SOAP_ERR;
	}
	return SOAP_OK;
}

#ifdef WIN32
#pragma warning(push)
// do not warn on switch w/o cases
#pragma warning(disable:4065)
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_fbase(int t, int b)
{
	(void)t; (void)b; /* appease -Wall -Werror */
	return 0;
}
#ifdef WIN32
#pragma warning(pop)
#endif

#ifndef WITH_NOIDREF
#ifdef WIN32
#pragma warning(push)
// do not warn on switch w/o cases
#pragma warning(disable:4065)
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_finsert(struct soap *soap, int t, int tt, void *p, size_t index, const void *q, void **x)
{
	(void)soap; (void)t; (void)p; (void)index; (void)q; (void)x; /* appease -Wall -Werror */
	switch (tt)
	{
	case SOAP_TYPE_ns__addResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__addResponse type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__addResponse*)p = *(struct ns__addResponse*)q;
		break;
	case SOAP_TYPE_ns__add:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__add type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__add*)p = *(struct ns__add*)q;
		break;
	case SOAP_TYPE_ns__subResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__subResponse type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__subResponse*)p = *(struct ns__subResponse*)q;
		break;
	case SOAP_TYPE_ns__sub:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__sub type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__sub*)p = *(struct ns__sub*)q;
		break;
	case SOAP_TYPE_ns__mulResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__mulResponse type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__mulResponse*)p = *(struct ns__mulResponse*)q;
		break;
	case SOAP_TYPE_ns__mul:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__mul type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__mul*)p = *(struct ns__mul*)q;
		break;
	case SOAP_TYPE_ns__divResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__divResponse type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__divResponse*)p = *(struct ns__divResponse*)q;
		break;
	case SOAP_TYPE_ns__div:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__div type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__div*)p = *(struct ns__div*)q;
		break;
	case SOAP_TYPE_ns__powResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__powResponse type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__powResponse*)p = *(struct ns__powResponse*)q;
		break;
	case SOAP_TYPE_ns__pow:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct ns__pow type=%d location=%p object=%p\n", t, p, q));
		*(struct ns__pow*)p = *(struct ns__pow*)q;
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Header type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Code type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Detail type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Reason type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Fault type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
		break;
#endif
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", t, tt));
	}
}
#ifdef WIN32
#pragma warning(pop)
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	a = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return a;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_new_byte(struct soap *soap, int n)
{
	char *a = static_cast<char *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(char)));
	for (char *p = a; p && n--; ++p)
		soap_default_byte(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	if (soap_out_byte(soap, tag ? tag : "byte", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	a = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return a;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_new_int(struct soap *soap, int n)
{
	int *a = static_cast<int *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(int)));
	for (int *p = a; p && n--; ++p)
		soap_default_int(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	if (soap_out_int(soap, tag ? tag : "int", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{
	a = soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
	return a;
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_new_double(struct soap *soap, int n)
{
	double *a = static_cast<double *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(double)));
	for (double *p = a; p && n--; ++p)
		soap_default_double(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	if (soap_out_double(soap, tag ? tag : "double", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize__QName(soap, (char*const*)&a->faultcode);
	soap_serialize_string(soap, (char*const*)&a->faultstring);
	soap_serialize_string(soap, (char*const*)&a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, (char*const*)&a->SOAP_ENV__Node);
	soap_serialize_string(soap, (char*const*)&a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode;
	soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)(void*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, (char*const*)&a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, (char*const*)&a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, (char*const*)&a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, (char*const*)&a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct SOAP_ENV__Fault*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in__QName(soap, "faultcode", (char**)&a->faultcode, "xsd:QName"))
				{	soap_flag_faultcode--;
					continue;
				}
			}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "faultstring", (char**)&a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "faultactor", (char**)&a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "SOAP-ENV:Node", (char**)&a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "SOAP-ENV:Role", (char**)&a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Fault *p;
	size_t k = sizeof(struct SOAP_ENV__Fault);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct SOAP_ENV__Fault);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct SOAP_ENV__Fault, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Fault location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Fault(soap, tag ? tag : "SOAP-ENV:Fault", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_string(soap, (char*const*)&a->SOAP_ENV__Text);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, (char*const*)&a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct SOAP_ENV__Reason*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "SOAP-ENV:Text", (char**)&a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Reason *p;
	size_t k = sizeof(struct SOAP_ENV__Reason);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct SOAP_ENV__Reason);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct SOAP_ENV__Reason, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Reason location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Reason(soap, tag ? tag : "SOAP-ENV:Reason", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_markelement(soap, a->fault, a->__type);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	if (soap_outliteral(soap, "-any", (char*const*)&a->__any, NULL))
		return soap->error;
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct SOAP_ENV__Detail*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
			{	if ((a->fault = soap_getelement(soap, "fault", &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_inliteral(soap, "-any", (char**)&a->__any))
				{	soap_flag___any--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Detail *p;
	size_t k = sizeof(struct SOAP_ENV__Detail);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct SOAP_ENV__Detail);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct SOAP_ENV__Detail, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Detail location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Detail(soap, tag ? tag : "SOAP-ENV:Detail", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize__QName(soap, (char*const*)&a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value;
	soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)(void*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct SOAP_ENV__Code*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in__QName(soap, "SOAP-ENV:Value", (char**)&a->SOAP_ENV__Value, "xsd:QName"))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Code *p;
	size_t k = sizeof(struct SOAP_ENV__Code);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct SOAP_ENV__Code);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct SOAP_ENV__Code, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Code location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Code(soap, tag ? tag : "SOAP-ENV:Code", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct SOAP_ENV__Header*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Header *p;
	size_t k = sizeof(struct SOAP_ENV__Header);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct SOAP_ENV__Header);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct SOAP_ENV__Header, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Header location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Header(soap, tag ? tag : "SOAP-ENV:Header", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__pow(struct soap *soap, struct ns__pow *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_double(soap, &a->a);
	soap_default_double(soap, &a->b);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__pow(struct soap *soap, const struct ns__pow *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_embedded(soap, &a->a, SOAP_TYPE_double);
	soap_embedded(soap, &a->b, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__pow(struct soap *soap, const char *tag, int id, const struct ns__pow *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__pow), type))
		return soap->error;
	if (soap_out_double(soap, "a", -1, &a->a, ""))
		return soap->error;
	if (soap_out_double(soap, "b", -1, &a->b, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__pow * SOAP_FMAC4 soap_in_ns__pow(struct soap *soap, const char *tag, struct ns__pow *a, const char *type)
{
	size_t soap_flag_a = 1;
	size_t soap_flag_b = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__pow*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__pow, sizeof(struct ns__pow), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__pow(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "a", &a->a, "xsd:double"))
				{	soap_flag_a--;
					continue;
				}
			}
			if (soap_flag_b && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "b", &a->b, "xsd:double"))
				{	soap_flag_b--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_a > 0 || soap_flag_b > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (struct ns__pow *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__pow, SOAP_TYPE_ns__pow, sizeof(struct ns__pow), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__pow * SOAP_FMAC2 soap_instantiate_ns__pow(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__pow(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__pow *p;
	size_t k = sizeof(struct ns__pow);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__pow, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__pow);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__pow, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__pow location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__pow(struct soap *soap, const struct ns__pow *a, const char *tag, const char *type)
{
	if (soap_out_ns__pow(soap, tag ? tag : "ns:pow", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__pow * SOAP_FMAC4 soap_get_ns__pow(struct soap *soap, struct ns__pow *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__pow(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__powResponse(struct soap *soap, struct ns__powResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__powResponse(struct soap *soap, const struct ns__powResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &a->result);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__powResponse(struct soap *soap, const char *tag, int id, const struct ns__powResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__powResponse), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "result", -1, &a->result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__powResponse * SOAP_FMAC4 soap_in_ns__powResponse(struct soap *soap, const char *tag, struct ns__powResponse *a, const char *type)
{
	size_t soap_flag_result = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__powResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__powResponse, sizeof(struct ns__powResponse), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__powResponse(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "result", &a->result, "xsd:double"))
				{	soap_flag_result--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__powResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__powResponse, SOAP_TYPE_ns__powResponse, sizeof(struct ns__powResponse), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__powResponse * SOAP_FMAC2 soap_instantiate_ns__powResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__powResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__powResponse *p;
	size_t k = sizeof(struct ns__powResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__powResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__powResponse);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__powResponse, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__powResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__powResponse(struct soap *soap, const struct ns__powResponse *a, const char *tag, const char *type)
{
	if (soap_out_ns__powResponse(soap, tag ? tag : "ns:powResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__powResponse * SOAP_FMAC4 soap_get_ns__powResponse(struct soap *soap, struct ns__powResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__powResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__div(struct soap *soap, struct ns__div *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_double(soap, &a->a);
	soap_default_double(soap, &a->b);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__div(struct soap *soap, const struct ns__div *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_embedded(soap, &a->a, SOAP_TYPE_double);
	soap_embedded(soap, &a->b, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__div(struct soap *soap, const char *tag, int id, const struct ns__div *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__div), type))
		return soap->error;
	if (soap_out_double(soap, "a", -1, &a->a, ""))
		return soap->error;
	if (soap_out_double(soap, "b", -1, &a->b, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__div * SOAP_FMAC4 soap_in_ns__div(struct soap *soap, const char *tag, struct ns__div *a, const char *type)
{
	size_t soap_flag_a = 1;
	size_t soap_flag_b = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__div*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__div, sizeof(struct ns__div), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__div(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "a", &a->a, "xsd:double"))
				{	soap_flag_a--;
					continue;
				}
			}
			if (soap_flag_b && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "b", &a->b, "xsd:double"))
				{	soap_flag_b--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_a > 0 || soap_flag_b > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (struct ns__div *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__div, SOAP_TYPE_ns__div, sizeof(struct ns__div), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__div * SOAP_FMAC2 soap_instantiate_ns__div(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__div(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__div *p;
	size_t k = sizeof(struct ns__div);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__div, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__div);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__div, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__div location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__div(struct soap *soap, const struct ns__div *a, const char *tag, const char *type)
{
	if (soap_out_ns__div(soap, tag ? tag : "ns:div", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__div * SOAP_FMAC4 soap_get_ns__div(struct soap *soap, struct ns__div *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__div(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__divResponse(struct soap *soap, struct ns__divResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__divResponse(struct soap *soap, const struct ns__divResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &a->result);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__divResponse(struct soap *soap, const char *tag, int id, const struct ns__divResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__divResponse), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "result", -1, &a->result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__divResponse * SOAP_FMAC4 soap_in_ns__divResponse(struct soap *soap, const char *tag, struct ns__divResponse *a, const char *type)
{
	size_t soap_flag_result = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__divResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__divResponse, sizeof(struct ns__divResponse), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__divResponse(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "result", &a->result, "xsd:double"))
				{	soap_flag_result--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__divResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__divResponse, SOAP_TYPE_ns__divResponse, sizeof(struct ns__divResponse), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__divResponse * SOAP_FMAC2 soap_instantiate_ns__divResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__divResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__divResponse *p;
	size_t k = sizeof(struct ns__divResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__divResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__divResponse);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__divResponse, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__divResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__divResponse(struct soap *soap, const struct ns__divResponse *a, const char *tag, const char *type)
{
	if (soap_out_ns__divResponse(soap, tag ? tag : "ns:divResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__divResponse * SOAP_FMAC4 soap_get_ns__divResponse(struct soap *soap, struct ns__divResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__divResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__mul(struct soap *soap, struct ns__mul *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_double(soap, &a->a);
	soap_default_double(soap, &a->b);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__mul(struct soap *soap, const struct ns__mul *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_embedded(soap, &a->a, SOAP_TYPE_double);
	soap_embedded(soap, &a->b, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__mul(struct soap *soap, const char *tag, int id, const struct ns__mul *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__mul), type))
		return soap->error;
	if (soap_out_double(soap, "a", -1, &a->a, ""))
		return soap->error;
	if (soap_out_double(soap, "b", -1, &a->b, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__mul * SOAP_FMAC4 soap_in_ns__mul(struct soap *soap, const char *tag, struct ns__mul *a, const char *type)
{
	size_t soap_flag_a = 1;
	size_t soap_flag_b = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__mul*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__mul, sizeof(struct ns__mul), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__mul(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "a", &a->a, "xsd:double"))
				{	soap_flag_a--;
					continue;
				}
			}
			if (soap_flag_b && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "b", &a->b, "xsd:double"))
				{	soap_flag_b--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_a > 0 || soap_flag_b > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (struct ns__mul *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__mul, SOAP_TYPE_ns__mul, sizeof(struct ns__mul), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__mul * SOAP_FMAC2 soap_instantiate_ns__mul(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__mul(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__mul *p;
	size_t k = sizeof(struct ns__mul);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__mul, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__mul);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__mul, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__mul location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__mul(struct soap *soap, const struct ns__mul *a, const char *tag, const char *type)
{
	if (soap_out_ns__mul(soap, tag ? tag : "ns:mul", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__mul * SOAP_FMAC4 soap_get_ns__mul(struct soap *soap, struct ns__mul *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__mul(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__mulResponse(struct soap *soap, struct ns__mulResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__mulResponse(struct soap *soap, const struct ns__mulResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &a->result);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__mulResponse(struct soap *soap, const char *tag, int id, const struct ns__mulResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__mulResponse), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "result", -1, &a->result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__mulResponse * SOAP_FMAC4 soap_in_ns__mulResponse(struct soap *soap, const char *tag, struct ns__mulResponse *a, const char *type)
{
	size_t soap_flag_result = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__mulResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__mulResponse, sizeof(struct ns__mulResponse), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__mulResponse(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "result", &a->result, "xsd:double"))
				{	soap_flag_result--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__mulResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__mulResponse, SOAP_TYPE_ns__mulResponse, sizeof(struct ns__mulResponse), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__mulResponse * SOAP_FMAC2 soap_instantiate_ns__mulResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__mulResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__mulResponse *p;
	size_t k = sizeof(struct ns__mulResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__mulResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__mulResponse);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__mulResponse, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__mulResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__mulResponse(struct soap *soap, const struct ns__mulResponse *a, const char *tag, const char *type)
{
	if (soap_out_ns__mulResponse(soap, tag ? tag : "ns:mulResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__mulResponse * SOAP_FMAC4 soap_get_ns__mulResponse(struct soap *soap, struct ns__mulResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__mulResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__sub(struct soap *soap, struct ns__sub *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_double(soap, &a->a);
	soap_default_double(soap, &a->b);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__sub(struct soap *soap, const struct ns__sub *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_embedded(soap, &a->a, SOAP_TYPE_double);
	soap_embedded(soap, &a->b, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__sub(struct soap *soap, const char *tag, int id, const struct ns__sub *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__sub), type))
		return soap->error;
	if (soap_out_double(soap, "a", -1, &a->a, ""))
		return soap->error;
	if (soap_out_double(soap, "b", -1, &a->b, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__sub * SOAP_FMAC4 soap_in_ns__sub(struct soap *soap, const char *tag, struct ns__sub *a, const char *type)
{
	size_t soap_flag_a = 1;
	size_t soap_flag_b = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__sub*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__sub, sizeof(struct ns__sub), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__sub(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "a", &a->a, "xsd:double"))
				{	soap_flag_a--;
					continue;
				}
			}
			if (soap_flag_b && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "b", &a->b, "xsd:double"))
				{	soap_flag_b--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_a > 0 || soap_flag_b > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (struct ns__sub *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__sub, SOAP_TYPE_ns__sub, sizeof(struct ns__sub), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__sub * SOAP_FMAC2 soap_instantiate_ns__sub(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__sub(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__sub *p;
	size_t k = sizeof(struct ns__sub);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__sub, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__sub);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__sub, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__sub location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__sub(struct soap *soap, const struct ns__sub *a, const char *tag, const char *type)
{
	if (soap_out_ns__sub(soap, tag ? tag : "ns:sub", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__sub * SOAP_FMAC4 soap_get_ns__sub(struct soap *soap, struct ns__sub *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__sub(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__subResponse(struct soap *soap, struct ns__subResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__subResponse(struct soap *soap, const struct ns__subResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &a->result);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__subResponse(struct soap *soap, const char *tag, int id, const struct ns__subResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__subResponse), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "result", -1, &a->result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__subResponse * SOAP_FMAC4 soap_in_ns__subResponse(struct soap *soap, const char *tag, struct ns__subResponse *a, const char *type)
{
	size_t soap_flag_result = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__subResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__subResponse, sizeof(struct ns__subResponse), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__subResponse(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "result", &a->result, "xsd:double"))
				{	soap_flag_result--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__subResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__subResponse, SOAP_TYPE_ns__subResponse, sizeof(struct ns__subResponse), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__subResponse * SOAP_FMAC2 soap_instantiate_ns__subResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__subResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__subResponse *p;
	size_t k = sizeof(struct ns__subResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__subResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__subResponse);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__subResponse, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__subResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__subResponse(struct soap *soap, const struct ns__subResponse *a, const char *tag, const char *type)
{
	if (soap_out_ns__subResponse(soap, tag ? tag : "ns:subResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__subResponse * SOAP_FMAC4 soap_get_ns__subResponse(struct soap *soap, struct ns__subResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__subResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__add(struct soap *soap, struct ns__add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_double(soap, &a->a);
	soap_default_double(soap, &a->b);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__add(struct soap *soap, const struct ns__add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_embedded(soap, &a->a, SOAP_TYPE_double);
	soap_embedded(soap, &a->b, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__add(struct soap *soap, const char *tag, int id, const struct ns__add *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__add), type))
		return soap->error;
	if (soap_out_double(soap, "a", -1, &a->a, ""))
		return soap->error;
	if (soap_out_double(soap, "b", -1, &a->b, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__add * SOAP_FMAC4 soap_in_ns__add(struct soap *soap, const char *tag, struct ns__add *a, const char *type)
{
	size_t soap_flag_a = 1;
	size_t soap_flag_b = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__add*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__add, sizeof(struct ns__add), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__add(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "a", &a->a, "xsd:double"))
				{	soap_flag_a--;
					continue;
				}
			}
			if (soap_flag_b && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_double(soap, "b", &a->b, "xsd:double"))
				{	soap_flag_b--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_a > 0 || soap_flag_b > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (struct ns__add *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__add, SOAP_TYPE_ns__add, sizeof(struct ns__add), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__add * SOAP_FMAC2 soap_instantiate_ns__add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__add(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__add *p;
	size_t k = sizeof(struct ns__add);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__add, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__add);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__add, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__add location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__add(struct soap *soap, const struct ns__add *a, const char *tag, const char *type)
{
	if (soap_out_ns__add(soap, tag ? tag : "ns:add", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__add * SOAP_FMAC4 soap_get_ns__add(struct soap *soap, struct ns__add *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__addResponse(struct soap *soap, struct ns__addResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__addResponse(struct soap *soap, const struct ns__addResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &a->result);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__addResponse(struct soap *soap, const char *tag, int id, const struct ns__addResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__addResponse), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "result", -1, &a->result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__addResponse * SOAP_FMAC4 soap_in_ns__addResponse(struct soap *soap, const char *tag, struct ns__addResponse *a, const char *type)
{
	size_t soap_flag_result = 1;
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	(void)type; /* appease -Wall -Werror */
	a = (struct ns__addResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__addResponse, sizeof(struct ns__addResponse), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__addResponse(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "result", &a->result, "xsd:double"))
				{	soap_flag_result--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__addResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__addResponse, SOAP_TYPE_ns__addResponse, sizeof(struct ns__addResponse), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct ns__addResponse * SOAP_FMAC2 soap_instantiate_ns__addResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__addResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct ns__addResponse *p;
	size_t k = sizeof(struct ns__addResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE_ns__addResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, struct ns__addResponse);
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, struct ns__addResponse, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct ns__addResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__addResponse(struct soap *soap, const struct ns__addResponse *a, const char *tag, const char *type)
{
	if (soap_out_ns__addResponse(soap, tag ? tag : "ns:addResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__addResponse * SOAP_FMAC4 soap_get_ns__addResponse(struct soap *soap, struct ns__addResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__addResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason, NULL);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag ? tag : "SOAP-ENV:Reason", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail, NULL);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag ? tag : "SOAP-ENV:Detail", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	char *mark;
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code, &mark);
	if (id < 0)
		return soap->error;
	(void)soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
	soap_unmark(soap, mark);
	return soap->error;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag ? tag : "SOAP-ENV:Code", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodouble(struct soap *soap, double *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	(void)soap_reference(soap, *a, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodouble(struct soap *soap, const char *tag, int id, double *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_double, NULL);
	if (id < 0)
		return soap->error;
	return soap_out_double(soap, tag, id, *a, type);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_in_PointerTodouble(struct soap *soap, const char *tag, double **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (double **)soap_malloc(soap, sizeof(double *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_double(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (double **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_double, sizeof(double), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodouble(struct soap *soap, double *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTodouble(soap, tag ? tag : "double", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_get_PointerTodouble(struct soap *soap, double **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTodouble(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	(void)soap_reference(soap, *a, SOAP_TYPE__QName);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	a = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1, NULL);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	if (soap_out__QName(soap, tag ? tag : "QName", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	(void)soap_reference(soap, *a, SOAP_TYPE_string);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	a = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1, NULL);
	return a;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_new_string(struct soap *soap, int n)
{
	char * *a = static_cast<char * *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(char *)));
	for (char * *p = a; p && n--; ++p)
		soap_default_string(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	if (soap_out_string(soap, tag ? tag : "string", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
