/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/
#line 4 "../../groonga/lib/grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT

  static void
  array_literal_add_element(efs_info *efsi)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_expr *e = (grn_expr *)(efsi->e);
    grn_expr_code *code = &(e->codes[e->codes_curr - 1]);
    if (code->op != GRN_OP_PUSH) {
      if (!efsi->array_literal) {
        efsi->array_literal = grn_obj_open(ctx, GRN_VECTOR, 0, GRN_ID_NIL);
      }
      ERR(GRN_FUNCTION_NOT_IMPLEMENTED,
          "complex expression in array literal isn't supported yet: <%.*s>",
          (int)(efsi->str_end - efsi->str), efsi->str);
    }
    if (ctx->rc == GRN_SUCCESS) {
      grn_obj *element = code->value;
      if (!efsi->array_literal) {
        efsi->array_literal = grn_obj_open(ctx,
                                           GRN_VECTOR,
                                           0,
                                           element->header.domain);
        if (!efsi->array_literal) {
          ERR(GRN_NO_MEMORY_AVAILABLE,
              "couldn't create vector for parsing array literal: <%.*s>",
              (int)(efsi->str_end - efsi->str), efsi->str);
        }
      }
      if (efsi->array_literal) {
        grn_vector_add_element_float(ctx,
                                     efsi->array_literal,
                                     GRN_TEXT_VALUE(element),
                                     GRN_TEXT_LEN(element),
                                     0,
                                     element->header.domain);
        if (ctx->rc == GRN_SUCCESS) {
          grn_expr_dfi_pop(e);
          e->codes_curr -= 1;
        }
      }
    }
  }
#line 77 "../../groonga/lib/grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    grn_expr_parserCTX_*         As grn_expr_parserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 117
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy61;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_PARAM ,efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi =yypParser->efsi ;
#define grn_expr_parserARG_STORE yypParser->efsi =efsi ;
#define grn_expr_parserCTX_SDECL
#define grn_expr_parserCTX_PDECL
#define grn_expr_parserCTX_PARAM
#define grn_expr_parserCTX_FETCH
#define grn_expr_parserCTX_STORE
#define YYNSTATE             153
#define YYNRULE              138
#define YYNRULE_WITH_ACTION  93
#define YYNTOKEN             79
#define YY_MAX_SHIFT         152
#define YY_MIN_SHIFTREDUCE   235
#define YY_MAX_SHIFTREDUCE   372
#define YY_ERROR_ACTION      373
#define YY_ACCEPT_ACTION     374
#define YY_NO_ACTION         375
#define YY_MIN_REDUCE        376
#define YY_MAX_REDUCE        513
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1730)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   385,    3,   75,    4,  120,  120,  144,  376,  334,    2,
 /*    10 */    81,   57,   86,  135,    1,   81,   74,  374,   82,  117,
 /*    20 */   385,  385,  139,   82,   78,  117,  117,   93,  132,  131,
 /*    30 */   147,  146,  145,  126,   90,  108,  122,  109,  109,  109,
 /*    40 */    93,   78,  466,  141,   78,   78,  334,   77,  115,   87,
 /*    50 */    86,  152,   10,  380,   74,  446,  495,   69,   68,   56,
 /*    60 */    55,   54,   72,   71,   70,   67,   66,   64,   63,   62,
 /*    70 */   359,  360,  361,  362,  363,    7,  133,  506,  144,  115,
 /*    80 */   141,   78,  133,  133,   93,  132,  131,  147,  146,  145,
 /*    90 */   126,   90,  108,  122,  109,  109,  109,   93,   78,   31,
 /*   100 */    30,   78,   78,  472,  120,  120,  144,  334,    2,  366,
 /*   110 */    57,   86,  135,    1,  379,   74,   81,  124,   73,   61,
 /*   120 */    60,   81,   78,  124,  124,   93,  132,  131,  147,  146,
 /*   130 */   145,  126,   90,  108,  122,  109,  109,  109,   93,   78,
 /*   140 */   314,  383,   78,   78,    8,  507,   65,   22,  357,   76,
 /*   150 */   382,  310,  381,   80,   59,   58,   69,   68,   36,   35,
 /*   160 */    79,   72,   71,   70,   67,   66,   64,   63,   62,  359,
 /*   170 */   360,  361,  362,  363,    7,   53,   52,   51,   50,   49,
 /*   180 */    48,   47,   46,   45,   44,   43,   42,   41,   40,   39,
 /*   190 */    38,   37,   69,   68,  322,  471,  378,   72,   71,   70,
 /*   200 */    67,   66,   64,   63,   62,  359,  360,  361,  362,  363,
 /*   210 */     7,  116,    5,  323,   29,   78,  465,  465,   93,  132,
 /*   220 */   131,  147,  146,  145,  126,   90,  108,  122,  109,  109,
 /*   230 */   109,   93,   78,  377,  356,   78,   78,    6,   26,   24,
 /*   240 */   136,   28,  460,  137,   85,   78,  136,  136,   93,  132,
 /*   250 */   131,  147,  146,  145,  126,   90,  108,  122,  109,  109,
 /*   260 */   109,   93,   78,  303,  304,   78,   78,   89,   88,   84,
 /*   270 */    83,  334,   77,  335,   87,   86,  152,   10,   28,   74,
 /*   280 */    78,  465,  465,   93,  132,  131,  147,  146,  145,  126,
 /*   290 */    90,  108,  122,  109,  109,  109,   93,   78,  306,   28,
 /*   300 */    78,   78,  243,    9,   28,  143,  473,  462,   78,  457,
 /*   310 */   457,   93,  132,  131,  147,  146,  145,  126,   90,  108,
 /*   320 */   122,  109,  109,  109,   93,   78,  327,  138,   78,   78,
 /*   330 */   326,  140,   32,  367,  119,   78,  449,  449,   93,  132,
 /*   340 */   131,  147,  146,  145,  126,   90,  108,  122,  109,  109,
 /*   350 */   109,   93,   78,   23,   33,   78,   78,  121,  313,   34,
 /*   360 */    25,  375,  375,  124,  375,  375,  375,  375,   78,  124,
 /*   370 */   124,   93,  132,  131,  147,  146,  145,  126,   90,  108,
 /*   380 */   122,  109,  109,  109,   93,   78,  375,  375,   78,   78,
 /*   390 */   127,  375,  375,  375,  375,   78,  127,  127,   93,  132,
 /*   400 */   131,  147,  146,  145,  126,   90,  108,  122,  109,  109,
 /*   410 */   109,   93,   78,  375,  375,   78,   78,  133,  375,  375,
 /*   420 */   375,  375,   78,  133,  133,   93,  132,  131,  147,  146,
 /*   430 */   145,  126,   90,  108,  122,  109,  109,  109,   93,   78,
 /*   440 */   375,  375,   78,   78,    8,  375,   65,  375,  357,   76,
 /*   450 */   375,   78,  398,  398,   93,  132,  131,  147,  146,  145,
 /*   460 */   126,   90,  108,  122,  109,  109,  109,   93,   78,  375,
 /*   470 */    78,   78,   78,  128,  375,  118,  147,  146,  145,  126,
 /*   480 */    90,  108,  122,  109,  109,  109,  128,   78,  375,  375,
 /*   490 */    78,   78,   69,   68,  375,  375,  375,   72,   71,   70,
 /*   500 */    67,   66,   64,   63,   62,  359,  360,  134,  362,  363,
 /*   510 */     7,    8,  375,   65,  375,  357,   76,   78,  397,  397,
 /*   520 */    93,  132,  131,  147,  146,  145,  126,   90,  108,  122,
 /*   530 */   109,  109,  109,   93,   78,  375,  375,   78,   78,  375,
 /*   540 */   375,   78,  396,  396,   93,  132,  131,  147,  146,  145,
 /*   550 */   126,   90,  108,  122,  109,  109,  109,   93,   78,   69,
 /*   560 */    68,   78,   78,  375,   72,   71,   70,   67,   66,   64,
 /*   570 */    63,   62,  359,  360,  361,  362,  363,    7,  375,  375,
 /*   580 */    78,  395,  395,   93,  132,  131,  147,  146,  145,  126,
 /*   590 */    90,  108,  122,  109,  109,  109,   93,   78,  375,  375,
 /*   600 */    78,   78,  375,   78,  394,  394,   93,  132,  131,  147,
 /*   610 */   146,  145,  126,   90,  108,  122,  109,  109,  109,   93,
 /*   620 */    78,  375,  375,   78,   78,   78,  393,  393,   93,  132,
 /*   630 */   131,  147,  146,  145,  126,   90,  108,  122,  109,  109,
 /*   640 */   109,   93,   78,  375,  375,   78,   78,   78,  392,  392,
 /*   650 */    93,  132,  131,  147,  146,  145,  126,   90,  108,  122,
 /*   660 */   109,  109,  109,   93,   78,  375,  375,   78,   78,   78,
 /*   670 */   391,  391,   93,  132,  131,  147,  146,  145,  126,   90,
 /*   680 */   108,  122,  109,  109,  109,   93,   78,  375,  375,   78,
 /*   690 */    78,   78,  390,  390,   93,  132,  131,  147,  146,  145,
 /*   700 */   126,   90,  108,  122,  109,  109,  109,   93,   78,  375,
 /*   710 */   375,   78,   78,   78,  389,  389,   93,  132,  131,  147,
 /*   720 */   146,  145,  126,   90,  108,  122,  109,  109,  109,   93,
 /*   730 */    78,  375,  375,   78,   78,   78,  388,  388,   93,  132,
 /*   740 */   131,  147,  146,  145,  126,   90,  108,  122,  109,  109,
 /*   750 */   109,   93,   78,  375,  375,   78,   78,   78,  458,  458,
 /*   760 */    93,  132,  131,  147,  146,  145,  126,   90,  108,  122,
 /*   770 */   109,  109,  109,   93,   78,  375,  375,   78,   78,   78,
 /*   780 */   453,  453,   93,  132,  131,  147,  146,  145,  126,   90,
 /*   790 */   108,  122,  109,  109,  109,   93,   78,  375,  375,   78,
 /*   800 */    78,   78,  450,  450,   93,  132,  131,  147,  146,  145,
 /*   810 */   126,   90,  108,  122,  109,  109,  109,   93,   78,  375,
 /*   820 */   375,   78,   78,   78,  399,  399,   93,  132,  131,  147,
 /*   830 */   146,  145,  126,   90,  108,  122,  109,  109,  109,   93,
 /*   840 */    78,  375,  375,   78,   78,   78,  151,  151,   93,  132,
 /*   850 */   131,  147,  146,  145,  126,   90,  108,  122,  109,  109,
 /*   860 */   109,   93,   78,  375,  375,   78,   78,   78,  387,  387,
 /*   870 */    93,  132,  131,  147,  146,  145,  126,   90,  108,  122,
 /*   880 */   109,  109,  109,   93,   78,  375,  375,   78,   78,   78,
 /*   890 */   386,  386,   93,  132,  131,  147,  146,  145,  126,   90,
 /*   900 */   108,  122,  109,  109,  109,   93,   78,  375,  375,   78,
 /*   910 */    78,   78,  470,  375,  128,  375,  375,  142,  146,  145,
 /*   920 */   126,   90,  108,  122,  109,  109,  109,  128,   78,   28,
 /*   930 */   375,   78,   78,   78,  375,  375,  128,  375,  375,  150,
 /*   940 */   146,  145,  126,   90,  108,  122,  109,  109,  109,  128,
 /*   950 */    78,  375,  375,   78,   78,   78,  375,  375,  128,  375,
 /*   960 */   375,  375,  149,  145,  126,   90,  108,  122,  109,  109,
 /*   970 */   109,  128,   78,  375,  375,   78,   78,   78,  375,  375,
 /*   980 */   128,  375,  375,  375,  375,  148,  126,   90,  108,  122,
 /*   990 */   109,  109,  109,  128,   78,  375,  375,   78,   78,   27,
 /*  1000 */    21,   20,   19,   18,   17,   16,   15,   14,   13,   12,
 /*  1010 */    11,   78,  375,  375,  128,  375,  375,  375,  375,  375,
 /*  1020 */   130,   90,  108,  122,  109,  109,  109,  128,   78,  375,
 /*  1030 */   375,   78,   78,  375,  375,  375,   78,  375,  375,  128,
 /*  1040 */   375,  375,  375,  375,  303,  304,   91,  108,  122,  109,
 /*  1050 */   109,  109,  128,   78,  375,   78,   78,   78,  128,  375,
 /*  1060 */   375,  375,  375,  375,  375,   92,  108,  122,  109,  109,
 /*  1070 */   109,  128,   78,  469,  375,   78,   78,   89,   88,   84,
 /*  1080 */    83,  334,   77,  375,   87,   86,  152,   10,   78,   74,
 /*  1090 */   375,  128,  375,  375,  375,  375,  375,  375,  375,   94,
 /*  1100 */   122,  109,  109,  109,  128,   78,  375,  375,   78,   78,
 /*  1110 */    78,  375,  375,  128,  375,  375,  375,  375,  375,  375,
 /*  1120 */   375,   95,  122,  109,  109,  109,  128,   78,  375,  375,
 /*  1130 */    78,   78,   78,  375,  375,  128,    8,  375,  375,  375,
 /*  1140 */   357,   76,  375,   96,  122,  109,  109,  109,  128,   78,
 /*  1150 */   375,  375,   78,   78,   78,  375,  375,  128,  375,  375,
 /*  1160 */   375,  375,  375,  375,  375,   97,  122,  109,  109,  109,
 /*  1170 */   128,   78,  375,   78,   78,   78,  128,  375,  375,  375,
 /*  1180 */   375,  375,  375,  375,   98,  122,  109,  109,  109,  128,
 /*  1190 */    78,  375,   78,   78,   78,  128,  375,  359,  360,  361,
 /*  1200 */   362,  363,    7,   99,  122,  109,  109,  109,  128,   78,
 /*  1210 */   375,   78,   78,   78,  128,  375,  375,  375,  375,  375,
 /*  1220 */   375,  375,  100,  122,  109,  109,  109,  128,   78,  375,
 /*  1230 */   375,   78,   78,   78,  375,  375,  128,  375,  375,  375,
 /*  1240 */   375,  375,  375,  375,  101,  122,  109,  109,  109,  128,
 /*  1250 */    78,  375,  375,   78,   78,   78,  375,  375,  128,  375,
 /*  1260 */   375,  375,  375,  375,  375,  375,  102,  122,  109,  109,
 /*  1270 */   109,  128,   78,  375,   78,   78,   78,  128,  375,  375,
 /*  1280 */   375,  375,  375,  375,  375,  103,  122,  109,  109,  109,
 /*  1290 */   128,   78,  375,   78,   78,   78,  128,  375,  375,  375,
 /*  1300 */   375,  375,  375,  375,  104,  122,  109,  109,  109,  128,
 /*  1310 */    78,  375,   78,   78,   78,  128,  375,  375,  375,  375,
 /*  1320 */   375,  375,  375,  105,  122,  109,  109,  109,  128,   78,
 /*  1330 */   375,  375,   78,   78,   78,  375,  375,  128,  375,  375,
 /*  1340 */   375,  375,  375,  375,  375,  106,  122,  109,  109,  109,
 /*  1350 */   128,   78,  375,  375,   78,   78,   78,  375,  375,  128,
 /*  1360 */   375,  375,  375,  375,  375,  375,  375,  107,  122,  109,
 /*  1370 */   109,  109,  128,   78,  375,   78,   78,   78,  128,  375,
 /*  1380 */   375,  375,  375,  375,  375,  375,  110,  122,  109,  109,
 /*  1390 */   109,  128,   78,  375,   78,   78,   78,  128,  375,  375,
 /*  1400 */   375,  375,  375,  375,  375,  112,  122,  109,  109,  109,
 /*  1410 */   128,   78,  375,   78,   78,   78,  128,  375,  375,  375,
 /*  1420 */   375,  375,  375,  375,  114,  122,  109,  109,  109,  128,
 /*  1430 */    78,  375,  375,   78,   78,   78,  375,  375,  128,  375,
 /*  1440 */   375,  375,  375,  375,  375,  375,  375,  123,  109,  109,
 /*  1450 */   109,  128,   78,  375,  375,   78,   78,   78,  375,  375,
 /*  1460 */   128,  375,  375,  375,  375,  375,  375,  375,  375,  125,
 /*  1470 */   109,  109,  109,  128,   78,  375,   78,   78,   78,  128,
 /*  1480 */   375,  375,  375,  381,   78,  375,  375,  128,  129,  109,
 /*  1490 */   109,  109,  128,   78,  375,  375,   78,   78,  440,  440,
 /*  1500 */   128,   78,  375,   78,   78,   78,  128,  375,  375,  375,
 /*  1510 */   375,  375,   78,  375,  375,  128,  111,  111,  111,  128,
 /*  1520 */    78,  375,  375,   78,   78,  113,  113,  113,  128,   78,
 /*  1530 */   375,  375,   78,   78,  375,   78,  375,  375,  128,  375,
 /*  1540 */   375,  375,  375,   78,  375,  375,  128,  375,  375,  432,
 /*  1550 */   432,  128,   78,  375,  375,   78,   78,  431,  431,  128,
 /*  1560 */    78,  375,   78,   78,   78,  128,  375,  375,  375,  375,
 /*  1570 */   375,   78,  375,  375,  128,  375,  443,  443,  128,   78,
 /*  1580 */   375,   78,   78,   78,  128,  442,  442,  128,   78,  375,
 /*  1590 */   375,   78,   78,  375,  375,  441,  441,  128,   78,  375,
 /*  1600 */    78,   78,   78,  128,  375,  375,  375,  375,   78,  375,
 /*  1610 */   375,  128,  375,  375,  440,  440,  128,   78,  375,  375,
 /*  1620 */    78,   78,  439,  439,  128,   78,  375,  375,   78,   78,
 /*  1630 */   375,   78,  375,  375,  128,  375,  375,  375,  375,   78,
 /*  1640 */   375,  375,  128,  375,  375,  438,  438,  128,   78,  375,
 /*  1650 */   375,   78,   78,  437,  437,  128,   78,  375,  375,   78,
 /*  1660 */    78,  375,   78,  375,  375,  128,  375,  375,  375,  375,
 /*  1670 */    78,  375,  375,  128,  375,  375,  436,  436,  128,   78,
 /*  1680 */   375,  375,   78,   78,  435,  435,  128,   78,  375,   78,
 /*  1690 */    78,   78,  128,  375,  375,  375,  375,  375,  375,   78,
 /*  1700 */   375,  375,  128,  434,  434,  128,   78,  375,   78,   78,
 /*  1710 */    78,  128,  375,  433,  433,  128,   78,  375,  375,   78,
 /*  1720 */    78,  375,  430,  430,  128,   78,  375,  375,   78,   78,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    87,    1,    2,    3,  110,  111,  112,   86,    8,    9,
 /*    10 */    81,   11,   12,   13,   14,   86,   16,   80,   81,   82,
 /*    20 */   107,  108,   13,   86,   87,   88,   89,   90,   91,   92,
 /*    30 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*    40 */   103,  104,  115,  116,  107,  108,    8,    9,   84,   11,
 /*    50 */    12,   13,   14,   86,   16,  105,  106,   57,   58,   54,
 /*    60 */    55,   56,   62,   63,   64,   65,   66,   67,   68,   69,
 /*    70 */    70,   71,   72,   73,   74,   75,   82,  111,  112,  115,
 /*    80 */   116,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*    90 */    96,   97,   98,   99,  100,  101,  102,  103,  104,    4,
 /*   100 */     5,  107,  108,    0,  110,  111,  112,    8,    9,   72,
 /*   110 */    11,   12,   13,   14,   86,   16,   81,   82,   59,   60,
 /*   120 */    61,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   130 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   140 */    10,   86,  107,  108,    9,   31,   11,   17,   13,   14,
 /*   150 */    86,   15,   86,   17,   57,   58,   57,   58,   35,   36,
 /*   160 */    57,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   170 */    71,   72,   73,   74,   75,   37,   38,   39,   40,   41,
 /*   180 */    42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*   190 */    52,   53,   57,   58,   59,    0,   86,   62,   63,   64,
 /*   200 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   210 */    75,   83,   17,   78,    6,   87,   88,   89,   90,   91,
 /*   220 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   230 */   102,  103,  104,   86,   10,  107,  108,    9,   30,   17,
 /*   240 */    82,   17,  114,   85,   12,   87,   88,   89,   90,   91,
 /*   250 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   260 */   102,  103,  104,   63,   64,  107,  108,    4,    5,    6,
 /*   270 */     7,    8,    9,   10,   11,   12,   13,   14,   17,   16,
 /*   280 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   290 */    97,   98,   99,  100,  101,  102,  103,  104,   76,   17,
 /*   300 */   107,  108,   15,   75,   17,   77,    0,  114,   87,   88,
 /*   310 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   320 */    99,  100,  101,  102,  103,  104,   72,   42,  107,  108,
 /*   330 */    70,   59,   32,   13,  113,   87,   88,   89,   90,   91,
 /*   340 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   350 */   102,  103,  104,   31,   33,  107,  108,  109,   76,   34,
 /*   360 */    31,  117,  117,   82,  117,  117,  117,  117,   87,   88,
 /*   370 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   380 */    99,  100,  101,  102,  103,  104,  117,  117,  107,  108,
 /*   390 */    82,  117,  117,  117,  117,   87,   88,   89,   90,   91,
 /*   400 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   410 */   102,  103,  104,  117,  117,  107,  108,   82,  117,  117,
 /*   420 */   117,  117,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   430 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   440 */   117,  117,  107,  108,    9,  117,   11,  117,   13,   14,
 /*   450 */   117,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   460 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  117,
 /*   470 */    87,  107,  108,   90,  117,   92,   93,   94,   95,   96,
 /*   480 */    97,   98,   99,  100,  101,  102,  103,  104,  117,  117,
 /*   490 */   107,  108,   57,   58,  117,  117,  117,   62,   63,   64,
 /*   500 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   510 */    75,    9,  117,   11,  117,   13,   14,   87,   88,   89,
 /*   520 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   530 */   100,  101,  102,  103,  104,  117,  117,  107,  108,  117,
 /*   540 */   117,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   550 */    96,   97,   98,   99,  100,  101,  102,  103,  104,   57,
 /*   560 */    58,  107,  108,  117,   62,   63,   64,   65,   66,   67,
 /*   570 */    68,   69,   70,   71,   72,   73,   74,   75,  117,  117,
 /*   580 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   590 */    97,   98,   99,  100,  101,  102,  103,  104,  117,  117,
 /*   600 */   107,  108,  117,   87,   88,   89,   90,   91,   92,   93,
 /*   610 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   620 */   104,  117,  117,  107,  108,   87,   88,   89,   90,   91,
 /*   630 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   640 */   102,  103,  104,  117,  117,  107,  108,   87,   88,   89,
 /*   650 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   660 */   100,  101,  102,  103,  104,  117,  117,  107,  108,   87,
 /*   670 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   680 */    98,   99,  100,  101,  102,  103,  104,  117,  117,  107,
 /*   690 */   108,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   700 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  117,
 /*   710 */   117,  107,  108,   87,   88,   89,   90,   91,   92,   93,
 /*   720 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   730 */   104,  117,  117,  107,  108,   87,   88,   89,   90,   91,
 /*   740 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   750 */   102,  103,  104,  117,  117,  107,  108,   87,   88,   89,
 /*   760 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   770 */   100,  101,  102,  103,  104,  117,  117,  107,  108,   87,
 /*   780 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   790 */    98,   99,  100,  101,  102,  103,  104,  117,  117,  107,
 /*   800 */   108,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   810 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  117,
 /*   820 */   117,  107,  108,   87,   88,   89,   90,   91,   92,   93,
 /*   830 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   840 */   104,  117,  117,  107,  108,   87,   88,   89,   90,   91,
 /*   850 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   860 */   102,  103,  104,  117,  117,  107,  108,   87,   88,   89,
 /*   870 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   880 */   100,  101,  102,  103,  104,  117,  117,  107,  108,   87,
 /*   890 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   900 */    98,   99,  100,  101,  102,  103,  104,  117,  117,  107,
 /*   910 */   108,   87,    0,  117,   90,  117,  117,   93,   94,   95,
 /*   920 */    96,   97,   98,   99,  100,  101,  102,  103,  104,   17,
 /*   930 */   117,  107,  108,   87,  117,  117,   90,  117,  117,   93,
 /*   940 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   950 */   104,  117,  117,  107,  108,   87,  117,  117,   90,  117,
 /*   960 */   117,  117,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   970 */   102,  103,  104,  117,  117,  107,  108,   87,  117,  117,
 /*   980 */    90,  117,  117,  117,  117,   95,   96,   97,   98,   99,
 /*   990 */   100,  101,  102,  103,  104,  117,  117,  107,  108,   18,
 /*  1000 */    19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*  1010 */    29,   87,  117,  117,   90,  117,  117,  117,  117,  117,
 /*  1020 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  117,
 /*  1030 */   117,  107,  108,  117,  117,  117,   87,  117,  117,   90,
 /*  1040 */   117,  117,  117,  117,   63,   64,   97,   98,   99,  100,
 /*  1050 */   101,  102,  103,  104,  117,   87,  107,  108,   90,  117,
 /*  1060 */   117,  117,  117,  117,  117,   97,   98,   99,  100,  101,
 /*  1070 */   102,  103,  104,    0,  117,  107,  108,    4,    5,    6,
 /*  1080 */     7,    8,    9,  117,   11,   12,   13,   14,   87,   16,
 /*  1090 */   117,   90,  117,  117,  117,  117,  117,  117,  117,   98,
 /*  1100 */    99,  100,  101,  102,  103,  104,  117,  117,  107,  108,
 /*  1110 */    87,  117,  117,   90,  117,  117,  117,  117,  117,  117,
 /*  1120 */   117,   98,   99,  100,  101,  102,  103,  104,  117,  117,
 /*  1130 */   107,  108,   87,  117,  117,   90,    9,  117,  117,  117,
 /*  1140 */    13,   14,  117,   98,   99,  100,  101,  102,  103,  104,
 /*  1150 */   117,  117,  107,  108,   87,  117,  117,   90,  117,  117,
 /*  1160 */   117,  117,  117,  117,  117,   98,   99,  100,  101,  102,
 /*  1170 */   103,  104,  117,   87,  107,  108,   90,  117,  117,  117,
 /*  1180 */   117,  117,  117,  117,   98,   99,  100,  101,  102,  103,
 /*  1190 */   104,  117,   87,  107,  108,   90,  117,   70,   71,   72,
 /*  1200 */    73,   74,   75,   98,   99,  100,  101,  102,  103,  104,
 /*  1210 */   117,   87,  107,  108,   90,  117,  117,  117,  117,  117,
 /*  1220 */   117,  117,   98,   99,  100,  101,  102,  103,  104,  117,
 /*  1230 */   117,  107,  108,   87,  117,  117,   90,  117,  117,  117,
 /*  1240 */   117,  117,  117,  117,   98,   99,  100,  101,  102,  103,
 /*  1250 */   104,  117,  117,  107,  108,   87,  117,  117,   90,  117,
 /*  1260 */   117,  117,  117,  117,  117,  117,   98,   99,  100,  101,
 /*  1270 */   102,  103,  104,  117,   87,  107,  108,   90,  117,  117,
 /*  1280 */   117,  117,  117,  117,  117,   98,   99,  100,  101,  102,
 /*  1290 */   103,  104,  117,   87,  107,  108,   90,  117,  117,  117,
 /*  1300 */   117,  117,  117,  117,   98,   99,  100,  101,  102,  103,
 /*  1310 */   104,  117,   87,  107,  108,   90,  117,  117,  117,  117,
 /*  1320 */   117,  117,  117,   98,   99,  100,  101,  102,  103,  104,
 /*  1330 */   117,  117,  107,  108,   87,  117,  117,   90,  117,  117,
 /*  1340 */   117,  117,  117,  117,  117,   98,   99,  100,  101,  102,
 /*  1350 */   103,  104,  117,  117,  107,  108,   87,  117,  117,   90,
 /*  1360 */   117,  117,  117,  117,  117,  117,  117,   98,   99,  100,
 /*  1370 */   101,  102,  103,  104,  117,   87,  107,  108,   90,  117,
 /*  1380 */   117,  117,  117,  117,  117,  117,   98,   99,  100,  101,
 /*  1390 */   102,  103,  104,  117,   87,  107,  108,   90,  117,  117,
 /*  1400 */   117,  117,  117,  117,  117,   98,   99,  100,  101,  102,
 /*  1410 */   103,  104,  117,   87,  107,  108,   90,  117,  117,  117,
 /*  1420 */   117,  117,  117,  117,   98,   99,  100,  101,  102,  103,
 /*  1430 */   104,  117,  117,  107,  108,   87,  117,  117,   90,  117,
 /*  1440 */   117,  117,  117,  117,  117,  117,  117,   99,  100,  101,
 /*  1450 */   102,  103,  104,  117,  117,  107,  108,   87,  117,  117,
 /*  1460 */    90,  117,  117,  117,  117,  117,  117,  117,  117,   99,
 /*  1470 */   100,  101,  102,  103,  104,  117,   87,  107,  108,   90,
 /*  1480 */   117,  117,  117,   86,   87,  117,  117,   90,   99,  100,
 /*  1490 */   101,  102,  103,  104,  117,  117,  107,  108,  101,  102,
 /*  1500 */   103,  104,  117,   87,  107,  108,   90,  117,  117,  117,
 /*  1510 */   117,  117,   87,  117,  117,   90,  100,  101,  102,  103,
 /*  1520 */   104,  117,  117,  107,  108,  100,  101,  102,  103,  104,
 /*  1530 */   117,  117,  107,  108,  117,   87,  117,  117,   90,  117,
 /*  1540 */   117,  117,  117,   87,  117,  117,   90,  117,  117,  101,
 /*  1550 */   102,  103,  104,  117,  117,  107,  108,  101,  102,  103,
 /*  1560 */   104,  117,   87,  107,  108,   90,  117,  117,  117,  117,
 /*  1570 */   117,   87,  117,  117,   90,  117,  101,  102,  103,  104,
 /*  1580 */   117,   87,  107,  108,   90,  101,  102,  103,  104,  117,
 /*  1590 */   117,  107,  108,  117,  117,  101,  102,  103,  104,  117,
 /*  1600 */    87,  107,  108,   90,  117,  117,  117,  117,   87,  117,
 /*  1610 */   117,   90,  117,  117,  101,  102,  103,  104,  117,  117,
 /*  1620 */   107,  108,  101,  102,  103,  104,  117,  117,  107,  108,
 /*  1630 */   117,   87,  117,  117,   90,  117,  117,  117,  117,   87,
 /*  1640 */   117,  117,   90,  117,  117,  101,  102,  103,  104,  117,
 /*  1650 */   117,  107,  108,  101,  102,  103,  104,  117,  117,  107,
 /*  1660 */   108,  117,   87,  117,  117,   90,  117,  117,  117,  117,
 /*  1670 */    87,  117,  117,   90,  117,  117,  101,  102,  103,  104,
 /*  1680 */   117,  117,  107,  108,  101,  102,  103,  104,  117,   87,
 /*  1690 */   107,  108,   90,  117,  117,  117,  117,  117,  117,   87,
 /*  1700 */   117,  117,   90,  101,  102,  103,  104,  117,   87,  107,
 /*  1710 */   108,   90,  117,  101,  102,  103,  104,  117,  117,  107,
 /*  1720 */   108,  117,  101,  102,  103,  104,  117,  117,  107,  108,
 /*  1730 */    79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
 /*  1740 */    79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
 /*  1750 */    79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
 /*  1760 */    79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
 /*  1770 */    79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
 /*  1780 */    79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
 /*  1790 */    79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
 /*  1800 */    79,   79,   79,   79,   79,   79,   79,   79,   79,
};
#define YY_SHIFT_COUNT    (152)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1127)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     0,  435,   99,  135,  502,  135,  502,  502,  502,  502,
 /*    10 */   502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
 /*    20 */   502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
 /*    30 */   502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
 /*    40 */   502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
 /*    50 */   502,  502,  502,  502,  502,  502,  502,   99,  502,  502,
 /*    60 */   502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
 /*    70 */   502,  502,  502,  502, 1127,    9,   37,   38,  228,    9,
 /*    80 */    37,  263, 1073,   38,   38,   38,   38,   38,   38,   38,
 /*    90 */   138,  138,  138,  981,    5,    5,    5,    5,    5,    5,
 /*   100 */     5,    5,    5,    5,    5,    5,    5,    5,    5,   59,
 /*   110 */     5,   59,    5,   59,    5,  103,  195,  912,   95,  130,
 /*   120 */   136,  222,   97,   97,  224,   97,  123,  282,  200,   97,
 /*   130 */   123,   95,  208,  287,  114,  232,  261,  306,  254,  285,
 /*   140 */   260,  272,  300,  320,  322,  325,  321,  300,  325,  321,
 /*   150 */   300,  329,  232,
};
#define YY_REDUCE_COUNT (89)
#define YY_REDUCE_MIN   (-106)
#define YY_REDUCE_MAX   (1621)
static const short yy_reduce_ofst[] = {
 /*     0 */   -63,   -6,   35,  128,  158,  193,  221,  248,  281,  308,
 /*    10 */   335,  364,  430,  454,  493,  516,  538,  560,  582,  604,
 /*    20 */   626,  648,  670,  692,  714,  736,  758,  780,  802,  383,
 /*    30 */   824,  846,  868,  890,  924,  949,  968, 1001, 1023, 1045,
 /*    40 */  1067, 1086, 1105, 1124, 1146, 1168, 1187, 1206, 1225, 1247,
 /*    50 */  1269, 1288, 1307, 1326, 1348, 1370, 1389, 1397, 1416, 1425,
 /*    60 */  1448, 1456, 1475, 1484, 1494, 1513, 1521, 1544, 1552, 1575,
 /*    70 */  1583, 1602, 1612, 1621,  -87,  -36, -106,  -71,  -50,  -73,
 /*    80 */   -34,  -79,  -79,  -33,   28,   55,   64,   66,  110,  147,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   373,  452,  373,  459,  512,  461,  456,  448,  373,  373,
 /*    10 */   373,  373,  373,  373,  373,  373,  373,  373,  373,  373,
 /*    20 */   373,  373,  373,  373,  373,  373,  373,  373,  373,  373,
 /*    30 */   373,  373,  373,  373,  373,  373,  373,  373,  373,  373,
 /*    40 */   373,  373,  373,  373,  373,  373,  373,  373,  373,  373,
 /*    50 */   373,  373,  373,  373,  373,  373,  373,  373,  373,  373,
 /*    60 */   373,  373,  373,  373,  373,  373,  373,  373,  373,  373,
 /*    70 */   373,  373,  373,  373,  373,  509,  452,  373,  493,  373,
 /*    80 */   373,  373,  373,  373,  373,  373,  373,  373,  373,  373,
 /*    90 */   485,  407,  406,  491,  424,  423,  422,  421,  420,  419,
 /*   100 */   418,  417,  416,  415,  414,  413,  412,  411,  486,  488,
 /*   110 */   410,  429,  409,  428,  408,  373,  373,  373,  400,  373,
 /*   120 */   373,  373,  487,  427,  373,  426,  484,  373,  491,  425,
 /*   130 */   405,  480,  479,  373,  502,  498,  513,  373,  373,  373,
 /*   140 */   373,  511,  402,  373,  373,  483,  482,  481,  404,  403,
 /*   150 */   401,  373,  373,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
  grn_expr_parserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "START_OUTPUT_COLUMNS",
  /*    2 */ "START_ADJUSTER",
  /*    3 */ "START_GROUP_KEYS",
  /*    4 */ "LOGICAL_AND",
  /*    5 */ "LOGICAL_AND_NOT",
  /*    6 */ "LOGICAL_OR",
  /*    7 */ "NEGATIVE",
  /*    8 */ "QSTRING",
  /*    9 */ "PARENL",
  /*   10 */ "PARENR",
  /*   11 */ "ADJUST",
  /*   12 */ "RELATIVE_OP",
  /*   13 */ "IDENTIFIER",
  /*   14 */ "BRACEL",
  /*   15 */ "BRACER",
  /*   16 */ "EVAL",
  /*   17 */ "COMMA",
  /*   18 */ "ASSIGN",
  /*   19 */ "STAR_ASSIGN",
  /*   20 */ "SLASH_ASSIGN",
  /*   21 */ "MOD_ASSIGN",
  /*   22 */ "PLUS_ASSIGN",
  /*   23 */ "MINUS_ASSIGN",
  /*   24 */ "SHIFTL_ASSIGN",
  /*   25 */ "SHIFTR_ASSIGN",
  /*   26 */ "SHIFTRR_ASSIGN",
  /*   27 */ "AND_ASSIGN",
  /*   28 */ "XOR_ASSIGN",
  /*   29 */ "OR_ASSIGN",
  /*   30 */ "QUESTION",
  /*   31 */ "COLON",
  /*   32 */ "BITWISE_OR",
  /*   33 */ "BITWISE_XOR",
  /*   34 */ "BITWISE_AND",
  /*   35 */ "EQUAL",
  /*   36 */ "NOT_EQUAL",
  /*   37 */ "LESS",
  /*   38 */ "GREATER",
  /*   39 */ "LESS_EQUAL",
  /*   40 */ "GREATER_EQUAL",
  /*   41 */ "IN",
  /*   42 */ "MATCH",
  /*   43 */ "NEAR",
  /*   44 */ "NEAR2",
  /*   45 */ "NEAR_PHRASE",
  /*   46 */ "ORDERED_NEAR_PHRASE",
  /*   47 */ "SIMILAR",
  /*   48 */ "TERM_EXTRACT",
  /*   49 */ "QUORUM",
  /*   50 */ "LCP",
  /*   51 */ "PREFIX",
  /*   52 */ "SUFFIX",
  /*   53 */ "REGEXP",
  /*   54 */ "SHIFTL",
  /*   55 */ "SHIFTR",
  /*   56 */ "SHIFTRR",
  /*   57 */ "PLUS",
  /*   58 */ "MINUS",
  /*   59 */ "STAR",
  /*   60 */ "SLASH",
  /*   61 */ "MOD",
  /*   62 */ "DELETE",
  /*   63 */ "INCR",
  /*   64 */ "DECR",
  /*   65 */ "NOT",
  /*   66 */ "BITWISE_NOT",
  /*   67 */ "EXACT",
  /*   68 */ "PARTIAL",
  /*   69 */ "UNSPLIT",
  /*   70 */ "DECIMAL",
  /*   71 */ "HEX_INTEGER",
  /*   72 */ "STRING",
  /*   73 */ "BOOLEAN",
  /*   74 */ "NULL",
  /*   75 */ "BRACKETL",
  /*   76 */ "BRACKETR",
  /*   77 */ "DOT",
  /*   78 */ "NONEXISTENT_COLUMN",
  /*   79 */ "suppress_unused_variable_warning",
  /*   80 */ "input",
  /*   81 */ "query",
  /*   82 */ "expression",
  /*   83 */ "output_columns",
  /*   84 */ "adjuster",
  /*   85 */ "group_keys",
  /*   86 */ "query_element",
  /*   87 */ "primary_expression",
  /*   88 */ "assignment_expression",
  /*   89 */ "conditional_expression",
  /*   90 */ "lefthand_side_expression",
  /*   91 */ "logical_or_expression",
  /*   92 */ "logical_and_expression",
  /*   93 */ "bitwise_or_expression",
  /*   94 */ "bitwise_xor_expression",
  /*   95 */ "bitwise_and_expression",
  /*   96 */ "equality_expression",
  /*   97 */ "relational_expression",
  /*   98 */ "shift_expression",
  /*   99 */ "additive_expression",
  /*  100 */ "multiplicative_expression",
  /*  101 */ "unary_expression",
  /*  102 */ "postfix_expression",
  /*  103 */ "call_expression",
  /*  104 */ "member_expression",
  /*  105 */ "arguments",
  /*  106 */ "member_expression_part",
  /*  107 */ "object_literal",
  /*  108 */ "array_literal",
  /*  109 */ "element_list",
  /*  110 */ "property_name_and_value_list",
  /*  111 */ "property_name_and_value",
  /*  112 */ "property_name",
  /*  113 */ "argument_list",
  /*  114 */ "output_column",
  /*  115 */ "adjust_expression",
  /*  116 */ "adjust_match_expression",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  28 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  29 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  30 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  31 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  32 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  33 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  36 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  37 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  38 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  39 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  40 */ "relational_expression ::= relational_expression NEAR_PHRASE shift_expression",
 /*  41 */ "relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression",
 /*  42 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  43 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  44 */ "relational_expression ::= relational_expression QUORUM shift_expression",
 /*  45 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  46 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  47 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  48 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  49 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  50 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  51 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  52 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  53 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  54 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  55 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  56 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  57 */ "unary_expression ::= DELETE unary_expression",
 /*  58 */ "unary_expression ::= INCR unary_expression",
 /*  59 */ "unary_expression ::= DECR unary_expression",
 /*  60 */ "unary_expression ::= PLUS unary_expression",
 /*  61 */ "unary_expression ::= MINUS unary_expression",
 /*  62 */ "unary_expression ::= NOT unary_expression",
 /*  63 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  64 */ "unary_expression ::= ADJUST unary_expression",
 /*  65 */ "unary_expression ::= EXACT unary_expression",
 /*  66 */ "unary_expression ::= PARTIAL unary_expression",
 /*  67 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  68 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  69 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  70 */ "call_expression ::= member_expression arguments",
 /*  71 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /*  72 */ "element_list ::=",
 /*  73 */ "element_list ::= assignment_expression",
 /*  74 */ "element_list ::= element_list COMMA assignment_expression",
 /*  75 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /*  76 */ "property_name_and_value_list ::=",
 /*  77 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /*  78 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  79 */ "arguments ::= PARENL argument_list PARENR",
 /*  80 */ "argument_list ::=",
 /*  81 */ "argument_list ::= assignment_expression",
 /*  82 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  83 */ "output_columns ::=",
 /*  84 */ "output_columns ::= output_column",
 /*  85 */ "output_columns ::= output_columns COMMA",
 /*  86 */ "output_columns ::= output_columns COMMA output_column",
 /*  87 */ "output_column ::= STAR",
 /*  88 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  89 */ "output_column ::= assignment_expression",
 /*  90 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  91 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  92 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  93 */ "input ::= query",
 /*  94 */ "input ::= expression",
 /*  95 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*  96 */ "input ::= START_ADJUSTER adjuster",
 /*  97 */ "input ::= START_GROUP_KEYS group_keys",
 /*  98 */ "query ::= query_element",
 /*  99 */ "query_element ::= QSTRING",
 /* 100 */ "query_element ::= PARENL query PARENR",
 /* 101 */ "expression ::= assignment_expression",
 /* 102 */ "assignment_expression ::= conditional_expression",
 /* 103 */ "conditional_expression ::= logical_or_expression",
 /* 104 */ "logical_or_expression ::= logical_and_expression",
 /* 105 */ "logical_and_expression ::= bitwise_or_expression",
 /* 106 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /* 107 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 108 */ "bitwise_and_expression ::= equality_expression",
 /* 109 */ "equality_expression ::= relational_expression",
 /* 110 */ "relational_expression ::= shift_expression",
 /* 111 */ "shift_expression ::= additive_expression",
 /* 112 */ "additive_expression ::= multiplicative_expression",
 /* 113 */ "multiplicative_expression ::= unary_expression",
 /* 114 */ "unary_expression ::= postfix_expression",
 /* 115 */ "postfix_expression ::= lefthand_side_expression",
 /* 116 */ "lefthand_side_expression ::= call_expression",
 /* 117 */ "lefthand_side_expression ::= member_expression",
 /* 118 */ "member_expression ::= primary_expression",
 /* 119 */ "member_expression ::= member_expression member_expression_part",
 /* 120 */ "primary_expression ::= object_literal",
 /* 121 */ "primary_expression ::= PARENL expression PARENR",
 /* 122 */ "primary_expression ::= IDENTIFIER",
 /* 123 */ "primary_expression ::= array_literal",
 /* 124 */ "primary_expression ::= DECIMAL",
 /* 125 */ "primary_expression ::= HEX_INTEGER",
 /* 126 */ "primary_expression ::= STRING",
 /* 127 */ "primary_expression ::= BOOLEAN",
 /* 128 */ "primary_expression ::= NULL",
 /* 129 */ "property_name_and_value_list ::= property_name_and_value",
 /* 130 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 131 */ "property_name ::= STRING",
 /* 132 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 133 */ "adjuster ::=",
 /* 134 */ "adjuster ::= adjust_expression",
 /* 135 */ "adjust_expression ::= adjust_match_expression",
 /* 136 */ "group_keys ::=",
 /* 137 */ "group_keys ::= expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypRawParser grn_expr_parserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  grn_expr_parserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) grn_expr_parserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    grn_expr_parserCTX_STORE
    grn_expr_parserInit(yypParser grn_expr_parserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 79: /* suppress_unused_variable_warning */
{
#line 56 "../../groonga/lib/grn_ecmascript.lemon"

  (void)efsi;

#line 1150 "../../groonga/lib/grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int grn_expr_parserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH
   grn_expr_parserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument var */
   grn_expr_parserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    81,  /* (0) query ::= query query_element */
    81,  /* (1) query ::= query LOGICAL_AND query_element */
    81,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
    81,  /* (3) query ::= query LOGICAL_OR query_element */
    81,  /* (4) query ::= query NEGATIVE query_element */
    86,  /* (5) query_element ::= ADJUST query_element */
    86,  /* (6) query_element ::= RELATIVE_OP query_element */
    86,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
    86,  /* (8) query_element ::= BRACEL expression BRACER */
    86,  /* (9) query_element ::= EVAL primary_expression */
    82,  /* (10) expression ::= expression COMMA assignment_expression */
    88,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
    88,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
    88,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
    88,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
    88,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
    88,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
    88,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
    88,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
    88,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
    88,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
    88,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
    88,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
    89,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
    91,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
    92,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
    92,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
    93,  /* (27) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
    94,  /* (28) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
    95,  /* (29) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
    96,  /* (30) equality_expression ::= equality_expression EQUAL relational_expression */
    96,  /* (31) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
    97,  /* (32) relational_expression ::= relational_expression LESS shift_expression */
    97,  /* (33) relational_expression ::= relational_expression GREATER shift_expression */
    97,  /* (34) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
    97,  /* (35) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
    97,  /* (36) relational_expression ::= relational_expression IN shift_expression */
    97,  /* (37) relational_expression ::= relational_expression MATCH shift_expression */
    97,  /* (38) relational_expression ::= relational_expression NEAR shift_expression */
    97,  /* (39) relational_expression ::= relational_expression NEAR2 shift_expression */
    97,  /* (40) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
    97,  /* (41) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
    97,  /* (42) relational_expression ::= relational_expression SIMILAR shift_expression */
    97,  /* (43) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
    97,  /* (44) relational_expression ::= relational_expression QUORUM shift_expression */
    97,  /* (45) relational_expression ::= relational_expression LCP shift_expression */
    97,  /* (46) relational_expression ::= relational_expression PREFIX shift_expression */
    97,  /* (47) relational_expression ::= relational_expression SUFFIX shift_expression */
    97,  /* (48) relational_expression ::= relational_expression REGEXP shift_expression */
    98,  /* (49) shift_expression ::= shift_expression SHIFTL additive_expression */
    98,  /* (50) shift_expression ::= shift_expression SHIFTR additive_expression */
    98,  /* (51) shift_expression ::= shift_expression SHIFTRR additive_expression */
    99,  /* (52) additive_expression ::= additive_expression PLUS multiplicative_expression */
    99,  /* (53) additive_expression ::= additive_expression MINUS multiplicative_expression */
   100,  /* (54) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   100,  /* (55) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   100,  /* (56) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   101,  /* (57) unary_expression ::= DELETE unary_expression */
   101,  /* (58) unary_expression ::= INCR unary_expression */
   101,  /* (59) unary_expression ::= DECR unary_expression */
   101,  /* (60) unary_expression ::= PLUS unary_expression */
   101,  /* (61) unary_expression ::= MINUS unary_expression */
   101,  /* (62) unary_expression ::= NOT unary_expression */
   101,  /* (63) unary_expression ::= BITWISE_NOT unary_expression */
   101,  /* (64) unary_expression ::= ADJUST unary_expression */
   101,  /* (65) unary_expression ::= EXACT unary_expression */
   101,  /* (66) unary_expression ::= PARTIAL unary_expression */
   101,  /* (67) unary_expression ::= UNSPLIT unary_expression */
   102,  /* (68) postfix_expression ::= lefthand_side_expression INCR */
   102,  /* (69) postfix_expression ::= lefthand_side_expression DECR */
   103,  /* (70) call_expression ::= member_expression arguments */
   108,  /* (71) array_literal ::= BRACKETL element_list BRACKETR */
   109,  /* (72) element_list ::= */
   109,  /* (73) element_list ::= assignment_expression */
   109,  /* (74) element_list ::= element_list COMMA assignment_expression */
   107,  /* (75) object_literal ::= BRACEL property_name_and_value_list BRACER */
   110,  /* (76) property_name_and_value_list ::= */
   111,  /* (77) property_name_and_value ::= property_name COLON assignment_expression */
   106,  /* (78) member_expression_part ::= BRACKETL expression BRACKETR */
   105,  /* (79) arguments ::= PARENL argument_list PARENR */
   113,  /* (80) argument_list ::= */
   113,  /* (81) argument_list ::= assignment_expression */
   113,  /* (82) argument_list ::= argument_list COMMA assignment_expression */
    83,  /* (83) output_columns ::= */
    83,  /* (84) output_columns ::= output_column */
    83,  /* (85) output_columns ::= output_columns COMMA */
    83,  /* (86) output_columns ::= output_columns COMMA output_column */
   114,  /* (87) output_column ::= STAR */
   114,  /* (88) output_column ::= NONEXISTENT_COLUMN */
   114,  /* (89) output_column ::= assignment_expression */
    84,  /* (90) adjuster ::= adjuster PLUS adjust_expression */
   115,  /* (91) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   116,  /* (92) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    80,  /* (93) input ::= query */
    80,  /* (94) input ::= expression */
    80,  /* (95) input ::= START_OUTPUT_COLUMNS output_columns */
    80,  /* (96) input ::= START_ADJUSTER adjuster */
    80,  /* (97) input ::= START_GROUP_KEYS group_keys */
    81,  /* (98) query ::= query_element */
    86,  /* (99) query_element ::= QSTRING */
    86,  /* (100) query_element ::= PARENL query PARENR */
    82,  /* (101) expression ::= assignment_expression */
    88,  /* (102) assignment_expression ::= conditional_expression */
    89,  /* (103) conditional_expression ::= logical_or_expression */
    91,  /* (104) logical_or_expression ::= logical_and_expression */
    92,  /* (105) logical_and_expression ::= bitwise_or_expression */
    93,  /* (106) bitwise_or_expression ::= bitwise_xor_expression */
    94,  /* (107) bitwise_xor_expression ::= bitwise_and_expression */
    95,  /* (108) bitwise_and_expression ::= equality_expression */
    96,  /* (109) equality_expression ::= relational_expression */
    97,  /* (110) relational_expression ::= shift_expression */
    98,  /* (111) shift_expression ::= additive_expression */
    99,  /* (112) additive_expression ::= multiplicative_expression */
   100,  /* (113) multiplicative_expression ::= unary_expression */
   101,  /* (114) unary_expression ::= postfix_expression */
   102,  /* (115) postfix_expression ::= lefthand_side_expression */
    90,  /* (116) lefthand_side_expression ::= call_expression */
    90,  /* (117) lefthand_side_expression ::= member_expression */
   104,  /* (118) member_expression ::= primary_expression */
   104,  /* (119) member_expression ::= member_expression member_expression_part */
    87,  /* (120) primary_expression ::= object_literal */
    87,  /* (121) primary_expression ::= PARENL expression PARENR */
    87,  /* (122) primary_expression ::= IDENTIFIER */
    87,  /* (123) primary_expression ::= array_literal */
    87,  /* (124) primary_expression ::= DECIMAL */
    87,  /* (125) primary_expression ::= HEX_INTEGER */
    87,  /* (126) primary_expression ::= STRING */
    87,  /* (127) primary_expression ::= BOOLEAN */
    87,  /* (128) primary_expression ::= NULL */
   110,  /* (129) property_name_and_value_list ::= property_name_and_value */
   110,  /* (130) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */
   112,  /* (131) property_name ::= STRING */
   106,  /* (132) member_expression_part ::= DOT IDENTIFIER */
    84,  /* (133) adjuster ::= */
    84,  /* (134) adjuster ::= adjust_expression */
   115,  /* (135) adjust_expression ::= adjust_match_expression */
    85,  /* (136) group_keys ::= */
    85,  /* (137) group_keys ::= expression */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -2,  /* (0) query ::= query query_element */
   -3,  /* (1) query ::= query LOGICAL_AND query_element */
   -3,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
   -3,  /* (3) query ::= query LOGICAL_OR query_element */
   -3,  /* (4) query ::= query NEGATIVE query_element */
   -2,  /* (5) query_element ::= ADJUST query_element */
   -2,  /* (6) query_element ::= RELATIVE_OP query_element */
   -3,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
   -3,  /* (8) query_element ::= BRACEL expression BRACER */
   -2,  /* (9) query_element ::= EVAL primary_expression */
   -3,  /* (10) expression ::= expression COMMA assignment_expression */
   -3,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
   -3,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
   -3,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
   -3,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
   -3,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
   -3,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
   -3,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
   -3,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
   -3,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
   -3,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
   -3,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
   -3,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
   -5,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
   -3,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
   -3,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
   -3,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
   -3,  /* (27) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
   -3,  /* (28) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
   -3,  /* (29) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
   -3,  /* (30) equality_expression ::= equality_expression EQUAL relational_expression */
   -3,  /* (31) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
   -3,  /* (32) relational_expression ::= relational_expression LESS shift_expression */
   -3,  /* (33) relational_expression ::= relational_expression GREATER shift_expression */
   -3,  /* (34) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
   -3,  /* (35) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
   -3,  /* (36) relational_expression ::= relational_expression IN shift_expression */
   -3,  /* (37) relational_expression ::= relational_expression MATCH shift_expression */
   -3,  /* (38) relational_expression ::= relational_expression NEAR shift_expression */
   -3,  /* (39) relational_expression ::= relational_expression NEAR2 shift_expression */
   -3,  /* (40) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
   -3,  /* (41) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
   -3,  /* (42) relational_expression ::= relational_expression SIMILAR shift_expression */
   -3,  /* (43) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
   -3,  /* (44) relational_expression ::= relational_expression QUORUM shift_expression */
   -3,  /* (45) relational_expression ::= relational_expression LCP shift_expression */
   -3,  /* (46) relational_expression ::= relational_expression PREFIX shift_expression */
   -3,  /* (47) relational_expression ::= relational_expression SUFFIX shift_expression */
   -3,  /* (48) relational_expression ::= relational_expression REGEXP shift_expression */
   -3,  /* (49) shift_expression ::= shift_expression SHIFTL additive_expression */
   -3,  /* (50) shift_expression ::= shift_expression SHIFTR additive_expression */
   -3,  /* (51) shift_expression ::= shift_expression SHIFTRR additive_expression */
   -3,  /* (52) additive_expression ::= additive_expression PLUS multiplicative_expression */
   -3,  /* (53) additive_expression ::= additive_expression MINUS multiplicative_expression */
   -3,  /* (54) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   -3,  /* (55) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   -3,  /* (56) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   -2,  /* (57) unary_expression ::= DELETE unary_expression */
   -2,  /* (58) unary_expression ::= INCR unary_expression */
   -2,  /* (59) unary_expression ::= DECR unary_expression */
   -2,  /* (60) unary_expression ::= PLUS unary_expression */
   -2,  /* (61) unary_expression ::= MINUS unary_expression */
   -2,  /* (62) unary_expression ::= NOT unary_expression */
   -2,  /* (63) unary_expression ::= BITWISE_NOT unary_expression */
   -2,  /* (64) unary_expression ::= ADJUST unary_expression */
   -2,  /* (65) unary_expression ::= EXACT unary_expression */
   -2,  /* (66) unary_expression ::= PARTIAL unary_expression */
   -2,  /* (67) unary_expression ::= UNSPLIT unary_expression */
   -2,  /* (68) postfix_expression ::= lefthand_side_expression INCR */
   -2,  /* (69) postfix_expression ::= lefthand_side_expression DECR */
   -2,  /* (70) call_expression ::= member_expression arguments */
   -3,  /* (71) array_literal ::= BRACKETL element_list BRACKETR */
    0,  /* (72) element_list ::= */
   -1,  /* (73) element_list ::= assignment_expression */
   -3,  /* (74) element_list ::= element_list COMMA assignment_expression */
   -3,  /* (75) object_literal ::= BRACEL property_name_and_value_list BRACER */
    0,  /* (76) property_name_and_value_list ::= */
   -3,  /* (77) property_name_and_value ::= property_name COLON assignment_expression */
   -3,  /* (78) member_expression_part ::= BRACKETL expression BRACKETR */
   -3,  /* (79) arguments ::= PARENL argument_list PARENR */
    0,  /* (80) argument_list ::= */
   -1,  /* (81) argument_list ::= assignment_expression */
   -3,  /* (82) argument_list ::= argument_list COMMA assignment_expression */
    0,  /* (83) output_columns ::= */
   -1,  /* (84) output_columns ::= output_column */
   -2,  /* (85) output_columns ::= output_columns COMMA */
   -3,  /* (86) output_columns ::= output_columns COMMA output_column */
   -1,  /* (87) output_column ::= STAR */
   -1,  /* (88) output_column ::= NONEXISTENT_COLUMN */
   -1,  /* (89) output_column ::= assignment_expression */
   -3,  /* (90) adjuster ::= adjuster PLUS adjust_expression */
   -3,  /* (91) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   -3,  /* (92) adjust_match_expression ::= IDENTIFIER MATCH STRING */
   -1,  /* (93) input ::= query */
   -1,  /* (94) input ::= expression */
   -2,  /* (95) input ::= START_OUTPUT_COLUMNS output_columns */
   -2,  /* (96) input ::= START_ADJUSTER adjuster */
   -2,  /* (97) input ::= START_GROUP_KEYS group_keys */
   -1,  /* (98) query ::= query_element */
   -1,  /* (99) query_element ::= QSTRING */
   -3,  /* (100) query_element ::= PARENL query PARENR */
   -1,  /* (101) expression ::= assignment_expression */
   -1,  /* (102) assignment_expression ::= conditional_expression */
   -1,  /* (103) conditional_expression ::= logical_or_expression */
   -1,  /* (104) logical_or_expression ::= logical_and_expression */
   -1,  /* (105) logical_and_expression ::= bitwise_or_expression */
   -1,  /* (106) bitwise_or_expression ::= bitwise_xor_expression */
   -1,  /* (107) bitwise_xor_expression ::= bitwise_and_expression */
   -1,  /* (108) bitwise_and_expression ::= equality_expression */
   -1,  /* (109) equality_expression ::= relational_expression */
   -1,  /* (110) relational_expression ::= shift_expression */
   -1,  /* (111) shift_expression ::= additive_expression */
   -1,  /* (112) additive_expression ::= multiplicative_expression */
   -1,  /* (113) multiplicative_expression ::= unary_expression */
   -1,  /* (114) unary_expression ::= postfix_expression */
   -1,  /* (115) postfix_expression ::= lefthand_side_expression */
   -1,  /* (116) lefthand_side_expression ::= call_expression */
   -1,  /* (117) lefthand_side_expression ::= member_expression */
   -1,  /* (118) member_expression ::= primary_expression */
   -2,  /* (119) member_expression ::= member_expression member_expression_part */
   -1,  /* (120) primary_expression ::= object_literal */
   -3,  /* (121) primary_expression ::= PARENL expression PARENR */
   -1,  /* (122) primary_expression ::= IDENTIFIER */
   -1,  /* (123) primary_expression ::= array_literal */
   -1,  /* (124) primary_expression ::= DECIMAL */
   -1,  /* (125) primary_expression ::= HEX_INTEGER */
   -1,  /* (126) primary_expression ::= STRING */
   -1,  /* (127) primary_expression ::= BOOLEAN */
   -1,  /* (128) primary_expression ::= NULL */
   -1,  /* (129) property_name_and_value_list ::= property_name_and_value */
   -3,  /* (130) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */
   -1,  /* (131) property_name ::= STRING */
   -2,  /* (132) member_expression_part ::= DOT IDENTIFIER */
    0,  /* (133) adjuster ::= */
   -1,  /* (134) adjuster ::= adjust_expression */
   -1,  /* (135) adjust_expression ::= adjust_match_expression */
    0,  /* (136) group_keys ::= */
   -1,  /* (137) group_keys ::= expression */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  grn_expr_parserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  grn_expr_parserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 98 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1814 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 101 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1822 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 104 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1830 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 107 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1838 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 110 "../../groonga/lib/grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 1847 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 119 "../../groonga/lib/grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
}
#line 1855 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 123 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 1863 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 127 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR2 :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_NEAR_PHRASE :
  case GRN_OP_ORDERED_NEAR_PHRASE :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
      int additional_last_interval;
      GRN_INT32_POP(&efsi->additional_last_interval_stack,
                    additional_last_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  case GRN_OP_QUORUM :
    {
      int quorum_threshold;
      GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    }
    break;
  default :
    break;
  }
}
#line 1906 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 166 "../../groonga/lib/grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 1914 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 174 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1921 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 179 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1928 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 182 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1935 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 185 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1942 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 188 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1949 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 191 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1956 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 194 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1963 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 197 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1970 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 200 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1977 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 203 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1984 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 206 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1991 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 209 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1998 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 212 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 2005 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 217 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 2014 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 27: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 237 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 2021 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 28: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 242 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 2028 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 29: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 247 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 2035 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 30: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 252 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 2042 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 31: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 255 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 2049 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 32: /* relational_expression ::= relational_expression LESS shift_expression */
#line 260 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 2056 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 33: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 263 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 2063 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 266 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 2070 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 269 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 2077 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression IN shift_expression */
#line 272 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 2084 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 92: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==92);
#line 275 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 2092 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 278 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 3);
}
#line 2105 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 287 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 2112 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
#line 290 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_PHRASE, 4);
}
#line 2130 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
#line 304 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ORDERED_NEAR_PHRASE, 4);
}
#line 2148 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 318 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int similarity_threshold;
    GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, similarity_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 3);
}
#line 2161 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 327 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 2168 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression QUORUM shift_expression */
#line 330 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int quorum_threshold;
    GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, quorum_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_QUORUM, 3);
}
#line 2181 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression LCP shift_expression */
#line 339 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 2188 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 342 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 2195 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 345 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 2202 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 48: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 348 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 2209 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 49: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 353 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 2216 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 50: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 356 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 2223 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 51: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 359 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 2230 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 52: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 90: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==90);
#line 364 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 2238 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 53: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 367 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 2245 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 54: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 91: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==91);
#line 372 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 2253 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 55: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 375 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 2260 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 56: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 378 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 2267 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 57: /* unary_expression ::= DELETE unary_expression */
#line 383 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 2274 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 58: /* unary_expression ::= INCR unary_expression */
#line 386 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 2295 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 59: /* unary_expression ::= DECR unary_expression */
#line 403 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 2316 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 60: /* unary_expression ::= PLUS unary_expression */
#line 420 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 2323 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= MINUS unary_expression */
#line 423 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 2330 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= NOT unary_expression */
#line 426 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 2337 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 429 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 2344 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= ADJUST unary_expression */
#line 432 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 2351 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 65: /* unary_expression ::= EXACT unary_expression */
#line 435 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 2358 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 66: /* unary_expression ::= PARTIAL unary_expression */
#line 438 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 2365 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 67: /* unary_expression ::= UNSPLIT unary_expression */
#line 441 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 2372 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 68: /* postfix_expression ::= lefthand_side_expression INCR */
#line 446 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 2393 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 69: /* postfix_expression ::= lefthand_side_expression DECR */
#line 463 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 2414 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 70: /* call_expression ::= member_expression arguments */
#line 484 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 2421 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 71: /* array_literal ::= BRACKETL element_list BRACKETR */
#line 501 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  if (efsi->array_literal) {
    grn_expr_take_obj(ctx, efsi->e, efsi->array_literal);
    grn_expr_append_obj(ctx, efsi->e, efsi->array_literal,
                        GRN_OP_PUSH, 1);
    efsi->array_literal = NULL;
  }
}
#line 2434 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 72: /* element_list ::= */
#line 511 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->array_literal = grn_obj_open(ctx, GRN_VECTOR, 0, GRN_ID_NIL);
  if (!efsi->array_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create vector for parsing array literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 2448 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 73: /* element_list ::= assignment_expression */
      case 74: /* element_list ::= element_list COMMA assignment_expression */ yytestcase(yyruleno==74);
#line 522 "../../groonga/lib/grn_ecmascript.lemon"
{
  array_literal_add_element(efsi);
}
#line 2456 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 75: /* object_literal ::= BRACEL property_name_and_value_list BRACER */
#line 530 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal));
  grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal),
                      GRN_OP_PUSH, 1);
  efsi->object_literal = NULL;
}
#line 2467 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 76: /* property_name_and_value_list ::= */
#line 538 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->object_literal =
    grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                    GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 2483 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 77: /* property_name_and_value ::= property_name COLON assignment_expression */
#line 553 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_obj *property = e->codes[e->codes_curr - 3].value;
  grn_obj *value = e->codes[e->codes_curr - 1].value;

  if (!efsi->object_literal) {
     efsi->object_literal =
       grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                       GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  }

  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_obj *buf;
    int added;
    if (grn_hash_add(ctx, (grn_hash *)efsi->object_literal,
                     GRN_TEXT_VALUE(property), GRN_TEXT_LEN(property),
                     (void **)&buf, &added)) {
      if (added) {
        switch (value->header.type) {
        case GRN_TABLE_HASH_KEY :
        case GRN_COLUMN_FIX_SIZE :
        case GRN_COLUMN_VAR_SIZE :
        case GRN_COLUMN_INDEX :
          GRN_OBJ_INIT(buf, GRN_PTR, 0, GRN_ID_NIL);
          GRN_PTR_SET(ctx, buf, value);
          break;
        case GRN_VECTOR :
          GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
          grn_vector_copy(ctx, value, buf);
          break;
        default :
          GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
          GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
          break;
        }
        grn_expr_dfi_pop(e);
        e->codes_curr -= 3;
      } else {
        ERR(GRN_INVALID_ARGUMENT,
            "duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(property),
            GRN_TEXT_VALUE(property));
      }
    } else {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "failed to add a property to object literal: <%.*s>",
          (int)GRN_TEXT_LEN(property),
          GRN_TEXT_VALUE(property));
    }
  }
}
#line 2543 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 78: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 612 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2550 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 79: /* arguments ::= PARENL argument_list PARENR */
#line 617 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2555 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 80: /* argument_list ::= */
#line 618 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2560 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 81: /* argument_list ::= assignment_expression */
#line 619 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2565 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 82: /* argument_list ::= argument_list COMMA assignment_expression */
#line 620 "../../groonga/lib/grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2570 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 83: /* output_columns ::= */
#line 622 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2578 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 84: /* output_columns ::= output_column */
#line 625 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2585 "../../groonga/lib/grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 85: /* output_columns ::= output_columns COMMA */
#line 630 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2593 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 86: /* output_columns ::= output_columns COMMA output_column */
#line 635 "../../groonga/lib/grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2610 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 87: /* output_column ::= STAR */
#line 648 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      grn_expr_take_obj(ctx, expr, column);
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        grn_expr_take_obj(ctx, expr, column);
      }
    }

    if (grn_enable_reference_count) {
      grn_obj_unlink(ctx, table);
    }
    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2664 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 88: /* output_column ::= NONEXISTENT_COLUMN */
#line 697 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2671 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 89: /* output_column ::= assignment_expression */
#line 700 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2678 "../../groonga/lib/grn_ecmascript.c"
        break;
      default:
      /* (93) input ::= query */ yytestcase(yyruleno==93);
      /* (94) input ::= expression */ yytestcase(yyruleno==94);
      /* (95) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==95);
      /* (96) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==96);
      /* (97) input ::= START_GROUP_KEYS group_keys */ yytestcase(yyruleno==97);
      /* (98) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=98);
      /* (99) query_element ::= QSTRING */ yytestcase(yyruleno==99);
      /* (100) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==100);
      /* (101) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=101);
      /* (102) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=102);
      /* (103) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==103);
      /* (104) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==104);
      /* (105) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==105);
      /* (106) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==106);
      /* (107) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==107);
      /* (108) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==108);
      /* (109) equality_expression ::= relational_expression */ yytestcase(yyruleno==109);
      /* (110) relational_expression ::= shift_expression */ yytestcase(yyruleno==110);
      /* (111) shift_expression ::= additive_expression */ yytestcase(yyruleno==111);
      /* (112) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==112);
      /* (113) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=113);
      /* (114) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=114);
      /* (115) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==115);
      /* (116) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=116);
      /* (117) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==117);
      /* (118) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=118);
      /* (119) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==119);
      /* (120) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=120);
      /* (121) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==121);
      /* (122) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==122);
      /* (123) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=123);
      /* (124) primary_expression ::= DECIMAL */ yytestcase(yyruleno==124);
      /* (125) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==125);
      /* (126) primary_expression ::= STRING */ yytestcase(yyruleno==126);
      /* (127) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==127);
      /* (128) primary_expression ::= NULL */ yytestcase(yyruleno==128);
      /* (129) property_name_and_value_list ::= property_name_and_value (OPTIMIZED OUT) */ assert(yyruleno!=129);
      /* (130) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==130);
      /* (131) property_name ::= STRING */ yytestcase(yyruleno==131);
      /* (132) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==132);
      /* (133) adjuster ::= */ yytestcase(yyruleno==133);
      /* (134) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=134);
      /* (135) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==135);
      /* (136) group_keys ::= */ yytestcase(yyruleno==136);
      /* (137) group_keys ::= expression */ yytestcase(yyruleno==137);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 62 "../../groonga/lib/grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      char errbuf[GRN_CTX_MSGSIZE];
      grn_strcpy(errbuf, GRN_CTX_MSGSIZE, ctx->errbuf);
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 2813 "../../groonga/lib/grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  grn_expr_parserCTX_FETCH
  grn_expr_parserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor grn_expr_parserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int grn_expr_parserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
