// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: control.proto

/*
	Package controlpb is a generated protocol buffer package.

	It is generated from these files:
		control.proto

	It has these top-level messages:
		Command
		Node
		Metrics
		Unsubscribe
		Disconnect
		SurveyRequest
		SurveyResponse
*/
package controlpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import bytes "bytes"

import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type MethodType int32

const (
	MethodTypeNode           MethodType = 0
	MethodTypeUnsubscribe    MethodType = 1
	MethodTypeDisconnect     MethodType = 2
	MethodTypeShutdown       MethodType = 3
	MethodTypeSurveyRequest  MethodType = 4
	MethodTypeSurveyResponse MethodType = 5
)

var MethodType_name = map[int32]string{
	0: "NODE",
	1: "UNSUBSCRIBE",
	2: "DISCONNECT",
	3: "SHUTDOWN",
	4: "SURVEY_REQUEST",
	5: "SURVEY_RESPONSE",
}
var MethodType_value = map[string]int32{
	"NODE":            0,
	"UNSUBSCRIBE":     1,
	"DISCONNECT":      2,
	"SHUTDOWN":        3,
	"SURVEY_REQUEST":  4,
	"SURVEY_RESPONSE": 5,
}

func (x MethodType) String() string {
	return proto.EnumName(MethodType_name, int32(x))
}
func (MethodType) EnumDescriptor() ([]byte, []int) { return fileDescriptorControl, []int{0} }

type Command struct {
	UID    string     `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid"`
	Method MethodType `protobuf:"varint,2,opt,name=method,proto3,enum=controlpb.MethodType" json:"method"`
	Params Raw        `protobuf:"bytes,3,opt,name=params,proto3,customtype=Raw" json:"params"`
}

func (m *Command) Reset()                    { *m = Command{} }
func (m *Command) String() string            { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()               {}
func (*Command) Descriptor() ([]byte, []int) { return fileDescriptorControl, []int{0} }

func (m *Command) GetUID() string {
	if m != nil {
		return m.UID
	}
	return ""
}

func (m *Command) GetMethod() MethodType {
	if m != nil {
		return m.Method
	}
	return MethodTypeNode
}

type Node struct {
	UID         string   `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid"`
	Name        string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name"`
	Version     string   `protobuf:"bytes,3,opt,name=version,proto3" json:"version"`
	NumClients  uint32   `protobuf:"varint,4,opt,name=num_clients,json=numClients,proto3" json:"num_clients"`
	NumUsers    uint32   `protobuf:"varint,5,opt,name=num_users,json=numUsers,proto3" json:"num_users"`
	NumChannels uint32   `protobuf:"varint,6,opt,name=num_channels,json=numChannels,proto3" json:"num_channels"`
	Uptime      uint32   `protobuf:"varint,7,opt,name=uptime,proto3" json:"uptime"`
	Metrics     *Metrics `protobuf:"bytes,8,opt,name=metrics" json:"metrics"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptorControl, []int{1} }

func (m *Node) GetUID() string {
	if m != nil {
		return m.UID
	}
	return ""
}

func (m *Node) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Node) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Node) GetNumClients() uint32 {
	if m != nil {
		return m.NumClients
	}
	return 0
}

func (m *Node) GetNumUsers() uint32 {
	if m != nil {
		return m.NumUsers
	}
	return 0
}

func (m *Node) GetNumChannels() uint32 {
	if m != nil {
		return m.NumChannels
	}
	return 0
}

func (m *Node) GetUptime() uint32 {
	if m != nil {
		return m.Uptime
	}
	return 0
}

func (m *Node) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type Metrics struct {
	Interval float64            `protobuf:"fixed64,1,opt,name=interval,proto3" json:"interval"`
	Items    map[string]float64 `protobuf:"bytes,2,rep,name=items" json:"items" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
}

func (m *Metrics) Reset()                    { *m = Metrics{} }
func (m *Metrics) String() string            { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()               {}
func (*Metrics) Descriptor() ([]byte, []int) { return fileDescriptorControl, []int{2} }

func (m *Metrics) GetInterval() float64 {
	if m != nil {
		return m.Interval
	}
	return 0
}

func (m *Metrics) GetItems() map[string]float64 {
	if m != nil {
		return m.Items
	}
	return nil
}

type Unsubscribe struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel"`
	User    string `protobuf:"bytes,2,opt,name=user,proto3" json:"user"`
}

func (m *Unsubscribe) Reset()                    { *m = Unsubscribe{} }
func (m *Unsubscribe) String() string            { return proto.CompactTextString(m) }
func (*Unsubscribe) ProtoMessage()               {}
func (*Unsubscribe) Descriptor() ([]byte, []int) { return fileDescriptorControl, []int{3} }

func (m *Unsubscribe) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *Unsubscribe) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

type Disconnect struct {
	User      string   `protobuf:"bytes,1,opt,name=user,proto3" json:"user"`
	Whitelist []string `protobuf:"bytes,2,rep,name=whitelist" json:"whitelist"`
	Code      uint32   `protobuf:"varint,3,opt,name=code,proto3" json:"code"`
	Reason    string   `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason"`
	Reconnect bool     `protobuf:"varint,5,opt,name=reconnect,proto3" json:"reconnect"`
}

func (m *Disconnect) Reset()                    { *m = Disconnect{} }
func (m *Disconnect) String() string            { return proto.CompactTextString(m) }
func (*Disconnect) ProtoMessage()               {}
func (*Disconnect) Descriptor() ([]byte, []int) { return fileDescriptorControl, []int{4} }

func (m *Disconnect) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *Disconnect) GetWhitelist() []string {
	if m != nil {
		return m.Whitelist
	}
	return nil
}

func (m *Disconnect) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Disconnect) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Disconnect) GetReconnect() bool {
	if m != nil {
		return m.Reconnect
	}
	return false
}

type SurveyRequest struct {
	ID   uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id"`
	Op   string `protobuf:"bytes,2,opt,name=op,proto3" json:"op"`
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data"`
}

func (m *SurveyRequest) Reset()                    { *m = SurveyRequest{} }
func (m *SurveyRequest) String() string            { return proto.CompactTextString(m) }
func (*SurveyRequest) ProtoMessage()               {}
func (*SurveyRequest) Descriptor() ([]byte, []int) { return fileDescriptorControl, []int{5} }

func (m *SurveyRequest) GetID() uint64 {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *SurveyRequest) GetOp() string {
	if m != nil {
		return m.Op
	}
	return ""
}

func (m *SurveyRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type SurveyResponse struct {
	ID   uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id"`
	Code uint32 `protobuf:"varint,3,opt,name=code,proto3" json:"code"`
	Data []byte `protobuf:"bytes,4,opt,name=data,proto3" json:"data"`
}

func (m *SurveyResponse) Reset()                    { *m = SurveyResponse{} }
func (m *SurveyResponse) String() string            { return proto.CompactTextString(m) }
func (*SurveyResponse) ProtoMessage()               {}
func (*SurveyResponse) Descriptor() ([]byte, []int) { return fileDescriptorControl, []int{6} }

func (m *SurveyResponse) GetID() uint64 {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *SurveyResponse) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *SurveyResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterType((*Command)(nil), "controlpb.Command")
	proto.RegisterType((*Node)(nil), "controlpb.Node")
	proto.RegisterType((*Metrics)(nil), "controlpb.Metrics")
	proto.RegisterType((*Unsubscribe)(nil), "controlpb.Unsubscribe")
	proto.RegisterType((*Disconnect)(nil), "controlpb.Disconnect")
	proto.RegisterType((*SurveyRequest)(nil), "controlpb.SurveyRequest")
	proto.RegisterType((*SurveyResponse)(nil), "controlpb.SurveyResponse")
	proto.RegisterEnum("controlpb.MethodType", MethodType_name, MethodType_value)
}
func (this *Command) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Command)
	if !ok {
		that2, ok := that.(Command)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.UID != that1.UID {
		return false
	}
	if this.Method != that1.Method {
		return false
	}
	if !this.Params.Equal(that1.Params) {
		return false
	}
	return true
}
func (this *Node) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Node)
	if !ok {
		that2, ok := that.(Node)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.UID != that1.UID {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.NumClients != that1.NumClients {
		return false
	}
	if this.NumUsers != that1.NumUsers {
		return false
	}
	if this.NumChannels != that1.NumChannels {
		return false
	}
	if this.Uptime != that1.Uptime {
		return false
	}
	if !this.Metrics.Equal(that1.Metrics) {
		return false
	}
	return true
}
func (this *Metrics) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Metrics)
	if !ok {
		that2, ok := that.(Metrics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Interval != that1.Interval {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if this.Items[i] != that1.Items[i] {
			return false
		}
	}
	return true
}
func (this *Unsubscribe) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Unsubscribe)
	if !ok {
		that2, ok := that.(Unsubscribe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	if this.User != that1.User {
		return false
	}
	return true
}
func (this *Disconnect) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Disconnect)
	if !ok {
		that2, ok := that.(Disconnect)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if len(this.Whitelist) != len(that1.Whitelist) {
		return false
	}
	for i := range this.Whitelist {
		if this.Whitelist[i] != that1.Whitelist[i] {
			return false
		}
	}
	if this.Code != that1.Code {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Reconnect != that1.Reconnect {
		return false
	}
	return true
}
func (this *SurveyRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SurveyRequest)
	if !ok {
		that2, ok := that.(SurveyRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ID != that1.ID {
		return false
	}
	if this.Op != that1.Op {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *SurveyResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SurveyResponse)
	if !ok {
		that2, ok := that.(SurveyResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ID != that1.ID {
		return false
	}
	if this.Code != that1.Code {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (m *Command) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Command) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.UID)))
		i += copy(dAtA[i:], m.UID)
	}
	if m.Method != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.Method))
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintControl(dAtA, i, uint64(m.Params.Size()))
	n1, err := m.Params.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.UID)))
		i += copy(dAtA[i:], m.UID)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if m.NumClients != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.NumClients))
	}
	if m.NumUsers != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.NumUsers))
	}
	if m.NumChannels != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.NumChannels))
	}
	if m.Uptime != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.Uptime))
	}
	if m.Metrics != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.Metrics.Size()))
		n2, err := m.Metrics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *Metrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Interval != 0 {
		dAtA[i] = 0x9
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Interval))))
		i += 8
	}
	if len(m.Items) > 0 {
		for k, _ := range m.Items {
			dAtA[i] = 0x12
			i++
			v := m.Items[k]
			mapSize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + 8
			i = encodeVarintControl(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x11
			i++
			binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i += 8
		}
	}
	return i, nil
}

func (m *Unsubscribe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Unsubscribe) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	if len(m.User) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	return i, nil
}

func (m *Disconnect) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Disconnect) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Whitelist) > 0 {
		for _, s := range m.Whitelist {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Code != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.Code))
	}
	if len(m.Reason) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.Reason)))
		i += copy(dAtA[i:], m.Reason)
	}
	if m.Reconnect {
		dAtA[i] = 0x28
		i++
		if m.Reconnect {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *SurveyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SurveyRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.ID))
	}
	if len(m.Op) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.Op)))
		i += copy(dAtA[i:], m.Op)
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *SurveyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SurveyResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.ID))
	}
	if m.Code != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintControl(dAtA, i, uint64(m.Code))
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintControl(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func encodeVarintControl(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedCommand(r randyControl, easy bool) *Command {
	this := &Command{}
	this.UID = string(randStringControl(r))
	this.Method = MethodType([]int32{0, 1, 2, 3, 4, 5}[r.Intn(6)])
	v1 := NewPopulatedRaw(r)
	this.Params = *v1
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedNode(r randyControl, easy bool) *Node {
	this := &Node{}
	this.UID = string(randStringControl(r))
	this.Name = string(randStringControl(r))
	this.Version = string(randStringControl(r))
	this.NumClients = uint32(r.Uint32())
	this.NumUsers = uint32(r.Uint32())
	this.NumChannels = uint32(r.Uint32())
	this.Uptime = uint32(r.Uint32())
	if r.Intn(10) != 0 {
		this.Metrics = NewPopulatedMetrics(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMetrics(r randyControl, easy bool) *Metrics {
	this := &Metrics{}
	this.Interval = float64(r.Float64())
	if r.Intn(2) == 0 {
		this.Interval *= -1
	}
	if r.Intn(10) != 0 {
		v2 := r.Intn(10)
		this.Items = make(map[string]float64)
		for i := 0; i < v2; i++ {
			v3 := randStringControl(r)
			this.Items[v3] = float64(r.Float64())
			if r.Intn(2) == 0 {
				this.Items[v3] *= -1
			}
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedUnsubscribe(r randyControl, easy bool) *Unsubscribe {
	this := &Unsubscribe{}
	this.Channel = string(randStringControl(r))
	this.User = string(randStringControl(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedDisconnect(r randyControl, easy bool) *Disconnect {
	this := &Disconnect{}
	this.User = string(randStringControl(r))
	v4 := r.Intn(10)
	this.Whitelist = make([]string, v4)
	for i := 0; i < v4; i++ {
		this.Whitelist[i] = string(randStringControl(r))
	}
	this.Code = uint32(r.Uint32())
	this.Reason = string(randStringControl(r))
	this.Reconnect = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSurveyRequest(r randyControl, easy bool) *SurveyRequest {
	this := &SurveyRequest{}
	this.ID = uint64(uint64(r.Uint32()))
	this.Op = string(randStringControl(r))
	v5 := r.Intn(100)
	this.Data = make([]byte, v5)
	for i := 0; i < v5; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSurveyResponse(r randyControl, easy bool) *SurveyResponse {
	this := &SurveyResponse{}
	this.ID = uint64(uint64(r.Uint32()))
	this.Code = uint32(r.Uint32())
	v6 := r.Intn(100)
	this.Data = make([]byte, v6)
	for i := 0; i < v6; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyControl interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneControl(r randyControl) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringControl(r randyControl) string {
	v7 := r.Intn(100)
	tmps := make([]rune, v7)
	for i := 0; i < v7; i++ {
		tmps[i] = randUTF8RuneControl(r)
	}
	return string(tmps)
}
func randUnrecognizedControl(r randyControl, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldControl(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldControl(dAtA []byte, r randyControl, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateControl(dAtA, uint64(key))
		v8 := r.Int63()
		if r.Intn(2) == 0 {
			v8 *= -1
		}
		dAtA = encodeVarintPopulateControl(dAtA, uint64(v8))
	case 1:
		dAtA = encodeVarintPopulateControl(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateControl(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateControl(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateControl(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateControl(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Command) Size() (n int) {
	var l int
	_ = l
	l = len(m.UID)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovControl(uint64(m.Method))
	}
	l = m.Params.Size()
	n += 1 + l + sovControl(uint64(l))
	return n
}

func (m *Node) Size() (n int) {
	var l int
	_ = l
	l = len(m.UID)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.NumClients != 0 {
		n += 1 + sovControl(uint64(m.NumClients))
	}
	if m.NumUsers != 0 {
		n += 1 + sovControl(uint64(m.NumUsers))
	}
	if m.NumChannels != 0 {
		n += 1 + sovControl(uint64(m.NumChannels))
	}
	if m.Uptime != 0 {
		n += 1 + sovControl(uint64(m.Uptime))
	}
	if m.Metrics != nil {
		l = m.Metrics.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	return n
}

func (m *Metrics) Size() (n int) {
	var l int
	_ = l
	if m.Interval != 0 {
		n += 9
	}
	if len(m.Items) > 0 {
		for k, v := range m.Items {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + 8
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Unsubscribe) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	return n
}

func (m *Disconnect) Size() (n int) {
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Whitelist) > 0 {
		for _, s := range m.Whitelist {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.Code != 0 {
		n += 1 + sovControl(uint64(m.Code))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Reconnect {
		n += 2
	}
	return n
}

func (m *SurveyRequest) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovControl(uint64(m.ID))
	}
	l = len(m.Op)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	return n
}

func (m *SurveyResponse) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovControl(uint64(m.ID))
	}
	if m.Code != 0 {
		n += 1 + sovControl(uint64(m.Code))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	return n
}

func sovControl(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozControl(x uint64) (n int) {
	return sovControl(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Command) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Command: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Command: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= (MethodType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Params.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Node) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Node: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Node: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumClients", wireType)
			}
			m.NumClients = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumClients |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumUsers", wireType)
			}
			m.NumUsers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumUsers |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumChannels", wireType)
			}
			m.NumChannels = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumChannels |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uptime", wireType)
			}
			m.Uptime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Uptime |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metrics == nil {
				m.Metrics = &Metrics{}
			}
			if err := m.Metrics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Interval = float64(math.Float64frombits(v))
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Items == nil {
				m.Items = make(map[string]float64)
			}
			var mapkey string
			var mapvalue float64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapvaluetemp uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					mapvaluetemp = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					mapvalue = math.Float64frombits(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Items[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Unsubscribe) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Unsubscribe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Unsubscribe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Disconnect) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Disconnect: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Disconnect: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Whitelist", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Whitelist = append(m.Whitelist, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reconnect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reconnect = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SurveyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SurveyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SurveyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Op = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SurveyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SurveyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SurveyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipControl(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowControl
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowControl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowControl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthControl
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowControl
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipControl(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthControl = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowControl   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("control.proto", fileDescriptorControl) }

var fileDescriptorControl = []byte{
	// 855 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0x3f, 0x8f, 0xe3, 0x44,
	0x14, 0xdf, 0x71, 0xb2, 0xf9, 0xf3, 0xb2, 0xc9, 0x45, 0xa3, 0xdb, 0xc3, 0x98, 0x25, 0xb6, 0x22,
	0x90, 0xa2, 0x45, 0x97, 0x85, 0xbd, 0xe6, 0x8e, 0x82, 0xc2, 0x49, 0x24, 0xb6, 0x20, 0x0b, 0xe3,
	0x0d, 0x88, 0xea, 0xe4, 0xd8, 0xc3, 0xc6, 0x10, 0xcf, 0x18, 0xff, 0xd9, 0xd5, 0x7e, 0x03, 0x94,
	0xea, 0x1a, 0xca, 0x54, 0x34, 0x34, 0xf4, 0x7c, 0x02, 0x74, 0x25, 0x35, 0x85, 0x81, 0xd0, 0xf9,
	0x13, 0x50, 0xa2, 0x19, 0x3b, 0x71, 0x56, 0x77, 0x02, 0x9a, 0x99, 0xf7, 0x7e, 0xef, 0x37, 0xf3,
	0x9b, 0x79, 0xef, 0xcd, 0x40, 0xdb, 0xe1, 0x2c, 0x0e, 0xf9, 0x72, 0x18, 0x84, 0x3c, 0xe6, 0xb8,
	0x59, 0xb8, 0xc1, 0x5c, 0x7b, 0x7c, 0xed, 0xc5, 0x8b, 0x64, 0x3e, 0x74, 0xb8, 0x7f, 0x76, 0xcd,
	0xaf, 0xf9, 0x99, 0x64, 0xcc, 0x93, 0xaf, 0xa4, 0x27, 0x1d, 0x69, 0xe5, 0x2b, 0xfb, 0xdf, 0x23,
	0xa8, 0x8f, 0xb8, 0xef, 0xdb, 0xcc, 0xc5, 0x06, 0x54, 0x12, 0xcf, 0x55, 0x91, 0x81, 0x06, 0x4d,
	0xb3, 0xb3, 0x49, 0xf5, 0xca, 0xec, 0x62, 0x9c, 0xa5, 0xba, 0x40, 0x89, 0x18, 0xf0, 0x33, 0xa8,
	0xf9, 0x34, 0x5e, 0x70, 0x57, 0x55, 0x0c, 0x34, 0xe8, 0x9c, 0x1f, 0x0f, 0x77, 0xc2, 0xc3, 0x4f,
	0x64, 0xe0, 0xea, 0x2e, 0xa0, 0x26, 0x64, 0xa9, 0x5e, 0x10, 0x49, 0x31, 0xe3, 0xc7, 0x50, 0x0b,
	0xec, 0xd0, 0xf6, 0x23, 0xb5, 0x62, 0xa0, 0xc1, 0x91, 0x79, 0xfc, 0x32, 0xd5, 0x0f, 0x7e, 0x4b,
	0xf5, 0x0a, 0xb1, 0x6f, 0x05, 0x3d, 0x0f, 0x92, 0x62, 0xee, 0xff, 0xae, 0x40, 0x75, 0xca, 0x5d,
	0xfa, 0x3f, 0x0e, 0x75, 0x02, 0x55, 0x66, 0xfb, 0x54, 0x1e, 0xa9, 0x69, 0x36, 0xb2, 0x54, 0x97,
	0x3e, 0x91, 0x23, 0x7e, 0x17, 0xea, 0x37, 0x34, 0x8c, 0x3c, 0xce, 0xa4, 0x70, 0xd3, 0x6c, 0x65,
	0xa9, 0xbe, 0x85, 0xc8, 0xd6, 0xc0, 0xef, 0x43, 0x8b, 0x25, 0xfe, 0x73, 0x67, 0xe9, 0x51, 0x16,
	0x47, 0x6a, 0xd5, 0x40, 0x83, 0xb6, 0xf9, 0x20, 0x4b, 0xf5, 0x7d, 0x98, 0x00, 0x4b, 0xfc, 0x51,
	0x6e, 0xe3, 0x53, 0x68, 0x8a, 0x50, 0x12, 0xd1, 0x30, 0x52, 0x0f, 0x25, 0xbf, 0x9d, 0xa5, 0x7a,
	0x09, 0x92, 0x06, 0x4b, 0xfc, 0x99, 0xb0, 0xf0, 0x13, 0x38, 0x92, 0xdb, 0x2c, 0x6c, 0xc6, 0xe8,
	0x32, 0x52, 0x6b, 0x92, 0xde, 0xcd, 0x52, 0xfd, 0x1e, 0x4e, 0x84, 0xd8, 0xa8, 0x70, 0x70, 0x1f,
	0x6a, 0x49, 0x10, 0x7b, 0x3e, 0x55, 0xeb, 0x92, 0x2e, 0xb3, 0x9a, 0x23, 0xa4, 0x98, 0xf1, 0x33,
	0xa8, 0xfb, 0x34, 0x0e, 0x3d, 0x27, 0x52, 0x1b, 0x06, 0x1a, 0xb4, 0xce, 0xf1, 0xfd, 0x8a, 0x88,
	0x48, 0x7e, 0xe3, 0x82, 0x46, 0xb6, 0x46, 0xff, 0x27, 0x04, 0xf5, 0x82, 0x81, 0x07, 0xd0, 0xf0,
	0x58, 0x4c, 0xc3, 0x1b, 0x7b, 0x29, 0x33, 0x8d, 0xcc, 0xa3, 0x2c, 0xd5, 0x77, 0x18, 0xd9, 0x59,
	0xf8, 0x23, 0x38, 0xf4, 0x62, 0xea, 0x47, 0xaa, 0x62, 0x54, 0x06, 0xad, 0xf3, 0xb7, 0x5f, 0x95,
	0x1b, 0x5e, 0x88, 0xf8, 0x84, 0xc5, 0xe1, 0x9d, 0xd9, 0xcc, 0x52, 0x3d, 0xe7, 0x93, 0x7c, 0xd2,
	0x9e, 0x02, 0x94, 0x71, 0xdc, 0x85, 0xca, 0x37, 0xf4, 0x2e, 0x2f, 0x2e, 0x11, 0x26, 0x7e, 0x08,
	0x87, 0x37, 0xf6, 0x32, 0xc9, 0xab, 0x89, 0x48, 0xee, 0x7c, 0xa8, 0x3c, 0x45, 0x7d, 0x02, 0xad,
	0x19, 0x8b, 0x92, 0x79, 0xe4, 0x84, 0xde, 0x5c, 0xd6, 0xb5, 0x48, 0x5b, 0xd1, 0x1b, 0xf2, 0x96,
	0x05, 0x44, 0xb6, 0x86, 0x68, 0x0e, 0x51, 0x8c, 0xfd, 0xe6, 0x10, 0x3e, 0x91, 0x63, 0xff, 0x17,
	0x04, 0x30, 0xf6, 0x22, 0x87, 0x33, 0x46, 0x9d, 0x78, 0x47, 0x46, 0xaf, 0x23, 0xe3, 0xf7, 0xa0,
	0x79, 0xbb, 0xf0, 0x62, 0xba, 0xf4, 0xa2, 0x58, 0x5e, 0xbf, 0x99, 0x17, 0x7c, 0x07, 0x92, 0xd2,
	0x14, 0x5b, 0x39, 0xdc, 0xa5, 0xb2, 0xe7, 0xda, 0xf9, 0x56, 0xc2, 0x27, 0x72, 0x14, 0xa5, 0x0d,
	0xa9, 0x1d, 0x71, 0x26, 0x1b, 0xad, 0x99, 0x97, 0x36, 0x47, 0x48, 0x31, 0x0b, 0xb9, 0x90, 0x16,
	0x27, 0x93, 0xfd, 0xd5, 0xc8, 0xe5, 0x76, 0x20, 0x29, 0xcd, 0xbe, 0x03, 0x6d, 0x2b, 0x09, 0x6f,
	0xe8, 0x1d, 0xa1, 0xdf, 0x26, 0x54, 0xea, 0x2b, 0xc5, 0xab, 0xa9, 0x9a, 0x47, 0x9b, 0x54, 0x57,
	0xe4, 0xa3, 0x51, 0x3c, 0x97, 0x28, 0x9e, 0x8b, 0x1f, 0x81, 0xc2, 0x83, 0x22, 0x27, 0x35, 0x81,
	0xf3, 0x80, 0x28, 0x3c, 0x10, 0xa7, 0x76, 0xed, 0xd8, 0x2e, 0x9e, 0xa8, 0x3c, 0xb5, 0xf0, 0x89,
	0x1c, 0xfb, 0x5f, 0x43, 0x67, 0x2b, 0x12, 0x05, 0x9c, 0x45, 0xf4, 0x3f, 0x54, 0xfe, 0x3d, 0x07,
	0x5b, 0xad, 0xea, 0xeb, 0xb4, 0x4e, 0x5f, 0x28, 0x00, 0xe5, 0x8f, 0x22, 0xc8, 0xd3, 0xcb, 0xf1,
	0xa4, 0x7b, 0xa0, 0xe1, 0xd5, 0xda, 0xe8, 0x94, 0x11, 0xf9, 0x47, 0x9c, 0x42, 0x6b, 0x36, 0xb5,
	0x66, 0xa6, 0x35, 0x22, 0x17, 0xe6, 0xa4, 0x8b, 0xb4, 0x37, 0x57, 0x6b, 0xe3, 0xb8, 0x24, 0xed,
	0xf7, 0xcd, 0x00, 0x60, 0x7c, 0x61, 0x8d, 0x2e, 0xa7, 0xd3, 0xc9, 0xe8, 0xaa, 0xab, 0x68, 0xea,
	0x6a, 0x6d, 0x3c, 0x2c, 0xa9, 0x7b, 0xdd, 0xf0, 0x0e, 0x34, 0xac, 0x8f, 0x67, 0x57, 0xe3, 0xcb,
	0x2f, 0xa6, 0xdd, 0x8a, 0xf6, 0x68, 0xb5, 0x36, 0x70, 0xc9, 0xb3, 0x16, 0x49, 0xec, 0xf2, 0x5b,
	0x86, 0xcf, 0xa0, 0x63, 0xcd, 0xc8, 0xe7, 0x93, 0x2f, 0x9f, 0x93, 0xc9, 0x67, 0xb3, 0x89, 0x75,
	0xd5, 0xad, 0x6a, 0x6f, 0xad, 0xd6, 0xc6, 0x1b, 0x7b, 0xdc, 0x7b, 0x95, 0xf9, 0x00, 0x1e, 0xec,
	0x16, 0x58, 0x9f, 0x5e, 0x4e, 0xad, 0x49, 0xf7, 0x50, 0x3b, 0x59, 0xad, 0x0d, 0xf5, 0xd5, 0x15,
	0x79, 0x9a, 0xb5, 0xea, 0x77, 0x3f, 0xf4, 0x0e, 0xcc, 0x93, 0xbf, 0xff, 0xec, 0xa1, 0x1f, 0x37,
	0x3d, 0xf4, 0xf3, 0xa6, 0x87, 0x5e, 0x6e, 0x7a, 0xe8, 0xd7, 0x4d, 0x0f, 0xfd, 0xb1, 0xe9, 0xa1,
	0x17, 0x7f, 0xf5, 0x0e, 0xe6, 0x35, 0xf9, 0x9f, 0x3f, 0xf9, 0x27, 0x00, 0x00, 0xff, 0xff, 0xd0,
	0x87, 0xd1, 0x2b, 0x1a, 0x06, 0x00, 0x00,
}
