/*
 * Decompiled with CFR 0.152.
 */
package mspccs_spreadsheet_tester.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mspccs_spreadsheet_tester.utility.Directory;

public class AppResultsWindow
extends JFrame
implements ActionListener {
    private JTextArea output = new JTextArea(30, 10);
    private JButton btn_close;
    private JButton btn_save;
    private JButton btn_kill;
    private String app_name;
    private Process proc;
    private boolean proc_running = true;
    private boolean text_blocked = false;
    private Directory currentDir;

    public AppResultsWindow(Process process, String string, String string2, Directory directory) {
        Object object;
        this.currentDir = directory;
        this.setTitle(string + " " + "results (Status: Running)");
        URL uRL = this.getClass().getResource("/mspccs_spreadsheet_tester/gui/icons/NGA.gif");
        try {
            object = this.createImage((ImageProducer)uRL.getContent());
            this.setIconImage((Image)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.app_name = new String(string);
        object = this.getContentPane();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        JTextArea jTextArea = new JTextArea("Command:  " + string + " " + string2);
        jTextArea.setLineWrap(true);
        ((Container)object).add(jTextArea);
        JPanel jPanel = new JPanel();
        this.btn_kill = new JButton("Kill Process");
        this.btn_kill.setActionCommand("Kill");
        this.btn_kill.addActionListener(this);
        this.btn_close = new JButton("Close Window");
        this.btn_close.setActionCommand("Close");
        this.btn_close.addActionListener(this);
        this.btn_save = new JButton("Save Output");
        this.btn_save.setActionCommand("Save");
        this.btn_save.addActionListener(this);
        this.btn_save.setEnabled(false);
        jPanel.add(this.btn_kill);
        jPanel.add(this.btn_close);
        jPanel.add(this.btn_save);
        ((Container)object).add(jPanel);
        ((Container)object).add(new JScrollPane(this.output));
        this.proc = process;
        ProcessExit processExit = new ProcessExit(this.proc);
        StreamGobbler streamGobbler = new StreamGobbler(this.proc.getErrorStream(), "ERROR");
        StreamGobbler streamGobbler2 = new StreamGobbler(this.proc.getInputStream(), "OUTPUT");
        processExit.setPriority(8);
        streamGobbler.setPriority(4);
        streamGobbler2.setPriority(4);
        streamGobbler.start();
        streamGobbler2.start();
        processExit.start();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppResultsWindow.this.proc.destroy();
                AppResultsWindow.this.proc_running = false;
                AppResultsWindow.this.dispose();
            }
        });
        this.pack();
        this.setSize(800, 600);
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Kill")) {
            this.proc.destroy();
            this.proc_running = false;
            this.btn_kill.setEnabled(false);
            this.btn_save.setEnabled(true);
            this.setTitle(this.app_name + " " + "results (Status: Killed)");
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.proc.destroy();
            this.proc_running = false;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Save")) {
            JFileChooser jFileChooser = new JFileChooser(this.currentDir.getDirectory());
            jFileChooser.setDialogTitle("Select file to save to...");
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    FileWriter fileWriter = new FileWriter(file);
                    this.output.write(fileWriter);
                    fileWriter.close();
                    JOptionPane.showMessageDialog(null, "Output saved.");
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
    }

    class ProcessExit
    extends Thread {
        Process proc;

        ProcessExit(Process process) {
            this.proc = process;
        }

        public void run() {
            int n = -1;
            try {
                n = this.proc.waitFor();
                AppResultsWindow.this.proc_running = false;
                AppResultsWindow.this.btn_kill.setEnabled(false);
                AppResultsWindow.this.btn_save.setEnabled(true);
                AppResultsWindow.this.setTitle(AppResultsWindow.this.app_name + " " + "results (Status: Completed)");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AppResultsWindow.this.proc_running = false;
            }
        }
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream inputStream, String string) {
            this.is = inputStream;
            this.type = string;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 900000);
                String string = "Reading";
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.regionMatches(0, string, 0, 7)) continue;
                    AppResultsWindow.this.output.append(string2 + "\n");
                    AppResultsWindow.this.output.setCaretPosition(AppResultsWindow.this.output.getText().length());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

