{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCrossSectionCurve: TAbstractNurbsControlCurveNode;
    procedure SetCrossSectionCurve(const Value: TAbstractNurbsControlCurveNode);
    function GetTrajectoryCurve: TNurbsCurveNode;
    procedure SetTrajectoryCurve(const Value: TNurbsCurveNode);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCrossSectionCurve: TSFNode;
    { Internal wrapper for property @code(CrossSectionCurve). This wrapper API may change, we advise to access simpler @code(CrossSectionCurve) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCrossSectionCurve: TSFNode read FFdCrossSectionCurve;
    {  }
    property CrossSectionCurve: TAbstractNurbsControlCurveNode read GetCrossSectionCurve write SetCrossSectionCurve;

    strict private FFdTrajectoryCurve: TSFNode;
    { Internal wrapper for property @code(TrajectoryCurve). This wrapper API may change, we advise to access simpler @code(TrajectoryCurve) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTrajectoryCurve: TSFNode read FFdTrajectoryCurve;
    {  }
    property TrajectoryCurve: TNurbsCurveNode read GetTrajectoryCurve write SetTrajectoryCurve;

    strict private FFdCcw: TSFBool;
    { Internal wrapper for property @code(Ccw). This wrapper API may change, we advise to access simpler @code(Ccw) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCcw: TSFBool read FFdCcw;
    {  }
    property Ccw: Boolean read GetCcw write SetCcw;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsSweptSurfaceNode ----------------------------------------------- }

function TNurbsSweptSurfaceNode.GetCrossSectionCurve: TAbstractNurbsControlCurveNode;
begin
  if FdCrossSectionCurve.Value is TAbstractNurbsControlCurveNode then
    Result := TAbstractNurbsControlCurveNode(FdCrossSectionCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSweptSurfaceNode.SetCrossSectionCurve(const Value: TAbstractNurbsControlCurveNode);
begin
  FdCrossSectionCurve.Send(Value);
end;

function TNurbsSweptSurfaceNode.GetTrajectoryCurve: TNurbsCurveNode;
begin
  if FdTrajectoryCurve.Value is TNurbsCurveNode then
    Result := TNurbsCurveNode(FdTrajectoryCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSweptSurfaceNode.SetTrajectoryCurve(const Value: TNurbsCurveNode);
begin
  FdTrajectoryCurve.Send(Value);
end;

function TNurbsSweptSurfaceNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TNurbsSweptSurfaceNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

class function TNurbsSweptSurfaceNode.ClassX3DType: String;
begin
  Result := 'NurbsSweptSurface';
end;

procedure TNurbsSweptSurfaceNode.CreateNode;
begin
  inherited;

  FFdCrossSectionCurve := TSFNode.Create(Self, True, 'crossSectionCurve', [TAbstractNurbsControlCurveNode]);
   FdCrossSectionCurve.ChangeAlways := chGeometry;
  AddField(FFdCrossSectionCurve);

  FFdTrajectoryCurve := TSFNode.Create(Self, True, 'trajectoryCurve', [TNurbsCurveNode]);
   FdTrajectoryCurve.ChangeAlways := chGeometry;
  AddField(FFdTrajectoryCurve);

  FFdCcw := TSFBool.Create(Self, False, 'ccw', true);
   FdCcw.ChangeAlways := chGeometry;
  AddField(FFdCcw);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);
end;

{$endif read_implementation}
