#include <iostream>
using namespace std;
//code
struct Accepted
{
    int d_val = 10;
    void unchanged() const
    {
        cout << d_val << '\n';
    }
    void changed()              // OK: not used by Demo below
    {
        cout << ++d_val << '\n';
    }
};

struct Rejected
{
    mutable int d_val = 10;     // 'Rejected' can't be used by
                                // Demo because of 'mutable'
    void unchanged() const
    {
        cout << d_val << '\n';
    }
    void changed()              // OK: not used by Demo below
    {
        cout << ++d_val << '\n';
    }
};

template <auto val> struct Demo
{
    Demo()
    {
        val.unchanged();
    }
};

int main()
{
    Demo<Accepted{}> sa;
    // Demo<Rejected{}> sr;     // won't compile
}
//=
