dnl ---------------------------------------------------------------------------
dnl FP_GETARG_ENABLE
dnl
dnl Macro arguments:
dnl $1 = the name of the --enable feature
dnl $2 = the name of the variable associated
dnl $3 = the description of that feature
dnl $4 = the default value for that feature
dnl $5 = additional action to do in case option is given with "yes" value
dnl ---------------------------------------------------------------------------
AC_DEFUN([FP_GETARG_ENABLE],
         [AC_ARG_ENABLE($1,
            AC_HELP_STRING([--enable-$1], [$3 (default is $4)]),
            [], [enableval="$4"])

            if test "$enableval" = "no" || test "$enableval" = "disable" ; then
              dnl Show a message to the user about this option
                AC_MSG_CHECKING([for the --enable-$1 option])
                AC_MSG_RESULT([disable both install and uninstall])
                $2=no
                 AM_CONDITIONAL([AMINSTALL_$1], [false])
                 AM_CONDITIONAL([AMUNINSTALL_$1], [false])
            elif test "$enableval" = "install_only" ; then
                AC_MSG_CHECKING([for the --enable-$1 option])
                AC_MSG_RESULT([disable uninstall only])
                $2=install_only
                 AM_CONDITIONAL([AMINSTALL_$1], [true])
                 AM_CONDITIONAL([AMUNINSTALL_$1], [false])
            elif test "$enableval" = "uninstall_only" ; then
                AC_MSG_CHECKING([for the --enable-$1 option])
                AC_MSG_RESULT([disable install only])
                $2=uninstall_only
                 AM_CONDITIONAL([AMINSTALL_$1], [false])
                 AM_CONDITIONAL([AMUNINSTALL_$1], [true])
            else
              dnl Anything else is install both. No need to burble about it
                $2=yes
                 AM_CONDITIONAL([AMINSTALL_$1], [true])
                 AM_CONDITIONAL([AMUNINSTALL_$1], [true])
                $5
            fi
         ])

dnl ---------------------------------------------------------------------------
dnl FP_BZIP2_CHECK($BZIP2)
dnl Should we use the system bzip2 headers/lib or use our built-in versions
dnl The default is built-in but, e.g. for packaging, allow to use system ones
dnl ---------------------------------------------------------------------------
AC_DEFUN([FP_BZIP2_CHECK],
    [AC_ARG_WITH([builtin_bzip2],
                      AC_HELP_STRING([--with-builtin_bzip2, whether to use built-in support for bzip2 archive peeking (if no, requires the bzip2 headers to be installed)]),
                      [], [withval=yes]
                )

      AS_IF( [test "x$withval" = "xno"],
                 [  dnl We don't want tar.bz2 streaming to use our built-in bzip. Check that the system headers are available
                     AC_CHECK_HEADER([bzlib.h], [$1="-lbz2"],
                                    [AC_MSG_ERROR([the bzip2 headers are missing. You need to install them, or else configure --with-builtin_bzip2=yes])]
                                    )

                    AC_MSG_CHECKING([for --with-builtin_bzip2])
                    AC_MSG_RESULT([no])
                    AC_SUBST([BZIP2_FLAGS],[-DUSE_SYSTEM_BZIP2])
                    AM_CONDITIONAL([AMBUILTIN_BZIP], [false])
                 ],
                 [  AC_MSG_CHECKING([for --with-builtin_bzip2])
                    AC_MSG_RESULT([yes])
                    AM_CONDITIONAL([AMBUILTIN_BZIP], [true])
                    $1=""
                 ]

          )
    ])

dnl ---------------------------------------------------------------------------
dnl FP_LZMA_ARCHIVE_STREAMS($LIBLZMA)
dnl Building 4Pane will fail if liblzma-dev/xz-devel isn't installed unless you
dnl either pass -DNO_LZMA_ARCHIVE_STREAMS to 'make', or disable with this macro
dnl ---------------------------------------------------------------------------
AC_DEFUN([FP_LZMA_ARCHIVE_STREAMS],
    [AC_ARG_ENABLE([lzma_streams],
                      AC_HELP_STRING([--enable-lzma_streams, whether to build with support for xz archive peeking (if yes, requires the xz/lzma headers to be installed)]),
                      [], [enableval=yes]
                  )

      AS_IF( [test "x$enableval" != "xno" && test "x$enableval" != "xdisable"],
                 [  dnl We want xz archive streaming support. Check that it's available
                     AC_CHECK_HEADER([lzma.h], [$1="-llzma"],
                                    [AC_MSG_ERROR([the lzma headers are missing. You need to install them, or else configure --disable-lzma_streams])]
                                   )
                 ],
                 [  AC_MSG_CHECKING([for the --enable-lzma_streams option])
                    AC_MSG_RESULT([disable])
                    AC_SUBST([XZFLAGS],[-DNO_LZMA_ARCHIVE_STREAMS])
                    $1=""
                 ]
          )
    ])


dnl ---------------------------------------------------------------------------
dnl FP_CHECK_GTK_HEADERS
dnl Check that the gtk2 or 3 headers exist
dnl ---------------------------------------------------------------------------
AC_DEFUN([FP_CHECK_GTK_HEADERS],
  [
  dnl Try pkgconfig first
  AC_PATH_PROG(PKG_CONFIG, pkg-config, no) > /dev/null

  AS_IF([test x$PKG_CONFIG != xno],
        [if pkg-config --atleast-pkgconfig-version 0.7 ; then
          AS_IF([$PKG_CONFIG --exists gtk+-$1.0], [AC_MSG_CHECKING([for gtk$1 headers])
                                                   AC_MSG_RESULT([yes])
                                                   GTKPKG_CFLAGS=`$PKG_CONFIG --cflags gtk+-$1.0`
                                                   AC_SUBST([GTKPKG_CFLAGS])
                                                   GTKPKG_LDFLAGS=`$PKG_CONFIG --libs gtk+-$1.0`
                                                   AC_SUBST([GTKPKG_LDFLAGS])
                                                  ],
                [AC_MSG_ERROR([gtk headers not found. You probably need to install the devel package e.g. libgtk$1.0-dev])]
              )
        fi
        ],
        [AC_MSG_ERROR([pkgconfig is missing. Please install it])]
      )
  ])


dnl ---------------------------------------------------------------------------
dnl FP_CONTROL_ASSERTS
dnl Since wx3 wxAsserts are turned on by default even in release builds
dnl so turn them off here. NB must be _after_ the WX_STANDARD_OPTIONS call
dnl ---------------------------------------------------------------------------
AC_DEFUN([FP_CONTROL_ASSERTS],
  AS_IF( [echo "$CXXFLAGS" | grep -q "O0"],
            [ : ],
            [
              CFLAGS="$CFLAGS -DNDEBUG"
              CXXFLAGS="$CXXFLAGS -DNDEBUG"
            ]
      )
  )


dnl ---------------------------------------------------------------------------
dnl FP_DETECT_GETTEXT
dnl Ensure msgfmt, part of the gettext package, is installed
dnl ---------------------------------------------------------------------------
AC_DEFUN([FP_DETECT_GETTEXT],
  msgfmt=`which msgfmt`
  AS_IF( [test -f "$msgfmt"],
            [ AM_CONDITIONAL([AMMSGFMT_AVAILABLE], [true])
              AC_SUBST([MSGFMT],["$msgfmt"])
            ],
            [
              AM_CONDITIONAL([AMMSGFMT_AVAILABLE], [false])
              [AC_MSG_WARN([gettext not installed on your system so translations will not be compiled.])]
            ]
      )
  )
