// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/shared_criterion_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [SharedCriterionService.GetSharedCriterion][google.ads.googleads.v2.services.SharedCriterionService.GetSharedCriterion].
type GetSharedCriterionRequest struct {
	// Required. The resource name of the shared criterion to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSharedCriterionRequest) Reset()         { *m = GetSharedCriterionRequest{} }
func (m *GetSharedCriterionRequest) String() string { return proto.CompactTextString(m) }
func (*GetSharedCriterionRequest) ProtoMessage()    {}
func (*GetSharedCriterionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8972b6dd5d4dfeaa, []int{0}
}

func (m *GetSharedCriterionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSharedCriterionRequest.Unmarshal(m, b)
}
func (m *GetSharedCriterionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSharedCriterionRequest.Marshal(b, m, deterministic)
}
func (m *GetSharedCriterionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSharedCriterionRequest.Merge(m, src)
}
func (m *GetSharedCriterionRequest) XXX_Size() int {
	return xxx_messageInfo_GetSharedCriterionRequest.Size(m)
}
func (m *GetSharedCriterionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSharedCriterionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSharedCriterionRequest proto.InternalMessageInfo

func (m *GetSharedCriterionRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [SharedCriterionService.MutateSharedCriteria][google.ads.googleads.v2.services.SharedCriterionService.MutateSharedCriteria].
type MutateSharedCriteriaRequest struct {
	// Required. The ID of the customer whose shared criteria are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual shared criteria.
	Operations []*SharedCriterionOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateSharedCriteriaRequest) Reset()         { *m = MutateSharedCriteriaRequest{} }
func (m *MutateSharedCriteriaRequest) String() string { return proto.CompactTextString(m) }
func (*MutateSharedCriteriaRequest) ProtoMessage()    {}
func (*MutateSharedCriteriaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8972b6dd5d4dfeaa, []int{1}
}

func (m *MutateSharedCriteriaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedCriteriaRequest.Unmarshal(m, b)
}
func (m *MutateSharedCriteriaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedCriteriaRequest.Marshal(b, m, deterministic)
}
func (m *MutateSharedCriteriaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedCriteriaRequest.Merge(m, src)
}
func (m *MutateSharedCriteriaRequest) XXX_Size() int {
	return xxx_messageInfo_MutateSharedCriteriaRequest.Size(m)
}
func (m *MutateSharedCriteriaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedCriteriaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedCriteriaRequest proto.InternalMessageInfo

func (m *MutateSharedCriteriaRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateSharedCriteriaRequest) GetOperations() []*SharedCriterionOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateSharedCriteriaRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateSharedCriteriaRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, remove) on an shared criterion.
type SharedCriterionOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*SharedCriterionOperation_Create
	//	*SharedCriterionOperation_Remove
	Operation            isSharedCriterionOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *SharedCriterionOperation) Reset()         { *m = SharedCriterionOperation{} }
func (m *SharedCriterionOperation) String() string { return proto.CompactTextString(m) }
func (*SharedCriterionOperation) ProtoMessage()    {}
func (*SharedCriterionOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8972b6dd5d4dfeaa, []int{2}
}

func (m *SharedCriterionOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SharedCriterionOperation.Unmarshal(m, b)
}
func (m *SharedCriterionOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SharedCriterionOperation.Marshal(b, m, deterministic)
}
func (m *SharedCriterionOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SharedCriterionOperation.Merge(m, src)
}
func (m *SharedCriterionOperation) XXX_Size() int {
	return xxx_messageInfo_SharedCriterionOperation.Size(m)
}
func (m *SharedCriterionOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_SharedCriterionOperation.DiscardUnknown(m)
}

var xxx_messageInfo_SharedCriterionOperation proto.InternalMessageInfo

type isSharedCriterionOperation_Operation interface {
	isSharedCriterionOperation_Operation()
}

type SharedCriterionOperation_Create struct {
	Create *resources.SharedCriterion `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type SharedCriterionOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*SharedCriterionOperation_Create) isSharedCriterionOperation_Operation() {}

func (*SharedCriterionOperation_Remove) isSharedCriterionOperation_Operation() {}

func (m *SharedCriterionOperation) GetOperation() isSharedCriterionOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *SharedCriterionOperation) GetCreate() *resources.SharedCriterion {
	if x, ok := m.GetOperation().(*SharedCriterionOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *SharedCriterionOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*SharedCriterionOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SharedCriterionOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SharedCriterionOperation_Create)(nil),
		(*SharedCriterionOperation_Remove)(nil),
	}
}

// Response message for a shared criterion mutate.
type MutateSharedCriteriaResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateSharedCriterionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *MutateSharedCriteriaResponse) Reset()         { *m = MutateSharedCriteriaResponse{} }
func (m *MutateSharedCriteriaResponse) String() string { return proto.CompactTextString(m) }
func (*MutateSharedCriteriaResponse) ProtoMessage()    {}
func (*MutateSharedCriteriaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8972b6dd5d4dfeaa, []int{3}
}

func (m *MutateSharedCriteriaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedCriteriaResponse.Unmarshal(m, b)
}
func (m *MutateSharedCriteriaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedCriteriaResponse.Marshal(b, m, deterministic)
}
func (m *MutateSharedCriteriaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedCriteriaResponse.Merge(m, src)
}
func (m *MutateSharedCriteriaResponse) XXX_Size() int {
	return xxx_messageInfo_MutateSharedCriteriaResponse.Size(m)
}
func (m *MutateSharedCriteriaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedCriteriaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedCriteriaResponse proto.InternalMessageInfo

func (m *MutateSharedCriteriaResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateSharedCriteriaResponse) GetResults() []*MutateSharedCriterionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the shared criterion mutate.
type MutateSharedCriterionResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateSharedCriterionResult) Reset()         { *m = MutateSharedCriterionResult{} }
func (m *MutateSharedCriterionResult) String() string { return proto.CompactTextString(m) }
func (*MutateSharedCriterionResult) ProtoMessage()    {}
func (*MutateSharedCriterionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_8972b6dd5d4dfeaa, []int{4}
}

func (m *MutateSharedCriterionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedCriterionResult.Unmarshal(m, b)
}
func (m *MutateSharedCriterionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedCriterionResult.Marshal(b, m, deterministic)
}
func (m *MutateSharedCriterionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedCriterionResult.Merge(m, src)
}
func (m *MutateSharedCriterionResult) XXX_Size() int {
	return xxx_messageInfo_MutateSharedCriterionResult.Size(m)
}
func (m *MutateSharedCriterionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedCriterionResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedCriterionResult proto.InternalMessageInfo

func (m *MutateSharedCriterionResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetSharedCriterionRequest)(nil), "google.ads.googleads.v2.services.GetSharedCriterionRequest")
	proto.RegisterType((*MutateSharedCriteriaRequest)(nil), "google.ads.googleads.v2.services.MutateSharedCriteriaRequest")
	proto.RegisterType((*SharedCriterionOperation)(nil), "google.ads.googleads.v2.services.SharedCriterionOperation")
	proto.RegisterType((*MutateSharedCriteriaResponse)(nil), "google.ads.googleads.v2.services.MutateSharedCriteriaResponse")
	proto.RegisterType((*MutateSharedCriterionResult)(nil), "google.ads.googleads.v2.services.MutateSharedCriterionResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/shared_criterion_service.proto", fileDescriptor_8972b6dd5d4dfeaa)
}

var fileDescriptor_8972b6dd5d4dfeaa = []byte{
	// 731 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4d, 0x6b, 0xd4, 0x40,
	0x18, 0x36, 0x59, 0xa9, 0x76, 0xb6, 0x55, 0x18, 0xb5, 0xa6, 0xdb, 0x82, 0x4b, 0x2c, 0xb8, 0x2c,
	0x92, 0x94, 0xf4, 0x52, 0x52, 0xaa, 0x64, 0xc5, 0xb6, 0x82, 0xda, 0xb2, 0xc5, 0x16, 0x64, 0x21,
	0x4c, 0x93, 0xe9, 0x36, 0x90, 0x64, 0xe2, 0xcc, 0x64, 0xa1, 0x94, 0x5e, 0xfa, 0x07, 0x3c, 0xf8,
	0x0f, 0x3c, 0xfa, 0x27, 0xbc, 0xf7, 0xe2, 0xc1, 0x5b, 0x4f, 0x3d, 0x78, 0xf2, 0xe0, 0xc1, 0x93,
	0x78, 0x92, 0x7c, 0xcc, 0x7e, 0xc4, 0x2c, 0x0b, 0x7b, 0x7b, 0x33, 0xef, 0x33, 0xcf, 0xfb, 0xbc,
	0xf3, 0x7e, 0x04, 0x3c, 0xef, 0x12, 0xd2, 0xf5, 0xb1, 0x8e, 0x5c, 0xa6, 0x67, 0x66, 0x62, 0xf5,
	0x0c, 0x9d, 0x61, 0xda, 0xf3, 0x1c, 0xcc, 0x74, 0x76, 0x82, 0x28, 0x76, 0x6d, 0x87, 0x7a, 0x1c,
	0x53, 0x8f, 0x84, 0x76, 0xee, 0xd1, 0x22, 0x4a, 0x38, 0x81, 0xf5, 0xec, 0x96, 0x86, 0x5c, 0xa6,
	0xf5, 0x09, 0xb4, 0x9e, 0xa1, 0x09, 0x82, 0xda, 0xfa, 0xb8, 0x10, 0x14, 0x33, 0x12, 0xd3, 0xb2,
	0x18, 0x19, 0x77, 0x6d, 0x59, 0xdc, 0x8c, 0x3c, 0x1d, 0x85, 0x21, 0xe1, 0x88, 0x7b, 0x24, 0x64,
	0xb9, 0xf7, 0xe1, 0x90, 0xd7, 0xf1, 0x3d, 0x1c, 0xf2, 0xdc, 0xf1, 0x68, 0xc8, 0x71, 0xec, 0x61,
	0xdf, 0xb5, 0x8f, 0xf0, 0x09, 0xea, 0x79, 0x84, 0xe6, 0x80, 0xc5, 0x21, 0x80, 0x10, 0x51, 0x20,
	0xa5, 0x91, 0xa3, 0x33, 0x8e, 0x78, 0x9c, 0x47, 0x53, 0x29, 0x58, 0xdc, 0xc6, 0x7c, 0x3f, 0x15,
	0xfa, 0x42, 0xe8, 0x6c, 0xe3, 0x0f, 0x31, 0x66, 0x1c, 0xbe, 0x03, 0xf3, 0x82, 0xc7, 0x0e, 0x51,
	0x80, 0x15, 0xa9, 0x2e, 0x35, 0x66, 0x5b, 0xab, 0xd7, 0x96, 0xfc, 0xd7, 0x6a, 0x82, 0xc6, 0xe0,
	0x61, 0x72, 0x2b, 0xf2, 0x98, 0xe6, 0x90, 0x40, 0x2f, 0xf2, 0xcd, 0x09, 0x9a, 0xb7, 0x28, 0xc0,
	0xea, 0x6f, 0x09, 0x2c, 0xbd, 0x89, 0x39, 0xe2, 0x78, 0x04, 0x87, 0x44, 0xd8, 0x15, 0x50, 0x75,
	0x62, 0xc6, 0x49, 0x80, 0xa9, 0xed, 0xb9, 0x79, 0xd0, 0xca, 0xb5, 0x25, 0xb7, 0x81, 0x38, 0x7f,
	0xe5, 0x42, 0x1b, 0x00, 0x12, 0x61, 0x9a, 0xbd, 0x9d, 0x22, 0xd7, 0x2b, 0x8d, 0xaa, 0x61, 0x6a,
	0x93, 0xca, 0xa6, 0x15, 0xa4, 0xed, 0x0a, 0x8a, 0x3c, 0xc0, 0x80, 0x12, 0x3e, 0x01, 0x77, 0x23,
	0x44, 0xb9, 0x87, 0x7c, 0xfb, 0x18, 0x79, 0x7e, 0x4c, 0xb1, 0x52, 0xa9, 0x4b, 0x8d, 0xdb, 0xed,
	0x3b, 0xf9, 0xf1, 0x56, 0x76, 0x0a, 0x1f, 0x83, 0xf9, 0x1e, 0xf2, 0x3d, 0x17, 0x71, 0x6c, 0x93,
	0xd0, 0x3f, 0x55, 0x6e, 0xa6, 0xb0, 0x39, 0x71, 0xb8, 0x1b, 0xfa, 0xa7, 0xea, 0x47, 0x09, 0x28,
	0xe3, 0x62, 0xc3, 0xd7, 0x60, 0xc6, 0xa1, 0x18, 0xf1, 0xec, 0x85, 0xab, 0x86, 0x31, 0x36, 0x8f,
	0x7e, 0x73, 0x15, 0x13, 0xd9, 0xb9, 0xd1, 0xce, 0x39, 0xa0, 0x02, 0x66, 0x28, 0x0e, 0x48, 0x2f,
	0xd3, 0x3b, 0x9b, 0x78, 0xb2, 0xef, 0x56, 0x15, 0xcc, 0xf6, 0x13, 0x54, 0xbf, 0x4a, 0x60, 0xb9,
	0xbc, 0x0c, 0x2c, 0x22, 0x21, 0xc3, 0x70, 0x0b, 0x3c, 0x28, 0x3c, 0x80, 0x8d, 0x29, 0x25, 0x34,
	0xa5, 0xad, 0x1a, 0x50, 0x88, 0xa4, 0x91, 0xa3, 0xed, 0xa7, 0x4d, 0xd5, 0xbe, 0x37, 0xfa, 0x34,
	0x2f, 0x13, 0x38, 0x3c, 0x04, 0xb7, 0x28, 0x66, 0xb1, 0xcf, 0x45, 0x99, 0x36, 0x27, 0x97, 0xa9,
	0x44, 0x58, 0xd2, 0x97, 0x09, 0x4b, 0x5b, 0xb0, 0xa9, 0xad, 0xd2, 0x3e, 0x12, 0xb8, 0xa4, 0x2e,
	0x25, 0xed, 0x3b, 0xda, 0x8c, 0xc6, 0x9f, 0x0a, 0x58, 0x28, 0x5c, 0xdf, 0xcf, 0x44, 0xc0, 0x6f,
	0x12, 0x80, 0xff, 0x0f, 0x07, 0xdc, 0x98, 0xac, 0x7e, 0xec, 0x48, 0xd5, 0xa6, 0xa8, 0xac, 0xba,
	0x73, 0x65, 0x8d, 0x26, 0x72, 0xf1, 0xfd, 0xc7, 0x27, 0xd9, 0x80, 0xab, 0xc9, 0xb6, 0x39, 0x1b,
	0xf1, 0x6c, 0x8a, 0x01, 0x61, 0x7a, 0x33, 0x5f, 0x3f, 0xa2, 0xac, 0x7a, 0xf3, 0x1c, 0xfe, 0x92,
	0xc0, 0xfd, 0xb2, 0x92, 0xc3, 0xe9, 0x2a, 0x22, 0x26, 0xb6, 0xf6, 0x6c, 0xda, 0xeb, 0x59, 0xa7,
	0xa9, 0x87, 0x57, 0xd6, 0xc2, 0xd0, 0xc8, 0x3f, 0x1d, 0x4c, 0x61, 0x9a, 0xea, 0xba, 0xba, 0x96,
	0xa4, 0x3a, 0xc8, 0xed, 0x6c, 0x08, 0xbc, 0xd9, 0x3c, 0x2f, 0x64, 0x6a, 0x06, 0x69, 0x2c, 0x53,
	0x6a, 0xd6, 0x96, 0x2e, 0x2d, 0x65, 0xdc, 0x96, 0x6a, 0x5d, 0xc8, 0x60, 0xc5, 0x21, 0xc1, 0x44,
	0xed, 0xad, 0xa5, 0xf2, 0x06, 0xd9, 0x4b, 0x36, 0xe8, 0x9e, 0xf4, 0x7e, 0x27, 0x27, 0xe8, 0x12,
	0x1f, 0x85, 0x5d, 0x8d, 0xd0, 0xae, 0xde, 0xc5, 0x61, 0xba, 0x5f, 0xf5, 0x41, 0xc8, 0xf1, 0xff,
	0xa2, 0x0d, 0x61, 0x7c, 0x96, 0x2b, 0xdb, 0x96, 0xf5, 0x45, 0xae, 0x6f, 0x67, 0x84, 0x96, 0xcb,
	0xb4, 0xcc, 0x4c, 0xac, 0x03, 0x43, 0xcb, 0x03, 0xb3, 0x4b, 0x01, 0xe9, 0x58, 0x2e, 0xeb, 0xf4,
	0x21, 0x9d, 0x03, 0xa3, 0x23, 0x20, 0x3f, 0xe5, 0x95, 0xec, 0xdc, 0x34, 0x2d, 0x97, 0x99, 0x66,
	0x1f, 0x64, 0x9a, 0x07, 0x86, 0x69, 0x0a, 0xd8, 0xd1, 0x4c, 0xaa, 0x73, 0xed, 0x5f, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x3e, 0xf2, 0x9f, 0x5e, 0x32, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SharedCriterionServiceClient is the client API for SharedCriterionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SharedCriterionServiceClient interface {
	// Returns the requested shared criterion in full detail.
	GetSharedCriterion(ctx context.Context, in *GetSharedCriterionRequest, opts ...grpc.CallOption) (*resources.SharedCriterion, error)
	// Creates or removes shared criteria. Operation statuses are returned.
	MutateSharedCriteria(ctx context.Context, in *MutateSharedCriteriaRequest, opts ...grpc.CallOption) (*MutateSharedCriteriaResponse, error)
}

type sharedCriterionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSharedCriterionServiceClient(cc grpc.ClientConnInterface) SharedCriterionServiceClient {
	return &sharedCriterionServiceClient{cc}
}

func (c *sharedCriterionServiceClient) GetSharedCriterion(ctx context.Context, in *GetSharedCriterionRequest, opts ...grpc.CallOption) (*resources.SharedCriterion, error) {
	out := new(resources.SharedCriterion)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.SharedCriterionService/GetSharedCriterion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sharedCriterionServiceClient) MutateSharedCriteria(ctx context.Context, in *MutateSharedCriteriaRequest, opts ...grpc.CallOption) (*MutateSharedCriteriaResponse, error) {
	out := new(MutateSharedCriteriaResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.SharedCriterionService/MutateSharedCriteria", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SharedCriterionServiceServer is the server API for SharedCriterionService service.
type SharedCriterionServiceServer interface {
	// Returns the requested shared criterion in full detail.
	GetSharedCriterion(context.Context, *GetSharedCriterionRequest) (*resources.SharedCriterion, error)
	// Creates or removes shared criteria. Operation statuses are returned.
	MutateSharedCriteria(context.Context, *MutateSharedCriteriaRequest) (*MutateSharedCriteriaResponse, error)
}

// UnimplementedSharedCriterionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSharedCriterionServiceServer struct {
}

func (*UnimplementedSharedCriterionServiceServer) GetSharedCriterion(ctx context.Context, req *GetSharedCriterionRequest) (*resources.SharedCriterion, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSharedCriterion not implemented")
}
func (*UnimplementedSharedCriterionServiceServer) MutateSharedCriteria(ctx context.Context, req *MutateSharedCriteriaRequest) (*MutateSharedCriteriaResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateSharedCriteria not implemented")
}

func RegisterSharedCriterionServiceServer(s *grpc.Server, srv SharedCriterionServiceServer) {
	s.RegisterService(&_SharedCriterionService_serviceDesc, srv)
}

func _SharedCriterionService_GetSharedCriterion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSharedCriterionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SharedCriterionServiceServer).GetSharedCriterion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.SharedCriterionService/GetSharedCriterion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SharedCriterionServiceServer).GetSharedCriterion(ctx, req.(*GetSharedCriterionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SharedCriterionService_MutateSharedCriteria_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateSharedCriteriaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SharedCriterionServiceServer).MutateSharedCriteria(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.SharedCriterionService/MutateSharedCriteria",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SharedCriterionServiceServer).MutateSharedCriteria(ctx, req.(*MutateSharedCriteriaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SharedCriterionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.SharedCriterionService",
	HandlerType: (*SharedCriterionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSharedCriterion",
			Handler:    _SharedCriterionService_GetSharedCriterion_Handler,
		},
		{
			MethodName: "MutateSharedCriteria",
			Handler:    _SharedCriterionService_MutateSharedCriteria_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/shared_criterion_service.proto",
}
