// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/docker/swarmkit/api/specs.proto

package api

import (
	fmt "fmt"
	github_com_docker_swarmkit_api_deepcopy "github.com/docker/swarmkit/api/deepcopy"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type NodeSpec_Membership int32

const (
	NodeMembershipPending  NodeSpec_Membership = 0
	NodeMembershipAccepted NodeSpec_Membership = 1
)

var NodeSpec_Membership_name = map[int32]string{
	0: "PENDING",
	1: "ACCEPTED",
}

var NodeSpec_Membership_value = map[string]int32{
	"PENDING":  0,
	"ACCEPTED": 1,
}

func (x NodeSpec_Membership) String() string {
	return proto.EnumName(NodeSpec_Membership_name, int32(x))
}

func (NodeSpec_Membership) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{0, 0}
}

type NodeSpec_Availability int32

const (
	// Active nodes.
	NodeAvailabilityActive NodeSpec_Availability = 0
	// Paused nodes won't be considered by the scheduler, preventing any
	// further task to run on them.
	NodeAvailabilityPause NodeSpec_Availability = 1
	// Drained nodes are paused and any task already running on them will
	// be evicted.
	NodeAvailabilityDrain NodeSpec_Availability = 2
)

var NodeSpec_Availability_name = map[int32]string{
	0: "ACTIVE",
	1: "PAUSE",
	2: "DRAIN",
}

var NodeSpec_Availability_value = map[string]int32{
	"ACTIVE": 0,
	"PAUSE":  1,
	"DRAIN":  2,
}

func (x NodeSpec_Availability) String() string {
	return proto.EnumName(NodeSpec_Availability_name, int32(x))
}

func (NodeSpec_Availability) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{0, 1}
}

type ContainerSpec_Isolation int32

const (
	// ISOLATION_DEFAULT uses whatever default value from the container runtime
	ContainerIsolationDefault ContainerSpec_Isolation = 0
	// ISOLATION_PROCESS forces windows container isolation
	ContainerIsolationProcess ContainerSpec_Isolation = 1
	// ISOLATION_HYPERV forces Hyper-V isolation
	ContainerIsolationHyperV ContainerSpec_Isolation = 2
)

var ContainerSpec_Isolation_name = map[int32]string{
	0: "ISOLATION_DEFAULT",
	1: "ISOLATION_PROCESS",
	2: "ISOLATION_HYPERV",
}

var ContainerSpec_Isolation_value = map[string]int32{
	"ISOLATION_DEFAULT": 0,
	"ISOLATION_PROCESS": 1,
	"ISOLATION_HYPERV":  2,
}

func (x ContainerSpec_Isolation) String() string {
	return proto.EnumName(ContainerSpec_Isolation_name, int32(x))
}

func (ContainerSpec_Isolation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{10, 0}
}

// ResolutionMode specifies the mode of resolution to use for
// internal loadbalancing between tasks which are all within
// the cluster. This is sometimes calls east-west data path.
type EndpointSpec_ResolutionMode int32

const (
	// VIP resolution mode specifies that the
	// service resolves to a logical IP and the requests
	// are sent to that logical IP. Packets hitting that
	// logical IP are load balanced to a chosen backend.
	ResolutionModeVirtualIP EndpointSpec_ResolutionMode = 0
	// DNSRR resolution mode specifies that the
	// service directly gets resolved to one of the
	// backend IP and the client directly initiates a
	// request towards the actual backend. This requires
	// that the client does not cache the DNS responses
	// when the DNS response TTL is 0.
	ResolutionModeDNSRoundRobin EndpointSpec_ResolutionMode = 1
)

var EndpointSpec_ResolutionMode_name = map[int32]string{
	0: "VIP",
	1: "DNSRR",
}

var EndpointSpec_ResolutionMode_value = map[string]int32{
	"VIP":   0,
	"DNSRR": 1,
}

func (x EndpointSpec_ResolutionMode) String() string {
	return proto.EnumName(EndpointSpec_ResolutionMode_name, int32(x))
}

func (EndpointSpec_ResolutionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{11, 0}
}

type NodeSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations"`
	// DesiredRole defines the role the node should have.
	DesiredRole NodeRole `protobuf:"varint,2,opt,name=desired_role,json=desiredRole,proto3,enum=docker.swarmkit.v1.NodeRole" json:"desired_role,omitempty"`
	// Membership controls the admission of the node into the cluster.
	Membership NodeSpec_Membership `protobuf:"varint,3,opt,name=membership,proto3,enum=docker.swarmkit.v1.NodeSpec_Membership" json:"membership,omitempty"`
	// Availability allows a user to control the current scheduling status of a
	// node.
	Availability NodeSpec_Availability `protobuf:"varint,4,opt,name=availability,proto3,enum=docker.swarmkit.v1.NodeSpec_Availability" json:"availability,omitempty"`
}

func (m *NodeSpec) Reset()      { *m = NodeSpec{} }
func (*NodeSpec) ProtoMessage() {}
func (*NodeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{0}
}
func (m *NodeSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSpec.Merge(m, src)
}
func (m *NodeSpec) XXX_Size() int {
	return m.Size()
}
func (m *NodeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSpec proto.InternalMessageInfo

// ServiceSpec defines the properties of a service.
//
// A service instructs the cluster in orchestrating repeated instances of a
// template, implemented as tasks. Based on the number of instances, scheduling
// strategy and restart policy, a number of application-level behaviors can be
// defined.
type ServiceSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations"`
	// Task defines the task template this service will spawn.
	Task TaskSpec `protobuf:"bytes,2,opt,name=task,proto3" json:"task"`
	// Types that are valid to be assigned to Mode:
	//	*ServiceSpec_Replicated
	//	*ServiceSpec_Global
	//	*ServiceSpec_ReplicatedJob
	//	*ServiceSpec_GlobalJob
	Mode isServiceSpec_Mode `protobuf_oneof:"mode"`
	// Update contains settings which affect updates.
	Update *UpdateConfig `protobuf:"bytes,6,opt,name=update,proto3" json:"update,omitempty"`
	// Rollback contains settings which affect rollbacks of updates.
	Rollback *UpdateConfig `protobuf:"bytes,9,opt,name=rollback,proto3" json:"rollback,omitempty"`
	// ServiceSpec.Networks has been deprecated and is replaced by
	// Networks field in Task (TaskSpec.Networks).
	// This field (ServiceSpec.Networks) is kept for compatibility.
	// In case TaskSpec.Networks does not exist, ServiceSpec.Networks
	// is still honored if it exists.
	Networks []*NetworkAttachmentConfig `protobuf:"bytes,7,rep,name=networks,proto3" json:"networks,omitempty"` // Deprecated: Do not use.
	// Service endpoint specifies the user provided configuration
	// to properly discover and load balance a service.
	Endpoint *EndpointSpec `protobuf:"bytes,8,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (m *ServiceSpec) Reset()      { *m = ServiceSpec{} }
func (*ServiceSpec) ProtoMessage() {}
func (*ServiceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{1}
}
func (m *ServiceSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceSpec.Merge(m, src)
}
func (m *ServiceSpec) XXX_Size() int {
	return m.Size()
}
func (m *ServiceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceSpec proto.InternalMessageInfo

type isServiceSpec_Mode interface {
	isServiceSpec_Mode()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ServiceSpec_Replicated struct {
	Replicated *ReplicatedService `protobuf:"bytes,3,opt,name=replicated,proto3,oneof"`
}
type ServiceSpec_Global struct {
	Global *GlobalService `protobuf:"bytes,4,opt,name=global,proto3,oneof"`
}
type ServiceSpec_ReplicatedJob struct {
	ReplicatedJob *ReplicatedJob `protobuf:"bytes,10,opt,name=replicated_job,json=replicatedJob,proto3,oneof"`
}
type ServiceSpec_GlobalJob struct {
	GlobalJob *GlobalJob `protobuf:"bytes,11,opt,name=global_job,json=globalJob,proto3,oneof"`
}

func (*ServiceSpec_Replicated) isServiceSpec_Mode()    {}
func (*ServiceSpec_Global) isServiceSpec_Mode()        {}
func (*ServiceSpec_ReplicatedJob) isServiceSpec_Mode() {}
func (*ServiceSpec_GlobalJob) isServiceSpec_Mode()     {}

func (m *ServiceSpec) GetMode() isServiceSpec_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (m *ServiceSpec) GetReplicated() *ReplicatedService {
	if x, ok := m.GetMode().(*ServiceSpec_Replicated); ok {
		return x.Replicated
	}
	return nil
}

func (m *ServiceSpec) GetGlobal() *GlobalService {
	if x, ok := m.GetMode().(*ServiceSpec_Global); ok {
		return x.Global
	}
	return nil
}

func (m *ServiceSpec) GetReplicatedJob() *ReplicatedJob {
	if x, ok := m.GetMode().(*ServiceSpec_ReplicatedJob); ok {
		return x.ReplicatedJob
	}
	return nil
}

func (m *ServiceSpec) GetGlobalJob() *GlobalJob {
	if x, ok := m.GetMode().(*ServiceSpec_GlobalJob); ok {
		return x.GlobalJob
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ServiceSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ServiceSpec_OneofMarshaler, _ServiceSpec_OneofUnmarshaler, _ServiceSpec_OneofSizer, []interface{}{
		(*ServiceSpec_Replicated)(nil),
		(*ServiceSpec_Global)(nil),
		(*ServiceSpec_ReplicatedJob)(nil),
		(*ServiceSpec_GlobalJob)(nil),
	}
}

func _ServiceSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ServiceSpec)
	// mode
	switch x := m.Mode.(type) {
	case *ServiceSpec_Replicated:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Replicated); err != nil {
			return err
		}
	case *ServiceSpec_Global:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Global); err != nil {
			return err
		}
	case *ServiceSpec_ReplicatedJob:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReplicatedJob); err != nil {
			return err
		}
	case *ServiceSpec_GlobalJob:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GlobalJob); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ServiceSpec.Mode has unexpected type %T", x)
	}
	return nil
}

func _ServiceSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ServiceSpec)
	switch tag {
	case 3: // mode.replicated
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReplicatedService)
		err := b.DecodeMessage(msg)
		m.Mode = &ServiceSpec_Replicated{msg}
		return true, err
	case 4: // mode.global
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GlobalService)
		err := b.DecodeMessage(msg)
		m.Mode = &ServiceSpec_Global{msg}
		return true, err
	case 10: // mode.replicated_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReplicatedJob)
		err := b.DecodeMessage(msg)
		m.Mode = &ServiceSpec_ReplicatedJob{msg}
		return true, err
	case 11: // mode.global_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GlobalJob)
		err := b.DecodeMessage(msg)
		m.Mode = &ServiceSpec_GlobalJob{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ServiceSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ServiceSpec)
	// mode
	switch x := m.Mode.(type) {
	case *ServiceSpec_Replicated:
		s := proto.Size(x.Replicated)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ServiceSpec_Global:
		s := proto.Size(x.Global)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ServiceSpec_ReplicatedJob:
		s := proto.Size(x.ReplicatedJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ServiceSpec_GlobalJob:
		s := proto.Size(x.GlobalJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ReplicatedService sets the reconciliation target to certain number of replicas.
type ReplicatedService struct {
	Replicas uint64 `protobuf:"varint,1,opt,name=replicas,proto3" json:"replicas,omitempty"`
}

func (m *ReplicatedService) Reset()      { *m = ReplicatedService{} }
func (*ReplicatedService) ProtoMessage() {}
func (*ReplicatedService) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{2}
}
func (m *ReplicatedService) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicatedService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicatedService.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicatedService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicatedService.Merge(m, src)
}
func (m *ReplicatedService) XXX_Size() int {
	return m.Size()
}
func (m *ReplicatedService) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicatedService.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicatedService proto.InternalMessageInfo

// GlobalService represents global service.
type GlobalService struct {
}

func (m *GlobalService) Reset()      { *m = GlobalService{} }
func (*GlobalService) ProtoMessage() {}
func (*GlobalService) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{3}
}
func (m *GlobalService) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GlobalService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GlobalService.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GlobalService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlobalService.Merge(m, src)
}
func (m *GlobalService) XXX_Size() int {
	return m.Size()
}
func (m *GlobalService) XXX_DiscardUnknown() {
	xxx_messageInfo_GlobalService.DiscardUnknown(m)
}

var xxx_messageInfo_GlobalService proto.InternalMessageInfo

// ReplicatedJob is a certain type of one-off job which executes many Tasks in
// parallel until the specified number of Tasks have succeeded.
type ReplicatedJob struct {
	// MaxConcurrent indicates the maximum number of Tasks that should be
	// executing simultaneously at any given time.
	MaxConcurrent uint64 `protobuf:"varint,1,opt,name=max_concurrent,json=maxConcurrent,proto3" json:"max_concurrent,omitempty"`
	// TotalCompletions sets the total number of Tasks desired to run to
	// completion. This is also the absolute maximum number of Tasks that will
	// be executed in parallel. That is, if this number is smaller than
	// MaxConcurrent, only this many replicas will run.
	TotalCompletions uint64 `protobuf:"varint,2,opt,name=total_completions,json=totalCompletions,proto3" json:"total_completions,omitempty"`
}

func (m *ReplicatedJob) Reset()      { *m = ReplicatedJob{} }
func (*ReplicatedJob) ProtoMessage() {}
func (*ReplicatedJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{4}
}
func (m *ReplicatedJob) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicatedJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicatedJob.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicatedJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicatedJob.Merge(m, src)
}
func (m *ReplicatedJob) XXX_Size() int {
	return m.Size()
}
func (m *ReplicatedJob) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicatedJob.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicatedJob proto.InternalMessageInfo

// GlobalJob is a type of one-off job which executes one Task on every node
// matching the service's placement constraints.
type GlobalJob struct {
}

func (m *GlobalJob) Reset()      { *m = GlobalJob{} }
func (*GlobalJob) ProtoMessage() {}
func (*GlobalJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{5}
}
func (m *GlobalJob) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GlobalJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GlobalJob.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GlobalJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlobalJob.Merge(m, src)
}
func (m *GlobalJob) XXX_Size() int {
	return m.Size()
}
func (m *GlobalJob) XXX_DiscardUnknown() {
	xxx_messageInfo_GlobalJob.DiscardUnknown(m)
}

var xxx_messageInfo_GlobalJob proto.InternalMessageInfo

type TaskSpec struct {
	// Types that are valid to be assigned to Runtime:
	//	*TaskSpec_Attachment
	//	*TaskSpec_Container
	//	*TaskSpec_Generic
	Runtime isTaskSpec_Runtime `protobuf_oneof:"runtime"`
	// Resource requirements for the container.
	Resources *ResourceRequirements `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// RestartPolicy specifies what to do when a task fails or finishes.
	Restart *RestartPolicy `protobuf:"bytes,4,opt,name=restart,proto3" json:"restart,omitempty"`
	// Placement specifies node selection constraints
	Placement *Placement `protobuf:"bytes,5,opt,name=placement,proto3" json:"placement,omitempty"`
	// LogDriver specifies the log driver to use for the task. Any runtime will
	// direct logs into the specified driver for the duration of the task.
	LogDriver *Driver `protobuf:"bytes,6,opt,name=log_driver,json=logDriver,proto3" json:"log_driver,omitempty"`
	// Networks specifies the list of network attachment
	// configurations (which specify the network and per-network
	// aliases) that this task spec is bound to.
	Networks []*NetworkAttachmentConfig `protobuf:"bytes,7,rep,name=networks,proto3" json:"networks,omitempty"`
	// ForceUpdate is a counter that triggers an update even if no relevant
	// parameters have been changed. We do this to allow forced restarts
	// using the same reconciliation-based mechanism that performs rolling
	// updates.
	ForceUpdate uint64 `protobuf:"varint,9,opt,name=force_update,json=forceUpdate,proto3" json:"force_update,omitempty"`
	// ResourceReferences provides a generic way to specify resources that
	// are used by this task, and should be sent down to agents along with
	// the task. Inside the runtime field there may be more specific
	// information about how to use the resource, but ResourceReferences
	// establishes the relationship at the store level, and instructs the
	// dispatcher to send the related objects.
	//
	// ResourceReferences is a list of ResourceReferences used by the task.
	ResourceReferences []ResourceReference `protobuf:"bytes,11,rep,name=resource_references,json=resourceReferences,proto3" json:"resource_references"`
}

func (m *TaskSpec) Reset()      { *m = TaskSpec{} }
func (*TaskSpec) ProtoMessage() {}
func (*TaskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{6}
}
func (m *TaskSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TaskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TaskSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TaskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TaskSpec.Merge(m, src)
}
func (m *TaskSpec) XXX_Size() int {
	return m.Size()
}
func (m *TaskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TaskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TaskSpec proto.InternalMessageInfo

type isTaskSpec_Runtime interface {
	isTaskSpec_Runtime()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TaskSpec_Attachment struct {
	Attachment *NetworkAttachmentSpec `protobuf:"bytes,8,opt,name=attachment,proto3,oneof"`
}
type TaskSpec_Container struct {
	Container *ContainerSpec `protobuf:"bytes,1,opt,name=container,proto3,oneof"`
}
type TaskSpec_Generic struct {
	Generic *GenericRuntimeSpec `protobuf:"bytes,10,opt,name=generic,proto3,oneof"`
}

func (*TaskSpec_Attachment) isTaskSpec_Runtime() {}
func (*TaskSpec_Container) isTaskSpec_Runtime()  {}
func (*TaskSpec_Generic) isTaskSpec_Runtime()    {}

func (m *TaskSpec) GetRuntime() isTaskSpec_Runtime {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (m *TaskSpec) GetAttachment() *NetworkAttachmentSpec {
	if x, ok := m.GetRuntime().(*TaskSpec_Attachment); ok {
		return x.Attachment
	}
	return nil
}

func (m *TaskSpec) GetContainer() *ContainerSpec {
	if x, ok := m.GetRuntime().(*TaskSpec_Container); ok {
		return x.Container
	}
	return nil
}

func (m *TaskSpec) GetGeneric() *GenericRuntimeSpec {
	if x, ok := m.GetRuntime().(*TaskSpec_Generic); ok {
		return x.Generic
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TaskSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TaskSpec_OneofMarshaler, _TaskSpec_OneofUnmarshaler, _TaskSpec_OneofSizer, []interface{}{
		(*TaskSpec_Attachment)(nil),
		(*TaskSpec_Container)(nil),
		(*TaskSpec_Generic)(nil),
	}
}

func _TaskSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TaskSpec)
	// runtime
	switch x := m.Runtime.(type) {
	case *TaskSpec_Attachment:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Attachment); err != nil {
			return err
		}
	case *TaskSpec_Container:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Container); err != nil {
			return err
		}
	case *TaskSpec_Generic:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Generic); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TaskSpec.Runtime has unexpected type %T", x)
	}
	return nil
}

func _TaskSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TaskSpec)
	switch tag {
	case 8: // runtime.attachment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NetworkAttachmentSpec)
		err := b.DecodeMessage(msg)
		m.Runtime = &TaskSpec_Attachment{msg}
		return true, err
	case 1: // runtime.container
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ContainerSpec)
		err := b.DecodeMessage(msg)
		m.Runtime = &TaskSpec_Container{msg}
		return true, err
	case 10: // runtime.generic
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GenericRuntimeSpec)
		err := b.DecodeMessage(msg)
		m.Runtime = &TaskSpec_Generic{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TaskSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TaskSpec)
	// runtime
	switch x := m.Runtime.(type) {
	case *TaskSpec_Attachment:
		s := proto.Size(x.Attachment)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TaskSpec_Container:
		s := proto.Size(x.Container)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TaskSpec_Generic:
		s := proto.Size(x.Generic)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ResourceReference struct {
	ResourceID   string       `protobuf:"bytes,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	ResourceType ResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=docker.swarmkit.v1.ResourceType" json:"resource_type,omitempty"`
}

func (m *ResourceReference) Reset()      { *m = ResourceReference{} }
func (*ResourceReference) ProtoMessage() {}
func (*ResourceReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{7}
}
func (m *ResourceReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceReference.Merge(m, src)
}
func (m *ResourceReference) XXX_Size() int {
	return m.Size()
}
func (m *ResourceReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceReference.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceReference proto.InternalMessageInfo

type GenericRuntimeSpec struct {
	Kind    string     `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Payload *types.Any `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (m *GenericRuntimeSpec) Reset()      { *m = GenericRuntimeSpec{} }
func (*GenericRuntimeSpec) ProtoMessage() {}
func (*GenericRuntimeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{8}
}
func (m *GenericRuntimeSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GenericRuntimeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GenericRuntimeSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GenericRuntimeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenericRuntimeSpec.Merge(m, src)
}
func (m *GenericRuntimeSpec) XXX_Size() int {
	return m.Size()
}
func (m *GenericRuntimeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_GenericRuntimeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_GenericRuntimeSpec proto.InternalMessageInfo

// NetworkAttachmentSpec specifies runtime parameters required to attach
// a container to a network.
type NetworkAttachmentSpec struct {
	// ContainerID specifies a unique ID of the container for which
	// this attachment is for.
	ContainerID string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
}

func (m *NetworkAttachmentSpec) Reset()      { *m = NetworkAttachmentSpec{} }
func (*NetworkAttachmentSpec) ProtoMessage() {}
func (*NetworkAttachmentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{9}
}
func (m *NetworkAttachmentSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkAttachmentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkAttachmentSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkAttachmentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkAttachmentSpec.Merge(m, src)
}
func (m *NetworkAttachmentSpec) XXX_Size() int {
	return m.Size()
}
func (m *NetworkAttachmentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkAttachmentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkAttachmentSpec proto.InternalMessageInfo

// Container specifies runtime parameters for a container.
type ContainerSpec struct {
	// image defines the image reference, as specified in the
	// distribution/reference package. This may include a registry host, name,
	// tag or digest.
	//
	// The field will be directly passed to the engine pulling. Well-behaved
	// service definitions will used immutable references, either through tags
	// that don't change or verifiable digests.
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Labels defines labels to be added to the container at creation time. If
	// collisions with system labels occur, these labels will be overridden.
	//
	// This field *must* remain compatible with the Labels field of
	// Annotations.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Command to run the the container. The first element is a path to the
	// executable and the following elements are treated as arguments.
	//
	// If command is empty, execution will fall back to the image's entrypoint.
	//
	// Command should only be used when overriding entrypoint.
	Command []string `protobuf:"bytes,3,rep,name=command,proto3" json:"command,omitempty"`
	// Args specifies arguments provided to the image's entrypoint.
	//
	// If Command and Args are provided, Args will be appended to Command.
	Args []string `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	// Hostname specifies the hostname that will be set on containers created by docker swarm.
	// All containers for a given service will have the same hostname
	Hostname string `protobuf:"bytes,14,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Env specifies the environment variables for the container in NAME=VALUE
	// format. These must be compliant with  [IEEE Std
	// 1003.1-2001](http://pubs.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap08.html).
	Env []string `protobuf:"bytes,5,rep,name=env,proto3" json:"env,omitempty"`
	// Dir defines the working directory to set for the container process.
	Dir string `protobuf:"bytes,6,opt,name=dir,proto3" json:"dir,omitempty"`
	// User specifies the user that should be employed to run the container.
	//
	// Note that the primary group may be specified by appending the group name
	// or id to the user name, separated by a `:`. This syntax is
	// `<user>:<group>`.
	User string `protobuf:"bytes,7,opt,name=user,proto3" json:"user,omitempty"`
	// Groups specifies supplementary groups available to the user.
	Groups []string `protobuf:"bytes,11,rep,name=groups,proto3" json:"groups,omitempty"`
	// Privileges specifies security configuration/permissions.
	Privileges *Privileges `protobuf:"bytes,22,opt,name=privileges,proto3" json:"privileges,omitempty"`
	// Init declares that a custom init will be running inside the container, if null, use the daemon's configured settings
	Init *types.BoolValue `protobuf:"bytes,23,opt,name=init,proto3" json:"init,omitempty"`
	// TTY declares that a TTY should be attached to the standard streams,
	// including stdin if it is still open.
	TTY bool `protobuf:"varint,13,opt,name=tty,proto3" json:"tty,omitempty"`
	// OpenStdin declares that the standard input (stdin) should be open.
	OpenStdin bool `protobuf:"varint,18,opt,name=open_stdin,json=openStdin,proto3" json:"open_stdin,omitempty"`
	// ReadOnly declares that the container root filesystem is read-only.
	// This only impacts the root filesystem, not additional mounts (including
	// tmpfs). For additional mounts that are not part of the initial rootfs,
	// they will be decided by the modes passed in the mount definition.
	ReadOnly bool `protobuf:"varint,19,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// StopSignal defines the signal to stop the container.
	StopSignal string  `protobuf:"bytes,20,opt,name=stop_signal,json=stopSignal,proto3" json:"stop_signal,omitempty"`
	Mounts     []Mount `protobuf:"bytes,8,rep,name=mounts,proto3" json:"mounts"`
	// StopGracePeriod the grace period for stopping the container before
	// forcefully killing the container.
	// Note: Can't use stdduration here because this needs to be nullable.
	StopGracePeriod *types.Duration `protobuf:"bytes,9,opt,name=stop_grace_period,json=stopGracePeriod,proto3" json:"stop_grace_period,omitempty"`
	// PullOptions parameterize the behavior of image pulls.
	PullOptions *ContainerSpec_PullOptions `protobuf:"bytes,10,opt,name=pull_options,json=pullOptions,proto3" json:"pull_options,omitempty"`
	// SecretReference contains references to zero or more secrets that
	// will be exposed to the container.
	Secrets []*SecretReference `protobuf:"bytes,12,rep,name=secrets,proto3" json:"secrets,omitempty"`
	// ConfigReference contains references to zero or more configs that
	// will be exposed to the container.
	Configs []*ConfigReference `protobuf:"bytes,21,rep,name=configs,proto3" json:"configs,omitempty"`
	// Hosts allow additional entries to be specified in /etc/hosts
	// that associates IP addresses with hostnames.
	// Detailed documentation is available in:
	// http://man7.org/linux/man-pages/man5/hosts.5.html
	//   IP_address canonical_hostname [aliases...]
	//
	// The format of the Hosts in swarmkit follows the same as
	// above.
	// This is different from `docker run --add-host <hostname>:<ip>`
	// where format is `<hostname>:<ip>`
	Hosts []string `protobuf:"bytes,17,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// DNSConfig allows one to specify DNS related configuration in resolv.conf
	DNSConfig *ContainerSpec_DNSConfig `protobuf:"bytes,15,opt,name=dns_config,json=dnsConfig,proto3" json:"dns_config,omitempty"`
	// Healthcheck describes how to check the container is healthy. If the
	// container is considered unhealthy, it will be destroyed, its creating
	// task will exit and a new task will be rescheduled elsewhere. A container
	// is considered unhealthy after `Retries` number of consecutive failures.
	Healthcheck *HealthConfig `protobuf:"bytes,16,opt,name=healthcheck,proto3" json:"healthcheck,omitempty"`
	// Isolation defines the isolation level for windows containers (default, process, hyperv).
	// Runtimes that don't support it ignore that field
	Isolation ContainerSpec_Isolation `protobuf:"varint,24,opt,name=isolation,proto3,enum=docker.swarmkit.v1.ContainerSpec_Isolation" json:"isolation,omitempty"`
	// PidsLimit prevents from OS resource damage by applications inside the container
	// using fork bomb attack.
	PidsLimit int64 `protobuf:"varint,25,opt,name=pidsLimit,proto3" json:"pidsLimit,omitempty"`
	// Sysctls sets namespaced kernel parameters (sysctls) in the container. This
	// option is equivalent to passing --sysctl to docker run.
	//
	// Note that while options are subject to the same restrictions as arguments
	// passed to the --sysctl flag on docker run, those options are not further
	// validated to ensure that they are safe or sensible in a clustered
	// environment.
	//
	// Additionally, sysctls are not validated for support in the underlying
	// daemon. For information about supported options, refer to the
	// documentation at:
	//
	// https://docs.docker.com/engine/reference/commandline/run/#configure-namespaced-kernel-parameters-sysctls-at-runtime
	Sysctls map[string]string `protobuf:"bytes,26,rep,name=sysctls,proto3" json:"sysctls,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// CapabilityAdd sets the list of capabilities to add to the default capability list
	CapabilityAdd []string `protobuf:"bytes,27,rep,name=capability_add,json=capabilityAdd,proto3" json:"capability_add,omitempty"`
	// CapabilityDrop sets the list of capabilities to drop from the default capability list
	CapabilityDrop []string `protobuf:"bytes,28,rep,name=capability_drop,json=capabilityDrop,proto3" json:"capability_drop,omitempty"`
	// Ulimits defines the list of ulimits to set in the container. This option
	// is equivalent to passing --ulimit to docker run.
	Ulimits []*ContainerSpec_Ulimit `protobuf:"bytes,29,rep,name=ulimits,proto3" json:"ulimits,omitempty"`
}

func (m *ContainerSpec) Reset()      { *m = ContainerSpec{} }
func (*ContainerSpec) ProtoMessage() {}
func (*ContainerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{10}
}
func (m *ContainerSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerSpec.Merge(m, src)
}
func (m *ContainerSpec) XXX_Size() int {
	return m.Size()
}
func (m *ContainerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerSpec proto.InternalMessageInfo

// PullOptions allows one to parameterize an image pull.
type ContainerSpec_PullOptions struct {
	// RegistryAuth is the registry auth token obtained from the client, required
	// to pull private images. This is the unmodified JSON used as part of
	// the `X-Registry-Auth` header.
	// TODO(nishanttotla): This field will later be deprecated
	RegistryAuth string `protobuf:"bytes,64,opt,name=registry_auth,json=registryAuth,proto3" json:"registry_auth,omitempty"`
}

func (m *ContainerSpec_PullOptions) Reset()      { *m = ContainerSpec_PullOptions{} }
func (*ContainerSpec_PullOptions) ProtoMessage() {}
func (*ContainerSpec_PullOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{10, 1}
}
func (m *ContainerSpec_PullOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerSpec_PullOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerSpec_PullOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerSpec_PullOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerSpec_PullOptions.Merge(m, src)
}
func (m *ContainerSpec_PullOptions) XXX_Size() int {
	return m.Size()
}
func (m *ContainerSpec_PullOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerSpec_PullOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerSpec_PullOptions proto.InternalMessageInfo

// DNSConfig specifies DNS related configurations in resolver configuration file (resolv.conf)
// Detailed documentation is available in:
// http://man7.org/linux/man-pages/man5/resolv.conf.5.html
// TODO: domain is not supported yet
type ContainerSpec_DNSConfig struct {
	// Nameservers specifies the IP addresses of the name servers
	Nameservers []string `protobuf:"bytes,1,rep,name=nameservers,proto3" json:"nameservers,omitempty"`
	// Search specifies the search list for host-name lookup
	Search []string `protobuf:"bytes,2,rep,name=search,proto3" json:"search,omitempty"`
	// Options allows certain internal resolver variables to be modified
	Options []string `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
}

func (m *ContainerSpec_DNSConfig) Reset()      { *m = ContainerSpec_DNSConfig{} }
func (*ContainerSpec_DNSConfig) ProtoMessage() {}
func (*ContainerSpec_DNSConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{10, 2}
}
func (m *ContainerSpec_DNSConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerSpec_DNSConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerSpec_DNSConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerSpec_DNSConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerSpec_DNSConfig.Merge(m, src)
}
func (m *ContainerSpec_DNSConfig) XXX_Size() int {
	return m.Size()
}
func (m *ContainerSpec_DNSConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerSpec_DNSConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerSpec_DNSConfig proto.InternalMessageInfo

type ContainerSpec_Ulimit struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Soft int64  `protobuf:"varint,2,opt,name=soft,proto3" json:"soft,omitempty"`
	Hard int64  `protobuf:"varint,3,opt,name=hard,proto3" json:"hard,omitempty"`
}

func (m *ContainerSpec_Ulimit) Reset()      { *m = ContainerSpec_Ulimit{} }
func (*ContainerSpec_Ulimit) ProtoMessage() {}
func (*ContainerSpec_Ulimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{10, 4}
}
func (m *ContainerSpec_Ulimit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerSpec_Ulimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerSpec_Ulimit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerSpec_Ulimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerSpec_Ulimit.Merge(m, src)
}
func (m *ContainerSpec_Ulimit) XXX_Size() int {
	return m.Size()
}
func (m *ContainerSpec_Ulimit) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerSpec_Ulimit.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerSpec_Ulimit proto.InternalMessageInfo

// EndpointSpec defines the properties that can be configured to
// access and loadbalance the service.
type EndpointSpec struct {
	Mode EndpointSpec_ResolutionMode `protobuf:"varint,1,opt,name=mode,proto3,enum=docker.swarmkit.v1.EndpointSpec_ResolutionMode" json:"mode,omitempty"`
	// List of exposed ports that this service is accessible from
	// external to the cluster.
	Ports []*PortConfig `protobuf:"bytes,2,rep,name=ports,proto3" json:"ports,omitempty"`
}

func (m *EndpointSpec) Reset()      { *m = EndpointSpec{} }
func (*EndpointSpec) ProtoMessage() {}
func (*EndpointSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{11}
}
func (m *EndpointSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndpointSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EndpointSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EndpointSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointSpec.Merge(m, src)
}
func (m *EndpointSpec) XXX_Size() int {
	return m.Size()
}
func (m *EndpointSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointSpec.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointSpec proto.InternalMessageInfo

// NetworkSpec specifies user defined network parameters.
type NetworkSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations"`
	// DriverConfig specific configuration consumed by the network driver.
	DriverConfig *Driver `protobuf:"bytes,2,opt,name=driver_config,json=driverConfig,proto3" json:"driver_config,omitempty"`
	// IPv6Enabled enables support for IPv6 on the network.
	Ipv6Enabled bool `protobuf:"varint,3,opt,name=ipv6_enabled,json=ipv6Enabled,proto3" json:"ipv6_enabled,omitempty"`
	// internal restricts external access to the network. This may be
	// accomplished by disabling the default gateway or through other means.
	Internal bool         `protobuf:"varint,4,opt,name=internal,proto3" json:"internal,omitempty"`
	IPAM     *IPAMOptions `protobuf:"bytes,5,opt,name=ipam,proto3" json:"ipam,omitempty"`
	// Attachable allows external(to swarm) entities to manually
	// attach to this network. With this flag enabled, external
	// entities such as containers running in an worker node in
	// the cluster can manually attach to this network and access
	// the services attached to this network. If this flag is not
	// enabled(default case) no manual attachment to this network
	// can happen.
	Attachable bool `protobuf:"varint,6,opt,name=attachable,proto3" json:"attachable,omitempty"`
	// Ingress indicates this network will provide the routing-mesh.
	// In older versions, the network providing the routing mesh was
	// swarm internally created only and it was identified by the name
	// "ingress" and the label "com.docker.swarm.internal": "true".
	Ingress bool `protobuf:"varint,7,opt,name=ingress,proto3" json:"ingress,omitempty"`
	// ConfigFrom is the source of the configuration for this network.
	//
	// Types that are valid to be assigned to ConfigFrom:
	//	*NetworkSpec_Network
	ConfigFrom isNetworkSpec_ConfigFrom `protobuf_oneof:"config_from"`
}

func (m *NetworkSpec) Reset()      { *m = NetworkSpec{} }
func (*NetworkSpec) ProtoMessage() {}
func (*NetworkSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{12}
}
func (m *NetworkSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkSpec.Merge(m, src)
}
func (m *NetworkSpec) XXX_Size() int {
	return m.Size()
}
func (m *NetworkSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkSpec proto.InternalMessageInfo

type isNetworkSpec_ConfigFrom interface {
	isNetworkSpec_ConfigFrom()
	MarshalTo([]byte) (int, error)
	Size() int
}

type NetworkSpec_Network struct {
	Network string `protobuf:"bytes,8,opt,name=network,proto3,oneof"`
}

func (*NetworkSpec_Network) isNetworkSpec_ConfigFrom() {}

func (m *NetworkSpec) GetConfigFrom() isNetworkSpec_ConfigFrom {
	if m != nil {
		return m.ConfigFrom
	}
	return nil
}

func (m *NetworkSpec) GetNetwork() string {
	if x, ok := m.GetConfigFrom().(*NetworkSpec_Network); ok {
		return x.Network
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*NetworkSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _NetworkSpec_OneofMarshaler, _NetworkSpec_OneofUnmarshaler, _NetworkSpec_OneofSizer, []interface{}{
		(*NetworkSpec_Network)(nil),
	}
}

func _NetworkSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*NetworkSpec)
	// config_from
	switch x := m.ConfigFrom.(type) {
	case *NetworkSpec_Network:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Network)
	case nil:
	default:
		return fmt.Errorf("NetworkSpec.ConfigFrom has unexpected type %T", x)
	}
	return nil
}

func _NetworkSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*NetworkSpec)
	switch tag {
	case 8: // config_from.network
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ConfigFrom = &NetworkSpec_Network{x}
		return true, err
	default:
		return false, nil
	}
}

func _NetworkSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*NetworkSpec)
	// config_from
	switch x := m.ConfigFrom.(type) {
	case *NetworkSpec_Network:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Network)))
		n += len(x.Network)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ClusterSpec specifies global cluster settings.
type ClusterSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations"`
	// DEPRECATED: AcceptancePolicy defines the certificate issuance policy.
	// Acceptance policy is no longer customizable, and secrets have been
	// replaced with join tokens.
	AcceptancePolicy AcceptancePolicy `protobuf:"bytes,2,opt,name=acceptance_policy,json=acceptancePolicy,proto3" json:"acceptance_policy"` // Deprecated: Do not use.
	// Orchestration defines cluster-level orchestration settings.
	Orchestration OrchestrationConfig `protobuf:"bytes,3,opt,name=orchestration,proto3" json:"orchestration"`
	// Raft defines the cluster's raft settings.
	Raft RaftConfig `protobuf:"bytes,4,opt,name=raft,proto3" json:"raft"`
	// Dispatcher defines cluster-level dispatcher settings.
	Dispatcher DispatcherConfig `protobuf:"bytes,5,opt,name=dispatcher,proto3" json:"dispatcher"`
	// CAConfig defines cluster-level certificate authority settings.
	CAConfig CAConfig `protobuf:"bytes,6,opt,name=ca_config,json=caConfig,proto3" json:"ca_config"`
	// TaskDefaults specifies the default values to use for task creation.
	TaskDefaults TaskDefaults `protobuf:"bytes,7,opt,name=task_defaults,json=taskDefaults,proto3" json:"task_defaults"`
	// EncryptionConfig defines the cluster's encryption settings.
	EncryptionConfig EncryptionConfig `protobuf:"bytes,8,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config"`
}

func (m *ClusterSpec) Reset()      { *m = ClusterSpec{} }
func (*ClusterSpec) ProtoMessage() {}
func (*ClusterSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{13}
}
func (m *ClusterSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterSpec.Merge(m, src)
}
func (m *ClusterSpec) XXX_Size() int {
	return m.Size()
}
func (m *ClusterSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterSpec proto.InternalMessageInfo

// SecretSpec specifies a user-provided secret.
type SecretSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations"`
	// Data is the secret payload - the maximum size is 500KB (that is, 500*1024 bytes)
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Templating controls whether and how to evaluate the secret payload as
	// a template. If it is not set, no templating is used.
	//
	// The currently recognized values are:
	// - golang: Go templating
	Templating *Driver `protobuf:"bytes,3,opt,name=templating,proto3" json:"templating,omitempty"`
	// Driver is the the secret driver that is used to store the specified secret
	Driver *Driver `protobuf:"bytes,4,opt,name=driver,proto3" json:"driver,omitempty"`
}

func (m *SecretSpec) Reset()      { *m = SecretSpec{} }
func (*SecretSpec) ProtoMessage() {}
func (*SecretSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{14}
}
func (m *SecretSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretSpec.Merge(m, src)
}
func (m *SecretSpec) XXX_Size() int {
	return m.Size()
}
func (m *SecretSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretSpec.DiscardUnknown(m)
}

var xxx_messageInfo_SecretSpec proto.InternalMessageInfo

// ConfigSpec specifies user-provided configuration files.
type ConfigSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations"`
	// Data is the config payload - the maximum size is 500KB (that is, 500*1024 bytes)
	// TODO(aaronl): Do we want to revise this to include multiple payloads in a single
	// ConfigSpec? Define this to be a tar? etc...
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Templating controls whether and how to evaluate the secret payload as
	// a template. If it is not set, no templating is used.
	//
	// The currently recognized values are:
	// - golang: Go templating
	Templating *Driver `protobuf:"bytes,3,opt,name=templating,proto3" json:"templating,omitempty"`
}

func (m *ConfigSpec) Reset()      { *m = ConfigSpec{} }
func (*ConfigSpec) ProtoMessage() {}
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6589acc608f7d4fd, []int{15}
}
func (m *ConfigSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec.Merge(m, src)
}
func (m *ConfigSpec) XXX_Size() int {
	return m.Size()
}
func (m *ConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("docker.swarmkit.v1.NodeSpec_Membership", NodeSpec_Membership_name, NodeSpec_Membership_value)
	proto.RegisterEnum("docker.swarmkit.v1.NodeSpec_Availability", NodeSpec_Availability_name, NodeSpec_Availability_value)
	proto.RegisterEnum("docker.swarmkit.v1.ContainerSpec_Isolation", ContainerSpec_Isolation_name, ContainerSpec_Isolation_value)
	proto.RegisterEnum("docker.swarmkit.v1.EndpointSpec_ResolutionMode", EndpointSpec_ResolutionMode_name, EndpointSpec_ResolutionMode_value)
	proto.RegisterType((*NodeSpec)(nil), "docker.swarmkit.v1.NodeSpec")
	proto.RegisterType((*ServiceSpec)(nil), "docker.swarmkit.v1.ServiceSpec")
	proto.RegisterType((*ReplicatedService)(nil), "docker.swarmkit.v1.ReplicatedService")
	proto.RegisterType((*GlobalService)(nil), "docker.swarmkit.v1.GlobalService")
	proto.RegisterType((*ReplicatedJob)(nil), "docker.swarmkit.v1.ReplicatedJob")
	proto.RegisterType((*GlobalJob)(nil), "docker.swarmkit.v1.GlobalJob")
	proto.RegisterType((*TaskSpec)(nil), "docker.swarmkit.v1.TaskSpec")
	proto.RegisterType((*ResourceReference)(nil), "docker.swarmkit.v1.ResourceReference")
	proto.RegisterType((*GenericRuntimeSpec)(nil), "docker.swarmkit.v1.GenericRuntimeSpec")
	proto.RegisterType((*NetworkAttachmentSpec)(nil), "docker.swarmkit.v1.NetworkAttachmentSpec")
	proto.RegisterType((*ContainerSpec)(nil), "docker.swarmkit.v1.ContainerSpec")
	proto.RegisterMapType((map[string]string)(nil), "docker.swarmkit.v1.ContainerSpec.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "docker.swarmkit.v1.ContainerSpec.SysctlsEntry")
	proto.RegisterType((*ContainerSpec_PullOptions)(nil), "docker.swarmkit.v1.ContainerSpec.PullOptions")
	proto.RegisterType((*ContainerSpec_DNSConfig)(nil), "docker.swarmkit.v1.ContainerSpec.DNSConfig")
	proto.RegisterType((*ContainerSpec_Ulimit)(nil), "docker.swarmkit.v1.ContainerSpec.Ulimit")
	proto.RegisterType((*EndpointSpec)(nil), "docker.swarmkit.v1.EndpointSpec")
	proto.RegisterType((*NetworkSpec)(nil), "docker.swarmkit.v1.NetworkSpec")
	proto.RegisterType((*ClusterSpec)(nil), "docker.swarmkit.v1.ClusterSpec")
	proto.RegisterType((*SecretSpec)(nil), "docker.swarmkit.v1.SecretSpec")
	proto.RegisterType((*ConfigSpec)(nil), "docker.swarmkit.v1.ConfigSpec")
}

func init() {
	proto.RegisterFile("github.com/docker/swarmkit/api/specs.proto", fileDescriptor_6589acc608f7d4fd)
}

var fileDescriptor_6589acc608f7d4fd = []byte{
	// 2363 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x4d, 0x73, 0x1b, 0xc7,
	0xd1, 0x06, 0x48, 0x10, 0x1f, 0xbd, 0x00, 0x05, 0x8e, 0x65, 0x7b, 0x09, 0x49, 0x20, 0x0c, 0xcb,
	0x36, 0x6d, 0xd7, 0x0b, 0xd6, 0xcb, 0xb8, 0x1c, 0x7f, 0xc4, 0x49, 0x00, 0x02, 0x96, 0x60, 0x49,
	0x14, 0x6a, 0x40, 0x29, 0x51, 0x55, 0xaa, 0x50, 0x83, 0xdd, 0x21, 0xb0, 0xe1, 0x62, 0x67, 0x33,
	0x3b, 0xa0, 0x8d, 0x5b, 0x8e, 0x2e, 0xe5, 0x92, 0x3f, 0xc0, 0x53, 0x2a, 0xa7, 0x5c, 0x92, 0x7f,
	0x90, 0xa3, 0x8f, 0x3e, 0x3a, 0x17, 0x56, 0x4c, 0xff, 0x84, 0xdc, 0x72, 0x49, 0x6a, 0x66, 0x67,
	0x17, 0x0b, 0x0a, 0x10, 0x95, 0x8a, 0x0e, 0xb9, 0xcd, 0xf4, 0x3e, 0x4f, 0x4f, 0xcf, 0x4c, 0x77,
	0x4f, 0xf7, 0xc2, 0x7b, 0x23, 0x47, 0x8c, 0xa7, 0xc3, 0x86, 0xc5, 0x26, 0x7b, 0x36, 0xb3, 0x4e,
	0x28, 0xdf, 0x0b, 0xbe, 0x24, 0x7c, 0x72, 0xe2, 0x88, 0x3d, 0xe2, 0x3b, 0x7b, 0x81, 0x4f, 0xad,
	0xa0, 0xe1, 0x73, 0x26, 0x18, 0x42, 0x21, 0xa0, 0x11, 0x01, 0x1a, 0xa7, 0xff, 0x5f, 0xb9, 0x8a,
	0x2f, 0x66, 0x3e, 0xd5, 0xfc, 0xca, 0xf5, 0x11, 0x1b, 0x31, 0x35, 0xdc, 0x93, 0x23, 0x2d, 0xad,
	0x8e, 0x18, 0x1b, 0xb9, 0x74, 0x4f, 0xcd, 0x86, 0xd3, 0xe3, 0x3d, 0x7b, 0xca, 0x89, 0x70, 0x98,
	0xa7, 0xbf, 0x6f, 0x5f, 0xfe, 0x4e, 0xbc, 0xd9, 0x2a, 0xea, 0x97, 0x9c, 0xf8, 0x3e, 0xe5, 0x7a,
	0xc1, 0xfa, 0x59, 0x06, 0xf2, 0x87, 0xcc, 0xa6, 0x7d, 0x9f, 0x5a, 0xe8, 0x0e, 0x18, 0xc4, 0xf3,
	0x98, 0x50, 0xba, 0x03, 0x33, 0x5d, 0x4b, 0xef, 0x1a, 0xfb, 0x3b, 0x8d, 0x67, 0xf7, 0xd4, 0x68,
	0xce, 0x61, 0xad, 0xcc, 0x37, 0xe7, 0x3b, 0x29, 0x9c, 0x64, 0xa2, 0x9f, 0x41, 0xd1, 0xa6, 0x81,
	0xc3, 0xa9, 0x3d, 0xe0, 0xcc, 0xa5, 0xe6, 0x5a, 0x2d, 0xbd, 0xbb, 0xb9, 0x7f, 0x73, 0x99, 0x26,
	0xb9, 0x38, 0x66, 0x2e, 0xc5, 0x86, 0x66, 0xc8, 0x09, 0xba, 0x03, 0x30, 0xa1, 0x93, 0x21, 0xe5,
	0xc1, 0xd8, 0xf1, 0xcd, 0x75, 0x45, 0x7f, 0x67, 0x15, 0x5d, 0xda, 0xde, 0x78, 0x10, 0xc3, 0x71,
	0x82, 0x8a, 0x1e, 0x40, 0x91, 0x9c, 0x12, 0xc7, 0x25, 0x43, 0xc7, 0x75, 0xc4, 0xcc, 0xcc, 0x28,
	0x55, 0xef, 0x3e, 0x57, 0x55, 0x33, 0x41, 0xc0, 0x0b, 0xf4, 0xba, 0x0d, 0x30, 0x5f, 0x08, 0xbd,
	0x0d, 0xb9, 0x5e, 0xe7, 0xb0, 0xdd, 0x3d, 0xbc, 0x53, 0x4e, 0x55, 0xb6, 0x9f, 0x9e, 0xd5, 0x5e,
	0x95, 0x3a, 0xe6, 0x80, 0x1e, 0xf5, 0x6c, 0xc7, 0x1b, 0xa1, 0x5d, 0xc8, 0x37, 0x0f, 0x0e, 0x3a,
	0xbd, 0xa3, 0x4e, 0xbb, 0x9c, 0xae, 0x54, 0x9e, 0x9e, 0xd5, 0x5e, 0x5b, 0x04, 0x36, 0x2d, 0x8b,
	0xfa, 0x82, 0xda, 0x95, 0xcc, 0xd7, 0x7f, 0xa8, 0xa6, 0xea, 0x5f, 0xa7, 0xa1, 0x98, 0x34, 0x02,
	0xbd, 0x0d, 0xd9, 0xe6, 0xc1, 0x51, 0xf7, 0x71, 0xa7, 0x9c, 0x9a, 0xd3, 0x93, 0x88, 0xa6, 0x25,
	0x9c, 0x53, 0x8a, 0x6e, 0xc3, 0x46, 0xaf, 0xf9, 0xa8, 0xdf, 0x29, 0xa7, 0xe7, 0xe6, 0x24, 0x61,
	0x3d, 0x32, 0x0d, 0x14, 0xaa, 0x8d, 0x9b, 0xdd, 0xc3, 0xf2, 0xda, 0x72, 0x54, 0x9b, 0x13, 0xc7,
	0xd3, 0xa6, 0xfc, 0x69, 0x03, 0x8c, 0x3e, 0xe5, 0xa7, 0x8e, 0xf5, 0x92, 0x5d, 0xe4, 0x43, 0xc8,
	0x08, 0x12, 0x9c, 0x28, 0xd7, 0x30, 0x96, 0xbb, 0xc6, 0x11, 0x09, 0x4e, 0xe4, 0xa2, 0x9a, 0xae,
	0xf0, 0xd2, 0x33, 0x38, 0xf5, 0x5d, 0xc7, 0x22, 0x82, 0xda, 0xca, 0x33, 0x8c, 0xfd, 0xb7, 0x96,
	0xb1, 0x71, 0x8c, 0xd2, 0xf6, 0xdf, 0x4d, 0xe1, 0x04, 0x15, 0x7d, 0x0a, 0xd9, 0x91, 0xcb, 0x86,
	0xc4, 0x55, 0x3e, 0x61, 0xec, 0xbf, 0xb1, 0x4c, 0xc9, 0x1d, 0x85, 0x98, 0x2b, 0xd0, 0x14, 0xf4,
	0x05, 0x6c, 0xce, 0x55, 0x0d, 0x7e, 0xcd, 0x86, 0x26, 0xac, 0x56, 0x32, 0xb7, 0xe4, 0x0b, 0x36,
	0xbc, 0x9b, 0xc2, 0x25, 0x9e, 0x14, 0xa0, 0x9f, 0x02, 0x84, 0x5a, 0x95, 0x1e, 0x43, 0xe9, 0xb9,
	0xb5, 0xda, 0x98, 0x50, 0x47, 0x61, 0x14, 0x4d, 0xd0, 0x47, 0x90, 0x9d, 0xfa, 0x36, 0x11, 0xd4,
	0xcc, 0x2a, 0x6e, 0x6d, 0x19, 0xf7, 0x91, 0x42, 0x1c, 0x30, 0xef, 0xd8, 0x19, 0x61, 0x8d, 0x47,
	0x3f, 0x81, 0x3c, 0x67, 0xae, 0x3b, 0x24, 0xd6, 0x89, 0x59, 0x78, 0x41, 0x6e, 0xcc, 0x40, 0xf7,
	0x20, 0xef, 0x51, 0xf1, 0x25, 0xe3, 0x27, 0x81, 0x99, 0xab, 0xad, 0xef, 0x1a, 0xfb, 0xef, 0x2f,
	0x0d, 0xab, 0x10, 0xd3, 0x14, 0x82, 0x58, 0xe3, 0x09, 0xf5, 0x44, 0xa8, 0xa8, 0xb5, 0x66, 0xa6,
	0x71, 0xac, 0x40, 0x9a, 0x42, 0x3d, 0xdb, 0x67, 0x8e, 0x27, 0xcc, 0xfc, 0x6a, 0x53, 0x3a, 0x1a,
	0x23, 0xdd, 0x02, 0xc7, 0x8c, 0x56, 0x16, 0x32, 0x13, 0x66, 0xd3, 0xfa, 0x1e, 0x6c, 0x3d, 0x73,
	0xed, 0xa8, 0x02, 0x79, 0x7d, 0xe0, 0xa1, 0xbf, 0x66, 0x70, 0x3c, 0xaf, 0x5f, 0x83, 0xd2, 0xc2,
	0x15, 0xd7, 0x2d, 0x28, 0x2d, 0x5c, 0x17, 0x7a, 0x0b, 0x36, 0x27, 0xe4, 0xab, 0x81, 0xc5, 0x3c,
	0x6b, 0xca, 0x39, 0xf5, 0x84, 0xd6, 0x51, 0x9a, 0x90, 0xaf, 0x0e, 0x62, 0x21, 0x7a, 0x1f, 0xb6,
	0x04, 0x13, 0xc4, 0x1d, 0x58, 0x6c, 0xe2, 0xbb, 0x34, 0x8c, 0x8e, 0x35, 0x85, 0x2c, 0xab, 0x0f,
	0x07, 0x73, 0x79, 0xdd, 0x80, 0x42, 0x7c, 0x97, 0xf5, 0x3f, 0x6f, 0x40, 0x3e, 0xf2, 0x74, 0x74,
	0x0f, 0x80, 0xc4, 0x07, 0xa5, 0x0f, 0xe2, 0xdd, 0x17, 0x3a, 0x55, 0x49, 0x97, 0x1e, 0x3e, 0xa7,
	0xa3, 0x26, 0x14, 0x2c, 0xe6, 0x09, 0xe2, 0x78, 0x94, 0xeb, 0x48, 0x5d, 0xea, 0x9f, 0x07, 0x11,
	0x48, 0xeb, 0x98, 0xb3, 0x50, 0x0b, 0x72, 0x23, 0xea, 0x51, 0xee, 0x58, 0xda, 0xc1, 0xdf, 0x5e,
	0xea, 0x98, 0x21, 0x04, 0x4f, 0x3d, 0xe1, 0x4c, 0xa8, 0xd6, 0x12, 0x11, 0xd1, 0xe7, 0x50, 0xe0,
	0x34, 0x60, 0x53, 0x6e, 0xd1, 0x40, 0x87, 0xfb, 0xee, 0xf2, 0x30, 0x09, 0x41, 0x98, 0xfe, 0x66,
	0xea, 0x70, 0x2a, 0xb7, 0x10, 0xe0, 0x39, 0x15, 0x7d, 0x0a, 0x39, 0x4e, 0x03, 0x41, 0xb8, 0x78,
	0x5e, 0xc4, 0xe2, 0x10, 0xd2, 0x63, 0xae, 0x63, 0xcd, 0x70, 0xc4, 0x40, 0x9f, 0x42, 0xc1, 0x77,
	0x89, 0xa5, 0xb4, 0x9a, 0x1b, 0xab, 0x63, 0xac, 0x17, 0x81, 0xf0, 0x1c, 0x8f, 0x3e, 0x06, 0x70,
	0xd9, 0x68, 0x60, 0x73, 0xe7, 0x94, 0x72, 0x1d, 0x65, 0x95, 0x65, 0xec, 0xb6, 0x42, 0xe0, 0x82,
	0xcb, 0x46, 0xe1, 0x10, 0xdd, 0xf9, 0xaf, 0x82, 0x24, 0x11, 0x20, 0x6f, 0x40, 0xf1, 0x98, 0x71,
	0x8b, 0x0e, 0x74, 0xac, 0x17, 0x94, 0x6f, 0x19, 0x4a, 0x16, 0x06, 0x28, 0xfa, 0x15, 0xbc, 0x12,
	0x9d, 0xd6, 0x80, 0xd3, 0x63, 0xca, 0xa9, 0x27, 0x8f, 0xdc, 0x50, 0xcb, 0xbe, 0xf5, 0xfc, 0x23,
	0xd7, 0x68, 0x9d, 0x6a, 0x11, 0xbf, 0xfc, 0x21, 0x68, 0x15, 0x20, 0xc7, 0xc3, 0x0b, 0xae, 0xff,
	0x2e, 0x2d, 0xe3, 0xec, 0x12, 0x02, 0xed, 0x81, 0x11, 0x2f, 0xef, 0xd8, 0xca, 0xe1, 0x0a, 0xad,
	0xcd, 0x8b, 0xf3, 0x1d, 0x88, 0xb0, 0xdd, 0xb6, 0xcc, 0xc0, 0x7a, 0x6c, 0xa3, 0x0e, 0x94, 0x62,
	0x82, 0x2c, 0x82, 0x74, 0x99, 0x50, 0x7b, 0x9e, 0xa5, 0x47, 0x33, 0x9f, 0xe2, 0x22, 0x4f, 0xcc,
	0xea, 0xbf, 0x04, 0xf4, 0xac, 0x03, 0x22, 0x04, 0x99, 0x13, 0xc7, 0xd3, 0x66, 0x60, 0x35, 0x46,
	0x0d, 0xc8, 0xf9, 0x64, 0xe6, 0x32, 0x62, 0x6b, 0x3f, 0xbc, 0xde, 0x08, 0xcb, 0xa3, 0x46, 0x54,
	0x1e, 0x35, 0x9a, 0xde, 0x0c, 0x47, 0xa0, 0xfa, 0x3d, 0x78, 0x75, 0x69, 0x9c, 0xa1, 0x7d, 0x28,
	0xc6, 0x31, 0x32, 0xdf, 0xeb, 0xb5, 0x8b, 0xf3, 0x1d, 0x23, 0x0e, 0xa6, 0x6e, 0x1b, 0x1b, 0x31,
	0xa8, 0x6b, 0xd7, 0xff, 0xba, 0x09, 0xa5, 0x85, 0x48, 0x43, 0xd7, 0x61, 0xc3, 0x99, 0x90, 0x11,
	0xd5, 0x36, 0x86, 0x13, 0xd4, 0x81, 0xac, 0x4b, 0x86, 0xd4, 0x95, 0xb1, 0x22, 0x2f, 0xee, 0xff,
	0xae, 0x0c, 0xd9, 0xc6, 0x7d, 0x85, 0xef, 0x78, 0x82, 0xcf, 0xb0, 0x26, 0x23, 0x13, 0x72, 0x16,
	0x9b, 0x4c, 0x88, 0x27, 0x1f, 0xc9, 0xf5, 0xdd, 0x02, 0x8e, 0xa6, 0xf2, 0x64, 0x08, 0x1f, 0x05,
	0x66, 0x46, 0x89, 0xd5, 0x58, 0xe6, 0xc8, 0x31, 0x0b, 0x84, 0x47, 0x26, 0xd4, 0xdc, 0x54, 0xd6,
	0xc4, 0x73, 0x54, 0x86, 0x75, 0xea, 0x9d, 0x9a, 0x1b, 0x0a, 0x2e, 0x87, 0x52, 0x62, 0x3b, 0x61,
	0x20, 0x14, 0xb0, 0x1c, 0x4a, 0x9d, 0xd3, 0x80, 0x72, 0x33, 0x17, 0x9e, 0xb6, 0x1c, 0xa3, 0xd7,
	0x20, 0x3b, 0xe2, 0x6c, 0xea, 0x87, 0x1e, 0x58, 0xc0, 0x7a, 0x26, 0xdf, 0x3b, 0x9f, 0x3b, 0xa7,
	0x8e, 0x4b, 0x47, 0x34, 0x30, 0x5f, 0x53, 0x17, 0x51, 0x5d, 0x1a, 0x8b, 0x31, 0x0a, 0x27, 0x18,
	0xa8, 0x01, 0x19, 0xc7, 0x73, 0x84, 0xf9, 0xba, 0x8e, 0xc3, 0xcb, 0x57, 0xd8, 0x62, 0xcc, 0x7d,
	0x4c, 0xdc, 0x29, 0xc5, 0x0a, 0x87, 0xb6, 0x61, 0x5d, 0x88, 0x99, 0x59, 0xaa, 0xa5, 0x77, 0xf3,
	0xad, 0xdc, 0xc5, 0xf9, 0xce, 0xfa, 0xd1, 0xd1, 0x13, 0x2c, 0x65, 0xe8, 0x16, 0x00, 0xf3, 0xa9,
	0x37, 0x08, 0x84, 0xed, 0x78, 0x26, 0x92, 0x08, 0x5c, 0x90, 0x92, 0xbe, 0x14, 0xa0, 0x1b, 0x32,
	0x73, 0x11, 0x7b, 0xc0, 0x3c, 0x77, 0x66, 0xbe, 0xa2, 0xbe, 0xe6, 0xa5, 0xe0, 0xa1, 0xe7, 0xce,
	0xd0, 0x0e, 0x18, 0x81, 0x60, 0xfe, 0x20, 0x70, 0x46, 0x1e, 0x71, 0xcd, 0xeb, 0x6a, 0xe7, 0x20,
	0x45, 0x7d, 0x25, 0x41, 0x3f, 0x86, 0xec, 0x84, 0x4d, 0x3d, 0x11, 0x98, 0x79, 0x75, 0x91, 0xdb,
	0xcb, 0xf6, 0xf8, 0x40, 0x22, 0x74, 0xd4, 0x69, 0x38, 0xea, 0xc0, 0x96, 0xd2, 0x3c, 0xe2, 0xc4,
	0xa2, 0x03, 0x9f, 0x72, 0x87, 0xd9, 0xfa, 0x7d, 0xde, 0x7e, 0x66, 0xb7, 0x6d, 0xdd, 0x0a, 0xe0,
	0x6b, 0x92, 0x73, 0x47, 0x52, 0x7a, 0x8a, 0x81, 0x7a, 0x50, 0xf4, 0xa7, 0xae, 0x3b, 0x60, 0x7e,
	0xf8, 0x1a, 0x85, 0x09, 0xfc, 0x05, 0xdc, 0xa9, 0x37, 0x75, 0xdd, 0x87, 0x21, 0x09, 0x1b, 0xfe,
	0x7c, 0x82, 0x3e, 0x83, 0x5c, 0x40, 0x2d, 0x4e, 0x45, 0x60, 0x16, 0xd5, 0x96, 0xde, 0x5c, 0xa6,
	0xac, 0xaf, 0x20, 0x71, 0x5e, 0xc0, 0x11, 0x47, 0xd2, 0x2d, 0x95, 0xd6, 0x02, 0xf3, 0xd5, 0xd5,
	0x74, 0x9d, 0xf9, 0xe6, 0x74, 0xcd, 0x91, 0xe1, 0x22, 0x7d, 0x32, 0x30, 0xb7, 0x94, 0x3b, 0x85,
	0x13, 0xf4, 0x04, 0xc0, 0xf6, 0x82, 0x41, 0x08, 0x32, 0xaf, 0xa9, 0x3d, 0xbe, 0x7f, 0xf5, 0x1e,
	0xdb, 0x87, 0x7d, 0x5d, 0x87, 0x94, 0x2e, 0xce, 0x77, 0x0a, 0xf1, 0x14, 0x17, 0x6c, 0x2f, 0x08,
	0x87, 0xa8, 0x05, 0xc6, 0x98, 0x12, 0x57, 0x8c, 0xad, 0x31, 0xb5, 0x4e, 0xcc, 0xf2, 0xea, 0xb2,
	0xe4, 0xae, 0x82, 0x69, 0x0d, 0x49, 0x12, 0xea, 0x42, 0xc1, 0x09, 0x98, 0xab, 0xae, 0xc8, 0x34,
	0x55, 0x7e, 0x7b, 0x01, 0xeb, 0xba, 0x11, 0x05, 0xcf, 0xd9, 0xe8, 0x26, 0x14, 0x7c, 0xc7, 0x0e,
	0xee, 0x3b, 0x13, 0x47, 0x98, 0xdb, 0xb5, 0xf4, 0xee, 0x3a, 0x9e, 0x0b, 0xd0, 0x5d, 0xc8, 0x05,
	0xb3, 0xc0, 0x12, 0x6e, 0x60, 0x56, 0xd4, 0xe1, 0x36, 0xae, 0x5e, 0xa6, 0x1f, 0x12, 0xc2, 0xc4,
	0x11, 0xd1, 0x65, 0xc5, 0x63, 0x11, 0x5f, 0xf7, 0x02, 0x03, 0x62, 0xdb, 0xe6, 0x0d, 0x75, 0xe0,
	0xa5, 0xb9, 0xb4, 0x69, 0xdb, 0xe8, 0x1d, 0xb8, 0x96, 0x80, 0xd9, 0x9c, 0xf9, 0xe6, 0x4d, 0x85,
	0x4b, 0xb0, 0xdb, 0x9c, 0xf9, 0xb2, 0x86, 0x98, 0xba, 0xd2, 0xc6, 0xc0, 0xbc, 0xa5, 0x2c, 0xdb,
	0xbd, 0xda, 0xb2, 0x47, 0x8a, 0x80, 0x23, 0x62, 0xe5, 0x63, 0x30, 0x12, 0x49, 0x4e, 0x26, 0xa0,
	0x13, 0x3a, 0xd3, 0x79, 0x53, 0x0e, 0xa5, 0x73, 0x9c, 0xca, 0x98, 0x57, 0x89, 0xbd, 0x80, 0xc3,
	0xc9, 0x27, 0x6b, 0x1f, 0xa5, 0x2b, 0xfb, 0x60, 0x24, 0x1c, 0x1a, 0xbd, 0x29, 0x1f, 0x9d, 0x91,
	0x13, 0x08, 0x3e, 0x1b, 0x90, 0xa9, 0x18, 0x9b, 0x3f, 0x57, 0x84, 0x62, 0x24, 0x6c, 0x4e, 0xc5,
	0xb8, 0x32, 0x80, 0xb9, 0x47, 0xa0, 0x1a, 0x18, 0x32, 0x0f, 0x06, 0x94, 0x9f, 0x52, 0x2e, 0x4b,
	0x48, 0xb9, 0xc9, 0xa4, 0x48, 0x66, 0xba, 0x80, 0x12, 0x6e, 0x8d, 0x55, 0xca, 0x2e, 0x60, 0x3d,
	0x93, 0x39, 0x38, 0x0a, 0x3e, 0x9d, 0x83, 0xf5, 0xb4, 0xf2, 0x09, 0x14, 0x93, 0x87, 0xff, 0x1f,
	0x6d, 0xa8, 0x0d, 0xd9, 0xf0, 0x78, 0x64, 0xd6, 0x55, 0x19, 0x5b, 0xbf, 0x71, 0x2a, 0x5b, 0x23,
	0xc8, 0x04, 0xec, 0x58, 0x28, 0xda, 0x3a, 0x56, 0x63, 0x29, 0x1b, 0x13, 0x1e, 0x76, 0x4b, 0xeb,
	0x58, 0x8d, 0xeb, 0x7f, 0x49, 0x43, 0x21, 0x76, 0x33, 0xf4, 0x01, 0x6c, 0x75, 0xfb, 0x0f, 0xef,
	0x37, 0x8f, 0xba, 0x0f, 0x0f, 0x07, 0xed, 0xce, 0xe7, 0xcd, 0x47, 0xf7, 0x8f, 0xca, 0xa9, 0xca,
	0xad, 0xa7, 0x67, 0xb5, 0xed, 0xf9, 0x8b, 0x16, 0xc1, 0xdb, 0xf4, 0x98, 0x4c, 0x5d, 0xb1, 0xc8,
	0xea, 0xe1, 0x87, 0x07, 0x9d, 0x7e, 0xbf, 0x9c, 0x5e, 0xc5, 0xea, 0x71, 0x66, 0xd1, 0x20, 0x40,
	0xfb, 0x50, 0x9e, 0xb3, 0xee, 0x3e, 0xe9, 0x75, 0xf0, 0xe3, 0xf2, 0x5a, 0xe5, 0xe6, 0xd3, 0xb3,
	0x9a, 0xf9, 0x2c, 0xe9, 0xee, 0xcc, 0xa7, 0xfc, 0xb1, 0x6e, 0x46, 0xff, 0x91, 0x86, 0x62, 0xb2,
	0x03, 0x40, 0x07, 0x61, 0xdd, 0xaf, 0x0e, 0x60, 0x73, 0x7f, 0xef, 0xaa, 0x8e, 0x41, 0x55, 0x11,
	0xee, 0x54, 0xea, 0x7d, 0xc0, 0x6c, 0x8a, 0x15, 0x19, 0x7d, 0x00, 0x1b, 0x3e, 0xe3, 0x22, 0x7a,
	0x6f, 0x97, 0x3f, 0x45, 0x8c, 0x47, 0x25, 0x59, 0x08, 0xae, 0x8f, 0x61, 0x73, 0x51, 0x1b, 0xba,
	0x0d, 0xeb, 0x8f, 0xbb, 0xbd, 0x72, 0xaa, 0x72, 0xe3, 0xe9, 0x59, 0xed, 0xf5, 0xc5, 0x8f, 0x8f,
	0x1d, 0x2e, 0xa6, 0xc4, 0xed, 0xf6, 0xd0, 0x7b, 0xb0, 0xd1, 0x3e, 0xec, 0x63, 0x5c, 0x4e, 0x57,
	0x76, 0x9e, 0x9e, 0xd5, 0x6e, 0x2c, 0xe2, 0xe4, 0x27, 0x36, 0xf5, 0x6c, 0xcc, 0x86, 0x71, 0x0b,
	0xfe, 0xcf, 0x35, 0x30, 0x74, 0x19, 0xf2, 0xb2, 0xff, 0xd2, 0x94, 0xc2, 0x92, 0x36, 0xca, 0x9e,
	0x6b, 0x57, 0x56, 0xb6, 0xc5, 0x90, 0xa0, 0x23, 0xe3, 0x0d, 0x28, 0x3a, 0xfe, 0xe9, 0x87, 0x03,
	0xea, 0x91, 0xa1, 0xab, 0xbb, 0xf1, 0x3c, 0x36, 0xa4, 0xac, 0x13, 0x8a, 0x64, 0x61, 0xe1, 0x78,
	0x82, 0x72, 0x4f, 0xf7, 0xd9, 0x79, 0x1c, 0xcf, 0xd1, 0x67, 0x90, 0x71, 0x7c, 0x32, 0xd1, 0xe5,
	0xf8, 0xd2, 0x1d, 0x74, 0x7b, 0xcd, 0x07, 0x3a, 0x72, 0x5b, 0xf9, 0x8b, 0xf3, 0x9d, 0x8c, 0x14,
	0x60, 0x45, 0x43, 0xd5, 0xa8, 0x57, 0x92, 0x2b, 0xa9, 0x62, 0x24, 0x8f, 0x13, 0x12, 0x19, 0x7d,
	0x8e, 0x37, 0xe2, 0x34, 0x08, 0x54, 0x59, 0x92, 0xc7, 0xd1, 0x14, 0x55, 0x20, 0xa7, 0xeb, 0x6a,
	0xd5, 0x62, 0x15, 0x64, 0xb7, 0xa2, 0x05, 0xad, 0x12, 0x18, 0xe1, 0x69, 0x0c, 0x8e, 0x39, 0x9b,
	0xd4, 0xff, 0x95, 0x01, 0xe3, 0xc0, 0x9d, 0x06, 0x42, 0xd7, 0x6c, 0x2f, 0xed, 0xf0, 0x9f, 0xc0,
	0x16, 0x51, 0x7f, 0x7d, 0x88, 0x27, 0x1f, 0x79, 0xd5, 0xae, 0xe8, 0x0b, 0xb8, 0xbd, 0x54, 0x5d,
	0x0c, 0x0e, 0x5b, 0x9b, 0x56, 0x56, 0xea, 0x34, 0xd3, 0xb8, 0x4c, 0x2e, 0x7d, 0x41, 0x7d, 0x28,
	0x31, 0x6e, 0x8d, 0x69, 0x20, 0xc2, 0xd2, 0x40, 0xff, 0x25, 0x59, 0xfa, 0xff, 0xec, 0x61, 0x12,
	0xa8, 0x5f, 0xc4, 0xd0, 0xda, 0x45, 0x1d, 0xe8, 0x23, 0xc8, 0x70, 0x72, 0x1c, 0xb5, 0x5e, 0x4b,
	0x83, 0x04, 0x93, 0x63, 0xb1, 0xa0, 0x42, 0x31, 0xd0, 0x17, 0x00, 0xb6, 0x13, 0xf8, 0x44, 0x58,
	0x63, 0xca, 0xf5, 0x65, 0x2f, 0xdd, 0x62, 0x3b, 0x46, 0x2d, 0x68, 0x49, 0xb0, 0xd1, 0x3d, 0x28,
	0x58, 0x24, 0x72, 0xd7, 0xec, 0xea, 0x5f, 0x47, 0x07, 0x4d, 0xad, 0xa2, 0x2c, 0x55, 0x5c, 0x9c,
	0xef, 0xe4, 0x23, 0x09, 0xce, 0x5b, 0x44, 0xbb, 0xef, 0x3d, 0x28, 0x09, 0x12, 0x9c, 0x0c, 0xec,
	0x30, 0x9d, 0x85, 0x6e, 0xb2, 0xe2, 0x85, 0x97, 0x1d, 0xba, 0x4e, 0x7b, 0xd1, 0x75, 0x16, 0x45,
	0x42, 0x86, 0x7e, 0x01, 0x5b, 0xd4, 0xb3, 0xf8, 0x4c, 0x39, 0x6b, 0x64, 0x61, 0x7e, 0xf5, 0x66,
	0x3b, 0x31, 0x78, 0x61, 0xb3, 0x65, 0x7a, 0x49, 0x5e, 0xff, 0x5b, 0x1a, 0x20, 0x2c, 0xa9, 0x5e,
	0xae, 0x03, 0x22, 0xc8, 0xd8, 0x44, 0x10, 0xe5, 0x73, 0x45, 0xac, 0xc6, 0xe8, 0x13, 0x00, 0x41,
	0x27, 0xbe, 0x4c, 0xbd, 0xde, 0x48, 0xbb, 0xcd, 0xf3, 0xd2, 0x41, 0x02, 0x8d, 0xf6, 0x21, 0xab,
	0x1b, 0xe4, 0xcc, 0x95, 0x3c, 0x8d, 0xac, 0xff, 0x31, 0x0d, 0x10, 0x6e, 0xf3, 0x7f, 0x7a, 0x6f,
	0xad, 0xdb, 0xdf, 0x7c, 0x5f, 0x4d, 0x7d, 0xf7, 0x7d, 0x35, 0xf5, 0xdb, 0x8b, 0x6a, 0xfa, 0x9b,
	0x8b, 0x6a, 0xfa, 0xdb, 0x8b, 0x6a, 0xfa, 0xef, 0x17, 0xd5, 0xf4, 0xef, 0x7f, 0xa8, 0xa6, 0xbe,
	0xfd, 0xa1, 0x9a, 0xfa, 0xee, 0x87, 0x6a, 0x6a, 0x98, 0x55, 0x45, 0xf9, 0x8f, 0xfe, 0x1d, 0x00,
	0x00, 0xff, 0xff, 0x74, 0x9e, 0x83, 0x44, 0x31, 0x18, 0x00, 0x00,
}

func (m *NodeSpec) Copy() *NodeSpec {
	if m == nil {
		return nil
	}
	o := &NodeSpec{}
	o.CopyFrom(m)
	return o
}

func (m *NodeSpec) CopyFrom(src interface{}) {

	o := src.(*NodeSpec)
	*m = *o
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Annotations, &o.Annotations)
}

func (m *ServiceSpec) Copy() *ServiceSpec {
	if m == nil {
		return nil
	}
	o := &ServiceSpec{}
	o.CopyFrom(m)
	return o
}

func (m *ServiceSpec) CopyFrom(src interface{}) {

	o := src.(*ServiceSpec)
	*m = *o
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Annotations, &o.Annotations)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Task, &o.Task)
	if o.Update != nil {
		m.Update = &UpdateConfig{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Update, o.Update)
	}
	if o.Rollback != nil {
		m.Rollback = &UpdateConfig{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Rollback, o.Rollback)
	}
	if o.Networks != nil {
		m.Networks = make([]*NetworkAttachmentConfig, len(o.Networks))
		for i := range m.Networks {
			m.Networks[i] = &NetworkAttachmentConfig{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Networks[i], o.Networks[i])
		}
	}

	if o.Endpoint != nil {
		m.Endpoint = &EndpointSpec{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Endpoint, o.Endpoint)
	}
	if o.Mode != nil {
		switch o.Mode.(type) {
		case *ServiceSpec_Replicated:
			v := ServiceSpec_Replicated{
				Replicated: &ReplicatedService{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Replicated, o.GetReplicated())
			m.Mode = &v
		case *ServiceSpec_Global:
			v := ServiceSpec_Global{
				Global: &GlobalService{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Global, o.GetGlobal())
			m.Mode = &v
		case *ServiceSpec_ReplicatedJob:
			v := ServiceSpec_ReplicatedJob{
				ReplicatedJob: &ReplicatedJob{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.ReplicatedJob, o.GetReplicatedJob())
			m.Mode = &v
		case *ServiceSpec_GlobalJob:
			v := ServiceSpec_GlobalJob{
				GlobalJob: &GlobalJob{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.GlobalJob, o.GetGlobalJob())
			m.Mode = &v
		}
	}

}

func (m *ReplicatedService) Copy() *ReplicatedService {
	if m == nil {
		return nil
	}
	o := &ReplicatedService{}
	o.CopyFrom(m)
	return o
}

func (m *ReplicatedService) CopyFrom(src interface{}) {

	o := src.(*ReplicatedService)
	*m = *o
}

func (m *GlobalService) Copy() *GlobalService {
	if m == nil {
		return nil
	}
	o := &GlobalService{}
	o.CopyFrom(m)
	return o
}

func (m *GlobalService) CopyFrom(src interface{}) {}
func (m *ReplicatedJob) Copy() *ReplicatedJob {
	if m == nil {
		return nil
	}
	o := &ReplicatedJob{}
	o.CopyFrom(m)
	return o
}

func (m *ReplicatedJob) CopyFrom(src interface{}) {

	o := src.(*ReplicatedJob)
	*m = *o
}

func (m *GlobalJob) Copy() *GlobalJob {
	if m == nil {
		return nil
	}
	o := &GlobalJob{}
	o.CopyFrom(m)
	return o
}

func (m *GlobalJob) CopyFrom(src interface{}) {}
func (m *TaskSpec) Copy() *TaskSpec {
	if m == nil {
		return nil
	}
	o := &TaskSpec{}
	o.CopyFrom(m)
	return o
}

func (m *TaskSpec) CopyFrom(src interface{}) {

	o := src.(*TaskSpec)
	*m = *o
	if o.Resources != nil {
		m.Resources = &ResourceRequirements{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Resources, o.Resources)
	}
	if o.Restart != nil {
		m.Restart = &RestartPolicy{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Restart, o.Restart)
	}
	if o.Placement != nil {
		m.Placement = &Placement{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Placement, o.Placement)
	}
	if o.LogDriver != nil {
		m.LogDriver = &Driver{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.LogDriver, o.LogDriver)
	}
	if o.Networks != nil {
		m.Networks = make([]*NetworkAttachmentConfig, len(o.Networks))
		for i := range m.Networks {
			m.Networks[i] = &NetworkAttachmentConfig{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Networks[i], o.Networks[i])
		}
	}

	if o.ResourceReferences != nil {
		m.ResourceReferences = make([]ResourceReference, len(o.ResourceReferences))
		for i := range m.ResourceReferences {
			github_com_docker_swarmkit_api_deepcopy.Copy(&m.ResourceReferences[i], &o.ResourceReferences[i])
		}
	}

	if o.Runtime != nil {
		switch o.Runtime.(type) {
		case *TaskSpec_Attachment:
			v := TaskSpec_Attachment{
				Attachment: &NetworkAttachmentSpec{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Attachment, o.GetAttachment())
			m.Runtime = &v
		case *TaskSpec_Container:
			v := TaskSpec_Container{
				Container: &ContainerSpec{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Container, o.GetContainer())
			m.Runtime = &v
		case *TaskSpec_Generic:
			v := TaskSpec_Generic{
				Generic: &GenericRuntimeSpec{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Generic, o.GetGeneric())
			m.Runtime = &v
		}
	}

}

func (m *ResourceReference) Copy() *ResourceReference {
	if m == nil {
		return nil
	}
	o := &ResourceReference{}
	o.CopyFrom(m)
	return o
}

func (m *ResourceReference) CopyFrom(src interface{}) {

	o := src.(*ResourceReference)
	*m = *o
}

func (m *GenericRuntimeSpec) Copy() *GenericRuntimeSpec {
	if m == nil {
		return nil
	}
	o := &GenericRuntimeSpec{}
	o.CopyFrom(m)
	return o
}

func (m *GenericRuntimeSpec) CopyFrom(src interface{}) {

	o := src.(*GenericRuntimeSpec)
	*m = *o
	if o.Payload != nil {
		m.Payload = &types.Any{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Payload, o.Payload)
	}
}

func (m *NetworkAttachmentSpec) Copy() *NetworkAttachmentSpec {
	if m == nil {
		return nil
	}
	o := &NetworkAttachmentSpec{}
	o.CopyFrom(m)
	return o
}

func (m *NetworkAttachmentSpec) CopyFrom(src interface{}) {

	o := src.(*NetworkAttachmentSpec)
	*m = *o
}

func (m *ContainerSpec) Copy() *ContainerSpec {
	if m == nil {
		return nil
	}
	o := &ContainerSpec{}
	o.CopyFrom(m)
	return o
}

func (m *ContainerSpec) CopyFrom(src interface{}) {

	o := src.(*ContainerSpec)
	*m = *o
	if o.Labels != nil {
		m.Labels = make(map[string]string, len(o.Labels))
		for k, v := range o.Labels {
			m.Labels[k] = v
		}
	}

	if o.Command != nil {
		m.Command = make([]string, len(o.Command))
		copy(m.Command, o.Command)
	}

	if o.Args != nil {
		m.Args = make([]string, len(o.Args))
		copy(m.Args, o.Args)
	}

	if o.Env != nil {
		m.Env = make([]string, len(o.Env))
		copy(m.Env, o.Env)
	}

	if o.Groups != nil {
		m.Groups = make([]string, len(o.Groups))
		copy(m.Groups, o.Groups)
	}

	if o.Privileges != nil {
		m.Privileges = &Privileges{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Privileges, o.Privileges)
	}
	if o.Init != nil {
		m.Init = &types.BoolValue{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Init, o.Init)
	}
	if o.Mounts != nil {
		m.Mounts = make([]Mount, len(o.Mounts))
		for i := range m.Mounts {
			github_com_docker_swarmkit_api_deepcopy.Copy(&m.Mounts[i], &o.Mounts[i])
		}
	}

	if o.StopGracePeriod != nil {
		m.StopGracePeriod = &types.Duration{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.StopGracePeriod, o.StopGracePeriod)
	}
	if o.PullOptions != nil {
		m.PullOptions = &ContainerSpec_PullOptions{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.PullOptions, o.PullOptions)
	}
	if o.Secrets != nil {
		m.Secrets = make([]*SecretReference, len(o.Secrets))
		for i := range m.Secrets {
			m.Secrets[i] = &SecretReference{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Secrets[i], o.Secrets[i])
		}
	}

	if o.Configs != nil {
		m.Configs = make([]*ConfigReference, len(o.Configs))
		for i := range m.Configs {
			m.Configs[i] = &ConfigReference{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Configs[i], o.Configs[i])
		}
	}

	if o.Hosts != nil {
		m.Hosts = make([]string, len(o.Hosts))
		copy(m.Hosts, o.Hosts)
	}

	if o.DNSConfig != nil {
		m.DNSConfig = &ContainerSpec_DNSConfig{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.DNSConfig, o.DNSConfig)
	}
	if o.Healthcheck != nil {
		m.Healthcheck = &HealthConfig{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Healthcheck, o.Healthcheck)
	}
	if o.Sysctls != nil {
		m.Sysctls = make(map[string]string, len(o.Sysctls))
		for k, v := range o.Sysctls {
			m.Sysctls[k] = v
		}
	}

	if o.CapabilityAdd != nil {
		m.CapabilityAdd = make([]string, len(o.CapabilityAdd))
		copy(m.CapabilityAdd, o.CapabilityAdd)
	}

	if o.CapabilityDrop != nil {
		m.CapabilityDrop = make([]string, len(o.CapabilityDrop))
		copy(m.CapabilityDrop, o.CapabilityDrop)
	}

	if o.Ulimits != nil {
		m.Ulimits = make([]*ContainerSpec_Ulimit, len(o.Ulimits))
		for i := range m.Ulimits {
			m.Ulimits[i] = &ContainerSpec_Ulimit{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Ulimits[i], o.Ulimits[i])
		}
	}

}

func (m *ContainerSpec_PullOptions) Copy() *ContainerSpec_PullOptions {
	if m == nil {
		return nil
	}
	o := &ContainerSpec_PullOptions{}
	o.CopyFrom(m)
	return o
}

func (m *ContainerSpec_PullOptions) CopyFrom(src interface{}) {

	o := src.(*ContainerSpec_PullOptions)
	*m = *o
}

func (m *ContainerSpec_DNSConfig) Copy() *ContainerSpec_DNSConfig {
	if m == nil {
		return nil
	}
	o := &ContainerSpec_DNSConfig{}
	o.CopyFrom(m)
	return o
}

func (m *ContainerSpec_DNSConfig) CopyFrom(src interface{}) {

	o := src.(*ContainerSpec_DNSConfig)
	*m = *o
	if o.Nameservers != nil {
		m.Nameservers = make([]string, len(o.Nameservers))
		copy(m.Nameservers, o.Nameservers)
	}

	if o.Search != nil {
		m.Search = make([]string, len(o.Search))
		copy(m.Search, o.Search)
	}

	if o.Options != nil {
		m.Options = make([]string, len(o.Options))
		copy(m.Options, o.Options)
	}

}

func (m *ContainerSpec_Ulimit) Copy() *ContainerSpec_Ulimit {
	if m == nil {
		return nil
	}
	o := &ContainerSpec_Ulimit{}
	o.CopyFrom(m)
	return o
}

func (m *ContainerSpec_Ulimit) CopyFrom(src interface{}) {

	o := src.(*ContainerSpec_Ulimit)
	*m = *o
}

func (m *EndpointSpec) Copy() *EndpointSpec {
	if m == nil {
		return nil
	}
	o := &EndpointSpec{}
	o.CopyFrom(m)
	return o
}

func (m *EndpointSpec) CopyFrom(src interface{}) {

	o := src.(*EndpointSpec)
	*m = *o
	if o.Ports != nil {
		m.Ports = make([]*PortConfig, len(o.Ports))
		for i := range m.Ports {
			m.Ports[i] = &PortConfig{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Ports[i], o.Ports[i])
		}
	}

}

func (m *NetworkSpec) Copy() *NetworkSpec {
	if m == nil {
		return nil
	}
	o := &NetworkSpec{}
	o.CopyFrom(m)
	return o
}

func (m *NetworkSpec) CopyFrom(src interface{}) {

	o := src.(*NetworkSpec)
	*m = *o
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Annotations, &o.Annotations)
	if o.DriverConfig != nil {
		m.DriverConfig = &Driver{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.DriverConfig, o.DriverConfig)
	}
	if o.IPAM != nil {
		m.IPAM = &IPAMOptions{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.IPAM, o.IPAM)
	}
	if o.ConfigFrom != nil {
		switch o.ConfigFrom.(type) {
		case *NetworkSpec_Network:
			v := NetworkSpec_Network{
				Network: o.GetNetwork(),
			}
			m.ConfigFrom = &v
		}
	}

}

func (m *ClusterSpec) Copy() *ClusterSpec {
	if m == nil {
		return nil
	}
	o := &ClusterSpec{}
	o.CopyFrom(m)
	return o
}

func (m *ClusterSpec) CopyFrom(src interface{}) {

	o := src.(*ClusterSpec)
	*m = *o
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Annotations, &o.Annotations)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.AcceptancePolicy, &o.AcceptancePolicy)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Orchestration, &o.Orchestration)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Raft, &o.Raft)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Dispatcher, &o.Dispatcher)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.CAConfig, &o.CAConfig)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.TaskDefaults, &o.TaskDefaults)
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.EncryptionConfig, &o.EncryptionConfig)
}

func (m *SecretSpec) Copy() *SecretSpec {
	if m == nil {
		return nil
	}
	o := &SecretSpec{}
	o.CopyFrom(m)
	return o
}

func (m *SecretSpec) CopyFrom(src interface{}) {

	o := src.(*SecretSpec)
	*m = *o
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Annotations, &o.Annotations)
	if o.Data != nil {
		m.Data = make([]byte, len(o.Data))
		copy(m.Data, o.Data)
	}
	if o.Templating != nil {
		m.Templating = &Driver{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Templating, o.Templating)
	}
	if o.Driver != nil {
		m.Driver = &Driver{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Driver, o.Driver)
	}
}

func (m *ConfigSpec) Copy() *ConfigSpec {
	if m == nil {
		return nil
	}
	o := &ConfigSpec{}
	o.CopyFrom(m)
	return o
}

func (m *ConfigSpec) CopyFrom(src interface{}) {

	o := src.(*ConfigSpec)
	*m = *o
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Annotations, &o.Annotations)
	if o.Data != nil {
		m.Data = make([]byte, len(o.Data))
		copy(m.Data, o.Data)
	}
	if o.Templating != nil {
		m.Templating = &Driver{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Templating, o.Templating)
	}
}

func (m *NodeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Annotations.Size()))
	n1, err := m.Annotations.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.DesiredRole != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.DesiredRole))
	}
	if m.Membership != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Membership))
	}
	if m.Availability != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Availability))
	}
	return i, nil
}

func (m *ServiceSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Annotations.Size()))
	n2, err := m.Annotations.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x12
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Task.Size()))
	n3, err := m.Task.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.Mode != nil {
		nn4, err := m.Mode.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	if m.Update != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Update.Size()))
		n5, err := m.Update.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.Networks) > 0 {
		for _, msg := range m.Networks {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Endpoint != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Endpoint.Size()))
		n6, err := m.Endpoint.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Rollback != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Rollback.Size()))
		n7, err := m.Rollback.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *ServiceSpec_Replicated) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Replicated != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Replicated.Size()))
		n8, err := m.Replicated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *ServiceSpec_Global) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Global != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Global.Size()))
		n9, err := m.Global.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *ServiceSpec_ReplicatedJob) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReplicatedJob != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.ReplicatedJob.Size()))
		n10, err := m.ReplicatedJob.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *ServiceSpec_GlobalJob) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.GlobalJob != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.GlobalJob.Size()))
		n11, err := m.GlobalJob.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *ReplicatedService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicatedService) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Replicas != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Replicas))
	}
	return i, nil
}

func (m *GlobalService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GlobalService) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ReplicatedJob) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicatedJob) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MaxConcurrent != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.MaxConcurrent))
	}
	if m.TotalCompletions != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.TotalCompletions))
	}
	return i, nil
}

func (m *GlobalJob) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GlobalJob) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TaskSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Runtime != nil {
		nn12, err := m.Runtime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn12
	}
	if m.Resources != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Resources.Size()))
		n13, err := m.Resources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.Restart != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Restart.Size()))
		n14, err := m.Restart.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Placement != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Placement.Size()))
		n15, err := m.Placement.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.LogDriver != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.LogDriver.Size()))
		n16, err := m.LogDriver.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if len(m.Networks) > 0 {
		for _, msg := range m.Networks {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ForceUpdate != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.ForceUpdate))
	}
	if len(m.ResourceReferences) > 0 {
		for _, msg := range m.ResourceReferences {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TaskSpec_Container) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Container != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Container.Size()))
		n17, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *TaskSpec_Attachment) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Attachment != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Attachment.Size()))
		n18, err := m.Attachment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}
func (m *TaskSpec_Generic) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Generic != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Generic.Size()))
		n19, err := m.Generic.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}
func (m *ResourceReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResourceID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.ResourceID)))
		i += copy(dAtA[i:], m.ResourceID)
	}
	if m.ResourceType != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.ResourceType))
	}
	return i, nil
}

func (m *GenericRuntimeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GenericRuntimeSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if m.Payload != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Payload.Size()))
		n20, err := m.Payload.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	return i, nil
}

func (m *NetworkAttachmentSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkAttachmentSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ContainerID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.ContainerID)))
		i += copy(dAtA[i:], m.ContainerID)
	}
	return i, nil
}

func (m *ContainerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Image) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.Image)))
		i += copy(dAtA[i:], m.Image)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			i = encodeVarintSpecs(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Dir) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.Dir)))
		i += copy(dAtA[i:], m.Dir)
	}
	if len(m.User) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Mounts) > 0 {
		for _, msg := range m.Mounts {
			dAtA[i] = 0x42
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StopGracePeriod != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.StopGracePeriod.Size()))
		n21, err := m.StopGracePeriod.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.PullOptions != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.PullOptions.Size()))
		n22, err := m.PullOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if len(m.Groups) > 0 {
		for _, s := range m.Groups {
			dAtA[i] = 0x5a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Secrets) > 0 {
		for _, msg := range m.Secrets {
			dAtA[i] = 0x62
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.TTY {
		dAtA[i] = 0x68
		i++
		if m.TTY {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Hostname) > 0 {
		dAtA[i] = 0x72
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.Hostname)))
		i += copy(dAtA[i:], m.Hostname)
	}
	if m.DNSConfig != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.DNSConfig.Size()))
		n23, err := m.DNSConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.Healthcheck != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Healthcheck.Size()))
		n24, err := m.Healthcheck.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			dAtA[i] = 0x8a
			i++
			dAtA[i] = 0x1
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.OpenStdin {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		if m.OpenStdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ReadOnly {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		if m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.StopSignal) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.StopSignal)))
		i += copy(dAtA[i:], m.StopSignal)
	}
	if len(m.Configs) > 0 {
		for _, msg := range m.Configs {
			dAtA[i] = 0xaa
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Privileges != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Privileges.Size()))
		n25, err := m.Privileges.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.Init != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Init.Size()))
		n26, err := m.Init.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.Isolation != 0 {
		dAtA[i] = 0xc0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Isolation))
	}
	if m.PidsLimit != 0 {
		dAtA[i] = 0xc8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.PidsLimit))
	}
	if len(m.Sysctls) > 0 {
		for k, _ := range m.Sysctls {
			dAtA[i] = 0xd2
			i++
			dAtA[i] = 0x1
			i++
			v := m.Sysctls[k]
			mapSize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			i = encodeVarintSpecs(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.CapabilityAdd) > 0 {
		for _, s := range m.CapabilityAdd {
			dAtA[i] = 0xda
			i++
			dAtA[i] = 0x1
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.CapabilityDrop) > 0 {
		for _, s := range m.CapabilityDrop {
			dAtA[i] = 0xe2
			i++
			dAtA[i] = 0x1
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Ulimits) > 0 {
		for _, msg := range m.Ulimits {
			dAtA[i] = 0xea
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ContainerSpec_PullOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerSpec_PullOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RegistryAuth) > 0 {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x4
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.RegistryAuth)))
		i += copy(dAtA[i:], m.RegistryAuth)
	}
	return i, nil
}

func (m *ContainerSpec_DNSConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerSpec_DNSConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Nameservers) > 0 {
		for _, s := range m.Nameservers {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Search) > 0 {
		for _, s := range m.Search {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *ContainerSpec_Ulimit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerSpec_Ulimit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Soft != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Soft))
	}
	if m.Hard != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Hard))
	}
	return i, nil
}

func (m *EndpointSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Mode != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Mode))
	}
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSpecs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NetworkSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Annotations.Size()))
	n27, err := m.Annotations.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	if m.DriverConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.DriverConfig.Size()))
		n28, err := m.DriverConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.Ipv6Enabled {
		dAtA[i] = 0x18
		i++
		if m.Ipv6Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Internal {
		dAtA[i] = 0x20
		i++
		if m.Internal {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.IPAM != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.IPAM.Size()))
		n29, err := m.IPAM.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.Attachable {
		dAtA[i] = 0x30
		i++
		if m.Attachable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Ingress {
		dAtA[i] = 0x38
		i++
		if m.Ingress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ConfigFrom != nil {
		nn30, err := m.ConfigFrom.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn30
	}
	return i, nil
}

func (m *NetworkSpec_Network) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x42
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(len(m.Network)))
	i += copy(dAtA[i:], m.Network)
	return i, nil
}
func (m *ClusterSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Annotations.Size()))
	n31, err := m.Annotations.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	dAtA[i] = 0x12
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.AcceptancePolicy.Size()))
	n32, err := m.AcceptancePolicy.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n32
	dAtA[i] = 0x1a
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Orchestration.Size()))
	n33, err := m.Orchestration.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n33
	dAtA[i] = 0x22
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Raft.Size()))
	n34, err := m.Raft.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n34
	dAtA[i] = 0x2a
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Dispatcher.Size()))
	n35, err := m.Dispatcher.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n35
	dAtA[i] = 0x32
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.CAConfig.Size()))
	n36, err := m.CAConfig.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n36
	dAtA[i] = 0x3a
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.TaskDefaults.Size()))
	n37, err := m.TaskDefaults.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n37
	dAtA[i] = 0x42
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.EncryptionConfig.Size()))
	n38, err := m.EncryptionConfig.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n38
	return i, nil
}

func (m *SecretSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Annotations.Size()))
	n39, err := m.Annotations.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n39
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.Templating != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Templating.Size()))
		n40, err := m.Templating.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if m.Driver != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Driver.Size()))
		n41, err := m.Driver.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	return i, nil
}

func (m *ConfigSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintSpecs(dAtA, i, uint64(m.Annotations.Size()))
	n42, err := m.Annotations.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n42
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.Templating != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintSpecs(dAtA, i, uint64(m.Templating.Size()))
		n43, err := m.Templating.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	return i, nil
}

func encodeVarintSpecs(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *NodeSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.DesiredRole != 0 {
		n += 1 + sovSpecs(uint64(m.DesiredRole))
	}
	if m.Membership != 0 {
		n += 1 + sovSpecs(uint64(m.Membership))
	}
	if m.Availability != 0 {
		n += 1 + sovSpecs(uint64(m.Availability))
	}
	return n
}

func (m *ServiceSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Task.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.Mode != nil {
		n += m.Mode.Size()
	}
	if m.Update != nil {
		l = m.Update.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.Endpoint != nil {
		l = m.Endpoint.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Rollback != nil {
		l = m.Rollback.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *ServiceSpec_Replicated) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Replicated != nil {
		l = m.Replicated.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *ServiceSpec_Global) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Global != nil {
		l = m.Global.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *ServiceSpec_ReplicatedJob) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReplicatedJob != nil {
		l = m.ReplicatedJob.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *ServiceSpec_GlobalJob) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GlobalJob != nil {
		l = m.GlobalJob.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *ReplicatedService) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Replicas != 0 {
		n += 1 + sovSpecs(uint64(m.Replicas))
	}
	return n
}

func (m *GlobalService) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ReplicatedJob) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxConcurrent != 0 {
		n += 1 + sovSpecs(uint64(m.MaxConcurrent))
	}
	if m.TotalCompletions != 0 {
		n += 1 + sovSpecs(uint64(m.TotalCompletions))
	}
	return n
}

func (m *GlobalJob) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *TaskSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Runtime != nil {
		n += m.Runtime.Size()
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Restart != nil {
		l = m.Restart.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Placement != nil {
		l = m.Placement.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.LogDriver != nil {
		l = m.LogDriver.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.ForceUpdate != 0 {
		n += 1 + sovSpecs(uint64(m.ForceUpdate))
	}
	if len(m.ResourceReferences) > 0 {
		for _, e := range m.ResourceReferences {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	return n
}

func (m *TaskSpec_Container) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *TaskSpec_Attachment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Attachment != nil {
		l = m.Attachment.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *TaskSpec_Generic) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Generic != nil {
		l = m.Generic.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *ResourceReference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceID)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.ResourceType != 0 {
		n += 1 + sovSpecs(uint64(m.ResourceType))
	}
	return n
}

func (m *GenericRuntimeSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Payload != nil {
		l = m.Payload.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *NetworkAttachmentSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerID)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *ContainerSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Image)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			n += mapEntrySize + 1 + sovSpecs(uint64(mapEntrySize))
		}
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	l = len(m.Dir)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Mounts) > 0 {
		for _, e := range m.Mounts {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.StopGracePeriod != nil {
		l = m.StopGracePeriod.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.PullOptions != nil {
		l = m.PullOptions.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Groups) > 0 {
		for _, s := range m.Groups {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.TTY {
		n += 2
	}
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.DNSConfig != nil {
		l = m.DNSConfig.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Healthcheck != nil {
		l = m.Healthcheck.Size()
		n += 2 + l + sovSpecs(uint64(l))
	}
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			l = len(s)
			n += 2 + l + sovSpecs(uint64(l))
		}
	}
	if m.OpenStdin {
		n += 3
	}
	if m.ReadOnly {
		n += 3
	}
	l = len(m.StopSignal)
	if l > 0 {
		n += 2 + l + sovSpecs(uint64(l))
	}
	if len(m.Configs) > 0 {
		for _, e := range m.Configs {
			l = e.Size()
			n += 2 + l + sovSpecs(uint64(l))
		}
	}
	if m.Privileges != nil {
		l = m.Privileges.Size()
		n += 2 + l + sovSpecs(uint64(l))
	}
	if m.Init != nil {
		l = m.Init.Size()
		n += 2 + l + sovSpecs(uint64(l))
	}
	if m.Isolation != 0 {
		n += 2 + sovSpecs(uint64(m.Isolation))
	}
	if m.PidsLimit != 0 {
		n += 2 + sovSpecs(uint64(m.PidsLimit))
	}
	if len(m.Sysctls) > 0 {
		for k, v := range m.Sysctls {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			n += mapEntrySize + 2 + sovSpecs(uint64(mapEntrySize))
		}
	}
	if len(m.CapabilityAdd) > 0 {
		for _, s := range m.CapabilityAdd {
			l = len(s)
			n += 2 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.CapabilityDrop) > 0 {
		for _, s := range m.CapabilityDrop {
			l = len(s)
			n += 2 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Ulimits) > 0 {
		for _, e := range m.Ulimits {
			l = e.Size()
			n += 2 + l + sovSpecs(uint64(l))
		}
	}
	return n
}

func (m *ContainerSpec_PullOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RegistryAuth)
	if l > 0 {
		n += 2 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *ContainerSpec_DNSConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Nameservers) > 0 {
		for _, s := range m.Nameservers {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Search) > 0 {
		for _, s := range m.Search {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	return n
}

func (m *ContainerSpec_Ulimit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Soft != 0 {
		n += 1 + sovSpecs(uint64(m.Soft))
	}
	if m.Hard != 0 {
		n += 1 + sovSpecs(uint64(m.Hard))
	}
	return n
}

func (m *EndpointSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovSpecs(uint64(m.Mode))
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	return n
}

func (m *NetworkSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.DriverConfig != nil {
		l = m.DriverConfig.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Ipv6Enabled {
		n += 2
	}
	if m.Internal {
		n += 2
	}
	if m.IPAM != nil {
		l = m.IPAM.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Attachable {
		n += 2
	}
	if m.Ingress {
		n += 2
	}
	if m.ConfigFrom != nil {
		n += m.ConfigFrom.Size()
	}
	return n
}

func (m *NetworkSpec_Network) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Network)
	n += 1 + l + sovSpecs(uint64(l))
	return n
}
func (m *ClusterSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.AcceptancePolicy.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Orchestration.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Raft.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Dispatcher.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.CAConfig.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.TaskDefaults.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.EncryptionConfig.Size()
	n += 1 + l + sovSpecs(uint64(l))
	return n
}

func (m *SecretSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Templating != nil {
		l = m.Templating.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Driver != nil {
		l = m.Driver.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *ConfigSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Templating != nil {
		l = m.Templating.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func sovSpecs(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozSpecs(x uint64) (n int) {
	return sovSpecs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NodeSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`DesiredRole:` + fmt.Sprintf("%v", this.DesiredRole) + `,`,
		`Membership:` + fmt.Sprintf("%v", this.Membership) + `,`,
		`Availability:` + fmt.Sprintf("%v", this.Availability) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Task:` + strings.Replace(strings.Replace(this.Task.String(), "TaskSpec", "TaskSpec", 1), `&`, ``, 1) + `,`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`Update:` + strings.Replace(fmt.Sprintf("%v", this.Update), "UpdateConfig", "UpdateConfig", 1) + `,`,
		`Networks:` + strings.Replace(fmt.Sprintf("%v", this.Networks), "NetworkAttachmentConfig", "NetworkAttachmentConfig", 1) + `,`,
		`Endpoint:` + strings.Replace(fmt.Sprintf("%v", this.Endpoint), "EndpointSpec", "EndpointSpec", 1) + `,`,
		`Rollback:` + strings.Replace(fmt.Sprintf("%v", this.Rollback), "UpdateConfig", "UpdateConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec_Replicated) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec_Replicated{`,
		`Replicated:` + strings.Replace(fmt.Sprintf("%v", this.Replicated), "ReplicatedService", "ReplicatedService", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec_Global) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec_Global{`,
		`Global:` + strings.Replace(fmt.Sprintf("%v", this.Global), "GlobalService", "GlobalService", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec_ReplicatedJob) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec_ReplicatedJob{`,
		`ReplicatedJob:` + strings.Replace(fmt.Sprintf("%v", this.ReplicatedJob), "ReplicatedJob", "ReplicatedJob", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec_GlobalJob) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec_GlobalJob{`,
		`GlobalJob:` + strings.Replace(fmt.Sprintf("%v", this.GlobalJob), "GlobalJob", "GlobalJob", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicatedService) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicatedService{`,
		`Replicas:` + fmt.Sprintf("%v", this.Replicas) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GlobalService) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GlobalService{`,
		`}`,
	}, "")
	return s
}
func (this *ReplicatedJob) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicatedJob{`,
		`MaxConcurrent:` + fmt.Sprintf("%v", this.MaxConcurrent) + `,`,
		`TotalCompletions:` + fmt.Sprintf("%v", this.TotalCompletions) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GlobalJob) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GlobalJob{`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec{`,
		`Runtime:` + fmt.Sprintf("%v", this.Runtime) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "ResourceRequirements", "ResourceRequirements", 1) + `,`,
		`Restart:` + strings.Replace(fmt.Sprintf("%v", this.Restart), "RestartPolicy", "RestartPolicy", 1) + `,`,
		`Placement:` + strings.Replace(fmt.Sprintf("%v", this.Placement), "Placement", "Placement", 1) + `,`,
		`LogDriver:` + strings.Replace(fmt.Sprintf("%v", this.LogDriver), "Driver", "Driver", 1) + `,`,
		`Networks:` + strings.Replace(fmt.Sprintf("%v", this.Networks), "NetworkAttachmentConfig", "NetworkAttachmentConfig", 1) + `,`,
		`ForceUpdate:` + fmt.Sprintf("%v", this.ForceUpdate) + `,`,
		`ResourceReferences:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ResourceReferences), "ResourceReference", "ResourceReference", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec_Container) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec_Container{`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerSpec", "ContainerSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec_Attachment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec_Attachment{`,
		`Attachment:` + strings.Replace(fmt.Sprintf("%v", this.Attachment), "NetworkAttachmentSpec", "NetworkAttachmentSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec_Generic) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec_Generic{`,
		`Generic:` + strings.Replace(fmt.Sprintf("%v", this.Generic), "GenericRuntimeSpec", "GenericRuntimeSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceReference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceReference{`,
		`ResourceID:` + fmt.Sprintf("%v", this.ResourceID) + `,`,
		`ResourceType:` + fmt.Sprintf("%v", this.ResourceType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GenericRuntimeSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GenericRuntimeSpec{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Payload:` + strings.Replace(fmt.Sprintf("%v", this.Payload), "Any", "types.Any", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkAttachmentSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkAttachmentSpec{`,
		`ContainerID:` + fmt.Sprintf("%v", this.ContainerID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerSpec) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForSysctls := make([]string, 0, len(this.Sysctls))
	for k, _ := range this.Sysctls {
		keysForSysctls = append(keysForSysctls, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSysctls)
	mapStringForSysctls := "map[string]string{"
	for _, k := range keysForSysctls {
		mapStringForSysctls += fmt.Sprintf("%v: %v,", k, this.Sysctls[k])
	}
	mapStringForSysctls += "}"
	s := strings.Join([]string{`&ContainerSpec{`,
		`Image:` + fmt.Sprintf("%v", this.Image) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Command:` + fmt.Sprintf("%v", this.Command) + `,`,
		`Args:` + fmt.Sprintf("%v", this.Args) + `,`,
		`Env:` + fmt.Sprintf("%v", this.Env) + `,`,
		`Dir:` + fmt.Sprintf("%v", this.Dir) + `,`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`Mounts:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Mounts), "Mount", "Mount", 1), `&`, ``, 1) + `,`,
		`StopGracePeriod:` + strings.Replace(fmt.Sprintf("%v", this.StopGracePeriod), "Duration", "types.Duration", 1) + `,`,
		`PullOptions:` + strings.Replace(fmt.Sprintf("%v", this.PullOptions), "ContainerSpec_PullOptions", "ContainerSpec_PullOptions", 1) + `,`,
		`Groups:` + fmt.Sprintf("%v", this.Groups) + `,`,
		`Secrets:` + strings.Replace(fmt.Sprintf("%v", this.Secrets), "SecretReference", "SecretReference", 1) + `,`,
		`TTY:` + fmt.Sprintf("%v", this.TTY) + `,`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`DNSConfig:` + strings.Replace(fmt.Sprintf("%v", this.DNSConfig), "ContainerSpec_DNSConfig", "ContainerSpec_DNSConfig", 1) + `,`,
		`Healthcheck:` + strings.Replace(fmt.Sprintf("%v", this.Healthcheck), "HealthConfig", "HealthConfig", 1) + `,`,
		`Hosts:` + fmt.Sprintf("%v", this.Hosts) + `,`,
		`OpenStdin:` + fmt.Sprintf("%v", this.OpenStdin) + `,`,
		`ReadOnly:` + fmt.Sprintf("%v", this.ReadOnly) + `,`,
		`StopSignal:` + fmt.Sprintf("%v", this.StopSignal) + `,`,
		`Configs:` + strings.Replace(fmt.Sprintf("%v", this.Configs), "ConfigReference", "ConfigReference", 1) + `,`,
		`Privileges:` + strings.Replace(fmt.Sprintf("%v", this.Privileges), "Privileges", "Privileges", 1) + `,`,
		`Init:` + strings.Replace(fmt.Sprintf("%v", this.Init), "BoolValue", "types.BoolValue", 1) + `,`,
		`Isolation:` + fmt.Sprintf("%v", this.Isolation) + `,`,
		`PidsLimit:` + fmt.Sprintf("%v", this.PidsLimit) + `,`,
		`Sysctls:` + mapStringForSysctls + `,`,
		`CapabilityAdd:` + fmt.Sprintf("%v", this.CapabilityAdd) + `,`,
		`CapabilityDrop:` + fmt.Sprintf("%v", this.CapabilityDrop) + `,`,
		`Ulimits:` + strings.Replace(fmt.Sprintf("%v", this.Ulimits), "ContainerSpec_Ulimit", "ContainerSpec_Ulimit", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerSpec_PullOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerSpec_PullOptions{`,
		`RegistryAuth:` + fmt.Sprintf("%v", this.RegistryAuth) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerSpec_DNSConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerSpec_DNSConfig{`,
		`Nameservers:` + fmt.Sprintf("%v", this.Nameservers) + `,`,
		`Search:` + fmt.Sprintf("%v", this.Search) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerSpec_Ulimit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerSpec_Ulimit{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Soft:` + fmt.Sprintf("%v", this.Soft) + `,`,
		`Hard:` + fmt.Sprintf("%v", this.Hard) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EndpointSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EndpointSpec{`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`Ports:` + strings.Replace(fmt.Sprintf("%v", this.Ports), "PortConfig", "PortConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`DriverConfig:` + strings.Replace(fmt.Sprintf("%v", this.DriverConfig), "Driver", "Driver", 1) + `,`,
		`Ipv6Enabled:` + fmt.Sprintf("%v", this.Ipv6Enabled) + `,`,
		`Internal:` + fmt.Sprintf("%v", this.Internal) + `,`,
		`IPAM:` + strings.Replace(fmt.Sprintf("%v", this.IPAM), "IPAMOptions", "IPAMOptions", 1) + `,`,
		`Attachable:` + fmt.Sprintf("%v", this.Attachable) + `,`,
		`Ingress:` + fmt.Sprintf("%v", this.Ingress) + `,`,
		`ConfigFrom:` + fmt.Sprintf("%v", this.ConfigFrom) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkSpec_Network) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkSpec_Network{`,
		`Network:` + fmt.Sprintf("%v", this.Network) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClusterSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClusterSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`AcceptancePolicy:` + strings.Replace(strings.Replace(this.AcceptancePolicy.String(), "AcceptancePolicy", "AcceptancePolicy", 1), `&`, ``, 1) + `,`,
		`Orchestration:` + strings.Replace(strings.Replace(this.Orchestration.String(), "OrchestrationConfig", "OrchestrationConfig", 1), `&`, ``, 1) + `,`,
		`Raft:` + strings.Replace(strings.Replace(this.Raft.String(), "RaftConfig", "RaftConfig", 1), `&`, ``, 1) + `,`,
		`Dispatcher:` + strings.Replace(strings.Replace(this.Dispatcher.String(), "DispatcherConfig", "DispatcherConfig", 1), `&`, ``, 1) + `,`,
		`CAConfig:` + strings.Replace(strings.Replace(this.CAConfig.String(), "CAConfig", "CAConfig", 1), `&`, ``, 1) + `,`,
		`TaskDefaults:` + strings.Replace(strings.Replace(this.TaskDefaults.String(), "TaskDefaults", "TaskDefaults", 1), `&`, ``, 1) + `,`,
		`EncryptionConfig:` + strings.Replace(strings.Replace(this.EncryptionConfig.String(), "EncryptionConfig", "EncryptionConfig", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SecretSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SecretSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Templating:` + strings.Replace(fmt.Sprintf("%v", this.Templating), "Driver", "Driver", 1) + `,`,
		`Driver:` + strings.Replace(fmt.Sprintf("%v", this.Driver), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ConfigSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Templating:` + strings.Replace(fmt.Sprintf("%v", this.Templating), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringSpecs(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NodeSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DesiredRole", wireType)
			}
			m.DesiredRole = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DesiredRole |= NodeRole(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Membership", wireType)
			}
			m.Membership = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Membership |= NodeSpec_Membership(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Availability", wireType)
			}
			m.Availability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Availability |= NodeSpec_Availability(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Task.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReplicatedService{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Mode = &ServiceSpec_Replicated{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Global", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GlobalService{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Mode = &ServiceSpec_Global{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Update", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Update == nil {
				m.Update = &UpdateConfig{}
			}
			if err := m.Update.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &NetworkAttachmentConfig{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Endpoint == nil {
				m.Endpoint = &EndpointSpec{}
			}
			if err := m.Endpoint.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rollback", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Rollback == nil {
				m.Rollback = &UpdateConfig{}
			}
			if err := m.Rollback.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicatedJob", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReplicatedJob{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Mode = &ServiceSpec_ReplicatedJob{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalJob", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GlobalJob{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Mode = &ServiceSpec_GlobalJob{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicatedService) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicatedService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicatedService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			m.Replicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Replicas |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GlobalService) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GlobalService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GlobalService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicatedJob) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicatedJob: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicatedJob: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxConcurrent", wireType)
			}
			m.MaxConcurrent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxConcurrent |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalCompletions", wireType)
			}
			m.TotalCompletions = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalCompletions |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GlobalJob) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GlobalJob: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GlobalJob: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ContainerSpec{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Runtime = &TaskSpec_Container{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &ResourceRequirements{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Restart == nil {
				m.Restart = &RestartPolicy{}
			}
			if err := m.Restart.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Placement", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Placement == nil {
				m.Placement = &Placement{}
			}
			if err := m.Placement.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogDriver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LogDriver == nil {
				m.LogDriver = &Driver{}
			}
			if err := m.LogDriver.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &NetworkAttachmentConfig{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attachment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkAttachmentSpec{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Runtime = &TaskSpec_Attachment{v}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForceUpdate", wireType)
			}
			m.ForceUpdate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForceUpdate |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Generic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GenericRuntimeSpec{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Runtime = &TaskSpec_Generic{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceReferences", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceReferences = append(m.ResourceReferences, ResourceReference{})
			if err := m.ResourceReferences[len(m.ResourceReferences)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceType", wireType)
			}
			m.ResourceType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResourceType |= ResourceType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GenericRuntimeSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenericRuntimeSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenericRuntimeSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Payload == nil {
				m.Payload = &types.Any{}
			}
			if err := m.Payload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkAttachmentSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkAttachmentSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkAttachmentSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Image = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSpecs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSpecs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSpecs
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSpecs
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSpecs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthSpecs
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthSpecs
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSpecs(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthSpecs
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mounts = append(m.Mounts, Mount{})
			if err := m.Mounts[len(m.Mounts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopGracePeriod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StopGracePeriod == nil {
				m.StopGracePeriod = &types.Duration{}
			}
			if err := m.StopGracePeriod.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PullOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PullOptions == nil {
				m.PullOptions = &ContainerSpec_PullOptions{}
			}
			if err := m.PullOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, &SecretReference{})
			if err := m.Secrets[len(m.Secrets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTY", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TTY = bool(v != 0)
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DNSConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DNSConfig == nil {
				m.DNSConfig = &ContainerSpec_DNSConfig{}
			}
			if err := m.DNSConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Healthcheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Healthcheck == nil {
				m.Healthcheck = &HealthConfig{}
			}
			if err := m.Healthcheck.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenStdin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OpenStdin = bool(v != 0)
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReadOnly = bool(v != 0)
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopSignal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StopSignal = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Configs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Configs = append(m.Configs, &ConfigReference{})
			if err := m.Configs[len(m.Configs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Privileges == nil {
				m.Privileges = &Privileges{}
			}
			if err := m.Privileges.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Init", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Init == nil {
				m.Init = &types.BoolValue{}
			}
			if err := m.Init.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Isolation", wireType)
			}
			m.Isolation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Isolation |= ContainerSpec_Isolation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PidsLimit", wireType)
			}
			m.PidsLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PidsLimit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sysctls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sysctls == nil {
				m.Sysctls = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSpecs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSpecs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSpecs
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSpecs
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSpecs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthSpecs
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthSpecs
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSpecs(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthSpecs
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Sysctls[mapkey] = mapvalue
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CapabilityAdd", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CapabilityAdd = append(m.CapabilityAdd, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CapabilityDrop", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CapabilityDrop = append(m.CapabilityDrop, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ulimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ulimits = append(m.Ulimits, &ContainerSpec_Ulimit{})
			if err := m.Ulimits[len(m.Ulimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerSpec_PullOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PullOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PullOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 64:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegistryAuth", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegistryAuth = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerSpec_DNSConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nameservers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nameservers = append(m.Nameservers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Search", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Search = append(m.Search, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerSpec_Ulimit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ulimit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ulimit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Soft", wireType)
			}
			m.Soft = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Soft |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hard", wireType)
			}
			m.Hard = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Hard |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= EndpointSpec_ResolutionMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &PortConfig{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverConfig == nil {
				m.DriverConfig = &Driver{}
			}
			if err := m.DriverConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv6Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ipv6Enabled = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Internal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Internal = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IPAM", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IPAM == nil {
				m.IPAM = &IPAMOptions{}
			}
			if err := m.IPAM.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attachable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Attachable = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ingress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ingress = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigFrom = &NetworkSpec_Network{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptancePolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AcceptancePolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Orchestration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Orchestration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Raft", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Raft.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dispatcher", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dispatcher.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CAConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.CAConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskDefaults", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskDefaults.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EncryptionConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Templating", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Templating == nil {
				m.Templating = &Driver{}
			}
			if err := m.Templating.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Driver == nil {
				m.Driver = &Driver{}
			}
			if err := m.Driver.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Templating", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSpecs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Templating == nil {
				m.Templating = &Driver{}
			}
			if err := m.Templating.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSpecs(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSpecs
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthSpecs
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSpecs
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSpecs(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthSpecs
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSpecs = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSpecs   = fmt.Errorf("proto: integer overflow")
)
